/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import java.util.Optional;
import kafka.admin.BrokerMetadata;
import kafka.cluster.Observer$;
import kafka.cluster.RequiredReplicaCountsAndEligibleBrokers;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.metadata.TopicPlacement;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tEc\u0001\u0002%J\u00019CQ!\u0016\u0001\u0005\u0002YCq!\u0017\u0001C\u0002\u0013%!\f\u0003\u0004j\u0001\u0001\u0006Ia\u0017\u0005\bU\u0002\u0011\r\u0011\"\u0003[\u0011\u0019Y\u0007\u0001)A\u00057\"9A\u000e\u0001b\u0001\n\u0013i\u0007B\u0002<\u0001A\u0003%a\u000eC\u0004x\u0001\t\u0007I\u0011B7\t\ra\u0004\u0001\u0015!\u0003o\u0011\u001dI\bA1A\u0005\niCaA\u001f\u0001!\u0002\u0013Y\u0006bB>\u0001\u0005\u0004%I\u0001 \u0005\b\u0003G\u0001\u0001\u0015!\u0003~\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!!\u0012\u0001\t\u0003\t9\u0003C\u0004\u0002J\u0001!\t!a\n\t\u000f\u00055\u0003\u0001\"\u0001\u0002(!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005\u001d\u0002bBA+\u0001\u0011\u0005\u0011q\u0005\u0005\b\u00033\u0002A\u0011AA\u0014\u0011\u001d\ti\u0006\u0001C\u0001\u0003OAq!!\u0019\u0001\t\u0003\t9\u0003C\u0004\u0002f\u0001!\t!a\n\t\u000f\u0005%\u0004\u0001\"\u0001\u0002(!9\u0011Q\u000e\u0001\u0005\u0002\u0005\u001d\u0002bBA9\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003k\u0002A\u0011AA\u0014\u0011\u001d\tI\b\u0001C\u0001\u0003OAq!! \u0001\t\u0003\t9\u0003C\u0004\u0002\u0002\u0002!\t!a\n\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002(!9\u0011\u0011\u0012\u0001\u0005\u0002\u0005\u001d\u0002bBAG\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003#\u0003A\u0011AA\u0014\u0011\u001d\t)\n\u0001C\u0001\u0003OA\u0001\"!'\u0001A\u0013%\u00111\u0014\u0005\b\u0003\u000b\u0004A\u0011AA\u0014\u0011\u001d\tI\r\u0001C\u0001\u0003OAq!!4\u0001\t\u0003\t9\u0003C\u0004\u0002R\u0002!\t!a\n\t\u000f\u0005U\u0007\u0001\"\u0001\u0002(!9\u0011\u0011\u001c\u0001\u0005\u0002\u0005\u001d\u0002bBAo\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003C\u0004A\u0011AA\u0014\u0011\u001d\t)\u000f\u0001C\u0001\u0003OAq!!;\u0001\t\u0003\t9\u0003C\u0004\u0002n\u0002!\t!a\n\t\u000f\u0005E\b\u0001\"\u0001\u0002(!9\u0011Q\u001f\u0001\u0005\u0002\u0005\u001d\u0002bBA}\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003{\u0004A\u0011AA\u0014\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0003OAqA!\u0002\u0001\t\u0003\t9\u0003C\u0004\u0003\n\u0001!\t!a\n\t\u000f\t5\u0001\u0001\"\u0001\u0002(!9!\u0011\u0003\u0001\u0005\u0002\u0005\u001d\u0002b\u0002B\u000b\u0001\u0011\u0005\u0011q\u0005\u0005\b\u00053\u0001A\u0011AA\u0014\u0011\u001d\u0011i\u0002\u0001C\u0001\u0003OAqA!\t\u0001\t\u0003\t9\u0003C\u0004\u0003&\u0001!\t!a\n\t\u000f\t%\u0002\u0001\"\u0001\u0002(!9!Q\u0006\u0001\u0005\u0002\u0005\u001d\u0002b\u0002B\u0019\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0005k\u0001A\u0011AA\u0014\u0011\u001d\u0011I\u0004\u0001C\u0001\u0003OAqA!\u0010\u0001\t\u0003\t9\u0003C\u0004\u0003B\u0001!\t!a\n\t\u000f\t\u0015\u0003\u0001\"\u0001\u0002(!9!\u0011\n\u0001\u0005\u0002\u0005\u001d\u0002b\u0002B'\u0001\u0011\u0005\u0011q\u0005\u0002\r\u001f\n\u001cXM\u001d<feR+7\u000f\u001e\u0006\u0003\u0015.\u000bqa\u00197vgR,'OC\u0001M\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A(\u0011\u0005A\u001bV\"A)\u000b\u0003I\u000bQa]2bY\u0006L!\u0001V)\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\u000b\u0005\u0002Y\u00015\t\u0011*\u0001\u0013u_BL7mV5uQ>\u00137/\u001a:wKJ\u0004F.Y2f[\u0016tGoQ8ogR\u0014\u0018-\u001b8u+\u0005Y\u0006c\u0001)]=&\u0011Q,\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005};W\"\u00011\u000b\u0005\u0005\u0014\u0017\u0001C7fi\u0006$\u0017\r^1\u000b\u00051\u001b'B\u00013f\u0003\u0019\t\u0007/Y2iK*\ta-A\u0002pe\u001eL!\u0001\u001b1\u0003\u001dQ{\u0007/[2QY\u0006\u001cW-\\3oi\u0006)Co\u001c9jG^KG\u000f[(cg\u0016\u0014h/\u001a:QY\u0006\u001cW-\\3oi\u000e{gn\u001d;sC&tG\u000fI\u0001<i>\u0004\u0018nY,ji\"|%m]3sm\u0016\u0014\b\u000b\\1dK6,g\u000e^(o'\u0006lWMU1dW\u0006\u001b8+\u001f8d%\u0016\u0004H.[2b\u0007>t7\u000f\u001e:bS:$\u0018\u0001\u0010;pa&\u001cw+\u001b;i\u001f\n\u001cXM\u001d<feBc\u0017mY3nK:$xJ\\*b[\u0016\u0014\u0016mY6BgNKhn\u0019*fa2L7-Y\"p]N$(/Y5oi\u0002\nq\u0005^8qS\u000e<\u0016\u000e\u001e5Uo>|%m]3sm\u0016\u0014\b\u000b\\1dK6,g\u000e^\"p]N$(/Y5oiV\ta\u000eE\u0002pizk\u0011\u0001\u001d\u0006\u0003cJ\fA!\u001e;jY*\t1/\u0001\u0003kCZ\f\u0017BA;q\u0005!y\u0005\u000f^5p]\u0006d\u0017\u0001\u000b;pa&\u001cw+\u001b;i)^|wJY:feZ,'\u000f\u00157bG\u0016lWM\u001c;D_:\u001cHO]1j]R\u0004\u0013\u0001\u000e;pa&\u001cw+\u001b;i)^|wJY:feZ,'/\u00118e%\u0006\u001c7.T5yS:<\u0007\u000b\\1dK6,g\u000e^\"p]N$(/Y5oi\u0006)Do\u001c9jG^KG\u000f\u001b+x_>\u00137/\u001a:wKJ\fe\u000e\u001a*bG.l\u0015\u000e_5oOBc\u0017mY3nK:$8i\u001c8tiJ\f\u0017N\u001c;!\u0003}!x\u000e]5d/&$\bn\\;u\u001f\n\u001cXM\u001d<feN\u001cuN\\:ue\u0006Lg\u000e^\u0001!i>\u0004\u0018nY,ji\"|W\u000f^(cg\u0016\u0014h/\u001a:t\u0007>t7\u000f\u001e:bS:$\b%\u0001\u000bbY2\u0014%o\\6feN\fE\u000f\u001e:jEV$Xm]\u000b\u0002{B9a0a\u0002\u0002\f\u0005EQ\"A@\u000b\t\u0005\u0005\u00111A\u0001\nS6lW\u000f^1cY\u0016T1!!\u0002R\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004\u0003\u0013y(aA'baB\u0019\u0001+!\u0004\n\u0007\u0005=\u0011KA\u0002J]R\u0004\u0002\"a\u0005\u0002\u0016\u0005]\u0011qC\u0007\u0003\u0003\u0007IA!!\u0003\u0002\u0004A!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001eI\fA\u0001\\1oO&!\u0011\u0011EA\u000e\u0005\u0019\u0019FO]5oO\u0006)\u0012\r\u001c7Ce>\\WM]:BiR\u0014\u0018NY;uKN\u0004\u0013a\n;fgR\u0004F.Y2f[\u0016tGoQ8ogR\u0014\u0018-\u001b8u!J,G-[2bi\u0016\u001cVoY2fgN$\"!!\u000b\u0011\u0007A\u000bY#C\u0002\u0002.E\u0013A!\u00168ji\"\u001aa\"!\r\u0011\t\u0005M\u0012\u0011I\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005\u0019\u0011\r]5\u000b\t\u0005m\u0012QH\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\ty$Z\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u0007\n)D\u0001\u0003UKN$\u0018a\r;fgR\u0004F.Y2f[\u0016tGoQ8ogR\u0014\u0018-\u001b8u/&$\bNU1dWRK\b/\u001a)sK\u0012L7-\u0019;f'V\u001c7-Z:tQ\ry\u0011\u0011G\u0001(i\u0016\u001cH\u000f\u00157bG\u0016lWM\u001c;D_:\u001cHO]1j]R\u0004&/\u001a3jG\u0006$XMR1jYV\u0014X\rK\u0002\u0011\u0003c\t1\u0007^3tiBc\u0017mY3nK:$8i\u001c8tiJ\f\u0017N\u001c;XSRD'+Y2l)f\u0004X\r\u0015:fI&\u001c\u0017\r^3GC&dWO]3)\u0007E\t\t$A\u0017uKN$\b\u000b\\1dK6,g\u000e^\"p]N$(/Y5oiB\u0013X\rZ5dCR,gj\\\"p]N$(/Y5oiND3AEA\u0019\u0003e\"Xm\u001d;QY\u0006\u001cW-\\3oi\u000e{gn\u001d;sC&tG\u000f\u0015:fI&\u001c\u0017\r^3XSRD'+Y2l)f\u0004XMT8D_:\u001cHO]1j]R\u001c\bfA\n\u00022\u0005aC/Z:u!2\f7-Z7f]R\u001cuN\\:ue\u0006Lg\u000e\u001e)sK\u0012L7-\u0019;f\u001d>\u0014%o\\6feJ\u000b7m\u001b\u0015\u0004)\u0005E\u0012\u0001\u000f;fgR\u0004F.Y2f[\u0016tGoQ8ogR\u0014\u0018-\u001b8u!J,G-[2bi\u0016<\u0016\u000e\u001e5SC\u000e\\G+\u001f9f\u001d>\u0014%o\\6feJ\u000b7m\u001b\u0015\u0004+\u0005E\u0012!\u0006;fgRlUM]4f\t&\u001c(n\\5oi6\u000b\u0007o\u001d\u0015\u0004-\u0005E\u0012!\u0005;fgRlUM]4f\u000b6\u0004H/_'ba\"\u001aq#!\r\u0002+Q,7\u000f^'fe\u001e,W*\u00199WC2,XmU1nK\"\u001a\u0001$!\r\u0002'Q,7\u000f^'fe\u001e,W*\u00199LKf\u001c\u0016-\\3)\u0007e\t\t$\u0001\u000euKN$X*\u001a:hK\u0012K7O[8j]R\u001cV-];f]\u000e,7\u000fK\u0002\u001b\u0003c\tq\u0003^3ti6+'oZ3F[B$\u0018pU3rk\u0016t7-Z:)\u0007m\t\t$A\rnKJ<WMT8o\t&\u001c(n\\5oiN+\u0017/^3oG\u0016\u001c\bf\u0001\u000f\u00022\u0005\u0001C/Z:u!\u0006\u0014H/\u001b;j_:\u0014%o\\6feN\u0014\u0015pQ8ogR\u0014\u0018-\u001b8uQ\ri\u0012\u0011G\u00016i\u0016\u001cH\u000fU1si&$\u0018n\u001c8Ce>\\WM]:Cs\u000e{gn\u001d;sC&tGoV5uQJ\u000b7m['jq&twmU;qa>\u0014H\u000fK\u0002\u001f\u0003c\t!\u000b^3tiB\u000b'\u000f^5uS>t'I]8lKJ\u001cx+\u001b;i\u001fZ,'\u000f\\1qa\u0016$'+Y2l\u0007>t7\u000f\u001e:bS:$8OQ=D_:\u001cHO]1j]R<\u0016\u000e\u001e5SC\u000e\\W*\u001b=j]\u001e\u001cV\u000f\u001d9peRD3aHA\u0019\u00031\"Xm\u001d;QCJ$\u0018\u000e^5p]\n\u0013xn[3sg\nK8i\u001c8tiJ\f\u0017N\u001c;J]Z\fG.\u001b3D_VtG\u000fK\u0002!\u0003c\tQ\t^3ti\n+\u0018\u000e\u001c3SKF,\u0018N]3e%\u0016\u0004H.[2b\u0007>,h\u000e^:B]\u0012,E.[4jE2,'I]8lKJ\u001cx+\u001b;i%\u0006\u001c7.T5yS:<7+\u001e9q_J$\bfA\u0011\u00022\u0005aC/Z:u%\u0006\u001c7.\u00168bo\u0006\u0014XMT8D_:\u001cHO]1j]R\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u0015\u0004E\u0005E\u0012A\u0010;fgR\u0014\u0016mY6V]\u0006<\u0018M]3SKBd\u0017nY1BgNLwM\\7f]R<\u0016\u000e\u001e5QY\u0006\u001cW-\\3oi\u000e{gn\u001d;sC&tG/T5tg&tw\rK\u0002$\u0003c\tAE^1mS\u0012\fG/\u001a*bG.,f.Y<be\u0016\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u000b\u0007\u0003S\ti*a-\t\u000f\u0005}E\u00051\u0001\u0002\"\u00069!M]8lKJ\u001c\b#\u0002@\u0002$\u0006\u001d\u0016bAAS\u007f\nQ\u0011J\u001c3fq\u0016$7+Z9\u0011\t\u0005%\u0016qV\u0007\u0003\u0003WS1!!,L\u0003\u0015\tG-\\5o\u0013\u0011\t\t,a+\u0003\u001d\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uC\"9\u0011Q\u0017\u0013A\u0002\u0005]\u0016aC1tg&<g.\\3oiN\u0004\u0002\"a\u0005\u0002\u0016\u0005-\u0011\u0011\u0018\t\u0005\u0003w\u000b\t-\u0004\u0002\u0002>*\u0019\u0011qX&\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0003\u0002D\u0006u&!\u0005*fa2L7-Y!tg&<g.\\3oi\u0006QC/Z:u%\u0006\u001c7.Q<be\u0016tunQ8ogR\u0014\u0018-\u001b8u%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bfA\u0013\u00022\u0005qC/Z:u\u000f\u0016$(+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;IC:$G.Z:NKR\fG-\u0019;b-\u0016\u00148/[8oQ\r1\u0013\u0011G\u0001;i\u0016\u001cHOU1dW\u0006;\u0018M]3XSRD7i\u001c8tiJ\f\u0017N\u001c;SKBd\u0017nY1BgNLwM\\7f]R<\u0016\u000e\u001e5SC\u000e\\W*\u001b=j]\u001eD3aJA\u0019\u00031\"Xm\u001d;SC\u000e\\\u0017i^1sK^KG\u000f[\"p]N$(/Y5oiJ+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000fK\u0002)\u0003c\t!\b^3tiJ\u000b7m[!xCJ,w+\u001b;i\u0007>t7\u000f\u001e:bS:$(+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;XSRD7\u000b^1si&sG-\u001a=)\u0007%\n\t$A\u000ewC2LG-\u0019;f!\u0006\u0014H/\u001b;j_:LgnZ*vG\u000e,7o\u001d\u0015\u0004U\u0005E\u0012a\u0007<bY&$\u0017\r^3QCJ$\u0018\u000e^5p]&twMR1jYV\u0014X\rK\u0002,\u0003c\t!I^1mS\u0012\fG/\u001a)beRLG/[8oS:<g)Y5mkJ,W*\u001e7uSBdW\rU1si&$\u0018n\u001c8t/&$\bNU1dW6K\u00070\u001b8h'V\u0004\bo\u001c:uQ\ra\u0013\u0011G\u0001*i\u0016\u001cHOV1mS\u0012\fG/\u001a*fa2L7-Y:O_Bc\u0017mY3nK:$8i\u001c8tiJ\f\u0017N\u001c;)\u00075\n\t$A\u0010uKN$h+\u00197jI\u0006$Xm\u00142tKJ4XM]:D_:\u001cHO]1j]RD3ALA\u0019\u0003\u0015#Xm\u001d;WC2LG-\u0019;f\u001f\n\u001cXM\u001d<feN\u001cuN\\:ue\u0006Lg\u000e^,ji\"\u001c\u0016P\\2SKBd\u0017nY1t\u0003:$wJY:feZ,'o](o'\u0006lWMU1dW\"\u001aq&!\r\u0002KQ,7\u000f\u001e,bY&$\u0017\r^3SKBd\u0017nY1t\u001b\u0006$8\r[3t\u0007>t7\u000f\u001e:bS:$\bf\u0001\u0019\u00022\u00059C/Z:u-\u0006d\u0017\u000eZ1uKJ+\u0007\u000f\\5dCN|e/\u001a:D_:\u001cHO]1j]R\u001cu.\u001e8uQ\r\t\u0014\u0011G\u0001)i\u0016\u001cHOV1mS\u0012\fG/\u001a*fa2L7-Y:V]\u0012,'oQ8ogR\u0014\u0018-\u001b8u\u0007>,h\u000e\u001e\u0015\u0004e\u0005E\u0012\u0001\r;fgR\u0014V\r\u001d7jG\u0006Le\u000eZ5wS\u0012,\u0018\r\\\"p]N$(/Y5oi\u000e{WO\u001c;O_R\u001c\u0016\r^5tM&,G\rK\u00024\u0003c\tQ\u0004^3ti>\u00137/\u001a:wKJl\u0015\r^2iKN\u001cuN\\:ue\u0006Lg\u000e\u001e\u0015\u0004i\u0005E\u0012a\u0011;fgR|%m]3sm\u0016\u0014X*\u0019;dQ\u0016\u001c8i\u001c8tiJ\f\u0017N\u001c;XSRD7+\u001f8d%\u0016\u0004H.[2bg\u0006sGm\u00142tKJ4XM]:P]N\u000bW.\u001a*bG.D3!NA\u0019\u0003Y#Xm\u001d;SKBd\u0017nY1J]\u0012Lg/\u001b3vC2\u001cuN\\:ue\u0006Lg\u000e^\"pk:$hj\u001c;TCRL7OZ5fI^KG\u000f[*z]\u000e\u0014V\r\u001d7jG\u0006\u001c\u0018I\u001c3PEN,'O^3sg>s7+Y7f%\u0006\u001c7\u000eK\u00027\u0003c\t\u0001\u0004^3ti&sg/\u00197jI>\u00137/\u001a:wKJ\u001cu.\u001e8uQ\r9\u0014\u0011G\u0001?i\u0016\u001cH/\u00138wC2LGm\u00142tKJ4XM]\"pk:$x+\u001b;i'ft7MU3qY&\u001c\u0017m]!oI>\u00137/\u001a:wKJ\u001cxJ\\*b[\u0016\u0014\u0016mY6)\u0007a\n\t$\u0001\u000fuKN$\u0018J\u001c<bY&$wJY:feZ,'/\u0011;ue&\u0014W\u000f^3)\u0007e\n\t$A\u0010uKN$(+\u001a9mS\u000e\f7\u000fS1t\u001f\n\u001cXM\u001d<fe\u0006\u001b8+\u001e4gSbD3AOA\u0019\u0003U!Xm\u001d;O_\u0012+\b\u000f\\5dCJ+\u0007\u000f\\5dCND3aOA\u0019\u0003a!Xm\u001d;O_:+w-\u0019;jm\u0016\u0014V\r\u001d7jG\u0006LEm\u001d\u0015\u0004y\u0005E\u0012A\n;fgR4\u0016\r\\5e%\u0016\f7o]5h]6,g\u000e\u001e(p\u001f\u001a4G.\u001b8f\u001f\n\u001cXM\u001d<fe\"\u001aQ(!\r\u0002\u0019R,7\u000f\u001e,bY&$'+Z1tg&<g.\\3oi:{wJ\u001a4mS:,wJY:feZ,'oV5uQNKhn\u0019*fa2L7-Y:B]\u0012|%m]3sm\u0016\u00148o\u00148TC6,'+Y2lQ\rq\u0014\u0011G\u0001di\u0016\u001cHOV1mS\u0012\u0014V-Y:tS\u001etW.\u001a8u%\u0016$XO\u001d8t\u000bJ\u0014xN],iK:\u001cuN\\:ue\u0006Lg\u000e\u001e(pi6+Go\u00142tKJ4XM],ji\"\u001c\u0016P\\2SKBd\u0017nY1t\u0003:$wJY:feZ,'o](o'\u0006lWMU1dW\"\u001aq(!\r\u0002OQ,7\u000f\u001e,bY&$'+Z1tg&<g.\\3oi\u0006cGn\u00144gY&tWm\u00142tKJ4XM\u001d\u0015\u0004\u0001\u0006E\u0012a\n;fgR4\u0016\r\\5e%\u0016\f7o]5h]6,g\u000e^(oK>3g\r\\5oK>\u00137/\u001a:wKJD3!QA\u0019\u0003%\"Xm\u001d;J]Z\fG.\u001b3SK\u0006\u001c8/[4o[\u0016tGOT3x\u001f\u001a4G.\u001b8f\u001f\n\u001cXM\u001d<fe\"\u001a!)!\r\u0002EQ,7\u000f^%om\u0006d\u0017\u000e\u001a*fCN\u001c\u0018n\u001a8nK:$xJ\u001a4mS:,7+\u001f8dQ\r\u0019\u0015\u0011G\u00016i\u0016\u001cHOV1mS\u0012\fG/\u001a+pa&\u001c\u0007\u000b\\1dK6,g\u000e^+qI\u0006$XmV5uQJ\u000b7m['jq&twmU;dG\u0016\u001c8\u000fK\u0002E\u0003c\tQ\u0007^3tiZ\u000bG.\u001b3bi\u0016$v\u000e]5d!2\f7-Z7f]R,\u0006\u000fZ1uK^KG\u000f\u001b*bG.l\u0015\u000e_5oO\u001a\u000b\u0017\u000e\\;sK\"\u001aQ)!\r\u0002qQ,7\u000f\u001e,bY&$\u0017\r^3U_BL7\r\u00157bG\u0016lWM\u001c;Va\u0012\fG/Z,ji\"|W\u000f\u001e*bG.l\u0015\u000e_5oON+8mY3tg\"\u001aa)!\r\u0002qQ,7\u000f\u001e,bY&$\u0017\r^3U_BL7\r\u00157bG\u0016lWM\u001c;Va\u0012\fG/Z,ji\"|W\u000f\u001e*bG.l\u0015\u000e_5oO\u001a\u000b\u0017\u000e\\;sK\"\u001aq)!\r")
public class ObserverTest {
    private final Option<TopicPlacement> topicWithObserverPlacementConstraint;
    private final Option<TopicPlacement> topicWithObserverPlacementOnSameRackAsSyncReplicaConstraint;
    private final Optional<TopicPlacement> topicWithTwoObserverPlacementConstraint;
    private final Optional<TopicPlacement> topicWithTwoObserverAndRackMixingPlacementConstraint;
    private final Option<TopicPlacement> topicWithoutObserversConstraint;
    private final scala.collection.immutable.Map<Object, Map<String, String>> allBrokersAttributes;

    private Option<TopicPlacement> topicWithObserverPlacementConstraint() {
        return this.topicWithObserverPlacementConstraint;
    }

    private Option<TopicPlacement> topicWithObserverPlacementOnSameRackAsSyncReplicaConstraint() {
        return this.topicWithObserverPlacementOnSameRackAsSyncReplicaConstraint;
    }

    private Optional<TopicPlacement> topicWithTwoObserverPlacementConstraint() {
        return this.topicWithTwoObserverPlacementConstraint;
    }

    private Optional<TopicPlacement> topicWithTwoObserverAndRackMixingPlacementConstraint() {
        return this.topicWithTwoObserverAndRackMixingPlacementConstraint;
    }

    private Option<TopicPlacement> topicWithoutObserversConstraint() {
        return this.topicWithoutObserversConstraint;
    }

    private scala.collection.immutable.Map<Object, Map<String, String>> allBrokersAttributes() {
        return this.allBrokersAttributes;
    }

    @Test
    public void testPlacementConstraintPredicateSuccess() {
        BrokerMetadata replicaBroker = new BrokerMetadata(2, (Option)new Some((Object)"east-1"), (Map)scala.collection.Map$.MODULE$.empty());
        BrokerMetadata observerBroker = new BrokerMetadata(2, (Option)new Some((Object)"west-1"), (Map)scala.collection.Map$.MODULE$.empty());
        this.topicWithObserverPlacementConstraint().foreach((Function1 & Serializable)topicPlacement -> {
            ObserverTest.$anonfun$testPlacementConstraintPredicateSuccess$1(replicaBroker, observerBroker, topicPlacement);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPlacementConstraintWithRackTypePredicateSuccess() {
        BrokerMetadata replicaBroker = new BrokerMetadata(2, (Option)new Some((Object)"east-1"), (Map)scala.collection.Map$.MODULE$.empty());
        BrokerMetadata observerBroker = new BrokerMetadata(2, (Option)new Some((Object)"west-1"), (Map)scala.collection.Map$.MODULE$.empty());
        this.topicWithObserverPlacementConstraint().foreach((Function1 & Serializable)topicPlacement -> {
            ObserverTest.$anonfun$testPlacementConstraintWithRackTypePredicateSuccess$1(replicaBroker, observerBroker, topicPlacement);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPlacementConstraintPredicateFailure() {
        BrokerMetadata broker = new BrokerMetadata(2, (Option)new Some((Object)"south-1"), (Map)scala.collection.Map$.MODULE$.empty());
        this.topicWithObserverPlacementConstraint().foreach((Function1 & Serializable)topicPlacement -> {
            ObserverTest.$anonfun$testPlacementConstraintPredicateFailure$1(broker, topicPlacement);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPlacementConstraintWithRackTypePredicateFailure() {
        BrokerMetadata broker = new BrokerMetadata(2, (Option)new Some((Object)"south-1"), (Map)scala.collection.Map$.MODULE$.empty());
        this.topicWithObserverPlacementConstraint().foreach((Function1 & Serializable)topicPlacement -> {
            ObserverTest.$anonfun$testPlacementConstraintWithRackTypePredicateFailure$1(broker, topicPlacement);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPlacementConstraintPredicateNoConstraints() {
        BrokerMetadata broker = new BrokerMetadata(2, (Option)new Some((Object)"south-1"), (Map)scala.collection.Map$.MODULE$.empty());
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |    }\n                          |  }]\n                          |}"));
        TopicPlacement topicPlacement = (TopicPlacement)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson))).get();
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, (TopicPlacement.ConstraintCount)topicPlacement.replicas().get(0)));
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, (TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)));
    }

    @Test
    public void testPlacementConstraintPredicateWithRackTypeNoConstraints() {
        BrokerMetadata broker = new BrokerMetadata(2, (Option)new Some((Object)"south-1"), (Map)scala.collection.Map$.MODULE$.empty());
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |    }\n                          |  }]\n                          |}"));
        TopicPlacement topicPlacement = (TopicPlacement)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson))).get();
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, (Map)CollectionConverters$.MODULE$.MapHasAsScala(((TopicPlacement.ConstraintCount)topicPlacement.replicas().get(0)).constraints()).asScala()));
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, (Map)CollectionConverters$.MODULE$.MapHasAsScala(((TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)).constraints()).asScala()));
    }

    @Test
    public void testPlacementConstraintPredicateNoBrokerRack() {
        BrokerMetadata broker = new BrokerMetadata(2, (Option)None$.MODULE$, (Map)scala.collection.Map$.MODULE$.empty());
        this.topicWithObserverPlacementConstraint().foreach((Function1 & Serializable)topicPlacement -> {
            ObserverTest.$anonfun$testPlacementConstraintPredicateNoBrokerRack$1(broker, topicPlacement);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPlacementConstraintPredicateWithRackTypeNoBrokerRack() {
        BrokerMetadata broker = new BrokerMetadata(2, (Option)None$.MODULE$, (Map)scala.collection.Map$.MODULE$.empty());
        this.topicWithObserverPlacementConstraint().foreach((Function1 & Serializable)topicPlacement -> {
            ObserverTest.$anonfun$testPlacementConstraintPredicateWithRackTypeNoBrokerRack$1(broker, topicPlacement);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMergeDisjointMaps() {
        scala.collection.mutable.Map firstMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), 6))}));
        scala.collection.mutable.Map secondMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(10), 15)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(11), 16))}));
        scala.collection.mutable.Map mergedMap = Observer$.MODULE$.mergeAssignmentMap(firstMap, (Map)secondMap);
        Assertions.assertEquals((Object)firstMap.$plus$plus((IterableOnce)secondMap), (Object)mergedMap);
    }

    @Test
    public void testMergeEmptyMap() {
        scala.collection.mutable.Map assignmentMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), 6))}));
        Assertions.assertEquals((Object)assignmentMap, (Object)Observer$.MODULE$.mergeAssignmentMap(assignmentMap, (Map)Map$.MODULE$.empty()));
        Assertions.assertEquals((Object)assignmentMap, (Object)Observer$.MODULE$.mergeAssignmentMap((scala.collection.mutable.Map)Map$.MODULE$.empty(), (Map)assignmentMap));
        Assertions.assertEquals((Object)Map$.MODULE$.empty(), (Object)Observer$.MODULE$.mergeAssignmentMap((scala.collection.mutable.Map)Map$.MODULE$.empty(), (Map)Map$.MODULE$.empty()));
    }

    @Test
    public void testMergeMapValueSame() {
        scala.collection.mutable.Map firstMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), 6))}));
        scala.collection.mutable.Map secondMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(10), 15)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(11), 16))}));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> Observer$.MODULE$.mergeAssignmentMap(firstMap, (Map)secondMap));
    }

    @Test
    public void testMergeMapKeySame() {
        scala.collection.mutable.Map firstMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), 6))}));
        scala.collection.mutable.Map secondMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(6), 10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(10), 15))}));
        Assertions.assertEquals((Object)((scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), 6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(10), 15))}))), (Object)Observer$.MODULE$.mergeAssignmentMap(firstMap, (Map)secondMap));
    }

    @Test
    public void testMergeDisjointSequences() {
        Range.Inclusive firstSeq = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10);
        Range.Inclusive secondSeq = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(11), 20);
        Assertions.assertEquals((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 20), (Object)Observer$.MODULE$.mergeReplicaLists((Seq)firstSeq, (Seq)secondSeq));
    }

    @Test
    public void testMergeEmptySequences() {
        Range.Inclusive testSeq = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10);
        Assertions.assertEquals((Object)testSeq, (Object)Observer$.MODULE$.mergeReplicaLists((Seq)testSeq, (Seq)Seq$.MODULE$.empty()));
        Assertions.assertEquals((Object)testSeq, (Object)Observer$.MODULE$.mergeReplicaLists((Seq)Seq$.MODULE$.empty(), (Seq)testSeq));
        Assertions.assertEquals((Object)Seq$.MODULE$.empty(), (Object)Observer$.MODULE$.mergeReplicaLists((Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty()));
    }

    @Test
    public void mergeNonDisjointSequences() {
        Range.Inclusive firstSeq = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10);
        Range.Inclusive secondSeq = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 15);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> Observer$.MODULE$.mergeReplicaLists((Seq)firstSeq, (Seq)secondSeq));
    }

    @Test
    public void testPartitionBrokersByConstraint() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 3,\n                          |    \"constraints\": {\n                          |      \"rack\": \"west-1\"\n                          |    }\n                          |  }]\n                          |}"));
        IndexedSeq east1Brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)x$1 -> ObserverTest.$anonfun$testPartitionBrokersByConstraint$1(BoxesRunTime.unboxToInt((Object)x$1)));
        IndexedSeq east2Brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(11), 20).map((Function1 & Serializable)x$2 -> ObserverTest.$anonfun$testPartitionBrokersByConstraint$2(BoxesRunTime.unboxToInt((Object)x$2)));
        IndexedSeq west1Brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(21), 30).map((Function1 & Serializable)x$3 -> ObserverTest.$anonfun$testPartitionBrokersByConstraint$3(BoxesRunTime.unboxToInt((Object)x$3)));
        IndexedSeq allBrokers = (IndexedSeq)((IterableOps)east1Brokers.$plus$plus((IterableOnce)east2Brokers)).$plus$plus((IterableOnce)west1Brokers);
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placementJson).get();
        Buffer buffer = CollectionConverters$.MODULE$.ListHasAsScala(topicPlacement.replicas()).asScala();
        Seq replicasTuple = Observer$.MODULE$.partitionBrokersByConstraint((Seq)allBrokers, (Seq)buffer);
        Seq replicas = (Seq)replicasTuple.flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                return (Seq)x0$1._2();
            }
            throw new MatchError(null);
        });
        Assertions.assertEquals((Object)east1Brokers.$plus$plus((IterableOnce)east2Brokers), (Object)replicas);
        Seq replicaCount = (Seq)replicasTuple.map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)ObserverTest.$anonfun$testPartitionBrokersByConstraint$6(x0$2)));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)replicaCount);
        buffer = CollectionConverters$.MODULE$.ListHasAsScala(topicPlacement.observers()).asScala();
        Seq observersTuple = Observer$.MODULE$.partitionBrokersByConstraint((Seq)allBrokers, (Seq)buffer);
        Seq observers = (Seq)observersTuple.flatMap((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                return (Seq)x0$3._2();
            }
            throw new MatchError(null);
        });
        Assertions.assertEquals((Object)west1Brokers, (Object)observers);
        Seq observersCount = (Seq)observersTuple.map((Function1 & Serializable)x0$4 -> BoxesRunTime.boxToInteger((int)ObserverTest.$anonfun$testPartitionBrokersByConstraint$8(x0$4)));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), (Object)observersCount);
    }

    @Test
    public void testPartitionBrokersByConstraintWithRackMixingSupport() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 3,\n                          |    \"constraints\": {\n                          |      \"rack\": \"west-1\"\n                          |    }\n                          |  }]\n                          |}"));
        IndexedSeq east1Brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)x$4 -> ObserverTest.$anonfun$testPartitionBrokersByConstraintWithRackMixingSupport$1(BoxesRunTime.unboxToInt((Object)x$4)));
        IndexedSeq east2Brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(11), 20).map((Function1 & Serializable)x$5 -> ObserverTest.$anonfun$testPartitionBrokersByConstraintWithRackMixingSupport$2(BoxesRunTime.unboxToInt((Object)x$5)));
        IndexedSeq west1Brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(21), 30).map((Function1 & Serializable)x$6 -> ObserverTest.$anonfun$testPartitionBrokersByConstraintWithRackMixingSupport$3(BoxesRunTime.unboxToInt((Object)x$6)));
        IndexedSeq allBrokers = (IndexedSeq)((IterableOps)east1Brokers.$plus$plus((IterableOnce)east2Brokers)).$plus$plus((IterableOnce)west1Brokers);
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placementJson).get();
        Seq requiredReplicaCountsAndEligibleBrokers = Observer$.MODULE$.buildRequiredReplicaCountsAndEligibleBrokers(topicPlacement, (Seq)allBrokers);
        Assertions.assertEquals((int)3, (int)requiredReplicaCountsAndEligibleBrokers.size());
        Assertions.assertEquals((Object)new RequiredReplicaCountsAndEligibleBrokers(3, 0, (Seq)east1Brokers, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option)None$.MODULE$), (Object)requiredReplicaCountsAndEligibleBrokers.apply(0));
        Assertions.assertEquals((Object)new RequiredReplicaCountsAndEligibleBrokers(2, 0, (Seq)east2Brokers, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)None$.MODULE$), (Object)requiredReplicaCountsAndEligibleBrokers.apply(1));
        Assertions.assertEquals((Object)new RequiredReplicaCountsAndEligibleBrokers(0, 3, (Seq)west1Brokers, (Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0))), (Object)requiredReplicaCountsAndEligibleBrokers.apply(2));
    }

    @Test
    public void testPartitionBrokersWithOverlappedRackConstraintsByConstraintWithRackMixingSupport() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 3,\n                          |    \"constraints\": {\n                          |      \"rack\": \"east-1\"\n                          |    }\n                          |  }]\n                          |}"));
        IndexedSeq east1Brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)x$7 -> ObserverTest.$anonfun$testPartitionBrokersWithOverlappedRackConstraintsByConstraintWithRackMixingSupport$1(BoxesRunTime.unboxToInt((Object)x$7)));
        IndexedSeq east2Brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(11), 20).map((Function1 & Serializable)x$8 -> ObserverTest.$anonfun$testPartitionBrokersWithOverlappedRackConstraintsByConstraintWithRackMixingSupport$2(BoxesRunTime.unboxToInt((Object)x$8)));
        IndexedSeq allBrokers = (IndexedSeq)east1Brokers.$plus$plus((IterableOnce)east2Brokers);
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placementJson).get();
        Seq requiredReplicaCountsAndEligibleBrokers = Observer$.MODULE$.buildRequiredReplicaCountsAndEligibleBrokers(topicPlacement, (Seq)allBrokers);
        Assertions.assertEquals((int)2, (int)requiredReplicaCountsAndEligibleBrokers.size());
        Assertions.assertEquals((Object)new RequiredReplicaCountsAndEligibleBrokers(3, 3, (Seq)east1Brokers, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)0))), (Object)requiredReplicaCountsAndEligibleBrokers.apply(0));
        Assertions.assertEquals((Object)new RequiredReplicaCountsAndEligibleBrokers(2, 0, (Seq)east2Brokers, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)None$.MODULE$), (Object)requiredReplicaCountsAndEligibleBrokers.apply(1));
    }

    @Test
    public void testPartitionBrokersByConstraintInvalidCount() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 5,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 3,\n                          |    \"constraints\": {\n                          |      \"rack\": \"west-1\"\n                          |    }\n                          |  }]\n                          |}"));
        IndexedSeq east1Brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)x$9 -> ObserverTest.$anonfun$testPartitionBrokersByConstraintInvalidCount$1(BoxesRunTime.unboxToInt((Object)x$9)));
        IndexedSeq east2Brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(11), 13).map((Function1 & Serializable)x$10 -> ObserverTest.$anonfun$testPartitionBrokersByConstraintInvalidCount$2(BoxesRunTime.unboxToInt((Object)x$10)));
        IndexedSeq west1Brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(14), 20).map((Function1 & Serializable)x$11 -> ObserverTest.$anonfun$testPartitionBrokersByConstraintInvalidCount$3(BoxesRunTime.unboxToInt((Object)x$11)));
        IndexedSeq allBrokers = (IndexedSeq)((IterableOps)east1Brokers.$plus$plus((IterableOnce)east2Brokers)).$plus$plus((IterableOnce)west1Brokers);
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placementJson).get();
        Function1 & Serializable partitionFunction = (Function1 & Serializable)constraints -> Observer$.MODULE$.partitionBrokersByConstraint((Seq)allBrokers, constraints);
        Buffer buffer = CollectionConverters$.MODULE$.ListHasAsScala(topicPlacement.observers()).asScala();
        Observer$.MODULE$.partitionBrokersByConstraint((Seq)allBrokers, (Seq)buffer);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> partitionFunction.apply((Object)CollectionConverters$.MODULE$.ListHasAsScala(topicPlacement.replicas()).asScala()));
    }

    @Test
    public void testBuildRequiredReplicaCountsAndEligibleBrokersWithRackMixingSupport() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 5,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-2\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-3\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 3,\n                          |    \"constraints\": {\n                          |      \"rack\": \"west-1\"\n                          |    }\n                          |  }]\n                          |}"));
        IndexedSeq east1Brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)x$12 -> ObserverTest.$anonfun$testBuildRequiredReplicaCountsAndEligibleBrokersWithRackMixingSupport$1(BoxesRunTime.unboxToInt((Object)x$12)));
        IndexedSeq east2Brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(11), 13).map((Function1 & Serializable)x$13 -> ObserverTest.$anonfun$testBuildRequiredReplicaCountsAndEligibleBrokersWithRackMixingSupport$2(BoxesRunTime.unboxToInt((Object)x$13)));
        IndexedSeq west1Brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(14), 20).map((Function1 & Serializable)x$14 -> ObserverTest.$anonfun$testBuildRequiredReplicaCountsAndEligibleBrokersWithRackMixingSupport$3(BoxesRunTime.unboxToInt((Object)x$14)));
        IndexedSeq allBrokers = (IndexedSeq)((IterableOps)east1Brokers.$plus$plus((IterableOnce)east2Brokers)).$plus$plus((IterableOnce)west1Brokers);
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placementJson).get();
        InvalidConfigurationException exception = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> Observer$.MODULE$.buildRequiredReplicaCountsAndEligibleBrokers(topicPlacement, (Seq)allBrokers));
        Assertions.assertEquals((Object)"Failed to satisfy the topic placement: for constraint Map(rack -> east-3) there are 0 matching brokers but the topic placement requires 1 sync replicas and 0 observers, for constraint Map(rack -> east-2) there are 3 matching brokers but the topic placement requires 5 sync replicas and 0 observers", (Object)exception.getMessage());
    }

    @Test
    public void testRackUnawareNoConstraintReplicaAssignment() {
        IntRef assignmentFuncsProcessed = IntRef.create((int)0);
        Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)rackMixingSupport -> {
            ObserverTest.$anonfun$testRackUnawareNoConstraintReplicaAssignment$1(this, assignmentFuncsProcessed, BoxesRunTime.unboxToBoolean((Object)rackMixingSupport));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)assignmentFuncsProcessed.elem);
    }

    @Test
    public void testRackUnawareReplicaAssignmentWithPlacementConstraintMissing() {
        IntRef assignmentFuncsProcessed = IntRef.create((int)0);
        Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)rackMixingSupport -> {
            ObserverTest.$anonfun$testRackUnawareReplicaAssignmentWithPlacementConstraintMissing$1(this, assignmentFuncsProcessed, BoxesRunTime.unboxToBoolean((Object)rackMixingSupport));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)assignmentFuncsProcessed.elem);
    }

    private void validateRackUnawareReplicaAssignment(IndexedSeq<BrokerMetadata> brokers2, Map<Object, ReplicaAssignment> assignments) {
        ((Iterable)((IterableOps)assignments.values().map((Function1 & Serializable)x$17 -> x$17.replicas())).transpose(Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable)assignedPartitions -> {
            ObserverTest.$anonfun$validateRackUnawareReplicaAssignment$2(assignedPartitions);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)assignments.values().map((Function1 & Serializable)x$18 -> x$18.replicas())).foreach((Function1 & Serializable)brokers -> {
            ObserverTest.$anonfun$validateRackUnawareReplicaAssignment$6(brokers);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRackAwareNoConstraintReplicaAssignment() {
        int numPartitions = 9;
        short replicationFactor = 3;
        IndexedSeq racks = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).flatMap((Function1 & Serializable)id -> ObserverTest.$anonfun$testRackAwareNoConstraintReplicaAssignment$1(BoxesRunTime.unboxToInt((Object)id)));
        IndexedSeq brokers = (IndexedSeq)((IndexedSeqOps)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).zip((IterableOnce)racks)).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int id = x0$1._1$mcI$sp();
                String rack = (String)x0$1._2();
                return new BrokerMetadata(id, (Option)new Some((Object)rack), (Map)scala.collection.Map$.MODULE$.empty());
            }
            throw new MatchError(null);
        });
        IntRef assignmentFuncsProcessed = IntRef.create((int)0);
        Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)rackMixingSupport -> {
            ObserverTest.$anonfun$testRackAwareNoConstraintReplicaAssignment$4(brokers, numPartitions, replicationFactor, assignmentFuncsProcessed, BoxesRunTime.unboxToBoolean((Object)rackMixingSupport));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)assignmentFuncsProcessed.elem);
    }

    @Test
    public void testGetReplicaAssignmentHandlesMetadataVersion() {
        String placementJsonWithSyncReplicasAndObserversOnSameRack = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 2,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack1\"\n                          |    }\n                          |  }]\n                          |}"));
        String placementJsonWithoutSyncReplicasAndObserversOnSameRack = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 2,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack3\"\n                          |    }\n                          |  }]\n                          |}"));
        IndexedSeq brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 14).map((Function1 & Serializable)id -> ObserverTest.$anonfun$testGetReplicaAssignmentHandlesMetadataVersion$1(BoxesRunTime.unboxToInt((Object)id)));
        Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)rackMixingSupport -> ObserverTest.$anonfun$testGetReplicaAssignmentHandlesMetadataVersion$2(brokers, placementJsonWithSyncReplicasAndObserversOnSameRack, placementJsonWithoutSyncReplicasAndObserversOnSameRack, BoxesRunTime.unboxToBoolean((Object)rackMixingSupport)));
    }

    @Test
    public void testRackAwareWithConstraintReplicaAssignmentWithRackMixing() {
        IndexedSeq brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 24).map((Function1 & Serializable)id -> ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$1(BoxesRunTime.unboxToInt((Object)id)));
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                           | \"version\": 1,\n                           |  \"replicas\": [{\n                           |      \"count\": 2,\n                           |      \"constraints\": {\n                           |        \"rack\": \"rack1\"\n                           |      }\n                           |    },\n                           |    {\n                           |      \"count\": 2,\n                           |      \"constraints\": {\n                           |        \"rack\": \"rack2\"\n                           |      }\n                           |    },\n                           |    {\n                           |      \"count\": 2,\n                           |      \"constraints\": {\n                           |         \"rack\": \"rack3\"\n                           |      }\n                           |    },\n                           |    {\n                           |      \"count\": 2,\n                           |      \"constraints\": {\n                           |        \"rack\": \"rack4\"\n                           |       }\n                           |     },\n                           |    {\n                           |      \"count\": 2,\n                           |      \"constraints\": {\n                           |        \"rack\": \"rack5\"\n                           |       }\n                           |    }\n                           |  ],\n                           |  \"observers\": [\n                           |  {\n                           |    \"count\": 2,\n                           |    \"constraints\": {\n                           |      \"rack\": \"rack1\"\n                           |    }\n                           |   },\n                           |   {\n                           |    \"count\": 2,\n                           |    \"constraints\": {\n                           |      \"rack\": \"rack2\"\n                           |    }\n                           |   },\n                           |   {\n                           |     \"count\": 2,\n                           |     \"constraints\": {\n                           |       \"rack\": \"rack3\"\n                           |     }\n                           |   },\n                           |   {\n                           |     \"count\": 2,\n                           |     \"constraints\": {\n                           |       \"rack\": \"rack4\"\n                           |     }\n                           |   },\n                           |   {\n                           |     \"count\": 2,\n                           |     \"constraints\": {\n                           |       \"rack\": \"rack5\"\n                           |     }\n                           |   }\n                           |  ]\n                           |}"));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> Observer$.MODULE$.getReplicaAssignment((Seq)brokers, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson))), 10, 3, false, -1, -1));
        Map partitionAssignment = Observer$.MODULE$.getReplicaAssignment((Seq)brokers, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson))), 10, 3, true, 0, 0);
        ((IterableOnceOps)partitionAssignment.values().map((Function1 & Serializable)x$21 -> x$21.replicas())).foreach((Function1 & Serializable)assignedBrokers -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$4(assignedBrokers);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)partitionAssignment.values().map((Function1 & Serializable)x$22 -> x$22.observers())).foreach((Function1 & Serializable)observers -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$16(observers);
            return BoxedUnit.UNIT;
        });
        ((Iterable)((IterableOps)partitionAssignment.values().map((Function1 & Serializable)x$23 -> x$23.replicas())).transpose(Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable)assignedPartitions -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$23(assignedPartitions);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRackAwareWithConstraintReplicaAssignment() {
        IndexedSeq brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 14).map((Function1 & Serializable)id -> ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignment$1(BoxesRunTime.unboxToInt((Object)id)));
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 2,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack3\"\n                          |    }\n                          |  }]\n                          |}"));
        IntRef assignmentFuncsProcessed = IntRef.create((int)0);
        Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)rackMixingSupport -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignment$2(brokers, placementJson, assignmentFuncsProcessed, BoxesRunTime.unboxToBoolean((Object)rackMixingSupport));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)assignmentFuncsProcessed.elem);
    }

    @Test
    public void testRackAwareWithConstraintReplicaAssignmentWithStartIndex() {
        IndexedSeq brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 14).map((Function1 & Serializable)id -> ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$1(BoxesRunTime.unboxToInt((Object)id)));
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                           | \"version\": 1,\n                           |  \"replicas\": [{\n                           |      \"count\": 4,\n                           |      \"constraints\": {\n                           |        \"rack\": \"rack1\"\n                           |      }\n                           |    }\n                           |  ],\n                           |  \"observers\": [{\n                           |    \"count\": 3,\n                           |    \"constraints\": {\n                           |      \"rack\": \"rack3\"\n                           |    }\n                           |  }]\n                           |}"));
        IntRef assignmentFuncsProcessed = IntRef.create((int)0);
        Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)rackMixingSupport -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$2(brokers, placementJson, assignmentFuncsProcessed, BoxesRunTime.unboxToBoolean((Object)rackMixingSupport));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)assignmentFuncsProcessed.elem);
    }

    @Test
    public void validatePartitioningSuccess() {
        IndexedSeq partitionedBrokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).map((Function1 & Serializable)partitionNumber -> ObserverTest.$anonfun$validatePartitioningSuccess$1(BoxesRunTime.unboxToInt((Object)partitionNumber)));
        Observer$.MODULE$.validatePartitioning((Seq)partitionedBrokers);
    }

    @Test
    public void validatePartitioningFailure() {
        .colon.colon commonBrokers = new .colon.colon((Object)new BrokerMetadata(1, (Option)new Some((Object)"rack-1"), (Map)scala.collection.Map$.MODULE$.empty()), (List)new .colon.colon((Object)new BrokerMetadata(2, (Option)new Some((Object)"rack-1"), (Map)scala.collection.Map$.MODULE$.empty()), (List)Nil$.MODULE$));
        .colon.colon partitionedBrokers = new .colon.colon((Object)((List)new .colon.colon((Object)new BrokerMetadata(3, (Option)new Some((Object)"rack-1"), (Map)scala.collection.Map$.MODULE$.empty()), (List)Nil$.MODULE$).$plus$plus((IterableOnce)commonBrokers)), (List)new .colon.colon((Object)((List)new .colon.colon((Object)new BrokerMetadata(4, (Option)new Some((Object)"rack-1"), (Map)scala.collection.Map$.MODULE$.empty()), (List)Nil$.MODULE$).$plus$plus((IterableOnce)commonBrokers)), (List)Nil$.MODULE$));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ObserverTest.$anonfun$validatePartitioningFailure$1((Seq)partitionedBrokers));
    }

    @Test
    public void validatePartitioningFailureMultiplePartitionsWithRackMixingSupport() {
        .colon.colon commonBrokers = new .colon.colon((Object)new BrokerMetadata(1, (Option)new Some((Object)"rack-1"), (Map)scala.collection.Map$.MODULE$.empty()), (List)new .colon.colon((Object)new BrokerMetadata(2, (Option)new Some((Object)"rack-1"), (Map)scala.collection.Map$.MODULE$.empty()), (List)Nil$.MODULE$));
        .colon.colon brokers = new .colon.colon((Object)((List)new .colon.colon((Object)new BrokerMetadata(3, (Option)new Some((Object)"rack-1"), (Map)scala.collection.Map$.MODULE$.empty()), (List)Nil$.MODULE$).$plus$plus((IterableOnce)commonBrokers)), (List)new .colon.colon((Object)new .colon.colon((Object)new BrokerMetadata(4, (Option)new Some((Object)"rack-1"), (Map)scala.collection.Map$.MODULE$.empty()), (List)Nil$.MODULE$), (List)new .colon.colon((Object)((List)new .colon.colon((Object)new BrokerMetadata(5, (Option)new Some((Object)"rack-1"), (Map)scala.collection.Map$.MODULE$.empty()), (List)Nil$.MODULE$).$plus$plus((IterableOnce)commonBrokers)), (List)Nil$.MODULE$)));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ObserverTest.$anonfun$validatePartitioningFailureMultiplePartitionsWithRackMixingSupport$1((Seq)brokers));
    }

    @Test
    public void testValidateReplicasNoPlacementConstraint() {
        Observer$.MODULE$.validateAssignment((Option)None$.MODULE$, new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 6), (Seq)Seq$.MODULE$.empty()), this.allBrokersAttributes());
    }

    @Test
    public void testValidateObserversConstraint() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3), (Seq)Seq$.MODULE$.empty()), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable)x$31 -> x$31.error()));
    }

    @Test
    public void testValidateObserversConstraintWithSyncReplicasAndObserversOnSameRack() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementOnSameRackAsSyncReplicaConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2), (Seq)Seq$.MODULE$.empty()), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable)x$32 -> x$32.error()));
    }

    @Test
    public void testValidateReplicasMatchesConstraint() {
        Observer$.MODULE$.validateAssignment(this.topicWithoutObserversConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 6), (Seq)Seq$.MODULE$.empty()), this.allBrokersAttributes());
    }

    @Test
    public void testValidateReplicasOverConstraintCount() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithoutObserversConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7), (Seq)Seq$.MODULE$.empty()), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable)x$33 -> x$33.error()));
    }

    @Test
    public void testValidateReplicasUnderConstraintCount() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithoutObserversConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4), (Seq)Seq$.MODULE$.empty()), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable)x$34 -> x$34.error()));
    }

    @Test
    public void testReplicaIndividualConstraintCountNotSatisfied() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithoutObserversConstraint(), new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3, 4, 5, 6, 7})), (Seq)Seq$.MODULE$.empty()), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable)x$35 -> x$35.error()));
    }

    @Test
    public void testObserverMatchesConstraint() {
        Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 6)), this.allBrokersAttributes());
    }

    @Test
    public void testObserverMatchesConstraintWithSyncReplicasAndObserversOnSameRack() {
        Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementOnSameRackAsSyncReplicaConstraint(), new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 1})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))), this.allBrokersAttributes());
    }

    @Test
    public void testReplicaIndividualConstraintCountNotSatisfiedWithSyncReplicasAndObserversOnSameRack() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementOnSameRackAsSyncReplicaConstraint(), new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 4})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4}))), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable)x$36 -> x$36.error()));
    }

    @Test
    public void testInvalidObserverCount() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 7)), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable)x$37 -> x$37.error()));
    }

    @Test
    public void testInvalidObserverCountWithSyncReplicasAndObserversOnSameRack() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementOnSameRackAsSyncReplicaConstraint(), new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable)x$38 -> x$38.error()));
    }

    @Test
    public void testInvalidObserverAttribute() {
        Option err = Observer$.MODULE$.validateAssignment(this.topicWithObserverPlacementConstraint(), new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5).$plus$plus((IterableOnce)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{9}))), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 9}))), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable)x$39 -> x$39.error()));
    }

    @Test
    public void testReplicasHasObserverAsSuffix() {
        Option err = Observer$.MODULE$.validateAssignmentStructure(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1)));
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable)x$40 -> x$40.error()));
    }

    @Test
    public void testNoDuplicaReplicas() {
        Option err = Observer$.MODULE$.validateAssignmentStructure(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 1})), (Seq)Seq$.MODULE$.empty()));
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable)x$41 -> x$41.error()));
    }

    @Test
    public void testNoNegativeReplicaIds() {
        Option err = Observer$.MODULE$.validateAssignmentStructure(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, -2})), (Seq)Seq$.MODULE$.empty()));
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable)x$42 -> x$42.error()));
    }

    @Test
    public void testValidReassignmentNoOfflineObserver() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 6))).reassignTo(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 6).$plus$plus((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4)), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4))), this.allBrokersAttributes());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)err.map((Function1 & Serializable)x$43 -> x$43.error()));
    }

    @Test
    public void testValidReassignmentNoOfflineObserverWithSyncReplicasAndObserversOnSameRack() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverAndRackMixingPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})))).reassignTo(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3})))), this.allBrokersAttributes());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)err.map((Function1 & Serializable)x$44 -> x$44.error()));
    }

    @Test
    public void testValidReassignmentReturnsErrorWhenConstraintNotMetObserverWithSyncReplicasAndObserversOnSameRack() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverAndRackMixingPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})))).reassignTo(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 4, 3})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 3})))), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable)x$45 -> x$45.error()));
    }

    @Test
    public void testValidReassignmentAllOfflineObserver() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 6))).reassignTo(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 6).$plus$plus((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4)), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4))), (Map)this.allBrokersAttributes().$minus$minus((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)err.map((Function1 & Serializable)x$46 -> x$46.error()));
    }

    @Test
    public void testValidReassignmentOneOfflineObserver() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 6))).reassignTo(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 6).$plus$plus((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4)), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4))), (Map)this.allBrokersAttributes().$minus((Object)BoxesRunTime.boxToInteger((int)0)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)err.map((Function1 & Serializable)x$47 -> x$47.error()));
    }

    @Test
    public void testInvalidReassignmentNewOfflineObserver() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 6))).reassignTo(new ReplicaAssignment.Assignment((Seq)((IterableOps)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 6).$plus$plus((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3))).$plus$plus((IterableOnce)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10}))), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).$plus$plus((IterableOnce)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10}))))), this.allBrokersAttributes());
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable)x$48 -> x$48.error()));
    }

    @Test
    public void testInvalidReassignmentOfflineSync() {
        Option err = Observer$.MODULE$.validateReassignment(this.topicWithTwoObserverPlacementConstraint(), ReplicaAssignment$.MODULE$.fromAssignment(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 6), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 6))).reassignTo(new ReplicaAssignment.Assignment((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 6).$plus$plus((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4)), (Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4))), (Map)this.allBrokersAttributes().$minus((Object)BoxesRunTime.boxToInteger((int)5)));
        Assertions.assertEquals((Object)new Some((Object)Errors.INVALID_REPLICA_ASSIGNMENT), (Object)err.map((Function1 & Serializable)x$49 -> x$49.error()));
    }

    @Test
    public void testValidateTopicPlacementUpdateWithRackMixingSuccess() {
        .colon.colon brokers = new .colon.colon((Object)new BrokerMetadata(0, (Option)new Some((Object)"rack-1"), (Map)scala.collection.Map$.MODULE$.empty()), (List)new .colon.colon((Object)new BrokerMetadata(1, (Option)new Some((Object)"rack-1"), (Map)scala.collection.Map$.MODULE$.empty()), (List)Nil$.MODULE$));
        new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 1,\n        |    \"constraints\": {\n        |      \"rack\": \"rack-1\"\n        |    }\n        |  }]\n        |}")), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ]\n        |}")), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ]\n        |}")), (List)Nil$.MODULE$))).foreach(arg_0 -> ObserverTest.$anonfun$testValidateTopicPlacementUpdateWithRackMixingSuccess$1$adapted((List)brokers, arg_0));
    }

    @Test
    public void testValidateTopicPlacementUpdateWithRackMixingFailure() {
        .colon.colon brokers = new .colon.colon((Object)new BrokerMetadata(0, (Option)new Some((Object)"rack-1"), (Map)scala.collection.Map$.MODULE$.empty()), (List)new .colon.colon((Object)new BrokerMetadata(1, (Option)new Some((Object)"rack-1"), (Map)scala.collection.Map$.MODULE$.empty()), (List)Nil$.MODULE$));
        new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack-1\"\n        |    }\n        |  }]\n        |}")), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 1,\n        |    \"constraints\": {\n        |      \"rack\": \"rack-1\"\n        |    }\n        |  }]\n        |}")), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 3,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ]\n        |}")), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [\n        |  {\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |  },\n        |  {\n        |    \"count\": 1,\n        |     \"constraints\": {\n        |       \"rack\": \"rack-1\"\n        |    }\n        |  }\n        |]\n        |}")), (List)Nil$.MODULE$)))).foreach(arg_0 -> ObserverTest.$anonfun$testValidateTopicPlacementUpdateWithRackMixingFailure$1((List)brokers, arg_0));
    }

    @Test
    public void testValidateTopicPlacementUpdateWithoutRackMixingSuccess() {
        .colon.colon brokers = new .colon.colon((Object)new BrokerMetadata(0, (Option)new Some((Object)"rack-1"), (Map)scala.collection.Map$.MODULE$.empty()), (List)new .colon.colon((Object)new BrokerMetadata(1, (Option)new Some((Object)"rack-2"), (Map)scala.collection.Map$.MODULE$.empty()), (List)Nil$.MODULE$));
        new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 1,\n        |    \"constraints\": {\n        |      \"rack\": \"rack-2\"\n        |    }\n        |  }]\n        |}")), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ]\n        |}")), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ]\n        |}")), (List)Nil$.MODULE$))).foreach(arg_0 -> ObserverTest.$anonfun$testValidateTopicPlacementUpdateWithoutRackMixingSuccess$1$adapted((List)brokers, arg_0));
    }

    @Test
    public void testValidateTopicPlacementUpdateWithoutRackMixingFailure() {
        .colon.colon brokers = new .colon.colon((Object)new BrokerMetadata(0, (Option)new Some((Object)"rack-1"), (Map)scala.collection.Map$.MODULE$.empty()), (List)new .colon.colon((Object)new BrokerMetadata(1, (Option)new Some((Object)"rack-2"), (Map)scala.collection.Map$.MODULE$.empty()), (List)Nil$.MODULE$));
        new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack-2\"\n        |    }\n        |  }]\n        |}")), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack-1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 1,\n        |    \"constraints\": {\n        |      \"rack\": \"rack-2\"\n        |    }\n        |  }]\n        |}")), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n          | \"version\": 1,\n          |  \"replicas\": [{\n          |      \"count\": 3,\n          |      \"constraints\": {\n          |        \"rack\": \"rack-1\"\n          |      }\n          |    }\n          |  ]\n          |}")), (List)Nil$.MODULE$))).foreach(arg_0 -> ObserverTest.$anonfun$testValidateTopicPlacementUpdateWithoutRackMixingFailure$1((List)brokers, arg_0));
    }

    public static final /* synthetic */ Tuple2 $anonfun$allBrokersAttributes$1(int id) {
        switch (id) {
            default: 
        }
        String rack = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).contains(id) ? "east-1" : (RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 4).contains(id) ? "east-2" : (RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 7).contains(id) ? "west-1" : "west-2"));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)id)), scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rack"), (Object)rack)})));
    }

    public static final /* synthetic */ void $anonfun$testPlacementConstraintPredicateSuccess$1(BrokerMetadata replicaBroker$1, BrokerMetadata observerBroker$1, TopicPlacement topicPlacement) {
        Buffer replicaConstraints = CollectionConverters$.MODULE$.ListHasAsScala(topicPlacement.replicas()).asScala();
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(replicaBroker$1, (TopicPlacement.ConstraintCount)replicaConstraints.head()));
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(replicaBroker$1, (TopicPlacement.ConstraintCount)((IterableOps)replicaConstraints.tail()).head()));
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(observerBroker$1, (TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)));
    }

    public static final /* synthetic */ void $anonfun$testPlacementConstraintWithRackTypePredicateSuccess$1(BrokerMetadata replicaBroker$2, BrokerMetadata observerBroker$2, TopicPlacement topicPlacement) {
        Buffer replicaConstraints = CollectionConverters$.MODULE$.ListHasAsScala(topicPlacement.replicas()).asScala();
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(replicaBroker$2, (Map)CollectionConverters$.MODULE$.MapHasAsScala(((TopicPlacement.ConstraintCount)replicaConstraints.head()).constraints()).asScala()));
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(replicaBroker$2, (Map)CollectionConverters$.MODULE$.MapHasAsScala(((TopicPlacement.ConstraintCount)((IterableOps)replicaConstraints.tail()).head()).constraints()).asScala()));
        Assertions.assertTrue((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(observerBroker$2, (Map)CollectionConverters$.MODULE$.MapHasAsScala(((TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)).constraints()).asScala()));
    }

    public static final /* synthetic */ void $anonfun$testPlacementConstraintPredicateFailure$1(BrokerMetadata broker$1, TopicPlacement topicPlacement) {
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$1, (TopicPlacement.ConstraintCount)topicPlacement.replicas().get(0)));
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$1, (TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)));
    }

    public static final /* synthetic */ void $anonfun$testPlacementConstraintWithRackTypePredicateFailure$1(BrokerMetadata broker$2, TopicPlacement topicPlacement) {
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$2, (Map)CollectionConverters$.MODULE$.MapHasAsScala(((TopicPlacement.ConstraintCount)topicPlacement.replicas().get(0)).constraints()).asScala()));
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$2, (Map)CollectionConverters$.MODULE$.MapHasAsScala(((TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)).constraints()).asScala()));
    }

    public static final /* synthetic */ void $anonfun$testPlacementConstraintPredicateNoBrokerRack$1(BrokerMetadata broker$3, TopicPlacement topicPlacement) {
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$3, (TopicPlacement.ConstraintCount)topicPlacement.replicas().get(0)));
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$3, (TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)));
    }

    public static final /* synthetic */ void $anonfun$testPlacementConstraintPredicateWithRackTypeNoBrokerRack$1(BrokerMetadata broker$4, TopicPlacement topicPlacement) {
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$4, (Map)CollectionConverters$.MODULE$.MapHasAsScala(((TopicPlacement.ConstraintCount)topicPlacement.replicas().get(0)).constraints()).asScala()));
        Assertions.assertFalse((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker$4, (Map)CollectionConverters$.MODULE$.MapHasAsScala(((TopicPlacement.ConstraintCount)topicPlacement.observers().get(0)).constraints()).asScala()));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraint$1(int x$1) {
        return new BrokerMetadata(x$1, (Option)new Some((Object)"east-1"), (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraint$2(int x$2) {
        return new BrokerMetadata(x$2, (Option)new Some((Object)"east-2"), (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraint$3(int x$3) {
        return new BrokerMetadata(x$3, (Option)new Some((Object)"west-1"), (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ Seq $anonfun$testPartitionBrokersByConstraint$4(IndexedSeq allBrokers$1, Seq constraints) {
        return Observer$.MODULE$.partitionBrokersByConstraint((Seq)allBrokers$1, constraints);
    }

    public static final /* synthetic */ int $anonfun$testPartitionBrokersByConstraint$6(Tuple2 x0$2) {
        if (x0$2 != null) {
            return x0$2._1$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$testPartitionBrokersByConstraint$8(Tuple2 x0$4) {
        if (x0$4 != null) {
            return x0$4._1$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraintWithRackMixingSupport$1(int x$4) {
        return new BrokerMetadata(x$4, (Option)new Some((Object)"east-1"), (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraintWithRackMixingSupport$2(int x$5) {
        return new BrokerMetadata(x$5, (Option)new Some((Object)"east-2"), (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraintWithRackMixingSupport$3(int x$6) {
        return new BrokerMetadata(x$6, (Option)new Some((Object)"west-1"), (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersWithOverlappedRackConstraintsByConstraintWithRackMixingSupport$1(int x$7) {
        return new BrokerMetadata(x$7, (Option)new Some((Object)"east-1"), (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersWithOverlappedRackConstraintsByConstraintWithRackMixingSupport$2(int x$8) {
        return new BrokerMetadata(x$8, (Option)new Some((Object)"east-2"), (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraintInvalidCount$1(int x$9) {
        return new BrokerMetadata(x$9, (Option)new Some((Object)"east-1"), (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraintInvalidCount$2(int x$10) {
        return new BrokerMetadata(x$10, (Option)new Some((Object)"east-2"), (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testPartitionBrokersByConstraintInvalidCount$3(int x$11) {
        return new BrokerMetadata(x$11, (Option)new Some((Object)"west-1"), (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testBuildRequiredReplicaCountsAndEligibleBrokersWithRackMixingSupport$1(int x$12) {
        return new BrokerMetadata(x$12, (Option)new Some((Object)"east-1"), (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testBuildRequiredReplicaCountsAndEligibleBrokersWithRackMixingSupport$2(int x$13) {
        return new BrokerMetadata(x$13, (Option)new Some((Object)"east-2"), (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testBuildRequiredReplicaCountsAndEligibleBrokersWithRackMixingSupport$3(int x$14) {
        return new BrokerMetadata(x$14, (Option)new Some((Object)"west-1"), (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testRackUnawareNoConstraintReplicaAssignment$2(int x$15) {
        return new BrokerMetadata(x$15, (Option)None$.MODULE$, (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ void $anonfun$testRackUnawareNoConstraintReplicaAssignment$1(ObserverTest $this, IntRef assignmentFuncsProcessed$1, boolean rackMixingSupport) {
        IndexedSeq brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)x$15 -> ObserverTest.$anonfun$testRackUnawareNoConstraintReplicaAssignment$2(BoxesRunTime.unboxToInt((Object)x$15)));
        int numPartitions = 10;
        int replicationFactor = 3;
        Map assignments = Observer$.MODULE$.getReplicaAssignment((Seq)brokers, (Option)None$.MODULE$, numPartitions, replicationFactor, rackMixingSupport, -1, -1);
        $this.validateRackUnawareReplicaAssignment((IndexedSeq<BrokerMetadata>)brokers, (Map<Object, ReplicaAssignment>)assignments);
        ++assignmentFuncsProcessed$1.elem;
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testRackUnawareReplicaAssignmentWithPlacementConstraintMissing$2(int x$16) {
        return new BrokerMetadata(x$16, (Option)None$.MODULE$, (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ void $anonfun$testRackUnawareReplicaAssignmentWithPlacementConstraintMissing$1(ObserverTest $this, IntRef assignmentFuncsProcessed$2, boolean rackMixingSupport) {
        IndexedSeq brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)x$16 -> ObserverTest.$anonfun$testRackUnawareReplicaAssignmentWithPlacementConstraintMissing$2(BoxesRunTime.unboxToInt((Object)x$16)));
        int numPartitions = 10;
        int replicationFactor = 3;
        Map assignments = Observer$.MODULE$.getReplicaAssignment((Seq)brokers, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)"{\"version\":1, \"replicas\":[{\"count\":3}]}"))), numPartitions, replicationFactor, rackMixingSupport, -1, -1);
        $this.validateRackUnawareReplicaAssignment((IndexedSeq<BrokerMetadata>)brokers, (Map<Object, ReplicaAssignment>)assignments);
        ++assignmentFuncsProcessed$2.elem;
    }

    public static final /* synthetic */ void $anonfun$validateRackUnawareReplicaAssignment$4(Iterable brokerIds) {
        Assertions.assertEquals((int)2, (int)brokerIds.size());
    }

    public static final /* synthetic */ void $anonfun$validateRackUnawareReplicaAssignment$2(Iterable assignedPartitions) {
        assignedPartitions.groupBy((Function1)(JFunction1.mcII.sp & Serializable)brokerId -> brokerId).values().foreach((Function1 & Serializable)brokerIds -> {
            ObserverTest.$anonfun$validateRackUnawareReplicaAssignment$4(brokerIds);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)10, (int)assignedPartitions.size());
        Assertions.assertEquals((int)5, (int)assignedPartitions.toSet().size());
    }

    public static final /* synthetic */ void $anonfun$validateRackUnawareReplicaAssignment$6(Seq brokers) {
        Assertions.assertEquals((int)3, (int)brokers.size());
    }

    public static final /* synthetic */ List $anonfun$testRackAwareNoConstraintReplicaAssignment$1(int id) {
        return (List)package$.MODULE$.List().fill(3, (Function0 & Serializable)() -> new StringBuilder(4).append("rack").append(id).toString());
    }

    public static final /* synthetic */ void $anonfun$testRackAwareNoConstraintReplicaAssignment$6(Seq assignedBrokers) {
        Assertions.assertEquals((int)3, (int)assignedBrokers.toSet().size());
    }

    public static final /* synthetic */ void $anonfun$testRackAwareNoConstraintReplicaAssignment$8(Iterable assignedBrokers) {
        Assertions.assertEquals((int)9, (int)assignedBrokers.toSet().size());
    }

    public static final /* synthetic */ void $anonfun$testRackAwareNoConstraintReplicaAssignment$4(IndexedSeq brokers$1, int numPartitions$1, short replicationFactor$1, IntRef assignmentFuncsProcessed$3, boolean rackMixingSupport) {
        Map assignments = Observer$.MODULE$.getReplicaAssignment((Seq)brokers$1, (Option)None$.MODULE$, numPartitions$1, (int)replicationFactor$1, rackMixingSupport, -1, -1);
        ((IterableOnceOps)assignments.values().map((Function1 & Serializable)x$19 -> x$19.replicas())).foreach((Function1 & Serializable)assignedBrokers -> {
            ObserverTest.$anonfun$testRackAwareNoConstraintReplicaAssignment$6(assignedBrokers);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)((IterableOps)assignments.values().map((Function1 & Serializable)x$20 -> x$20.replicas())).transpose(Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable)assignedBrokers -> {
            ObserverTest.$anonfun$testRackAwareNoConstraintReplicaAssignment$8(assignedBrokers);
            return BoxedUnit.UNIT;
        });
        ++assignmentFuncsProcessed$3.elem;
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testGetReplicaAssignmentHandlesMetadataVersion$1(int id) {
        String rack = new StringBuilder(4).append("rack").append(id / 5 + 1).toString();
        return new BrokerMetadata(id, (Option)new Some((Object)rack), (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ Map $anonfun$testGetReplicaAssignmentHandlesMetadataVersion$2(IndexedSeq brokers$2, String placementJsonWithSyncReplicasAndObserversOnSameRack$1, String placementJsonWithoutSyncReplicasAndObserversOnSameRack$1, boolean rackMixingSupport) {
        if (rackMixingSupport) {
            Observer$.MODULE$.getReplicaAssignment((Seq)brokers$2, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJsonWithSyncReplicasAndObserversOnSameRack$1))), 10, 3, rackMixingSupport, 0, -1);
            return Observer$.MODULE$.getReplicaAssignment((Seq)brokers$2, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJsonWithoutSyncReplicasAndObserversOnSameRack$1))), 10, 3, rackMixingSupport, 0, -1);
        }
        Assertions.assertThrows(InvalidConfigurationException.class, () -> Observer$.MODULE$.getReplicaAssignment((Seq)brokers$2, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJsonWithSyncReplicasAndObserversOnSameRack$1))), 10, 3, rackMixingSupport, 0, -1));
        return Observer$.MODULE$.getReplicaAssignment((Seq)brokers$2, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJsonWithoutSyncReplicasAndObserversOnSameRack$1))), 10, 3, rackMixingSupport, 0, -1);
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$1(int id) {
        String rack = new StringBuilder(4).append("rack").append(id / 5 + 1).toString();
        return new BrokerMetadata(id, (Option)new Some((Object)rack), (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$4(Seq assignedBrokers) {
        Assertions.assertEquals((int)20, (int)assignedBrokers.toSet().size());
        ((IterableOnceOps)assignedBrokers.take(2)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 0 && brokerId <= 4 ? 1 : 0) != 0));
        ((IterableOnceOps)assignedBrokers.slice(2, 4)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 5 && brokerId <= 9 ? 1 : 0) != 0));
        ((IterableOnceOps)assignedBrokers.slice(4, 6)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 10 && brokerId <= 14 ? 1 : 0) != 0));
        ((IterableOnceOps)assignedBrokers.slice(6, 8)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 15 && brokerId <= 19 ? 1 : 0) != 0));
        ((IterableOnceOps)assignedBrokers.slice(8, 10)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 20 && brokerId <= 24 ? 1 : 0) != 0));
        ((IterableOnceOps)assignedBrokers.slice(10, 12)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 0 && brokerId <= 4 ? 1 : 0) != 0));
        ((IterableOnceOps)assignedBrokers.slice(12, 14)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 5 && brokerId <= 9 ? 1 : 0) != 0));
        ((IterableOnceOps)assignedBrokers.slice(14, 16)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 10 && brokerId <= 14 ? 1 : 0) != 0));
        ((IterableOnceOps)assignedBrokers.slice(16, 18)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 15 && brokerId <= 19 ? 1 : 0) != 0));
        ((IterableOnceOps)assignedBrokers.slice(18, 20)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 20 && brokerId <= 24 ? 1 : 0) != 0));
        Assertions.assertEquals((int)assignedBrokers.size(), (int)assignedBrokers.toSet().size());
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$16(Seq observers) {
        ((IterableOnceOps)observers.take(2)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 0 && brokerId <= 4 ? 1 : 0) != 0));
        ((IterableOnceOps)observers.slice(2, 4)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 5 && brokerId <= 9 ? 1 : 0) != 0));
        ((IterableOnceOps)observers.slice(4, 6)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 10 && brokerId <= 14 ? 1 : 0) != 0));
        ((IterableOnceOps)observers.slice(6, 8)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 15 && brokerId <= 19 ? 1 : 0) != 0));
        ((IterableOnceOps)observers.slice(8, 10)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 20 && brokerId <= 24 ? 1 : 0) != 0));
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$25(Iterable brokerIds) {
        Assertions.assertEquals((int)2, (int)brokerIds.size());
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$23(Iterable assignedPartitions) {
        assignedPartitions.groupBy((Function1)(JFunction1.mcII.sp & Serializable)brokerId -> brokerId).values().foreach((Function1 & Serializable)brokerIds -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithRackMixing$25(brokerIds);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testRackAwareWithConstraintReplicaAssignment$1(int id) {
        String rack = new StringBuilder(4).append("rack").append(id / 5 + 1).toString();
        return new BrokerMetadata(id, (Option)new Some((Object)rack), (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignment$4(Seq assignedBrokers) {
        Assertions.assertEquals((int)7, (int)assignedBrokers.toSet().size());
        ((IterableOnceOps)assignedBrokers.take(3)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 0 && brokerId <= 4 ? 1 : 0) != 0));
        ((IterableOnceOps)assignedBrokers.slice(3, 5)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 5 && brokerId <= 9 ? 1 : 0) != 0));
        ((IterableOnceOps)assignedBrokers.slice(5, 7)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 10 && brokerId <= 14 ? 1 : 0) != 0));
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignment$9(Seq observers) {
        Assertions.assertTrue((boolean)observers.forall((Function1)(JFunction1.mcZI.sp & Serializable)observerId -> observerId >= 10 && observerId <= 14), (String)observers.mkString(","));
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignment$14(Iterable brokerIds) {
        Assertions.assertEquals((int)2, (int)brokerIds.size());
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignment$12(Iterable assignedPartitions) {
        assignedPartitions.groupBy((Function1)(JFunction1.mcII.sp & Serializable)brokerId -> brokerId).values().foreach((Function1 & Serializable)brokerIds -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignment$14(brokerIds);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignment$2(IndexedSeq brokers$4, String placementJson$2, IntRef assignmentFuncsProcessed$4, boolean rackMixingSupport) {
        Map partitionAssignment = Observer$.MODULE$.getReplicaAssignment((Seq)brokers$4, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson$2))), 10, 3, rackMixingSupport, -1, -1);
        ((IterableOnceOps)partitionAssignment.values().map((Function1 & Serializable)x$24 -> x$24.replicas())).foreach((Function1 & Serializable)assignedBrokers -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignment$4(assignedBrokers);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)partitionAssignment.values().map((Function1 & Serializable)x$25 -> x$25.observers())).foreach((Function1 & Serializable)observers -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignment$9(observers);
            return BoxedUnit.UNIT;
        });
        ((Iterable)((IterableOps)partitionAssignment.values().map((Function1 & Serializable)x$26 -> x$26.replicas())).transpose(Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable)assignedPartitions -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignment$12(assignedPartitions);
            return BoxedUnit.UNIT;
        });
        ++assignmentFuncsProcessed$4.elem;
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$1(int id) {
        String rack = new StringBuilder(4).append("rack").append(id / 5 + 1).toString();
        return new BrokerMetadata(id, (Option)new Some((Object)rack), (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ boolean $anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$3(Seq expectedObservers$1, ReplicaAssignment x$27) {
        return x$27.observers().equals((Object)expectedObservers$1);
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$6(Seq assignedBrokers) {
        Assertions.assertEquals((int)7, (int)assignedBrokers.toSet().size());
        ((IterableOnceOps)assignedBrokers.take(4)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 0 && brokerId <= 4 ? 1 : 0) != 0));
        ((IterableOnceOps)assignedBrokers.slice(5, 7)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 10 && brokerId <= 14 ? 1 : 0) != 0));
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$10(Seq observers) {
        Assertions.assertTrue((boolean)observers.forall((Function1)(JFunction1.mcZI.sp & Serializable)observerId -> observerId >= 10 && observerId <= 14), (String)observers.mkString(","));
    }

    public static final /* synthetic */ void $anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$2(IndexedSeq brokers$5, String placementJson$3, IntRef assignmentFuncsProcessed$5, boolean rackMixingSupport) {
        Map partitionAssignment = Observer$.MODULE$.getReplicaAssignment((Seq)brokers$5, OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson$3))), 15, 3, rackMixingSupport, 2, 3);
        Seq expectedObservers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{12, 11, 13}));
        Set matchingAssignment = ((IterableOnceOps)partitionAssignment.values().filter((Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$3(expectedObservers, x$27)))).toSet();
        Assertions.assertTrue((boolean)matchingAssignment.nonEmpty(), (String)new StringBuilder(14).append(expectedObservers).append(" not found in ").append(partitionAssignment.values()).toString());
        Set matchingReplicas = (Set)matchingAssignment.map((Function1 & Serializable)x$28 -> (Seq)x$28.replicas().slice(0, 4));
        Seq expectedReplicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1, 3, 4}));
        Assertions.assertTrue((boolean)matchingReplicas.contains((Object)expectedReplicas), (String)new StringBuilder(14).append(expectedReplicas).append(" not found in ").append(matchingAssignment).toString());
        ((IterableOnceOps)partitionAssignment.values().map((Function1 & Serializable)x$29 -> x$29.replicas())).foreach((Function1 & Serializable)assignedBrokers -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$6(assignedBrokers);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)partitionAssignment.values().map((Function1 & Serializable)x$30 -> x$30.observers())).foreach((Function1 & Serializable)observers -> {
            ObserverTest.$anonfun$testRackAwareWithConstraintReplicaAssignmentWithStartIndex$10(observers);
            return BoxedUnit.UNIT;
        });
        ++assignmentFuncsProcessed$5.elem;
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$validatePartitioningSuccess$2(int partitionNumber$1, int brokerId) {
        return new BrokerMetadata(partitionNumber$1 * 5 + brokerId, (Option)new Some((Object)"rack"), (Map)scala.collection.Map$.MODULE$.empty());
    }

    public static final /* synthetic */ IndexedSeq $anonfun$validatePartitioningSuccess$1(int partitionNumber) {
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)brokerId -> ObserverTest.$anonfun$validatePartitioningSuccess$2(partitionNumber, BoxesRunTime.unboxToInt((Object)brokerId)));
    }

    public static final /* synthetic */ void $anonfun$validatePartitioningFailure$1(Seq partitionedBrokers$1) {
        Observer$.MODULE$.validatePartitioning(partitionedBrokers$1);
    }

    public static final /* synthetic */ void $anonfun$validatePartitioningFailureMultiplePartitionsWithRackMixingSupport$1(Seq brokers$6) {
        Observer$.MODULE$.validatePartitioning(brokers$6);
    }

    public static final /* synthetic */ void $anonfun$testValidateTopicPlacementUpdateWithRackMixingSuccess$1(List brokers$7, String placement) {
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placement).get();
        Observer$.MODULE$.validateTopicPlacementUpdate(topicPlacement, (Seq)brokers$7);
    }

    public static final /* synthetic */ InvalidConfigurationException $anonfun$testValidateTopicPlacementUpdateWithRackMixingFailure$1(List brokers$8, String placement) {
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placement).get();
        return (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> Observer$.MODULE$.validateTopicPlacementUpdate(topicPlacement, (Seq)brokers$8));
    }

    public static final /* synthetic */ void $anonfun$testValidateTopicPlacementUpdateWithoutRackMixingSuccess$1(List brokers$9, String placement) {
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placement).get();
        Observer$.MODULE$.validateTopicPlacementUpdate(topicPlacement, (Seq)brokers$9);
    }

    public static final /* synthetic */ InvalidConfigurationException $anonfun$testValidateTopicPlacementUpdateWithoutRackMixingFailure$1(List brokers$10, String placement) {
        TopicPlacement topicPlacement = (TopicPlacement)TopicPlacement.parse((String)placement).get();
        return (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> Observer$.MODULE$.validateTopicPlacementUpdate(topicPlacement, (Seq)brokers$10));
    }

    public ObserverTest() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |{\n      |  \"version\": 1,\n      |  \"replicas\": [{\n      |      \"count\": 3,\n      |      \"constraints\": {\n      |        \"rack\": \"east-1\"\n      |      }\n      |    },\n      |    {\n      |      \"count\": 2,\n      |      \"constraints\": {\n      |        \"rack\": \"east-2\"\n      |      }\n      |    }\n      |  ],\n      |  \"observers\": [{\n      |    \"count\": 2,\n      |    \"constraints\": {\n      |      \"rack\": \"west-1\"\n      |    }\n      |  }]\n      |}"));
        this.topicWithObserverPlacementConstraint = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson)));
        String placementJson2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                          |{\n                          |  \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |      \"rack\": \"east-1\"\n                          |    }\n                          |  }]\n                          |}"));
        this.topicWithObserverPlacementOnSameRackAsSyncReplicaConstraint = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson2)));
        this.topicWithTwoObserverPlacementConstraint = TopicPlacement.parse((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |{\n      |  \"version\": 1,\n      |  \"observers\": [{\n      |      \"count\": 3,\n      |      \"constraints\": {\n      |        \"rack\": \"east-1\"\n      |      }\n      |    },\n      |    {\n      |      \"count\": 2,\n      |      \"constraints\": {\n      |        \"rack\": \"east-2\"\n      |      }\n      |    }\n      |  ],\n      |  \"replicas\": [{\n      |    \"count\": 2,\n      |    \"constraints\": {\n      |      \"rack\": \"west-1\"\n      |    }\n      |  }]\n      |}")));
        this.topicWithTwoObserverAndRackMixingPlacementConstraint = TopicPlacement.parse((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                          |{\n                          |  \"version\": 1,\n                          |  \"observers\": [{\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-1\"\n                          |      }\n                          |    },\n                          |    {\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"east-2\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"replicas\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |      \"rack\": \"east-1\"\n                          |    }\n                          |  }]\n                          |}")));
        String placementJsonWithoutObservers = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |{\n      |  \"version\": 1,\n      |  \"replicas\": [{\n      |      \"count\": 3,\n      |      \"constraints\": {\n      |        \"rack\": \"east-1\"\n      |      }\n      |    },\n      |    {\n      |      \"count\": 2,\n      |      \"constraints\": {\n      |        \"rack\": \"east-2\"\n      |      }\n      |    },\n      |    {\n      |      \"count\": 2,\n      |      \"constraints\": {\n      |        \"rack\": \"west-1\"\n      |      }\n      |    }\n      |  ]\n      |}"));
        this.topicWithoutObserversConstraint = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJsonWithoutObservers)));
        this.allBrokersAttributes = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 9).map((Function1 & Serializable)id -> ObserverTest.$anonfun$allBrokersAttributes$1(BoxesRunTime.unboxToInt((Object)id))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ Object $anonfun$testValidateTopicPlacementUpdateWithRackMixingSuccess$1$adapted(List brokers$7, String placement) {
        ObserverTest.$anonfun$testValidateTopicPlacementUpdateWithRackMixingSuccess$1(brokers$7, placement);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testValidateTopicPlacementUpdateWithoutRackMixingSuccess$1$adapted(List brokers$9, String placement) {
        ObserverTest.$anonfun$testValidateTopicPlacementUpdateWithoutRackMixingSuccess$1(brokers$9, placement);
        return BoxedUnit.UNIT;
    }
}

