/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import kafka.common.ClusterMetadataTopicsSnapshot;
import kafka.common.TopicsMetadataSnapshot;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Option;

public class ClusterMetadataTopicsSnapshotTest {
    private final String topic = "topic";
    private final int partition = 0;
    private final List<Integer> replicas = Arrays.asList(1, 2, 3);
    private final List<Integer> observers = Arrays.asList(4, 5);
    private final List<Integer> isr = Arrays.asList(2, 3);
    private final List<Integer> offlineReplicas = Collections.singletonList(1);
    TopicsMetadataSnapshot.PartitionSnapshot snapshot = new TopicsMetadataSnapshot.PartitionSnapshot(){

        public String topic() {
            return "topic";
        }

        public int partitionId() {
            return 0;
        }

        public int numReplicas() {
            return 3;
        }
    };

    @Test
    public void testPartitionInfoSnapshot() {
        ClusterMetadataTopicsSnapshot clusterSnapshot = new ClusterMetadataTopicsSnapshot(Cluster.empty(), (topic, partitionId) -> {
            if (topic.equals(this.topic) && partitionId == this.partition) {
                return Option.apply((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setPartitionIndex(partitionId).setTopicName(topic).setReplicas(this.replicas).setObservers(this.observers).setOfflineReplicas(this.offlineReplicas).setIsr(this.isr));
            }
            return Option.empty();
        });
        Optional replicaInfoOpt = clusterSnapshot.partitionInfoSnapshot(this.snapshot);
        Assertions.assertTrue((boolean)replicaInfoOpt.isPresent(), (String)"Expected the replica info to be present!");
        ClusterMetadataTopicsSnapshot.ClusterMetadataReplicaInfo receivedReplicaInfo = (ClusterMetadataTopicsSnapshot.ClusterMetadataReplicaInfo)replicaInfoOpt.get();
        Assertions.assertEquals(this.replicas, (Object)receivedReplicaInfo.replicas());
        Assertions.assertEquals(this.observers, (Object)receivedReplicaInfo.observers());
        Assertions.assertEquals(this.offlineReplicas, (Object)receivedReplicaInfo.offlineReplicas());
        Assertions.assertEquals(this.isr, (Object)receivedReplicaInfo.inSyncReplicas());
        Assertions.assertEquals(Optional.empty(), (Object)clusterSnapshot.partitionInfoSnapshot(new TopicsMetadataSnapshot.PartitionSnapshot(){

            public String topic() {
                return "topic-diff";
            }

            public int partitionId() {
                return 10;
            }

            public int numReplicas() {
                return 10;
            }
        }));
    }
}

