/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.common.ReplicaExclusionCache;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.clients.admin.DegradedBrokerComponent;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.Tenant;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005]h\u0001B\u00193\u0001]BQA\u0010\u0001\u0005\u0002}B\u0011B\u0011\u0001A\u0002\u0003\u0007I\u0011A\"\t\u0013\u001d\u0003\u0001\u0019!a\u0001\n\u0003A\u0005\"\u0003(\u0001\u0001\u0004\u0005\t\u0015)\u0003E\u0011\u001dy\u0005A1A\u0005\u0002ACaa\u0016\u0001!\u0002\u0013\t\u0006b\u0002-\u0001\u0005\u0004%\t!\u0017\u0005\u0007S\u0002\u0001\u000b\u0011\u0002.\t\u000f)\u0004!\u0019!C\u0001W\"1a\u000f\u0001Q\u0001\n1Dqa\u001e\u0001C\u0002\u0013\u00051\u000e\u0003\u0004y\u0001\u0001\u0006I\u0001\u001c\u0005\bs\u0002\u0011\r\u0011\"\u0001l\u0011\u0019Q\b\u0001)A\u0005Y\")1\u0010\u0001C\u0001y\"9\u0011\u0011\u0003\u0001\u0005\n\u0005M\u0001bBA\u000e\u0001\u0011%\u0011Q\u0004\u0005\u0007\u0003\u0007\u0002A\u0011\u0001?\t\r\u00055\u0003\u0001\"\u0001}\u0011\u0019\t\t\u0006\u0001C\u0001y\"1\u0011Q\u000b\u0001\u0005\u0002qDa!!\u0017\u0001\t\u0003a\bBBA/\u0001\u0011\u0005A\u0010\u0003\u0004\u0002b\u0001!\t\u0001 \u0005\u0007\u0003K\u0002A\u0011\u0001?\t\r\u0005%\u0004\u0001\"\u0001}\u0011\u0019\ti\u0007\u0001C\u0001y\"1\u0011\u0011\u000f\u0001\u0005\u0002qDa!!\u001e\u0001\t\u0003a\bBBA=\u0001\u0011\u0005A\u0010\u0003\u0004\u0002~\u0001!\t\u0001 \u0005\u0007\u0003\u0003\u0003A\u0011\u0001?\t\r\u0005\u0015\u0005\u0001\"\u0001}\u0011\u0019\tI\t\u0001C\u0001y\"1\u0011Q\u0012\u0001\u0005\u0002qDa!!%\u0001\t\u0003a\bBBAK\u0001\u0011\u0005A\u0010\u0003\u0004\u0002\u001a\u0002!\t\u0001 \u0005\u0007\u0003;\u0003A\u0011\u0001?\t\r\u0005\u0005\u0006\u0001\"\u0001}\u0011\u0019\t)\u000b\u0001C\u0001y\"1\u0011\u0011\u0016\u0001\u0005\u0002qDa!!,\u0001\t\u0003a\bBBAY\u0001\u0011\u0005A\u0010\u0003\u0004\u00026\u0002!\t\u0001 \u0005\u0007\u0003s\u0003A\u0011\u0001?\t\r\u0005u\u0006\u0001\"\u0001}\u0011\u001d\ty\f\u0001C\u0005\u0003\u0003\u0014QcQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u)\u0016\u001cHO\u0003\u00024i\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003U\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001qA\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001!\u0011\u0005\u0005\u0003Q\"\u0001\u001a\u0002\u000f\r|g\u000e^3yiV\tA\t\u0005\u0002B\u000b&\u0011aI\r\u0002\u0012\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$\u0018aC2p]R,\u0007\u0010^0%KF$\"!\u0013'\u0011\u0005eR\u0015BA&;\u0005\u0011)f.\u001b;\t\u000f5\u001b\u0011\u0011!a\u0001\t\u0006\u0019\u0001\u0010J\u0019\u0002\u0011\r|g\u000e^3yi\u0002\na\"\u001a=dYV\u001c\u0018n\u001c8DC\u000eDW-F\u0001R!\t\u0011V+D\u0001T\u0015\t!F'\u0001\u0004d_6lwN\\\u0005\u0003-N\u0013QCU3qY&\u001c\u0017-\u0012=dYV\u001c\u0018n\u001c8DC\u000eDW-A\bfq\u000edWo]5p]\u000e\u000b7\r[3!\u0003\u001d\u0011'o\\6feN,\u0012A\u0017\t\u00047\u000e4gB\u0001/b\u001d\ti\u0006-D\u0001_\u0015\tyf'\u0001\u0004=e>|GOP\u0005\u0002w%\u0011!MO\u0001\ba\u0006\u001c7.Y4f\u0013\t!WMA\u0002TKFT!A\u0019\u001e\u0011\u0005e:\u0017B\u00015;\u0005\rIe\u000e^\u0001\tEJ|7.\u001a:tA\u0005\u0019A\u000f]\u0019\u0016\u00031\u0004\"!\u001c;\u000e\u00039T!\u0001V8\u000b\u0005U\u0002(BA9s\u0003\u0019\t\u0007/Y2iK*\t1/A\u0002pe\u001eL!!\u001e8\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006!A\u000f]\u0019!\u0003\r!\bOM\u0001\u0005iB\u0014\u0004%A\u0002uaN\nA\u0001\u001e94A\u0005)1/\u001a;VaR\t\u0011\n\u000b\u0002\u0010}B\u0019q0!\u0004\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\t1!\u00199j\u0015\u0011\t9!!\u0003\u0002\u000f),\b/\u001b;fe*\u0019\u00111\u0002:\u0002\u000b),h.\u001b;\n\t\u0005=\u0011\u0011\u0001\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!F2sK\u0006$X\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0004\u0013\u0006U\u0001bBA\f!\u0001\u0007\u0011\u0011D\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bcA.dY\u0006!r-\u001a8fe\u0006$XM\u0011:pW\u0016\u0014X\t]8dQN$B!a\b\u0002>AA\u0011\u0011EA\u0014\u0003W\t9$\u0004\u0002\u0002$)\u0019\u0011Q\u0005\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002*\u0005\r\"aA'baB!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022Q\nqa\u00197vgR,'/\u0003\u0003\u00026\u0005=\"A\u0002\"s_.,'\u000fE\u0002:\u0003sI1!a\u000f;\u0005\u0011auN\\4\t\u000f\u0005}\u0012\u00031\u0001\u0002B\u0005y!M]8lKJ\fe\u000eZ#q_\u000eD7\u000fE\u0004\u0002\"\u0005\u001db-a\u000e\u0002\u0001R,7\u000f^+qI\u0006$X\rU1si&$\u0018n\u001c8SKBd\u0017nY1BgNLwM\\7f]R,\u0006\u000fZ1uKN\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e^(oYfD3AEA$!\ry\u0018\u0011J\u0005\u0005\u0003\u0017\n\tA\u0001\u0003UKN$\u0018\u0001\u0011;fgR,\u0006\u000fZ1uKB\u000b'\u000f^5uS>tg)\u001e7m%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$X\u000b\u001d3bi\u0016\u001c(+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;)\u0007M\t9%A&uKN$\b+\u0019:uSRLwN\u001c*fa2L7-Y!tg&<g.\\3oiJ+G/\u001e:og\u0016k\u0007\u000f^=TKFLe\rV8qS\u000e|%\u000fU1si&$\u0018n\u001c8E_\u0016\u001chj\u001c;Fq&\u001cH\u000fK\u0002\u0015\u0003\u000f\na\u000b^3tiB\u000b'\u000f^5uS>tg)\u001e7m%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$(+\u001a;ve:\u001cX)\u001c9us\u0006\u001b8/[4o[\u0016tG/\u00134U_BL7m\u0014:QCJ$\u0018\u000e^5p]\u0012{Wm\u001d(pi\u0016C\u0018n\u001d;)\u0007U\t9%\u0001%uKN$\b+\u0019:uSRLwN\u001c*fa2L7-Y!tg&<g.\\3oi\u001a{'\u000fV8qS\u000e\u0014V\r^;s]N,U\u000e\u001d;z\u001b\u0006\u0004\u0018J\u001a+pa&\u001cGi\\3t\u001d>$X\t_5ti\"\u001aa#a\u0012\u0002\u000fR,7\u000f\u001e)beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$hi\u001c:U_BL7MU3ukJt7/\u0012=qK\u000e$X\r\u001a*fa2L7-Y!tg&<g.\\3oiND3aFA$\u0003y!Xm\u001d;QCJ$\u0018\u000e^5p]J+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000fK\u0002\u0019\u0003\u000f\n\u0011\u0006^3tiJ+\u0017m]:jO:lWM\u001c;Ge>lwJY:feZ,'\u000fV8Ts:\u001c'+\u001a9mS\u000e\f\u0007fA\r\u0002H\u0005AB/Z:u%\u0016lwN^1m\u001f\u001a\u001c\u0016P\\2SKBd\u0017nY1)\u0007i\t9%A\u000buKN$(+Z7pm\u0006dwJZ(cg\u0016\u0014h/\u001a:)\u0007m\t9%A\u001auKN$(+Z7pm\u0006dwJZ(cg\u0016\u0014h/\u001a:B]\u0012l\u0015m[3Ts:\u001c'+\u001a9mS\u000e\f\u0017J\u001c;p\u001f\n\u001cXM\u001d<fe\"\u001aA$a\u0012\u0002SQ,7\u000f\u001e*f[>4\u0018\r\\(g'ft7MU3qY&\u001c\u0017-\u00118e\u001f\n\u001cXM\u001d<fe\u000eC\u0017M\\4fQ\ri\u0012qI\u0001.i\u0016\u001cHOU3bgNLwM\\7f]R\u001cv/\u00199t\u001f\n\u001cXM\u001d<feN\fe\u000eZ*z]\u000e\u0014V\r\u001d7jG\u0006\u001c\bf\u0001\u0010\u0002H\u0005IB/Z:u%\u0016\f7o]5h]R{\u0017\nZ3na>$XM\\2fQ\ry\u0012qI\u0001\u000fi\u0016\u001cHOU3bgNLwM\u001c+pQ\r\u0001\u0013qI\u0001\"i\u0016\u001cHOU3n_ZLgn\u001a*fa2L7-\u0019+be\u001e,Go\u00142tKJ4XM\u001d\u0015\u0004C\u0005\u001d\u0013a\t;fgR\u0004&/\u001a4feJ,GMU3qY&\u001c\u0017-S7cC2\fgnY3NKR\u0014\u0018n\u0019\u0015\u0004E\u0005\u001d\u0013a\b;fgR\u0004&/\u001a4feJ,G\rT3bI\u0016\u0014hi\u001c:QCJ$\u0018\u000e^5p]\"\u001a1%a\u0012\u0002MQ,7\u000f\u001e)sK\u001a,'O]3e\u0019\u0016\fG-\u001a:XSRDG)Z4sC\u0012,GM\u0011:pW\u0016\u00148\u000fK\u0002%\u0003\u000f\n!\u0005^3tiB\u000b'\u000f^5uS>t7oV5uQ2+\u0017\rZ3sg>s'I]8lKJ\u001c\bfA\u0013\u0002H\u0005YC/Z:u!\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i!J,g-\u001a:sK\u0012dU-\u00193feN|eN\u0011:pW\u0016\u00148\u000fK\u0002'\u0003\u000f\n\u0011\u0004^3tiN+G\u000fR3he\u0006$W\r\u001a\"s_.,'/\u00138g_\"\u001aq%a\u0012\u0002\u001dQ,7\u000f^+qI\u0006$XmQ3mY\"\u001a\u0001&a\u0012\u0002\u001dQ,7\u000f\u001e*f[>4XmQ3mY\"\u001a\u0011&a\u0012\u00027Q,7\u000f\u001e$vY2LX\u000b\u001d3bi\u0016\u001cU\r\u001c7JIR{7)\u001a7mQ\rQ\u0013qI\u0001\u0011i\u0016\u001cH/\u00169eCR,G+\u001a8b]RD3aKA$\u0003a!Xm\u001d;Va\u0012\fG/\u001a+f]\u0006tG/\u00134BEN,g\u000e\u001e\u0015\u0004Y\u0005\u001d\u0013\u0001\u0005;fgR\u0014V-\\8wKR+g.\u00198uQ\ri\u0013qI\u0001 i\u0016\u001cHOR;mYf,\u0006\u000fZ1uKR+g.\u00198u\u0013\u0012$v\u000eV3oC:$\bf\u0001\u0018\u0002H\u0005aD/Z:u!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006LUNY1mC:\u001cW-T3ue&\u001cwJ\\\"p]\u000e,(O]3oiR{\u0007/[2EK2,G/[8o\u0003)\u0019'/Z1uK\u000e+G\u000e\u001c\u000b\r\u0003\u0007\fI-!4\u0002`\u0006%\u00181\u001f\t\u0004[\u0006\u0015\u0017bAAd]\n!1)\u001a7m\u0011\u0019\tY\r\ra\u0001M\u000611-\u001a7m\u0013\u0012Da\u0001\u0017\u0019A\u0002\u0005=\u0007#BAi\u000334g\u0002BAj\u0003+\u0004\"!\u0018\u001e\n\u0007\u0005]'(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00037\fiNA\u0002TKRT1!a6;\u0011\u001d\t\t\u000f\ra\u0001\u0003G\fQa\u001d;bi\u0016\u00042!\\As\u0013\r\t9O\u001c\u0002\n\u0007\u0016dGn\u0015;bi\u0016Dq!a;1\u0001\u0004\ti/A\u0004nS:\u001c\u0016N_3\u0011\u0007e\ny/C\u0002\u0002rj\u0012Qa\u00155peRDq!!>1\u0001\u0004\ti/A\u0004nCb\u001c\u0016N_3")
public class ControllerContextTest {
    private ControllerContext context;
    private final ReplicaExclusionCache exclusionCache = new ReplicaExclusionCache();
    private final scala.collection.immutable.Seq<Object> brokers = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
    private final TopicPartition tp1 = new TopicPartition("A", 0);
    private final TopicPartition tp2 = new TopicPartition("A", 1);
    private final TopicPartition tp3 = new TopicPartition("B", 0);

    public ControllerContext context() {
        return this.context;
    }

    public void context_$eq(ControllerContext x$1) {
        this.context = x$1;
    }

    public ReplicaExclusionCache exclusionCache() {
        return this.exclusionCache;
    }

    public scala.collection.immutable.Seq<Object> brokers() {
        return this.brokers;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public TopicPartition tp3() {
        return this.tp3;
    }

    @BeforeEach
    public void setUp() {
        this.context_$eq(new ControllerContext());
        Map<Broker, Object> brokerEpochs = this.generateBrokerEpochs((Map<Object, Object>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToLong((long)1L))}))));
        this.context().setLiveBrokers(brokerEpochs);
        this.createTopicPartitions((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)this.tp1(), (List)new .colon.colon((Object)this.tp2(), (List)new .colon.colon((Object)this.tp3(), (List)Nil$.MODULE$))));
    }

    private void createTopicPartitions(scala.collection.immutable.Seq<TopicPartition> partitions) {
        IntRef leaderIndex = IntRef.create((int)0);
        partitions.foreach((Function1 & Serializable)partition -> {
            ControllerContextTest.$anonfun$createTopicPartitions$1(this, leaderIndex, partition);
            return BoxedUnit.UNIT;
        });
    }

    private Map<Broker, Object> generateBrokerEpochs(Map<Object, Object> brokerAndEpochs) {
        return (Map)brokerAndEpochs.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int brokerId = x0$1._1$mcI$sp();
                long brokerEpoch = x0$1._2$mcJ$sp();
                EndPoint endpoint = new EndPoint("localhost", 9900 + brokerId, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(brokerId, (Seq)new .colon.colon((Object)endpoint, (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)brokerEpoch));
            }
            throw new MatchError(null);
        });
    }

    @Test
    public void testUpdatePartitionReplicaAssignmentUpdatesReplicaAssignmentOnly() {
        scala.collection.immutable.Seq expectedReplicas = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4}));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)expectedReplicas, (Seq)package$.MODULE$.Seq().empty()));
        Seq assignment = this.context().partitionReplicaAssignment(this.tp1());
        ReplicaAssignment fullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assertions.assertEquals((Object)expectedReplicas, (Object)assignment);
        Assertions.assertEquals((Object)expectedReplicas, (Object)fullAssignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)fullAssignment.addingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)fullAssignment.removingReplicas());
    }

    @Test
    public void testUpdatePartitionFullReplicaAssignmentUpdatesReplicaAssignment() {
        scala.collection.immutable.Seq initialReplicas = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4}));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)initialReplicas, (Seq)package$.MODULE$.Seq().empty()));
        ReplicaAssignment fullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assertions.assertEquals((Object)initialReplicas, (Object)fullAssignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)fullAssignment.addingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)fullAssignment.removingReplicas());
        ReplicaAssignment expectedFullAssignment = new ReplicaAssignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), (Seq)package$.MODULE$.Seq().empty(), (Option)new Some((Object)package$.MODULE$.Seq().empty()));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), expectedFullAssignment);
        ReplicaAssignment updatedFullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assertions.assertEquals((Object)expectedFullAssignment.replicas(), (Object)updatedFullAssignment.replicas());
        Assertions.assertEquals((Object)expectedFullAssignment.addingReplicas(), (Object)updatedFullAssignment.addingReplicas());
        Assertions.assertEquals((Object)expectedFullAssignment.removingReplicas(), (Object)updatedFullAssignment.removingReplicas());
    }

    @Test
    public void testPartitionReplicaAssignmentReturnsEmptySeqIfTopicOrPartitionDoesNotExist() {
        Seq noTopicReplicas = this.context().partitionReplicaAssignment(new TopicPartition("NONEXISTENT", 0));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)noTopicReplicas);
        Seq noPartitionReplicas = this.context().partitionReplicaAssignment(new TopicPartition("A", 100));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)noPartitionReplicas);
    }

    @Test
    public void testPartitionFullReplicaAssignmentReturnsEmptyAssignmentIfTopicOrPartitionDoesNotExist() {
        ReplicaAssignment expectedEmptyAssignment = ReplicaAssignment$.MODULE$.empty();
        ReplicaAssignment noTopicAssignment = this.context().partitionFullReplicaAssignment(new TopicPartition("NONEXISTENT", 0));
        Assertions.assertEquals((Object)expectedEmptyAssignment, (Object)noTopicAssignment);
        ReplicaAssignment noPartitionAssignment = this.context().partitionFullReplicaAssignment(new TopicPartition("A", 100));
        Assertions.assertEquals((Object)expectedEmptyAssignment, (Object)noPartitionAssignment);
    }

    @Test
    public void testPartitionReplicaAssignmentForTopicReturnsEmptyMapIfTopicDoesNotExist() {
        Assertions.assertEquals((Object)Map$.MODULE$.empty(), (Object)this.context().partitionReplicaAssignmentForTopic("NONEXISTENT"));
    }

    @Test
    public void testPartitionReplicaAssignmentForTopicReturnsExpectedReplicaAssignments() {
        Map expectedAssignments = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1()), (Object)this.context().partitionReplicaAssignment(this.tp1())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2()), (Object)this.context().partitionReplicaAssignment(this.tp2()))}));
        Map receivedAssignments = this.context().partitionReplicaAssignmentForTopic("A");
        Assertions.assertEquals((Object)expectedAssignments, (Object)receivedAssignments);
    }

    @Test
    public void testPartitionReplicaAssignment() {
        ReplicaAssignment reassigningPartition = new ReplicaAssignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 5, 6})), (Seq)package$.MODULE$.Seq().empty(), (Option)new Some((Object)package$.MODULE$.Seq().empty()));
        Assertions.assertTrue((boolean)reassigningPartition.isBeingReassigned());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Seq)package$.MODULE$.Seq().empty())), (Object)reassigningPartition.targetAssignment());
        ReplicaAssignment reassigningPartition2 = new ReplicaAssignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)Nil$.MODULE$, (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 4})), (Seq)package$.MODULE$.Seq().empty(), (Option)new Some((Object)package$.MODULE$.Seq().empty()));
        Assertions.assertTrue((boolean)reassigningPartition2.isBeingReassigned());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), (Seq)package$.MODULE$.Seq().empty())), (Object)reassigningPartition2.targetAssignment());
        ReplicaAssignment reassigningPartition3 = new ReplicaAssignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), (Seq)package$.MODULE$.Seq().empty(), (Option)new Some((Object)package$.MODULE$.Seq().empty()));
        Assertions.assertTrue((boolean)reassigningPartition3.isBeingReassigned());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), (Seq)package$.MODULE$.Seq().empty())), (Object)reassigningPartition3.targetAssignment());
        ReplicaAssignment partition = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)package$.MODULE$.Seq().empty());
        Assertions.assertFalse((boolean)partition.isBeingReassigned());
        Assertions.assertEquals((Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)package$.MODULE$.Seq().empty()), (Object)partition.targetReplicaAssignment());
        ReplicaAssignment reassigningPartition4 = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.Seq().empty()).reassignTo(new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3})), (Seq)package$.MODULE$.Seq().empty()));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3, 1})), (Object)reassigningPartition4.replicas());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3})), (Seq)package$.MODULE$.Seq().empty())), (Object)reassigningPartition4.targetAssignment());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5})), (Object)reassigningPartition4.addingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Object)reassigningPartition4.removingReplicas());
        Assertions.assertTrue((boolean)reassigningPartition4.isBeingReassigned());
        ReplicaAssignment reassigningPartition5 = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty()).reassignTo(new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)package$.MODULE$.Seq().empty()));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Object)reassigningPartition5.replicas());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)package$.MODULE$.Seq().empty())), (Object)reassigningPartition5.targetAssignment());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Object)reassigningPartition5.addingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)reassigningPartition5.removingReplicas());
        Assertions.assertTrue((boolean)reassigningPartition5.isBeingReassigned());
        ReplicaAssignment nonReassigningPartition = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty()).reassignTo(new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Seq)package$.MODULE$.Seq().empty()));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Object)nonReassigningPartition.replicas());
        Assertions.assertEquals((Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Seq)package$.MODULE$.Seq().empty()), (Object)nonReassigningPartition.targetReplicaAssignment());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)nonReassigningPartition.addingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)nonReassigningPartition.removingReplicas());
        Assertions.assertFalse((boolean)nonReassigningPartition.isBeingReassigned());
    }

    @Test
    public void testReassignmentFromObserverToSyncReplica() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$);
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfSyncReplica() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 4, 2, 3})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4})), (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfObserver() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4})), (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfObserverAndMakeSyncReplicaIntoObserver() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4})), (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfSyncReplicaAndObserverChange() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2, 3})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 1, 2, 3})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testReassignmentSwapsObserversAndSyncReplicas() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 1, 2})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 1, 2})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)reassignment.effectiveObservers());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.removingReplicas());
    }

    @Test
    public void testReassignToIdempotence() {
        ReplicaAssignment assignment1 = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty());
        Assertions.assertEquals((Object)assignment1, (Object)assignment1.reassignTo(new ReplicaAssignment.Assignment(assignment1.replicas(), assignment1.observers())));
        ReplicaAssignment assignment2 = new ReplicaAssignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$));
        Assertions.assertEquals((Object)assignment2, (Object)assignment2.reassignTo((ReplicaAssignment.Assignment)assignment2.targetAssignment().get()));
        ReplicaAssignment assignment3 = new ReplicaAssignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2, 3, 1})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$));
        Assertions.assertEquals((Object)assignment3, (Object)assignment3.reassignTo((ReplicaAssignment.Assignment)assignment3.targetAssignment().get()));
    }

    @Test
    public void testReassignTo() {
        ReplicaAssignment assignment = ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty());
        ReplicaAssignment firstReassign = assignment.reassignTo(new ReplicaAssignment.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)package$.MODULE$.Seq().empty()));
        Assertions.assertEquals((Object)new ReplicaAssignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty(), (Option)new Some((Object)package$.MODULE$.Seq().empty())), (Object)firstReassign);
        Assertions.assertEquals((Object)new ReplicaAssignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9, 1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty(), (Option)new Some((Object)package$.MODULE$.Seq().empty())), (Object)firstReassign.reassignTo(new ReplicaAssignment.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)package$.MODULE$.Seq().empty())));
        Assertions.assertEquals((Object)new ReplicaAssignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9, 1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty(), (Option)new Some((Object)package$.MODULE$.Seq().empty())), (Object)assignment.reassignTo(new ReplicaAssignment.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)package$.MODULE$.Seq().empty())));
        Assertions.assertEquals((Object)assignment, (Object)firstReassign.reassignTo(new ReplicaAssignment.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty())));
    }

    @Test
    public void testRemovingReplicaTargetObserver() {
        Assertions.assertEquals((Object)new ReplicaAssignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Seq)package$.MODULE$.Seq().empty(), (Option)new Some((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})))).removeReplica(3), (Object)new ReplicaAssignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Seq)package$.MODULE$.Seq().empty(), (Option)new Some((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})))));
    }

    @Test
    public void testPreferredReplicaImbalanceMetric() {
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty()));
        this.context().updatePartitionFullReplicaAssignment(this.tp2(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty()));
        this.context().updatePartitionFullReplicaAssignment(this.tp3(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty()));
        this.context().putPartitionLeadershipInfo(this.tp1(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        this.context().putPartitionLeadershipInfo(this.tp2(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        this.context().putPartitionLeadershipInfo(this.tp3(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp1(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp2(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(2, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 1}))), 0));
        Assertions.assertEquals((int)1, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp3(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(3, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 2}))), 0));
        Assertions.assertEquals((int)2, (int)this.context().preferredReplicaImbalanceCount());
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), (Seq)package$.MODULE$.Seq().empty()));
        this.context().updatePartitionFullReplicaAssignment(this.tp2(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), (Seq)package$.MODULE$.Seq().empty()));
        Assertions.assertEquals((int)2, (int)this.context().preferredReplicaImbalanceCount());
        this.context().queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.tp3().topic()})));
        Assertions.assertEquals((int)1, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp3(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 2}))), 0));
        Assertions.assertEquals((int)1, (int)this.context().preferredReplicaImbalanceCount());
        this.context().removeTopic(this.tp1().topic());
        this.context().removeTopic(this.tp2().topic());
        this.context().removeTopic(this.tp3().topic());
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
    }

    @Test
    public void testPreferredLeaderForPartition() {
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty()));
        Assertions.assertEquals((int)1, (int)this.context().preferredLeaderForPartition(this.tp1()));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), (Seq)package$.MODULE$.Seq().empty()));
        Assertions.assertEquals((int)2, (int)this.context().preferredLeaderForPartition(this.tp1()));
    }

    @Test
    public void testPreferredLeaderWithDegradedBrokers() {
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty()));
        Assertions.assertEquals((int)1, (int)this.context().preferredLeaderForPartition(this.tp1()));
        this.context().setDegradedBrokerComponent(1, ComponentHealthStatus.DEGRADED, new DegradedBrokerComponent("reason", BrokerComponent.UNSPECIFIED.id()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Object)this.context().degradedBrokerIds());
        Assertions.assertEquals((int)1, (int)this.context().preferredLeaderForPartition(this.tp1()));
    }

    @Test
    public void testPartitionsWithLeadersOnBrokers() {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1()})), (Object)this.context().partitionsWithLeadersOnGivenBrokers((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))));
        this.context().putPartitionLeadershipInfo(this.tp1(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(2, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.tp2()})), (Object)this.context().partitionsWithLeadersOnGivenBrokers((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}))));
        String topic = "large topic";
        this.createTopicPartitions((scala.collection.immutable.Seq<TopicPartition>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable)i -> ControllerContextTest.$anonfun$testPartitionsWithLeadersOnBrokers$1(topic, BoxesRunTime.unboxToInt((Object)i))));
        Assertions.assertEquals((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 33).map((Function1 & Serializable)i -> ControllerContextTest.$anonfun$testPartitionsWithLeadersOnBrokers$2(topic, BoxesRunTime.unboxToInt((Object)i))).toSet(), (Object)this.context().partitionsWithLeadersOnGivenBrokers((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))));
    }

    @Test
    public void testPartitionsWithPreferredLeadersOnBrokers() {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1()})), (Object)this.context().partitionsWithPreferredLeadersOnGivenBrokers((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))));
        this.context().putPartitionLeadershipInfo(this.tp1(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(2, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1()})), (Object)this.context().partitionsWithPreferredLeadersOnGivenBrokers((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))));
    }

    @Test
    public void testSetDegradedBrokerInfo() {
        this.context().setDegradedBrokerComponent(1, ComponentHealthStatus.DEGRADED, new DegradedBrokerComponent("reason", BrokerComponent.UNSPECIFIED.id()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Object)this.context().degradedBrokerIds());
        this.context().setDegradedBrokerComponent(2, ComponentHealthStatus.DEGRADED, new DegradedBrokerComponent("reason", BrokerComponent.UNSPECIFIED.id()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)this.context().degradedBrokerIds());
        Assertions.assertEquals((Object)((SetOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)).$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{new DegradedBrokerComponent("reason", BrokerComponent.UNSPECIFIED.id())}))), (Object)this.context().degradedBrokerComponents(1).getOrElse((Function0 & Serializable)() -> (scala.collection.mutable.Set)Set$.MODULE$.empty()));
        Assertions.assertEquals((Object)((SetOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)).$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DegradedBrokerComponent[]{new DegradedBrokerComponent("reason", BrokerComponent.UNSPECIFIED.id())}))), (Object)this.context().degradedBrokerComponents(2).getOrElse((Function0 & Serializable)() -> (scala.collection.mutable.Set)Set$.MODULE$.empty()));
        this.context().setDegradedBrokerComponent(1, ComponentHealthStatus.HEALTHY, new DegradedBrokerComponent("reason", BrokerComponent.UNSPECIFIED.id()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), (Object)this.context().degradedBrokerIds());
    }

    @Test
    public void testUpdateCell() {
        Cell cell = this.createCell(0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.READY, (short)3, (short)6);
        this.context().updateCell(cell);
        Assertions.assertEquals((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)cell.cellId())), (Object)cell)})), (Object)this.context().cellIdToCell());
    }

    @Test
    public void testRemoveCell() {
        Cell cell = this.createCell(0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.READY, (short)3, (short)6);
        this.context().updateCell(cell);
        this.context().removeCell(cell.cellId());
        Assertions.assertEquals((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)this.context().cellIdToCell());
    }

    @Test
    public void testFullyUpdateCellIdToCell() {
        Map cellIdToCell = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.createCell(0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), CellState.READY, (short)3, (short)6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.createCell(1, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4}))), CellState.EXCLUDED, (short)1, (short)2))}));
        this.context().fullyUpdateCellIdToCell(cellIdToCell);
        Assertions.assertEquals((Object)cellIdToCell, (Object)this.context().cellIdToCell());
        Map newCellIdToCell = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.createCell(0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}))), CellState.QUARANTINED, (short)5, (short)10))}));
        this.context().fullyUpdateCellIdToCell(newCellIdToCell);
        Assertions.assertEquals((Object)newCellIdToCell, (Object)this.context().cellIdToCell());
    }

    @Test
    public void testUpdateTenant() {
        Tenant tenant = new Tenant("lkc-abcd", 0);
        this.context().updateTenant(tenant);
        Assertions.assertEquals((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tenant.tenantId()), (Object)tenant)})), (Object)this.context().tenantIdToTenant());
    }

    @Test
    public void testUpdateTenantIfAbsent() {
        Tenant tenant = new Tenant("lkc-abcd", 0);
        this.context().updateTenantIfAbsent(tenant);
        Assertions.assertEquals((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tenant.tenantId()), (Object)tenant)})), (Object)this.context().tenantIdToTenant());
        this.context().updateTenantIfAbsent(new Tenant("lkc-abcd", 1));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tenant.tenantId()), (Object)tenant)})), (Object)this.context().tenantIdToTenant());
    }

    @Test
    public void testRemoveTenant() {
        Tenant tenant = new Tenant("lkc-abcd", 0);
        this.context().updateTenant(tenant);
        this.context().removeTenant(tenant.tenantId());
        Assertions.assertEquals((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)this.context().tenantIdToTenant());
    }

    @Test
    public void testFullyUpdateTenantIdToTenant() {
        Map tenantIdToTenant = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lkc-abcd"), (Object)new Tenant("lkc-abcd", 0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lkc-wxyz"), (Object)new Tenant("lkc-wxyz", 1))}));
        this.context().fullyUpdateTenantIdToTenant(tenantIdToTenant);
        Assertions.assertEquals((Object)tenantIdToTenant, (Object)this.context().tenantIdToTenant());
        Map newTenantIdToTenant = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lkc-abcd"), (Object)new Tenant("lkc-abcd", 900))}));
        this.context().fullyUpdateTenantIdToTenant(newTenantIdToTenant);
        Assertions.assertEquals((Object)newTenantIdToTenant, (Object)this.context().tenantIdToTenant());
    }

    public void testPreferredReplicaImbalanceMetricOnConcurrentTopicDeletion() {
        String topicA = "A";
        String topicB = "B";
        TopicPartition tpA = new TopicPartition(topicA, 0);
        TopicPartition tpB = new TopicPartition(topicB, 0);
        this.context().updatePartitionFullReplicaAssignment(tpA, ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty()));
        this.context().updatePartitionFullReplicaAssignment(tpB, ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().empty()));
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
        this.context().queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicA})));
        this.context().putPartitionLeadershipInfo(tpA, new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
        this.context().queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicA, topicB})));
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
    }

    private Cell createCell(int cellId, scala.collection.immutable.Set<Object> brokers, CellState state, short minSize, short maxSize) {
        return new Cell(cellId, CollectionConverters$.MODULE$.SetHasAsJava((Set)brokers.map((Function1 & Serializable)b -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)b)))).asJava(), state, minSize, maxSize);
    }

    public static final /* synthetic */ void $anonfun$createTopicPartitions$1(ControllerContextTest $this, IntRef leaderIndex$1, TopicPartition partition) {
        IndexedSeq replicas = $this.brokers().indices().map((Function1)(JFunction1.mcII.sp & Serializable)i -> BoxesRunTime.unboxToInt((Object)$this.brokers().apply((i + leaderIndex$1.elem) % $this.brokers().size())));
        $this.context().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)replicas, (Seq)package$.MODULE$.Seq().empty()));
        $this.context().putPartitionLeadershipInfo(partition, new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)replicas.head()), replicas.toList()), 0));
        ++leaderIndex$1.elem;
    }

    public static final /* synthetic */ TopicPartition $anonfun$testPartitionsWithLeadersOnBrokers$1(String topic$1, int i) {
        return new TopicPartition(topic$1, i);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testPartitionsWithLeadersOnBrokers$2(String topic$1, int i) {
        return new TopicPartition(topic$1, i * 3);
    }
}

