/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.catalog.ZKMetadataCollector;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.MockPartitionStateMachine;
import kafka.controller.MockReplicaStateMachine;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.state.TierPartitionState;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001B\n\u0015\u0001eAQ\u0001\t\u0001\u0005\u0002\u0005Bq\u0001\n\u0001C\u0002\u0013%Q\u0005\u0003\u0004*\u0001\u0001\u0006IA\n\u0005\bU\u0001\u0011\r\u0011\"\u0003,\u0011\u0019\u0011\u0004\u0001)A\u0005Y!91\u0007\u0001b\u0001\n\u0013!\u0004B\u0002\u001d\u0001A\u0003%Q\u0007C\u0003:\u0001\u0011\u0005!\bC\u0003L\u0001\u0011\u0005!\bC\u0003Q\u0001\u0011\u0005!\bC\u0003S\u0001\u0011\u0005!\bC\u0003U\u0001\u0011\u0005!\bC\u0003W\u0001\u0011\u0005!\bC\u0003Y\u0001\u0011\u0005!\bC\u0003[\u0001\u0011\u0005!\bC\u0003]\u0001\u0011\u0005!\bC\u0003_\u0001\u0011\u0005q\fC\u0005\u0002\u0010\u0001\t\n\u0011\"\u0001\u0002\u0012\tABk\u001c9jG\u0012+G.\u001a;j_:l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005U1\u0012AC2p]R\u0014x\u000e\u001c7fe*\tq#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002)\u0005A!M]8lKJLE-F\u0001'!\tYr%\u0003\u0002)9\t\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013AB2p]\u001aLw-F\u0001-!\ti\u0003'D\u0001/\u0015\tyc#\u0001\u0004tKJ4XM]\u0005\u0003c9\u00121bS1gW\u0006\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013A\u00043fY\u0016$\u0018n\u001c8DY&,g\u000e^\u000b\u0002kA\u00111EN\u0005\u0003oQ\u0011a\u0002R3mKRLwN\\\"mS\u0016tG/A\beK2,G/[8o\u00072LWM\u001c;!\u0003!!X-\u0019:e_^tG#A\u001e\u0011\u0005ma\u0014BA\u001f\u001d\u0005\u0011)f.\u001b;)\u0005!y\u0004C\u0001!J\u001b\u0005\t%B\u0001\"D\u0003\r\t\u0007/\u001b\u0006\u0003\t\u0016\u000bqA[;qSR,'O\u0003\u0002G\u000f\u0006)!.\u001e8ji*\t\u0001*A\u0002pe\u001eL!AS!\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u0005;fgRLe.\u001b;jC2L'0\u0019;j_:D#!C'\u0011\u0005\u0001s\u0015BA(B\u0005\u0011!Vm\u001d;\u0002#Q,7\u000f\u001e\"bg&\u001cG)\u001a7fi&|g\u000e\u000b\u0002\u000b\u001b\u0006qB/Z:u\u0005\u0006\u001c\u0018n\u0019#fY\u0016$\u0018n\u001c8PMRKWM]3e)>\u0004\u0018n\u0019\u0015\u0003\u00175\u000bA\u0005^3ti\u0016C8-\u001a9uS>tw\u000b[3o\t\u0016dW\r^5oORKWM]3e)>\u0004\u0018n\u0019\u0015\u0003\u00195\u000b\u0011\u0005^3ti\u0012+G.\u001a;j_:$UO]5oONCW\u000f\u001e3po:\u0004&o\\2fgND#!D'\u0002;Q,7\u000f\u001e#fY\u0016$\u0018n\u001c8XSRD'I]8lKJ|eM\u001a7j]\u0016D#AD'\u0002KQ,7\u000f\u001e\"s_.,'OR1jYV\u0014X-\u00114uKJ$U\r\\3uS>t7\u000b^1si\u0016$\u0007FA\bN\u0003\u0001\"Xm\u001d;Nk2$\u0018\u000e\u001d7f)&,'/\u001a3U_BL7\rR3mKRLwN\\:)\u0005Ai\u0015aC5oSR\u001cuN\u001c;fqR$\u0002\u0002Y2r}\u0006\u0005\u0011Q\u0001\t\u0003G\u0005L!A\u0019\u000b\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000fC\u0003e#\u0001\u0007Q-A\u0004ce>\\WM]:\u0011\u0007\u0019tgE\u0004\u0002hY:\u0011\u0001n[\u0007\u0002S*\u0011!\u000eG\u0001\u0007yI|w\u000e\u001e \n\u0003uI!!\u001c\u000f\u0002\u000fA\f7m[1hK&\u0011q\u000e\u001d\u0002\u0004'\u0016\f(BA7\u001d\u0011\u0015\u0011\u0018\u00031\u0001t\u0003\u0019!x\u000e]5dgB\u0019A\u000f_>\u000f\u0005U4\bC\u00015\u001d\u0013\t9H$\u0001\u0004Qe\u0016$WMZ\u0005\u0003sj\u00141aU3u\u0015\t9H\u0004\u0005\u0002uy&\u0011QP\u001f\u0002\u0007'R\u0014\u0018N\\4\t\u000b}\f\u0002\u0019\u0001\u0014\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011\u0019\t\u0019!\u0005a\u0001M\u0005\t\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\t\u0013\u0005\u001d\u0011\u0003%AA\u0002\u0005%\u0011AC1eIR{\u0007/[2JIB\u00191$a\u0003\n\u0007\u00055ADA\u0004C_>dW-\u00198\u0002+%t\u0017\u000e^\"p]R,\u0007\u0010\u001e\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u00111\u0003\u0016\u0005\u0003\u0013\t)b\u000b\u0002\u0002\u0018A!\u0011\u0011DA\u0012\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011!C;oG\",7m[3e\u0015\r\t\t\u0003H\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0013\u00037\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class TopicDeletionManagerTest {
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
    private final DeletionClient deletionClient = (DeletionClient)Mockito.mock(DeletionClient.class);

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private DeletionClient deletionClient() {
        return this.deletionClient;
    }

    @AfterEach
    public void teardown() {
        Mockito.framework().clearInlineMocks();
    }

    @Test
    public void testInitialization() {
        ControllerContext controllerContext = this.initContext((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar", "baz"}))), 2, 3, this.initContext$default$5());
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false, true);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)None$.MODULE$, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "baz"})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Object)controllerContext.topicsToBeDeleted().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar"})), (Object)controllerContext.topicsIneligibleForDeletion().toSet());
    }

    @Test
    public void testBasicDeletion() {
        ControllerContext controllerContext = this.initContext((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, this.initContext$default$5());
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false, true);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)None$.MODULE$, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        Set barPartitions = controllerContext.partitionsForTopic("bar");
        scala.collection.immutable.Set barReplicas = controllerContext.replicasForPartition(barPartitions).toSet();
        replicaStateMachine.clear();
        partitionStateMachine.clear();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})));
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        Assertions.assertEquals((Object)barPartitions, (Object)controllerContext.partitionsInState("bar", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)barReplicas, (Object)controllerContext.replicasInState("bar", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate((Set)fooPartitions.$plus$plus((IterableOnce)barPartitions));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.completeReplicaDeletion((Set)fooReplicas.$plus$plus((IterableOnce)barReplicas));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("foo"));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testBasicDeletion$1(x$1))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("bar"));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testBasicDeletion$2(x$2))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        Assertions.assertEquals((int)1, (int)partitionStateMachine.stateChangesCalls((PartitionState)OfflinePartition$.MODULE$));
        Assertions.assertEquals((int)1, (int)partitionStateMachine.stateChangesCalls((PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((int)1, (int)replicaStateMachine.stateChangesCalls((ReplicaState)ReplicaDeletionIneligible$.MODULE$));
        Assertions.assertEquals((int)1, (int)replicaStateMachine.stateChangesCalls((ReplicaState)OfflineReplica$.MODULE$));
        Assertions.assertEquals((int)1, (int)replicaStateMachine.stateChangesCalls((ReplicaState)ReplicaDeletionStarted$.MODULE$));
        Assertions.assertEquals((int)1, (int)replicaStateMachine.stateChangesCalls((ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBasicDeletionOfTieredTopic() {
        Properties brokerProperties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        brokerProperties.put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(brokerProperties);
        new Properties().setProperty("confluent.tier.enable", "true");
        ControllerContext controllerContext = this.initContext((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, true);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        CompletableFuture<TierPartitionState.AppendResult> future = new CompletableFuture<TierPartitionState.AppendResult>();
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(future);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false, true);
        partitionStateMachine.startup();
        ZKMetadataCollector zkMetadataCollector = (ZKMetadataCollector)Mockito.mock(ZKMetadataCollector.class);
        TopicDeletionManager deletionManager = new TopicDeletionManager(config, controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)new Some((Object)tierTopicManager), (Option)new Some((Object)zkMetadataCollector));
        Assertions.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate(fooPartitions);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.completeReplicaDeletion((Set)fooReplicas);
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})));
        AtomicInteger finishInvoked = new AtomicInteger(0);
        this.deletionClient().completeDeleteTopic((String)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(null, deletionManager, finishInvoked){
            private final TopicDeletionManager deletionManager$1;
            private final AtomicInteger finishInvoked$1;

            public void answer(InvocationOnMock invocation) {
                this.deletionManager$1.finishTopicDelete((String)invocation.getArgument(0));
                this.finishInvoked$1.getAndIncrement();
            }
            {
                this.deletionManager$1 = deletionManager$1;
                this.finishInvoked$1 = finishInvoked$1;
            }
        });
        future.complete(TierPartitionState.AppendResult.ACCEPTED);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicDeletionManagerTest.$anonfun$testBasicDeletionOfTieredTopic$1(finishInvoked)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for deletion to be completed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)1, (int)finishInvoked.get());
        ((DeletionClient)Mockito.verify((Object)this.deletionClient(), (VerificationMode)Mockito.times((int)1))).completeDeleteTopic("foo");
        ((DeletionClient)Mockito.verify((Object)this.deletionClient(), (VerificationMode)Mockito.times((int)0))).completeDeleteTopic("bar");
        ((ZKMetadataCollector)Mockito.verify((Object)zkMetadataCollector, (VerificationMode)Mockito.times((int)1))).onTopicDelete((java.util.Set)ArgumentMatchers.any());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("foo"));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testBasicDeletionOfTieredTopic$3(x$3))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
    }

    @Test
    public void testExceptionWhenDeletingTieredTopic() {
        Properties brokerProperties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        brokerProperties.put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(brokerProperties);
        new Properties().setProperty("confluent.tier.enable", "true");
        ControllerContext controllerContext = this.initContext((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, true);
        CompletableFuture futureWithException = new CompletableFuture();
        futureWithException.completeExceptionally(new TierMetadataRetriableException("exception on tier topic append"));
        CompletableFuture<TierPartitionState.AppendResult> successfulFuture = CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(futureWithException);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false, true);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(config, controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)new Some((Object)tierTopicManager), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate(fooPartitions);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.completeReplicaDeletion((Set)fooReplicas);
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        this.deletionClient().completeDeleteTopic((String)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(null, deletionManager){
            private final TopicDeletionManager deletionManager$2;

            public void answer(InvocationOnMock invocation) {
                this.deletionManager$2.finishTopicDelete((String)invocation.getArgument(0));
            }
            {
                this.deletionManager$2 = deletionManager$2;
            }
        });
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(successfulFuture);
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        deletionManager.completeReplicaDeletion((Set)fooReplicas);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("foo"));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testExceptionWhenDeletingTieredTopic$1(x$4))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
    }

    @Test
    public void testDeletionDuringShutdownProcess() {
        Properties brokerProperties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        brokerProperties.put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(brokerProperties);
        new Properties().setProperty("confluent.tier.enable", "true");
        ControllerContext controllerContext = this.initContext((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, true);
        CompletableFuture futureWithException = new CompletableFuture();
        futureWithException.completeExceptionally(new CancellationException("TierTopicManager is shutting down"));
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(futureWithException);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false, true);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(config, controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)new Some((Object)tierTopicManager), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate(fooPartitions);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.completeReplicaDeletion((Set)fooReplicas);
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeletionWithBrokerOffline() {
        void var13_12;
        void var12_11;
        ControllerContext controllerContext = this.initContext((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, this.initContext$default$5());
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false, true);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)None$.MODULE$, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        int failedBrokerId = 2;
        Broker offlineBroker = (Broker)controllerContext.liveOrShuttingDownBroker(failedBrokerId).get();
        long lastEpoch = BoxesRunTime.unboxToLong((Object)controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)failedBrokerId)));
        controllerContext.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{failedBrokerId})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3})), (Object)controllerContext.liveBrokerIds());
        Tuple2 tuple2 = fooReplicas.partition((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testDeletionWithBrokerOffline$1(failedBrokerId, x$5)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set offlineReplicas = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set onlineReplicas = (scala.collection.immutable.Set)tuple2._2();
        replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)var12_11.toSeq(), (ReplicaState)OfflineReplica$.MODULE$, replicaStateMachine.handleStateChanges$default$3());
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate(fooPartitions);
        Assertions.assertEquals((Object)var13_12, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        Assertions.assertEquals((Object)var12_11, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionIneligible$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.completeReplicaDeletion((Set)var13_12);
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsIneligibleForDeletion());
        Assertions.assertEquals((Object)var13_12, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
        Assertions.assertEquals((Object)var12_11, (Object)controllerContext.replicasInState("foo", (ReplicaState)OfflineReplica$.MODULE$));
        controllerContext.addLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)offlineBroker), (Object)BoxesRunTime.boxToLong((long)(lastEpoch + 1L)))})));
        deletionManager.resumeDeletionForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((Object)var13_12, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
        Assertions.assertEquals((Object)var12_11, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        deletionManager.completeReplicaDeletion((Set)var12_11);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("foo"));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testDeletionWithBrokerOffline$2(x$7))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerFailureAfterDeletionStarted() {
        void var13_12;
        void var12_11;
        ControllerContext controllerContext = this.initContext((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, this.initContext$default$5());
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false, true);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)None$.MODULE$, (Option)None$.MODULE$);
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assertions.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        int failedBrokerId = 2;
        Broker offlineBroker = (Broker)controllerContext.liveOrShuttingDownBroker(failedBrokerId).get();
        long lastEpoch = BoxesRunTime.unboxToLong((Object)controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)failedBrokerId)));
        controllerContext.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{failedBrokerId})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3})), (Object)controllerContext.liveBrokerIds());
        Tuple2 tuple2 = fooReplicas.partition((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManagerTest.$anonfun$testBrokerFailureAfterDeletionStarted$1(failedBrokerId, x$8)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set offlineReplicas = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set onlineReplicas = (scala.collection.immutable.Set)tuple2._2();
        deletionManager.failReplicaDeletion((Set)var12_11);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsIneligibleForDeletion());
        Assertions.assertEquals((Object)var12_11, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionIneligible$.MODULE$));
        Assertions.assertEquals((Object)var13_12, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        controllerContext.addLiveBrokers((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)offlineBroker), (Object)BoxesRunTime.boxToLong((long)(lastEpoch + 1L)))})));
        deletionManager.resumeDeletionForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        Assertions.assertEquals((Object)var13_12, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        Assertions.assertEquals((Object)var12_11, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionIneligible$.MODULE$));
        deletionManager.completeReplicaDeletion((Set)var13_12);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        Assertions.assertEquals((Object)var13_12, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
        Assertions.assertEquals((Object)var12_11, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
    }

    @Test
    public void testMultipleTieredTopicDeletions() {
        Properties brokerProperties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        brokerProperties.put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(brokerProperties);
        new Properties().setProperty("confluent.tier.enable", "true");
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        ControllerContext controllerContext = this.initContext((scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, true);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false, true);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(config, controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)new Some((Object)tierTopicManager), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        ListBuffer deletionsBeingCompleted = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.deletionClient().completeDeleteTopic((String)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(null, deletionsBeingCompleted){
            private final ListBuffer deletionsBeingCompleted$1;

            public void answer(InvocationOnMock invocation) {
                this.deletionsBeingCompleted$1.$plus$eq(invocation.getArgument(0));
            }
            {
                this.deletionsBeingCompleted$1 = deletionsBeingCompleted$1;
            }
        });
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        Set barPartitions = controllerContext.partitionsForTopic("bar");
        scala.collection.immutable.Set barReplicas = controllerContext.replicasForPartition(barPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        deletionManager.completeReplicaDeletion((Set)fooReplicas);
        Assertions.assertEquals((Object)new .colon.colon((Object)"foo", (List)Nil$.MODULE$), (Object)deletionsBeingCompleted);
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar"})));
        deletionManager.completeReplicaDeletion((Set)barReplicas);
        Assertions.assertEquals((Object)new .colon.colon((Object)"foo", (List)new .colon.colon((Object)"bar", (List)Nil$.MODULE$)), (Object)deletionsBeingCompleted);
    }

    public ControllerContext initContext(scala.collection.immutable.Seq<Object> brokers, scala.collection.immutable.Set<String> topics, int numPartitions, int replicationFactor, boolean addTopicId) {
        ControllerContext context = new ControllerContext();
        scala.collection.immutable.Map brokerEpochs = ((IterableOnceOps)brokers.map((Function1 & Serializable)brokerId -> TopicDeletionManagerTest.$anonfun$initContext$1(BoxesRunTime.unboxToInt((Object)brokerId)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        context.setLiveBrokers((Map)brokerEpochs);
        IntRef leaderIndex = IntRef.create((int)0);
        topics.foreach((Function1 & Serializable)topic -> {
            TopicDeletionManagerTest.$anonfun$initContext$2(numPartitions, replicationFactor, brokers, leaderIndex, context, topic);
            return BoxedUnit.UNIT;
        });
        context.setAllTopics(topics);
        if (addTopicId) {
            topics.foreach((Function1 & Serializable)topic -> {
                context.addTopicId(topic, Uuid.randomUuid());
                return BoxedUnit.UNIT;
            });
        }
        return context;
    }

    public boolean initContext$default$5() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testBasicDeletion$1(PartitionAndReplica x$1) {
        String string = x$1.topic();
        String string2 = "foo";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testBasicDeletion$2(PartitionAndReplica x$2) {
        String string = x$2.topic();
        String string2 = "bar";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testBasicDeletionOfTieredTopic$1(AtomicInteger finishInvoked$1) {
        return finishInvoked$1.get() > 0;
    }

    public static final /* synthetic */ String $anonfun$testBasicDeletionOfTieredTopic$2() {
        return "Timed out waiting for deletion to be completed";
    }

    public static final /* synthetic */ boolean $anonfun$testBasicDeletionOfTieredTopic$3(PartitionAndReplica x$3) {
        String string = x$3.topic();
        String string2 = "foo";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testExceptionWhenDeletingTieredTopic$1(PartitionAndReplica x$4) {
        String string = x$4.topic();
        String string2 = "foo";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDeletionWithBrokerOffline$1(int failedBrokerId$1, PartitionAndReplica x$5) {
        return x$5.replica() == failedBrokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDeletionWithBrokerOffline$2(PartitionAndReplica x$7) {
        String string = x$7.topic();
        String string2 = "foo";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerFailureAfterDeletionStarted$1(int failedBrokerId$2, PartitionAndReplica x$8) {
        return x$8.replica() == failedBrokerId$2;
    }

    public static final /* synthetic */ Tuple2 $anonfun$initContext$1(int brokerId) {
        EndPoint endpoint = new EndPoint("localhost", 9900 + brokerId, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(brokerId, (Seq)new .colon.colon((Object)endpoint, (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L));
    }

    public static final /* synthetic */ void $anonfun$initContext$2(int numPartitions$1, int replicationFactor$1, scala.collection.immutable.Seq brokers$1, IntRef leaderIndex$1, ControllerContext context$1, String topic) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> {
            TopicPartition partition = new TopicPartition(topic, partitionId);
            IndexedSeq replicas = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), replicationFactor$1).map((Function1)(JFunction1.mcII.sp & Serializable)i -> BoxesRunTime.unboxToInt((Object)brokers$1.apply((i + leaderIndex$1.elem) % brokers$1.size())));
            context$1.updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)replicas, (Seq)package$.MODULE$.Seq().empty()));
            ++leaderIndex$1.elem;
        });
    }

    public TopicDeletionManagerTest() {
        this.brokerId = 1;
    }
}

