/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.CompletingRebalance$;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.JoinGroupResult$;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.MemberMetadata$;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.coordinator.group.SyncGroupResult;
import kafka.coordinator.group.SyncGroupResult$;
import kafka.utils.MockTime;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t5d\u0001\u0002*T\u0001iCQ!\u0019\u0001\u0005\u0002\tDq!\u001a\u0001C\u0002\u0013%a\r\u0003\u0004p\u0001\u0001\u0006Ia\u001a\u0005\ba\u0002\u0011\r\u0011\"\u0003g\u0011\u0019\t\b\u0001)A\u0005O\"9!\u000f\u0001b\u0001\n\u00131\u0007BB:\u0001A\u0003%q\rC\u0004u\u0001\t\u0007I\u0011\u00024\t\rU\u0004\u0001\u0015!\u0003h\u0011\u001d1\bA1A\u0005\n\u0019Daa\u001e\u0001!\u0002\u00139\u0007b\u0002=\u0001\u0005\u0004%I!\u001f\u0005\u0007{\u0002\u0001\u000b\u0011\u0002>\t\u000fy\u0004!\u0019!C\u0005s\"1q\u0010\u0001Q\u0001\niD!\u0002\u0016\u0001A\u0002\u0003\u0007I\u0011BA\u0001\u0011-\tI\u0001\u0001a\u0001\u0002\u0004%I!a\u0003\t\u0017\u0005]\u0001\u00011A\u0001B\u0003&\u00111\u0001\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\t9\u0004\u0001C\u0001\u00037Aq!!\u0011\u0001\t\u0003\tY\u0002C\u0004\u0002F\u0001!\t!a\u0007\t\u000f\u0005%\u0003\u0001\"\u0001\u0002\u001c!9\u0011Q\n\u0001\u0005\u0002\u0005m\u0001bBA)\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003+\u0002A\u0011AA\u000e\u0011\u001d\tI\u0006\u0001C\u0001\u00037Aq!!\u0018\u0001\t\u0003\tY\u0002C\u0004\u0002b\u0001!\t!a\u0007\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002\u001c!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005m\u0001bBA7\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003c\u0002A\u0011AA\u000e\u0011\u001d\t)\b\u0001C\u0001\u00037Aq!!\u001f\u0001\t\u0003\tY\u0002C\u0004\u0002~\u0001!\t!a\u0007\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u001c!9\u00111\u0011\u0001\u0005\u0002\u0005m\u0001bBAD\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003\u0017\u0003A\u0011AA\u000e\u0011\u001d\ty\t\u0001C\u0001\u00037Aq!a%\u0001\t\u0003\tY\u0002C\u0004\u0002\u0018\u0002!\t!a\u0007\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001c!9\u0011q\u0014\u0001\u0005\u0002\u0005m\u0001bBAR\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003O\u0003A\u0011AA\u000e\u0011\u001d\tY\u000b\u0001C\u0001\u00037Aq!a,\u0001\t\u0003\tY\u0002C\u0004\u00024\u0002!\t!a\u0007\t\u000f\u0005]\u0006\u0001\"\u0001\u0002\u001c!9\u00111\u0018\u0001\u0005\u0002\u0005m\u0001bBA`\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003\u0007\u0004A\u0011AA\u000e\u0011\u001d\t9\r\u0001C\u0001\u00037Aq!a3\u0001\t\u0003\tY\u0002C\u0004\u0002P\u0002!\t!a\u0007\t\u000f\u0005M\u0007\u0001\"\u0001\u0002\u001c!9\u0011q\u001b\u0001\u0005\u0002\u0005m\u0001bBAn\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003?\u0004A\u0011AA\u000e\u0011\u001d\t\u0019\u000f\u0001C\u0001\u00037Aq!a:\u0001\t\u0003\tY\u0002C\u0004\u0002l\u0002!\t!a\u0007\t\u000f\u0005=\b\u0001\"\u0001\u0002\u001c!9\u00111\u001f\u0001\u0005\u0002\u0005m\u0001bBA|\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003w\u0004A\u0011AA\u000e\u0011\u001d\ty\u0010\u0001C\u0001\u00037AqAa\u0001\u0001\t\u0003\tY\u0002C\u0004\u0003\b\u0001!\t!a\u0007\t\u000f\t-\u0001\u0001\"\u0001\u0002\u001c!9!q\u0002\u0001\u0005\u0002\u0005m\u0001b\u0002B\n\u0001\u0011\u0005\u00111\u0004\u0005\b\u0005/\u0001A\u0011AA\u000e\u0011\u001d\u0011Y\u0002\u0001C\u0001\u00037AqAa\b\u0001\t\u0003\tY\u0002C\u0004\u0003$\u0001!\t!a\u0007\t\u000f\t\u001d\u0002\u0001\"\u0003\u0003*!9!q\u0007\u0001\u0005\n\te\u0002\"\u0003B+\u0001E\u0005I\u0011\u0002B,\u0005E9%o\\;q\u001b\u0016$\u0018\rZ1uCR+7\u000f\u001e\u0006\u0003)V\u000bQa\u001a:pkBT!AV,\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u00021\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001\\!\tav,D\u0001^\u0015\u0005q\u0016!B:dC2\f\u0017B\u00011^\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0019\t\u0003I\u0002i\u0011aU\u0001\raJ|Go\\2pYRK\b/Z\u000b\u0002OB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\u0005Y\u0006twMC\u0001m\u0003\u0011Q\u0017M^1\n\u00059L'AB*ue&tw-A\u0007qe>$xnY8m)f\u0004X\rI\u0001\u0010OJ|W\u000f]%ogR\fgnY3JI\u0006\u0001rM]8va&s7\u000f^1oG\u0016LE\rI\u0001\t[\u0016l'-\u001a:JI\u0006IQ.Z7cKJLE\rI\u0001\tG2LWM\u001c;JI\u0006I1\r\\5f]RLE\rI\u0001\u000bG2LWM\u001c;I_N$\u0018aC2mS\u0016tG\u000fS8ti\u0002\n!C]3cC2\fgnY3US6,w.\u001e;NgV\t!\u0010\u0005\u0002]w&\u0011A0\u0018\u0002\u0004\u0013:$\u0018a\u0005:fE\u0006d\u0017M\\2f)&lWm\\;u\u001bN\u0004\u0013\u0001E:fgNLwN\u001c+j[\u0016|W\u000f^'t\u0003E\u0019Xm]:j_:$\u0016.\\3pkRl5\u000fI\u000b\u0003\u0003\u0007\u00012\u0001ZA\u0003\u0013\r\t9a\u0015\u0002\u000e\u000fJ|W\u000f]'fi\u0006$\u0017\r^1\u0002\u0013\u001d\u0014x.\u001e9`I\u0015\fH\u0003BA\u0007\u0003'\u00012\u0001XA\b\u0013\r\t\t\"\u0018\u0002\u0005+:LG\u000fC\u0005\u0002\u0016E\t\t\u00111\u0001\u0002\u0004\u0005\u0019\u0001\u0010J\u0019\u0002\r\u001d\u0014x.\u001e9!\u0003\u0015\u0019X\r^+q)\t\ti\u0001K\u0002\u0014\u0003?\u0001B!!\t\u000245\u0011\u00111\u0005\u0006\u0005\u0003K\t9#A\u0002ba&TA!!\u000b\u0002,\u00059!.\u001e9ji\u0016\u0014(\u0002BA\u0017\u0003_\tQA[;oSRT!!!\r\u0002\u0007=\u0014x-\u0003\u0003\u00026\u0005\r\"A\u0003\"fM>\u0014X-R1dQ\u0006QB/Z:u\u0007\u0006t'+\u001a2bY\u0006t7-Z,iK:\u001cF/\u00192mK\"\u001aA#a\u000f\u0011\t\u0005\u0005\u0012QH\u0005\u0005\u0003\u007f\t\u0019C\u0001\u0003UKN$\u0018a\n;fgR\u001c\u0015M\u001c*fE\u0006d\u0017M\\2f/\",gnQ8na2,G/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016D3!FA\u001e\u0003%\"Xm\u001d;DC:tw\u000e\u001e*fE\u0006d\u0017M\\2f/\",g\u000e\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dK\"\u001aa#a\u000f\u00027Q,7\u000f^\"b]:|GOU3cC2\fgnY3XQ\u0016tG)Z1eQ\r9\u00121H\u0001)i\u0016\u001cHo\u0015;bE2,Gk\u001c)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$&/\u00198tSRLwN\u001c\u0015\u00041\u0005m\u0012A\u0007;fgR\u001cF/\u00192mKR{G)Z1e)J\fgn]5uS>t\u0007fA\r\u0002<\u0005\u0019D/Z:u\u0003^\f\u0017\u000e^5oOJ+'-\u00197b]\u000e,Gk\u001c)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$&/\u00198tSRLwN\u001c\u0015\u00045\u0005m\u0012A\n;fgR\u0004&/\u001a9be&twMU3cC2\fgnY3U_\u0012+\u0017\r\u001a+sC:\u001c\u0018\u000e^5p]\"\u001a1$a\u000f\u0002OQ,7\u000f\u001e)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$v.R7qif$&/\u00198tSRLwN\u001c\u0015\u00049\u0005m\u0012!\u0007;fgR,U\u000e\u001d;z)>$U-\u00193Ue\u0006t7/\u001b;j_:D3!HA\u001e\u0003\u001d\"Xm\u001d;Bo\u0006LG/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$vn\u0015;bE2,GK]1og&$\u0018n\u001c8)\u0007y\tY$\u0001\u0012uKN$X)\u001c9usR{7\u000b^1cY\u0016LE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\u0004?\u0005m\u0012a\t;fgR\u001cF/\u00192mKR{7\u000b^1cY\u0016LE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\u0004A\u0005m\u0012!\f;fgR,U\u000e\u001d;z)>\fu/Y5uS:<'+\u001a2bY\u0006t7-Z%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\"\u001a\u0011%a\u000f\u0002wQ,7\u000f\u001e)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$v\u000e\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0002#\u0003w\tq\u0006^3tiB\u0013X\r]1sS:<'+\u001a2bY\u0006t7-\u001a+p'R\f'\r\\3JY2,w-\u00197Ue\u0006t7/\u001b;j_:D3aIA\u001e\u0003e\"Xm\u001d;Bo\u0006LG/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$v.Q<bSRLgn\u001a*fE\u0006d\u0017M\\2f\u00132dWmZ1m)J\fgn]5uS>t\u0007f\u0001\u0013\u0002<\u0005yB/Z:u\t\u0016\fG\rV8EK\u0006$\u0017\n\u001c7fO\u0006dGK]1og&$\u0018n\u001c8\u0002CQ,7\u000f\u001e#fC\u0012$vn\u0015;bE2,\u0017\n\u001c7fO\u0006dGK]1og&$\u0018n\u001c8)\u0007\u0019\nY$A\u0017uKN$H)Z1e)>\u0004&/\u001a9be&twMU3cC2\fgnY3JY2,w-\u00197Ue\u0006t7/\u001b;j_:D3aJA\u001e\u00031\"Xm\u001d;EK\u0006$Gk\\!xC&$\u0018N\\4SK\n\fG.\u00198dK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0002)\u0003w\t!\u0003^3tiN+G.Z2u!J|Go\\2pY\"\u001a\u0011&a\u000f\u0002GQ,7\u000f^*fY\u0016\u001cG\u000f\u0015:pi>\u001cw\u000e\u001c*bSN,7/\u00134O_6+WNY3sg\"\u001a!&a\u000f\u0002WQ,7\u000f^*fY\u0016\u001cG\u000f\u0015:pi>\u001cw\u000e\\\"i_>\u001cXm]\"p[B\fG/\u001b2mKB\u0013x\u000e^8d_2D3aKA\u001e\u0003U!Xm\u001d;TkB\u0004xN\u001d;t!J|Go\\2pYND3\u0001LA\u001e\u0003Q\"Xm\u001d;PM\u001a\u001cX\r\u001e*f[>4\u0018\r\u001c#ve&tw\r\u0016:b]NLG/[8o\rJ|W.R7qif$vNT8o\u000b6\u0004H/\u001f\u0015\u0004[\u0005m\u0012\u0001\u0006;fgR\u001cVOY:de&\u0014W\r\u001a+pa&\u001c7\u000fK\u0002/\u0003w\tA\u0005^3tiN+(m]2sS\n,G\rV8qS\u000e\u001chj\u001c8D_:\u001cX/\\3s\u000fJ|W\u000f\u001d\u0015\u0004_\u0005m\u0012A\u0006;fgRLe.\u001b;OKb$x)\u001a8fe\u0006$\u0018n\u001c8)\u0007A\nY$\u0001\u0011uKN$\u0018J\\5u\u001d\u0016DHoR3oKJ\fG/[8o\u000b6\u0004H/_$s_V\u0004\bfA\u0019\u0002<\u0005\u0001B/Z:u\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e\u0015\u0004e\u0005m\u0012a\u0006;fgR|eMZ:fi\u000e{W.\\5u\r\u0006LG.\u001e:fQ\r\u0019\u00141H\u0001*i\u0016\u001cHo\u00144gg\u0016$8i\\7nSR4\u0015-\u001b7ve\u0016<\u0016\u000e\u001e5B]>$\b.\u001a:QK:$\u0017N\\4)\u0007Q\nY$\u0001\u0012uKN$xJ\u001a4tKR\u001cu.\\7ji^KG\u000f[!o_RDWM\u001d)f]\u0012Lgn\u001a\u0015\u0004k\u0005m\u0012A\u000b;fgR\u001cuN\\:v[\u0016\u0014()Z1ugR\u0013\u0018M\\:bGRLwN\\1m\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e\u0015\u0004m\u0005m\u0012\u0001\u000b;fgR$&/\u00198tC\u000e$\u0018n\u001c8CK\u0006$8oQ8ogVlWM](gMN,GoQ8n[&$\bfA\u001c\u0002<\u0005)D/Z:u)J\fgn]1di&|g.\u00197D_6l\u0017\u000e^%t\u0003\n|'\u000f^3e\u0003:$7i\u001c8tk6,'oQ8n[&$x+\u001b8tQ\rA\u00141H\u0001.i\u0016\u001cHOR1jY\u0016$G\u000b\u001f8PM\u001a\u001cX\r^\"p[6LG\u000fT3bm\u0016\u001chj\u001c)f]\u0012LgnZ*uCR,\u0007fA\u001d\u0002<\u0005\u0001B/Z:u+B$\u0017\r^3NK6\u0014WM\u001d\u0015\u0004u\u0005m\u0012!\f;fgR\u0014V\r\u001d7bG\u0016<%o\\;q\u0013:\u001cH/\u00198dK^KG\u000f\u001b(p]\u0016C\u0018n\u001d;j]\u001elU-\u001c2fe\"\u001a1(a\u000f\u00021Q,7\u000f\u001e*fa2\f7-Z$s_V\u0004\u0018J\\:uC:\u001cW\rK\u0002=\u0003w\ta\u0003^3ti&sgo\\6f\u0015>LgnQ1mY\n\f7m\u001b\u0015\u0004{\u0005m\u0012a\u0007;fgRLeN^8lK*{\u0017N\\\"bY2\u0014\u0017mY6GC&d7\u000fK\u0002?\u0003w\t\u0011\u0004^3ti:{G/\u00138w_.,'j\\5o\u0007\u0006dGNY1dW\"\u001aq(a\u000f\u00027Q,7\u000f^%om>\\WmU=oG\u000e\u000bG\u000e\u001c2bG.4\u0015-\u001b7tQ\r\u0001\u00151H\u0001\u0017i\u0016\u001cH/\u00138w_.,7+\u001f8d\u0007\u0006dGNY1dW\"\u001a\u0011)a\u000f\u00023Q,7\u000f\u001e(pi&sgo\\6f'ft7mQ1mY\n\f7m\u001b\u0015\u0004\u0005\u0006m\u0012a\u0007;fgRD\u0015m\u001d)f]\u0012Lgn\u001a(p]RChn\u00144gg\u0016$8\u000fK\u0002D\u0003w\t\u0001\u0004^3ti\"\u000b7\u000fU3oI&tw\r\u0016=o\u001f\u001a47/\u001a;tQ\r!\u00151H\u0001\u001ci\u0016\u001cHOU3cC2\fgnY3Ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9)\u0007\u0015\u000bY$\u0001\u0012uKN$8)\u00198o_R\fE\r\u001a)f]\u0012LgnZ'f[\n,'/\u00134Ti\u0006\u0014G.\u001a\u0015\u0004\r\u0006m\u0012!\u000b;fgR\u0014V-\\8wC24%o\\7QK:$\u0017N\\4BMR,'/T3nE\u0016\u0014\u0018j]*uC\ndW\rK\u0002H\u0003w\t\u0011\u0006^3tiJ+Wn\u001c<bY\u001a\u0013x.\u001c)f]\u0012LgnZ,iK:lU-\u001c2fe&\u001b(+Z7pm\u0016$\u0007f\u0001%\u0002<\u0005IC/Z:u\u0007\u0006tgn\u001c;BI\u0012\u001cF/\u0019;jG6+WNY3s\u0013\u001a\fEN]3bIf\u0004&/Z:f]RD3!SA\u001e\u0003\u001d\"Xm\u001d;DC:tw\u000e^!eIB+g\u000eZ5oONKhnY(g+:\\gn\\<o\u001b\u0016l'-\u001a:)\u0007)\u000bY$\u0001\u0016uKN$8)\u00198o_R\u0014V-\\8wKB+g\u000eZ5oONKhnY(g+:\\gn\\<o\u001b\u0016l'-\u001a:)\u0007-\u000bY$\u0001\u0013uKN$8)\u00198BI\u0012\fe\u000e\u001a*f[>4X\rU3oI&twmU=oG6+WNY3sQ\ra\u00151H\u0001.i\u0016\u001cHOU3n_Z\fGN\u0012:p[B+g\u000eZ5oONKhnY,iK:lU-\u001c2fe&\u001b(+Z7pm\u0016$\u0007fA'\u0002<\u0005IC/Z:u\u001d\u0016<x)\u001a8fe\u0006$\u0018n\u001c8DY\u0016\f'o\u001d)f]\u0012LgnZ*z]\u000elU-\u001c2feND3ATA\u001e\u0003-\t7o]3siN#\u0018\r^3\u0015\r\u00055!1\u0006B\u0017\u0011\u0019!v\n1\u0001\u0002\u0004!9!qF(A\u0002\tE\u0012a\u0003;be\u001e,Go\u0015;bi\u0016\u00042\u0001\u001aB\u001a\u0013\r\u0011)d\u0015\u0002\u000b\u000fJ|W\u000f]*uCR,\u0017!E8gMN,G/\u00118e\u001b\u0016$\u0018\rZ1uCR1!1\bB$\u0005#\u0002BA!\u0010\u0003D5\u0011!q\b\u0006\u0004\u0005\u0003:\u0016AB2p[6|g.\u0003\u0003\u0003F\t}\"!E(gMN,G/\u00118e\u001b\u0016$\u0018\rZ1uC\"9!\u0011\n)A\u0002\t-\u0013AB8gMN,G\u000fE\u0002]\u0005\u001bJ1Aa\u0014^\u0005\u0011auN\\4\t\u0013\tM\u0003\u000b%AA\u0002\t-\u0013!\u0003;j[\u0016\u001cH/Y7q\u0003mygMZ:fi\u0006sG-T3uC\u0012\fG/\u0019\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\f\u0016\u0005\u0005\u0017\u0012Yf\u000b\u0002\u0003^A!!q\fB5\u001b\t\u0011\tG\u0003\u0003\u0003d\t\u0015\u0014!C;oG\",7m[3e\u0015\r\u00119'X\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B6\u0005C\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class GroupMetadataTest {
    private final String protocolType;
    private final String groupInstanceId;
    private final String memberId;
    private final String clientId;
    private final String clientHost;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;
    private GroupMetadata group;

    private String protocolType() {
        return this.protocolType;
    }

    private String groupInstanceId() {
        return this.groupInstanceId;
    }

    private String memberId() {
        return this.memberId;
    }

    private String clientId() {
        return this.clientId;
    }

    private String clientHost() {
        return this.clientHost;
    }

    private int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    private int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    private GroupMetadata group() {
        return this.group;
    }

    private void group_$eq(GroupMetadata x$1) {
        this.group = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.group_$eq(new GroupMetadata("groupId", (GroupState)Empty$.MODULE$, Time.SYSTEM));
    }

    @Test
    public void testCanRebalanceWhenStable() {
        Assertions.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCanRebalanceWhenCompletingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assertions.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenPreparingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenDead() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testStableToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testStableToDeadTransition() {
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToEmptyTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.assertState(this.group(), (GroupState)Empty$.MODULE$);
    }

    @Test
    public void testEmptyToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToStableTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        this.assertState(this.group(), (GroupState)Stable$.MODULE$);
    }

    @Test
    public void testEmptyToStableIllegalTransition() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testStableToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testEmptyToAwaitingRebalanceIllegalTransition() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    @Test
    public void testPreparingRebalanceToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$));
    }

    @Test
    public void testPreparingRebalanceToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testAwaitingRebalanceToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    public void testDeadToDeadIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testDeadToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testDeadToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$));
    }

    @Test
    public void testDeadToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    @Test
    public void testSelectProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertEquals((Object)"range", (Object)this.group().selectProtocol());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertTrue((boolean)((SetOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))).apply((Object)this.group().selectProtocol()));
        String lastMemberId = "lastMemberId";
        MemberMetadata lastMember = new MemberMetadata(lastMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$3 = this.group();
        Function1 x$6 = qual$3.add$default$2();
        qual$3.add(lastMember, x$6);
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSelectProtocolRaisesIfNoMembers() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().selectProtocol());
    }

    @Test
    public void testSelectProtocolChoosesCompatibleProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"blah", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSupportsProtocols() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "range"}))));
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"blah", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols("invalid_type", (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetRemovalDuringTransitionFromEmptyToNonEmpty() {
        void offsetAndMetadata_timestamp;
        String topic = "foo";
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, topic);
        MockTime time = new MockTime();
        this.group_$eq(new GroupMetadata("groupId", (GroupState)Empty$.MODULE$, (Time)time));
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()), (short)3).array()), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)new Some(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))), (Object)this.group().getSubscribedTopics());
        long l = time.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp);
        int commitRecordOffset = 3;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().onOffsetCommitAppend(topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)commitRecordOffset)), offset));
        long offsetRetentionMs = 50000L;
        time.sleep(offsetRetentionMs + 1L);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().remove(this.memberId());
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)Empty$.MODULE$, (Object)this.group().currentState());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.group().removeExpiredOffsets(time.milliseconds(), offsetRetentionMs));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(member, x$4);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.group().removeExpiredOffsets(time.milliseconds(), offsetRetentionMs));
    }

    @Test
    public void testSubscribedTopics() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava()), (short)3).array()), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)new Some(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))), (Object)this.group().getSubscribedTopics());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().remove(memberId);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)new Some((Object)Predef$.MODULE$.Set().empty()), (Object)this.group().getSubscribedTopics());
        MemberMetadata memberWithFaultyProtocol = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(memberWithFaultyProtocol, x$4);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    @Test
    public void testSubscribedTopicsNonConsumerGroup() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), "My Protocol", (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    @Test
    public void testInitNextGeneration() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        member.supportedProtocols_$eq((List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().add(member, (Function1 & Serializable)x$2 -> {
            GroupMetadataTest.$anonfun$testInitNextGeneration$1(x$2);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.group().initNextGeneration();
        Assertions.assertEquals((int)1, (int)this.group().generationId());
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Test
    public void testInitNextGenerationEmptyGroup() {
        Assertions.assertEquals((Object)Empty$.MODULE$, (Object)this.group().currentState());
        Assertions.assertEquals((int)0, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().initNextGeneration();
        Assertions.assertEquals((int)1, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetCommit() {
        void offsetAndMetadata_timestamp;
        TopicIdPartition partition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp);
        int commitRecordOffset = 3;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition.topicPartition()));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)commitRecordOffset)), offset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)offset), (Object)this.group().offset(partition.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetCommitFailure() {
        void offsetAndMetadata_timestamp;
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)offset), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().failPendingOffsetWrite(topicIdPartition, offset);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetCommitFailureWithAnotherPending() {
        void offsetAndMetadata_timestamp;
        void offsetAndMetadata_timestamp2;
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata firstOffset = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp2);
        long l2 = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset2 = 57L;
        OffsetAndMetadata secondOffset = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset2, "", (long)offsetAndMetadata_timestamp);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)firstOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)firstOffset), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)secondOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().failPendingOffsetWrite(topicIdPartition, firstOffset);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().onOffsetCommitAppend(topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), secondOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(topicIdPartition.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetCommitWithAnotherPending() {
        void offsetAndMetadata_timestamp;
        void offsetAndMetadata_timestamp2;
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata firstOffset = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp2);
        long l2 = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset2 = 57L;
        OffsetAndMetadata secondOffset = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset2, "", (long)offsetAndMetadata_timestamp);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)firstOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)firstOffset), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)secondOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().onOffsetCommitAppend(topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), firstOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)firstOffset), (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().onOffsetCommitAppend(topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)5L)), secondOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(topicIdPartition.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumerBeatsTransactionalOffsetCommit() {
        void offsetAndMetadata_timestamp;
        void offsetAndMetadata_timestamp2;
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long producerId = 13232L;
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata txnOffsetCommit = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp2);
        long l2 = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset2 = 57L;
        OffsetAndMetadata consumerOffsetCommit = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset2, "", (long)offsetAndMetadata_timestamp);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)new CommitRecordMetadataAndOffset((Option)None$.MODULE$, txnOffsetCommit)), (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().onTxnOffsetCommitAppend(producerId, topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), txnOffsetCommit));
        this.group().onOffsetCommitAppend(topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), consumerOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), txnOffsetCommit)), (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(topicIdPartition.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionBeatsConsumerOffsetCommit() {
        void offsetAndMetadata_timestamp;
        void offsetAndMetadata_timestamp2;
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long producerId = 13232L;
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata txnOffsetCommit = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp2);
        long l2 = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset2 = 57L;
        OffsetAndMetadata consumerOffsetCommit = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset2, "", (long)offsetAndMetadata_timestamp);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)new CommitRecordMetadataAndOffset((Option)None$.MODULE$, txnOffsetCommit)), (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        this.group().onOffsetCommitAppend(topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit)), (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingOffsetCommit(topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)txnOffsetCommit), (Object)this.group().offset(topicIdPartition.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionalCommitIsAbortedAndConsumerCommitWins() {
        void offsetAndMetadata_timestamp;
        void offsetAndMetadata_timestamp2;
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long producerId = 13232L;
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata txnOffsetCommit = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp2);
        long l2 = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset2 = 57L;
        OffsetAndMetadata consumerOffsetCommit = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset2, "", (long)offsetAndMetadata_timestamp);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        Assertions.assertEquals((Object)new Some((Object)new CommitRecordMetadataAndOffset((Option)None$.MODULE$, txnOffsetCommit)), (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        Assertions.assertEquals((Object)new Some((Object)new CommitRecordMetadataAndOffset((Option)None$.MODULE$, txnOffsetCommit)), (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().pendingOffsetCommit(topicIdPartition));
        this.group().onOffsetCommitAppend(topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, topicIdPartition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit)), (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().completePendingTxnOffsetCommit(producerId, false);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(topicIdPartition.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFailedTxnOffsetCommitLeavesNoPendingState() {
        void offsetAndMetadata_timestamp;
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long producerId = 13232L;
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata txnOffsetCommit = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)new CommitRecordMetadataAndOffset((Option)None$.MODULE$, txnOffsetCommit)), (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(topicIdPartition.topicPartition()));
        this.group().failPendingTxnOffsetCommit(producerId, topicIdPartition);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().pendingTxnOffsetCommit(producerId, topicIdPartition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
    }

    @Test
    public void testUpdateMember() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        int newRebalanceTimeout = 120000;
        int newSessionTimeout = 20000;
        this.group().updateMember(member, (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), newRebalanceTimeout, newSessionTimeout, null);
        Assertions.assertEquals((int)this.group().rebalanceTimeoutMs(), (int)newRebalanceTimeout);
        Assertions.assertEquals((int)member.sessionTimeoutMs(), (int)newSessionTimeout);
    }

    @Test
    public void testReplaceGroupInstanceWithNonExistingMember() {
        String newMemberId = "newMemberId";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.group().replaceStaticMember(this.groupInstanceId(), this.memberId(), newMemberId));
    }

    @Test
    public void testReplaceGroupInstance() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        BooleanRef joinAwaitingMemberFenced = BooleanRef.create((boolean)false);
        this.group().add(member, (Function1 & Serializable)joinGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$1(joinAwaitingMemberFenced, joinGroupResult);
            return BoxedUnit.UNIT;
        });
        BooleanRef syncAwaitingMemberFenced = BooleanRef.create((boolean)false);
        member.awaitingSyncCallback_$eq((Function1 & Serializable)syncGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$2(syncAwaitingMemberFenced, syncGroupResult);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().isLeader(this.memberId()));
        Assertions.assertEquals((Object)new Some((Object)this.memberId()), (Object)this.group().currentStaticMemberId(this.groupInstanceId()));
        String newMemberId = "newMemberId";
        this.group().replaceStaticMember(this.groupInstanceId(), this.memberId(), newMemberId);
        Assertions.assertTrue((boolean)this.group().isLeader(newMemberId));
        Assertions.assertEquals((Object)new Some((Object)newMemberId), (Object)this.group().currentStaticMemberId(this.groupInstanceId()));
        Assertions.assertTrue((boolean)joinAwaitingMemberFenced.elem);
        Assertions.assertTrue((boolean)syncAwaitingMemberFenced.elem);
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
        Assertions.assertFalse((boolean)member.isAwaitingSync());
    }

    @Test
    public void testInvokeJoinCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        BooleanRef invoked = BooleanRef.create((boolean)false);
        this.group().add(member, (Function1 & Serializable)x$3 -> {
            invoked.elem = true;
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().hasAllMembersJoined());
        this.group().maybeInvokeJoinCallback(member, JoinGroupResult$.MODULE$.apply(member.memberId(), Errors.NONE));
        Assertions.assertTrue((boolean)invoked.elem);
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
    }

    @Test
    public void testInvokeJoinCallbackFails() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        BooleanRef shouldFail = BooleanRef.create((boolean)true);
        ObjectRef result = ObjectRef.create((Object)None$.MODULE$);
        this.group().add(member, (Function1 & Serializable)joinGroupResult -> {
            GroupMetadataTest.joinCallback$1(joinGroupResult, shouldFail, result);
            return BoxedUnit.UNIT;
        });
        this.group().maybeInvokeJoinCallback(member, JoinGroupResult$.MODULE$.apply(member.memberId(), Errors.NONE));
        Assertions.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)((JoinGroupResult)((Option)result.elem).get()).error());
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
    }

    @Test
    public void testNotInvokeJoinCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
        this.group().maybeInvokeJoinCallback(member, JoinGroupResult$.MODULE$.apply(member.memberId(), Errors.NONE));
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
    }

    @Test
    public void testInvokeSyncCallbackFails() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        BooleanRef shouldFail = BooleanRef.create((boolean)true);
        ObjectRef result = ObjectRef.create((Object)None$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        member.awaitingSyncCallback_$eq((Function1 & Serializable)syncGroupResult -> {
            GroupMetadataTest.syncCallback$1(syncGroupResult, shouldFail, result);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().maybeInvokeSyncCallback(member, SyncGroupResult$.MODULE$.apply(Errors.NONE)));
        Assertions.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)((SyncGroupResult)((Option)result.elem).get()).error());
        Assertions.assertFalse((boolean)member.isAwaitingSync());
    }

    @Test
    public void testInvokeSyncCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        member.awaitingSyncCallback_$eq((Function1 & Serializable)x$4 -> {
            GroupMetadataTest.$anonfun$testInvokeSyncCallback$1(x$4);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().maybeInvokeSyncCallback(member, SyncGroupResult$.MODULE$.apply(Errors.NONE)));
        Assertions.assertFalse((boolean)member.isAwaitingSync());
    }

    @Test
    public void testNotInvokeSyncCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertFalse((boolean)this.group().maybeInvokeSyncCallback(member, SyncGroupResult$.MODULE$.apply(Errors.NONE)));
        Assertions.assertFalse((boolean)member.isAwaitingSync());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHasPendingNonTxnOffsets() {
        void offsetAndMetadata_timestamp;
        TopicIdPartition partition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(partition.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHasPendingTxnOffsets() {
        void offsetAndMetadata_timestamp;
        TopicIdPartition txnPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp);
        int producerId = 5;
        this.group().prepareTxnOffsetCommit((long)producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)txnPartition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(txnPartition.topicPartition()));
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(new TopicPartition("non-exist", 0)));
    }

    @Test
    public void testRebalanceStartTimestamp() {
        MockTime time = new MockTime();
        GroupMetadata group = new GroupMetadata("groupId2", (GroupState)Empty$.MODULE$, (Time)time);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)group.rebalanceStartTimestamp());
        time.sleep(100L);
        group.transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Option expectedRebalanceStartTimestamp = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)time.milliseconds()));
        Assertions.assertEquals((Object)expectedRebalanceStartTimestamp, (Object)group.rebalanceStartTimestamp());
        time.sleep(100L);
        group.transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assertions.assertEquals((Object)expectedRebalanceStartTimestamp, (Object)group.rebalanceStartTimestamp());
        time.sleep(100L);
        group.transitionTo((GroupState)Stable$.MODULE$);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)group.rebalanceStartTimestamp());
        time.sleep(100L);
        group.transitionTo((GroupState)PreparingRebalance$.MODULE$);
        expectedRebalanceStartTimestamp = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)time.milliseconds()));
        Assertions.assertEquals((Object)expectedRebalanceStartTimestamp, (Object)group.rebalanceStartTimestamp());
        time.sleep(100L);
        group.transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assertions.assertEquals((Object)expectedRebalanceStartTimestamp, (Object)group.rebalanceStartTimestamp());
        time.sleep(100L);
        group.transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertEquals((Object)expectedRebalanceStartTimestamp, (Object)group.rebalanceStartTimestamp());
        group.transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)group.rebalanceStartTimestamp());
    }

    @Test
    public void testCannotAddPendingMemberIfStable() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().addPendingMember(this.memberId()));
    }

    @Test
    public void testRemovalFromPendingAfterMemberIsStable() {
        this.group().addPendingMember(this.memberId());
        Assertions.assertFalse((boolean)this.group().has(this.memberId()));
        Assertions.assertTrue((boolean)this.group().isPendingMember(this.memberId()));
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertTrue((boolean)this.group().has(this.memberId()));
        Assertions.assertFalse((boolean)this.group().isPendingMember(this.memberId()));
    }

    @Test
    public void testRemovalFromPendingWhenMemberIsRemoved() {
        this.group().addPendingMember(this.memberId());
        Assertions.assertFalse((boolean)this.group().has(this.memberId()));
        Assertions.assertTrue((boolean)this.group().isPendingMember(this.memberId()));
        this.group().remove(this.memberId());
        Assertions.assertFalse((boolean)this.group().has(this.memberId()));
        Assertions.assertFalse((boolean)this.group().isPendingMember(this.memberId()));
    }

    @Test
    public void testCannotAddStaticMemberIfAlreadyPresent() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertTrue((boolean)this.group().has(this.memberId()));
        Assertions.assertTrue((boolean)this.group().hasStaticMember(this.groupInstanceId()));
        Assertions.assertThrows(IllegalStateException.class, () -> {
            GroupMetadata qual$2 = this.group();
            Function1 x$4 = qual$2.add$default$2();
            qual$2.add(member, x$4);
        });
    }

    @Test
    public void testCannotAddPendingSyncOfUnknownMember() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().addPendingSyncMember(this.memberId()));
    }

    @Test
    public void testCannotRemovePendingSyncOfUnknownMember() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().removePendingSyncMember(this.memberId()));
    }

    @Test
    public void testCanAddAndRemovePendingSyncMember() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().removePendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    @Test
    public void testRemovalFromPendingSyncWhenMemberIsRemoved() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().remove(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    @Test
    public void testNewGenerationClearsPendingSyncMembers() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    private void assertState(GroupMetadata group, GroupState targetState) {
        ((Set)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GroupState[]{Stable$.MODULE$, PreparingRebalance$.MODULE$, CompletingRebalance$.MODULE$, Dead$.MODULE$}))).$minus((Object)targetState)).foreach((Function1 & Serializable)otherState -> {
            GroupMetadataTest.$anonfun$assertState$1(group, otherState);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)group.is(targetState));
    }

    private OffsetAndMetadata offsetAndMetadata(long offset, long timestamp) {
        return OffsetAndMetadata$.MODULE$.apply(offset, "", timestamp);
    }

    private long offsetAndMetadata$default$2() {
        return Time.SYSTEM.milliseconds();
    }

    public static final /* synthetic */ void $anonfun$testInitNextGeneration$1(JoinGroupResult x$2) {
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$1(BooleanRef joinAwaitingMemberFenced$1, JoinGroupResult joinGroupResult) {
        Errors errors = joinGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        joinAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$2(BooleanRef syncAwaitingMemberFenced$1, SyncGroupResult syncGroupResult) {
        Errors errors = syncGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        syncAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    private static final void joinCallback$1(JoinGroupResult joinGroupResult, BooleanRef shouldFail$1, ObjectRef result$1) {
        if (shouldFail$1.elem) {
            shouldFail$1.elem = false;
            throw new Exception("Something went wrong!");
        }
        result$1.elem = new Some((Object)joinGroupResult);
    }

    private static final void syncCallback$1(SyncGroupResult syncGroupResult, BooleanRef shouldFail$2, ObjectRef result$2) {
        if (shouldFail$2.elem) {
            shouldFail$2.elem = false;
            throw new Exception("Something went wrong!");
        }
        result$2.elem = new Some((Object)syncGroupResult);
    }

    public static final /* synthetic */ void $anonfun$testInvokeSyncCallback$1(SyncGroupResult x$4) {
    }

    public static final /* synthetic */ void $anonfun$assertState$1(GroupMetadata group$1, GroupState otherState) {
        Assertions.assertFalse((boolean)group$1.is(otherState));
    }

    public GroupMetadataTest() {
        this.protocolType = "consumer";
        this.groupInstanceId = "groupInstanceId";
        this.memberId = "memberId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

