/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.function.Supplier;
import kafka.coordinator.quota.QuotaConsumption;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaCoordinatorConfig$;
import kafka.coordinator.quota.QuotaDescription;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntityAndConsumptions;
import kafka.coordinator.quota.QuotaStateManager;
import kafka.coordinator.quota.ReportQuotaResult;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.quota.ClusterLevelQuotaCallback;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t]a\u0001\u0002\u001c8\u0001yBQ!\u0012\u0001\u0005\u0002\u0019Cq!\u0013\u0001C\u0002\u0013\u0005!\n\u0003\u0004R\u0001\u0001\u0006Ia\u0013\u0005\n%\u0002\u0001\r\u00111A\u0005\u0002MC\u0011B\u0017\u0001A\u0002\u0003\u0007I\u0011A.\t\u0013\u0005\u0004\u0001\u0019!A!B\u0013!\u0006\"\u00032\u0001\u0001\u0004\u0005\r\u0011\"\u0001d\u0011%\u0001\b\u00011AA\u0002\u0013\u0005\u0011\u000fC\u0005t\u0001\u0001\u0007\t\u0011)Q\u0005I\"IA\u000f\u0001a\u0001\u0002\u0004%\t!\u001e\u0005\f\u0003\u000b\u0001\u0001\u0019!a\u0001\n\u0003\t9\u0001\u0003\u0006\u0002\f\u0001\u0001\r\u0011!Q!\nYD1\"!\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0010!Y\u00111\u0004\u0001A\u0002\u0003\u0007I\u0011AA\u000f\u0011-\t\t\u0003\u0001a\u0001\u0002\u0003\u0006K!!\u0005\t\u0017\u0005\r\u0002\u00011AA\u0002\u0013\u0005\u0011Q\u0005\u0005\f\u0003[\u0001\u0001\u0019!a\u0001\n\u0003\ty\u0003C\u0006\u00024\u0001\u0001\r\u0011!Q!\n\u0005\u001d\u0002bCA\u001b\u0001\u0001\u0007\t\u0019!C\u0001\u0003oA1\"a\u0010\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002B!Y\u0011Q\t\u0001A\u0002\u0003\u0005\u000b\u0015BA\u001d\u0011%\t9\u0005\u0001b\u0001\n\u0003\tI\u0005\u0003\u0005\u0002R\u0001\u0001\u000b\u0011BA&\u0011%\t\u0019\u0006\u0001b\u0001\n\u0003\tI\u0005\u0003\u0005\u0002V\u0001\u0001\u000b\u0011BA&\u0011%\t9\u0006\u0001b\u0001\n\u0003\tI\u0006\u0003\u0005\u0002b\u0001\u0001\u000b\u0011BA.\u0011%\t\u0019\u0007\u0001b\u0001\n\u0003\tI\u0006\u0003\u0005\u0002f\u0001\u0001\u000b\u0011BA.\u0011%\t9\u0007\u0001b\u0001\n\u0003\tI\u0007\u0003\u0005\u0002r\u0001\u0001\u000b\u0011BA6\u0011%\t\u0019\b\u0001b\u0001\n\u0003\tI\u0007\u0003\u0005\u0002v\u0001\u0001\u000b\u0011BA6\u0011%\t9\b\u0001b\u0001\n\u0003\tI\b\u0003\u0005\u0002\u0012\u0002\u0001\u000b\u0011BA>\u0011%\t\u0019\n\u0001b\u0001\n\u0003\tI\b\u0003\u0005\u0002\u0016\u0002\u0001\u000b\u0011BA>\u0011%\t9\n\u0001b\u0001\n\u0003\tI\b\u0003\u0005\u0002\u001a\u0002\u0001\u000b\u0011BA>\u0011\u001d\tY\n\u0001C\u0001\u0003;Cq!!.\u0001\t\u0003\ti\nC\u0004\u0002@\u0002!\t!!(\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002\u001e\"9\u0011q\u0019\u0001\u0005\u0002\u0005u\u0005bBAf\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0003\u001f\u0004A\u0011AAO\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003;Cq!a6\u0001\t\u0003\ti\nC\u0004\u0002\\\u0002!\t!!(\t\u000f\u0005}\u0007\u0001\"\u0001\u0002\u001e\"9\u00111\u001d\u0001\u0005\n\u0005\u0015\bbBAy\u0001\u0011%\u00111\u001f\u0005\b\u0005\u0017\u0001A\u0011\u0002B\u0007\u0005Q\tVo\u001c;b\u0007>|'\u000fZ5oCR|'\u000fV3ti*\u0011\u0001(O\u0001\u0006cV|G/\u0019\u0006\u0003um\n1bY8pe\u0012Lg.\u0019;pe*\tA(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0004C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u000fB\u0011\u0001\nA\u0007\u0002o\u000511m\u001c8gS\u001e,\u0012a\u0013\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001dn\naa]3sm\u0016\u0014\u0018B\u0001)N\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005!A/[7f+\u0005!\u0006CA+Y\u001b\u00051&BA,<\u0003\u0015)H/\u001b7t\u0013\tIfK\u0001\u0005N_\u000e\\G+[7f\u0003!!\u0018.\\3`I\u0015\fHC\u0001/`!\t\u0001U,\u0003\u0002_\u0003\n!QK\\5u\u0011\u001d\u0001W!!AA\u0002Q\u000b1\u0001\u001f\u00132\u0003\u0015!\u0018.\\3!\u0003%\u00198\r[3ek2,'/F\u0001e!\t)g.D\u0001g\u0015\t9\u0007.\u0001\u0003vi&d'B\u0001(j\u0015\ta$N\u0003\u0002lY\u00061\u0011\r]1dQ\u0016T\u0011!\\\u0001\u0004_J<\u0017BA8g\u00055iunY6TG\",G-\u001e7fe\u0006i1o\u00195fIVdWM]0%KF$\"\u0001\u0018:\t\u000f\u0001D\u0011\u0011!a\u0001I\u0006Q1o\u00195fIVdWM\u001d\u0011\u0002+%tG/\u001a:oC2\fE-\\5o'V\u0004\b\u000f\\5feV\ta\u000fE\u0002x{~l\u0011\u0001\u001f\u0006\u0003sj\f\u0001BZ;oGRLwN\u001c\u0006\u0003OnT\u0011\u0001`\u0001\u0005U\u00064\u0018-\u0003\u0002\u007fq\nA1+\u001e9qY&,'\u000fE\u0002M\u0003\u0003I1!a\u0001N\u00055Ie\u000e^3s]\u0006d\u0017\tZ7j]\u0006I\u0012N\u001c;fe:\fG.\u00113nS:\u001cV\u000f\u001d9mS\u0016\u0014x\fJ3r)\ra\u0016\u0011\u0002\u0005\bA.\t\t\u00111\u0001w\u0003YIg\u000e^3s]\u0006d\u0017\tZ7j]N+\b\u000f\u001d7jKJ\u0004\u0013!G2mkN$XM\u001d'fm\u0016d\u0017+^8uC\u000e\u000bG\u000e\u001c2bG.,\"!!\u0005\u0011\t\u0005M\u0011qC\u0007\u0003\u0003+Q!\u0001\u000f5\n\t\u0005e\u0011Q\u0003\u0002\u001a\u00072,8\u000f^3s\u0019\u00164X\r\\)v_R\f7)\u00197mE\u0006\u001c7.A\u000fdYV\u001cH/\u001a:MKZ,G.U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\w\fJ3r)\ra\u0016q\u0004\u0005\tA:\t\t\u00111\u0001\u0002\u0012\u0005Q2\r\\;ti\u0016\u0014H*\u001a<fYF+x\u000e^1DC2d'-Y2lA\u0005\t\u0012/^8uCN#\u0018\r^3NC:\fw-\u001a:\u0016\u0005\u0005\u001d\u0002c\u0001%\u0002*%\u0019\u00111F\u001c\u0003#E+x\u000e^1Ti\u0006$X-T1oC\u001e,'/A\u000brk>$\u0018m\u0015;bi\u0016l\u0015M\\1hKJ|F%Z9\u0015\u0007q\u000b\t\u0004\u0003\u0005a#\u0005\u0005\t\u0019AA\u0014\u0003I\tXo\u001c;b'R\fG/Z'b]\u0006<WM\u001d\u0011\u0002!E,x\u000e^1D_>\u0014H-\u001b8bi>\u0014XCAA\u001d!\rA\u00151H\u0005\u0004\u0003{9$\u0001E)v_R\f7i\\8sI&t\u0017\r^8s\u0003Q\tXo\u001c;b\u0007>|'\u000fZ5oCR|'o\u0018\u0013fcR\u0019A,a\u0011\t\u0011\u0001$\u0012\u0011!a\u0001\u0003s\t\u0011#];pi\u0006\u001cun\u001c:eS:\fGo\u001c:!\u0003\r)\u0005kU\u000b\u0003\u0003\u0017\u00022\u0001QA'\u0013\r\ty%\u0011\u0002\u0007\t>,(\r\\3\u0002\t\u0015\u00036\u000bI\u0001\u0017G2,8\u000f^3s)\"\u0014x.^4iaV$\u0018+^8uC\u000692\r\\;ti\u0016\u0014H\u000b\u001b:pk\u001eD\u0007/\u001e;Rk>$\u0018\rI\u0001\u0014EJ|7.\u001a:MS6LG\u000f\u0015:pIV\u001cWM]\u000b\u0003\u00037\u00022\u0001QA/\u0013\r\ty&\u0011\u0002\u0004\u0013:$\u0018\u0001\u00062s_.,'\u000fT5nSR\u0004&o\u001c3vG\u0016\u0014\b%A\nce>\\WM\u001d'j[&$8i\u001c8tk6,'/\u0001\u000bce>\\WM\u001d'j[&$8i\u001c8tk6,'\u000fI\u0001\bK:$\u0018\u000e^=2+\t\tY\u0007E\u0002I\u0003[J1!a\u001c8\u0005-\tVo\u001c;b\u000b:$\u0018\u000e^=\u0002\u0011\u0015tG/\u001b;zc\u0001\nq!\u001a8uSRL('\u0001\u0005f]RLG/\u001f\u001a!\u0003e)g\u000e^5us\u000e{gn];naRLwN\\:Ce>\\WM\u001d\u0019\u0016\u0005\u0005m\u0004CBA?\u0003\u000f\u000bY)\u0004\u0002\u0002\u0000)!\u0011\u0011QAB\u0003%IW.\\;uC\ndWMC\u0002\u0002\u0006\u0006\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI)a \u0003\u0007M+\u0017\u000fE\u0002I\u0003\u001bK1!a$8\u0005i\tVo\u001c;b\u000b:$\u0018\u000e^=B]\u0012\u001cuN\\:v[B$\u0018n\u001c8t\u0003i)g\u000e^5us\u000e{gn];naRLwN\\:Ce>\\WM\u001d\u0019!\u0003e)g\u000e^5us\u000e{gn];naRLwN\\:Ce>\\WM]\u0019\u00025\u0015tG/\u001b;z\u0007>t7/^7qi&|gn\u001d\"s_.,'/\r\u0011\u00023\u0015tG/\u001b;z\u0007>t7/^7qi&|gn\u001d\"s_.,'OM\u0001\u001bK:$\u0018\u000e^=D_:\u001cX/\u001c9uS>t7O\u0011:pW\u0016\u0014(\u0007I\u0001\u0006g\u0016$X\u000b\u001d\u000b\u00029\"\u001a\u0001&!)\u0011\t\u0005\r\u0016\u0011W\u0007\u0003\u0003KSA!a*\u0002*\u0006\u0019\u0011\r]5\u000b\t\u0005-\u0016QV\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\ty\u000b\\\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003g\u000b)K\u0001\u0006CK\u001a|'/Z#bG\"\fA\u0005^3ti\u000e{W\u000e];uKF+x\u000e^1t\u0013:\f7\r^5wK\u000e{wN\u001d3j]\u0006$xN\u001d\u0015\u0004S\u0005e\u0006\u0003BAR\u0003wKA!!0\u0002&\n!A+Z:u\u0003\u0015\"Xm\u001d;D_6\u0004X\u000f^3Rk>$\u0018m]%om\u0006d\u0017\u000eZ)v_R\fWI\u001c;ji&,7\u000fK\u0002+\u0003s\u000bQ\u0005^3ti\u0012+7o\u0019:jE\u0016\fVo\u001c;bg&s\u0017m\u0019;jm\u0016\u001cun\u001c:eS:\fGo\u001c:)\u0007-\nI,\u0001\u0013uKN$H)Z:de&\u0014W-U;pi\u0006\u001cXI\u001c;jif$u.Z:O_R,\u00050[:uQ\ra\u0013\u0011X\u0001,i\u0016\u001cHoQ8naV$X-\u00118e\t\u0016\u001c8M]5cKF+x\u000e^1t/&$\bnQ1qa\u0016$\u0017+^8uC\"\u001aQ&!/\u0002]Q,7\u000f^\"p[B,H/Z!oI\u0012+7o\u0019:jE\u0016\fVo\u001c;bgVsWM^3o\t&\u001cHO]5ckRLwN\u001c\u0015\u0004]\u0005e\u0016!\u000b;fgR\u001cu.\u001c9vi\u0016\fe\u000e\u001a#fg\u000e\u0014\u0018NY3Rk>$\u0018m],iK:$\u0006N]8ui2,G\rK\u00020\u0003s\u000b!\u0004^3ti\u0016C\b/\u001b:f#V|G/Y\"p]N,X\u000e\u001d;j_:D3\u0001MA]\u0003Y!Xm\u001d;BY2TVM]8D_:\u001cX/\u001c9uS>t\u0007fA\u0019\u0002:\u0006iC/Z:u\tft\u0017-\\5d#V|G/\u0019(piR\u0013\u0018nZ4fe\u0016$w+\u001b;i\u0019><H\u000b\u001b:pk\u001eD\u0007/\u001e;)\u0007I\nI,A\u000bd_6\u0004X\u000f^3Rk>$\u0018m]\"bY2\u0014\u0017mY6\u0015\u0007q\u000b9\u000fC\u0004\u0002jN\u0002\r!a;\u0002\rI,7/\u001e7u!\rA\u0015Q^\u0005\u0004\u0003_<$!\u0005*fa>\u0014H/U;pi\u0006\u0014Vm];mi\u0006Ya/\u001a:jMf\fVo\u001c;b)%a\u0016Q_A}\u0003{\u00149\u0001C\u0004\u0002xR\u0002\r!a\u0017\u0002\r\t\u0014xn[3s\u0011\u001d\tY\u0010\u000ea\u0001\u0003W\n1\"];pi\u0006,e\u000e^5us\"9\u0011q \u001bA\u0002\t\u0005\u0011!C9v_R\fG+\u001f9f!\u0011\t\u0019Ba\u0001\n\t\t\u0015\u0011Q\u0003\u0002\u0010\u00072LWM\u001c;Rk>$\u0018\rV=qK\"9!\u0011\u0002\u001bA\u0002\u0005-\u0013!D3ya\u0016\u001cG/\u001a3Rk>$\u0018-A\rhKR\fVo\u001c;b\u0007>|'\u000fZ5oCR|'oQ8oM&<G\u0003\u0002B\b\u0005+\u00012\u0001\u0013B\t\u0013\r\u0011\u0019b\u000e\u0002\u0017#V|G/Y\"p_J$\u0017N\\1u_J\u001cuN\u001c4jO\")\u0011*\u000ea\u0001\u0017\u0002")
public class QuotaCoordinatorTest {
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
    private MockTime time;
    private MockScheduler scheduler;
    private Supplier<InternalAdmin> internalAdminSupplier;
    private ClusterLevelQuotaCallback clusterLevelQuotaCallback;
    private QuotaStateManager quotaStateManager;
    private QuotaCoordinator quotaCoordinator;
    private final double EPS;
    private final double clusterThroughputQuota;
    private final int brokerLimitProducer;
    private final int brokerLimitConsumer;
    private final QuotaEntity entity1 = new QuotaEntity((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"tenant1")})));
    private final QuotaEntity entity2 = new QuotaEntity((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"tenant2")})));
    private final scala.collection.immutable.Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker0 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
    private final scala.collection.immutable.Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker1 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 400.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 300.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
    private final scala.collection.immutable.Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker2 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 5000.0, true), (List)Nil$.MODULE$)), (List)Nil$.MODULE$);

    public KafkaConfig config() {
        return this.config;
    }

    public MockTime time() {
        return this.time;
    }

    public void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    public MockScheduler scheduler() {
        return this.scheduler;
    }

    public void scheduler_$eq(MockScheduler x$1) {
        this.scheduler = x$1;
    }

    public Supplier<InternalAdmin> internalAdminSupplier() {
        return this.internalAdminSupplier;
    }

    public void internalAdminSupplier_$eq(Supplier<InternalAdmin> x$1) {
        this.internalAdminSupplier = x$1;
    }

    public ClusterLevelQuotaCallback clusterLevelQuotaCallback() {
        return this.clusterLevelQuotaCallback;
    }

    public void clusterLevelQuotaCallback_$eq(ClusterLevelQuotaCallback x$1) {
        this.clusterLevelQuotaCallback = x$1;
    }

    public QuotaStateManager quotaStateManager() {
        return this.quotaStateManager;
    }

    public void quotaStateManager_$eq(QuotaStateManager x$1) {
        this.quotaStateManager = x$1;
    }

    public QuotaCoordinator quotaCoordinator() {
        return this.quotaCoordinator;
    }

    public void quotaCoordinator_$eq(QuotaCoordinator x$1) {
        this.quotaCoordinator = x$1;
    }

    public double EPS() {
        return this.EPS;
    }

    public double clusterThroughputQuota() {
        return this.clusterThroughputQuota;
    }

    public int brokerLimitProducer() {
        return this.brokerLimitProducer;
    }

    public int brokerLimitConsumer() {
        return this.brokerLimitConsumer;
    }

    public QuotaEntity entity1() {
        return this.entity1;
    }

    public QuotaEntity entity2() {
        return this.entity2;
    }

    public scala.collection.immutable.Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker0() {
        return this.entityConsumptionsBroker0;
    }

    public scala.collection.immutable.Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker1() {
        return this.entityConsumptionsBroker1;
    }

    public scala.collection.immutable.Seq<QuotaEntityAndConsumptions> entityConsumptionsBroker2() {
        return this.entityConsumptionsBroker2;
    }

    @BeforeEach
    public void setUp() {
        this.time_$eq(new MockTime());
        this.scheduler_$eq(new MockScheduler((Time)this.time()));
        InternalAdmin internalAdmin = (InternalAdmin)EasyMock.createNiceMock(InternalAdmin.class);
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)internalAdmin.ensureTopic((String)EasyMock.eq((Object)"_confluent-quotas"), EasyMock.anyInt(), EasyMock.anyShort(), (Properties)EasyMock.anyObject(Properties.class)))).andReturn((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(this.config().confluentConfig().quotasTopicPartitions()))).anyTimes();
        this.internalAdminSupplier_$eq(() -> internalAdmin);
        this.clusterLevelQuotaCallback_$eq((ClusterLevelQuotaCallback)EasyMock.createNiceMock(ClusterLevelQuotaCallback.class));
        EasyMock.expect((Object)this.clusterLevelQuotaCallback().clusterQuotaLimit((ClientQuotaType)EasyMock.anyObject(ClientQuotaType.class), (java.util.Map)EasyMock.anyObject(java.util.Map.class))).andReturn((Object)Predef$.MODULE$.double2Double(this.clusterThroughputQuota())).anyTimes();
        QuotaCoordinatorConfig quotaCoordinatorConfig = this.getQuotaCoordinatorConfig(this.config());
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.getMagic((TopicPartition)EasyMock.anyObject(TopicPartition.class))).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)((byte)2)))).anyTimes();
        this.quotaStateManager_$eq(new QuotaStateManager(quotaCoordinatorConfig, (Scheduler)this.scheduler(), replicaManager, new Metrics(), (Time)this.time()));
        this.quotaStateManager().startup((Function0)(JFunction0.mcI.sp & Serializable)() -> 50, (Function0)(JFunction0.mcV.sp & Serializable)() -> {});
        this.quotaStateManager().addOwnedPartition(this.quotaStateManager().partitionFor(this.entity1()));
        this.quotaStateManager().addOwnedPartition(this.quotaStateManager().partitionFor(this.entity2()));
        EasyMock.replay((Object[])new Object[]{internalAdmin, this.clusterLevelQuotaCallback(), replicaManager});
        this.quotaCoordinator_$eq(new QuotaCoordinator(this.config().brokerId(), quotaCoordinatorConfig, this.quotaStateManager(), (Scheduler)this.scheduler(), this.internalAdminSupplier(), this.clusterLevelQuotaCallback(), (Time)this.time()));
    }

    @Test
    public void testComputeQuotasInactiveCoordinator() {
        this.quotaCoordinator().computeQuotas(0, this.entityConsumptionsBroker0(), (Function1 & Serializable)result -> {
            this.callback$1(result);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testComputeQuotasInvalidQuotaEntities() {
        this.quotaStateManager().removeOwnedPartition(this.quotaStateManager().partitionFor(this.entity1()));
        this.quotaStateManager().addLoadingPartition(this.quotaStateManager().partitionFor(this.entity1()));
        this.quotaCoordinator().isActive().set(true);
        this.quotaCoordinator().computeQuotas(0, this.entityConsumptionsBroker0(), (Function1 & Serializable)result -> {
            this.callback$2(result);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeQuotasInactiveCoordinator() {
        void var3_3;
        void var2_2;
        Tuple2 tuple2 = this.quotaCoordinator().describeQuota(this.entity1());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription quotaDescription = (QuotaDescription)tuple2._2();
        Assertions.assertEquals((Object)var2_2, (Object)Errors.COORDINATOR_NOT_AVAILABLE, (String)new StringBuilder(24).append("Got error ").append(var2_2).append(" but expected ").append(Errors.COORDINATOR_NOT_AVAILABLE).toString());
        Assertions.assertEquals((Object)new QuotaDescription((Map)Predef$.MODULE$.Map().empty()), (Object)var3_3, (String)new StringBuilder(32).append("Got non-empty quota description ").append(var3_3).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeQuotasEntityDoesNotExist() {
        void var3_3;
        void var2_2;
        this.quotaCoordinator().isActive().set(true);
        Tuple2 tuple2 = this.quotaCoordinator().describeQuota(this.entity1());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription quotaDescription = (QuotaDescription)tuple2._2();
        Assertions.assertEquals((Object)var2_2, (Object)Errors.QUOTA_ENTITY_NOT_FOUND, (String)new StringBuilder(24).append("Got error ").append(var2_2).append(" but expected ").append(Errors.QUOTA_ENTITY_NOT_FOUND).toString());
        Assertions.assertEquals((Object)new QuotaDescription((Map)Predef$.MODULE$.Map().empty()), (Object)var3_3, (String)new StringBuilder(32).append("Got non-empty quota description ").append(var3_3).toString());
    }

    @Test
    public void testComputeAndDescribeQuotasWithCappedQuota() {
        this.quotaCoordinator().isActive().set(true);
        this.quotaCoordinator().computeQuotas(0, this.entityConsumptionsBroker0(), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(0, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(1, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
        this.quotaCoordinator().computeQuotas(1, this.entityConsumptionsBroker1(), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(0, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
    }

    @Test
    public void testComputeAndDescribeQuotasUnevenDistribution() {
        this.quotaCoordinator().isActive().set(true);
        .colon.colon consumptionBroker0 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(0, (Iterable)consumptionBroker0, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(0, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(1, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
        .colon.colon consumptionBroker1 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 1000.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 1000.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(1, (Iterable)consumptionBroker1, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(0, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity2(), ClientQuotaType.PRODUCE, 0.0);
        .colon.colon consumptionBroker2 = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 150.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(2, (Iterable)consumptionBroker2, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 2800.0);
        this.verifyQuota(0, this.entity2(), ClientQuotaType.PRODUCE, 3500.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity2(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 4200.0);
        this.verifyQuota(2, this.entity2(), ClientQuotaType.PRODUCE, 3500.0);
    }

    @Test
    public void testComputeAndDescribeQuotasWhenThrottled() {
        this.quotaCoordinator().isActive().set(true);
        .colon.colon consumption = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(0, (Iterable)consumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        this.quotaCoordinator().computeQuotas(1, (Iterable)consumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        .colon.colon consumptionThrottled = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, true), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, true), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(2, (Iterable)consumptionThrottled, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        double broker2Quota = (double)12000 * (1.1 / 3.1);
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, ((double)12000 - broker2Quota) / (double)2);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, ((double)12000 - broker2Quota) / (double)2);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, broker2Quota);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testExpireQuotaConsumption() {
        void var4_4;
        void var3_3;
        this.quotaCoordinator().isActive().set(true);
        .colon.colon consumption = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity2(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 100.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        this.quotaCoordinator().computeQuotas(0, (Iterable)consumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(1, (Iterable)consumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(2, (Iterable)consumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 4000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 4000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 4000.0);
        this.time().sleep(2 * (this.quotaCoordinator().quotaConfig().quotasConsumptionExpirationTimeMs() / 3));
        this.quotaCoordinator().computeQuotas(0, (Iterable)consumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(1, (Iterable)consumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 4000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 4000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 4000.0);
        this.time().sleep(2 * (this.quotaCoordinator().quotaConfig().quotasConsumptionExpirationTimeMs() / 3));
        this.quotaCoordinator().computeQuotas(0, (Iterable)consumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(1, (Iterable)consumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, 5000.0);
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, 0.0);
        Tuple2 tuple2 = this.quotaCoordinator().describeQuota(this.entity1());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription quotaDescription = (QuotaDescription)tuple2._2();
        Assertions.assertEquals((Object)var3_3, (Object)Errors.NONE, (String)new StringBuilder(10).append("Got error ").append(var3_3).toString());
        Assertions.assertFalse((boolean)var4_4.brokerQuotas().contains((Object)BoxesRunTime.boxToInteger((int)2)));
    }

    @Test
    public void testAllZeroConsumption() {
        this.quotaCoordinator().isActive().set(true);
        .colon.colon zeroConsumption = new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 0.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$);
        this.quotaCoordinator().computeQuotas(0, (Iterable)zeroConsumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(1, (Iterable)zeroConsumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(2, (Iterable)zeroConsumption, (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, this.brokerLimitProducer());
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, this.brokerLimitProducer());
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, this.brokerLimitProducer());
    }

    @Test
    public void testDynamicQuotaNotTriggeredWithLowThroughput() {
        this.quotaCoordinator().isActive().set(true);
        this.quotaCoordinator().computeQuotas(0, (Iterable)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 10.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(1, (Iterable)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 20.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.quotaCoordinator().computeQuotas(2, (Iterable)new .colon.colon((Object)new QuotaEntityAndConsumptions(this.entity1(), (Seq)new .colon.colon((Object)new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 30.0, false), (List)Nil$.MODULE$)), (List)Nil$.MODULE$), (Function1 & Serializable)result -> {
            this.computeQuotasCallback(result);
            return BoxedUnit.UNIT;
        });
        this.verifyQuota(0, this.entity1(), ClientQuotaType.PRODUCE, this.brokerLimitProducer());
        this.verifyQuota(1, this.entity1(), ClientQuotaType.PRODUCE, this.brokerLimitProducer());
        this.verifyQuota(2, this.entity1(), ClientQuotaType.PRODUCE, this.brokerLimitProducer());
    }

    private void computeQuotasCallback(ReportQuotaResult result) {
        result.entityErrors().foreach((Function1 & Serializable)x0$1 -> {
            QuotaCoordinatorTest.$anonfun$computeQuotasCallback$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void verifyQuota(int broker, QuotaEntity quotaEntity, ClientQuotaType quotaType, double expectedQuota) {
        void var7_6;
        void var8_7;
        Tuple2 tuple2 = this.quotaCoordinator().describeQuota(quotaEntity);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription quotaDescription = (QuotaDescription)tuple2._2();
        double computedQuota = BoxesRunTime.unboxToDouble((Object)((MapOps)var8_7.brokerQuotas().getOrElse((Object)BoxesRunTime.boxToInteger((int)broker), (Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())).getOrElse((Object)quotaType.toString(), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
        Assertions.assertEquals((Object)Errors.NONE, (Object)var7_6, (String)new StringBuilder(40).append("Got error ").append(var7_6).append(" when describing quota entity ").append(quotaEntity).toString());
        Assertions.assertEquals((double)expectedQuota, (double)computedQuota, (double)this.EPS(), (String)new StringBuilder(53).append("Got quota ").append(computedQuota).append(" on broker ").append(broker).append(" for quota entity ").append(quotaEntity).append(" but expected ").append(expectedQuota).toString());
    }

    private QuotaCoordinatorConfig getQuotaCoordinatorConfig(KafkaConfig config) {
        int x$1 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicPartitions());
        short x$2 = Predef$.MODULE$.Short2short(config.confluentConfig().quotasTopicReplicationFactor());
        int x$3 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicSegmentBytes());
        int x$4 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasLoadBufferSize());
        CompressionType x$5 = config.confluentConfig().quotasTopicCompressionType();
        int x$6 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicAppendTimeoutMs());
        String x$7 = config.confluentConfig().quotasTopicPlacementConstraints();
        int x$8 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasExpirationTimeMs());
        int x$9 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasExpirationIntervalMs());
        int x$10 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasConsumptionExpirationTimeMs());
        long x$11 = this.brokerLimitProducer();
        long x$12 = this.brokerLimitConsumer();
        QuotaCoordinatorConfig$ apply$default$13_this = QuotaCoordinatorConfig$.MODULE$;
        Object var18_14 = null;
        long x$14 = apply$default$13_this.DefaultQuotasRecomputeIntervalMs();
        return new QuotaCoordinatorConfig(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$14, 0.01);
    }

    public static final /* synthetic */ void $anonfun$testComputeQuotasInactiveCoordinator$1(ReportQuotaResult result$1, QuotaEntityAndConsumptions entityAndConsumption) {
        Option option = result$1.entityErrors().get((Object)entityAndConsumption.entity());
        if (option instanceof Some) {
            Errors error = (Errors)((Some)option).value();
            Assertions.assertEquals((Object)Errors.COORDINATOR_NOT_AVAILABLE, (Object)error, (String)new StringBuilder(42).append("Got error ").append(error).append(" for quota entity ").append(entityAndConsumption.entity()).append(" but expected ").append(Errors.COORDINATOR_NOT_AVAILABLE).toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(36).append("Did not get status for quota entity ").append(entityAndConsumption.entity()).toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    private final void callback$1(ReportQuotaResult result) {
        this.entityConsumptionsBroker0().foreach((Function1 & Serializable)entityAndConsumption -> {
            QuotaCoordinatorTest.$anonfun$testComputeQuotasInactiveCoordinator$1(result, entityAndConsumption);
            return BoxedUnit.UNIT;
        });
    }

    private final void callback$2(ReportQuotaResult result) {
        Assertions.assertEquals((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)result.entityErrors().apply((Object)this.entity1()), (String)new StringBuilder(24).append("Got error ").append(result.entityErrors().apply((Object)this.entity1())).append(" but expected ").append(Errors.COORDINATOR_LOAD_IN_PROGRESS).toString());
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)result.entityErrors().apply((Object)this.entity2()), (String)new StringBuilder(24).append("Got error ").append(result.entityErrors().apply((Object)this.entity2())).append(" but expected ").append(Errors.NOT_COORDINATOR).toString());
    }

    public static final /* synthetic */ void $anonfun$computeQuotasCallback$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            QuotaEntity quotaEntity = (QuotaEntity)x0$1._1();
            Errors error = (Errors)x0$1._2();
            Assertions.assertEquals((Object)Errors.NONE, (Object)error, (String)new StringBuilder(49).append("Got error ").append(error).append(" when reporting usage for quota entity ").append(quotaEntity).toString());
            return;
        }
        throw new MatchError(null);
    }

    public QuotaCoordinatorTest() {
        this.EPS = 1.0E-4;
        this.clusterThroughputQuota = 12000.0;
        this.brokerLimitProducer = 5000;
        this.brokerLimitConsumer = 5000;
    }
}

