/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kafka.durability.DurabilityTestUtilConstants$;
import kafka.durability.DurabilityTestUtils$;
import kafka.durability.TestBrokerAuditManager;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.audit.DurabilityAuditConfig$;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.job.BrokerAuditJob$;
import kafka.durability.audit.manager.DurabilityAuditCheck$;
import kafka.durability.db.DbTestUtils$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.DurabilityEventType$;
import kafka.durability.materialization.AbstractDurabilityEventsMaterialize;
import kafka.durability.materialization.BrokerDurabilityEventsMaterialize;
import kafka.durability.topic.DurabilityTopicConfig;
import kafka.durability.topic.DurabilityTopicConsumer;
import kafka.durability.topic.DurabilityTopicManager;
import kafka.durability.topic.DurabilityTopicProducer;
import kafka.durability.utils.DurabilityOffsetMapUtils$;
import kafka.durability.utils.OffsetInfo;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.TierLogSegment;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tools.TierMetadataValidatorTest;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.ConfluentLogConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.test.TestUtils;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.SortedMap;
import scala.collection.mutable.SortedMap$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class DurabilityTestUtils$ {
    public static final DurabilityTestUtils$ MODULE$ = new DurabilityTestUtils$();
    private static int offset = 0;
    private static final Supplier<InternalAdmin> internalAdminSupplier = new Supplier<InternalAdmin>(){

        public InternalAdmin get() {
            return (InternalAdmin)Mockito.mock(InternalAdmin.class);
        }
    };

    public int offset() {
        return offset;
    }

    public void offset_$eq(int x$1) {
        offset = x$1;
    }

    public Supplier<InternalAdmin> internalAdminSupplier() {
        return internalAdminSupplier;
    }

    public DurabilityDB getDB(String topic, int partition) {
        DurabilityDB db = DbTestUtils$.MODULE$.getDbInstance();
        DbTestUtils$.MODULE$.addPartition(db, topic, partition);
        return db;
    }

    public DurabilityTopicConfig getDurabilityConfig() {
        return new DurabilityTopicConfig(() -> Collections.singletonMap("bootstrap.servers", "localhost:80"), "test-topic", 50, 3, 2, "test-cluster", 10000L, Predef$.MODULE$.int2Integer(6000), DurabilityAuditConstants$.MODULE$.DURABILITY_TOPIC_RETENTION_MS(), false, (Option)None$.MODULE$);
    }

    public DurabilityTopicManager getDurabilityTopicManager(DurabilityDB db, BlockingQueue<ConsumerRecords<byte[], byte[]>> topicPartitionQueue, Option<BlockingQueue<ConsumerRecords<byte[], byte[]>>> resultQueue) {
        return new DurabilityTopicManager(db, topicPartitionQueue, resultQueue){
            private DurabilityTopicConsumer consumerProvider;
            private DurabilityTopicProducer producerProvider;
            private volatile byte bitmap$0;
            private final BlockingQueue topicPartitionQueue$1;
            private DurabilityDB db$1;
            private Option resultQueue$1;

            /*
             * WARNING - void declaration
             */
            private DurabilityTopicConsumer consumerProvider$lzycompute() {
                synchronized (this) {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        void getDurabilityConsumer_resultQueue;
                        Option option = this.resultQueue$1;
                        DurabilityDB getDurabilityConsumer_db = this.db$1;
                        BlockingQueue getDurabilityConsumer_topicPartitionQueue = this.topicPartitionQueue$1;
                        Object var1_3 = null;
                        Object var2_2 = null;
                        option = null;
                        this.consumerProvider = new DurabilityTopicConsumer(getDurabilityConsumer_db, getDurabilityConsumer_topicPartitionQueue, (Option)getDurabilityConsumer_resultQueue){
                            private KafkaConsumer<byte[], byte[]> consumer;
                            private volatile boolean bitmap$0;
                            public final BlockingQueue topicPartitionQueue$2;
                            private final Option resultQueue$2;

                            private KafkaConsumer<byte[], byte[]> consumer$lzycompute() {
                                synchronized (this) {
                                    if (!this.bitmap$0) {
                                        this.consumer = new KafkaConsumer<byte[], byte[]>(this){
                                            private final /* synthetic */ anon.3 $outer;

                                            public ConsumerRecords<byte[], byte[]> poll(Duration timeout) {
                                                return (ConsumerRecords)this.$outer.topicPartitionQueue$2.poll(timeout.toMillis(), TimeUnit.MILLISECONDS);
                                            }

                                            public void seek(TopicPartition partition, long offset) {
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                super(DurabilityTestUtils$.MODULE$.getDurabilityConfig().toConsumerProperties("dummy"));
                                            }
                                        };
                                        this.bitmap$0 = true;
                                    }
                                }
                                return this.consumer;
                            }

                            public KafkaConsumer<byte[], byte[]> consumer() {
                                if (!this.bitmap$0) {
                                    return this.consumer$lzycompute();
                                }
                                return this.consumer;
                            }

                            public void processRecords(ConsumerRecords<byte[], byte[]> records) {
                                Option option = this.resultQueue$2;
                                if (option instanceof Some) {
                                    BlockingQueue queue = (BlockingQueue)((Some)option).value();
                                    if (records != null) {
                                        queue.put(records);
                                        return;
                                    }
                                    return;
                                }
                            }
                            {
                                this.topicPartitionQueue$2 = topicPartitionQueue$2;
                                this.resultQueue$2 = resultQueue$2;
                                super(DurabilityTestUtils$.MODULE$.getDurabilityConfig(), db$2, (AbstractDurabilityEventsMaterialize)Mockito.mock(BrokerDurabilityEventsMaterialize.class));
                            }
                        };
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    }
                }
                this.db$1 = null;
                this.resultQueue$1 = null;
                return this.consumerProvider;
            }

            public DurabilityTopicConsumer consumerProvider() {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    return this.consumerProvider$lzycompute();
                }
                return this.consumerProvider;
            }

            private DurabilityTopicProducer producerProvider$lzycompute() {
                synchronized (this) {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        BlockingQueue getDurabilityProducer_queue = this.topicPartitionQueue$1;
                        DurabilityTopicConfig getDurabilityProducer_config = DurabilityTestUtils$.MODULE$.getDurabilityConfig();
                        Object var1_2 = null;
                        Object var2_1 = null;
                        this.producerProvider = new DurabilityTopicProducer(getDurabilityProducer_config, getDurabilityProducer_queue){
                            private KafkaProducer<byte[], byte[]> get;
                            private KafkaProducer<byte[], byte[]> producer;
                            private volatile boolean bitmap$0;
                            public final BlockingQueue queue$1;

                            private KafkaProducer<byte[], byte[]> producer() {
                                return this.producer;
                            }

                            private KafkaProducer<byte[], byte[]> get$lzycompute() {
                                synchronized (this) {
                                    if (!this.bitmap$0) {
                                        this.get = this.producer();
                                        this.bitmap$0 = true;
                                    }
                                }
                                this.producer = null;
                                return this.get;
                            }

                            public KafkaProducer<byte[], byte[]> get() {
                                if (!this.bitmap$0) {
                                    return this.get$lzycompute();
                                }
                                return this.get;
                            }
                            {
                                this.queue$1 = queue$1;
                                super(config$1);
                                this.producer = new KafkaProducer<byte[], byte[]>(this){
                                    private final /* synthetic */ anon.5 $outer;

                                    public Future<RecordMetadata> send(ProducerRecord<byte[], byte[]> record) {
                                        this.$outer.queue$1.add(DurabilityTestUtils$.MODULE$.kafka$durability$DurabilityTestUtils$$toConsumerRecord(record));
                                        return (Future)Mockito.mock(Future.class);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        super(DurabilityTestUtils$.MODULE$.getDurabilityConfig().toProducerProperties("dummy"));
                                    }
                                };
                            }
                        };
                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                    }
                }
                return this.producerProvider;
            }

            public DurabilityTopicProducer producerProvider() {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    return this.producerProvider$lzycompute();
                }
                return this.producerProvider;
            }
            {
                this.topicPartitionQueue$1 = topicPartitionQueue$1;
                this.db$1 = db$1;
                this.resultQueue$1 = resultQueue$1;
                DurabilityTopicConfig x$1 = DurabilityTestUtils$.MODULE$.getDurabilityConfig();
                BrokerDurabilityEventsMaterialize x$3 = (BrokerDurabilityEventsMaterialize)Mockito.mock(BrokerDurabilityEventsMaterialize.class);
                Supplier<InternalAdmin> x$4 = DurabilityTestUtils$.MODULE$.internalAdminSupplier();
                Time x$6 = Time.SYSTEM;
                super(x$1, db$1, (AbstractDurabilityEventsMaterialize)x$3, x$4, x$6, true);
            }
        };
    }

    public BlockingQueue<ConsumerRecords<byte[], byte[]>> getDurabilityTopicManager$default$2() {
        return new ArrayBlockingQueue<ConsumerRecords<byte[], byte[]>>(DurabilityTestUtilConstants$.MODULE$.TEST_QUEUE_SIZE());
    }

    public Option<BlockingQueue<ConsumerRecords<byte[], byte[]>>> getDurabilityTopicManager$default$3() {
        return None$.MODULE$;
    }

    public ConsumerRecords<byte[], byte[]> kafka$durability$DurabilityTestUtils$$toConsumerRecord(ProducerRecord<byte[], byte[]> record) {
        HashMap records = new HashMap();
        ConsumerRecord crecord = new ConsumerRecord(record.topic(), Predef$.MODULE$.Integer2int(record.partition()), (long)this.offset(), record.key(), record.value());
        this.offset_$eq(this.offset() + 1);
        ArrayList<ConsumerRecord> crecords = new ArrayList<ConsumerRecord>();
        crecords.add(crecord);
        records.put(new TopicPartition(record.topic(), Predef$.MODULE$.Integer2int(record.partition())), crecords);
        return new ConsumerRecords(records);
    }

    public DurabilityTopicConsumer getDurabilityConsumer(BlockingQueue<ConsumerRecords<byte[], byte[]>> topicPartitionQueue, DurabilityDB db, Option<BlockingQueue<ConsumerRecords<byte[], byte[]>>> resultQueue) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    public Option<BlockingQueue<ConsumerRecords<byte[], byte[]>>> getDurabilityConsumer$default$3() {
        return None$.MODULE$;
    }

    public DurabilityTopicProducer getDurabilityProducer(DurabilityTopicConfig config, BlockingQueue<ConsumerRecords<byte[], byte[]>> queue) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    public DurabilityAuditConfig durabilityAuditConfig(Time time, boolean enableAuditRun, Set<Enumeration.Value> auditChecks, Set<Enumeration.Value> allowedEvents, File dbPath, long initialAuditJobDelay, int nodeId) {
        Supplier<InternalAdmin> x$3 = this.internalAdminSupplier();
        Supplier<Map> x$4 = () -> Collections.singletonMap("bootstrap.servers", "localhost:80");
        Metrics x$5 = new Metrics(new MetricConfig(), Collections.emptyList(), time);
        None$ x$12 = None$.MODULE$;
        short x$15 = 3;
        short x$16 = 50;
        long x$17 = 900000L;
        long x$18 = 900000L;
        long x$19 = 0xA00000L;
        long x$20 = DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS();
        long x$21 = DurabilityAuditConstants$.MODULE$.TIER_TOPIC_CONSUMER_POLL_DURATION_MS();
        int x$22 = DurabilityAuditConstants$.MODULE$.TIER_BATCH_RECORDS_TO_CONSUME();
        int x$23 = DurabilityAuditConstants$.MODULE$.TIER_TOPIC_MAX_LOOK_BACK_IN_DAYS();
        boolean x$24 = DurabilityAuditConstants$.MODULE$.DURABILITY_IDEMPOTENT_PRODUCER();
        List x$25 = DurabilityAuditConfig$.MODULE$.apply$default$25();
        return new DurabilityAuditConfig(0, "test", x$3, x$4, x$5, enableAuditRun, auditChecks, allowedEvents, dbPath, 3, initialAuditJobDelay, (Option)x$12, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, nodeId, true, x$25);
    }

    public boolean durabilityAuditConfig$default$2() {
        return true;
    }

    public Set<Enumeration.Value> durabilityAuditConfig$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public Set<Enumeration.Value> durabilityAuditConfig$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    public int durabilityAuditConfig$default$7() {
        return DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
    }

    public void initializeTestAuditManager(TestBrokerAuditManager testAuditManagerTrait, Time time, ReplicaManager replicaManager, Option<TierObjectStore> tierObjectStoreOpt, boolean enableAuditRun, Set<Enumeration.Value> auditChecks, Set<Enumeration.Value> allowedEvents, Option<TopicPartition> initialTopicPartitionOpt, int nodeId, Option<File> dbPathOpt) {
        File file;
        if (dbPathOpt.isEmpty()) {
            File tmpDir = TestUtils.tempDirectory(null, null);
            file = TestUtils$.MODULE$.randomPartitionLogDir(tmpDir);
        } else {
            file = (File)dbPathOpt.get();
        }
        File dbPath = file;
        testAuditManagerTrait.initialize(this.durabilityAuditConfig(time, enableAuditRun, auditChecks, allowedEvents, dbPath, Predef$.MODULE$.Long2long(ConfluentConfigs.DURABILITY_AUDIT_INITIAL_JOB_DELAY_MS_DEFAULT), nodeId), replicaManager, tierObjectStoreOpt, time);
        initialTopicPartitionOpt.foreach((Function1 & Serializable)tp -> {
            DbTestUtils$.MODULE$.addPartition(testAuditManagerTrait.instance().db(), tp.topic(), tp.partition());
            return BoxedUnit.UNIT;
        });
    }

    public Time initializeTestAuditManager$default$2() {
        return new MockTime();
    }

    public ReplicaManager initializeTestAuditManager$default$3() {
        return (ReplicaManager)Mockito.mock(ReplicaManager.class);
    }

    public Option<TierObjectStore> initializeTestAuditManager$default$4() {
        return None$.MODULE$;
    }

    public boolean initializeTestAuditManager$default$5() {
        return true;
    }

    public Set<Enumeration.Value> initializeTestAuditManager$default$6() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit()}));
    }

    public Set<Enumeration.Value> initializeTestAuditManager$default$7() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityEventType$.MODULE$.DeleteRecordsType(), DurabilityEventType$.MODULE$.IsrExpandType(), DurabilityEventType$.MODULE$.EpochChangeType(), DurabilityEventType$.MODULE$.RetentionChangeType(), DurabilityEventType$.MODULE$.StartOffsetChangeType(), DurabilityEventType$.MODULE$.OffsetChangeType(), DurabilityEventType$.MODULE$.DeletePartitionType(), DurabilityEventType$.MODULE$.HealthCheckType()}));
    }

    public Option<TopicPartition> initializeTestAuditManager$default$8() {
        return None$.MODULE$;
    }

    public int initializeTestAuditManager$default$9() {
        return DurabilityTestUtilConstants$.MODULE$.DEFAULT_TEST_NODE_ID();
    }

    public Option<File> initializeTestAuditManager$default$10() {
        return None$.MODULE$;
    }

    public AbstractLog mockLogWithPreLoadedData(kafka.tier.TopicIdPartition tpId, Seq<Tuple2<Object, Object>> localOffsets, File logDir, Time time, Seq<Tuple2<Object, Object>> tierOffsets, Option<TierObjectStore> tierObjStoreOpt) {
        if (tierOffsets.nonEmpty() && tierObjStoreOpt.isEmpty()) {
            throw new IllegalStateException(new StringBuilder(56).append("Received empty tierObjStore with non-empty tierOffsets: ").append(tierOffsets).toString());
        }
        Seq localLogs = (Seq)localOffsets.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                long start = x0$1._1$mcJ$sp();
                long end = x0$1._2$mcJ$sp();
                int x$5 = 10;
                long x$6 = -1L;
                return LogTestUtils$.MODULE$.createLocalLogSegment(start, end, logDir, x$5, time, x$6);
            }
            throw new MatchError(null);
        });
        Seq tierLogs = (Seq)tierOffsets.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                long start = x0$2._1$mcJ$sp();
                long end = x0$2._2$mcJ$sp();
                TierLogSegment tierSegment = LogTestUtils$.MODULE$.createTierLogSegment(tpId, start, end, (TierObjectStore)tierObjStoreOpt.get(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L, TierObjectMetadata.State.INVALID, TierUploadType.Archive);
                TierMetadataValidatorTest.uploadSegmentToObjectStore(BrokerAuditJob$.MODULE$.getTierObjectMetadata(tierSegment), (TierObjectStore)tierObjStoreOpt.get());
                return tierSegment;
            }
            throw new MatchError(null);
        });
        long logStartOffset = BoxesRunTime.unboxToLong((Object)tierOffsets.headOption().map((Function1 & Serializable)first -> BoxesRunTime.boxToLong((long)first._1$mcJ$sp())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> ((Tuple2)localOffsets.head())._1$mcJ$sp()));
        long logEndOffset = ((Tuple2)((IterableOps)localOffsets.takeRight(1)).head())._2$mcJ$sp();
        TopicPartition x$7 = tpId.topicPartition();
        Some x$10 = new Some((Object)BoxesRunTime.boxToLong((long)logStartOffset));
        Some x$11 = new Some((Object)BoxesRunTime.boxToLong((long)logEndOffset));
        None$ x$12 = None$.MODULE$;
        boolean x$13 = false;
        boolean x$14 = false;
        None$ x$15 = None$.MODULE$;
        None$ x$16 = None$.MODULE$;
        return this.mockLog(x$7, (Seq<LogSegment>)localLogs, (Seq<TierLogSegment>)tierLogs, (Option<Seq<TierLogSegment>>)x$12, (Option<Object>)x$10, (Option<Object>)x$11, x$13, x$14, (Option<TierPartitionState>)x$15, (Option<Uuid>)x$16);
    }

    public TierPartitionState mockTierPartitionState(Option<Seq<TierLogSegment>> onRetryTieredSegments) {
        TierPartitionState mockTierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)mockTierPartitionState.metadata(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            Long offset = (Long)invocation.getArgument(0, Long.class);
            if (onRetryTieredSegments instanceof Some) {
                Seq segments = (Seq)((Some)onRetryTieredSegments).value();
                return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(segments.find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DurabilityTestUtils$.$anonfun$mockTierPartitionState$2(offset, s)))));
            }
            return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8((Option)None$.MODULE$));
        });
        return mockTierPartitionState;
    }

    public Option<Seq<TierLogSegment>> mockTierPartitionState$default$1() {
        return None$.MODULE$;
    }

    public AbstractLog mockLog(TopicPartition topicPartition, Seq<LogSegment> localSegments, Seq<TierLogSegment> tieredSegments, Option<Seq<TierLogSegment>> onRetryTieredSegments, Option<Object> logStartOffsetOpt, Option<Object> logEndOffsetOpt, boolean compacted, boolean tierCompacted, Option<TierPartitionState> tierPartitionStateOpt, Option<Uuid> topicId) {
        MergedLog mockLog = (MergedLog)Mockito.mock(MergedLog.class);
        Mockito.when((Object)mockLog.localLogSegments()).thenReturn(localSegments);
        Mockito.when((Object)mockLog.tieredLogSegments()).thenReturn((Object)tieredSegments.iterator());
        Mockito.when((Object)mockLog.topicPartition()).thenReturn((Object)topicPartition);
        Mockito.when((Object)mockLog.topicIdPartition()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mockLog.isTierCompactable())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)tierCompacted));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mockLog.isLocallyCompactable())).thenReturn((Object)BoxesRunTime.boxToBoolean((compacted && !tierCompacted ? 1 : 0) != 0));
        Mockito.when((Object)mockLog.topicId()).thenReturn(topicId);
        LogConfig mockConfig = (LogConfig)Mockito.mock(LogConfig.class);
        ConfluentLogConfig mockConfluentLogConfig = (ConfluentLogConfig)Mockito.mock(ConfluentLogConfig.class);
        Mockito.when((Object)mockConfig.confluentLogConfig()).thenReturn((Object)mockConfluentLogConfig);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mockConfluentLogConfig.tierEnable())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)tieredSegments.nonEmpty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mockConfig.compact())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)compacted));
        Mockito.when((Object)mockLog.config()).thenReturn((Object)mockConfig);
        Mockito.when((Object)mockLog.tieredLogSegments(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn((Object)((IterableOnce)tieredSegments.drop(tieredSegments.size() - 1)).iterator());
        logStartOffsetOpt.foreach((Function1 & Serializable)start -> DurabilityTestUtils$.$anonfun$mockLog$1(mockLog, BoxesRunTime.unboxToLong((Object)start)));
        logEndOffsetOpt.foreach((Function1 & Serializable)end -> DurabilityTestUtils$.$anonfun$mockLog$2(mockLog, BoxesRunTime.unboxToLong((Object)end)));
        if (localSegments.nonEmpty()) {
            Mockito.when((Object)BoxesRunTime.boxToLong((long)mockLog.localLogStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(((LogSegment)localSegments.head()).baseOffset()), BoxesRunTime.unboxToLong((Object)logStartOffsetOpt.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)))));
        }
        TierPartitionState mockTPS = (TierPartitionState)tierPartitionStateOpt.getOrElse((Function0 & Serializable)() -> MODULE$.mockTierPartitionState(onRetryTieredSegments));
        Mockito.when((Object)mockTPS.topicPartition()).thenReturn((Object)topicPartition);
        Mockito.when((Object)mockLog.tierPartitionState()).thenReturn((Object)mockTPS);
        return mockLog;
    }

    public Option<TierObjectStore> mockLogWithPreLoadedData$default$6() {
        return None$.MODULE$;
    }

    public Option<Seq<TierLogSegment>> mockLog$default$4() {
        return None$.MODULE$;
    }

    public Option<Object> mockLog$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> mockLog$default$6() {
        return None$.MODULE$;
    }

    public boolean mockLog$default$7() {
        return false;
    }

    public boolean mockLog$default$8() {
        return false;
    }

    public Option<TierPartitionState> mockLog$default$9() {
        return None$.MODULE$;
    }

    public Option<Uuid> mockLog$default$10() {
        return None$.MODULE$;
    }

    public LogManager mockLogManager(scala.collection.immutable.Map<TopicPartition, AbstractLog> logMap) {
        LogManager mockLogManager = (LogManager)Mockito.mock(LogManager.class);
        logMap.keys().foreach((Function1 & Serializable)topicPartition -> Mockito.when((Object)mockLogManager.getLog(topicPartition, mockLogManager.getLog$default$2())).thenReturn((Object)new Some(logMap.apply(topicPartition))));
        return mockLogManager;
    }

    public ReplicaManager mockReplicaManager(LogManager logManager) {
        ReplicaManager mockReplicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)mockReplicaManager.logManager()).thenReturn((Object)logManager);
        return mockReplicaManager;
    }

    public ReplicaManager mockReplicaManager(KafkaConfig config, LogManager logManager) {
        ReplicaManager mockReplicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)mockReplicaManager.config()).thenReturn((Object)config);
        Mockito.when((Object)mockReplicaManager.logManager()).thenReturn((Object)logManager);
        return mockReplicaManager;
    }

    public Seq<LogSegment> getLocalSegmentsWithGap(File logDir, long totalGapCount, long startOffset, int size) {
        LogSegment segment1 = LogTestUtils$.MODULE$.createLocalLogSegment(startOffset, startOffset + (long)size, logDir, 10, Time.SYSTEM, -1L);
        long nextSegmentStartOffset = startOffset + (long)size + totalGapCount + 1L;
        LogSegment segment2 = LogTestUtils$.MODULE$.createLocalLogSegment(nextSegmentStartOffset, nextSegmentStartOffset + (long)size, logDir, 10, Time.SYSTEM, -1L);
        return new .colon.colon((Object)segment1, (List)new .colon.colon((Object)segment2, (List)Nil$.MODULE$));
    }

    public long getLocalSegmentsWithGap$default$3() {
        return 0L;
    }

    public int getLocalSegmentsWithGap$default$4() {
        return 1;
    }

    public Seq<TierLogSegment> getTieredSegmentsWithGap(TopicPartition topicPartition, TierObjectStore objStore, long totalGapCount, long startOffset) {
        kafka.tier.TopicIdPartition tid = new kafka.tier.TopicIdPartition(topicPartition.topic(), UUID.randomUUID(), topicPartition.partition());
        TierLogSegment segment1 = LogTestUtils$.MODULE$.createTierLogSegment(tid, startOffset, startOffset + 999L, objStore, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L, TierObjectMetadata.State.INVALID, TierUploadType.Archive);
        long nextSegmentStartOffset = startOffset + 1000L + totalGapCount;
        TierLogSegment segment2 = LogTestUtils$.MODULE$.createTierLogSegment(tid, nextSegmentStartOffset, nextSegmentStartOffset + 999L, objStore, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L, TierObjectMetadata.State.INVALID, TierUploadType.Archive);
        return new .colon.colon((Object)segment1, (List)new .colon.colon((Object)segment2, (List)Nil$.MODULE$));
    }

    public long getTieredSegmentsWithGap$default$4() {
        return 0L;
    }

    public Seq<LogSegment> getLocalSegmentsWithoutGap(File logDir, long startOffset) {
        LogSegment segment1 = LogTestUtils$.MODULE$.createLocalLogSegment(startOffset, startOffset + 1L, logDir, 10, Time.SYSTEM, -1L);
        long nextSegmentStartOffset = startOffset + 2L;
        LogSegment segment2 = LogTestUtils$.MODULE$.createLocalLogSegment(nextSegmentStartOffset, nextSegmentStartOffset + 1L, logDir, 10, Time.SYSTEM, -1L);
        return new .colon.colon((Object)segment1, (List)new .colon.colon((Object)segment2, (List)Nil$.MODULE$));
    }

    public long getLocalSegmentsWithoutGap$default$2() {
        return 0L;
    }

    public Seq<TierLogSegment> getTieredSegmentsWithoutGap(TopicPartition topicPartition, TierObjectStore objStore, long startOffset) {
        kafka.tier.TopicIdPartition tid = new kafka.tier.TopicIdPartition(topicPartition.topic(), UUID.randomUUID(), topicPartition.partition());
        TierLogSegment segment1 = LogTestUtils$.MODULE$.createTierLogSegment(tid, startOffset, startOffset + 999L, objStore, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L, TierObjectMetadata.State.INVALID, TierUploadType.Archive);
        long nextSegmentStartOffset = startOffset + 1000L;
        TierLogSegment segment2 = LogTestUtils$.MODULE$.createTierLogSegment(tid, nextSegmentStartOffset, nextSegmentStartOffset + 999L, objStore, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, 1L, 1L, TierObjectMetadata.State.INVALID, TierUploadType.Archive);
        return new .colon.colon((Object)segment1, (List)new .colon.colon((Object)segment2, (List)Nil$.MODULE$));
    }

    public long getTieredSegmentsWithoutGap$default$3() {
        return 0L;
    }

    public SortedMap<ByteBuffer, OffsetInfo> getOffsetMap(int maxRecords, boolean putTombstones) {
        SortedMap offsetMap = (SortedMap)SortedMap$.MODULE$.apply((Seq)Nil$.MODULE$, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        Random random = new Random();
        int numProducedRecords = 0;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), maxRecords).toList().map((Function1 & Serializable)i -> DurabilityTestUtils$.$anonfun$getOffsetMap$1(random, maxRecords, numProducedRecords, BoxesRunTime.unboxToInt((Object)i))).foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                int v = x0$1._2$mcI$sp();
                if (putTombstones) {
                    return offsetMap.put((Object)DurabilityOffsetMapUtils$.MODULE$.getHashedBuffer(ByteBuffer.wrap(Integer.toString(k).getBytes(StandardCharsets.UTF_8))), (Object)new OffsetInfo((long)v, true));
                }
                return offsetMap.put((Object)DurabilityOffsetMapUtils$.MODULE$.getHashedBuffer(ByteBuffer.wrap(Integer.toString(k).getBytes(StandardCharsets.UTF_8))), (Object)new OffsetInfo((long)v, false));
            }
            throw new MatchError(null);
        });
        return offsetMap;
    }

    public boolean getOffsetMap$default$2() {
        return false;
    }

    public MetricName metricName(String name, Metrics metrics) {
        return (MetricName)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps(metrics.metrics().keySet().toArray()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DurabilityTestUtils$.$anonfun$metricName$1(name, x$1)))));
    }

    public MetricName metricNameWithTag(String name, String tag, Metrics metrics) {
        return (MetricName)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps(metrics.metrics().keySet().toArray()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DurabilityTestUtils$.$anonfun$metricNameWithTag$1(name, x$2)))), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DurabilityTestUtils$.$anonfun$metricNameWithTag$2(tag, x$3)))));
    }

    public ConsumerRecord<byte[], byte[]> createDurabilityEventConsumerRecord(AbstractDurabilityEvent obj, TopicIdPartition topicIdPartition) {
        return new ConsumerRecord(topicIdPartition.topicPartition().topic(), topicIdPartition.topicPartition().partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)obj.serializeKey(), (Object)obj.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
    }

    public static final /* synthetic */ boolean $anonfun$mockTierPartitionState$2(Long offset$1, TierLogSegment s) {
        return s.baseOffset() <= Predef$.MODULE$.Long2long(offset$1) && s.endOffset() >= Predef$.MODULE$.Long2long(offset$1);
    }

    public static final /* synthetic */ OngoingStubbing $anonfun$mockLog$1(MergedLog mockLog$1, long start) {
        return Mockito.when((Object)BoxesRunTime.boxToLong((long)mockLog$1.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)start));
    }

    public static final /* synthetic */ OngoingStubbing $anonfun$mockLog$2(MergedLog mockLog$1, long end) {
        return Mockito.when((Object)BoxesRunTime.boxToLong((long)mockLog$1.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)end));
    }

    public static final /* synthetic */ Tuple2 $anonfun$getOffsetMap$1(Random random$1, int maxRecords$1, int numProducedRecords$1, int i) {
        return new Tuple2.mcII.sp(random$1.nextInt(maxRecords$1 / 10), numProducedRecords$1 + i);
    }

    public static final /* synthetic */ boolean $anonfun$metricName$1(String name$1, Object x$1) {
        return ((MetricName)x$1).name().equals(name$1);
    }

    public static final /* synthetic */ boolean $anonfun$metricNameWithTag$1(String name$2, Object x$2) {
        return ((MetricName)x$2).name().equals(name$2);
    }

    public static final /* synthetic */ boolean $anonfun$metricNameWithTag$2(String tag$1, Object x$3) {
        return ((MetricName)x$3).tags().containsValue(tag$1);
    }

    private DurabilityTestUtils$() {
    }
}

