/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.db;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import kafka.durability.db.AuditRunState;
import kafka.durability.db.AuditRunState$;
import kafka.durability.db.DbHeader;
import kafka.durability.db.DbStatus$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.DurabilityDB$;
import kafka.durability.db.PartitionState;
import kafka.durability.db.kraft.KRaftPartitionState;
import kafka.durability.exceptions.DurabilityDBNotReadyException;
import kafka.durability.tools.DumpDB$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\rc\u0001B\u000e\u001d\u0001\rBQA\u000b\u0001\u0005\u0002-BqA\f\u0001C\u0002\u0013\u0005q\u0006\u0003\u0004<\u0001\u0001\u0006I\u0001\r\u0005\by\u0001\u0011\r\u0011\"\u0001>\u0011\u0019a\u0005\u0001)A\u0005}!9Q\n\u0001b\u0001\n\u0003q\u0005BB,\u0001A\u0003%q\nC\u0004Y\u0001\t\u0007I\u0011\u0001(\t\re\u0003\u0001\u0015!\u0003P\u0011\u001dQ\u0006A1A\u0005\u0002mCaa\u0018\u0001!\u0002\u0013a\u0006b\u00021\u0001\u0005\u0004%\t!\u0019\u0005\u0007K\u0002\u0001\u000b\u0011\u00022\t\u000b\u0019\u0004A\u0011A4\t\u000bY\u0004A\u0011A4\t\u000bm\u0004A\u0011A4\t\u000bu\u0004A\u0011A4\t\u000b}\u0004A\u0011A4\t\r\u0005\r\u0001\u0001\"\u0001h\u0011\u0019\t9\u0001\u0001C\u0001O\"1\u00111\u0002\u0001\u0005\u0002\u001dDa!a\u0004\u0001\t\u00039\u0007BBA\n\u0001\u0011\u0005q\r\u0003\u0004\u0002\u0018\u0001!\ta\u001a\u0005\u0007\u00037\u0001A\u0011A4\t\u000f\u0005}\u0001\u0001\"\u0003\u0002\"\t\u0001B)\u001e:bE&d\u0017\u000e^=E\u0005R+7\u000f\u001e\u0006\u0003;y\t!\u0001\u001a2\u000b\u0005}\u0001\u0013A\u00033ve\u0006\u0014\u0017\u000e\\5us*\t\u0011%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001!\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002YA\u0011Q\u0006A\u0007\u00029\u0005\u0011A\u000f]\u000b\u0002aA\u0011\u0011'O\u0007\u0002e)\u00111\u0007N\u0001\u0007G>lWn\u001c8\u000b\u0005\u0005*$B\u0001\u001c8\u0003\u0019\t\u0007/Y2iK*\t\u0001(A\u0002pe\u001eL!A\u000f\u001a\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0019A\u000f\u001d\u0011\u0002\u0015\u0015\u0004xn\u00195DQ\u0006Lg.F\u0001?!\u0011yDIR%\u000e\u0003\u0001S!!\u0011\"\u0002\u000f5,H/\u00192mK*\u00111IJ\u0001\u000bG>dG.Z2uS>t\u0017BA#A\u0005\u001dA\u0015m\u001d5NCB\u0004\"!J$\n\u0005!3#aA%oiB\u0011QES\u0005\u0003\u0017\u001a\u0012A\u0001T8oO\u0006YQ\r]8dQ\u000eC\u0017-\u001b8!\u0003\u0019!X\u000e\u001d#jeV\tq\n\u0005\u0002Q+6\t\u0011K\u0003\u0002S'\u0006\u0011\u0011n\u001c\u0006\u0002)\u0006!!.\u0019<b\u0013\t1\u0016K\u0001\u0003GS2,\u0017a\u0002;na\u0012K'\u000fI\u0001\u0007Y><G)\u001b:\u0002\u000f1|w\rR5sA\u0005\u0011\u0011m]\u000b\u00029B\u0011Q&X\u0005\u0003=r\u0011Q\"Q;eSR\u0014VO\\*uCR,\u0017aA1tA\u0005\u0011\u0001o]\u000b\u0002EB\u0011QfY\u0005\u0003Ir\u0011a\u0002U1si&$\u0018n\u001c8Ti\u0006$X-A\u0002qg\u0002\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002QB\u0011Q%[\u0005\u0003U\u001a\u0012A!\u00168ji\"\u0012a\u0002\u001c\t\u0003[Rl\u0011A\u001c\u0006\u0003_B\f1!\u00199j\u0015\t\t(/A\u0004kkBLG/\u001a:\u000b\u0005M<\u0014!\u00026v]&$\u0018BA;o\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u000bekJ\f'-\u001b7jif$%)\u00138jiR+7\u000f\u001e\u0015\u0003\u001fa\u0004\"!\\=\n\u0005it'\u0001\u0002+fgR\fA\u0006Z;sC\nLG.\u001b;z\t\n\u001bVM]5bY&T\u0018\r^5p]\u0012+7/\u001a:jC2L'0\u0019;j_:$Vm\u001d;)\u0005AA\u0018!\b3ve\u0006\u0014\u0017\u000e\\5us\u0012\u0013\u0015J\\5u\u0007\",7m\u001b)pS:$\u0018N\\4)\u0005EA\u0018a\u00063ve\u0006\u0014\u0017\u000e\\5us\u0012\u0013U)\u001c9us\u0012\u0013e)\u001b7fQ\t\u0011\u00020A\u0012ekJ\f'-\u001b7jif$%)T;mi&\u0004H.\u001a)beRLG/[8o+B$\u0017\r^3)\u0005MA\u0018!\u0007;fgR\f\u0005+S!dG\u0016\u001c8/\u00138J]&$8\u000b^1ukND#\u0001\u0006=\u0002SQ,7\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5us\u0012\u00135JU1giF+xN];n'R\fG/\u001a)sKN,'O^3eQ\t)\u00020A\beK2,G/\u001a)beRLG/[8oQ\t1\u00020\u0001\u0006ek6\u0004HI\u0019+fgRD#a\u0006=\u0002?\u0011,X\u000e\u001d#c\u000b6\u0004H/_&SC\u001a$\u0018+^8sk6\u001cF/\u0019;f)\u0016\u001cH\u000f\u000b\u0002\u0019q\u0006\u0011C-^7q\t\ntuN\\#naRL8JU1giF+xN];n'R\fG/\u001a+fgRD#!\u0007=\u0002\u0015\u0011,X\u000e](viB,H\u000f\u0006\u0005\u0002$\u0005e\u00121HA !\u0011\t)#a\r\u000f\t\u0005\u001d\u0012q\u0006\t\u0004\u0003S1SBAA\u0016\u0015\r\tiCI\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005Eb%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\t9D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003c1\u0003\"\u0002-\u001b\u0001\u0004y\u0005bBA\u001f5\u0001\u0007\u00111E\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0003\u0003R\u0002\u0019AA\u0012\u0003%\u0001\u0018M\u001d;ji&|g\u000e")
public class DurabilityDBTest {
    private final TopicPartition tp = new TopicPartition("test", 1);
    private final HashMap<Object, Object> epochChain = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)50L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)80L))}));
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final AuditRunState as = AuditRunState$.MODULE$.apply();
    private final PartitionState ps;

    public TopicPartition tp() {
        return this.tp;
    }

    public HashMap<Object, Object> epochChain() {
        return this.epochChain;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public AuditRunState as() {
        return this.as;
    }

    public PartitionState ps() {
        return this.ps;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tmpDir(), (boolean)false);
    }

    @Test
    public void durabilityDBInitTest() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        Assertions.assertEquals((Object)db.status(), (Object)DbStatus$.MODULE$.Online());
        Assertions.assertTrue((boolean)db.header().equals((Object)new DbHeader(2, 1, (long[])Array$.MODULE$.fill(50, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()))), (String)"Database failed to initialize");
        Assertions.assertEquals((int)db.topicStates().size(), (int)0, (String)"Database failed to initialize");
        Assertions.assertTrue((boolean)db.kraftQuorumState().isEmpty(), (String)"Database failed to initialize");
    }

    @Test
    public void durabilityDBSerializationDeserializationTest() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        db.addPartition(this.tp(), this.ps());
        db.close();
        DurabilityDB newDb = DurabilityDB$.MODULE$.apply(this.logDir());
        Assertions.assertTrue((boolean)newDb.header().equals((Object)db.header()), (String)"Check-pointing and recovery of db not consistent");
        Assertions.assertEquals((Object)newDb.fetchPartitionState(this.tp()).get(), (Object)this.ps(), (String)"PartitionState not preserved after recovery");
        Assertions.assertEquals((Object)db.kraftQuorumState(), (Object)newDb.kraftQuorumState(), (String)"KraftQuorumState not preserved after recovery");
    }

    @Test
    public void durabilityDBInitCheckPointing() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        Assertions.assertEquals((Object)db.status(), (Object)DbStatus$.MODULE$.Online());
        db.close();
        DurabilityDB newDb = DurabilityDB$.MODULE$.apply(this.logDir());
        Assertions.assertTrue((boolean)db.header().equals((Object)newDb.header()), (String)"Inconsistent db after check pointing in empty state");
        Assertions.assertEquals((Object)newDb.topicStates(), (Object)db.topicStates(), (String)"Inconsistent db after check pointing in empty state");
        Assertions.assertEquals((Object)db.kraftQuorumState(), (Object)newDb.kraftQuorumState(), (String)"Inconsistent db after check pointing in empty state");
    }

    @Test
    public void durabilityDBEmptyDBFile() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        db.dbFile().createNewFile();
        db = DurabilityDB$.MODULE$.apply(this.logDir());
        Assertions.assertTrue((boolean)db.header().equals((Object)new DbHeader(2, 1, (long[])Array$.MODULE$.fill(50, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()))), (String)"Database not in empty state");
        Assertions.assertEquals((int)db.topicStates().size(), (int)0, (String)"Database not in empty state");
        Assertions.assertTrue((boolean)db.kraftQuorumState().isEmpty(), (String)"Database not in empty state");
    }

    @Test
    public void durabilityDBMultiplePartitionUpdate() {
        ObjectRef db = ObjectRef.create((Object)DurabilityDB$.MODULE$.apply(this.logDir()));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4000).foreach((Function1 & Serializable)ii -> DurabilityDBTest.$anonfun$durabilityDBMultiplePartitionUpdate$1(this, db, BoxesRunTime.unboxToInt((Object)ii)));
        ((DurabilityDB)db.elem).close();
        db.elem = DurabilityDB$.MODULE$.apply(this.logDir());
        Seq committed = ((DurabilityDB)db.elem).getDurabilityTopicPartitionOffsets();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)ii -> {
            TopicPartition id = new TopicPartition(this.tp().topic(), ii);
            Assertions.assertEquals((long)((PartitionState)((DurabilityDB)db$1.elem).fetchPartitionState(id).get()).startOffset(), (long)ii, (String)new StringBuilder(45).append("Failed to get last valid state for partition ").append(ii).toString());
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)committed.apply(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT())), (long)(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT()), (String)new StringBuilder(54).append("Failed to fetch latest committed offset for partition ").append(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT()).toString());
        });
    }

    @Test
    public void testAPIAccessInInitStatus() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        db.status_$eq(DbStatus$.MODULE$.Init());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> db.addPartition(this.tp(), this.ps()), ClassTag$.MODULE$.apply(DurabilityDBNotReadyException.class), new Position("DurabilityDBTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDurabilityDBKRaftQuorumStatePreserved() {
        void apply_latestSnapshotId;
        void apply_hasFetchOffsetIncreasedInCurrentEpoch;
        void apply_lastKnownFetchOffset;
        void apply_localLogStartOffset;
        void apply_epochChain;
        void apply_localHighWatermark;
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.METADATA_TOPIC_ID, Topic.CLUSTER_METADATA_TOPIC_PARTITION);
        HashMap epochLeaderIds = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)2))}));
        Assertions.assertEquals((Object)db.status(), (Object)DbStatus$.MODULE$.Online());
        Some some = new Some((Object)new OffsetAndEpoch(0L, 0));
        boolean bl = true;
        long l = 10L;
        long l2 = 2L;
        HashMap<Object, Object> hashMap = this.epochChain();
        Some some2 = new Some((Object)BoxesRunTime.boxToLong((long)8L));
        Some apply_leaderHighWatermark = new Some((Object)BoxesRunTime.boxToLong((long)10L));
        Object var7_10 = null;
        some2 = null;
        hashMap = null;
        some = null;
        KRaftPartitionState kraftPartitionState = new KRaftPartitionState(topicIdPartition, (Option)apply_leaderHighWatermark, (Option)apply_localHighWatermark, (HashMap)apply_epochChain, epochLeaderIds, (long)apply_localLogStartOffset, (long)apply_lastKnownFetchOffset, (boolean)apply_hasFetchOffsetIncreasedInCurrentEpoch, (Option)apply_latestSnapshotId);
        int epoch = 2;
        db.addKRaftPartitionState(kraftPartitionState);
        Assertions.assertEquals((Object)kraftPartitionState, (Object)db.fetchKRaftPartitionState(topicIdPartition).get(), (String)"addKRaftPartitionState did not properly set DB KRaft partition state");
        db.setKRaftLocalEpoch(epoch);
        Assertions.assertEquals((int)epoch, (int)db.kraftQuorumState().epoch(), (String)"setKRaftNodeState did not properly set DB KRaft local epoch");
        db.addKRaftEpochLeader(0, 0);
        db.addKRaftEpochLeader(1, 1);
        db.addKRaftEpochLeader(2, 2);
        Assertions.assertEquals((Object)epochLeaderIds, (Object)db.kraftQuorumState().epochLeaderIds(), (String)"addKRaftEpochLeader did not properly add epoch and leader ID to DB KRaft Quorum State");
        db.close();
        DurabilityDB newDb = DurabilityDB$.MODULE$.apply(this.logDir());
        Assertions.assertEquals((Object)db.kraftQuorumState(), (Object)newDb.kraftQuorumState(), (String)"DB did not properly persist KRaftQuorumState");
        newDb.clearKRaftQuorumState();
        Assertions.assertTrue((boolean)newDb.kraftQuorumState().isEmpty(), (String)"clearKRaftQuorumState did not properly clear state");
        newDb.close();
        Assertions.assertTrue((boolean)DurabilityDB$.MODULE$.apply(this.logDir()).kraftQuorumState().isEmpty(), (String)"DB did not persist cleared KRaftQuorumState");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void deletePartition() {
        void apply_auditState;
        void apply_config;
        void apply_topicId;
        void apply_epochChain;
        void apply_retentionSz;
        void apply_retentionMs;
        void apply_totalMessages;
        void apply_externalLostMessages;
        void apply_committedOffset;
        void apply_highWatermark;
        void apply_startOffset;
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        db.addPartition(this.tp(), this.ps());
        TopicPartition id = new TopicPartition(this.tp().topic(), 2);
        AuditRunState auditRunState = this.as();
        long l = 0L;
        Uuid uuid = Uuid.randomUuid();
        HashMap<Object, Object> hashMap = this.epochChain();
        long l2 = 1024L;
        long l3 = 3600L;
        long l4 = 100L;
        long l5 = 2L;
        long l6 = 0L;
        long l7 = 100L;
        long l8 = 1L;
        int apply_partition = 2;
        hashMap = null;
        uuid = null;
        auditRunState = null;
        PartitionState ps2 = new PartitionState(apply_partition, (long)apply_startOffset, (long)apply_highWatermark, (long)apply_committedOffset, (long)apply_externalLostMessages, (long)apply_totalMessages, (long)apply_retentionMs, (long)apply_retentionSz, (HashMap)apply_epochChain, (Uuid)apply_topicId, (long)apply_config, (AuditRunState)apply_auditState);
        db.addPartition(id, ps2);
        Assertions.assertTrue((boolean)((PartitionState)db.fetchPartitionState(this.tp()).get()).equals((Object)this.ps()), (String)"Fetch for partition failed");
        db.deletePartition(this.tp());
        Assertions.assertEquals((Object)db.fetchPartitionState(this.tp()), (Object)None$.MODULE$, (String)"Fetch found deleted partition state");
        db.close();
        Assertions.assertEquals((Object)DurabilityDB$.MODULE$.apply(this.logDir()).fetchPartitionState(this.tp()), (Object)None$.MODULE$, (String)"Fetch found deleted partition state");
    }

    @Test
    public void dumpDbTest() {
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        db.addPartition(this.tp(), this.ps());
        db.close();
        Assertions.assertTrue((boolean)this.dumpOutput(this.logDir(), this.tp().topic(), Integer.toString(this.tp().partition())).startsWith(new StringBuilder(7).append("Topic: ").append(this.tp().topic()).toString()));
        Assertions.assertTrue((boolean)this.dumpOutput(this.logDir(), this.tp().topic(), "123").contains("DB doesn't contain partition"));
        Assertions.assertTrue((boolean)this.dumpOutput(this.logDir(), "invalid-topic", "123").contains("DB doesn't contain Topic"));
    }

    @Test
    public void dumpDbEmptyKRaftQuorumStateTest() {
        DurabilityDB$.MODULE$.apply(this.logDir()).close();
        Assertions.assertTrue((boolean)this.dumpOutput(this.logDir(), "__cluster_metadata", "").contains("DB doesn't contain Topic"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void dumpDbNonEmptyKRaftQuorumStateTest() {
        void apply_latestSnapshotId;
        void apply_hasFetchOffsetIncreasedInCurrentEpoch;
        void apply_lastKnownFetchOffset;
        void apply_localLogStartOffset;
        void apply_epochLeaderIds;
        void apply_epochChain;
        void apply_localHighWatermark;
        DurabilityDB db = DurabilityDB$.MODULE$.apply(this.logDir());
        db.setKRaftLocalNodeId(0);
        TopicIdPartition metadataTpid = new TopicIdPartition(Uuid.METADATA_TOPIC_ID, Topic.CLUSTER_METADATA_TOPIC_PARTITION);
        None$ none$ = None$.MODULE$;
        boolean bl = false;
        long l = -1L;
        long l2 = 0L;
        HashMap hashMap = db.kraftQuorumState().epochLeaderIds();
        HashMap hashMap2 = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        None$ none$2 = None$.MODULE$;
        None$ apply_leaderHighWatermark = None$.MODULE$;
        Object var4_10 = null;
        none$2 = null;
        hashMap2 = null;
        hashMap = null;
        none$ = null;
        KRaftPartitionState newKraftPartitionState = new KRaftPartitionState(metadataTpid, (Option)apply_leaderHighWatermark, (Option)apply_localHighWatermark, (HashMap)apply_epochChain, (HashMap)apply_epochLeaderIds, (long)apply_localLogStartOffset, (long)apply_lastKnownFetchOffset, (boolean)apply_hasFetchOffsetIncreasedInCurrentEpoch, (Option)apply_latestSnapshotId);
        db.addKRaftPartitionState(newKraftPartitionState);
        db.close();
        Assertions.assertTrue((boolean)this.dumpOutput(this.logDir(), metadataTpid.topic(), String.valueOf(BoxesRunTime.boxToInteger((int)metadataTpid.partition()))).startsWith("KRaft Quorum State:"));
        Assertions.assertTrue((boolean)this.dumpOutput(this.logDir(), metadataTpid.topic(), "").startsWith("KRaft Quorum State:"));
        Assertions.assertTrue((boolean)this.dumpOutput(this.logDir(), metadataTpid.topic(), null).startsWith("KRaft Quorum State:"));
    }

    private String dumpOutput(File logDir, String topic, String partition) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpDB$.MODULE$.dump(logDir, topic, partition));
        return out.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Option $anonfun$durabilityDBMultiplePartitionUpdate$1(DurabilityDBTest $this, ObjectRef db$1, int ii) {
        void apply_auditState;
        void apply_config;
        void apply_topicId;
        void apply_epochChain;
        void apply_retentionSz;
        void apply_retentionMs;
        void apply_totalMessages;
        void apply_externalLostMessages;
        void apply_committedOffset;
        void apply_highWatermark;
        void apply_startOffset;
        TopicPartition id = new TopicPartition($this.tp().topic(), ii);
        AuditRunState auditRunState = $this.as();
        long l = 0L;
        Uuid uuid = Uuid.randomUuid();
        HashMap<Object, Object> hashMap = $this.epochChain();
        long l2 = 1024L;
        long l3 = 3600L;
        long l4 = 100L;
        long l5 = 2L;
        long l6 = 0L;
        long l7 = 100L;
        long l8 = ii;
        int apply_partition = id.partition();
        hashMap = null;
        uuid = null;
        auditRunState = null;
        PartitionState ps = new PartitionState(apply_partition, (long)apply_startOffset, (long)apply_highWatermark, (long)apply_committedOffset, (long)apply_externalLostMessages, (long)apply_totalMessages, (long)apply_retentionMs, (long)apply_retentionSz, (HashMap)apply_epochChain, (Uuid)apply_topicId, (long)apply_config, (AuditRunState)apply_auditState);
        ((DurabilityDB)db$1.elem).updateDurabilityTopicPartitionOffset(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT(), (long)(ii % ((DurabilityDB)db$1.elem).DURABILITY_EVENTS_TOPIC_PARTITION_COUNT()));
        return ((DurabilityDB)db$1.elem).addPartition(id, ps);
    }

    /*
     * WARNING - void declaration
     */
    public DurabilityDBTest() {
        void apply_auditState;
        void apply_config;
        void apply_topicId;
        void apply_epochChain;
        void apply_retentionSz;
        void apply_retentionMs;
        void apply_totalMessages;
        void apply_externalLostMessages;
        void apply_committedOffset;
        void apply_highWatermark;
        AuditRunState auditRunState = this.as();
        long l = 0L;
        Uuid uuid = Uuid.randomUuid();
        HashMap<Object, Object> hashMap = this.epochChain();
        long l2 = 1024L;
        long l3 = 3600L;
        long l4 = 100L;
        long l5 = 2L;
        long l6 = 0L;
        long l7 = 100L;
        long apply_startOffset = 1L;
        int apply_partition = this.tp().partition();
        this.ps = new PartitionState(apply_partition, apply_startOffset, (long)apply_highWatermark, (long)apply_committedOffset, (long)apply_externalLostMessages, (long)apply_totalMessages, (long)apply_retentionMs, (long)apply_retentionSz, (HashMap)apply_epochChain, (Uuid)apply_topicId, (long)apply_config, (AuditRunState)apply_auditState);
    }
}

