/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import kafka.cluster.Partition;
import kafka.controller.ReplicaAssignment$;
import kafka.integration.UncleanLeaderElectionTest$;
import kafka.network.Processor;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\t\u0005u!B\u001d;\u0011\u0003yd!B!;\u0011\u0003\u0011\u0005\"B%\u0002\t\u0003Q\u0005\"B&\u0002\t\u0003ae\u0001B!;\u0001\u0015DQ!\u0013\u0003\u0005\u00021DqA\u001c\u0003C\u0002\u0013\u0005q\u000e\u0003\u0004t\t\u0001\u0006I\u0001\u001d\u0005\bi\u0012\u0011\r\u0011\"\u0001p\u0011\u0019)H\u0001)A\u0005a\"9a\u000f\u0002b\u0001\n\u0003y\u0007BB<\u0005A\u0003%\u0001\u000fC\u0004y\t\t\u0007I\u0011A=\t\ru$\u0001\u0015!\u0003{\u0011%qH\u00011AA\u0002\u0013\u0005q\u0010C\u0006\u0002\n\u0011\u0001\r\u00111A\u0005\u0002\u0005-\u0001bCA\f\t\u0001\u0007\t\u0011)Q\u0005\u0003\u0003A!\"!\u0007\u0005\u0001\u0004\u0005\r\u0011\"\u0001\u0000\u0011-\tY\u0002\u0002a\u0001\u0002\u0004%\t!!\b\t\u0017\u0005\u0005B\u00011A\u0001B\u0003&\u0011\u0011\u0001\u0005\u000b\u0003G!\u0001\u0019!a\u0001\n\u0003y\bbCA\u0013\t\u0001\u0007\t\u0019!C\u0001\u0003OA1\"a\u000b\u0005\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0002!I\u0011Q\u0006\u0003A\u0002\u0013\u0005\u0011q\u0006\u0005\n\u0003\u0007\"\u0001\u0019!C\u0001\u0003\u000bB\u0001\"!\u0013\u0005A\u0003&\u0011\u0011\u0007\u0005\n\u0003\u0017\"\u0001\u0019!C\u0001\u0003\u001bB\u0011\"a\u0016\u0005\u0001\u0004%\t!!\u0017\t\u0011\u0005uC\u0001)Q\u0005\u0003\u001fB\u0011\"a\u0018\u0005\u0005\u0004%\t!!\u0019\t\u0011\u00055D\u0001)A\u0005\u0003GB\u0011\"a\u001c\u0005\u0005\u0004%\t!!\u001d\t\u0011\u0005}D\u0001)A\u0005\u0003gB\u0001\"!!\u0005\u0005\u0004%\ta\u001c\u0005\b\u0003\u0007#\u0001\u0015!\u0003q\u0011%\t)\t\u0002b\u0001\n\u0003\t9\t\u0003\u0005\u0002\u001c\u0012\u0001\u000b\u0011BAE\u0011%\ti\n\u0002b\u0001\n\u0003\ty\n\u0003\u0005\u0002.\u0012\u0001\u000b\u0011BAQ\u0011%\ty\u000b\u0002b\u0001\n\u0003\ty\n\u0003\u0005\u00022\u0012\u0001\u000b\u0011BAQ\u0011\u001d\t\u0019\f\u0002C!\u0003kCq!a4\u0005\t\u0003\n\t\u000eC\u0004\u0002\\\u0012!I!!8\t\u000f\u0005\u0015H\u0001\"\u0001\u0002h\"9!\u0011\u0003\u0003\u0005\u0002\u0005E\u0007b\u0002B\u000e\t\u0011\u0005\u0011\u0011\u001b\u0005\b\u0005?!A\u0011AAi\u0011\u001d\u0011\u0019\u0003\u0002C\u0001\u0003#DqAa\n\u0005\t\u0003\t\t\u000eC\u0004\u0003,\u0011!\t!!5\t\u000f\t5B\u0001\"\u0001\u0002R\"9!q\u0006\u0003\u0005\n\tE\u0002b\u0002B\u001b\t\u0011%!q\u0007\u0005\b\u0005+\"A\u0011AAi\u0011\u001d\u0011I\u0006\u0002C\u0005\u00057BqA! \u0005\t\u0013\u0011y(A\rV]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8UKN$(BA\u001e=\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\u000b\u0003u\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002A\u00035\t!HA\rV]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8UKN$8CA\u0001D!\t!u)D\u0001F\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%F\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aP\u0001\u0016[\u0016$\u0018\rZ1uCZ+'o]5p]N{WO]2f+\u0005i\u0005c\u0001(V/6\tqJ\u0003\u0002Q#\u000611\u000f\u001e:fC6T!AU*\u0002\tU$\u0018\u000e\u001c\u0006\u0002)\u0006!!.\u0019<b\u0013\t1vJ\u0001\u0004TiJ,\u0017-\u001c\t\u00031\u000el\u0011!\u0017\u0006\u00035n\u000b\u0001\u0002\u001d:pm&$WM\u001d\u0006\u00039v\u000ba\u0001]1sC6\u001c(B\u00010`\u0003\u001dQW\u000f]5uKJT!\u0001Y1\u0002\u000b),h.\u001b;\u000b\u0003\t\f1a\u001c:h\u0013\t!\u0017LA\u0005Be\u001e,X.\u001a8ugN\u0011AA\u001a\t\u0003O*l\u0011\u0001\u001b\u0006\u0003Sr\naa]3sm\u0016\u0014\u0018BA6i\u0005E\tVo\u001c:v[R+7\u000f\u001e%be:,7o\u001d\u000b\u0002[B\u0011\u0001\tB\u0001\nEJ|7.\u001a:JIF*\u0012\u0001\u001d\t\u0003\tFL!A]#\u0003\u0007%sG/\u0001\u0006ce>\\WM]%ec\u0001\n\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u001a\u0002\u0015\t\u0014xn[3s\u0013\u0012\u0014\u0004%A\u0005ce>\\WM]%eg\u0005Q!M]8lKJLEm\r\u0011\u00021\u0015t\u0017M\u00197f\u0007>tGO]8mY\u0016$7\u000b[;uI><h.F\u0001{!\t!50\u0003\u0002}\u000b\n9!i\\8mK\u0006t\u0017!G3oC\ndWmQ8oiJ|G\u000e\\3e'\",H\u000fZ8x]\u0002\nAbY8oM&<\u0007K]8qgF*\"!!\u0001\u0011\t\u0005\r\u0011QA\u0007\u0002#&\u0019\u0011qA)\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\td_:4\u0017n\u001a)s_B\u001c\u0018g\u0018\u0013fcR!\u0011QBA\n!\r!\u0015qB\u0005\u0004\u0003#)%\u0001B+oSRD\u0011\"!\u0006\u0010\u0003\u0003\u0005\r!!\u0001\u0002\u0007a$\u0013'A\u0007d_:4\u0017n\u001a)s_B\u001c\u0018\u0007I\u0001\rG>tg-[4Qe>\u00048OM\u0001\u0011G>tg-[4Qe>\u00048OM0%KF$B!!\u0004\u0002 !I\u0011Q\u0003\n\u0002\u0002\u0003\u0007\u0011\u0011A\u0001\u000eG>tg-[4Qe>\u00048O\r\u0011\u0002\u0019\r|gNZ5h!J|\u0007o]\u001a\u0002!\r|gNZ5h!J|\u0007o]\u001a`I\u0015\fH\u0003BA\u0007\u0003SA\u0011\"!\u0006\u0016\u0003\u0003\u0005\r!!\u0001\u0002\u001b\r|gNZ5h!J|\u0007o]\u001a!\u0003\u001d\u0019wN\u001c4jON,\"!!\r\u0011\r\u0005M\u0012\u0011HA\u001f\u001b\t\t)DC\u0002\u00028\u0015\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY$!\u000e\u0003\u0007M+\u0017\u000fE\u0002h\u0003\u007fI1!!\u0011i\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0017\r|gNZ5hg~#S-\u001d\u000b\u0005\u0003\u001b\t9\u0005C\u0005\u0002\u0016a\t\t\u00111\u0001\u00022\u0005A1m\u001c8gS\u001e\u001c\b%A\u0004tKJ4XM]:\u0016\u0005\u0005=\u0003CBA\u001a\u0003s\t\t\u0006E\u0002h\u0003'J1!!\u0016i\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0005\u0003\u001b\tY\u0006C\u0005\u0002\u0016m\t\t\u00111\u0001\u0002P\u0005A1/\u001a:wKJ\u001c\b%\u0001\u0004sC:$w.\\\u000b\u0003\u0003G\u0002B!!\u001a\u0002j5\u0011\u0011q\r\u0006\u0003%\u0016KA!a\u001b\u0002h\t1!+\u00198e_6\fqA]1oI>l\u0007%A\u0003u_BL7-\u0006\u0002\u0002tA!\u0011QOA>\u001b\t\t9HC\u0002\u0002zM\u000bA\u0001\\1oO&!\u0011QPA<\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\n1\u0002]1si&$\u0018n\u001c8JI\u0006a\u0001/\u0019:uSRLwN\\%eA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tWCAAE!\u0011\tY)a&\u000e\u0005\u00055%\u0002BAH\u0003#\u000baaY8n[>t'bA\u001f\u0002\u0014*\u0019\u0011QS1\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\tI*!$\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007%A\blC\u001a\\\u0017-\u00119jg2{wmZ3s+\t\t\t\u000b\u0005\u0003\u0002$\u0006%VBAAS\u0015\u0011\t9+a%\u0002\u000b1|w\r\u000e6\n\t\u0005-\u0016Q\u0015\u0002\u0007\u0019><w-\u001a:\u0002!-\fgm[1Ba&\u001cHj\\4hKJ\u0004\u0013A\u00068fi^|'o\u001b)s_\u000e,7o]8s\u0019><w-\u001a:\u0002/9,Go^8sWB\u0013xnY3tg>\u0014Hj\\4hKJ\u0004\u0013!B:fiV\u0003H\u0003BA\u0007\u0003oCq!!/*\u0001\u0004\tY,\u0001\u0005uKN$\u0018J\u001c4p!\u0011\ti,a1\u000e\u0005\u0005}&bAAa;\u0006\u0019\u0011\r]5\n\t\u0005\u0015\u0017q\u0018\u0002\t)\u0016\u001cH/\u00138g_\"\u001a\u0011&!3\u0011\t\u0005u\u00161Z\u0005\u0005\u0003\u001b\fyL\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0003\u0003\u001bA3AKAk!\u0011\ti,a6\n\t\u0005e\u0017q\u0018\u0002\n\u0003\u001a$XM]#bG\"\fAb\u001d;beR\u0014%o\\6feN$B!!\u0004\u0002`\"9\u0011\u0011]\u0016A\u0002\u0005\r\u0018aB2mkN$XM\u001d\t\u0007\u0003g\tI$!\u0001\u0002[Q,7\u000f^+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\u001c*fG>4XM]=G_J4u\u000e\u001c7po\u0016\u00148\u000f\u0006\u0003\u0002\u000e\u0005%\bbBAvY\u0001\u0007\u0011Q^\u0001\u0010[\u0016$\u0018\rZ1uCZ+'o]5p]B!\u0011q^A{\u001b\t\t\tP\u0003\u0003\u0002\u0010\u0006M(bA5\u0002\u0012&!\u0011q_Ay\u0005=iU\r^1eCR\fg+\u001a:tS>t\u0007f\u0002\u0017\u0002|\n\u0005!1\u0001\t\u00041\u0006u\u0018bAA\u00003\naQ*\u001a;i_\u0012\u001cv.\u001e:dK\u0006)a/\u00197vK2\u0012!QA\u0011\u0002\u0017\"\u001aAF!\u0003\u0011\t\t-!QB\u0007\u00027&\u0019!qB.\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0011uKN$XK\\2mK\u0006tG*Z1eKJ,E.Z2uS>tWI\\1cY\u0016$\u0007fA\u0017\u0003\u0016A!\u0011Q\u0018B\f\u0013\u0011\u0011I\"a0\u0003\tQ+7\u000f^\u0001\"i\u0016\u001cH/\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eR5tC\ndW\r\u001a\u0015\u0004]\tU\u0011a\f;fgR,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:,e.\u00192mK\u0012\u0014\u0015\u0010V8qS\u000e|e/\u001a:sS\u0012,\u0007fA\u0018\u0003\u0016\u0005\u0001D/Z:u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\t&\u001c\u0018M\u00197fI\nKHk\u001c9jG>3XM\u001d:jI\u0016D3\u0001\rB\u000b\u00035\"Xm\u001d;V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8J]Z\fG.\u001b3U_BL7m\u0014<feJLG-\u001a\u0015\u0004c\tU\u0011A\t<fe&4\u00170\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g.\u00128bE2,G-A\u0012wKJLg-_+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\u001c#jg\u0006\u0014G.\u001a3\u0002\u001dMDW\u000f\u001e3po:\u001cVM\u001d<feR!\u0011Q\u0002B\u001a\u0011\u0019IG\u00071\u0001\u0002R\u0005\u00112m\u001c8tk6,\u0017\t\u001c7NKN\u001c\u0018mZ3t)\u0019\u0011IDa\u0014\u0003RA1\u00111GA\u001d\u0005w\u0001BA!\u0010\u0003L9!!q\bB$!\r\u0011\t%R\u0007\u0003\u0005\u0007R1A!\u0012?\u0003\u0019a$o\\8u}%\u0019!\u0011J#\u0002\rA\u0013X\rZ3g\u0013\u0011\tiH!\u0014\u000b\u0007\t%S\tC\u0004\u0002pU\u0002\rAa\u000f\t\r\tMS\u00071\u0001q\u0003-qW/\\'fgN\fw-Z:\u0002IQ,7\u000f\u001e+pa&\u001cWK\\2mK\u0006tG*Z1eKJ,E.Z2uS>tWI\\1cY\u0016D3A\u000eB\u000b\u0003E\tG\u000e^3s)>\u0004\u0018nY\"p]\u001aLwm\u001d\u000b\t\u0005;\u0012iGa\u001e\u0003zA!!q\fB5\u001b\t\u0011\tG\u0003\u0003\u0003d\t\u0015\u0014!B1e[&t'\u0002\u0002B4\u0003#\u000bqa\u00197jK:$8/\u0003\u0003\u0003l\t\u0005$AE!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z:vYRDqAa\u001c8\u0001\u0004\u0011\t(A\u0006bI6Lgn\u00117jK:$\b\u0003\u0002B0\u0005gJAA!\u001e\u0003b\t)\u0011\tZ7j]\"9\u0011qN\u001cA\u0002\tm\u0002b\u0002B>o\u0001\u0007\u0011\u0011A\u0001\ri>\u0004\u0018nY\"p]\u001aLwm]\u0001\u0012GJ,\u0017\r^3BI6Lgn\u00117jK:$HC\u0001B9\u0001")
public class UncleanLeaderElectionTest
extends QuorumTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private final int brokerId3;
    private final boolean enableControlledShutdown;
    private Properties configProps1;
    private Properties configProps2;
    private Properties configProps3;
    private Seq<KafkaConfig> configs = (Seq)Seq$.MODULE$.empty();
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final Random random = new Random();
    private final String topic = new StringBuilder(5).append("topic").append(this.random().nextLong()).toString();
    private final int partitionId;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), this.partitionId());
    private final Logger kafkaApisLogger = Logger.getLogger(KafkaApis.class);
    private final Logger networkProcessorLogger = Logger.getLogger(Processor.class);

    public static Stream<Arguments> metadataVersionSource() {
        return UncleanLeaderElectionTest$.MODULE$.metadataVersionSource();
    }

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public int brokerId3() {
        return this.brokerId3;
    }

    public boolean enableControlledShutdown() {
        return this.enableControlledShutdown;
    }

    public Properties configProps1() {
        return this.configProps1;
    }

    public void configProps1_$eq(Properties x$1) {
        this.configProps1 = x$1;
    }

    public Properties configProps2() {
        return this.configProps2;
    }

    public void configProps2_$eq(Properties x$1) {
        this.configProps2 = x$1;
    }

    public Properties configProps3() {
        return this.configProps3;
    }

    public void configProps3_$eq(Properties x$1) {
        this.configProps3 = x$1;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public Random random() {
        return this.random;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Logger kafkaApisLogger() {
        return this.kafkaApisLogger;
    }

    public Logger networkProcessorLogger() {
        return this.networkProcessorLogger;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.configProps1_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        this.configProps2_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        this.configProps3_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId3(), this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)new .colon.colon((Object)this.configProps3(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)configProps -> {
            configProps.put("controlled.shutdown.enable", Boolean.toString(this.enableControlledShutdown()));
            configProps.put("controlled.shutdown.max.retries", "1");
            return configProps.put("controlled.shutdown.retry.backoff.ms", "1000");
        });
        this.kafkaApisLogger().setLevel(Level.FATAL);
        this.networkProcessorLogger().setLevel(Level.FATAL);
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.servers().foreach((Function1 & Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)server -> {
            CoreUtils$.MODULE$.delete(server.config().logDirs());
            return BoxedUnit.UNIT;
        });
        this.kafkaApisLogger().setLevel(Level.ERROR);
        this.networkProcessorLogger().setLevel(Level.ERROR);
        super.tearDown();
    }

    private void startBrokers(Seq<Properties> cluster) {
        cluster.foreach((Function1 & Serializable)props -> {
            UncleanLeaderElectionTest.$anonfun$startBrokers$1(this, props);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @MethodSource(value={"metadataVersionSource"})
    public void testUncleanLeaderElectionRecoveryForFollowers(MetadataVersion metadataVersion) {
        new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)new .colon.colon((Object)this.configProps3(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)configProps -> {
            configProps.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), metadataVersion.version());
            configProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
            configProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
            configProps.put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), "1000");
            configProps.put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), "1000");
            configProps.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), "1");
            configProps.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "*");
            configProps.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), "1");
            return configProps.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "*");
        });
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)new .colon.colon((Object)this.configProps3(), (List)Nil$.MODULE$))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2(), this.brokerId3()})))}))), this.servers());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$2(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$3(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((IterableOnceOps)this.servers().tail()).foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$5(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"ISR should be down to 1");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        String brokerList = TestUtils$.MODULE$.bootstrapServers(this.servers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(brokerList, -1, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false);){
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 10000).foreach((Function1 & Serializable)x$5 -> UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$7(this, producer, BoxesRunTime.unboxToInt((Object)x$5)));
        }
        ((IterableOnceOps)this.servers().tail()).foreach((Function1 & Serializable)x$6 -> {
            x$6.startup();
            return BoxedUnit.UNIT;
        });
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$9(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"All brokers should be running.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$11(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"ISR should be down to 1");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        ((KafkaServer)this.servers().head()).shutdown();
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs5 = 15000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$13(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"Leader should either be 1 or 2 now");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        long l6 = 100L;
        long waitUntilTrue_waitTimeMs6 = 15000L;
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$15(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)"Leader and follower should have their `isUncleanLeader` flag cleared.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs6), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testUncleanLeaderElectionEnabled() {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers());
        this.verifyUncleanLeaderElectionEnabled();
    }

    @Test
    public void testUncleanLeaderElectionDisabled() {
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers());
        this.verifyUncleanLeaderElectionDisabled();
    }

    @Test
    public void testUncleanLeaderElectionEnabledByTopicOverride() {
        this.configProps1().put("unclean.leader.election.enable", "false");
        this.configProps2().put("unclean.leader.election.enable", "false");
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "true");
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers(), topicProps);
        this.verifyUncleanLeaderElectionEnabled();
    }

    @Test
    public void testUncleanLeaderElectionDisabledByTopicOverride() {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "false");
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers(), topicProps);
        this.verifyUncleanLeaderElectionDisabled();
    }

    @Test
    public void testUncleanLeaderElectionInvalidTopicOverride() {
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)Nil$.MODULE$));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "invalid");
        Assertions.assertThrows(ConfigException.class, () -> TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1()})))}))), this.servers(), topicProps));
    }

    public void verifyUncleanLeaderElectionEnabled() {
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(11).append("Leader for ").append(this.topic()).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is elected to be: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)}))).toString());
        Assertions.assertTrue((leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0, (String)new StringBuilder(46).append("Leader id is set to expected value for topic: ").append(this.topic()).toString());
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(13).append("Follower for ").append(this.topic()).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)}))).toString());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", null, 30000, 20000);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic(), this.partitionId(), 15000L);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((IterableOps)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$3(followerId, server)))).map((Function1 & Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        this.servers().map((Function1 & Serializable)x$7 -> {
            UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$5(x$7);
            return BoxedUnit.UNIT;
        });
        ((IterableOps)this.servers().filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$6(leaderId, x$8)))).map((Function1 & Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$8(followerId, x$9))).get();
        followerServer.startup();
        KafkaZkClient x$1 = this.zkClient();
        String x$2 = this.topic();
        int x$3 = this.partitionId();
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long x$5 = 30000L;
        None$ x$6 = None$.MODULE$;
        boolean x$72 = false;
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$1, x$2, x$3, x$5, (Option<Object>)x$6, (Option<Object>)x$4, x$72);
        Assertions.assertEquals((long)1L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
    }

    /*
     * WARNING - void declaration
     */
    public void verifyUncleanLeaderElectionDisabled() {
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(11).append("Leader for ").append(this.topic()).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is elected to be: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)}))).toString());
        Assertions.assertTrue((leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0, (String)new StringBuilder(46).append("Leader id is set to expected value for topic: ").append(this.topic()).toString());
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(13).append("Follower for ").append(this.topic()).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)}))).toString());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", null, 30000, 20000);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic(), this.partitionId(), 15000L);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((IterableOnceOps)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$3(followerId, server)))).foreach((Function1 & Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        this.servers().foreach((Function1 & Serializable)server -> {
            UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$5(server);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$6(leaderId, server)))).foreach((Function1 & Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$8(followerId, x$10))).get();
        followerServer.startup();
        KafkaZkClient x$1 = this.zkClient();
        String x$2 = this.topic();
        int x$3 = this.partitionId();
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)-1));
        long x$5 = 30000L;
        None$ x$6 = None$.MODULE$;
        boolean x$7 = false;
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$1, x$2, x$3, x$5, (Option<Object>)x$6, (Option<Object>)x$4, x$7);
        Assertions.assertEquals((long)0L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Seq<KafkaServer> x$8 = this.servers();
            String x$9 = this.topic();
            TestUtils$.MODULE$.produceMessage(x$8, x$9, "third", null, 1000, 1000);
        });
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), this.consumeAllMessages(this.topic(), 0));
        ((IterableOnceOps)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$10(leaderId, server)))).foreach((Function1 & Serializable)server -> {
            server.startup();
            return BoxedUnit.UNIT;
        });
        KafkaZkClient x$14 = this.zkClient();
        String x$15 = this.topic();
        int x$16 = this.partitionId();
        Some x$17 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
        long x$18 = 30000L;
        None$ x$19 = None$.MODULE$;
        boolean x$20 = false;
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$14, x$15, x$16, x$18, (Option<Object>)x$19, (Option<Object>)x$17, x$20);
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", null, 30000, 20000);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$12(this, followerServer, followerId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Inconsistent metadata after first server startup");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((IterableOnceOps)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$14(leaderId, server)))).foreach((Function1 & Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        KafkaZkClient x$21 = this.zkClient();
        String x$22 = this.topic();
        int x$23 = this.partitionId();
        Some x$24 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long x$25 = 30000L;
        None$ x$26 = None$.MODULE$;
        boolean x$27 = false;
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$21, x$22, x$23, x$25, (Option<Object>)x$26, (Option<Object>)x$24, x$27);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$))), this.consumeAllMessages(this.topic(), 3));
    }

    private void shutdownServer(KafkaServer server) {
        server.shutdown();
        server.awaitShutdown();
    }

    private Seq<String> consumeAllMessages(String topic, int numMessages) {
        Seq seq;
        String brokerList = TestUtils$.MODULE$.plaintextBootstrapServers(this.servers());
        String x$2 = new StringBuilder(5).append("group").append(this.random().nextLong()).toString();
        StringDeserializer x$4 = new StringDeserializer();
        None$ x$5 = None$.MODULE$;
        String x$6 = "earliest";
        boolean x$7 = false;
        int x$8 = 500;
        SecurityProtocol x$9 = SecurityProtocol.PLAINTEXT;
        None$ x$10 = None$.MODULE$;
        None$ x$112 = None$.MODULE$;
        ByteArrayDeserializer x$12 = new ByteArrayDeserializer();
        try (KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(brokerList, x$2, (Option<String>)x$5, x$6, false, x$7, x$8, x$9, (Option<File>)x$10, (Option<Properties>)x$112, x$12, x$4, (String)null);){
            TopicPartition tp = new TopicPartition(topic, this.partitionId());
            consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).asJava());
            consumer.seek(tp, 0L);
            seq = (Seq)TestUtils$.MODULE$.consumeRecords(consumer, numMessages, 15000L).map((Function1 & Serializable)x$11 -> (String)x$11.value());
        }
        return seq;
    }

    @Test
    public void testTopicUncleanLeaderElectionEnable() {
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.topic();
        Properties x$2 = new Properties();
        Map x$3 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})), (Seq)Seq$.MODULE$.empty()))}));
        boolean x$4 = qual$1.createTopicWithAssignment$default$4();
        boolean x$5 = qual$1.createTopicWithAssignment$default$5();
        boolean x$6 = qual$1.createTopicWithAssignment$default$6();
        Option x$7 = qual$1.createTopicWithAssignment$default$7();
        qual$1.createTopicWithAssignment(x$1, x$2, x$3, x$4, x$5, x$6, x$7);
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false);
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", null, 30000, 20000);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic(), this.partitionId(), 15000L);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((IterableOps)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$1(followerId, server)))).map((Function1 & Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        this.servers().map((Function1 & Serializable)server -> {
            UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$3(server);
            return BoxedUnit.UNIT;
        });
        ((IterableOps)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$4(leaderId, server)))).map((Function1 & Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$6(followerId, x$12))).get();
        followerServer.startup();
        Assertions.assertEquals((long)0L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Seq<KafkaServer> x$8 = this.servers();
            String x$9 = this.topic();
            TestUtils$.MODULE$.produceMessage(x$8, x$9, "third", null, 1000, 1000);
        });
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), this.consumeAllMessages(this.topic(), 0));
        Admin adminClient = this.createAdminClient();
        Properties newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        this.alterTopicConfigs(adminClient, this.topic(), newProps).all().get();
        adminClient.close();
        KafkaZkClient x$14 = this.zkClient();
        String x$15 = this.topic();
        int x$16 = this.partitionId();
        Some x$17 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long x$18 = 30000L;
        None$ x$19 = None$.MODULE$;
        boolean x$20 = false;
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$14, x$15, x$16, x$18, (Option<Object>)x$19, (Option<Object>)x$17, x$20);
        Assertions.assertEquals((long)1L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
    }

    private AlterConfigsResult alterTopicConfigs(Admin adminClient, String topic, Properties topicConfigs) {
        java.util.List configEntries = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.PropertiesHasAsScala(topicConfigs).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return new ConfigEntry(k, v);
            }
            throw new MatchError(null);
        })).toList()).asJava();
        Config newConfig = new Config((Collection)configEntries);
        java.util.Map configs = CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, topic)), (Object)newConfig)}))).asJava();
        return adminClient.alterConfigs(configs);
    }

    private Admin createAdminClient() {
        Properties config = new Properties();
        String bootstrapServers = TestUtils$.MODULE$.plaintextBootstrapServers(this.servers());
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        return Admin.create((Properties)config);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$startBrokers$1(UncleanLeaderElectionTest $this, Properties props) {
        void createServer_createServer_createServer_startup;
        void createServer_time;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Time time = Time.SYSTEM;
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean bl = true;
        int createServer_createServer_createServer_licenseTopicReplicationFactor = 0;
        Object var6_5 = null;
        Object var4_4 = null;
        time = null;
        KafkaServer server = createServer_this.createServer(config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_licenseTopicReplicationFactor, (boolean)createServer_createServer_createServer_startup, false);
        $this.configs_$eq((Seq<KafkaConfig>)((Seq)$this.configs().$plus$plus((IterableOnce)new .colon.colon((Object)config, (List)Nil$.MODULE$))));
        $this.servers_$eq((Seq<KafkaServer>)((Seq)$this.servers().$plus$plus((IterableOnce)new .colon.colon((Object)server, (List)Nil$.MODULE$))));
    }

    public static final /* synthetic */ boolean $anonfun$testUncleanLeaderElectionRecoveryForFollowers$2(UncleanLeaderElectionTest $this) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaServer)$this.servers().last()).metadataCache().getPartitionInfo($this.topic(), $this.partitionId()).get()).leader() == $this.brokerId1();
    }

    public static final /* synthetic */ String $anonfun$testUncleanLeaderElectionRecoveryForFollowers$3(UncleanLeaderElectionTest $this) {
        return new StringBuilder(18).append("Leader should be ").append($this.brokerId1()).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testUncleanLeaderElectionRecoveryForFollowers$5(UncleanLeaderElectionTest $this) {
        return 1 == ((UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaServer)$this.servers().head()).metadataCache().getPartitionInfo($this.topic(), $this.partitionId()).get()).isr().size();
    }

    public static final /* synthetic */ String $anonfun$testUncleanLeaderElectionRecoveryForFollowers$6() {
        return "ISR should be down to 1";
    }

    public static final /* synthetic */ RecordMetadata $anonfun$testUncleanLeaderElectionRecoveryForFollowers$7(UncleanLeaderElectionTest $this, KafkaProducer producer$1, int x$5) {
        return (RecordMetadata)producer$1.send(new ProducerRecord($this.topic(), (Object)new byte[1024])).get();
    }

    public static final /* synthetic */ boolean $anonfun$testUncleanLeaderElectionRecoveryForFollowers$9(UncleanLeaderElectionTest $this) {
        return ((KafkaServer)$this.servers().head()).metadataCache().getAliveBrokers().size() == $this.servers().size();
    }

    public static final /* synthetic */ String $anonfun$testUncleanLeaderElectionRecoveryForFollowers$10() {
        return "All brokers should be running.";
    }

    public static final /* synthetic */ boolean $anonfun$testUncleanLeaderElectionRecoveryForFollowers$11(UncleanLeaderElectionTest $this) {
        return 1 == ((UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaServer)$this.servers().head()).metadataCache().getPartitionInfo($this.topic(), $this.partitionId()).get()).isr().size();
    }

    public static final /* synthetic */ String $anonfun$testUncleanLeaderElectionRecoveryForFollowers$12() {
        return "ISR should be down to 1";
    }

    public static final /* synthetic */ boolean $anonfun$testUncleanLeaderElectionRecoveryForFollowers$13(UncleanLeaderElectionTest $this) {
        int leader = ((UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaServer)$this.servers().last()).metadataCache().getPartitionInfo($this.topic(), $this.partitionId()).get()).leader();
        return leader == $this.brokerId2() || leader == $this.brokerId3();
    }

    public static final /* synthetic */ String $anonfun$testUncleanLeaderElectionRecoveryForFollowers$14() {
        return "Leader should either be 1 or 2 now";
    }

    public static final /* synthetic */ boolean $anonfun$testUncleanLeaderElectionRecoveryForFollowers$16(UncleanLeaderElectionTest $this, KafkaServer server) {
        return !((Partition)server.replicaManager().onlinePartition($this.topicPartition()).get()).isUncleanLeader();
    }

    public static final /* synthetic */ boolean $anonfun$testUncleanLeaderElectionRecoveryForFollowers$15(UncleanLeaderElectionTest $this) {
        return ((IterableOnceOps)$this.servers().tail()).forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$16($this, server)));
    }

    public static final /* synthetic */ String $anonfun$testUncleanLeaderElectionRecoveryForFollowers$17() {
        return "Leader and follower should have their `isUncleanLeader` flag cleared.";
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$3(int followerId$1, KafkaServer server) {
        return server.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ void $anonfun$verifyUncleanLeaderElectionEnabled$5(KafkaServer x$7) {
        x$7.kafkaController().controllerContext().stats().removeMetric("UncleanLeaderElectionsPerSec");
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$6(int leaderId$1, KafkaServer x$8) {
        return x$8.config().brokerId() == leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$8(int followerId$1, KafkaServer x$9) {
        return x$9.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$3(int followerId$2, KafkaServer server) {
        return server.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ void $anonfun$verifyUncleanLeaderElectionDisabled$5(KafkaServer server) {
        server.kafkaController().controllerContext().stats().removeMetric("UncleanLeaderElectionsPerSec");
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$6(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$8(int followerId$2, KafkaServer x$10) {
        return x$10.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$10(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$12(UncleanLeaderElectionTest $this, KafkaServer followerServer$1, int followerId$2) {
        Option partitionInfoOpt = followerServer$1.metadataCache().getPartitionInfo($this.topic(), $this.partitionId());
        return partitionInfoOpt.isDefined() && ((UpdateMetadataRequestData.UpdateMetadataPartitionState)partitionInfoOpt.get()).isr().contains(BoxesRunTime.boxToInteger((int)followerId$2));
    }

    public static final /* synthetic */ String $anonfun$verifyUncleanLeaderElectionDisabled$13() {
        return "Inconsistent metadata after first server startup";
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$14(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$1(int followerId$3, KafkaServer server) {
        return server.config().brokerId() == followerId$3;
    }

    public static final /* synthetic */ void $anonfun$testTopicUncleanLeaderElectionEnable$3(KafkaServer server) {
        server.kafkaController().controllerContext().stats().removeMetric("UncleanLeaderElectionsPerSec");
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$4(int leaderId$3, KafkaServer server) {
        return server.config().brokerId() == leaderId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$6(int followerId$3, KafkaServer x$12) {
        return x$12.config().brokerId() == followerId$3;
    }

    public UncleanLeaderElectionTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.brokerId3 = 2;
        this.enableControlledShutdown = true;
        this.partitionId = 0;
    }
}

