/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.cluster.Partition;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.FailureType;
import kafka.link.FailureType$;
import kafka.link.FailureType$AuthenticationFailure$;
import kafka.link.FailureType$AuthorizationFailure$;
import kafka.link.FailureType$CorruptConfigs$;
import kafka.link.FailureType$NetworkFailure$;
import kafka.link.FailureType$UndecodableConfigs$;
import kafka.log.AbstractLog;
import kafka.server.ConfigType$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.ReplicaManager;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.FailedClusterLink$;
import kafka.server.link.SecureLinkConfigEncoder;
import kafka.server.link.TopicLinkMirror$;
import kafka.utils.CoreUtils$;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\t\rh\u0001B\u0016-\u0001EBQA\u000e\u0001\u0005\u0002]Bq!\u000f\u0001C\u0002\u0013\u0005#\b\u0003\u0004B\u0001\u0001\u0006Ia\u000f\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003D\u0011\u0019a\u0005\u0001)A\u0005\t\"9Q\n\u0001b\u0001\n\u0013q\u0005B\u0002*\u0001A\u0003%q\nC\u0004T\u0001\t\u0007I\u0011\u0002(\t\rQ\u0003\u0001\u0015!\u0003P\u0011\u001d)\u0006A1A\u0005\nYCaA\u0017\u0001!\u0002\u00139\u0006\"C.\u0001\u0001\u0004\u0005\r\u0011\"\u0003]\u0011%Q\u0007\u00011AA\u0002\u0013%1\u000eC\u0005r\u0001\u0001\u0007\t\u0011)Q\u0005;\"I!\u000f\u0001a\u0001\u0002\u0004%Ia\u001d\u0005\nu\u0002\u0001\r\u00111A\u0005\nmD\u0011\" \u0001A\u0002\u0003\u0005\u000b\u0015\u0002;\t\u000by\u0004A\u0011I@\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0004bBAB\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0003#\u0003A\u0011AAJ\u0011\u001d\ty\n\u0001C\u0001\u0003CCq!!,\u0001\t\u0003\ty\u000bC\u0004\u0002<\u0002!\t!!0\t\u000f\u0005%\u0007\u0001\"\u0001\u0002L\"9\u0011q\u001b\u0001\u0005\u0002\u0005e\u0007bBAs\u0001\u0011\u0005\u0011q\u001d\u0005\b\u0003g\u0004A\u0011AA{\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0005\u0007AqAa\u0004\u0001\t\u0003\u0011\t\u0002C\u0004\u0003\u001e\u0001!\tAa\b\t\u000f\t-\u0002\u0001\"\u0001\u0003.!9!\u0011\b\u0001\u0005\u0002\tm\u0002b\u0002B$\u0001\u0011\u0005!\u0011\n\u0005\b\u0005+\u0002A\u0011\u0001B,\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0005GBqAa\u001c\u0001\t#\u0011\t\bC\u0005\u0003\u0010\u0002\t\n\u0011\"\u0005\u0003\u0012\"9!q\u0015\u0001\u0005\n\t%\u0006b\u0002BV\u0001\u0011%!Q\u0016\u0005\b\u0005+\u0004A\u0011\u0002BU\u0005Y\u0019E.^:uKJd\u0015N\\6GC&dWO]3UKN$(BA\u0017/\u0003\u0011a\u0017N\\6\u000b\u0003=\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001eA\u00111\u0007N\u0007\u0002Y%\u0011Q\u0007\f\u0002#\u0003\n\u001cHO]1di\u000ecWo\u001d;fe2Kgn[%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005A\u0004CA\u001a\u0001\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN]\u000b\u0002wA\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t)1\u000b[8si\u0006\u0011\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:!\u00035\u0019wN\\:v[\u0016\u0014xI]8vaV\tA\t\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006!A.\u00198h\u0015\u0005I\u0015\u0001\u00026bm\u0006L!a\u0013$\u0003\rM#(/\u001b8h\u00039\u0019wN\\:v[\u0016\u0014xI]8va\u0002\naa]=oG6\u001bX#A(\u0011\u0005q\u0002\u0016BA)>\u0005\u0011auN\\4\u0002\u000fMLhnY'tA\u00059!/\u001a;ss6\u001b\u0018\u0001\u0003:fiJLXj\u001d\u0011\u0002\u00159,XNU3d_J$7/F\u0001X!\ta\u0004,\u0003\u0002Z{\t\u0019\u0011J\u001c;\u0002\u00179,XNU3d_J$7\u000fI\u0001\nI\u0016\u001cH/\u00113nS:,\u0012!\u0018\t\u0003=\"l\u0011a\u0018\u0006\u0003A\u0006\fQ!\u00193nS:T!AY2\u0002\u000f\rd\u0017.\u001a8ug*\u0011q\u0006\u001a\u0006\u0003K\u001a\fa!\u00199bG\",'\"A4\u0002\u0007=\u0014x-\u0003\u0002j?\nq1i\u001c8gYV,g\u000e^!e[&t\u0017!\u00043fgR\fE-\\5o?\u0012*\u0017\u000f\u0006\u0002m_B\u0011A(\\\u0005\u0003]v\u0012A!\u00168ji\"9\u0001/DA\u0001\u0002\u0004i\u0016a\u0001=%c\u0005QA-Z:u\u0003\u0012l\u0017N\u001c\u0011\u0002\r1Lgn[%e+\u0005!\bCA;y\u001b\u00051(BA<d\u0003\u0019\u0019w.\\7p]&\u0011\u0011P\u001e\u0002\u0005+VLG-\u0001\u0006mS:\\\u0017\nZ0%KF$\"\u0001\u001c?\t\u000fA\u0004\u0012\u0011!a\u0001i\u00069A.\u001b8l\u0013\u0012\u0004\u0013!B:fiV\u0003Hc\u00017\u0002\u0002!9\u00111\u0001\nA\u0002\u0005\u0015\u0011\u0001\u0003;fgRLeNZ8\u0011\t\u0005\u001d\u0011QC\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005\u0019\u0011\r]5\u000b\t\u0005=\u0011\u0011C\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t\u0019BZ\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003/\tIA\u0001\u0005UKN$\u0018J\u001c4pQ\r\u0011\u00121\u0004\t\u0005\u0003\u000f\ti\"\u0003\u0003\u0002 \u0005%!A\u0003\"fM>\u0014X-R1dQ\u00061C/Z:u\u001b&\u0014(o\u001c:U_BL7m\u00149fe\u0006$\u0018n\u001c8t\u001f:d\u0015N\\6GC&dWO]3\u0015\u000b1\f)#!\u0010\t\u000f\u0005\u001d2\u00031\u0001\u0002*\u00051\u0011/^8sk6\u0004B!a\u000b\u0002:9!\u0011QFA\u001b!\r\ty#P\u0007\u0003\u0003cQ1!a\r1\u0003\u0019a$o\\8u}%\u0019\u0011qG\u001f\u0002\rA\u0013X\rZ3g\u0013\rY\u00151\b\u0006\u0004\u0003oi\u0004bBA '\u0001\u0007\u0011\u0011I\u0001\fG>|'\u000fZ5oCR|'\u000fE\u0002=\u0003\u0007J1!!\u0012>\u0005\u001d\u0011un\u001c7fC:DsaEA%\u00033\nY\u0006\u0005\u0003\u0002L\u0005USBAA'\u0015\u0011\ty%!\u0015\u0002\u0011A\u0014xN^5eKJTA!a\u0015\u0002\u000e\u00051\u0001/\u0019:b[NLA!a\u0016\u0002N\taQ*\u001a;i_\u0012\u001cv.\u001e:dK\u0006)a/\u00197vK2\u0012\u0011QL\u0011\u0003\u0003?\naB_6D_6\u0014\u0017N\\1uS>t7\u000fK\u0004\u0014\u0003G\nY'!\u001c\u0011\t\u0005\u0015\u0014qM\u0007\u0003\u0003#JA!!\u001b\u0002R\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0003\u0003_\n\u0001f\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~]\r|wN\u001d3j]\u0006$xN]\u001f|cu\fQ\u0004^3tiN{WO]2f\u00072,8\u000f^3s\u001d>$\u0018I^1jY\u0006\u0014G.\u001a\u000b\u0006Y\u0006U\u0014q\u000f\u0005\b\u0003O!\u0002\u0019AA\u0015\u0011\u001d\ty\u0004\u0006a\u0001\u0003\u0003Bs\u0001FA%\u00033\nY\b\f\u0002\u0002~\u0005\u0012\u0011qP\u0001\u0010C2d7i\\7cS:\fG/[8og\":A#a\u0019\u0002l\u00055\u0014!\u0007;fgR$U\r\\3uK2Kgn\u001b#ve&twMU3uef$R\u0001\\AD\u0003\u0013Cq!a\n\u0016\u0001\u0004\tI\u0003C\u0004\u0002@U\u0001\r!!\u0011)\u000fU\tI%!\u0017\u0002\u000e2\u0012\u0011Q\f\u0015\b+\u0005\r\u00141NA7\u0003e!Xm\u001d;BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3\u0015\u000b1\f)*a&\t\u000f\u0005\u001db\u00031\u0001\u0002*!9\u0011q\b\fA\u0002\u0005\u0005\u0003f\u0002\f\u0002J\u0005e\u00131\u0014\u0017\u0003\u0003{BsAFA2\u0003W\ni'\u0001\ruKN$\u0018)\u001e;i_JL'0\u0019;j_:4\u0015-\u001b7ve\u0016$R\u0001\\AR\u0003KCq!a\n\u0018\u0001\u0004\tI\u0003C\u0004\u0002@]\u0001\r!!\u0011)\u000f]\tI%!\u0017\u0002*2\u0012\u0011Q\u0010\u0015\b/\u0005\r\u00141NA7\u0003I!Xm\u001d;D_J\u0014X\u000f\u001d;D_:4\u0017nZ:\u0015\u000b1\f\t,a-\t\u000f\u0005\u001d\u0002\u00041\u0001\u0002*!9\u0011q\b\rA\u0002\u0005\u0005\u0003f\u0002\r\u0002J\u0005e\u0013q\u0017\u0017\u0003\u0003;Bs\u0001GA2\u0003W\ni'\u0001\fuKN$XK\u001c3fG>$\u0017M\u00197f\u0007>tg-[4t)\u0015a\u0017qXAa\u0011\u001d\t9#\u0007a\u0001\u0003SAq!a\u0010\u001a\u0001\u0004\t\t\u0005K\u0004\u001a\u0003\u0013\nI&!2-\u0005\u0005u\u0003fB\r\u0002d\u0005-\u0014QN\u0001\u001fi\u0016\u001cH\u000fT5ti\u0012+7o\u0019:jE\u0016<\u0016\u000e\u001e5pkR\u001cuN\u001c4jON$R\u0001\\Ag\u0003\u001fDq!a\n\u001b\u0001\u0004\tI\u0003C\u0004\u0002@i\u0001\r!!\u0011)\u000fi\tI%!\u0017\u0002T2\u0012\u0011Q\f\u0015\b5\u0005\r\u00141NA7\u0003U!Xm\u001d;T_V\u00148-\u001a+pa&\u001cG)\u001a7fi\u0016$R\u0001\\An\u0003;Dq!a\n\u001c\u0001\u0004\tI\u0003C\u0004\u0002@m\u0001\r!!\u0011)\u000fm\tI%!\u0017\u0002b2\u0012\u0011Q\u0010\u0015\b7\u0005\r\u00141NA7\u00035\"Xm\u001d;T_V\u00148-\u001a+pa&\u001c'+Z2sK\u0006$X\rR3uK\u000e$\u0018n\u001c8Vg&tw\rV8qS\u000eLEm\u001d\u000b\u0006Y\u0006%\u00181\u001e\u0005\b\u0003Oa\u0002\u0019AA\u0015\u0011\u001d\ty\u0004\ba\u0001\u0003\u0003Bs\u0001HA%\u00033\ny\u000f\f\u0002\u0002~!:A$a\u0019\u0002l\u00055\u0014a\u0006;fgR\u001cv.\u001e:dK2+\u0017\rZ3s\u0007\"\fgnZ3t)\u0015a\u0017q_A}\u0011\u001d\t9#\ba\u0001\u0003SAq!a\u0010\u001e\u0001\u0004\t\t\u0005K\u0004\u001e\u0003\u0013\nI&!@-\u0005\u0005u\u0003fB\u000f\u0002d\u0005-\u0014QN\u00012i\u0016\u001cH/\u00168dY\u0016\fgnU8ve\u000e,G*Z1eKJ,E.Z2uS>tw+\u001b;i\t\u0016\u001cH/\u00129pG\"\f\u0005.Z1e)\u0015a'Q\u0001B\u0004\u0011\u001d\t9C\ba\u0001\u0003SAq!a\u0010\u001f\u0001\u0004\t\t\u0005K\u0004\u001f\u0003\u0013\nIFa\u0003-\u0005\u0005u\u0003f\u0002\u0010\u0002d\u0005-\u0014QN\u0001\u0016i\u0016\u001cH\u000fR3ti2+\u0017\rZ3s\u0007\"\fgnZ3t)\u0015a'1\u0003B\u000b\u0011\u001d\t9c\ba\u0001\u0003SAq!a\u0010 \u0001\u0004\t\t\u0005K\u0004 \u0003\u0013\nIF!\u0007-\u0005\u0005u\u0003fB\u0010\u0002d\u0005-\u0014QN\u0001\u001ei\u0016\u001cH\u000fR3ti\u001a{G\u000e\\8xKJ\f\u0005.Z1e\u001f\u001adU-\u00193feR)AN!\t\u0003$!9\u0011q\u0005\u0011A\u0002\u0005%\u0002bBA A\u0001\u0007\u0011\u0011\t\u0015\bA\u0005%\u0013\u0011\fB\u0014Y\t\ti\u0006K\u0004!\u0003G\nY'!\u001c\u0002]Q,7\u000f\u001e#fgR\u0014V\r\u001d7jG\u0006$\u0018n\u001c8O_RLU\u000e]1di\u0016$')_*pkJ\u001cWMR1jYV\u0014Xm\u001d\u000b\u0006Y\n=\"\u0011\u0007\u0005\b\u0003O\t\u0003\u0019AA\u0015\u0011\u001d\ty$\ta\u0001\u0003\u0003Bs!IA%\u00033\u0012)\u0004\f\u0002\u0002~!:\u0011%a\u0019\u0002l\u00055\u0014A\u0011;fgR$Um\u001d;SKBd\u0017nY1uS>tgj\u001c;J[B\f7\r^3e\u0005f\u001cv.\u001e:dK\u001a\u000b\u0017\u000e\\;sKN<\u0016\u000e\u001e5PY\u0012lUm]:bO\u00164uN]7biR)AN!\u0010\u0003@!9\u0011q\u0005\u0012A\u0002\u0005%\u0002bBA E\u0001\u0007\u0011\u0011\t\u0015\bE\u0005%\u0013\u0011\fB\"Y\t\ti\bK\u0004#\u0003G\nY'!\u001c\u00029Q,7\u000f\u001e#fgRLg.\u0019;j_:D\u0015n\u001a5XCR,'/\\1sWR)ANa\u0013\u0003N!9\u0011qE\u0012A\u0002\u0005%\u0002bBA G\u0001\u0007\u0011\u0011\t\u0015\bG\u0005%\u0013\u0011\fB)Y\t\ti\bK\u0004$\u0003G\nY'!\u001c\u0002wQ,7\u000f\u001e(p)J,hnY1uS>t')\u001a7po\"Kw\r[,bi\u0016\u0014X.\u0019:l/&$\b.R7qifdU-\u00193fe\u0016\u0003xn\u00195DC\u000eDW\rF\u0002m\u00053Bq!a\n%\u0001\u0004\tI\u0003K\u0004%\u0003\u0013\nIF!\u0018-\u0005\u0005u\u0004f\u0002\u0013\u0002d\u0005-\u0014QN\u0001.i\u0016\u001cH\u000fR3mKR,\u0017)\u001e;p\u0007J,\u0017\r^3e\u001b&\u0014(o\u001c:U_BL7MR8s\r\u0006LG.\u001a3MS:\\G#\u00027\u0003f\t\u001d\u0004bBA\u0014K\u0001\u0007\u0011\u0011\u0006\u0005\b\u0003\u007f)\u0003\u0019AA!Q\u001d)\u0013\u0011JA-\u0005Wb#!! )\u000f\u0015\n\u0019'a\u001b\u0002n\u0005Ab/\u001a:jMf4\u0015-\u001b7ve\u0016\fe\u000e\u001a*fG>4XM]=\u0015\u00131\u0014\u0019H! \u0003\b\n-\u0005b\u0002B;M\u0001\u0007!qO\u0001\fM\u0006LG.\u001e:f)f\u0004X\rE\u00024\u0005sJ1Aa\u001f-\u0005-1\u0015-\u001b7ve\u0016$\u0016\u0010]3\t\u000f\t}d\u00051\u0001\u0003\u0002\u0006a1\u000f^1si\u001a\u000b\u0017\u000e\\;sKB!AHa!m\u0013\r\u0011))\u0010\u0002\n\rVt7\r^5p]BBqA!#'\u0001\u0004\u0011\t)A\u0006ti>\u0004h)Y5mkJ,\u0007\"\u0003BGMA\u0005\t\u0019AA!\u0003\u00152XM]5gs\u00063\u0018-\u001b7bE&d\u0017\u000e^=NKR\u0014\u0018nY!gi\u0016\u0014(+Z2pm\u0016\u0014\u00180\u0001\u0012wKJLg-\u001f$bS2,(/Z!oIJ+7m\u001c<fef$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005'SC!!\u0011\u0003\u0016.\u0012!q\u0013\t\u0005\u00053\u0013\u0019+\u0004\u0002\u0003\u001c*!!Q\u0014BP\u0003%)hn\u00195fG.,GMC\u0002\u0003\"v\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Ka'\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\bxC&$hi\u001c:SK\u000e|g/\u001a:z)\u0005a\u0017AC1dY\nKg\u000eZ5oOR1!q\u0016B^\u0005\u0017\u0004BA!-\u000386\u0011!1\u0017\u0006\u0004\u0005k3\u0018aA1dY&!!\u0011\u0018BZ\u0005)\t5\r\u001c\"j]\u0012Lgn\u001a\u0005\b\u0005{K\u0003\u0019\u0001B`\u00031\u0011Xm]8ve\u000e,G+\u001f9f!\u0011\u0011\tMa2\u000e\u0005\t\r'b\u0001Bcm\u0006A!/Z:pkJ\u001cW-\u0003\u0003\u0003J\n\r'\u0001\u0004*fg>,(oY3UsB,\u0007b\u0002BgS\u0001\u0007!qZ\u0001\u000fa\u0016\u0014X.[:tS>tG+\u001f9f!\u0011\u0011\tL!5\n\t\tM'1\u0017\u0002\u0012\u0003\u000ed\u0007+\u001a:nSN\u001c\u0018n\u001c8UsB,\u0017aC1eI2Kgn[!dYNDs\u0001\u0001Bm\u00033\u0012y\u000e\u0005\u0003\u0002\b\tm\u0017\u0002\u0002Bo\u0003\u0013\u00111\u0001V1hC\t\u0011\t/A\u0006j]R,wM]1uS>t\u0007")
public class ClusterLinkFailureTest
extends AbstractClusterLinkIntegrationTest {
    private final short replicationFactor = (short)3;
    private final String consumerGroup;
    private final long syncMs;
    private final long retryMs;
    private final int numRecords;
    private ConfluentAdmin destAdmin;
    private Uuid linkId;

    @Override
    public short replicationFactor() {
        return this.replicationFactor;
    }

    private String consumerGroup() {
        return this.consumerGroup;
    }

    private long syncMs() {
        return this.syncMs;
    }

    private long retryMs() {
        return this.retryMs;
    }

    private int numRecords() {
        return this.numRecords;
    }

    private ConfluentAdmin destAdmin() {
        return this.destAdmin;
    }

    private void destAdmin_$eq(ConfluentAdmin x$1) {
        this.destAdmin = x$1;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private void linkId_$eq(Uuid x$1) {
        this.linkId = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        if (this.sourceCluster() == null && this.destCluster() == null) {
            None$ x$4 = None$.MODULE$;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_SSL, (Option<SecurityProtocol>)x$4, 0, 3));
            None$ x$8 = None$.MODULE$;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_PLAINTEXT, (Option<SecurityProtocol>)x$8, 100, 3));
            this.sourceCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), this.authorizerClassName(testInfo));
            this.sourceCluster().serverConfig().setProperty("super.users", new StringBuilder(11).append("User:").append(JaasTestUtils$.MODULE$.KafkaScramAdmin()).append(";User:").append(JaasTestUtils$.MODULE$.KafkaScramUser2()).toString());
        }
        super.setUp(testInfo);
        this.addLinkAcls();
        ClusterLinkTestHarness qual$1 = this.destCluster();
        Properties x$9 = qual$1.createConfluentAdminClient$default$1();
        this.destAdmin_$eq(qual$1.createConfluentAdminClient(x$9));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testMirrorTopicOperationsOnLinkFailure(String quorum, boolean coordinator) {
        void var12_16;
        Tuple2 tuple2;
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(this.syncMs(), this.retryMs(), this.consumerGroup(), this.setupLinkAndMirrorForFailureTest$default$4()));
        int numRecords = 10;
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        this.destCluster().updateZkLinkConfig(this.linkId(), ClusterLinkConfig$.MODULE$.ConnectionModeProp(), "invalid");
        this.waitForFailure(this.destAdmin(), FailureType$CorruptConfigs$.MODULE$, this.waitForFailure$default$3());
        String topic2 = "linkedTopic2";
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(topic2, x$2, 2, x$4, x$5, x$6);
        Assertions.assertThrows(InvalidRequestException.class, () -> {
            ClusterLinkTestHarness qual$2 = this.destCluster();
            String x$9 = this.linkName();
            Map<String, String> x$10 = qual$2.linkTopic$default$4();
            String x$11 = qual$2.linkTopic$default$5();
            qual$2.linkTopic(topic2, (short)2, x$9, x$10, x$11);
        });
        this.destCluster().deleteTopic(this.topic(), true);
        ConnectionMode.Inbound$ destConnectionMode = this.useSourceInitiatedLink() ? ConnectionMode.Inbound$.MODULE$ : ConnectionMode.Outbound$.MODULE$;
        this.destCluster().updateZkLinkConfig(this.linkId(), ClusterLinkConfig$.MODULE$.ConnectionModeProp(), ((ConnectionMode)destConnectionMode).name());
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            ClusterLinkListing computeUntilTrue_result;
            if ((computeUntilTrue_result = this.linkInfo(this.destAdmin())).available()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var24_14 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        ClusterLinkListing link = (ClusterLinkListing)tuple22._1();
        Assertions.assertTrue((boolean)var12_16.available(), (String)"Link not available");
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$12 = this.topic();
        String x$14 = this.linkName();
        Map<String, String> x$15 = qual$3.linkTopic$default$4();
        String x$16 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$12, (short)2, x$14, x$15, x$16);
        this.waitForRecovery();
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testSourceClusterNotAvailable(String quorum, boolean coordinator) {
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        this.verifyFailureAndRecovery(FailureType$NetworkFailure$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.sourceCluster().killAllBrokers(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.restartCluster(this.sourceCluster(), this.restartCluster$default$2()), true);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testDeleteLinkDuringRetry(String quorum, boolean coordinator) {
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(this.syncMs(), this.retryMs(), this.consumerGroup(), this.setupLinkAndMirrorForFailureTest$default$4()));
        this.produceToSourceCluster(this.numRecords());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.destCluster().updateZkLinkConfig(this.linkId(), "bootstrap.servers", "999.999.999.999:0000");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkFailureTest.$anonfun$testDeleteLinkDuringRetry$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"cluster link didn't fail as expected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyFailureRetryMetric((Option<String>)new Some((Object)this.linkName()));
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        scala.collection.immutable.Seq<KafkaBroker> x$3 = qual$1.deleteClusterLink$default$3();
        qual$1.deleteClusterLink(x$1, true, x$3);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        boolean x$42 = qual$2.listClusterLinks$default$1();
        Option<String> x$5 = qual$2.listClusterLinks$default$2();
        Assertions.assertTrue((boolean)qual$2.listClusterLinks(x$42, x$5).isEmpty());
        Assertions.assertFalse((boolean)this.destCluster().brokers().exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDeleteLinkDuringRetry$3(this, x$4))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testAuthenticationFailure(String quorum, boolean coordinator) {
        ClusterLinkTestHarness connectionTarget = this.useSourceInitiatedLink() ? this.destCluster() : this.sourceCluster();
        ObjectRef newJaasConfig = ObjectRef.create(null);
        this.verifyFailureAndRecovery(FailureType$AuthenticationFailure$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            newJaasConfig$1.elem = this.updateCredentials(connectionTarget);
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)((String)newJaasConfig$1.elem))})))), this.verifyFailureAndRecovery$default$4());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testAuthorizationFailure(String quorum, boolean coordinator) {
        AclBinding denyTopicAcl = this.aclBinding(ResourceType.TOPIC, AclPermissionType.DENY);
        this.verifyFailureAndRecovery(FailureType$AuthorizationFailure$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.sourceCluster().addAcls((scala.collection.immutable.Seq<AclBinding>)new .colon.colon((Object)denyTopicAcl, (List)Nil$.MODULE$)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.sourceCluster().deleteAcls((scala.collection.immutable.Seq<AclBinding>)new .colon.colon((Object)denyTopicAcl, (List)Nil$.MODULE$)), this.verifyFailureAndRecovery$default$4());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testCorruptConfigs(String quorum, boolean coordinator) {
        ConnectionMode.Inbound$ destConnectionMode = this.useSourceInitiatedLink() ? ConnectionMode.Inbound$.MODULE$ : ConnectionMode.Outbound$.MODULE$;
        this.verifyFailureAndRecovery(FailureType$CorruptConfigs$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.destCluster().updateZkLinkConfig(this.linkId(), ClusterLinkConfig$.MODULE$.ConnectionModeProp(), "invalid"), (Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> ClusterLinkFailureTest.$anonfun$testCorruptConfigs$2(this, (Product)destConnectionMode)), this.verifyFailureAndRecovery$default$4());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testUndecodableConfigs(String quorum, boolean coordinator) {
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        Properties linkConfigs = new Properties();
        this.verifyFailureAndRecovery(FailureType$UndecodableConfigs$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.makeConfigUndecodable$1(linkConfigs), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.reconfigureLink$1(linkConfigs), this.verifyFailureAndRecovery$default$4());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testListDescribeWithoutConfigs(String quorum, boolean coordinator) {
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        this.useBidirectionalLink_$eq(false);
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(this.syncMs(), this.retryMs(), this.consumerGroup(), this.setupLinkAndMirrorForFailureTest$default$4()));
        this.produceToSourceCluster(this.numRecords());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.destCluster().updateZkLinkConfig(this.linkId(), "bootstrap.servers", "invalid");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkFailureTest.$anonfun$testListDescribeWithoutConfigs$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"cluster link didn't fail as expected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ClusterLinkTestHarness qual$1 = this.destCluster();
        boolean x$1 = qual$1.listClusterLinks$default$1();
        Option<String> x$2 = qual$1.listClusterLinks$default$2();
        scala.collection.immutable.Seq<ClusterLinkListing> res1 = qual$1.listClusterLinks(x$1, x$2);
        Assertions.assertEquals((Object)((ClusterLinkListing)res1.head()).linkName(), (Object)this.linkName());
        Assertions.assertEquals((Object)((ClusterLinkListing)res1.head()).clusterLinkError(), (Object)ClusterLinkError.UNKNOWN);
        this.createClusterLink("test-link2", this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        boolean x$3 = qual$2.describeClusterLinks$default$1();
        Option<String> x$4 = qual$2.describeClusterLinks$default$2();
        int x$5 = qual$2.describeClusterLinks$default$3();
        scala.collection.immutable.Seq<ClusterLinkDescription> res2 = qual$2.describeClusterLinks(x$3, x$4, x$5);
        Assertions.assertEquals((int)res2.size(), (int)2);
        Assertions.assertTrue((boolean)((IterableOnceOps)res2.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testListDescribeWithoutConfigs$3(this, x$6)))).exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testListDescribeWithoutConfigs$4(x$7))));
        Assertions.assertTrue((boolean)((IterableOnceOps)res2.filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testListDescribeWithoutConfigs$5(x$8)))).exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testListDescribeWithoutConfigs$6(x$9))));
        Assertions.assertTrue((boolean)((IterableOnceOps)res2.filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testListDescribeWithoutConfigs$7(this, x$10)))).exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testListDescribeWithoutConfigs$8(x$11))));
        Assertions.assertTrue((boolean)((IterableOnceOps)res2.filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testListDescribeWithoutConfigs$9(x$12)))).exists((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testListDescribeWithoutConfigs$10(x$13))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testSourceTopicDelete(String quorum, boolean coordinator) {
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(this.syncMs(), this.retryMs(), this.consumerGroup(), this.setupLinkAndMirrorForFailureTest$default$4()));
        int numRecords = 10;
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, 5L, this.consumerGroup());
        this.verifyOffsetMigration(this.topic(), 0, 5L, this.consumerGroup(), this.verifyOffsetMigration$default$5());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        Uuid sourceTopicId = this.sourceCluster().describeTopic(this.topic()).topicId();
        this.sourceCluster().deleteTopic(this.topic(), true);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.FAILED);
        this.waitForFailure(this.destAdmin(), FailureType$.MODULE$.SourceTopicMayBeDeleted(), this.waitForFailure$default$3());
        Assertions.assertEquals((Object)sourceTopicId, (Object)this.destCluster().describeMirrorTopic(this.topic()).sourceTopicId());
        Properties topicProps = new Properties();
        topicProps.put("max.message.bytes", "100000");
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, 1, x$3, topicProps, x$5, x$6);
        this.produceToSourceCluster(numRecords);
        this.truncate(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, 10L, this.consumerGroup());
        this.verifyOffsetMigration(this.topic(), 0, 5L, this.consumerGroup(), this.verifyOffsetMigration$default$5());
        Assertions.assertEquals((int)this.numPartitions(), (int)this.destCluster().describeTopic(this.topic()).partitions().size());
        Option maxMessageSize = Option$.MODULE$.apply((Object)this.destCluster().describeTopicConfig(this.topic()).get("max.message.bytes"));
        Assertions.assertTrue((boolean)maxMessageSize.nonEmpty());
        Assertions.assertNotEquals((Object)"100000", (Object)((ConfigEntry)maxMessageSize.get()).value());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.FAILED);
        this.destCluster().killAllBrokers();
        this.destAdmin_$eq((ConfluentAdmin)this.restartCluster(this.destCluster(), !this.useSourceInitiatedLink()).get());
        this.waitForFailure(this.destAdmin(), FailureType$.MODULE$.SourceTopicMayBeDeleted(), this.waitForFailure$default$3());
        String x$7 = this.topic();
        Seq<KafkaBroker> x$9 = this.verifyMirror$default$2();
        boolean x$10 = this.verifyMirror$default$4();
        this.verifyMirror(x$7, x$9, false, x$10);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testSourceTopicRecreateDetectionUsingTopicIds(String quorum, boolean coordinator) {
        this.numPartitions_$eq(1);
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(300000L, 300000L, this.consumerGroup(), this.setupLinkAndMirrorForFailureTest$default$4()));
        this.produceToSourceCluster(20);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.sourceCluster().changeLeader(tp);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkFailureTest.$anonfun$testSourceTopicRecreateDetectionUsingTopicIds$1(this, tp)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Destination epoch not bumped");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.produceToSourceCluster(5);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.sourceCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.produceToSourceCluster(20);
        this.truncate(20);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.waitForFailure(this.destAdmin(), FailureType$.MODULE$.SourceTopicIdChanged(), this.waitForFailure$default$3());
        this.destCluster().killAllBrokers();
        this.destAdmin_$eq((ConfluentAdmin)this.restartCluster(this.destCluster(), !this.useSourceInitiatedLink()).get());
        String x$7 = this.topic();
        Seq<KafkaBroker> x$10 = this.verifyMirror$default$2();
        this.verifyMirror(x$7, x$10, false, false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testSourceLeaderChanges(String quorum, boolean coordinator) {
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5()));
        this.verifyMirrorWithSourceEpochChanges(false);
        this.verifyBasicLinkMetrics(this.linkId(), this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyLinkedLeaderChangeMetrics();
        String x$1 = this.topic();
        Seq<KafkaBroker> x$3 = this.verifyMirror$default$2();
        boolean x$4 = this.verifyMirror$default$3();
        this.verifyMirror(x$1, x$3, x$4, false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testUncleanSourceLeaderElectionWithDestEpochAhead(String quorum, boolean coordinator) {
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5()));
        this.verifyMirrorWithSourceEpochChanges(true);
        this.verifyLinkedLeaderChangeMetrics();
        String x$1 = this.topic();
        Seq<KafkaBroker> x$3 = this.verifyMirror$default$2();
        boolean x$4 = this.verifyMirror$default$3();
        this.verifyMirror(x$1, x$3, x$4, false);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testDestLeaderChanges(String quorum, boolean coordinator) {
        void var20_20;
        void var18_18;
        this.numPartitions_$eq(this.sourceCluster().brokerCount());
        TopicPartition tp = (TopicPartition)this.partitions(this.partitions$default$1(), this.partitions$default$2(), this.partitions$default$3()).head();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5()));
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(this.numPartitions());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(this.linkId(), this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        Tuple2<Object, Object> tuple2 = this.destCluster().shutdownLeader(tp);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int leader1 = tuple2._1$mcI$sp();
        this.produceToSourceCluster(this.numPartitions());
        this.waitForMirror((Seq<KafkaBroker>)((Seq)this.destCluster().brokers().filter(arg_0 -> ClusterLinkFailureTest.$anonfun$testDestLeaderChanges$1$adapted(this, (int)var18_18, arg_0))), this.waitForMirror$default$2());
        Tuple2<Object, Object> tuple22 = this.destCluster().shutdownLeader(tp);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int leader2 = tuple22._1$mcI$sp();
        this.destCluster().startBroker((int)var18_18);
        this.produceToSourceCluster(this.numPartitions());
        this.waitForMirror((Seq<KafkaBroker>)((Seq)this.destCluster().brokers().filter(arg_0 -> ClusterLinkFailureTest.$anonfun$testDestLeaderChanges$2$adapted(this, (int)var20_20, arg_0))), this.waitForMirror$default$2());
        this.destCluster().startBroker((int)var20_20);
        this.produceToSourceCluster(this.numPartitions());
        String x$12 = this.topic();
        Seq<KafkaBroker> x$14 = this.verifyMirror$default$2();
        boolean x$15 = this.verifyMirror$default$3();
        this.verifyMirror(x$12, x$14, x$15, false);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"zkCombinations"})
    public void testDestFollowerAheadOfLeader(String quorum, boolean coordinator) {
        void var22_22;
        void var20_20;
        void var17_17;
        void var16_16;
        this.numPartitions_$eq(1);
        TopicPartition tp = (TopicPartition)this.partitions(this.partitions$default$1(), this.partitions$default$2(), this.partitions$default$3()).head();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, 2, x$4, x$5, x$6);
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5()));
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, (short)2, x$9, x$10, x$11);
        Tuple2<Object, Object> tuple2 = this.destCluster().shutdownLeader(tp);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int destBroker1 = tuple2._1$mcI$sp();
        int destLeaderEpoch1 = tuple2._2$mcI$sp();
        int destBroker2 = TestUtils$.MODULE$.awaitLeaderAndEpochChange(this.destCluster().aliveServers(), tp, (int)var16_16, (int)var17_17, 15000L);
        this.produceToSourceCluster(100);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$17 -> {
            this.sourceCluster().bounceLeader(tp);
            this.produceToSourceCluster(100);
        });
        Tuple2<Object, Object> tuple22 = this.sourceCluster().shutdownLeader(tp);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int sourceBroker1 = tuple22._1$mcI$sp();
        this.produceToSourceCluster(100);
        this.waitForMirror((Seq<KafkaBroker>)new .colon.colon((Object)this.destCluster().serverWithBrokerId(destBroker2), (List)Nil$.MODULE$), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(this.linkId(), this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        Tuple2<Object, Object> tuple23 = this.destCluster().shutdownLeader(tp);
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        int destLeaderEpoch2 = tuple23._2$mcI$sp();
        this.sourceCluster().shutdownLeader(tp);
        this.truncate(100);
        this.sourceCluster().startBroker((int)var20_20);
        this.destCluster().startBroker((int)var16_16);
        int newLeader = TestUtils$.MODULE$.awaitLeaderAndEpochChange(this.destCluster().aliveServers(), tp, destBroker2, (int)var22_22, 15000L);
        Assertions.assertEquals((int)var16_16, (int)newLeader);
        this.destCluster().startBroker(destBroker2);
        this.produceToSourceCluster(100);
        String x$12 = this.topic();
        Seq<KafkaBroker> x$14 = this.verifyMirror$default$2();
        boolean x$15 = this.verifyMirror$default$3();
        this.verifyMirror(x$12, x$14, x$15, false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDestReplicationNotImpactedBySourceFailures(String quorum, boolean coordinator) {
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        this.createLinkAndMirrorWithPartialReplicationAndShutdownSource(new Properties(), this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$2(), this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$3());
        String x$1 = this.topic();
        Seq<KafkaBroker> x$4 = this.verifyMirror$default$2();
        this.verifyMirror(x$1, x$4, false, false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDestReplicationNotImpactedBySourceFailuresWithOldMessageFormat(String quorum, boolean coordinator) {
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        Properties topicConfig = new Properties();
        topicConfig.setProperty("message.format.version", "0.9.0");
        this.createLinkAndMirrorWithPartialReplicationAndShutdownSource(topicConfig, this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$2(), this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$3());
        String x$1 = this.topic();
        Seq<KafkaBroker> x$4 = this.verifyMirror$default$2();
        this.verifyMirror(x$1, x$4, false, false);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDestinationHighWatermark(String quorum, boolean coordinator) {
        void var79_69;
        Tuple2 tuple2;
        void var76_62;
        Tuple2 tuple22;
        void var73_55;
        Tuple2 tuple23;
        void var47_43;
        Tuple2 tuple24;
        void var44_36;
        Tuple2 tuple25;
        void var41_29;
        Tuple2 tuple26;
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        this.numPartitions_$eq(1);
        TopicPartition tp = (TopicPartition)this.partitions(this.partitions$default$1(), this.partitions$default$2(), this.partitions$default$3()).head();
        Properties props = new Properties();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, props, x$5, x$6);
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5()));
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        LongRef startOffset = LongRef.create((long)0L);
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.destCluster().brokers(), tp, TestUtils$.MODULE$.waitUntilLeaderIsKnown$default$3());
        Buffer destReplicaManagers = (Buffer)((IterableOps)this.destCluster().brokers().map((Function1 & Serializable)x$22 -> x$22.replicaManager())).filter((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$9(tp, x$23)));
        ReplicaManager sourceReplicaManager = this.sourceCluster().partitionLeader(tp).replicaManager();
        this.produceToSourceCluster(100);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        destReplicaManagers.foreach((Function1 & Serializable)replicaManager -> {
            ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$10(this, tp, startOffset, replicaManager);
            return BoxedUnit.UNIT;
        });
        startOffset.elem = 50L;
        sourceReplicaManager.deleteRecords(15000L, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)startOffset.elem))})), (Function1 & Serializable)x$24 -> {
            ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$11(x$24);
            return BoxedUnit.UNIT;
        });
        this.produceToSourceCluster(100);
        long verifyLog$1_highWatermark = this.verifyLog$default$2$1();
        AbstractLog verifyLog$1_log = (AbstractLog)sourceReplicaManager.getLog(tp).get();
        int verifyLog$1_endOffset = this.producedRecords().size();
        long l = 100L;
        long verifyLog$1_computeUntilTrue_waitTime = 15000L;
        long verifyLog$1_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l2 = verifyLog$1_log.logStartOffset();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l2);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$3(startOffset, l2)) {
                tuple26 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime + verifyLog$1_computeUntilTrue_waitTime) {
                tuple26 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var55_27 = null;
        Tuple2 tuple27 = tuple26;
        if (tuple27 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logStartOffset = tuple27._1$mcJ$sp();
        Assertions.assertEquals((long)startOffset.elem, (long)var41_29, (String)new StringBuilder(29).append("Unexpected log start offset: ").append(new StringBuilder(67).append("isLeader=").append(sourceReplicaManager.onlinePartition(tp).exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log.logStartOffset()).append(", end=").append(verifyLog$1_log.logEndOffset()).append(", hwm=").append(verifyLog$1_log.highWatermark()).append(") ").append("expected (start=").append(startOffset.elem).append(", end=").append(verifyLog$1_endOffset).append(", hwm=").append(verifyLog$1_highWatermark).append(")").toString()).toString());
        long l3 = 100L;
        long verifyLog$1_computeUntilTrue_waitTime2 = 15000L;
        long verifyLog$1_computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l4 = verifyLog$1_log.logEndOffset();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l4);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$5(verifyLog$1_endOffset, l4)) {
                tuple25 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime2 + verifyLog$1_computeUntilTrue_waitTime2) {
                tuple25 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime2), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var62_34 = null;
        Tuple2 tuple28 = tuple25;
        if (tuple28 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logEndOffset = tuple28._1$mcJ$sp();
        Assertions.assertEquals((long)verifyLog$1_endOffset, (long)var44_36, (String)new StringBuilder(27).append("Unexpected log end offset: ").append(new StringBuilder(67).append("isLeader=").append(sourceReplicaManager.onlinePartition(tp).exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log.logStartOffset()).append(", end=").append(verifyLog$1_log.logEndOffset()).append(", hwm=").append(verifyLog$1_log.highWatermark()).append(") ").append("expected (start=").append(startOffset.elem).append(", end=").append(verifyLog$1_endOffset).append(", hwm=").append(verifyLog$1_highWatermark).append(")").toString()).toString());
        long l5 = 100L;
        long verifyLog$1_computeUntilTrue_waitTime3 = 15000L;
        long verifyLog$1_computeUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l6 = verifyLog$1_log.highWatermark();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l6);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$7(verifyLog$1_highWatermark, l6)) {
                tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime3 + verifyLog$1_computeUntilTrue_waitTime3) {
                tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime3), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var69_40 = null;
        Tuple2 tuple29 = tuple24;
        if (tuple29 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logHighWatermark = tuple29._1$mcJ$sp();
        Assertions.assertEquals((long)verifyLog$1_highWatermark, (long)var47_43, (String)new StringBuilder(27).append("Unexpected high watermark: ").append(new StringBuilder(67).append("isLeader=").append(sourceReplicaManager.onlinePartition(tp).exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log.logStartOffset()).append(", end=").append(verifyLog$1_log.logEndOffset()).append(", hwm=").append(verifyLog$1_log.highWatermark()).append(") ").append("expected (start=").append(startOffset.elem).append(", end=").append(verifyLog$1_endOffset).append(", hwm=").append(verifyLog$1_highWatermark).append(")").toString()).toString());
        Object var38_21 = null;
        tuple27 = null;
        tuple28 = null;
        tuple29 = null;
        destReplicaManagers.foreach((Function1 & Serializable)replicaManager -> {
            ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$12(this, tp, startOffset, replicaManager);
            return BoxedUnit.UNIT;
        });
        int follower = ((ReplicaManager)((IterableOps)destReplicaManagers.filter((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$13(tp, x$25)))).head()).config().brokerId();
        this.destCluster().serverWithBrokerId(follower).replicaManager().replicaFetcherManager().closeAllFetchers();
        this.bufferedProduceToSource$1(100);
        long x$12 = this.producedRecords().size() - 100;
        ReplicaManager x$13 = this.verifyLog$default$1$1(tp);
        AbstractLog verifyLog$1_log2 = (AbstractLog)x$13.getLog(tp).get();
        int verifyLog$1_endOffset2 = this.producedRecords().size();
        long l7 = 100L;
        long verifyLog$1_computeUntilTrue_waitTime4 = 15000L;
        long verifyLog$1_computeUntilTrue_startTime4 = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l8 = verifyLog$1_log2.logStartOffset();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l8);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$3(startOffset, l8)) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime4 + verifyLog$1_computeUntilTrue_waitTime4) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime4), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var87_52 = null;
        Tuple2 tuple210 = tuple23;
        if (tuple210 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logStartOffset2 = tuple210._1$mcJ$sp();
        Assertions.assertEquals((long)startOffset.elem, (long)var73_55, (String)new StringBuilder(29).append("Unexpected log start offset: ").append(new StringBuilder(67).append("isLeader=").append(x$13.onlinePartition(tp).exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log2.logStartOffset()).append(", end=").append(verifyLog$1_log2.logEndOffset()).append(", hwm=").append(verifyLog$1_log2.highWatermark()).append(") ").append("expected (start=").append(startOffset.elem).append(", end=").append(verifyLog$1_endOffset2).append(", hwm=").append(x$12).append(")").toString()).toString());
        long l9 = 100L;
        long verifyLog$1_computeUntilTrue_waitTime5 = 15000L;
        long verifyLog$1_computeUntilTrue_startTime5 = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l10 = verifyLog$1_log2.logEndOffset();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l10);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$5(verifyLog$1_endOffset2, l10)) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime5 + verifyLog$1_computeUntilTrue_waitTime5) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime5), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var94_59 = null;
        Tuple2 tuple211 = tuple22;
        if (tuple211 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logEndOffset2 = tuple211._1$mcJ$sp();
        Assertions.assertEquals((long)verifyLog$1_endOffset2, (long)var76_62, (String)new StringBuilder(27).append("Unexpected log end offset: ").append(new StringBuilder(67).append("isLeader=").append(x$13.onlinePartition(tp).exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log2.logStartOffset()).append(", end=").append(verifyLog$1_log2.logEndOffset()).append(", hwm=").append(verifyLog$1_log2.highWatermark()).append(") ").append("expected (start=").append(startOffset.elem).append(", end=").append(verifyLog$1_endOffset2).append(", hwm=").append(x$12).append(")").toString()).toString());
        long l11 = 100L;
        long verifyLog$1_computeUntilTrue_waitTime6 = 15000L;
        long verifyLog$1_computeUntilTrue_startTime6 = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l12 = verifyLog$1_log2.highWatermark();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l12);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$7(x$12, l12)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime6 + verifyLog$1_computeUntilTrue_waitTime6) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime6), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var101_66 = null;
        Tuple2 tuple212 = tuple2;
        if (tuple212 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logHighWatermark2 = tuple212._1$mcJ$sp();
        Assertions.assertEquals((long)x$12, (long)var79_69, (String)new StringBuilder(27).append("Unexpected high watermark: ").append(new StringBuilder(67).append("isLeader=").append(x$13.onlinePartition(tp).exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log2.logStartOffset()).append(", end=").append(verifyLog$1_log2.logEndOffset()).append(", hwm=").append(verifyLog$1_log2.highWatermark()).append(") ").append("expected (start=").append(startOffset.elem).append(", end=").append(verifyLog$1_endOffset2).append(", hwm=").append(x$12).append(")").toString()).toString());
        Object var70_47 = null;
        tuple210 = null;
        tuple211 = null;
        tuple212 = null;
        this.destCluster().shutdownBroker(follower);
        this.destCluster().startBroker(follower);
        this.produceToSourceCluster(100);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyLog$1(this.verifyLog$default$1$1(tp), this.verifyLog$default$2$1(), tp, startOffset);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
        this.destCluster().serverWithBrokerId(follower).replicaManager().replicaFetcherManager().closeAllFetchers();
        this.bufferedProduceToSource$1(100);
        startOffset.elem = ((AbstractLog)sourceReplicaManager.getLog(tp).get()).logEndOffset() - 50L;
        sourceReplicaManager.deleteRecords(15000L, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)startOffset.elem))})), (Function1 & Serializable)x$26 -> {
            ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$15(x$26);
            return BoxedUnit.UNIT;
        });
        this.verifyLog$1(sourceReplicaManager, this.verifyLog$default$2$1(), tp, startOffset);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}))));
        startOffset.elem -= 50L;
        long x$14 = startOffset.elem;
        ReplicaManager x$15 = this.verifyLog$default$1$1(tp);
        this.verifyLog$1(x$15, x$14, tp, startOffset);
        startOffset.elem += 50L;
        this.destCluster().shutdownBroker(follower);
        this.destCluster().startBroker(follower);
        this.produceToSourceCluster(100);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyLog$1(this.verifyLog$default$1$1(tp), this.verifyLog$default$2$1(), tp, startOffset);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
        this.destCluster().serverWithBrokerId(follower).replicaManager().replicaFetcherManager().closeAllFetchers();
        this.bufferedProduceToSource$1(100);
        startOffset.elem = ((AbstractLog)sourceReplicaManager.getLog(tp).get()).logEndOffset();
        sourceReplicaManager.deleteRecords(15000L, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)startOffset.elem))})), (Function1 & Serializable)x$27 -> {
            ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$16(x$27);
            return BoxedUnit.UNIT;
        });
        this.verifyLog$1(sourceReplicaManager, this.verifyLog$default$2$1(), tp, startOffset);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$16 = this.linkName();
        Map x$17 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}));
        .colon.colon x$182 = new .colon.colon((Object)this.destCluster().partitionLeader(tp), (List)Nil$.MODULE$);
        Set<String> x$19 = qual$3.alterClusterLink$default$4();
        boolean x$20 = qual$3.alterClusterLink$default$5();
        qual$3.alterClusterLink(x$16, (Map<String, String>)x$17, (scala.collection.immutable.Seq<KafkaBroker>)x$182, x$19, x$20);
        this.verifyLog$1(this.verifyLog$default$1$1(tp), this.verifyLog$default$2$1(), tp, startOffset);
        this.bufferedProduceToSource$1(100);
        long x$21 = startOffset.elem;
        ReplicaManager x$222 = this.verifyLog$default$1$1(tp);
        this.verifyLog$1(x$222, x$21, tp, startOffset);
        this.destCluster().shutdownBroker(follower);
        this.produceToSourceCluster(100);
        this.verifyLog$1(this.verifyLog$default$1$1(tp), this.verifyLog$default$2$1(), tp, startOffset);
        this.destCluster().startBroker(follower);
        this.verifyLog$1(this.destCluster().serverWithBrokerId(follower).replicaManager(), this.verifyLog$default$2$1(), tp, startOffset);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testNoTruncationBelowHighWatermarkWithEmptyLeaderEpochCache(String quorum) {
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        Assumptions.assumeTrue((boolean)this.clusterLinkPrefix().isEmpty());
        this.verifyNoTruncationBelowHighWatermarkWithEmptyLeaderEpochCache();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDeleteAutoCreatedMirrorTopicForFailedLink(String quorum, boolean coordinator) {
        String autoCreatedTopic = "autoCreatedTopic";
        String nonAutoCreatedTopic = "nonAutoCreatedTopic";
        String topicFilter = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(197).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"").append(autoCreatedTopic).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  }\n          |]}\n          |").toString()));
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(this.syncMs(), this.retryMs(), this.consumerGroup(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)topicFilter)})))));
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(autoCreatedTopic, x$2, 2, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        int x$8 = this.numPartitions();
        Properties x$10 = qual$2.createTopic$default$4();
        ListenerName x$11 = qual$2.createTopic$default$5();
        Properties x$12 = qual$2.createTopic$default$6();
        qual$2.createTopic(nonAutoCreatedTopic, x$8, 2, x$10, x$11, x$12);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$15 = this.linkName();
        Map<String, String> x$16 = qual$3.linkTopic$default$4();
        String x$17 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(nonAutoCreatedTopic, (short)2, x$15, x$16, x$17);
        this.waitForAutoMirrorCreation(autoCreatedTopic);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$18 = this.linkName();
        Map x$19 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"999.999.999.999:0000")}));
        scala.collection.immutable.Seq<KafkaBroker> x$21 = qual$4.alterClusterLink$default$3();
        Set<String> x$22 = qual$4.alterClusterLink$default$4();
        qual$4.alterClusterLink(x$18, (Map<String, String>)x$19, x$21, x$22, false);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkFailureTest.$anonfun$testDeleteAutoCreatedMirrorTopicForFailedLink$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"cluster link didn't fail as expected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.destCluster().deleteTopic(this.topic(), true);
        Assertions.assertThrows(TopicDeletionDisabledException.class, () -> this.destCluster().deleteTopic(autoCreatedTopic, false));
        this.destCluster().killAllBrokers();
        ClusterLinkTestHarness qual$5 = this.destCluster();
        boolean x$23 = qual$5.restartDeadBrokers$default$1();
        qual$5.restartDeadBrokers(x$23);
        this.destCluster().updateBootstrapServers();
        this.destCluster().deleteTopic(nonAutoCreatedTopic, true);
        Assertions.assertThrows(TopicDeletionDisabledException.class, () -> this.destCluster().deleteTopic(autoCreatedTopic, false));
    }

    public void verifyFailureAndRecovery(FailureType failureType, Function0<BoxedUnit> startFailure, Function0<BoxedUnit> stopFailure, boolean verifyAvailabilityMetricAfterRecovery) {
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(this.syncMs(), this.retryMs(), this.consumerGroup(), this.setupLinkAndMirrorForFailureTest$default$4()));
        this.produceToSourceCluster(this.numRecords());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, 5L, this.consumerGroup());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        startFailure.apply$mcV$sp();
        this.waitForFailure(this.destAdmin(), failureType, this.waitForFailure$default$3());
        stopFailure.apply$mcV$sp();
        this.waitForRecovery();
        this.produceToSourceCluster(this.numRecords());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, 10L, this.consumerGroup());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyOffsetMigration(this.topic(), 0, 10L, this.consumerGroup(), this.verifyOffsetMigration$default$5());
        if (verifyAvailabilityMetricAfterRecovery) {
            double unavailabilityCount = this.unavailabilityCountMetricValueOnDest(this.linkName(), this.unavailabilityCountMetricValueOnDest$default$2());
            Thread.sleep(5L * this.retryMs());
            Assertions.assertEquals((double)unavailabilityCount, (double)this.unavailabilityCountMetricValueOnDest(this.linkName(), this.unavailabilityCountMetricValueOnDest$default$2()), (double)0.0);
        }
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.topic();
        String x$2 = this.linkName();
        boolean x$4 = qual$1.unlinkTopic$default$3();
        boolean x$5 = qual$1.unlinkTopic$default$5();
        int x$6 = qual$1.unlinkTopic$default$6();
        qual$1.unlinkTopic(x$1, x$2, x$4, false, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.linkName();
        boolean x$8 = qual$2.deleteClusterLink$default$2();
        scala.collection.immutable.Seq<KafkaBroker> x$9 = qual$2.deleteClusterLink$default$3();
        qual$2.deleteClusterLink(x$7, x$8, x$9);
    }

    public boolean verifyFailureAndRecovery$default$4() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void waitForRecovery() {
        void var5_13;
        Tuple2 tuple2;
        void var2_6;
        Tuple2 tuple22;
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            ClusterLinkListing computeUntilTrue_result;
            if ((computeUntilTrue_result = this.linkInfo(this.destAdmin())).available()) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var12_4 = null;
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        ClusterLinkListing link = (ClusterLinkListing)tuple23._1();
        Assertions.assertTrue((boolean)var2_6.available(), (String)"Link not available");
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        Set activePartitionState = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReplicaStatus.MirrorInfo.State[]{ReplicaStatus.MirrorInfo.State.ACTIVE}));
        long l2 = 100L;
        long computeUntilTrue_waitTime2 = 15000L;
        long computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Set computeUntilTrue_result;
            if (ClusterLinkFailureTest.$anonfun$waitForRecovery$4(activePartitionState, computeUntilTrue_result = this.mirrorPartitionStates(this.destAdmin(), this.mirrorPartitionStates$default$2()))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime2) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime2), (long)computeUntilTrue_pause));
        }
        Object var19_11 = null;
        Tuple2 tuple24 = tuple2;
        if (tuple24 == null) {
            throw new MatchError(null);
        }
        Set actualStates = (Set)tuple24._1();
        Assertions.assertEquals((Object)activePartitionState, (Object)var5_13);
        this.waitForLinkCountMetric(this.destinationLinkMode(), "active", this.destCluster());
        Assertions.assertEquals((double)1.0, (double)this.totalKafkaMetricValue((Seq<KafkaBroker>)this.destCluster().aliveServers(), "mirror-topic-count", (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)TopicLinkMirror$.MODULE$.name())}))), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()));
        Assertions.assertEquals((double)this.numPartitions(), (double)this.totalKafkaMetricValue((Seq<KafkaBroker>)this.destCluster().aliveServers(), "mirror-partition-count", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()));
        this.kafkaMetricMaxValue((Seq<KafkaBroker>)this.destCluster().aliveServers(), "broker-failed-link-count", ClusterLinkMetrics$.MODULE$.metricsGroup(), (Option<String>)new Some((Object)this.linkName()), (Map<String, String>)((Map)Map$.MODULE$.empty()), false, this.kafkaMetricMaxValue$default$7());
    }

    private AclBinding aclBinding(ResourceType resourceType, AclPermissionType permissionType) {
        ResourcePattern resource = new ResourcePattern(resourceType, "*", PatternType.LITERAL);
        AccessControlEntry ace = new AccessControlEntry(new StringBuilder(5).append("User:").append(this.linkUserName(this.linkName())).toString(), "*", AclOperation.ALL, permissionType);
        return new AclBinding(resource, ace);
    }

    private void addLinkAcls() {
        this.sourceCluster().addAcls((scala.collection.immutable.Seq<AclBinding>)new .colon.colon((Object)this.aclBinding(ResourceType.TOPIC, AclPermissionType.ALLOW), (List)new .colon.colon((Object)this.aclBinding(ResourceType.CLUSTER, AclPermissionType.ALLOW), (List)new .colon.colon((Object)this.aclBinding(ResourceType.GROUP, AclPermissionType.ALLOW), (List)Nil$.MODULE$))));
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLinkDuringRetry$1(ClusterLinkFailureTest $this) {
        return ((ClusterLinkManager)((KafkaBroker)$this.destCluster().brokers().head()).clusterLinkManager()).linkState($this.linkName()).equals(FailedClusterLink$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$testDeleteLinkDuringRetry$2() {
        return "cluster link didn't fail as expected";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLinkDuringRetry$3(ClusterLinkFailureTest $this, KafkaBroker x$4) {
        return ((ClusterLinkManager)x$4.clusterLinkManager()).getLinkRetryState($this.linkName()).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$testCorruptConfigs$2(ClusterLinkFailureTest $this, Product destConnectionMode$1) {
        $this.destCluster().updateZkLinkConfig($this.linkId(), ClusterLinkConfig$.MODULE$.ConnectionModeProp(), ((ConnectionMode)destConnectionMode$1).name());
    }

    private final void makeConfigUndecodable$1(Properties linkConfigs$1) {
        Properties props = ((KafkaServer)this.destCluster().servers().head()).zkClient().getEntityConfigs(ConfigType$.MODULE$.ClusterLink(), CoreUtils$.MODULE$.toJavaUUID(this.linkId()).toString());
        Properties decodedProps = ((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().configEncoder().decode(props);
        linkConfigs$1.putAll((java.util.Map<?, ?>)decodedProps);
        Properties brokerProps = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        brokerProps.setProperty(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "bad-secret");
        Properties newProps = new SecureLinkConfigEncoder(KafkaConfig$.MODULE$.fromProps(brokerProps)).encode(decodedProps);
        new AdminZkClient(((KafkaServer)this.destCluster().servers().head()).zkClient()).changeClusterLinkConfig(this.linkId(), newProps);
    }

    public static final /* synthetic */ boolean $anonfun$testUndecodableConfigs$2(Tuple2 x$5) {
        Object object = x$5._1();
        String string = ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp();
        return !(object != null ? !object.equals(string) : string != null);
    }

    private final void reconfigureLink$1(Properties linkConfigs$1) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, this.linkName());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((Future<?>)this.destAdmin().describeConfigs(Collections.singleton(resource)).all(), (Class<? extends Throwable>)InvalidConfigurationException.class, (Option<String>)None$.MODULE$);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(linkConfigs$1).asScala().filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testUndecodableConfigs$2(x$5))))));
        this.alterClusterLink(this.linkName(), (Map<String, String>)CollectionConverters$.MODULE$.PropertiesHasAsScala(linkConfigs$1).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeWithoutConfigs$1(ClusterLinkFailureTest $this) {
        return ((ClusterLinkManager)((KafkaBroker)$this.destCluster().brokers().head()).clusterLinkManager()).linkState($this.linkName()).equals(FailedClusterLink$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$testListDescribeWithoutConfigs$2() {
        return "cluster link didn't fail as expected";
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeWithoutConfigs$3(ClusterLinkFailureTest $this, ClusterLinkDescription x$6) {
        return x$6.linkName().equals($this.linkName());
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeWithoutConfigs$4(ClusterLinkDescription x$7) {
        return x$7.linkState().equals((Object)ClusterLinkDescription.LinkState.FAILED);
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeWithoutConfigs$5(ClusterLinkDescription x$8) {
        return x$8.linkName().equals("test-link2");
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeWithoutConfigs$6(ClusterLinkDescription x$9) {
        return x$9.linkState().equals((Object)ClusterLinkDescription.LinkState.ACTIVE);
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeWithoutConfigs$7(ClusterLinkFailureTest $this, ClusterLinkDescription x$10) {
        return x$10.linkName().equals($this.linkName());
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeWithoutConfigs$8(ClusterLinkDescription x$11) {
        return x$11.clusterLinkError().equals((Object)ClusterLinkError.UNKNOWN);
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeWithoutConfigs$9(ClusterLinkDescription x$12) {
        return x$12.linkName().equals("test-link2");
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeWithoutConfigs$10(ClusterLinkDescription x$13) {
        return x$13.clusterLinkError().equals((Object)ClusterLinkError.NO_ERROR);
    }

    public static final /* synthetic */ boolean $anonfun$testSourceTopicRecreateDetectionUsingTopicIds$1(ClusterLinkFailureTest $this, TopicPartition tp$1) {
        return $this.destCluster().leaderEpoch(tp$1) > 0;
    }

    public static final /* synthetic */ String $anonfun$testSourceTopicRecreateDetectionUsingTopicIds$2() {
        return "Destination epoch not bumped";
    }

    public static final /* synthetic */ boolean $anonfun$testDestLeaderChanges$1(ClusterLinkFailureTest $this, int leader1$1, KafkaBroker x$14) {
        KafkaBroker kafkaBroker = x$14;
        KafkaBroker kafkaBroker2 = $this.destCluster().serverWithBrokerId(leader1$1);
        return kafkaBroker == null ? kafkaBroker2 != null : !kafkaBroker.equals(kafkaBroker2);
    }

    public static final /* synthetic */ boolean $anonfun$testDestLeaderChanges$2(ClusterLinkFailureTest $this, int leader2$1, KafkaBroker x$15) {
        KafkaBroker kafkaBroker = x$15;
        KafkaBroker kafkaBroker2 = $this.destCluster().serverWithBrokerId(leader2$1);
        return kafkaBroker == null ? kafkaBroker2 != null : !kafkaBroker.equals(kafkaBroker2);
    }

    private static final String logDesc$1(ReplicaManager replicaManager$1, TopicPartition tp$3, AbstractLog log$1, LongRef startOffset$1, int endOffset$1, long highWatermark$1) {
        return new StringBuilder(67).append("isLeader=").append(replicaManager$1.onlinePartition(tp$3).exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isLeader()))).append(" ").append("actual (start=").append(log$1.logStartOffset()).append(", end=").append(log$1.logEndOffset()).append(", hwm=").append(log$1.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(endOffset$1).append(", hwm=").append(highWatermark$1).append(")").toString();
    }

    public static final /* synthetic */ long $anonfun$testDestinationHighWatermark$2(AbstractLog log$1) {
        return log$1.logStartOffset();
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$3(LongRef startOffset$1, long x$19) {
        return x$19 == startOffset$1.elem;
    }

    public static final /* synthetic */ long $anonfun$testDestinationHighWatermark$4(AbstractLog log$1) {
        return log$1.logEndOffset();
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$5(int endOffset$1, long x$20) {
        return x$20 == (long)endOffset$1;
    }

    public static final /* synthetic */ long $anonfun$testDestinationHighWatermark$6(AbstractLog log$1) {
        return log$1.highWatermark();
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$7(long highWatermark$1, long x$21) {
        return x$21 == highWatermark$1;
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyLog$1(ReplicaManager replicaManager, long highWatermark, TopicPartition tp$3, LongRef startOffset$1) {
        void var15_27;
        Tuple2 tuple2;
        void var12_20;
        Tuple2 tuple22;
        void var9_13;
        Tuple2 tuple23;
        AbstractLog log = (AbstractLog)replicaManager.getLog(tp$3).get();
        int endOffset = this.producedRecords().size();
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l2 = log.logStartOffset();
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l2);
            if (l2 == startOffset$1.elem) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var23_11 = null;
        Tuple2 tuple24 = tuple23;
        if (tuple24 == null) {
            throw new MatchError(null);
        }
        long logStartOffset = tuple24._1$mcJ$sp();
        Assertions.assertEquals((long)startOffset$1.elem, (long)var9_13, (String)new StringBuilder(29).append("Unexpected log start offset: ").append(new StringBuilder(67).append("isLeader=").append(replicaManager.onlinePartition(tp$3).exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isLeader()))).append(" ").append("actual (start=").append(log.logStartOffset()).append(", end=").append(log.logEndOffset()).append(", hwm=").append(log.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(endOffset).append(", hwm=").append(highWatermark).append(")").toString()).toString());
        long l3 = 100L;
        long computeUntilTrue_waitTime2 = 15000L;
        long computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l4 = log.logEndOffset();
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l4);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$5(endOffset, l4)) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime2) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime2), (long)computeUntilTrue_pause));
        }
        Object var30_18 = null;
        Tuple2 tuple25 = tuple22;
        if (tuple25 == null) {
            throw new MatchError(null);
        }
        long logEndOffset = tuple25._1$mcJ$sp();
        Assertions.assertEquals((long)endOffset, (long)var12_20, (String)new StringBuilder(27).append("Unexpected log end offset: ").append(new StringBuilder(67).append("isLeader=").append(replicaManager.onlinePartition(tp$3).exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isLeader()))).append(" ").append("actual (start=").append(log.logStartOffset()).append(", end=").append(log.logEndOffset()).append(", hwm=").append(log.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(endOffset).append(", hwm=").append(highWatermark).append(")").toString()).toString());
        long l5 = 100L;
        long computeUntilTrue_waitTime3 = 15000L;
        long computeUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            long l6 = log.highWatermark();
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l6);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$7(highWatermark, l6)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime3 + computeUntilTrue_waitTime3) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime3), (long)computeUntilTrue_pause));
        }
        Object var37_24 = null;
        Tuple2 tuple26 = tuple2;
        if (tuple26 == null) {
            throw new MatchError(null);
        }
        long logHighWatermark = tuple26._1$mcJ$sp();
        Assertions.assertEquals((long)highWatermark, (long)var15_27, (String)new StringBuilder(27).append("Unexpected high watermark: ").append(new StringBuilder(67).append("isLeader=").append(replicaManager.onlinePartition(tp$3).exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isLeader()))).append(" ").append("actual (start=").append(log.logStartOffset()).append(", end=").append(log.logEndOffset()).append(", hwm=").append(log.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(endOffset).append(", hwm=").append(highWatermark).append(")").toString()).toString());
    }

    private final ReplicaManager verifyLog$default$1$1(TopicPartition tp$3) {
        return this.destCluster().partitionLeader(tp$3).replicaManager();
    }

    private final long verifyLog$default$2$1() {
        return this.producedRecords().size();
    }

    private final void bufferedProduceToSource$1(int numRecords) {
        this.sourceCluster().producerConfig().setProperty("linger.ms", "100");
        this.produceToSourceCluster(numRecords);
        this.sourceCluster().producerConfig().remove("linger.ms");
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$9(TopicPartition tp$3, ReplicaManager x$23) {
        return x$23.getLog(tp$3).nonEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDestinationHighWatermark$10(ClusterLinkFailureTest $this, TopicPartition tp$3, LongRef startOffset$1, ReplicaManager replicaManager) {
        void var15_27;
        Tuple2 tuple2;
        void var12_20;
        Tuple2 tuple22;
        void var9_13;
        Tuple2 tuple23;
        long verifyLog$1_highWatermark = $this.verifyLog$default$2$1();
        AbstractLog verifyLog$1_log = (AbstractLog)replicaManager.getLog(tp$3).get();
        int verifyLog$1_endOffset = $this.producedRecords().size();
        long l = 100L;
        long verifyLog$1_computeUntilTrue_waitTime = 15000L;
        long verifyLog$1_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l2 = verifyLog$1_log.logStartOffset();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l2);
            if (l2 == startOffset$1.elem) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime + verifyLog$1_computeUntilTrue_waitTime) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var23_11 = null;
        Tuple2 tuple24 = tuple23;
        if (tuple24 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logStartOffset = tuple24._1$mcJ$sp();
        Assertions.assertEquals((long)startOffset$1.elem, (long)var9_13, (String)new StringBuilder(29).append("Unexpected log start offset: ").append(new StringBuilder(67).append("isLeader=").append(replicaManager.onlinePartition(tp$3).exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log.logStartOffset()).append(", end=").append(verifyLog$1_log.logEndOffset()).append(", hwm=").append(verifyLog$1_log.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(verifyLog$1_endOffset).append(", hwm=").append(verifyLog$1_highWatermark).append(")").toString()).toString());
        long l3 = 100L;
        long verifyLog$1_computeUntilTrue_waitTime2 = 15000L;
        long verifyLog$1_computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l4 = verifyLog$1_log.logEndOffset();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l4);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$5(verifyLog$1_endOffset, l4)) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime2 + verifyLog$1_computeUntilTrue_waitTime2) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime2), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var30_18 = null;
        Tuple2 tuple25 = tuple22;
        if (tuple25 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logEndOffset = tuple25._1$mcJ$sp();
        Assertions.assertEquals((long)verifyLog$1_endOffset, (long)var12_20, (String)new StringBuilder(27).append("Unexpected log end offset: ").append(new StringBuilder(67).append("isLeader=").append(replicaManager.onlinePartition(tp$3).exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log.logStartOffset()).append(", end=").append(verifyLog$1_log.logEndOffset()).append(", hwm=").append(verifyLog$1_log.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(verifyLog$1_endOffset).append(", hwm=").append(verifyLog$1_highWatermark).append(")").toString()).toString());
        long l5 = 100L;
        long verifyLog$1_computeUntilTrue_waitTime3 = 15000L;
        long verifyLog$1_computeUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l6 = verifyLog$1_log.highWatermark();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l6);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$7(verifyLog$1_highWatermark, l6)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime3 + verifyLog$1_computeUntilTrue_waitTime3) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime3), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var37_24 = null;
        Tuple2 tuple26 = tuple2;
        if (tuple26 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logHighWatermark = tuple26._1$mcJ$sp();
        Assertions.assertEquals((long)verifyLog$1_highWatermark, (long)var15_27, (String)new StringBuilder(27).append("Unexpected high watermark: ").append(new StringBuilder(67).append("isLeader=").append(replicaManager.onlinePartition(tp$3).exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log.logStartOffset()).append(", end=").append(verifyLog$1_log.logEndOffset()).append(", hwm=").append(verifyLog$1_log.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(verifyLog$1_endOffset).append(", hwm=").append(verifyLog$1_highWatermark).append(")").toString()).toString());
    }

    public static final /* synthetic */ void $anonfun$testDestinationHighWatermark$11(Map x$24) {
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDestinationHighWatermark$12(ClusterLinkFailureTest $this, TopicPartition tp$3, LongRef startOffset$1, ReplicaManager replicaManager) {
        void var15_27;
        Tuple2 tuple2;
        void var12_20;
        Tuple2 tuple22;
        void var9_13;
        Tuple2 tuple23;
        long verifyLog$1_highWatermark = $this.verifyLog$default$2$1();
        AbstractLog verifyLog$1_log = (AbstractLog)replicaManager.getLog(tp$3).get();
        int verifyLog$1_endOffset = $this.producedRecords().size();
        long l = 100L;
        long verifyLog$1_computeUntilTrue_waitTime = 15000L;
        long verifyLog$1_computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l2 = verifyLog$1_log.logStartOffset();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l2);
            if (l2 == startOffset$1.elem) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime + verifyLog$1_computeUntilTrue_waitTime) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var23_11 = null;
        Tuple2 tuple24 = tuple23;
        if (tuple24 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logStartOffset = tuple24._1$mcJ$sp();
        Assertions.assertEquals((long)startOffset$1.elem, (long)var9_13, (String)new StringBuilder(29).append("Unexpected log start offset: ").append(new StringBuilder(67).append("isLeader=").append(replicaManager.onlinePartition(tp$3).exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log.logStartOffset()).append(", end=").append(verifyLog$1_log.logEndOffset()).append(", hwm=").append(verifyLog$1_log.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(verifyLog$1_endOffset).append(", hwm=").append(verifyLog$1_highWatermark).append(")").toString()).toString());
        long l3 = 100L;
        long verifyLog$1_computeUntilTrue_waitTime2 = 15000L;
        long verifyLog$1_computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l4 = verifyLog$1_log.logEndOffset();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l4);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$5(verifyLog$1_endOffset, l4)) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime2 + verifyLog$1_computeUntilTrue_waitTime2) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime2), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var30_18 = null;
        Tuple2 tuple25 = tuple22;
        if (tuple25 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logEndOffset = tuple25._1$mcJ$sp();
        Assertions.assertEquals((long)verifyLog$1_endOffset, (long)var12_20, (String)new StringBuilder(27).append("Unexpected log end offset: ").append(new StringBuilder(67).append("isLeader=").append(replicaManager.onlinePartition(tp$3).exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log.logStartOffset()).append(", end=").append(verifyLog$1_log.logEndOffset()).append(", hwm=").append(verifyLog$1_log.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(verifyLog$1_endOffset).append(", hwm=").append(verifyLog$1_highWatermark).append(")").toString()).toString());
        long l5 = 100L;
        long verifyLog$1_computeUntilTrue_waitTime3 = 15000L;
        long verifyLog$1_computeUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void verifyLog$1_computeUntilTrue_pause;
            long l6 = verifyLog$1_log.highWatermark();
            Long verifyLog$1_computeUntilTrue_result = BoxesRunTime.boxToLong((long)l6);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$7(verifyLog$1_highWatermark, l6)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > verifyLog$1_computeUntilTrue_startTime3 + verifyLog$1_computeUntilTrue_waitTime3) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verifyLog$1_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyLog$1_computeUntilTrue_waitTime3), (long)verifyLog$1_computeUntilTrue_pause));
        }
        Object var37_24 = null;
        Tuple2 tuple26 = tuple2;
        if (tuple26 == null) {
            throw new MatchError(null);
        }
        long verifyLog$1_logHighWatermark = tuple26._1$mcJ$sp();
        Assertions.assertEquals((long)verifyLog$1_highWatermark, (long)var15_27, (String)new StringBuilder(27).append("Unexpected high watermark: ").append(new StringBuilder(67).append("isLeader=").append(replicaManager.onlinePartition(tp$3).exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isLeader()))).append(" ").append("actual (start=").append(verifyLog$1_log.logStartOffset()).append(", end=").append(verifyLog$1_log.logEndOffset()).append(", hwm=").append(verifyLog$1_log.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(verifyLog$1_endOffset).append(", hwm=").append(verifyLog$1_highWatermark).append(")").toString()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$14(Partition p) {
        return !p.isLeader();
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$13(TopicPartition tp$3, ReplicaManager x$25) {
        return x$25.onlinePartition(tp$3).exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$14(p)));
    }

    public static final /* synthetic */ void $anonfun$testDestinationHighWatermark$15(Map x$26) {
    }

    public static final /* synthetic */ void $anonfun$testDestinationHighWatermark$16(Map x$27) {
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteAutoCreatedMirrorTopicForFailedLink$1(ClusterLinkFailureTest $this) {
        return ((ClusterLinkManager)((KafkaBroker)$this.destCluster().brokers().head()).clusterLinkManager()).linkState($this.linkName()).equals(FailedClusterLink$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$testDeleteAutoCreatedMirrorTopicForFailedLink$2() {
        return "cluster link didn't fail as expected";
    }

    public static final /* synthetic */ boolean $anonfun$waitForRecovery$4(Set activePartitionState$1, Set x$29) {
        Set set = x$29;
        return !(set != null ? !set.equals(activePartitionState$1) : activePartitionState$1 != null);
    }

    public ClusterLinkFailureTest() {
        this.consumerGroup = "testGroup";
        this.syncMs = 100L;
        this.retryMs = 1000L;
        this.numRecords = 20;
    }

    public static final /* synthetic */ Object $anonfun$testMirrorTopicOperationsOnLinkFailure$3$adapted(ClusterLinkListing x$3) {
        return BoxesRunTime.boxToBoolean((boolean)x$3.available());
    }

    public static final /* synthetic */ Object $anonfun$testDestLeaderChanges$1$adapted(ClusterLinkFailureTest $this, int leader1$1, KafkaBroker x$14) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDestLeaderChanges$1($this, leader1$1, x$14));
    }

    public static final /* synthetic */ Object $anonfun$testDestLeaderChanges$2$adapted(ClusterLinkFailureTest $this, int leader2$1, KafkaBroker x$15) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDestLeaderChanges$2($this, leader2$1, x$15));
    }

    public static final /* synthetic */ Object $anonfun$waitForRecovery$2$adapted(ClusterLinkListing x$28) {
        return BoxesRunTime.boxToBoolean((boolean)x$28.available());
    }

    public static final /* synthetic */ Object $anonfun$waitForRecovery$4$adapted(Set activePartitionState$1, Set x$29) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$waitForRecovery$4(activePartitionState$1, x$29));
    }
}

