/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.lang.reflect.Method;
import java.util.Properties;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.utils.TestInfoUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005]d\u0001B\r\u001b\u0001}AQ\u0001\n\u0001\u0005\u0002\u0015B\u0011b\n\u0001A\u0002\u0003\u0007I\u0011\u0002\u0015\t\u0013U\u0002\u0001\u0019!a\u0001\n\u00131\u0004\"C \u0001\u0001\u0004\u0005\t\u0015)\u0003*\u0011%\u0001\u0005\u00011AA\u0002\u0013%\u0011\tC\u0005F\u0001\u0001\u0007\t\u0019!C\u0005\r\"I\u0001\n\u0001a\u0001\u0002\u0003\u0006KA\u0011\u0005\n\u0013\u0002\u0001\r\u00111A\u0005\n\u0005C\u0011B\u0013\u0001A\u0002\u0003\u0007I\u0011B&\t\u00135\u0003\u0001\u0019!A!B\u0013\u0011\u0005\"\u0002(\u0001\t\u0003z\u0005\"\u0002,\u0001\t\u00139\u0006\"\u0002/\u0001\t\u0003i\u0006\"\u00022\u0001\t\u0003i\u0006\"\u00023\u0001\t\u0003)\u0007bBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\u0007\u0003G\u0001A\u0011A/\t\r\u0005\u001d\u0002\u0001\"\u0001^\u0011\u0019\tY\u0003\u0001C\u0001;\"1\u0011q\u0006\u0001\u0005\u0002uCa!a\r\u0001\t\u0013i\u0006bBA\u001b\u0001\u0011%\u0011q\u0007\u0005\b\u0003k\u0001A\u0011BA\"\u0011\u001d\tY\u0005\u0001C\u0005\u0003\u001b\u0012a\u0004T5oW\u000e{wN\u001d3j]\u0006$xN]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005ma\u0012\u0001\u00027j].T\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0005\u0005\u0002\"E5\t!$\u0003\u0002$5\t\u0011\u0013IY:ue\u0006\u001cGo\u00117vgR,'\u000fT5oW&sG/Z4sCRLwN\u001c+fgR\fa\u0001P5oSRtD#\u0001\u0014\u0011\u0005\u0005\u0002\u0011!C0uKN$\u0018J\u001c4p+\u0005I\u0003C\u0001\u00164\u001b\u0005Y#B\u0001\u0017.\u0003\r\t\u0007/\u001b\u0006\u0003]=\nqA[;qSR,'O\u0003\u00021c\u0005)!.\u001e8ji*\t!'A\u0002pe\u001eL!\u0001N\u0016\u0003\u0011Q+7\u000f^%oM>\fQb\u0018;fgRLeNZ8`I\u0015\fHCA\u001c>!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u0011)f.\u001b;\t\u000fy\u001a\u0011\u0011!a\u0001S\u0005\u0019\u0001\u0010J\u0019\u0002\u0015}#Xm\u001d;J]\u001a|\u0007%A\rf]\u0006\u0014G.Z*pkJ\u001cW-T3uC\u0012\fG/\u0019+pa&\u001cW#\u0001\"\u0011\u0005a\u001a\u0015B\u0001#:\u0005\u001d\u0011un\u001c7fC:\fQ$\u001a8bE2,7k\\;sG\u0016lU\r^1eCR\fGk\u001c9jG~#S-\u001d\u000b\u0003o\u001dCqA\u0010\u0004\u0002\u0002\u0003\u0007!)\u0001\u000ef]\u0006\u0014G.Z*pkJ\u001cW-T3uC\u0012\fG/\u0019+pa&\u001c\u0007%A\ff]\u0006\u0014G.\u001a#fgRlU\r^1eCR\fGk\u001c9jG\u0006YRM\\1cY\u0016$Um\u001d;NKR\fG-\u0019;b)>\u0004\u0018nY0%KF$\"a\u000e'\t\u000fyJ\u0011\u0011!a\u0001\u0005\u0006ARM\\1cY\u0016$Um\u001d;NKR\fG-\u0019;b)>\u0004\u0018n\u0019\u0011\u0002\u000bM,G/\u00169\u0015\u0005]\u0002\u0006\"B)\f\u0001\u0004I\u0013\u0001\u0003;fgRLeNZ8)\u0005-\u0019\u0006C\u0001\u0016U\u0013\t)6F\u0001\u0006CK\u001a|'/Z#bG\"\fQb]3ukB\u001cE.^:uKJ\u001cH\u0003B\u001cY5nCQ!\u0017\u0007A\u0002\t\u000bqb]8ve\u000e,\u0017J\\5uS\u0006$X\r\u001a\u0005\u0006\u00012\u0001\rA\u0011\u0005\u0006\u00132\u0001\rAQ\u0001(i\u0016\u001cH\u000fR3ti&s\u0017\u000e^5bi\u0016$7i\u001c8ue>dG.\u001a:U_\u000e{g\u000e\u001e:pY2,'\u000fF\u00018Q\tiq\f\u0005\u0002+A&\u0011\u0011m\u000b\u0002\u0005)\u0016\u001cH/A\u0015uKN$8k\\;sG\u0016Le.\u001b;jCR,GmQ8oiJ|G\u000e\\3s)>\u001cuN\u001c;s_2dWM\u001d\u0015\u0003\u001d}\u000bQ\u0005^3ti\u0012+7\u000f^%oSRL\u0017\r^3e\u0019&t7nQ8pe\u0012$v\u000eT5oW\u000e{wN\u001d3\u0015\u0007]27\u000fC\u0003h\u001f\u0001\u0007\u0001.\u0001\u0004rk>\u0014X/\u001c\t\u0003SBt!A\u001b8\u0011\u0005-LT\"\u00017\u000b\u00055t\u0012A\u0002\u001fs_>$h(\u0003\u0002ps\u00051\u0001K]3eK\u001aL!!\u001d:\u0003\rM#(/\u001b8h\u0015\ty\u0017\bC\u0003u\u001f\u0001\u0007!)A\u0006d_>\u0014H-\u001b8bi>\u0014\b\u0006B\bw}~\u0004\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\u0011A\u0014xN^5eKJT!a_\u0017\u0002\rA\f'/Y7t\u0013\ti\bP\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\r\f\u0002\u0002\u0002\u0005\u0012\u00111A\u0001\u0010C2d7i\\7cS:\fG/[8og\":q\"a\u0002\u0002\u0010\u0005E\u0001\u0003BA\u0005\u0003\u0017i\u0011A_\u0005\u0004\u0003\u001bQ(!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\t\t\u0019\"\u0001\u0015|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018rk>\u0014X/\\\u001f|aut3m\\8sI&t\u0017\r^8s{m\fT0A\u0014uKN$8k\\;sG\u0016Le.\u001b;jCR,G\rT5oW\u000e{wN\u001d3U_2Kgn[\"p_J$G#B\u001c\u0002\u001a\u0005m\u0001\"B4\u0011\u0001\u0004A\u0007\"\u0002;\u0011\u0001\u0004\u0011\u0005&\u0002\tw}\u0006}AFAA\u0001Q\u001d\u0001\u0012qAA\b\u0003#\ta\u0005^3ti\u0012+7\u000f^%oSRL\u0017\r^3e\u0007>tGO]8mY\u0016\u0014Hk\u001c'j].\u001cun\u001c:eQ\t\tr,\u0001\u0015uKN$8k\\;sG\u0016Le.\u001b;jCR,GmQ8oiJ|G\u000e\\3s)>d\u0015N\\6D_>\u0014H\r\u000b\u0002\u0013?\u00061C/Z:u\t\u0016\u001cH/\u00138ji&\fG/\u001a3MS:\\7i\\8sIR{7i\u001c8ue>dG.\u001a:)\u0005My\u0016\u0001\u000b;fgR\u001cv.\u001e:dK&s\u0017\u000e^5bi\u0016$G*\u001b8l\u0007>|'\u000f\u001a+p\u0007>tGO]8mY\u0016\u0014\bF\u0001\u000b`\u0003]1XM]5gs\u000e{wN\u001d3j]\u0006$xN]\"iC:<W-A\tdQ\u0006tw-Z\"p_J$\u0017N\\1u_J$2aNA\u001d\u0011\u001d\tYD\u0006a\u0001\u0003{\tqa\u00197vgR,'\u000fE\u0002\"\u0003\u007fI1!!\u0011\u001b\u0005Y\u0019E.^:uKJd\u0015N\\6UKN$\b*\u0019:oKN\u001cH#B\u001c\u0002F\u0005\u001d\u0003bBA\u001e/\u0001\u0007\u0011Q\b\u0005\u0007\u0003\u0013:\u0002\u0019\u0001\"\u0002'\u0015t\u0017M\u00197f\u001b\u0016$\u0018\rZ1uCR{\u0007/[2\u0002;1Lgn\u001b(b[\u0016$v.T3uC\u0012\fG/\u0019)beRLG/[8o\u0013\u0012$b!a\u0014\u0002V\u0005e\u0003c\u0001\u001d\u0002R%\u0019\u00111K\u001d\u0003\u0007%sG\u000f\u0003\u0004\u0002Xa\u0001\r\u0001[\u0001\tY&t7NT1nK\"9\u00111\f\rA\u0002\u0005u\u0013aD7fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0011\t\u0005}\u0013qM\u0007\u0003\u0003CR1aGA2\u0015\r\t)\u0007H\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005%\u0014\u0011\r\u0002\u001b\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y'b]\u0006<WM\u001d\u0015\u0007\u0001\u00055d0a\u001d\u0011\u0007)\ny'C\u0002\u0002r-\u00121\u0001V1hC\t\t)(A\u0006j]R,wM]1uS>t\u0007")
public class LinkCoordinatorIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    private TestInfo _testInfo;
    private boolean enableSourceMetadataTopic;
    private boolean enableDestMetadataTopic;

    private TestInfo _testInfo() {
        return this._testInfo;
    }

    private void _testInfo_$eq(TestInfo x$1) {
        this._testInfo = x$1;
    }

    private boolean enableSourceMetadataTopic() {
        return this.enableSourceMetadataTopic;
    }

    private void enableSourceMetadataTopic_$eq(boolean x$1) {
        this.enableSourceMetadataTopic = x$1;
    }

    private boolean enableDestMetadataTopic() {
        return this.enableDestMetadataTopic;
    }

    private void enableDestMetadataTopic_$eq(boolean x$1) {
        this.enableDestMetadataTopic = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo_$eq(testInfo);
    }

    private void setupClusters(boolean sourceInitiated, boolean enableSourceMetadataTopic, boolean enableDestMetadataTopic) {
        if (TestInfoUtils$.MODULE$.isKRaft(this._testInfo()) && this.sourceCluster() == null && this.destCluster() == null) {
            None$ x$4 = None$.MODULE$;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.PLAINTEXT, (Option<SecurityProtocol>)x$4, 0, 3));
            None$ x$8 = None$.MODULE$;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.PLAINTEXT, (Option<SecurityProtocol>)x$8, 100, 3));
        } else if (this.sourceCluster() == null && this.destCluster() == null) {
            None$ x$12 = None$.MODULE$;
            this.sourceCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_SSL, (Option<SecurityProtocol>)x$12, 0, 3));
            None$ x$16 = None$.MODULE$;
            this.destCluster_$eq(new ClusterLinkTestHarness(SecurityProtocol.SASL_PLAINTEXT, (Option<SecurityProtocol>)x$16, 100, 3));
        }
        this.useSourceInitiatedLink_$eq(sourceInitiated);
        this.enableSourceMetadataTopic_$eq(enableSourceMetadataTopic);
        this.enableDestMetadataTopic_$eq(enableDestMetadataTopic);
        if (enableSourceMetadataTopic) {
            this.sourceCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.enable", "true");
            this.sourceCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.partitions", "1");
            this.sourceCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.replication.factor", "2");
        }
        if (enableDestMetadataTopic) {
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.enable", "true");
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.partitions", "1");
            this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.replication.factor", "2");
        }
        super.setUp(this._testInfo());
    }

    @Test
    public void testDestInitiatedControllerToController() {
        this.setupClusters(false, false, false);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testSourceInitiatedControllerToController() {
        this.setupClusters(true, false, false);
        this.verifyCoordinatorChange();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testDestInitiatedLinkCoordToLinkCoord(String quorum, boolean coordinator) {
        this.setupClusters(false, true, true);
        this.verifyCoordinatorChange();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testSourceInitiatedLinkCoordToLinkCoord(String quorum, boolean coordinator) {
        this.setupClusters(true, true, true);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testDestInitiatedControllerToLinkCoord() {
        this.setupClusters(false, false, true);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testSourceInitiatedControllerToLinkCoord() {
        this.setupClusters(true, false, true);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testDestInitiatedLinkCoordToController() {
        this.setupClusters(false, true, false);
        this.verifyCoordinatorChange();
    }

    @Test
    public void testSourceInitiatedLinkCoordToController() {
        this.setupClusters(true, true, false);
        this.verifyCoordinatorChange();
    }

    private void verifyCoordinatorChange() {
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4(), this.createClusterLink$default$5());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        Properties x$6 = qual$1.createTopic$default$6();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5, x$6);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = this.replicationFactor();
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        String x$11 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.changeCoordinator(this.destCluster());
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.changeCoordinator(this.sourceCluster());
        this.produceToSourceCluster(10);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3(), this.verifyMirror$default$4());
    }

    private void changeCoordinator(ClusterLinkTestHarness cluster) {
        if (cluster == this.sourceCluster()) {
            this.changeCoordinator(this.sourceCluster(), this.enableSourceMetadataTopic());
            return;
        }
        if (cluster == this.destCluster()) {
            this.changeCoordinator(this.destCluster(), this.enableDestMetadataTopic());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void changeCoordinator(ClusterLinkTestHarness cluster, boolean enableMetadataTopic) {
        if (enableMetadataTopic) {
            String metadataTopic = "_confluent-link-metadata";
            KafkaBroker linkCoordinator = cluster.linkCoordinator(this.linkName());
            int partition = this.linkNameToMetadataPartitionId(this.linkName(), LinkCoordinatorIntegrationTest.metadataManager$1(linkCoordinator));
            int newLeader = cluster.changeLeader(new TopicPartition(metadataTopic, partition));
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!LinkCoordinatorIntegrationTest.$anonfun$changeCoordinator$1(this, cluster, newLeader)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"New link coordinator not elected");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            return;
        }
        cluster.changeController();
    }

    private int linkNameToMetadataPartitionId(String linkName, ClusterLinkMetadataManager metadataManager) {
        Method method = metadataManager.getClass().getSuperclass().getDeclaredMethod("linkNameToPartitionId", String.class);
        method.setAccessible(true);
        return BoxesRunTime.unboxToInt((Object)method.invoke((Object)metadataManager, linkName));
    }

    private static final ClusterLinkMetadataManager metadataManager$1(KafkaBroker server) {
        return ((ClusterLinkManager)server.clusterLinkManager()).metadataManager();
    }

    public static final /* synthetic */ boolean $anonfun$changeCoordinator$1(LinkCoordinatorIntegrationTest $this, ClusterLinkTestHarness cluster$1, int newLeader$1) {
        return LinkCoordinatorIntegrationTest.metadataManager$1(cluster$1.brokerWithId(newLeader$1)).isLinkCoordinator($this.linkName());
    }

    public static final /* synthetic */ String $anonfun$changeCoordinator$2() {
        return "New link coordinator not elected";
    }
}

