/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kafka.log.AbstractLog;
import kafka.log.LogConcurrencyTest$FetchedBatch$;
import kafka.log.LogSegment;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\tue\u0001\u0002\u001d:\u0001yBQ!\u0012\u0001\u0005\u0002\u0019Cq!\u0013\u0001C\u0002\u0013%!\n\u0003\u0004R\u0001\u0001\u0006Ia\u0013\u0005\b%\u0002\u0011\r\u0011\"\u0003T\u0011\u0019Q\u0006\u0001)A\u0005)\"91\f\u0001b\u0001\n\u0013a\u0006B\u00025\u0001A\u0003%Q\fC\u0004j\u0001\t\u0007I\u0011\u00026\t\rM\u0004\u0001\u0015!\u0003l\u0011\u001d!\bA1A\u0005\n)Da!\u001e\u0001!\u0002\u0013Y\u0007\"\u0002<\u0001\t\u00039\bBBA\u0007\u0001\u0011\u0005q\u000f\u0003\u0004\u0002\u0018\u0001!\ta\u001e\u0005\u0007\u0003C\u0001A\u0011A<\t\u000f\u0005]\u0001\u0001\"\u0001\u0002&\u00191\u0011q\u0006\u0001\u0005\u0003cA\u0011BO\t\u0003\u0002\u0003\u0006I!!\u000b\t\u0015\u00055\u0013C!A!\u0002\u0013\ty\u0005\u0003\u0004F#\u0011\u0005\u0011Q\u000b\u0005\n\u0003?\n\"\u0019!C\u0001\u0003CB\u0001B!\u000b\u0012A\u0003%\u00111\r\u0005\u0007\u0005W\tB\u0011I<\u0007\r\t5\u0002\u0001\u0002B\u0018\u0011%Q\u0004D!A!\u0002\u0013\tI\u0003\u0003\u0006\u0002Na\u0011\t\u0011)A\u0005\u00037Ca!\u0012\r\u0005\u0002\tE\u0002B\u0002B\u00161\u0011\u0005s\u000fC\u0004\u0003:\u0001!IAa\u000f\t\u0013\tM\u0003!%A\u0005\n\tU\u0003b\u0002B-\u0001\u0011%!1\f\u0004\u0007\u0003k\u0002A)a\u001e\t\u0015\u0005]\u0005E!f\u0001\n\u0003\tI\n\u0003\u0006\u0002\"\u0002\u0012\t\u0012)A\u0005\u00037C!\"a)!\u0005+\u0007I\u0011AAS\u0011)\t9\u000b\tB\tB\u0003%\u0011q\n\u0005\u0007\u000b\u0002\"\t!!+\t\u000f\u0005=\u0006\u0005\"\u0011\u00022\"I\u00111\u0019\u0011\u0002\u0002\u0013\u0005\u0011Q\u0019\u0005\n\u0003\u0017\u0004\u0013\u0013!C\u0001\u0003\u001bD\u0011\"a9!#\u0003%\t!!:\t\u0013\u0005%\b%!A\u0005B\u0005-\b\"CAyA\u0005\u0005I\u0011AAS\u0011%\t\u0019\u0010IA\u0001\n\u0003\t)\u0010C\u0005\u0003\u0002\u0001\n\t\u0011\"\u0011\u0003\u0004!I!Q\u0002\u0011\u0002\u0002\u0013\u0005!q\u0002\u0005\n\u00053\u0001\u0013\u0011!C!\u00057A\u0011Ba\b!\u0003\u0003%\tE!\t\t\u0013\t\r\u0002%!A\u0005B\t\u0015r!\u0003B4\u0001\u0005\u0005\t\u0012\u0002B5\r%\t)\bAA\u0001\u0012\u0013\u0011Y\u0007\u0003\u0004Fg\u0011\u0005!Q\u0010\u0005\n\u0003_\u001b\u0014\u0011!C#\u0005\u007fB\u0011B!!4\u0003\u0003%\tIa!\t\u0013\t%5'!A\u0005\u0002\n-%A\u0005'pO\u000e{gnY;se\u0016t7-\u001f+fgRT!AO\u001e\u0002\u00071|wMC\u0001=\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A \u0011\u0005\u0001\u001bU\"A!\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R!\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\t\u0005\u0002I\u00015\t\u0011(\u0001\tce>\\WM\u001d+pa&\u001c7\u000b^1ugV\t1\n\u0005\u0002M\u001f6\tQJ\u0003\u0002Ow\u000511/\u001a:wKJL!\u0001U'\u0003!\t\u0013xn[3s)>\u0004\u0018nY*uCR\u001c\u0018!\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;tA\u00051!/\u00198e_6,\u0012\u0001\u0016\t\u0003+bk\u0011A\u0016\u0006\u0003/\u0006\u000bA!\u001e;jY&\u0011\u0011L\u0016\u0002\u0007%\u0006tGm\\7\u0002\u000fI\fg\u000eZ8nA\u0005I1o\u00195fIVdWM]\u000b\u0002;B\u0011aLZ\u0007\u0002?*\u0011q\u000b\u0019\u0006\u0003\u001d\u0006T!\u0001\u00102\u000b\u0005\r$\u0017AB1qC\u000eDWMC\u0001f\u0003\ry'oZ\u0005\u0003O~\u0013abS1gW\u0006\u001c6\r[3ek2,'/\u0001\u0006tG\",G-\u001e7fe\u0002\na\u0001^7q\t&\u0014X#A6\u0011\u00051\fX\"A7\u000b\u00059|\u0017AA5p\u0015\u0005\u0001\u0018\u0001\u00026bm\u0006L!A]7\u0003\t\u0019KG.Z\u0001\bi6\u0004H)\u001b:!\u0003\u0019awn\u001a#je\u00069An\\4ESJ\u0004\u0013!B:fiV\u0004H#\u0001=\u0011\u0005\u0001K\u0018B\u0001>B\u0005\u0011)f.\u001b;)\u00051a\bcA?\u0002\n5\taPC\u0002\u0000\u0003\u0003\t1!\u00199j\u0015\u0011\t\u0019!!\u0002\u0002\u000f),\b/\u001b;fe*\u0019\u0011q\u00013\u0002\u000b),h.\u001b;\n\u0007\u0005-aP\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001b\u001d5vi\u0012|wO\u001c\u0015\u0004\u001b\u0005E\u0001cA?\u0002\u0014%\u0019\u0011Q\u0003@\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\b;fgR,fnY8n[&$H/\u001a3ECR\fgj\u001c;D_:\u001cX/\\3eQ\rq\u00111\u0004\t\u0004{\u0006u\u0011bAA\u0010}\n!A+Z:u\u0003I\"Xm\u001d;V]\u000e|W.\\5ui\u0016$G)\u0019;b\u001d>$8i\u001c8tk6,GM\u0012:fcV,g\u000e^*fO6,g\u000e\u001e*pY2\u001c\bfA\b\u0002\u001cQ\u0019\u00010a\n\t\ri\u0002\u0002\u0019AA\u0015!\rA\u00151F\u0005\u0004\u0003[I$aC!cgR\u0014\u0018m\u0019;M_\u001e\u0014AbQ8ogVlWM\u001d+bg.\u001cR!EA\u001a\u0003\u007f\u0001B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003sy\u0017\u0001\u00027b]\u001eLA!!\u0010\u00028\t1qJ\u00196fGR\u0004R!!\u0011\u0002Jal!!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\u000bG>t7-\u001e:sK:$(BA,p\u0013\u0011\tY%a\u0011\u0003\u0011\r\u000bG\u000e\\1cY\u0016\f!\u0002\\1ti>3gm]3u!\r\u0001\u0015\u0011K\u0005\u0004\u0003'\n%aA%oiR1\u0011qKA.\u0003;\u00022!!\u0017\u0012\u001b\u0005\u0001\u0001B\u0002\u001e\u0015\u0001\u0004\tI\u0003C\u0004\u0002NQ\u0001\r!a\u0014\u0002\u001f\r|gn];nK\u0012\u0014\u0015\r^2iKN,\"!a\u0019\u0011\r\u0005\u0015\u0014qNA:\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003[\n\u0015AC2pY2,7\r^5p]&!\u0011\u0011OA4\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\t\u0004\u00033\u0002#\u0001\u0004$fi\u000eDW\r\u001a\"bi\u000eD7C\u0002\u0011@\u0003s\ny\bE\u0002A\u0003wJ1!! B\u0005\u001d\u0001&o\u001c3vGR\u0004B!!!\u0002\u0012:!\u00111QAG\u001d\u0011\t))a#\u000e\u0005\u0005\u001d%bAAE{\u00051AH]8pizJ\u0011AQ\u0005\u0004\u0003\u001f\u000b\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003'\u000b)J\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002\u0010\u0006\u000b!BY1tK>3gm]3u+\t\tY\nE\u0002A\u0003;K1!a(B\u0005\u0011auN\\4\u0002\u0017\t\f7/Z(gMN,G\u000fI\u0001\u0006KB|7\r[\u000b\u0003\u0003\u001f\na!\u001a9pG\"\u0004CCBA:\u0003W\u000bi\u000bC\u0004\u0002\u0018\u0016\u0002\r!a'\t\u000f\u0005\rV\u00051\u0001\u0002P\u0005AAo\\*ue&tw\r\u0006\u0002\u00024B!\u0011QWA_\u001d\u0011\t9,!/\u0011\u0007\u0005\u0015\u0015)C\u0002\u0002<\u0006\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA`\u0003\u0003\u0014aa\u0015;sS:<'bAA^\u0003\u0006!1m\u001c9z)\u0019\t\u0019(a2\u0002J\"I\u0011qS\u0014\u0011\u0002\u0003\u0007\u00111\u0014\u0005\n\u0003G;\u0003\u0013!a\u0001\u0003\u001f\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002P*\"\u00111TAiW\t\t\u0019\u000e\u0005\u0003\u0002V\u0006}WBAAl\u0015\u0011\tI.a7\u0002\u0013Ut7\r[3dW\u0016$'bAAo\u0003\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0018q\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003OTC!a\u0014\u0002R\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!<\u0011\t\u0005U\u0012q^\u0005\u0005\u0003\u007f\u000b9$\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005]\u0018Q \t\u0004\u0001\u0006e\u0018bAA~\u0003\n\u0019\u0011I\\=\t\u0013\u0005}H&!AA\u0002\u0005=\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u0006A1!q\u0001B\u0005\u0003ol!!a\u001b\n\t\t-\u00111\u000e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u0012\t]\u0001c\u0001!\u0003\u0014%\u0019!QC!\u0003\u000f\t{w\u000e\\3b]\"I\u0011q \u0018\u0002\u0002\u0003\u0007\u0011q_\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002n\nu\u0001\"CA\u0000_\u0005\u0005\t\u0019AA(\u0003!A\u0017m\u001d5D_\u0012,GCAA(\u0003\u0019)\u0017/^1mgR!!\u0011\u0003B\u0014\u0011%\ty0MA\u0001\u0002\u0004\t90\u0001\td_:\u001cX/\\3e\u0005\u0006$8\r[3tA\u0005!1-\u00197m\u00055aunZ!qa\u0016tG\rV1tWN)\u0001$a\r\u0002@Q1!1\u0007B\u001b\u0005o\u00012!!\u0017\u0019\u0011\u0019Q4\u00041\u0001\u0002*!9\u0011QJ\u000eA\u0002\u0005m\u0015!C2sK\u0006$X\rT8h)\u0011\tIC!\u0010\t\u0013\t}R\u0004%AA\u0002\t\u0005\u0013AB2p]\u001aLw\r\u0005\u0003\u0003D\t=SB\u0001B#\u0015\rQ$q\t\u0006\u0005\u0005\u0013\u0012Y%A\u0005j]R,'O\\1mg*\u0019!QJ1\u0002\u000fM$xN]1hK&!!\u0011\u000bB#\u0005%aunZ\"p]\u001aLw-A\nde\u0016\fG/\u001a'pO\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003X)\"!\u0011IAi\u0003Q1\u0018\r\\5eCR,7i\u001c8tk6,G\rR1uCR)\u0001P!\u0018\u0003`!1!h\ba\u0001\u0003SAq!a\u0018 \u0001\u0004\u0011\t\u0007\u0005\u0004\u0002\u0002\n\r\u00141O\u0005\u0005\u0005K\n)J\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u000311U\r^2iK\u0012\u0014\u0015\r^2i!\r\tIfM\n\u0006g\t5$\u0011\u0010\t\u000b\u0005_\u0012)(a'\u0002P\u0005MTB\u0001B9\u0015\r\u0011\u0019(Q\u0001\beVtG/[7f\u0013\u0011\u00119H!\u001d\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007E\u0002m\u0005wJ1!a%n)\t\u0011I\u0007\u0006\u0002\u0002n\u0006)\u0011\r\u001d9msR1\u00111\u000fBC\u0005\u000fCq!a&7\u0001\u0004\tY\nC\u0004\u0002$Z\u0002\r!a\u0014\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0012BM!\u0015\u0001%q\u0012BJ\u0013\r\u0011\t*\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f\u0001\u0013)*a'\u0002P%\u0019!qS!\u0003\rQ+\b\u000f\\33\u0011%\u0011YjNA\u0001\u0002\u0004\t\u0019(A\u0002yIA\u0002")
public class LogConcurrencyTest {
    private volatile LogConcurrencyTest$FetchedBatch$ FetchedBatch$module;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Random kafka$log$LogConcurrencyTest$$random = new Random();
    private final KafkaScheduler scheduler = new KafkaScheduler(1);
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());

    private LogConcurrencyTest$FetchedBatch$ FetchedBatch() {
        if (this.FetchedBatch$module == null) {
            this.FetchedBatch$lzycompute$1();
        }
        return this.FetchedBatch$module;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Random kafka$log$LogConcurrencyTest$$random() {
        return this.kafka$log$LogConcurrencyTest$$random;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File tmpDir() {
        return this.tmpDir;
    }

    private File logDir() {
        return this.logDir;
    }

    @BeforeEach
    public void setup() {
        this.scheduler().startup();
    }

    @AfterEach
    public void shutdown() {
        this.scheduler().shutdown();
        Utils.delete((File)this.tmpDir(), (boolean)false);
    }

    @Test
    public void testUncommittedDataNotConsumed() {
        this.testUncommittedDataNotConsumed(this.createLog(this.createLog$default$1()));
    }

    @Test
    public void testUncommittedDataNotConsumedFrequentSegmentRolls() {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(237));
        LogConfig logConfig = new LogConfig((Map)logProps);
        this.testUncommittedDataNotConsumed(this.createLog(logConfig));
    }

    public void testUncommittedDataNotConsumed(AbstractLog log) {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            int maxOffset = 5000;
            ConsumerTask consumer = new ConsumerTask(this, log, maxOffset);
            LogAppendTask appendTask = new LogAppendTask(this, log, maxOffset);
            Future<BoxedUnit> consumerFuture = executor.submit(consumer);
            executor.submit(appendTask).get();
            consumerFuture.get();
            this.validateConsumedData(log, (Iterable<FetchedBatch>)consumer.consumedBatches());
        }
        finally {
            executor.shutdownNow();
        }
    }

    private AbstractLog createLog(LogConfig config) {
        File x$1 = this.logDir();
        KafkaScheduler x$5 = this.scheduler();
        BrokerTopicStats x$6 = this.brokerTopicStats();
        Metrics x$7 = new Metrics();
        Time x$8 = Time.SYSTEM;
        ProducerStateManagerConfig x$10 = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs());
        int x$11 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$12 = new LogDirFailureChannel(10);
        TierLogComponents x$13 = TierLogComponents$.MODULE$.EMPTY();
        None$ x$14 = None$.MODULE$;
        None$ x$17 = None$.MODULE$;
        LogOffsetsListener x$18 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        None$ x$19 = None$.MODULE$;
        ConcurrentHashMap x$20 = new ConcurrentHashMap();
        return MergedLog$.MODULE$.apply(x$1, config, 0L, 0L, (Scheduler)x$5, x$6, x$7, x$8, 300000, x$10, x$11, (Option)x$17, x$12, x$13, true, (Option)x$14, true, x$18, (Option)x$19, x$20);
    }

    private LogConfig createLog$default$1() {
        return new LogConfig((Map)new Properties());
    }

    private void validateConsumedData(AbstractLog log, Iterable<FetchedBatch> consumedBatches) {
        Iterator iter = consumedBatches.iterator();
        log.localLogSegments().foreach((Function1 & Serializable)segment -> {
            LogConcurrencyTest.$anonfun$validateConsumedData$1(iter, segment);
            return BoxedUnit.UNIT;
        });
    }

    private final void FetchedBatch$lzycompute$1() {
        synchronized (this) {
            if (this.FetchedBatch$module == null) {
                this.FetchedBatch$module = new LogConcurrencyTest$FetchedBatch$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$validateConsumedData$1(Iterator iter$1, LogSegment segment) {
        segment.log().batches().forEach(batch -> {
            if (iter$1.hasNext()) {
                FetchedBatch consumedBatch = (FetchedBatch)iter$1.next();
                try {
                    Assertions.assertEquals((int)batch.partitionLeaderEpoch(), (int)consumedBatch.epoch(), (String)"Consumed batch with unexpected leader epoch");
                    Assertions.assertEquals((long)batch.baseOffset(), (long)consumedBatch.baseOffset(), (String)"Consumed batch with unexpected base offset");
                    return;
                }
                catch (Throwable t) {
                    throw new AssertionError(new StringBuilder(58).append("Consumed batch ").append(consumedBatch).append(" ").append("does not match next expected batch in log ").append(batch).toString(), t);
                }
            }
        });
    }

    private class ConsumerTask
    implements Callable<BoxedUnit> {
        private final AbstractLog log;
        private final int lastOffset;
        private final ListBuffer<FetchedBatch> consumedBatches;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public ListBuffer<FetchedBatch> consumedBatches() {
            return this.consumedBatches;
        }

        @Override
        public void call() {
            LongRef fetchOffset = LongRef.create((long)0L);
            while (this.log.highWatermark() < (long)this.lastOffset) {
                this.log.readLocal((long)fetchOffset.elem, (int)1, (FetchIsolation)FetchIsolation.HIGH_WATERMARK, (boolean)true).records.batches().forEach(batch -> {
                    this.consumedBatches().$plus$eq((Object)new FetchedBatch(this.kafka$log$LogConcurrencyTest$ConsumerTask$$$outer(), batch.baseOffset(), batch.partitionLeaderEpoch()));
                    fetchOffset$1.elem = batch.lastOffset() + 1L;
                });
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$ConsumerTask$$$outer() {
            return this.$outer;
        }

        public ConsumerTask(LogConcurrencyTest $outer, AbstractLog log, int lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.consumedBatches = ListBuffer$.MODULE$.empty();
        }
    }

    private class FetchedBatch
    implements Product,
    Serializable {
        private final long baseOffset;
        private final int epoch;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long baseOffset() {
            return this.baseOffset;
        }

        public int epoch() {
            return this.epoch;
        }

        public String toString() {
            return new StringBuilder(33).append("FetchedBatch(baseOffset=").append(this.baseOffset()).append(", epoch=").append(this.epoch()).append(")").toString();
        }

        public FetchedBatch copy(long baseOffset, int epoch) {
            return new FetchedBatch(this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer(), baseOffset, epoch);
        }

        public long copy$default$1() {
            return this.baseOffset();
        }

        public int copy$default$2() {
            return this.epoch();
        }

        public String productPrefix() {
            return "FetchedBatch";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.baseOffset());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.epoch());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FetchedBatch;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "baseOffset";
                }
                case 1: {
                    return "epoch";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.longHash((long)this.baseOffset())), (int)this.epoch()), (int)2);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof FetchedBatch && ((FetchedBatch)x$1).kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() == this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer())) break block3;
                    FetchedBatch fetchedBatch = (FetchedBatch)x$1;
                    if (this.baseOffset() != fetchedBatch.baseOffset() || this.epoch() != fetchedBatch.epoch() || !fetchedBatch.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() {
            return this.$outer;
        }

        public FetchedBatch(LogConcurrencyTest $outer, long baseOffset, int epoch) {
            this.baseOffset = baseOffset;
            this.epoch = epoch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    private class LogAppendTask
    implements Callable<BoxedUnit> {
        private final AbstractLog log;
        private final long lastOffset;
        public final /* synthetic */ LogConcurrencyTest $outer;

        @Override
        public void call() {
            int leaderEpoch = 1;
            boolean isLeader = true;
            block4: while (this.log.highWatermark() < this.lastOffset) {
                int n = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(2);
                switch (n) {
                    case 0: {
                        LogOffsetMetadata logEndOffsetMetadata = this.log.logEndOffsetMetadata();
                        long logEndOffset = logEndOffsetMetadata.messageOffset;
                        int batchSize = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(9) + 1;
                        IndexedSeq records = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), batchSize).map((Function1 & Serializable)i -> LogAppendTask.$anonfun$call$2(BoxesRunTime.unboxToInt((Object)i)));
                        if (isLeader) {
                            this.log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1), leaderEpoch, this.log.appendAsLeader$default$3(), this.log.appendAsLeader$default$4(), this.log.appendAsLeader$default$5());
                            this.log.maybeIncrementHighWatermark(logEndOffsetMetadata);
                            continue block4;
                        }
                        byte x$4 = 2;
                        CompressionType x$5 = CompressionType.NONE;
                        long x$6 = -1L;
                        short x$7 = -1;
                        int x$8 = -1;
                        this.log.appendAsFollower(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, x$4, x$5, x$6, x$7, x$8, logEndOffset, leaderEpoch));
                        this.log.updateHighWatermark(logEndOffset);
                        continue block4;
                    }
                    case 1: {
                        isLeader = !isLeader;
                        ++leaderEpoch;
                        if (isLeader) continue block4;
                        this.log.truncateTo(this.log.highWatermark());
                        continue block4;
                    }
                }
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$LogAppendTask$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ SimpleRecord $anonfun$call$2(int i) {
            return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        }

        public LogAppendTask(LogConcurrencyTest $outer, AbstractLog log, long lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

