/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import kafka.log.AbstractLog;
import kafka.log.LocalLog$;
import kafka.log.LogLoader$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogMetricNames$;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.SegmentDeletionThrottlerConfig;
import kafka.log.StrayLogMetadataFile$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.log.remote.RemoteIndexCache$;
import kafka.server.BrokerTopicMetrics;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicConsumer;
import kafka.utils.CoreUtils$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.directory.api.util.FileUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AbstractFetchDataInfo;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.VolatileIntRef;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\rmf\u0001B*U\u0001eCQ\u0001\u0019\u0001\u0005\u0002\u0005Dq\u0001\u001a\u0001C\u0002\u0013\u0005Q\r\u0003\u0004m\u0001\u0001\u0006IA\u001a\u0005\b[\u0002\u0011\r\u0011\"\u0001o\u0011\u0019\u0011\b\u0001)A\u0005_\"91\u000f\u0001b\u0001\n\u0003q\u0007B\u0002;\u0001A\u0003%q\u000eC\u0004v\u0001\t\u0007I\u0011\u0001<\t\r}\u0004\u0001\u0015!\u0003x\u0011%\t\t\u0001\u0001b\u0001\n\u0003\t\u0019\u0001\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\u0003\u0011-\t\u0019\u0003\u0001a\u0001\u0002\u0004%\t!!\n\t\u0017\u0005M\u0002\u00011AA\u0002\u0013\u0005\u0011Q\u0007\u0005\f\u0003\u0003\u0002\u0001\u0019!A!B\u0013\t9\u0003C\u0006\u0002D\u0001\u0001\r\u00111A\u0005\u0002\u0005\u0015\u0003bCA'\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u001fB1\"a\u0015\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002H!I\u0011Q\u000b\u0001C\u0002\u0013\u0005\u0011q\u000b\u0005\t\u0003K\u0002\u0001\u0015!\u0003\u0002Z!I\u0011q\r\u0001C\u0002\u0013\u0005\u0011\u0011\u000e\u0005\t\u0003c\u0002\u0001\u0015!\u0003\u0002l!I\u00111\u000f\u0001C\u0002\u0013\u0005\u0011Q\u000f\u0005\t\u0003\u000b\u0003\u0001\u0015!\u0003\u0002x!9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0005bBAQ\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003W\u0003A\u0011AAE\u0011\u001d\t)\f\u0001C\u0001\u0003\u0013Cq!!/\u0001\t\u0003\tI\tC\u0004\u0002>\u0002!\t!!#\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002\n\"9\u0011Q\u0019\u0001\u0005\u0002\u0005%\u0005bBAe\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003\u001b\u0004A\u0011BAh\u0011\u001d\t)\u000e\u0001C\u0001\u0003\u0013Cq!!7\u0001\t\u0003\tY\u000eC\u0004\u0003\f\u0001!\t!!#\t\u000f\t=\u0001\u0001\"\u0001\u0002\n\"9!1\u0003\u0001\u0005\u0002\u0005%\u0005b\u0002B\f\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u00057\u0001A\u0011AAE\u0011\u001d\u0011y\u0002\u0001C\u0005\u0005CAqAa\u000f\u0001\t\u0003\tI\tC\u0004\u0003@\u0001!\t!!#\t\u000f\t\r\u0003\u0001\"\u0001\u0002\n\"9!q\n\u0001\u0005\u0002\u0005%\u0005b\u0002B*\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0005/\u0002A\u0011AAE\u0011\u001d\u0011Y\u0006\u0001C\u0001\u0003\u0013CqAa\u0018\u0001\t\u0013\u0011\t\u0007C\u0004\u0003\u0006\u0002!IAa\"\t\u0013\tE\u0006!%A\u0005\n\tM\u0006\"\u0003Be\u0001E\u0005I\u0011\u0002Bf\u0011%\u0011y\rAI\u0001\n\u0013\u0011\t\u000eC\u0005\u0003V\u0002\t\n\u0011\"\u0003\u0003X\"9!1\u001c\u0001\u0005\u0002\tu\u0007b\u0002Bu\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0005[\u0004A\u0011AAE\u0011\u001d\u0011\t\u0010\u0001C\u0001\u0003\u0013CqA!>\u0001\t\u0013\u00119\u0010C\u0005\u0004\u0010\u0001\t\n\u0011\"\u0003\u0003R\"91\u0011\u0003\u0001\u0005\u0002\u0005%\u0005bBB\u000b\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u00073\u0001A\u0011AAE\u0011\u001d\u0019i\u0002\u0001C\u0001\u0003\u0013Cqa!\t\u0001\t\u0003\tI\tC\u0004\u0004&\u0001!\t!!#\t\u000f\r%\u0002\u0001\"\u0001\u0004,!91Q\u0007\u0001\u0005\n\r]\u0002bBB\u001e\u0001\u0011%1Q\b\u0005\b\u00073\u0002A\u0011BB.\u0011\u001d\u0019\t\b\u0001C\u0005\u0007gBqa!$\u0001\t\u0013\u0019y\tC\u0004\u0004\u0014\u0002!\t!!#\t\u000f\r]\u0005\u0001\"\u0001\u0002\n\"911\u0014\u0001\u0005\u0002\u0005%\u0005bBBP\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0007G\u0003A\u0011AAE\u0011\u001d\u00199\u000b\u0001C\u0001\u0003\u0013Cqaa+\u0001\t\u0003\tI\tC\u0004\u00040\u0002!\t!!#\t\u000f\rM\u0006\u0001\"\u0001\u0002\n\"91q\u0017\u0001\u0005\u0002\u0005%%A\u0004'pO6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003+Z\u000b1\u0001\\8h\u0015\u00059\u0016!B6bM.\f7\u0001A\n\u0003\u0001i\u0003\"a\u00170\u000e\u0003qS\u0011!X\u0001\u0006g\u000e\fG.Y\u0005\u0003?r\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001c!\t\u0019\u0007!D\u0001U\u0003\u0011!\u0018.\\3\u0016\u0003\u0019\u0004\"a\u001a6\u000e\u0003!T!!\u001b,\u0002\u000bU$\u0018\u000e\\:\n\u0005-D'\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u001f5\f\u0007PU8mY&sG/\u001a:wC2,\u0012a\u001c\t\u00037BL!!\u001d/\u0003\u0007%sG/\u0001\tnCb\u0014v\u000e\u001c7J]R,'O^1mA\u0005YQ.\u0019=M_\u001e\fu-Z't\u00031i\u0017\r\u001f'pO\u0006;W-T:!\u0003!awn\u001a)s_B\u001cX#A<\u0011\u0005alX\"A=\u000b\u0005i\\\u0018\u0001B;uS2T\u0011\u0001`\u0001\u0005U\u00064\u0018-\u0003\u0002\u007fs\nQ\u0001K]8qKJ$\u0018.Z:\u0002\u00131|w\r\u0015:paN\u0004\u0013!\u00037pO\u000e{gNZ5h+\t\t)\u0001\u0005\u0003\u0002\b\u0005uQBAA\u0005\u0015\r)\u00161\u0002\u0006\u0005\u0003\u001b\ty!A\u0005j]R,'O\\1mg*!\u0011\u0011CA\n\u0003\u001d\u0019Ho\u001c:bO\u0016T1aVA\u000b\u0015\u0011\t9\"!\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tY\"A\u0002pe\u001eLA!a\b\u0002\n\tIAj\\4D_:4\u0017nZ\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0013A\u00027pO\u0012K'/\u0006\u0002\u0002(A!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.m\f!![8\n\t\u0005E\u00121\u0006\u0002\u0005\r&dW-\u0001\u0006m_\u001e$\u0015N]0%KF$B!a\u000e\u0002>A\u00191,!\u000f\n\u0007\u0005mBL\u0001\u0003V]&$\b\"CA \u001b\u0005\u0005\t\u0019AA\u0014\u0003\rAH%M\u0001\bY><G)\u001b:!\u0003)awnZ'b]\u0006<WM]\u000b\u0003\u0003\u000f\u00022aYA%\u0013\r\tY\u0005\u0016\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\u0018A\u00047pO6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003o\t\t\u0006C\u0005\u0002@A\t\t\u00111\u0001\u0002H\u0005YAn\\4NC:\fw-\u001a:!\u0003\u0011q\u0017-\\3\u0016\u0005\u0005e\u0003\u0003BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}30\u0001\u0003mC:<\u0017\u0002BA2\u0003;\u0012aa\u0015;sS:<\u0017!\u00028b[\u0016\u0004\u0013!\u0007<fefd\u0015M]4f\u0019><g\t\\;tQ&sG/\u001a:wC2,\"!a\u001b\u0011\u0007m\u000bi'C\u0002\u0002pq\u0013A\u0001T8oO\u0006Qb/\u001a:z\u0019\u0006\u0014x-\u001a'pO\u001acWo\u001d5J]R,'O^1mA\u00059Q.\u001a;sS\u000e\u001cXCAA<!\u0011\tI(!!\u000e\u0005\u0005m$\u0002BA:\u0003{RA!a \u0002\u0014\u000511m\\7n_:LA!a!\u0002|\t9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005]\u0002f\u0001\r\u0002\u000eB!\u0011qRAO\u001b\t\t\tJ\u0003\u0003\u0002\u0014\u0006U\u0015aA1qS*!\u0011qSAM\u0003\u001dQW\u000f]5uKJTA!a'\u0002\u001a\u0005)!.\u001e8ji&!\u0011qTAI\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001a\u0011$!*\u0011\t\u0005=\u0015qU\u0005\u0005\u0003S\u000b\tJA\u0005BMR,'/R1dQ\u0006iA/Z:u\u0007J,\u0017\r^3M_\u001eD3AGAX!\u0011\ty)!-\n\t\u0005M\u0016\u0011\u0013\u0002\u0005)\u0016\u001cH/\u0001\u0013uKN$\b*\u00198eY&tw-\u0012=dKB$\u0018n\u001c8t\tV\u0014\u0018N\\4TQV$Hm\\<oQ\rY\u0012qV\u0001=i\u0016\u001cHo\u00117fC:\u001c\u0006.\u001e;e_^tg)\u001b7f/\",gn\u00155vi\u0012|wO\\\"bY2,GMQ3g_J,7\u000b^1siV\u00048i\\7qY\u0016$X\rK\u0002\u001d\u0003_\u000b\u0001\u0004^3ti\"\u000bGm\u00117fC:\u001c\u0006.\u001e;e_^tg\t\\1hQ\ri\u0012qV\u0001\u001fi\u0016\u001cHo\u0011:fCR,Gj\\4XSRD\u0017J\u001c<bY&$Gj\\4ESJD3AHAX\u0003}!Xm\u001d;De\u0016\fG/\u001a'pO^KG\u000f\u001b'pO\u0012K'OR1mY\n\f7m\u001b\u0015\u0004?\u0005=\u0016!\u0006;fgR<U\r\u001e(p]\u0016C\u0018n\u001d;f]Rdun\u001a\u0015\u0004A\u0005=\u0016A\t:fG>tg-[4ve\u0016l\u0015\r_*fO6,g\u000e\u001e#fY\u0016$X\r\u001a)feJ+h\u000e\u0006\u0003\u00028\u0005E\u0007BBAjC\u0001\u0007q.\u0001\u000fm_\u001e$U\r\\3uS>tW*\u0019=TK\u001elWM\u001c;t!\u0016\u0014(+\u001e8\u0002_Q,7\u000f\u001e'pO\u0012+G.\u001a;j_:l\u0015\r_*fO6,g\u000e^:QKJ\u0014VO\\#ya&\u0014X\rZ*fO6,g\u000e^:)\u0007\t\ny+\u0001$uKN$Hj\\4EK2,G/[8o\u001b\u0006D8+Z4nK:$8\u000fU3s%Vt\u0017\t\\8oO^KG\u000f\u001b+jKJ\u001cVmZ7f]RDu\u000e^:fiJ{G\u000e\\'j]\nKH/Z:\u0015\t\u0005]\u0012Q\u001c\u0005\b\u0003?\u001c\u0003\u0019AAq\u0003=\u0019\u0007.Z2lgVlWI\\1cY\u0016$\u0007cA.\u0002d&\u0019\u0011Q\u001d/\u0003\u000f\t{w\u000e\\3b]\":1%!;\u0002z\u0006m\b\u0003BAv\u0003kl!!!<\u000b\t\u0005=\u0018\u0011_\u0001\taJ|g/\u001b3fe*!\u00111_AK\u0003\u0019\u0001\u0018M]1ng&!\u0011q_Aw\u0005-1\u0016\r\\;f'>,(oY3\u0002\u0011\t|w\u000e\\3b]NdC!!@\u0002\u0000f\t\u0011!G\u0001\u0001Q\r\u0019#1\u0001\t\u0005\u0005\u000b\u00119!\u0004\u0002\u0002r&!!\u0011BAy\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u001bi\u0016\u001cHo\u00117fC:,\b/\u0012=qSJ,GmU3h[\u0016tGo\u001d\u0015\u0004I\u0005=\u0016!\t;fgR\u001cE.Z1okB\u001cVmZ7f]R\u001cHk\\'bS:$\u0018-\u001b8TSj,\u0007fA\u0013\u00020\u0006QC/Z:u\t>,7O\u001c;DY\u0016\fg\u000eT8hg^KG\u000f[\"p[B\f7\r\u001e#fY\u0016$X\rU8mS\u000eL\bf\u0001\u0014\u00020\u0006!C/Z:u\t>,7O\u001c;DY\u0016\fg\u000eT8hg^KG\u000f[\"p[B\f7\r\u001e)pY&\u001c\u0017\u0010K\u0002(\u0003_\u000b\u0001\u0007^3ti\u0012{Wm\u001d8u\u00072,\u0017M\u001c'pON<\u0016\u000e\u001e5Ge>TXM\u001c'pON#\u0018M\u001d;PM\u001a\u001cX\r^*uCR,\u0007f\u0001\u0015\u00020\u0006\u0019B/Z:u\t>,7O\u001c;DY\u0016\fg\u000eT8hgR!\u0011q\u0007B\u0012\u0011\u001d\u0011)#\u000ba\u0001\u0005O\ta\u0001]8mS\u000eL\b\u0003\u0002B\u0015\u0005oqAAa\u000b\u00034A\u0019!Q\u0006/\u000e\u0005\t=\"b\u0001B\u00191\u00061AH]8pizJ1A!\u000e]\u0003\u0019\u0001&/\u001a3fM&!\u00111\rB\u001d\u0015\r\u0011)\u0004X\u0001\u0013i\u0016\u001cH\u000fV5nK\n\u000b7/\u001a3GYV\u001c\b\u000eK\u0002+\u0003_\u000b\u0011\u0004^3ti2+\u0017m\u001d;M_\u0006$W\rZ!tg&<g.\\3oi\"\u001a1&a,\u0002AQ,7\u000f\u001e'pC\u0012dunZ:TW&\u0004(+Z7pi\u0016Le\u000eZ3y\u0007\u0006\u001c\u0007.\u001a\u0015\u0004Y\u0005=\u0006f\u0001\u0017\u0003JA!\u0011q\u0012B&\u0013\u0011\u0011i%!%\u0003\u0011\u0011K7/\u00192mK\u0012\f1\u0005^3tiR;x\u000eT8h\u001b\u0006t\u0017mZ3sgV\u001b\u0018N\\4TC6,G)\u001b:GC&d7\u000fK\u0002.\u0003_\u000bA\u0004^3ti\u000eCWmY6q_&tGOU3d_Z,'/\u001f)pS:$8\u000fK\u0002/\u0003_\u000bQ\u0006^3tiJ+7m\u001c<fef$\u0015N]3di>\u0014\u00180T1qa&twmV5uQR\u0013\u0018-\u001b7j]\u001e\u001cF.Y:iQ\ry\u0013qV\u00012i\u0016\u001cHOU3d_Z,'/\u001f#je\u0016\u001cGo\u001c:z\u001b\u0006\u0004\b/\u001b8h/&$\bNU3mCRLg/\u001a#je\u0016\u001cGo\u001c:zQ\r\u0001\u0014qV\u0001\u0019m\u0016\u0014\u0018NZ=DQ\u0016\u001c7\u000e]8j]R\u0014VmY8wKJLH\u0003CA\u001c\u0005G\u0012\tIa!\t\u000f\t\u0015\u0014\u00071\u0001\u0003h\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0005\u0004\u0003j\tM$\u0011\u0010\b\u0005\u0005W\u0012yG\u0004\u0003\u0003.\t5\u0014\"A/\n\u0007\tED,A\u0004qC\u000e\\\u0017mZ3\n\t\tU$q\u000f\u0002\u0004'\u0016\f(b\u0001B99B!!1\u0010B?\u001b\t\ti(\u0003\u0003\u0003\u0000\u0005u$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003\u0007\n\u0004\u0019AA$\u0011\u001d\t\u0019#\ra\u0001\u0003O\t\u0001c\u0019:fCR,Gj\\4NC:\fw-\u001a:\u0015\u0015\u0005\u001d#\u0011\u0012BH\u0005G\u00139\u000bC\u0005\u0003\fJ\u0002\n\u00111\u0001\u0003\u000e\u00069An\\4ESJ\u001c\bC\u0002B5\u0005g\n9\u0003C\u0005\u0003\u0012J\u0002\n\u00111\u0001\u0003\u0014\u0006\u00012m\u001c8gS\u001e\u0014V\r]8tSR|'/\u001f\t\u0005\u0005+\u0013y*\u0004\u0002\u0003\u0018*!!\u0011\u0014BN\u0003!iW\r^1eCR\f'b\u0001BO-\u000611/\u001a:wKJLAA!)\u0003\u0018\n\u00012i\u001c8gS\u001e\u0014V\r]8tSR|'/\u001f\u0005\t\u0005K\u0013\u0004\u0013!a\u0001_\u0006I\"/Z2pm\u0016\u0014\u0018\u0010\u00165sK\u0006$7\u000fU3s\t\u0006$\u0018\rR5s\u0011%\u0011IK\rI\u0001\u0002\u0004\u0011Y+A\tuS\u0016\u0014Hj\\4D_6\u0004xN\\3oiN\u00042a\u0019BW\u0013\r\u0011y\u000b\u0016\u0002\u0012)&,'\u000fT8h\u0007>l\u0007o\u001c8f]R\u001c\u0018AG2sK\u0006$X\rT8h\u001b\u0006t\u0017mZ3sI\u0011,g-Y;mi\u0012\nTC\u0001B[U\u0011\u0011iIa.,\u0005\te\u0006\u0003\u0002B^\u0005\u000bl!A!0\u000b\t\t}&\u0011Y\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa1]\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u000f\u0014iLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!d\u0019:fCR,Gj\\4NC:\fw-\u001a:%I\u00164\u0017-\u001e7uII*\"A!4+\t\tM%qW\u0001\u001bGJ,\u0017\r^3M_\u001el\u0015M\\1hKJ$C-\u001a4bk2$HeM\u000b\u0003\u0005'T3a\u001cB\\\u0003i\u0019'/Z1uK2{w-T1oC\u001e,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011IN\u000b\u0003\u0003,\n]\u0016A\t;fgR4\u0015\u000e\\3SK\u001a,'/\u001a8dKN\fe\r^3s\u0003NLhn\u0019#fY\u0016$X\r\u0006\u0003\u00028\t}\u0007b\u0002Bqo\u0001\u0007\u0011\u0011]\u0001\bSN\u001cFO]1zQ\u001d9\u0014\u0011^A}\u0005KdC!!@\u0002\u0000\"\u001aqGa\u0001\u00029Q,7\u000f^*ue\u0006LHj\\4EK2,G/[8o)\"\u0014x\u000e\u001e;mK\"\u001a\u0001(a,\u0002EQ,7\u000f^\"sK\u0006$X-\u00118e\t\u0016dW\r^3Pm\u0016\u0014H.\u001f'p]\u001e$v\u000e]5dQ\rI\u0014qV\u0001\"i\u0016\u001cHo\u00115fG.\u0004x.\u001b8u\r>\u0014xJ\u001c7z\u0003\u001a4Wm\u0019;fI2{wm\u001d\u0015\u0004u\u0005=\u0016a\u0002:fC\u0012dun\u001a\u000b\t\u0005s\u0014ypa\u0002\u0004\fA!\u0011q\u0001B~\u0013\u0011\u0011i0!\u0003\u0003\u001b\u0019+Go\u00195ECR\f\u0017J\u001c4p\u0011\u0019)6\b1\u0001\u0004\u0002A\u00191ma\u0001\n\u0007\r\u0015AKA\u0006BEN$(/Y2u\u0019><\u0007bBB\u0005w\u0001\u0007\u00111N\u0001\u0007_\u001a47/\u001a;\t\u0011\r51\b%AA\u0002=\f\u0011\"\\1y\u0019\u0016tw\r\u001e5\u0002#I,\u0017\r\u001a'pO\u0012\"WMZ1vYR$3'A\u0013uKN$Hk\u001c9jG\u000e{gNZ5h\u0007\"\fgnZ3Va\u0012\fG/Z:M_\u001e\u001cuN\u001c4jO\"\u001aQ(a,\u0002;Q,7\u000f^\"p]\u001aLwm\u00115b]\u001e,w)\u001a;t\u00072,\u0017M\\3e+BD3APAX\u0003!\"Xm\u001d;Ce>\\WM]\"p]\u001aLwm\u00115b]\u001e,G)\u001a7jm\u0016\u0014X\r\u001a+p\u00032dGj\\4tQ\ry\u0014qV\u00014i\u0016\u001cH\u000fV8qS\u000e\u001cuN\u001c4jO\u000eC\u0017M\\4f'R|\u0007o\u00117fC:LgnZ%g\u0007>l\u0007/Y2u\u0013N\u0014V-\\8wK\u0012D3\u0001QAX\u00031\"Xm\u001d;D_:4\u0017nZ\"iC:<Wm],ji\"tu\u000eT8h\u000f\u0016$H/\u001b8h\u0013:LG/[1mSj,G\rK\u0002B\u0003_\u000ba\u0004^3ti\u000eCWmY6q_&tG\u000fV5feN#\u0018\r^3GC&dWO]3)\u0007\t\u000by+\u0001\u0014uKN$H)\u001a7fi\u0016\fe\u000e\u001a+jKJ\u001cF/\u0019;f\r2,8\u000f[\"p]\u000e,(O]3oGf$B!a\u000e\u0004.!9\u0011q\\\"A\u0002\u0005\u0005\bfB\"\u0002j\u0006e8\u0011\u0007\u0017\u0005\u0003{\fy\u0010K\u0002D\u0005\u0007\t\u0001\u0004^5fe\u0016s\u0017M\u00197fI2{wmQ8na>tWM\u001c;t)\u0011\u0011Yk!\u000f\t\u000f\u0005}G\t1\u0001\u0002b\u0006\u0011\u0012\r\u001d9f]\u0012\u0014VmY8sIN$v\u000eT8h)1\t9da\u0010\u0004B\r\u00153\u0011JB+\u0011\u0015!W\t1\u0001g\u0011\u001d\u0019\u0019%\u0012a\u0001\u0003O\tA\u0002]1sK:$Hj\\4ESJDaaa\u0012F\u0001\u0004y\u0017a\u00039beRLG/[8o\u0013\u0012Dqaa\u0013F\u0001\u0004\u0019i%\u0001\tce>\\WM\u001d+pa&\u001c7\u000b^1ugB!1qJB)\u001b\t\u0011Y*\u0003\u0003\u0004T\tm%\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0011\u0019\u00199&\u0012a\u0001_\u00061R\r\u001f9fGR,GmU3h[\u0016tGo\u001d)fe2{w-\u0001\u0012wKJLg-\u001f*f[\u0006Lg.\u001b8h\u0019><7\u000fV8SK\u000e|g/\u001a:NKR\u0014\u0018n\u0019\u000b\u0007\u0003o\u0019if!\u0019\t\u000f\r}c\t1\u0001\u0002H\u0005i1\u000f]=M_\u001el\u0015M\\1hKJDqaa\u0019G\u0001\u0004\u0019)'\u0001\bfqB,7\r^3e!\u0006\u0014\u0018-\\:\u0011\u000f\r\u001d4Q\u000eB\u0014_6\u00111\u0011\u000e\u0006\u0004\u0007Wb\u0016AC2pY2,7\r^5p]&!1qNB5\u0005\ri\u0015\r]\u0001'm\u0016\u0014\u0018NZ=SK6\f\u0017N\\5oON+w-\\3oiN$vNU3d_Z,'/T3ue&\u001cG\u0003DA\u001c\u0007k\u001a9h!\u001f\u0004|\r-\u0005bBB0\u000f\u0002\u0007\u0011q\t\u0005\b\u0005\u0017;\u0005\u0019\u0001BG\u0011\u0019\u0011)k\u0012a\u0001_\"91QP$A\u0002\r}\u0014aB7pG.l\u0015\r\u001d\t\b\u0007\u0003\u001b9Ia\np\u001b\t\u0019\u0019IC\u0002\u0004\u0006f\f!bY8oGV\u0014(/\u001a8u\u0013\u0011\u0019Iia!\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000fC\u0004\u0004d\u001d\u0003\ra!\u001a\u0002=Y,'/\u001b4z\u0019><'+Z2pm\u0016\u0014X*\u001a;sS\u000e\u001c(+Z7pm\u0016$G\u0003BA\u001c\u0007#Cqaa\u0018I\u0001\u0004\t9%\u0001\fuKN$Hj\\4SK\u000e|g/\u001a:z\u001b\u0016$(/[2tQ\rI\u0015qV\u00017i\u0016\u001cH\u000fT8h%\u0016\u001cwN^3ss6+GO]5dgNCw.\u001e7e\u0005\u0016\u0014V-\\8wK\u0012\fe\r^3s\u0019><'+Z2pm\u0016\u0014X\r\u001a\u0015\u0004\u0015\u0006=\u0016\u0001\r;fgRlU\r\u001e:jGN,\u00050[:u/\",g\u000eT8h\u0013N\u0014Vm\u0019:fCR,GMQ3g_J,G)\u001a7fi&|g\u000eK\u0002L\u0003_\u000b\u0011\u0007^3ti6+GO]5dg\u0006\u0013XMU3n_Z,Gm\u00165f]6{g/\u001b8h\u0007V\u0014(/\u001a8u)>4U\u000f^;sK2{w\rK\u0002M\u0003_\u000b\u0001\u0004^3ti^\u000b\u0017\u000e\u001e$pe\u0006cG\u000eV8D_6\u0004H.\u001a;fQ\ri\u0015qV\u0001\u001ei\u0016\u001cH\u000fT8bI2{wm]'be.,GMR8s\t\u0016dW\r^5p]\"\u001aa*a,\u0002?Q,7\u000f\u001e#va2L7-\u0019;f'\u0016\fX/\u001a8dKRKW.Z'fiJL7\rK\u0002P\u0003_\u000b!\u0005^3ti\u0016C\b/\u001b:fIB\u0013x\u000eZ;dKJ\u001c(+Z:u_J,G-T3ue&\u001c\u0007f\u0001)\u00020\u0006IB/Z:u\u0019>\fG\rT8hg6\u000b'o[3e\u0003N\u001cFO]1zQ\r\t\u0016qV\u0001&i\u0016\u001cH\u000fT8bIN#(/Y=M_\u001e<\u0016\u000e\u001e5D_J\u0014X\u000f\u001d;fI6+G/\u00193bi\u0006D3AUAX\u0001")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;
    private final Metrics metrics;

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1(), new MockConfigRepository(), 1, TierLogComponents$.MODULE$.EMPTY()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
    }

    @AfterEach
    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils.delete((File)this.logDir(), (boolean)false);
        if (this.logManager() != null) {
            this.logManager().liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
                LogManagerTest.$anonfun$tearDown$1(x$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Test
    public void testCreateLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        Assertions.assertEquals((int)1, (int)this.logManager().liveLogDirs().size());
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testHandlingExceptionsDuringShutdown() {
        File logDir1 = TestUtils.tempDirectory(null, null);
        File logDir2 = TestUtils.tempDirectory(null, null);
        Option logManagerForTest = Option$.MODULE$.empty();
        try {
            logManagerForTest = new Some((Object)this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$)), new MockConfigRepository(), 1, TierLogComponents$.MODULE$.EMPTY()));
            Assertions.assertEquals((int)2, (int)((LogManager)logManagerForTest.get()).liveLogDirs().size());
            ((LogManager)logManagerForTest.get()).startup((Set)Predef$.MODULE$.Set().empty());
            LogManager qual$1 = (LogManager)logManagerForTest.get();
            TopicPartition x$1 = new TopicPartition(this.name(), 0);
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            AbstractLog log1 = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            LogManager qual$2 = (LogManager)logManagerForTest.get();
            TopicPartition x$5 = new TopicPartition(this.name(), 1);
            None$ x$6 = None$.MODULE$;
            boolean x$7 = qual$2.getOrCreateLog$default$2();
            boolean x$8 = qual$2.getOrCreateLog$default$3();
            AbstractLog log2 = qual$2.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
            File logFile1 = new File(logDir1, new StringBuilder(2).append(this.name()).append("-0").toString());
            Assertions.assertTrue((boolean)logFile1.exists());
            Assertions.assertTrue((boolean)new File(logDir2, new StringBuilder(2).append(this.name()).append("-1").toString()).exists());
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
            log1.takeProducerSnapshot();
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5());
            log2.takeProducerSnapshot();
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5());
            FileUtils.deleteDirectory((File)logFile1);
            ((LogManager)logManagerForTest.get()).shutdown();
            Assertions.assertFalse((boolean)Files.exists(new File(logDir1, LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
            Assertions.assertTrue((boolean)Files.exists(new File(logDir2, LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
        }
        finally {
            logManagerForTest.foreach((Function1 & Serializable)manager -> {
                LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$1(manager);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete() {
        TopicPartition topicPartition0 = new TopicPartition(this.name(), 0);
        TopicPartition topicPartition1 = new TopicPartition(this.name(), 1);
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        AbstractLog log0 = qual$1.getOrCreateLog(topicPartition0, x$3, x$4, (Option)x$2);
        LogManager qual$2 = this.logManager();
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$2.getOrCreateLog$default$2();
        boolean x$8 = qual$2.getOrCreateLog$default$3();
        AbstractLog log1 = qual$2.getOrCreateLog(topicPartition1, x$7, x$8, (Option)x$6);
        File logFile0 = new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString());
        File logFile1 = new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-1").toString());
        Assertions.assertTrue((boolean)logFile0.exists());
        Assertions.assertTrue((boolean)logFile1.exists());
        log0.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log0.appendAsLeader$default$3(), log0.appendAsLeader$default$4(), log0.appendAsLeader$default$5());
        log0.takeProducerSnapshot();
        log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
        log1.takeProducerSnapshot();
        this.logManager().shutdown();
        Assertions.assertTrue((boolean)Files.deleteIfExists(new File(this.logDir(), LogLoader$.MODULE$.CleanShutdownFile()).toPath()));
        VolatileIntRef loadLogCalled = VolatileIntRef.create((int)0);
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager(this.createLogManager$default$1(), new MockConfigRepository(), 1, TierLogComponents$.MODULE$.EMPTY())));
        ((LogManager)Mockito.doAnswer(invocation -> {
            LogManagerTest.$anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$1(loadLogCalled, invocation);
            return BoxedUnit.UNIT;
        }).when((Object)this.logManager())).loadLog((File)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (LogConfig)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        new Thread(this){
            private final /* synthetic */ LogManagerTest $outer;

            public void run() {
                this.$outer.logManager().startup((Set)Predef$.MODULE$.Set().empty());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }.start();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(loadLogCalled.elem == 1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for only the first log to be loaded");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.logManager().shutdown();
        this.logManager_$eq(null);
        Assertions.assertFalse((boolean)Files.exists(new File(this.logDir(), LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
    }

    @Test
    public void testHadCleanShutdownFlag() {
        Assertions.assertFalse((boolean)this.logManager().hadCleanShutdown());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        this.logManager().shutdown();
        Assertions.assertTrue((boolean)Files.exists(new File(this.logDir(), LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1(), new MockConfigRepository(), 1, TierLogComponents$.MODULE$.EMPTY()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        Assertions.assertTrue((boolean)this.logManager().hadCleanShutdown());
        this.logManager().shutdown();
        Assertions.assertTrue((boolean)Files.exists(new File(this.logDir(), LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.deleteIfExists(new File(this.logDir(), LogLoader$.MODULE$.CleanShutdownFile()).toPath()));
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1(), new MockConfigRepository(), 1, TierLogComponents$.MODULE$.EMPTY()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        Assertions.assertFalse((boolean)this.logManager().hadCleanShutdown());
    }

    @Test
    public void testCreateLogWithInvalidLogDir() {
        .colon.colon dirs = new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)new File("\u0000"), (List)Nil$.MODULE$));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository(), 1, TierLogComponents$.MODULE$.EMPTY()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$3 = None$.MODULE$;
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$1, true, x$4, (Option)x$3);
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testCreateLogWithLogDirFallback() {
        IndexedSeq dirs = (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)x$3 -> LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$1(BoxesRunTime.unboxToInt((Object)x$3))).map((Function1 & Serializable)x$4 -> this.logDir().toPath().resolve((String)x$4).toFile());
        this.logManager().shutdown();
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository(), 1, TierLogComponents$.MODULE$.EMPTY())));
        scala.collection.mutable.Set brokenDirs = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File logDir = (File)invocation.getArgument(0);
            if (brokenDirs.contains((Object)logDir) || brokenDirs.size() < dirs.length() / 2) {
                brokenDirs.add((Object)logDir);
                return new Failure(new Throwable("broken dir"));
            }
            return (Try)invocation.callRealMethod();
        }).when((Object)this.logManager())).createLogDirectory((File)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$32 = None$.MODULE$;
        boolean x$42 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(x$1, true, x$42, (Option)x$32);
        Assertions.assertEquals((int)(dirs.length() / 2), (int)brokenDirs.size());
        Function1 & Serializable containsLogFile = (Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$4(this, dir));
        Assertions.assertEquals((int)1, (int)dirs.count((Function1)containsLogFile), (String)"More than one log file created");
        Assertions.assertFalse((boolean)brokenDirs.exists((Function1)containsLogFile));
    }

    @Test
    public void testGetNonExistentLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log, (String)"No log should be found.");
        Assertions.assertFalse((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
    }

    private void reconfigureMaxSegmentDeletedPerRun(int logDeletionMaxSegmentsPerRun) {
        KafkaConfig oldConfig = LogManagerTest.kafkaConfigWithCleanerConfig$1(Predef$.MODULE$.Integer2int(this.logManager().segmentDeletionThrottlerConfig().configuredDeletionMaxSegmentsPerRun()));
        KafkaConfig newConfig = LogManagerTest.kafkaConfigWithCleanerConfig$1(logDeletionMaxSegmentsPerRun);
        this.logManager().segmentDeletionThrottlerConfig().reconfigure(oldConfig, newConfig);
    }

    @Test
    public void testLogDeletionMaxSegmentsPerRunExpiredSegments() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> {
            byte[] x$52 = "test".getBytes();
            long x$6 = this.time().milliseconds() - (long)this.maxLogAgeMs() - 1L;
            CompressionType x$8 = CompressionType.NONE;
            byte x$9 = 2;
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords(x$52, null, x$8, x$6, x$9);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$1.elem = info.lastOffset();
        });
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.updateHighWatermark(log.logEndOffset());
        int numSegments = log.numberOfSegments();
        this.reconfigureMaxSegmentDeletedPerRun(0);
        log.localLogSegments().foreach((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testLogDeletionMaxSegmentsPerRunExpiredSegments$2(this, x$6)));
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        this.time().sleep(this.logManager().retentionCheckMs() + 1L);
        Assertions.assertEquals((int)numSegments, (int)log.numberOfSegments(), (String)"No segment should be deleted.");
        this.reconfigureMaxSegmentDeletedPerRun(log.numberOfSegments());
        this.time().sleep(this.logManager().retentionCheckMs() + 1L);
        Assertions.assertEquals((int)1, (int)log.numberOfSegments(), (String)"Now there should only be only one segment in the index.");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes(boolean checksumEnabled) {
        this.logManager().shutdown();
        int recordSize = this.createRecords$1().sizeInBytes();
        long tierLocalHotsetMs = 36000L;
        int tierSegmentHotsetRollMinBytes = 5 * recordSize;
        MockConfigRepository configRepository = new MockConfigRepository();
        configRepository.setTopicConfig(this.name(), "segment.bytes", Integer.toString(10 * recordSize));
        configRepository.setTopicConfig(this.name(), "confluent.tier.segment.hotset.roll.min.bytes", Integer.toString(tierSegmentHotsetRollMinBytes));
        configRepository.setTopicConfig(this.name(), "confluent.tier.local.hotset.ms", Long.toString(tierLocalHotsetMs));
        configRepository.setTopicConfig(this.name(), "segment.ms", Long.toString(Long.MAX_VALUE));
        configRepository.setTopicConfig(this.name(), "retention.bytes", Long.toString(Long.MAX_VALUE));
        configRepository.setTopicConfig(this.name(), "confluent.tier.enable", Boolean.toString(true));
        TierLogComponents x$1 = this.tierEnabledLogComponents(checksumEnabled);
        scala.collection.immutable.Seq<File> x$3 = this.createLogManager$default$1();
        int x$4 = 1;
        this.logManager_$eq(this.createLogManager(x$3, configRepository, x$4, x$1));
        LogManager qual$1 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        None$ x$6 = None$.MODULE$;
        boolean x$72 = qual$1.getOrCreateLog$default$2();
        boolean x$8 = qual$1.getOrCreateLog$default$3();
        AbstractLog log1 = qual$1.getOrCreateLog(x$5, x$72, x$8, (Option)x$6);
        LogManager qual$2 = this.logManager();
        TopicPartition x$9 = new TopicPartition(this.name(), 1);
        None$ x$10 = None$.MODULE$;
        boolean x$11 = qual$2.getOrCreateLog$default$2();
        boolean x$12 = qual$2.getOrCreateLog$default$3();
        AbstractLog log2 = qual$2.getOrCreateLog(x$9, x$11, x$12, (Option)x$10);
        log1.assignTopicId(Uuid.randomUuid(), log1.assignTopicId$default$2());
        log2.assignTopicId(Uuid.randomUuid(), log2.assignTopicId$default$2());
        Assertions.assertTrue((boolean)log1.tierPartitionState().isTieringEnabled());
        Assertions.assertTrue((boolean)log2.tierPartitionState().isTieringEnabled());
        new .colon.colon((Object)log1, (List)new .colon.colon((Object)log2, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)log -> {
            log.tierPartitionState().onCatchUpComplete();
            return log.tierPartitionState().append((AbstractTierMetadata)new TierTopicInitLeader((TopicIdPartition)log.topicIdPartition().get(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 25).foreach((Function1 & Serializable)x$7 -> LogManagerTest.$anonfun$testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes$2(this, log1, log2, BoxesRunTime.unboxToInt((Object)x$7)));
        Assertions.assertTrue((log1.numberOfSegments() == 3 ? 1 : 0) != 0, (String)"There should be 3 segments now.");
        Assertions.assertTrue((log2.numberOfSegments() == 3 ? 1 : 0) != 0, (String)"There should be 3 segments now.");
        log1.updateHighWatermark(log1.logEndOffset());
        log2.updateHighWatermark(log2.logEndOffset());
        new .colon.colon((Object)log1, (List)new .colon.colon((Object)log2, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)log -> {
            LogManagerTest.$anonfun$testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes$3(log);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)log1.tieredLogSegments().size());
        Assertions.assertEquals((int)2, (int)log2.tieredLogSegments().size());
        this.reconfigureMaxSegmentDeletedPerRun(1);
        this.time().sleep(tierLocalHotsetMs + 1L);
        this.logManager().cleanupLogsAndMaybeForceRoll();
        Assertions.assertTrue((log1.localLogSegments().size() == 3 && log2.localLogSegments().size() == 4 || log1.localLogSegments().size() == 4 && log2.localLogSegments().size() == 3 ? 1 : 0) != 0, (String)"Should have 1 segment removed from either of the 2 logs");
    }

    @Test
    public void testCleanupExpiredSegments() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$2.elem = info.lastOffset();
        });
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.updateHighWatermark(log.logEndOffset());
        log.localLogSegments().foreach((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCleanupExpiredSegments$2(this, x$9)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assertions.assertEquals((int)1, (int)log.numberOfSegments(), (String)"Now there should only be only one segment in the index.");
        this.time().sleep(log.config().fileDeleteDelayMs + 1L);
        log.localLogSegments().foreach((Function1 & Serializable)s -> {
            s.lazyOffsetIndex().get();
            return (TimeIndex)s.lazyTimeIndex().get();
        });
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        Assertions.assertEquals((int)0, (int)this.readLog((AbstractLog)log, (long)(offset.elem + 1L), (int)1024).records.sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> this.readLog(log, 0L, 1024), () -> "Should get exception from fetching earlier.");
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testCleanupSegmentsToMaintainSize() {
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes();
        this.logManager().shutdown();
        int segmentBytes = 10 * setSize;
        Properties properties = new Properties();
        properties.put("segment.bytes", Integer.toString(segmentBytes));
        properties.put("retention.bytes", Long.toString(50L * (long)setSize + 10L));
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), properties);
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = 1;
        TierLogComponents x$4 = TierLogComponents$.MODULE$.EMPTY();
        this.logManager_$eq(this.createLogManager(x$2, configRepository, x$3, x$4));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$1.getOrCreateLog$default$2();
        boolean x$8 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$10 -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$3.elem = ((LogOffsetMetadata)info.firstOffset().get()).messageOffset;
        });
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertEquals((int)(numMessages * setSize / segmentBytes), (int)log.numberOfSegments(), (String)"Check we have the expected number of segments.");
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertEquals((int)6, (int)log.numberOfSegments(), (String)"Now there should be exactly 6 segments");
        this.time().sleep(log.config().fileDeleteDelayMs + 1L);
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        Assertions.assertEquals((int)0, (int)this.readLog((AbstractLog)log, (long)(offset.elem + 1L), (int)1024).records.sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> this.readLog(log, 0L, 1024));
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        this.testDoesntCleanLogs("compact,delete");
    }

    @Test
    public void testDoesntCleanLogsWithCompactPolicy() {
        this.testDoesntCleanLogs("compact");
    }

    @Test
    public void testDoesntCleanLogsWithFrozenLogStartOffsetState() {
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes();
        this.logManager().shutdown();
        int segmentBytes = 10 * setSize;
        Properties properties = new Properties();
        properties.put("segment.bytes", Integer.toString(segmentBytes));
        properties.put("retention.bytes", Long.toString(50L * (long)setSize + 10L));
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), properties);
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = 1;
        TierLogComponents x$4 = TierLogComponents$.MODULE$.EMPTY();
        this.logManager_$eq(this.createLogManager(x$2, configRepository, x$3, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        spyLogManager.startup((Set)Predef$.MODULE$.Set().empty());
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = spyLogManager.getOrCreateLog$default$2();
        boolean x$8 = spyLogManager.getOrCreateLog$default$3();
        AbstractLog log = spyLogManager.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
        AbstractLog spyLog = (AbstractLog)Mockito.spy((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)spyLog.isFrozenLogStartOffsetState())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        spyLogManager.currentLogs().clear();
        spyLogManager.currentLogs().put((Object)new TopicPartition(this.name(), 0), (Object)spyLog);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$11 -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$4.elem = ((LogOffsetMetadata)info.firstOffset().get()).messageOffset;
        });
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertEquals((int)(numMessages * setSize / segmentBytes), (int)log.numberOfSegments(), (String)"Check we have the expected number of segments.");
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertEquals((int)(numMessages * setSize / segmentBytes), (int)log.numberOfSegments(), (String)"Nothing should have been deleted");
    }

    private void testDoesntCleanLogs(String policy) {
        this.logManager().shutdown();
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), "cleanup.policy", policy);
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = 1;
        TierLogComponents x$4 = TierLogComponents$.MODULE$.EMPTY();
        this.logManager_$eq(this.createLogManager(x$2, configRepository, x$3, x$4));
        LogManager qual$1 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$1.getOrCreateLog$default$2();
        boolean x$8 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$12 -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$5.elem = info.lastOffset();
        });
        int numSegments = log.numberOfSegments();
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.localLogSegments().foreach((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testDoesntCleanLogs$2(this, x$13)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assertions.assertEquals((int)numSegments, (int)log.numberOfSegments(), (String)"number of segments shouldn't have changed");
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), "flush.ms", "1000");
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = 1;
        TierLogComponents x$4 = TierLogComponents$.MODULE$.EMPTY();
        this.logManager_$eq(this.createLogManager(x$2, configRepository, x$3, x$4));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$1.getOrCreateLog$default$2();
        boolean x$8 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
        long lastFlush = log.lastFlushTime();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1 & Serializable)x$14 -> LogManagerTest.$anonfun$testTimeBasedFlush$1(log, BoxesRunTime.unboxToInt((Object)x$14)));
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((lastFlush != log.lastFlushTime() ? 1 : 0) != 0, (String)"Time based flush should have been triggered");
    }

    @Test
    public void testLeastLoadedAssignment() {
        .colon.colon dirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$)));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs, new MockConfigRepository(), 1, TierLogComponents$.MODULE$.EMPTY()));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> {
            LogManager qual$1 = this.logManager();
            TopicPartition x$1 = new TopicPartition("test", partition);
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            Assertions.assertEquals((int)(partition + 1), (int)this.logManager().allLogs().size(), (String)"We should have created the right number of logs");
            Iterable counts = (Iterable)this.logManager().allLogs().groupBy((Function1 & Serializable)x$15 -> x$15.dir().getParent()).values().map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.size()));
            Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0, (String)"Load should balance evenly");
        });
    }

    @Disabled
    @Test
    public void testLoadLogsSkipRemoteIndexCache() {
        File logDir = TestUtils.tempDirectory(null, null);
        new File(logDir, RemoteIndexCache$.MODULE$.DirName()).mkdir();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)logDir, (List)Nil$.MODULE$), new MockConfigRepository(), 1, TierLogComponents$.MODULE$.EMPTY()));
        this.logManager().loadLogs(this.logConfig(), (Map)Map$.MODULE$.empty());
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        Assertions.assertThrows(KafkaException.class, () -> this.createLogManager(this.createLogManager$default$1(), new MockConfigRepository(), 1, TierLogComponents$.MODULE$.EMPTY()));
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)), this.logManager(), this.logDir());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)new File(new StringBuilder(0).append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append(File.separator).toString()), (List)Nil$.MODULE$), new MockConfigRepository(), 1, TierLogComponents$.MODULE$.EMPTY()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)new File("data", this.logDir().getName()).getAbsoluteFile(), (List)Nil$.MODULE$), new MockConfigRepository(), 1, TierLogComponents$.MODULE$.EMPTY()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    private void verifyCheckpointRecovery(scala.collection.immutable.Seq<TopicPartition> topicPartitions, LogManager logManager, File logDir) {
        scala.collection.immutable.Seq logs = (scala.collection.immutable.Seq)topicPartitions.map((Function1 & Serializable)x$17 -> {
            None$ x$2 = None$.MODULE$;
            boolean x$3 = logManager.getOrCreateLog$default$2();
            boolean x$4 = logManager.getOrCreateLog$default$3();
            return logManager.getOrCreateLog(x$17, x$3, x$4, (Option)x$2);
        });
        logs.foreach((Function1 & Serializable)log -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$2(log);
            return BoxedUnit.UNIT;
        });
        logManager.checkpointLogRecoveryOffsets();
        Map checkpoints = new OffsetCheckpointFile(new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile()), null).read();
        ((IterableOnceOps)topicPartitions.zip((IterableOnce)logs)).foreach((Function1 & Serializable)x0$1 -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private LogManager createLogManager(scala.collection.immutable.Seq<File> logDirs, ConfigRepository configRepository, int recoveryThreadsPerDataDir, TierLogComponents tierLogComponents) {
        LogConfig x$1 = this.logConfig();
        MockTime x$4 = this.time();
        Metrics x$5 = this.metrics();
        CleanerConfig x$8 = new CleanerConfig(false);
        SegmentDeletionThrottlerConfig x$9 = new SegmentDeletionThrottlerConfig(){

            public Seq<FileStore> fileStores(Seq<File> logDirs) {
                return (Seq)logDirs.map((Function1 & Serializable)x$32 -> new TestUtils.DeterministicFileStore(TestUtils$.MODULE$.DefaultTotalAvailableBytes(), TestUtils$.MODULE$.DefaultInitialUsableBytes()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fileStores$1(java.io.File )}, serializedLambda);
            }
        };
        MetadataVersion x$10 = MetadataVersion.latest();
        return TestUtils$.MODULE$.createLogManager((Seq<File>)logDirs, x$1, configRepository, x$8, x$4, x$5, x$9, x$10, tierLogComponents, recoveryThreadsPerDataDir);
    }

    private scala.collection.immutable.Seq<File> createLogManager$default$1() {
        return new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$);
    }

    private ConfigRepository createLogManager$default$2() {
        return new MockConfigRepository();
    }

    private int createLogManager$default$3() {
        return 1;
    }

    private TierLogComponents createLogManager$default$4() {
        return TierLogComponents$.MODULE$.EMPTY();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testFileReferencesAfterAsyncDelete(boolean isStray) {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        LogSegment activeSegment = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2).activeSegment();
        String logName = activeSegment.log().file().getName();
        String indexName = activeSegment.offsetIndex().file().getName();
        String timeIndexName = activeSegment.timeIndex().file().getName();
        String txnIndexName = activeSegment.txnIndex().file().getName();
        Object[] indexFilesOnDiskBeforeDelete = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])activeSegment.log().file().getParentFile().listFiles()), (Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$1(x$20)));
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        boolean x$7 = qual$2.asyncDelete$default$2();
        boolean x$8 = qual$2.asyncDelete$default$3();
        Option x$9 = qual$2.asyncDelete$default$5();
        AbstractLog removedLog = (AbstractLog)qual$2.asyncDelete(x$5, x$7, x$8, isStray, x$9).get();
        LogSegment removedSegment = removedLog.activeSegment();
        .colon.colon indexFilesAfterDelete = new .colon.colon((Object)removedSegment.lazyOffsetIndex().file(), (List)new .colon.colon((Object)removedSegment.lazyTimeIndex().file(), (List)new .colon.colon((Object)removedSegment.txnIndex().file(), (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)new File(removedLog.dir(), logName), (Object)removedSegment.log().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), indexName), (Object)removedSegment.lazyOffsetIndex().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), timeIndexName), (Object)removedSegment.lazyTimeIndex().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), txnIndexName), (Object)removedSegment.txnIndex().file());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(indexFilesOnDiskBeforeDelete), arg_0 -> LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2$adapted((scala.collection.immutable.Seq)indexFilesAfterDelete, arg_0));
        if (isStray) {
            this.time().sleep(this.logManager().InitialTaskDelayMs());
            Assertions.assertTrue((boolean)this.logManager().hasStrayLogsToBeDeleted(), (String)"Stray logs deleted too early");
            this.time().sleep(this.logManager().currentDefaultConfig().fileDeleteDelayMs);
            Assertions.assertFalse((boolean)this.logManager().hasStrayLogsToBeDeleted(), (String)"Stray logs not deleted");
            return;
        }
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs deleted too early");
        this.time().sleep(this.logManager().currentDefaultConfig().fileDeleteDelayMs - (long)this.logManager().InitialTaskDelayMs());
        Assertions.assertFalse((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs not deleted");
    }

    @Test
    public void testStrayLogDeletionThrottle() {
        HashMap<String, Integer> logProps = new HashMap<String, Integer>(this.logManager().currentDefaultConfig().originals());
        String topicName = "stray";
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable)i -> LogManagerTest.$anonfun$testStrayLogDeletionThrottle$1(this, topicName, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((int)5, (int)this.logManager().strayLogsToBeDeleted().size());
        logProps.put("confluent.stray.log.max.deletions.per.run", Predef$.MODULE$.int2Integer(1));
        this.logManager().reconfigureDefaultLogConfig(new LogConfig(logProps));
        this.time().sleep(this.logManager().currentDefaultConfig().fileDeleteDelayMs + (long)this.logManager().InitialTaskDelayMs());
        Assertions.assertEquals((int)4, (int)this.logManager().strayLogsToBeDeleted().size());
        this.time().sleep(this.logManager().currentDefaultConfig().fileDeleteDelayMs);
        Assertions.assertEquals((int)3, (int)this.logManager().strayLogsToBeDeleted().size());
        logProps.put("confluent.stray.log.max.deletions.per.run", Predef$.MODULE$.int2Integer(3));
        this.logManager().reconfigureDefaultLogConfig(new LogConfig(logProps));
        this.time().sleep(this.logManager().currentDefaultConfig().fileDeleteDelayMs);
        Assertions.assertFalse((boolean)this.logManager().hasStrayLogsToBeDeleted());
    }

    @Test
    public void testCreateAndDeleteOverlyLongTopic() {
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(253, "x"));
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(invalidTopicName, 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(invalidTopicName, 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        boolean x$8 = qual$2.asyncDelete$default$4();
        Option x$9 = qual$2.asyncDelete$default$5();
        qual$2.asyncDelete(x$5, x$6, x$7, x$8, x$9);
    }

    @Test
    public void testCheckpointForOnlyAffectedLogs() {
        .colon.colon tps = new .colon.colon((Object)new TopicPartition("test-a", 0), (List)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-a", 2), (List)new .colon.colon((Object)new TopicPartition("test-b", 0), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)))));
        scala.collection.immutable.Seq allLogs = (scala.collection.immutable.Seq)tps.map((Function1 & Serializable)x$23 -> {
            LogManager qual$1 = this.logManager();
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            return qual$1.getOrCreateLog(x$23, x$3, x$4, (Option)x$2);
        });
        allLogs.foreach((Function1 & Serializable)log -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$2(log);
            return BoxedUnit.UNIT;
        });
        this.logManager().checkpointRecoveryOffsetsInDir(this.logDir());
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), LogManager$.MODULE$.RecoveryPointCheckpointFile()), null).read();
        ((IterableOnceOps)tps.zip((IterableOnce)allLogs)).foreach((Function1 & Serializable)x0$1 -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private FetchDataInfo readLog(AbstractLog log, long offset, int maxLength) {
        AbstractFetchDataInfo abstractFetchDataInfo = log.read(offset, maxLength, FetchIsolation.LOG_END, true, false);
        if (abstractFetchDataInfo instanceof FetchDataInfo) {
            return (FetchDataInfo)abstractFetchDataInfo;
        }
        throw new IllegalStateException(new StringBuilder(18).append("Unexpected result ").append(abstractFetchDataInfo).toString());
    }

    private int readLog$default$3() {
        return 1024;
    }

    @Test
    public void testTopicConfigChangeUpdatesLogConfig() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = 1;
        TierLogComponents x$4 = TierLogComponents$.MODULE$.EMPTY();
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, x$3, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        MergedLog mockLog = (MergedLog)Mockito.mock(MergedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.topicConfigUpdated(testTopicOne);
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicTwo);
    }

    @Test
    public void testConfigChangeGetsCleanedUp() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = 1;
        TierLogComponents x$4 = TierLogComponents$.MODULE$.EMPTY();
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, x$3, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        TopicPartition testTopicPartition = new TopicPartition("test-topic", 1);
        spyLogManager.initializingLog(testTopicPartition);
        spyLogManager.finishedInitializingLog(testTopicPartition, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicPartition.topic());
    }

    @Test
    public void testBrokerConfigChangeDeliveredToAllLogs() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = 1;
        TierLogComponents x$4 = TierLogComponents$.MODULE$.EMPTY();
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, x$3, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        MergedLog mockLog = (MergedLog)Mockito.mock(MergedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.brokerConfigUpdated();
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicTwo);
    }

    @Test
    public void testTopicConfigChangeStopCleaningIfCompactIsRemoved() {
        this.logManager().shutdown();
        MockConfigRepository x$1 = new MockConfigRepository();
        scala.collection.immutable.Seq<File> x$2 = this.createLogManager$default$1();
        int x$3 = 1;
        TierLogComponents x$4 = TierLogComponents$.MODULE$.EMPTY();
        this.logManager_$eq(this.createLogManager(x$2, x$1, x$3, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        String topic = "topic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Properties oldProperties = new Properties();
        oldProperties.put("cleanup.policy", "compact");
        LogConfig oldLogConfig = LogConfig.fromProps((java.util.Map)this.logConfig().originals(), (Properties)oldProperties);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = spyLogManager.getOrCreateLog$default$2();
        boolean x$8 = spyLogManager.getOrCreateLog$default$3();
        AbstractLog log0 = spyLogManager.getOrCreateLog(tp0, x$7, x$8, (Option)x$6);
        log0.updateConfig(oldLogConfig);
        None$ x$10 = None$.MODULE$;
        boolean x$11 = spyLogManager.getOrCreateLog$default$2();
        boolean x$12 = spyLogManager.getOrCreateLog$default$3();
        AbstractLog log1 = spyLogManager.getOrCreateLog(tp1, x$11, x$12, (Option)x$10);
        log1.updateConfig(oldLogConfig);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractLog[]{log0, log1})), (Object)spyLogManager.logsByTopic(topic).toSet());
        Properties newProperties = new Properties();
        newProperties.put("cleanup.policy", "delete");
        spyLogManager.updateTopicConfig(topic, newProperties);
        Assertions.assertTrue((boolean)log0.config().delete());
        Assertions.assertTrue((boolean)log1.config().delete());
        Assertions.assertFalse((boolean)log0.config().compact());
        Assertions.assertFalse((boolean)log1.config().compact());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).topicConfigUpdated(topic);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp0);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp1);
    }

    @Test
    public void testConfigChangesWithNoLogGettingInitialized() {
        this.logManager().brokerConfigUpdated();
        this.logManager().topicConfigUpdated("test-topic");
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
    }

    @Test
    public void testCheckpointTierStateFailure() {
        File logDir = TestUtils.tempDirectory(null, null);
        TierLogComponents tierLogComponents = this.tierEnabledLogComponents(false);
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tierLogComponents.topicConsumerOpt().get();
        HashMap<Integer, OffsetAndEpoch> proposedPositions = new HashMap<Integer, OffsetAndEpoch>();
        proposedPositions.put(Predef$.MODULE$.int2Integer(0), new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(10))));
        proposedPositions.put(Predef$.MODULE$.int2Integer(1), new OffsetAndEpoch(20L, Optional.of(Predef$.MODULE$.int2Integer(20))));
        Mockito.when((Object)tierTopicConsumer.snapshotPositions()).thenReturn(proposedPositions);
        MockConfigRepository configRepository = new MockConfigRepository();
        configRepository.setTopicConfig(this.name(), "confluent.tier.enable", Boolean.toString(true));
        .colon.colon x$1 = new .colon.colon((Object)logDir, (List)Nil$.MODULE$);
        int x$4 = 1;
        LogManager logManager = (LogManager)Mockito.spy((Object)this.createLogManager((scala.collection.immutable.Seq<File>)x$1, configRepository, x$4, tierLogComponents));
        TierPartitionState okTierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)okTierPartitionState.flush())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        TierPartitionState throwingTierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)throwingTierPartitionState.flush())).thenThrow(new Throwable[]{new IOException("uh oh")});
        AbstractLog okLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)okLog.tierPartitionState()).thenReturn((Object)okTierPartitionState);
        AbstractLog throwingLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)throwingLog.dir()).thenReturn((Object)logDir);
        Mockito.when((Object)throwingLog.tierPartitionState()).thenReturn((Object)throwingTierPartitionState);
        Mockito.when((Object)logManager.allLogs()).thenReturn((Object)new .colon.colon((Object)okLog, (List)new .colon.colon((Object)throwingLog, (List)Nil$.MODULE$)));
        ((LogManager)Mockito.doReturn((Object)new Some((Object)okLog), (Object[])new Object[]{new Some((Object)throwingLog)}).when((Object)logManager)).getLog((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        logManager.tryRunTierStateCheckpoint();
        ((TierTopicConsumer)Mockito.verify((Object)tierTopicConsumer, (VerificationMode)Mockito.never())).writePositions((java.util.Map)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDeleteAndTierStateFlushConcurrency(boolean checksumEnabled) {
        File logDir = TestUtils.tempDirectory(null, null);
        TierLogComponents tierLogComponents = this.tierEnabledLogComponents(checksumEnabled);
        Mockito.when((Object)((TierTopicConsumer)tierLogComponents.topicConsumerOpt().get()).snapshotPositions()).thenReturn(new HashMap());
        MockConfigRepository configRepository = new MockConfigRepository();
        configRepository.setTopicConfig(this.name(), "confluent.tier.enable", Boolean.toString(true));
        .colon.colon x$1 = new .colon.colon((Object)logDir, (List)Nil$.MODULE$);
        int x$4 = 1;
        LogManager logManager = this.createLogManager((scala.collection.immutable.Seq<File>)x$1, configRepository, x$4, tierLogComponents);
        VolatileBooleanRef isDone = VolatileBooleanRef.create((boolean)false);
        VolatileObjectRef exceptionOpt = VolatileObjectRef.create((Object)None$.MODULE$);
        int numPartitions = 50;
        Thread t = new Thread(null, isDone, logManager, exceptionOpt){
            private final VolatileBooleanRef isDone$1;
            private final LogManager logManager$2;
            private final VolatileObjectRef exceptionOpt$1;

            public void run() {
                try {
                    while (!this.isDone$1.elem) {
                        this.logManager$2.tryRunTierStateCheckpoint();
                    }
                }
                catch (Exception e) {
                    this.exceptionOpt$1.elem = new Some((Object)e);
                }
            }
            {
                this.isDone$1 = isDone$1;
                this.logManager$2 = logManager$2;
                this.exceptionOpt$1 = exceptionOpt$1;
            }
        };
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Uuid topicId = Uuid.randomUuid();
            TopicPartition topicPartition = new TopicPartition(this.name(), i);
            TopicIdPartition topicIdPartition = new TopicIdPartition(topicPartition.topic(), CoreUtils$.MODULE$.toJavaUUID(topicId), topicPartition.partition());
            Some x$6 = new Some((Object)topicId);
            boolean x$7 = logManager.getOrCreateLog$default$2();
            boolean x$8 = logManager.getOrCreateLog$default$3();
            AbstractLog log = logManager.getOrCreateLog(topicPartition, x$7, x$8, (Option)x$6);
            log.tierPartitionState().setTopicId(topicIdPartition.topicId());
            TierPartitionState.AppendResult result = log.tierPartitionState().append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, 0, UUID.randomUUID(), 0), new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0))));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)result);
        });
        t.start();
        IndexedSeq allLogs = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable)i -> logManager.asyncDelete(new TopicPartition(this.name(), BoxesRunTime.unboxToInt((Object)i)), logManager.asyncDelete$default$2(), logManager.asyncDelete$default$3(), logManager.asyncDelete$default$4(), logManager.asyncDelete$default$5()));
        isDone.elem = true;
        t.join();
        allLogs.foreach((Function1 & Serializable)x$26 -> {
            LogManagerTest.$anonfun$testDeleteAndTierStateFlushConcurrency$3(x$26);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)logDir, (boolean)false);
        ((Option)exceptionOpt.elem).foreach((Function1 & Serializable)x$27 -> {
            throw x$27;
        });
    }

    private TierLogComponents tierEnabledLogComponents(boolean checksumEnabled) {
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
        TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        TierPartitionStateFactory tierPartitionStateFactory = new TierPartitionStateFactory(true, checksumEnabled, true, TierPartitionStateCleanupConfig.EMPTY, false, -1);
        return new TierLogComponents((Option)new Some((Object)tierTopicConsumer), (Option)new Some((Object)tierObjectStore), tierPartitionStateFactory, (Option)None$.MODULE$);
    }

    private void appendRecordsToLog(MockTime time, File parentLogDir, int partitionId, BrokerTopicStats brokerTopicStats, int expectedSegmentsPerLog) {
        File tpFile = new File(parentLogDir, new StringBuilder(1).append(this.name()).append("-").append(partitionId).toString());
        int segmentBytes = 1024;
        MergedLog log = LogTestUtils$.MODULE$.createLog(tpFile, this.logConfig(), brokerTopicStats, (Scheduler)time.scheduler(), (Time)time, 0L, 0L, 300000, new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs()), Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs(), TierLogComponents$.MODULE$.EMPTY(), new LogDirFailureChannel(10), LogOffsetsListener.NO_OP_OFFSETS_LISTENER, true, (Option<Uuid>)None$.MODULE$, true, new ConcurrentHashMap<String, Object>());
        Assertions.assertTrue((expectedSegmentsPerLog > 0 ? 1 : 0) != 0);
        int numMessages = (int)Math.floor(segmentBytes * expectedSegmentsPerLog / LogManagerTest.createRecord$1(time).sizeInBytes());
        try {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable)x$28 -> log.appendAsLeader(LogManagerTest.createRecord$1(time), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
            Assertions.assertEquals((int)expectedSegmentsPerLog, (int)log.numberOfSegments());
        }
        finally {
            log.close();
        }
    }

    private void verifyRemainingLogsToRecoverMetric(LogManager spyLogManager, Map<String, Object> expectedParams) {
        String logManagerClassName = LogManager.class.getSimpleName();
        ArrayBuffer logMetrics = (ArrayBuffer)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$1(logManagerClassName, x0$1)))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                return (Metric)x0$2._2();
            }
            throw new MatchError(null);
        });
        Assertions.assertEquals((int)expectedParams.size(), (int)logMetrics.size());
        ArgumentCaptor capturedPath = ArgumentCaptor.forClass(String.class);
        int expectedCallTimes = BoxesRunTime.unboxToInt((Object)expectedParams.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)expectedCallTimes))).decNumRemainingLogs((ConcurrentMap)ArgumentMatchers.any(), (String)capturedPath.capture());
        java.util.List paths = capturedPath.getAllValues();
        expectedParams.foreach((Function1 & Serializable)x0$3 -> {
            LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$3(paths, x0$3);
            return BoxedUnit.UNIT;
        });
        logMetrics.foreach((Function1 & Serializable)gauge -> {
            LogManagerTest.$anonfun$verifyRemainingLogsToRecoverMetric$4(gauge);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyRemainingSegmentsToRecoverMetric(LogManager spyLogManager, scala.collection.immutable.Seq<File> logDirs, int recoveryThreadsPerDataDir, ConcurrentHashMap<String, Object> mockMap, Map<String, Object> expectedParams) {
        String logManagerClassName = LogManager.class.getSimpleName();
        ArrayBuffer logSegmentMetrics = (ArrayBuffer)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$1(logManagerClassName, x0$1)))).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                return (Metric)x0$2._2();
            }
            throw new MatchError(null);
        });
        Assertions.assertEquals((int)(recoveryThreadsPerDataDir * logDirs.size()), (int)logSegmentMetrics.size());
        ArgumentCaptor capturedThreadName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor capturedNumRemainingSegments = ArgumentCaptor.forClass(Integer.TYPE);
        int expectedCallTimes = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)expectedParams.values().map((Function1)(JFunction1.mcII.sp & Serializable)num -> num + 1)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ((ConcurrentHashMap)Mockito.verify(mockMap, (VerificationMode)Mockito.times((int)expectedCallTimes))).put(capturedThreadName.capture(), capturedNumRemainingSegments.capture());
        logSegmentMetrics.foreach((Function1 & Serializable)gauge -> {
            LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$4(gauge);
            return BoxedUnit.UNIT;
        });
        java.util.List threadNames = capturedThreadName.getAllValues();
        java.util.List numRemainingSegments = capturedNumRemainingSegments.getAllValues();
        expectedParams.foreach((Function1 & Serializable)x0$3 -> {
            LogManagerTest.$anonfun$verifyRemainingSegmentsToRecoverMetric$5(threadNames, numRemainingSegments, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyLogRecoverMetricsRemoved(LogManager spyLogManager) {
        String spyLogManagerClassName = spyLogManager.getClass().getSimpleName();
        Assertions.assertTrue((boolean)LogManagerTest.logMetrics$1(spyLogManagerClassName).isEmpty());
        Assertions.assertTrue((boolean)((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyLogRecoverMetricsRemoved$2(spyLogManagerClassName, metric)))).isEmpty());
    }

    @Test
    public void testLogRecoveryMetrics() {
        this.logManager().shutdown();
        File logDir1 = TestUtils.tempDirectory(null, null);
        File logDir2 = TestUtils.tempDirectory(null, null);
        .colon.colon logDirs = new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$));
        int recoveryThreadsPerDataDir = 2;
        MockConfigRepository x$3 = new MockConfigRepository();
        TierLogComponents x$4 = TierLogComponents$.MODULE$.EMPTY();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)logDirs, x$3, recoveryThreadsPerDataDir, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        Assertions.assertEquals((int)2, (int)spyLogManager.liveLogDirs().size());
        MockTime mockTime = new MockTime();
        ConcurrentHashMap mockMap = (ConcurrentHashMap)Mockito.mock(ConcurrentHashMap.class);
        BrokerTopicStats mockBrokerTopicStats = (BrokerTopicStats)Mockito.mock(BrokerTopicStats.class);
        Mockito.when((Object)mockBrokerTopicStats.allTopicsStats()).thenReturn((Object)new BrokerTopicMetrics((Option)None$.MODULE$));
        int expectedSegmentsPerLog = 2;
        this.appendRecordsToLog(mockTime, logDir1, 0, mockBrokerTopicStats, expectedSegmentsPerLog);
        this.appendRecordsToLog(mockTime, logDir2, 1, mockBrokerTopicStats, expectedSegmentsPerLog);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File dir = (File)invocation.getArgument(0);
            scala.collection.mutable.Map topicConfigOverrides = (scala.collection.mutable.Map)invocation.getArgument(5);
            TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
            LogConfig config = (LogConfig)topicConfigOverrides.getOrElse((Object)topicPartition.topic(), (Function0 & Serializable)() -> this.logConfig());
            Metrics x$9 = new Metrics();
            ProducerStateManagerConfig x$11 = new ProducerStateManagerConfig(300000);
            int x$12 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
            MockScheduler x$13 = mockTime.scheduler();
            LogDirFailureChannel x$16 = (LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class);
            TierLogComponents x$17 = TierLogComponents$.MODULE$.EMPTY();
            None$ x$19 = None$.MODULE$;
            LogOffsetsListener x$21 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
            None$ x$22 = None$.MODULE$;
            None$ x$24 = None$.MODULE$;
            return MergedLog$.MODULE$.apply(dir, config, 0L, 0L, (Scheduler)x$13, mockBrokerTopicStats, x$9, (Time)mockTime, 300000, x$11, x$12, (Option)x$24, x$16, x$17, false, (Option)x$19, false, x$21, (Option)x$22, (ConcurrentMap)mockMap);
        }).when((Object)spyLogManager)).loadLog((File)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (LogConfig)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.doNothing().when((Object)spyLogManager)).removeLogRecoveryMetrics();
        spyLogManager.startup((Set)Predef$.MODULE$.Set().empty());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).addLogRecoveryMetrics((ConcurrentMap)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).removeLogRecoveryMetrics();
        Map expectedRemainingLogsParams = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir1.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir2.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)1))}));
        this.verifyRemainingLogsToRecoverMetric(spyLogManager, (Map<String, Object>)expectedRemainingLogsParams);
        Map expectedRemainingSegmentsParams = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir1.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)expectedSegmentsPerLog)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logDir2.getAbsolutePath()), (Object)BoxesRunTime.boxToInteger((int)expectedSegmentsPerLog))}));
        this.verifyRemainingSegmentsToRecoverMetric(spyLogManager, (scala.collection.immutable.Seq<File>)logDirs, recoveryThreadsPerDataDir, mockMap, (Map<String, Object>)expectedRemainingSegmentsParams);
    }

    @Test
    public void testLogRecoveryMetricsShouldBeRemovedAfterLogRecovered() {
        this.logManager().shutdown();
        File logDir1 = TestUtils.tempDirectory(null, null);
        File logDir2 = TestUtils.tempDirectory(null, null);
        .colon.colon logDirs = new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$));
        int recoveryThreadsPerDataDir = 2;
        MockConfigRepository x$3 = new MockConfigRepository();
        TierLogComponents x$4 = TierLogComponents$.MODULE$.EMPTY();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)logDirs, x$3, recoveryThreadsPerDataDir, x$4));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        Assertions.assertEquals((int)2, (int)spyLogManager.liveLogDirs().size());
        spyLogManager.startup((Set)Predef$.MODULE$.Set().empty());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).addLogRecoveryMetrics((ConcurrentMap)ArgumentMatchers.any(), (ConcurrentMap)ArgumentMatchers.any());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).removeLogRecoveryMetrics();
        this.verifyLogRecoverMetricsRemoved(spyLogManager);
    }

    @Test
    public void testMetricsExistWhenLogIsRecreatedBeforeDeletion() {
        String topicName = "metric-test";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(tp, x$3, x$4, (Option)x$2);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        LogManager qual$2 = this.logManager();
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        boolean x$8 = qual$2.asyncDelete$default$4();
        Option x$9 = qual$2.asyncDelete$default$5();
        AbstractLog removedLog = (AbstractLog)qual$2.asyncDelete(tp, x$6, x$7, x$8, x$9).get();
        Assertions.assertTrue((boolean)LogManagerTest.logMetrics$2(topicName).isEmpty());
        LogManager qual$3 = this.logManager();
        None$ x$11 = None$.MODULE$;
        boolean x$12 = qual$3.getOrCreateLog$default$2();
        boolean x$13 = qual$3.getOrCreateLog$default$3();
        qual$3.getOrCreateLog(tp, x$12, x$13, (Option)x$11);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        this.time().sleep(this.logConfig().fileDeleteDelayMs + 1L);
        Assertions.assertTrue((boolean)removedLog.localLogSegments().isEmpty());
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
    }

    @Test
    public void testMetricsAreRemovedWhenMovingCurrentToFutureLog() {
        File dir1 = TestUtils.tempDirectory(null, null);
        File dir2 = TestUtils.tempDirectory(null, null);
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)dir1, (List)new .colon.colon((Object)dir2, (List)Nil$.MODULE$)), new MockConfigRepository(), 1, TierLogComponents$.MODULE$.EMPTY()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        String topicName = "future-log";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        this.logManager().maybeUpdatePreferredLogDir(tp, dir1.getAbsolutePath());
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(tp, x$3, x$4, (Option)x$2);
        this.logManager().maybeUpdatePreferredLogDir(tp, dir2.getAbsolutePath());
        LogManager qual$2 = this.logManager();
        None$ x$7 = None$.MODULE$;
        boolean x$8 = qual$2.getOrCreateLog$default$2();
        qual$2.getOrCreateLog(tp, x$8, true, (Option)x$7);
        LogManagerTest.verifyMetrics$2(2, metricTag, topicName);
        this.logManager().replaceCurrentWithFutureLog(tp);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
        Assertions.assertEquals((int)0, (int)LogManagerTest.logMetrics$3(topicName).count((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$3(m))));
        this.time().sleep(this.logConfig().fileDeleteDelayMs + 1L);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
    }

    @Test
    public void testWaitForAllToComplete() {
        IntRef invokedCount = IntRef.create((int)0);
        Future success = (Future)Mockito.mock(Future.class);
        Mockito.when(success.get()).thenAnswer(x$29 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testWaitForAllToComplete$1(invokedCount, x$29)));
        Future failure = (Future)Mockito.mock(Future.class);
        Mockito.when(failure.get()).thenAnswer(x$30 -> {
            ++invokedCount$1.elem;
            throw new RuntimeException();
        });
        IntRef failureCount = IntRef.create((int)0);
        Assertions.assertFalse((new .colon.colon((Object)success, (List)new .colon.colon((Object)failure, (List)Nil$.MODULE$)).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$31 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$3(failureCount, x$31);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)invokedCount.elem);
        Assertions.assertEquals((int)1, (int)failureCount.elem);
        Assertions.assertFalse((new .colon.colon((Object)failure, (List)new .colon.colon((Object)success, (List)Nil$.MODULE$)).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$32 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$4(failureCount, x$32);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)4, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        Assertions.assertTrue((new .colon.colon((Object)success, (List)new .colon.colon((Object)success, (List)Nil$.MODULE$)).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$33 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$5(failureCount, x$33);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)6, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        Assertions.assertFalse((new .colon.colon((Object)failure, (List)new .colon.colon((Object)failure, (List)Nil$.MODULE$)).count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1 & Serializable)x$34 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$6(failureCount, x$34);
            return BoxedUnit.UNIT;
        }, arg_0)) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)8, (int)invokedCount.elem);
        Assertions.assertEquals((int)4, (int)failureCount.elem);
    }

    @Test
    public void testLoadLogsMarkedForDeletion() {
        File deletedLogDir = new File(new StringBuilder(66).append(this.logDir().getAbsolutePath()).append("/lkc-abc12_deletedTopic-0.a23d92df7d364958bb6dbe17829434a2-delete/").toString());
        String topicName = "deletedTopic";
        this.logManager().loadLog(deletedLogDir, false, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), this.logConfig(), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), new ConcurrentHashMap());
        Assertions.assertTrue((boolean)this.logManager().hasLogsToBeDeleted());
        Assertions.assertEquals((int)0, (int)LogManagerTest.logMetrics$4(topicName).size());
    }

    @Test
    public void testDuplicateSequenceTimeMetric() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        AbstractLog log0 = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 1);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$2.getOrCreateLog$default$2();
        boolean x$8 = qual$2.getOrCreateLog$default$3();
        AbstractLog log1 = qual$2.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
        .colon.colon records = new .colon.colon((Object)new SimpleRecord(this.time().milliseconds(), "key".getBytes(), "value".getBytes()), (List)Nil$.MODULE$);
        byte x$13 = 2;
        CompressionType x$14 = CompressionType.NONE;
        long x$15 = 0L;
        int x$16 = -1;
        log0.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, x$13, x$14, 1L, (short)0, 0, x$15, x$16), 0, log0.appendAsLeader$default$3(), log0.appendAsLeader$default$4(), log0.appendAsLeader$default$5());
        this.time().sleep(100L);
        byte x$21 = 2;
        CompressionType x$22 = CompressionType.NONE;
        long x$23 = 0L;
        int x$24 = -1;
        log0.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, x$21, x$22, 1L, (short)0, 0, x$23, x$24), 0, log0.appendAsLeader$default$3(), log0.appendAsLeader$default$4(), log0.appendAsLeader$default$5());
        Assertions.assertEquals((long)100L, (long)this.maxDuplicateSequenceTimeMetric$1());
        Assertions.assertEquals((long)100L, (long)this.avgDuplicateSequenceTimeMetric$1());
        byte x$29 = 2;
        CompressionType x$30 = CompressionType.NONE;
        long x$31 = 0L;
        int x$32 = -1;
        log1.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, x$29, x$30, 1L, (short)0, 0, x$31, x$32), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
        this.time().sleep(100L);
        byte x$37 = 2;
        CompressionType x$38 = CompressionType.NONE;
        long x$39 = 0L;
        int x$40 = -1;
        log1.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, x$37, x$38, 1L, (short)0, 0, x$39, x$40), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
        Assertions.assertEquals((long)200L, (long)this.maxDuplicateSequenceTimeMetric$1());
        Assertions.assertEquals((long)150L, (long)this.avgDuplicateSequenceTimeMetric$1());
    }

    @Test
    public void testExpiredProducersRestoredMetric() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        AbstractLog log0 = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 1);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = qual$2.getOrCreateLog$default$2();
        boolean x$8 = qual$2.getOrCreateLog$default$3();
        AbstractLog log1 = qual$2.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
        LogManager qual$3 = this.logManager();
        TopicPartition x$9 = new TopicPartition(this.name(), 2);
        None$ x$10 = None$.MODULE$;
        boolean x$11 = qual$3.getOrCreateLog$default$2();
        boolean x$12 = qual$3.getOrCreateLog$default$3();
        AbstractLog log2 = qual$3.getOrCreateLog(x$9, x$11, x$12, (Option)x$10);
        .colon.colon records = new .colon.colon((Object)new SimpleRecord(0L, "key".getBytes(), "value".getBytes()), (List)Nil$.MODULE$);
        byte x$17 = 2;
        CompressionType x$18 = CompressionType.NONE;
        long x$19 = 0L;
        int x$20 = -1;
        log0.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, x$17, x$18, 1L, (short)0, 5, x$19, x$20), 0, log0.appendAsLeader$default$3(), log0.appendAsLeader$default$4(), log0.appendAsLeader$default$5());
        Assertions.assertEquals((double)1.0, (double)this.expiredProducersRestoredMetric$1());
        byte x$23 = 2;
        CompressionType x$24 = CompressionType.NONE;
        long x$25 = -1L;
        short x$26 = -1;
        long x$27 = 0L;
        int x$28 = -1;
        log1.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, x$23, x$24, x$25, x$26, 5, x$27, x$28), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
        Assertions.assertEquals((double)1.0, (double)this.expiredProducersRestoredMetric$1());
        byte x$33 = 2;
        CompressionType x$34 = CompressionType.NONE;
        long x$35 = 0L;
        int x$36 = -1;
        log0.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, x$33, x$34, 1L, (short)0, 6, x$35, x$36), 0, log0.appendAsLeader$default$3(), log0.appendAsLeader$default$4(), log0.appendAsLeader$default$5());
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> LogManagerTest.$anonfun$testExpiredProducersRestoredMetric$1(log0, (List)records));
        Assertions.assertEquals((double)1.0, (double)this.expiredProducersRestoredMetric$1());
        this.time().sleep(Defaults$.MODULE$.ProducerIdExpirationMs());
        log0.producerStateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)log0.producerStateManager().activeProducers().isEmpty());
        byte x$49 = 2;
        CompressionType x$50 = CompressionType.NONE;
        long x$51 = 0L;
        int x$52 = -1;
        log0.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, x$49, x$50, 1L, (short)0, 0, x$51, x$52), 0, log0.appendAsLeader$default$3(), log0.appendAsLeader$default$4(), log0.appendAsLeader$default$5());
        Assertions.assertEquals((double)1.0, (double)this.expiredProducersRestoredMetric$1());
        byte x$57 = 2;
        CompressionType x$58 = CompressionType.NONE;
        long x$59 = 0L;
        int x$60 = -1;
        log2.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, x$57, x$58, 1L, (short)1, 0, x$59, x$60), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5());
        Assertions.assertEquals((double)2.0, (double)this.expiredProducersRestoredMetric$1());
    }

    @Test
    public void testLoadLogsMarkedAsStray() {
        File strayLogDir = new File(new StringBuilder(65).append(this.logDir().getAbsolutePath()).append("/lkc-abc12_deletedTopic-0.a23d92df7d364958bb6dbe17829434a2-stray/").toString());
        String topicName = "strayTopic";
        this.logManager().loadLog(strayLogDir, false, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), this.logConfig(), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), new ConcurrentHashMap());
        Assertions.assertTrue((boolean)this.logManager().hasStrayLogsToBeDeleted());
        Assertions.assertEquals((int)0, (int)LogManagerTest.logMetrics$5(topicName).size());
    }

    @Test
    public void testLoadStrayLogWithCorruptedMetadata() {
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
        TopicPartition topicPartition = new TopicPartition(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("a"), 253), 1);
        File strayLogDir = new File(new StringBuilder(2).append(this.logDir().getAbsolutePath()).append("/").append(LocalLog$.MODULE$.logStrayDirName(topicPartition)).append("/").toString());
        strayLogDir.mkdir();
        StrayLogMetadataFile$.MODULE$.createFileWithData(strayLogDir, topicPartition, logDirFailureChannel);
        File strayLogMetadataFile = new File(strayLogDir, "partition.stray");
        Assertions.assertTrue((boolean)strayLogMetadataFile.exists());
        PrintWriter pw = new PrintWriter(strayLogMetadataFile);
        pw.print("aaa");
        pw.close();
        Predef$.MODULE$.print((Object)strayLogDir.getName());
        Assertions.assertThrows(KafkaException.class, () -> this.logManager().loadLog(strayLogDir, false, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), this.logConfig(), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), new ConcurrentHashMap()));
        Utils.delete((File)strayLogDir, (boolean)false);
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$2(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
            LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$1(VolatileIntRef loadLogCalled$1, InvocationOnMock invocation) {
        Thread.sleep(5000L);
        MergedLog cfr_ignored_0 = (MergedLog)invocation.callRealMethod();
        ++loadLogCalled$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$2(VolatileIntRef loadLogCalled$1) {
        return loadLogCalled$1.elem == 1;
    }

    public static final /* synthetic */ String $anonfun$testCleanShutdownFileWhenShutdownCalledBeforeStartupComplete$3() {
        return "Timed out waiting for only the first log to be loaded";
    }

    public static final /* synthetic */ String $anonfun$testCreateLogWithLogDirFallback$1(int x$3) {
        return Integer.toString(x$3);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateLogWithLogDirFallback$4(LogManagerTest $this, File dir) {
        return new File(dir, new StringBuilder(2).append($this.name()).append("-0").toString()).exists();
    }

    private static final KafkaConfig kafkaConfigWithCleanerConfig$1(int logDeletionMaxSegmentsPerRun) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), Integer.toString(logDeletionMaxSegmentsPerRun));
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public static final /* synthetic */ boolean $anonfun$testLogDeletionMaxSegmentsPerRunExpiredSegments$2(LogManagerTest $this, LogSegment x$6) {
        return x$6.log().file().setLastModified($this.time().milliseconds());
    }

    private final MemoryRecords createRecords$1() {
        byte[] x$1 = "test".getBytes();
        long x$2 = this.time().milliseconds() - (long)this.maxLogAgeMs() - 1L;
        CompressionType x$4 = CompressionType.NONE;
        byte x$5 = 2;
        return TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, x$2, x$5);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes$2(LogManagerTest $this, AbstractLog log1$1, AbstractLog log2$1, int x$7) {
        log1$1.appendAsLeader($this.createRecords$1(), 0, log1$1.appendAsLeader$default$3(), log1$1.appendAsLeader$default$4(), log1$1.appendAsLeader$default$5());
        return log2$1.appendAsLeader($this.createRecords$1(), 0, log2$1.appendAsLeader$default$3(), log2$1.appendAsLeader$default$4(), log2$1.appendAsLeader$default$5());
    }

    public static final /* synthetic */ void $anonfun$testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes$4(AbstractLog log$2, LogSegment segment) {
        TierPartitionState.AppendResult appendResult = TierTestUtils$.MODULE$.uploadWithMetadata(log$2.tierPartitionState(), (TopicIdPartition)log$2.topicIdPartition().get(), 0, UUID.randomUUID(), segment.baseOffset(), segment.readNextOffset() - 1L, segment.largestTimestamp(), segment.getFirstBatchTimestamp(), segment.size(), false, true, false, OffsetAndEpoch.EMPTY, TierObjectStore.OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)appendResult);
    }

    public static final /* synthetic */ void $anonfun$testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes$3(AbstractLog log) {
        log.tierableLogSegments().foreach((Function1 & Serializable)segment -> {
            LogManagerTest.$anonfun$testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes$4(log, segment);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testCleanupExpiredSegments$2(LogManagerTest $this, LogSegment x$9) {
        return x$9.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ boolean $anonfun$testDoesntCleanLogs$2(LogManagerTest $this, LogSegment x$13) {
        return x$13.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testTimeBasedFlush$1(AbstractLog log$7, int x$14) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
        return log$7.appendAsLeader(set, 0, log$7.appendAsLeader$default$3(), log$7.appendAsLeader$default$4(), log$7.appendAsLeader$default$5());
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$2(AbstractLog log) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable)x$18 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$4(Map checkpoints$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            AbstractLog log = (AbstractLog)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$1.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            Assertions.assertEquals((Object)log.localLogSegments().headOption().map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToLong((long)x$19.readNextOffset())), (Object)log.oldestProducerSnapshotOffset());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$1(File x$20) {
        return x$20.getName().endsWith("index");
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$3(File fileBeforeDelete$1, File x$21) {
        String string = x$21.getName();
        String string2 = fileBeforeDelete$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testFileReferencesAfterAsyncDelete$2(scala.collection.immutable.Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        Option fileInIndex = indexFilesAfterDelete$1.find((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$3(fileBeforeDelete, x$21)));
        Assertions.assertEquals((Object)new Some((Object)fileBeforeDelete.getName()), (Object)fileInIndex.map((Function1 & Serializable)x$22 -> x$22.getName()), (String)new StringBuilder(51).append("Could not find index file ").append(fileBeforeDelete.getName()).append(" in indexFilesAfterDelete").toString());
        Assertions.assertNotEquals((Object)"File reference was not updated in index", (Object)fileBeforeDelete.getAbsolutePath(), (String)((File)fileInIndex.get()).getAbsolutePath());
    }

    public static final /* synthetic */ Option $anonfun$testStrayLogDeletionThrottle$1(LogManagerTest $this, String topicName$1, int i) {
        TopicPartition topicPartition = new TopicPartition(topicName$1, i);
        LogManager qual$1 = $this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        AbstractLog strayLog = qual$1.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2);
        $this.logManager().addStrayLog(topicPartition, strayLog);
        LogManager qual$2 = $this.logManager();
        boolean x$7 = qual$2.asyncDelete$default$2();
        boolean x$8 = qual$2.asyncDelete$default$3();
        Option x$9 = qual$2.asyncDelete$default$5();
        return qual$2.asyncDelete(topicPartition, x$7, x$8, true, x$9);
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$2(AbstractLog log) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable)x$24 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$4(Map checkpoints$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            AbstractLog log = (AbstractLog)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$2.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            Assertions.assertEquals((Object)log.localLogSegments().headOption().map((Function1 & Serializable)x$25 -> BoxesRunTime.boxToLong((long)x$25.readNextOffset())), (Object)log.oldestProducerSnapshotOffset());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testDeleteAndTierStateFlushConcurrency$3(Option x$26) {
        ((AbstractLog)x$26.get()).close();
    }

    private static final MemoryRecords createRecord$1(MockTime time$1) {
        byte[] x$1 = "test".getBytes();
        long x$2 = time$1.milliseconds();
        CompressionType x$4 = CompressionType.NONE;
        byte x$5 = 2;
        return TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, x$2, x$5);
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemainingLogsToRecoverMetric$1(String logManagerClassName$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metric = (MetricName)x0$1._1();
            String string = metric.getType();
            String string2 = String.valueOf(logManagerClassName$1);
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String string3 = metric.getName();
                String string4 = "remainingLogsToRecover";
                if (string3 != null && string3.equals(string4)) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingLogsToRecoverMetric$3(java.util.List paths$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String path = (String)x0$3._1();
            Assertions.assertEquals((int)x0$3._2$mcI$sp(), (int)Collections.frequency(paths$1, path));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingLogsToRecoverMetric$4(Gauge gauge) {
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemainingSegmentsToRecoverMetric$1(String logManagerClassName$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metric = (MetricName)x0$1._1();
            String string = metric.getType();
            String string2 = String.valueOf(logManagerClassName$2);
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String string3 = metric.getName();
                String string4 = "remainingSegmentsToRecover";
                if (string3 != null && string3.equals(string4)) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingSegmentsToRecoverMetric$4(Gauge gauge) {
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    public static final /* synthetic */ void $anonfun$verifyRemainingSegmentsToRecoverMetric$5(java.util.List threadNames$1, java.util.List numRemainingSegments$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String threadName = (String)x0$3._1();
            IntRef expectedCurRemainingSegments = IntRef.create((int)(x0$3._2$mcI$sp() + 1));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), threadNames$1.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                if (((String)threadNames$1.get(i)).contains(threadName)) {
                    --expectedCurRemainingSegments$1.elem;
                    Assertions.assertEquals((int)expectedCurRemainingSegments$1.elem, (int)BoxesRunTime.unboxToInt(numRemainingSegments$1.get(i)));
                    return;
                }
            });
            Assertions.assertEquals((int)0, (int)expectedCurRemainingSegments.elem);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogRecoverMetricsRemoved$1(String spyLogManagerClassName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$1);
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = metric.getName();
            String string4 = "remainingLogsToRecover";
            if (string3 != null && string3.equals(string4)) {
                return true;
            }
        }
        return false;
    }

    private static final scala.collection.mutable.Set logMetrics$1(String spyLogManagerClassName$1) {
        return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$verifyLogRecoverMetricsRemoved$1(spyLogManagerClassName$1, metric)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogRecoverMetricsRemoved$2(String spyLogManagerClassName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = String.valueOf(spyLogManagerClassName$1);
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = metric.getName();
            String string4 = "remainingSegmentsToRecover";
            if (string3 != null && string3.equals(string4)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(String topicName$2, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$2);
    }

    private static final scala.collection.mutable.Set logMetrics$2(String topicName$2) {
        return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(topicName$2, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(String metricTag$1, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$1));
    }

    private static final void verifyMetrics$1(String metricTag$1, String topicName$2) {
        Assertions.assertEquals((int)LogMetricNames$.MODULE$.allMetricNames().size(), (int)LogManagerTest.logMetrics$2(topicName$2).size());
        LogManagerTest.logMetrics$2(topicName$2).foreach((Function1 & Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(metricTag$1, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(String topicName$3, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$3);
    }

    private static final scala.collection.mutable.Set logMetrics$3(String topicName$3) {
        return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(topicName$3, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(String metricTag$2, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$2));
    }

    private static final void verifyMetrics$2(int logCount, String metricTag$2, String topicName$3) {
        Assertions.assertEquals((int)(LogMetricNames$.MODULE$.allMetricNames().size() * logCount), (int)LogManagerTest.logMetrics$3(topicName$3).size());
        LogManagerTest.logMetrics$3(topicName$3).foreach((Function1 & Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(metricTag$2, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$3(MetricName m) {
        return m.getMBeanName().contains("is-future");
    }

    public static final /* synthetic */ boolean $anonfun$testWaitForAllToComplete$1(IntRef invokedCount$1, InvocationOnMock x$29) {
        ++invokedCount$1.elem;
        return true;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$3(IntRef failureCount$1, Throwable x$31) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$4(IntRef failureCount$1, Throwable x$32) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$5(IntRef failureCount$1, Throwable x$33) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$6(IntRef failureCount$1, Throwable x$34) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$testLoadLogsMarkedForDeletion$1(String topicName$4, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$4);
    }

    private static final scala.collection.mutable.Set logMetrics$4(String topicName$4) {
        return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testLoadLogsMarkedForDeletion$1(topicName$4, metric)));
    }

    private final long maxDuplicateSequenceTimeMetric$1() {
        return TestUtils$.MODULE$.totalMetricValue(this.metrics(), "duplicate-sequence-time-max");
    }

    private final long avgDuplicateSequenceTimeMetric$1() {
        return TestUtils$.MODULE$.totalMetricValue(this.metrics(), "duplicate-sequence-time-avg");
    }

    private final double expiredProducersRestoredMetric$1() {
        return TestUtils$.MODULE$.totalMetricValue(this.metrics(), "expired-producers-restored-total");
    }

    public static final /* synthetic */ void $anonfun$testExpiredProducersRestoredMetric$1(AbstractLog log0$1, List records$1) {
        byte x$41 = 2;
        CompressionType x$42 = CompressionType.NONE;
        long x$43 = 0L;
        int x$44 = -1;
        log0$1.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records$1, x$41, x$42, 1L, (short)0, 9, x$43, x$44), 0, log0$1.appendAsLeader$default$3(), log0$1.appendAsLeader$default$4(), log0$1.appendAsLeader$default$5());
    }

    public static final /* synthetic */ boolean $anonfun$testLoadLogsMarkedAsStray$1(String topicName$5, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$5);
    }

    private static final scala.collection.mutable.Set logMetrics$5(String topicName$5) {
        return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testLoadLogsMarkedAsStray$1(topicName$5, metric)));
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 600000;
        this.logProps().put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        this.logProps().put("segment.index.bytes", Predef$.MODULE$.int2Integer(4096));
        this.logProps().put("retention.ms", Predef$.MODULE$.int2Integer(this.maxLogAgeMs()));
        this.logProps().put("message.timestamp.difference.max.ms", Long.toString(Long.MAX_VALUE));
        this.logProps().put("confluent.stray.log.delete.delay.ms", Predef$.MODULE$.long2Long(60000L));
        this.logConfig = new LogConfig((java.util.Map)this.logProps());
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
        this.metrics = new Metrics();
    }

    public static final /* synthetic */ Object $anonfun$testFileReferencesAfterAsyncDelete$2$adapted(scala.collection.immutable.Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2(indexFilesAfterDelete$1, fileBeforeDelete);
        return BoxedUnit.UNIT;
    }
}

