/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.Optional;
import java.util.UUID;
import kafka.common.FetchedTimestampAndOffset;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.RecordGen$;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.scalacheck.Arbitrary;
import org.scalacheck.Gen;
import org.scalacheck.Gen$;
import org.scalacheck.Prop;
import org.scalacheck.Prop$;
import org.scalacheck.Shrink;
import org.scalacheck.Shrink$;
import org.scalacheck.Test;
import org.scalacheck.util.Buildable$;
import org.scalacheck.util.Pretty;
import org.scalacheck.util.Pretty$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.anyvals.PosInt;
import org.scalactic.anyvals.PosInt$;
import org.scalactic.source.Position;
import org.scalatest.FunSuite;
import org.scalatest.prop.Configuration;
import org.scalatest.prop.Configuration$MaxDiscarded$;
import org.scalatest.prop.Configuration$MaxDiscardedFactor$;
import org.scalatest.prop.Configuration$MaxSize$;
import org.scalatest.prop.Configuration$MinSize$;
import org.scalatest.prop.Configuration$MinSuccessful$;
import org.scalatest.prop.Configuration$PropertyCheckConfig$;
import org.scalatest.prop.Configuration$PropertyCheckConfiguration$;
import org.scalatest.prop.Configuration$SizeRange$;
import org.scalatest.prop.Configuration$Workers$;
import org.scalatestplus.scalacheck.CheckerAsserting;
import org.scalatestplus.scalacheck.CheckerAsserting$;
import org.scalatestplus.scalacheck.Checkers;
import org.scalatestplus.scalacheck.ScalaCheckConfiguration;
import org.scalatestplus.scalacheck.ScalaCheckConfiguration$InternalPropertyCheckConfiguration$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.Function6;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@Tag(value="propertybased")
@ScalaSignature(bytes="\u0006\u0005e3Aa\u0002\u0005\u0001\u001b!)a\u0004\u0001C\u0001?!9!\u0005\u0001b\u0001\n\u0007\u001a\u0003B\u0002\u0017\u0001A\u0003%A\u0005C\u0003.\u0001\u0011\u0005a\u0006C\u0003@\u0001\u0011\u0005\u0001\tC\u0003C\u0001\u0011\u00051I\u0001\fM_\u001e\u001cVmZ7f]R\u0004&o\u001c9feRLH+Z:u\u0015\tI!\"A\u0002m_\u001eT\u0011aC\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001aB\u0006\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003M\t1a\u001c:h\u0013\t)\u0002C\u0001\u0005Gk:\u001cV/\u001b;f!\t9B$D\u0001\u0019\u0015\tI\"$\u0001\u0006tG\u0006d\u0017m\u00195fG.T!a\u0007\n\u0002\u001bM\u001c\u0017\r\\1uKN$\b\u000f\\;t\u0013\ti\u0002D\u0001\u0005DQ\u0016\u001c7.\u001a:t\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\"\u00015\t\u0001\"A\u000bhK:,'/\u0019;pe\u0012\u0013\u0018N^3o\u0007>tg-[4\u0016\u0003\u0011\u0002\"!\n\u0014\u000e\u0003\u0001I!a\n\u0015\u00035A\u0013x\u000e]3sif\u001c\u0005.Z2l\u0007>tg-[4ve\u0006$\u0018n\u001c8\n\u0005%R#!D\"p]\u001aLw-\u001e:bi&|gN\u0003\u0002,!\u0005!\u0001O]8q\u0003Y9WM\\3sCR|'\u000f\u0012:jm\u0016t7i\u001c8gS\u001e\u0004\u0013!\u00045bg\u0006cGNU3d_J$7\u000fF\u00020ki\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012qAQ8pY\u0016\fg\u000eC\u00037\t\u0001\u0007q'A\u0004tK\u001elWM\u001c;\u0011\u0005\u0005B\u0014BA\u001d\t\u0005)aunZ*fO6,g\u000e\u001e\u0005\u0006w\u0011\u0001\r\u0001P\u0001\te\u0016\fGmU5{KB\u0011\u0001'P\u0005\u0003}E\u00121!\u00138u\u0003Iawn\\6va&sG-\u001b<jIV\fG\u000e\\=\u0015\u0005=\n\u0005\"\u0002\u001c\u0006\u0001\u00049\u0014A\u00067pON+w-\\3oiB\u0013x\u000e]3sif$Vm\u001d;\u0015\u0003\u0011\u0003\"\u0001M#\n\u0005\u0019\u000b$\u0001B+oSRD#A\u0002%\u0011\u0005%\u0003V\"\u0001&\u000b\u0005-c\u0015aA1qS*\u0011QJT\u0001\bUV\u0004\u0018\u000e^3s\u0015\ty%#A\u0003kk:LG/\u0003\u0002R\u0015\n!A+Z:uQ\u0011\u00011KV,\u0011\u0005%#\u0016BA+K\u0005\r!\u0016mZ\u0001\u0006m\u0006dW/Z\u0011\u00021\u0006i\u0001O]8qKJ$\u0018PY1tK\u0012\u0004")
public class LogSegmentPropertyTest
extends FunSuite
implements Checkers {
    private final Configuration.PropertyCheckConfiguration generatorDrivenConfig;
    private volatile ScalaCheckConfiguration$InternalPropertyCheckConfiguration$ InternalPropertyCheckConfiguration$module;
    private volatile Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration$module;
    private volatile Configuration$PropertyCheckConfig$ PropertyCheckConfig$module;
    private volatile Configuration$MinSuccessful$ MinSuccessful$module;
    private volatile Configuration$MaxDiscarded$ MaxDiscarded$module;
    private volatile Configuration$MaxDiscardedFactor$ MaxDiscardedFactor$module;
    private volatile Configuration$MinSize$ MinSize$module;
    private volatile Configuration$MaxSize$ MaxSize$module;
    private volatile Configuration$SizeRange$ SizeRange$module;
    private volatile Configuration$Workers$ Workers$module;

    public <A1, P, ASSERTION> Object check(Function1<A1, P> f, Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, Function1<P, Prop> p, Arbitrary<A1> a1, Shrink<A1> s1, Function1<A1, Pretty> pp1, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, f, configParams, (Configuration.PropertyCheckConfigurable)config, p, a1, s1, pp1, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A1, A2, P, ASSERTION> Object check(Function2<A1, A2, P> f, Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, Function1<P, Prop> p, Arbitrary<A1> a1, Shrink<A1> s1, Function1<A1, Pretty> pp1, Arbitrary<A2> a2, Shrink<A2> s2, Function1<A2, Pretty> pp2, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, f, configParams, (Configuration.PropertyCheckConfigurable)config, p, a1, s1, pp1, a2, s2, pp2, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A1, A2, A3, P, ASSERTION> Object check(Function3<A1, A2, A3, P> f, Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, Function1<P, Prop> p, Arbitrary<A1> a1, Shrink<A1> s1, Function1<A1, Pretty> pp1, Arbitrary<A2> a2, Shrink<A2> s2, Function1<A2, Pretty> pp2, Arbitrary<A3> a3, Shrink<A3> s3, Function1<A3, Pretty> pp3, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, f, configParams, (Configuration.PropertyCheckConfigurable)config, p, a1, s1, pp1, a2, s2, pp2, a3, s3, pp3, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A1, A2, A3, A4, P, ASSERTION> Object check(Function4<A1, A2, A3, A4, P> f, Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, Function1<P, Prop> p, Arbitrary<A1> a1, Shrink<A1> s1, Function1<A1, Pretty> pp1, Arbitrary<A2> a2, Shrink<A2> s2, Function1<A2, Pretty> pp2, Arbitrary<A3> a3, Shrink<A3> s3, Function1<A3, Pretty> pp3, Arbitrary<A4> a4, Shrink<A4> s4, Function1<A4, Pretty> pp4, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, f, configParams, (Configuration.PropertyCheckConfigurable)config, p, a1, s1, pp1, a2, s2, pp2, a3, s3, pp3, a4, s4, pp4, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A1, A2, A3, A4, A5, P, ASSERTION> Object check(Function5<A1, A2, A3, A4, A5, P> f, Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, Function1<P, Prop> p, Arbitrary<A1> a1, Shrink<A1> s1, Function1<A1, Pretty> pp1, Arbitrary<A2> a2, Shrink<A2> s2, Function1<A2, Pretty> pp2, Arbitrary<A3> a3, Shrink<A3> s3, Function1<A3, Pretty> pp3, Arbitrary<A4> a4, Shrink<A4> s4, Function1<A4, Pretty> pp4, Arbitrary<A5> a5, Shrink<A5> s5, Function1<A5, Pretty> pp5, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, f, configParams, (Configuration.PropertyCheckConfigurable)config, p, a1, s1, pp1, a2, s2, pp2, a3, s3, pp3, a4, s4, pp4, a5, s5, pp5, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A1, A2, A3, A4, A5, A6, P, ASSERTION> Object check(Function6<A1, A2, A3, A4, A5, A6, P> f, Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, Function1<P, Prop> p, Arbitrary<A1> a1, Shrink<A1> s1, Function1<A1, Pretty> pp1, Arbitrary<A2> a2, Shrink<A2> s2, Function1<A2, Pretty> pp2, Arbitrary<A3> a3, Shrink<A3> s3, Function1<A3, Pretty> pp3, Arbitrary<A4> a4, Shrink<A4> s4, Function1<A4, Pretty> pp4, Arbitrary<A5> a5, Shrink<A5> s5, Function1<A5, Pretty> pp5, Arbitrary<A6> a6, Shrink<A6> s6, Function1<A6, Pretty> pp6, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, f, configParams, (Configuration.PropertyCheckConfigurable)config, p, a1, s1, pp1, a2, s2, pp2, a3, s3, pp3, a4, s4, pp4, a5, s5, pp5, a6, s6, pp6, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <ASSERTION> Object check(Prop p, Test.Parameters prms, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, (Prop)p, (Test.Parameters)prms, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <ASSERTION> Object check(Prop p, Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, (Prop)p, configParams, (Configuration.PropertyCheckConfigurable)config, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public Configuration.PropertyCheckConfiguration PropertyCheckConfig2PropertyCheckConfiguration(Configuration.PropertyCheckConfig p) {
        return ScalaCheckConfiguration.PropertyCheckConfig2PropertyCheckConfiguration$((ScalaCheckConfiguration)this, (Configuration.PropertyCheckConfig)p);
    }

    public Test.Parameters getParams(Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable c) {
        return ScalaCheckConfiguration.getParams$((ScalaCheckConfiguration)this, configParams, (Configuration.PropertyCheckConfigurable)c);
    }

    public Configuration.MinSuccessful minSuccessful(int value) {
        return Configuration.minSuccessful$((Configuration)this, (int)value);
    }

    public Configuration.MaxDiscarded maxDiscarded(int value) {
        return Configuration.maxDiscarded$((Configuration)this, (int)value);
    }

    public Configuration.MaxDiscardedFactor maxDiscardedFactor(double value) {
        return Configuration.maxDiscardedFactor$((Configuration)this, (double)value);
    }

    public Configuration.MinSize minSize(int value) {
        return Configuration.minSize$((Configuration)this, (int)value);
    }

    public Configuration.MaxSize maxSize(int value) {
        return Configuration.maxSize$((Configuration)this, (int)value);
    }

    public Configuration.SizeRange sizeRange(int value) {
        return Configuration.sizeRange$((Configuration)this, (int)value);
    }

    public Configuration.Workers workers(int value) {
        return Configuration.workers$((Configuration)this, (int)value);
    }

    public ScalaCheckConfiguration$InternalPropertyCheckConfiguration$ org$scalatestplus$scalacheck$ScalaCheckConfiguration$$InternalPropertyCheckConfiguration() {
        if (this.InternalPropertyCheckConfiguration$module == null) {
            this.org$scalatestplus$scalacheck$ScalaCheckConfiguration$$InternalPropertyCheckConfiguration$lzycompute$1();
        }
        return this.InternalPropertyCheckConfiguration$module;
    }

    public Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration() {
        if (this.PropertyCheckConfiguration$module == null) {
            this.PropertyCheckConfiguration$lzycompute$1();
        }
        return this.PropertyCheckConfiguration$module;
    }

    public Configuration$PropertyCheckConfig$ PropertyCheckConfig() {
        if (this.PropertyCheckConfig$module == null) {
            this.PropertyCheckConfig$lzycompute$1();
        }
        return this.PropertyCheckConfig$module;
    }

    public Configuration$MinSuccessful$ MinSuccessful() {
        if (this.MinSuccessful$module == null) {
            this.MinSuccessful$lzycompute$1();
        }
        return this.MinSuccessful$module;
    }

    public Configuration$MaxDiscarded$ MaxDiscarded() {
        if (this.MaxDiscarded$module == null) {
            this.MaxDiscarded$lzycompute$1();
        }
        return this.MaxDiscarded$module;
    }

    public Configuration$MaxDiscardedFactor$ MaxDiscardedFactor() {
        if (this.MaxDiscardedFactor$module == null) {
            this.MaxDiscardedFactor$lzycompute$1();
        }
        return this.MaxDiscardedFactor$module;
    }

    public Configuration$MinSize$ MinSize() {
        if (this.MinSize$module == null) {
            this.MinSize$lzycompute$1();
        }
        return this.MinSize$module;
    }

    public Configuration$MaxSize$ MaxSize() {
        if (this.MaxSize$module == null) {
            this.MaxSize$lzycompute$1();
        }
        return this.MaxSize$module;
    }

    public Configuration$SizeRange$ SizeRange() {
        if (this.SizeRange$module == null) {
            this.SizeRange$lzycompute$1();
        }
        return this.SizeRange$module;
    }

    public Configuration$Workers$ Workers() {
        if (this.Workers$module == null) {
            this.Workers$lzycompute$1();
        }
        return this.Workers$module;
    }

    public void org$scalatest$prop$Configuration$_setter_$generatorDrivenConfig_$eq(Configuration.PropertyCheckConfiguration x$1) {
    }

    public Configuration.PropertyCheckConfiguration generatorDrivenConfig() {
        return this.generatorDrivenConfig;
    }

    public boolean hasAllRecords(LogSegment segment, int readSize) {
        LongRef readOffset = LongRef.create((long)segment.baseOffset());
        ObjectRef readOffsets = ObjectRef.create((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        while (readOffset.elem <= segment.readNextOffset() - 1L) {
            long x$12 = readOffset.elem;
            long x$4 = segment.read$default$3();
            FetchDataInfo read = segment.read(x$12, readSize, x$4, true);
            read.records.batches().forEach(x$1 -> x$1.ensureValid());
            long readOffsetBefore = readOffset.elem;
            CollectionConverters$.MODULE$.IterableHasAsScala(read.records.records()).asScala().foreach((Function1 & Serializable)rec -> {
                LogSegmentPropertyTest.$anonfun$hasAllRecords$2(readOffsets, readOffset, rec);
                return BoxedUnit.UNIT;
            });
            long $org_scalatest_assert_macro_right = readOffset.elem;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)readOffsetBefore), "!=", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), readOffsetBefore != $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogSegmentPropertyTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        }
        return (long)((Set)readOffsets.elem).size() == segment.readNextOffset() - segment.baseOffset();
    }

    public boolean lookupIndividually(LogSegment segment) {
        LongRef fetchOffset = LongRef.create((long)segment.baseOffset());
        while (fetchOffset.elem <= segment.readNextOffset() - 1L) {
            long x$1 = fetchOffset.elem;
            long x$4 = segment.read$default$3();
            FetchDataInfo read = segment.read(x$1, 1, x$4, true);
            CollectionConverters$.MODULE$.IterableHasAsScala(read.records.records()).asScala().foreach((Function1 & Serializable)rec -> {
                long $org_scalatest_assert_macro_left = rec.offset();
                long $org_scalatest_assert_macro_right = Math.max(segment.baseOffset(), 0L);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogSegmentPropertyTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            });
            if (CollectionConverters$.MODULE$.IterableHasAsScala(read.records.batches()).asScala().isEmpty()) {
                return false;
            }
            Option option = CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(read.records.batches()).asScala().head()).asScala().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogSegmentPropertyTest.$anonfun$lookupIndividually$2(fetchOffset, x$2)));
            if (option instanceof Some) {
                Record rec2 = (Record)((Some)option).value();
                Option offsetForTimestampOpt = segment.findOffsetByTimestamp(rec2.timestamp(), segment.findOffsetByTimestamp$default$2());
                if (offsetForTimestampOpt instanceof Some && ((FetchedTimestampAndOffset)((Some)offsetForTimestampOpt).value()).offset() > fetchOffset.elem) {
                    return false;
                }
                if (None$.MODULE$.equals(offsetForTimestampOpt)) {
                    return false;
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    return false;
                }
                throw new MatchError((Object)option);
            }
            ++fetchOffset.elem;
        }
        return true;
    }

    @Test
    public void logSegmentPropertyTest() {
        this.check(Prop$.MODULE$.forAll(Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)10000), (Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()), Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1000), (Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()), Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1000), (Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()), Gen$.MODULE$.resize(20, Gen$.MODULE$.nonEmptyListOf((Function0 & Serializable)() -> Gen$.MODULE$.nonEmptyListOf((Function0 & Serializable)() -> {
            boolean x$4 = false;
            long x$5 = -1L;
            short x$6 = -1;
            int x$7 = -1;
            int x$8 = -1;
            boolean x$9 = false;
            int x$10 = 5;
            int x$11 = 20;
            return RecordGen$.MODULE$.genRecordBatch(0L, Long.MAX_VALUE, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, (byte)2);
        }))), Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToByte((byte)-128), (Object)BoxesRunTime.boxToByte((byte)127), (Seq)Nil$.MODULE$, (Numeric)Numeric.ByteIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseByte()).suchThat((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogSegmentPropertyTest.$anonfun$logSegmentPropertyTest$3(BoxesRunTime.unboxToByte((Object)x$3)))), (Function5 & Serializable)(readSize, indexInterval, logSegmentBaseOffset, batchesOfBatches, corruptionByte) -> BoxesRunTime.boxToBoolean((boolean)LogSegmentPropertyTest.$anonfun$logSegmentPropertyTest$4(this, BoxesRunTime.unboxToInt((Object)readSize), BoxesRunTime.unboxToInt((Object)indexInterval), BoxesRunTime.unboxToInt((Object)logSegmentBaseOffset), batchesOfBatches, BoxesRunTime.unboxToByte((Object)corruptionByte))), (Function1 & Serializable)b -> Prop$.MODULE$.propBoolean(BoxesRunTime.unboxToBoolean((Object)b)), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.IntIsIntegral$.MODULE$), (Function1 & Serializable)t -> Pretty$.MODULE$.prettyAny(t), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.IntIsIntegral$.MODULE$), (Function1 & Serializable)t -> Pretty$.MODULE$.prettyAny(t), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.IntIsIntegral$.MODULE$), (Function1 & Serializable)t -> Pretty$.MODULE$.prettyAny(t), Shrink$.MODULE$.shrinkContainer(Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkContainer(Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkAny(), Buildable$.MODULE$.buildableFactory(List$.MODULE$.iterableFactory())), Buildable$.MODULE$.buildableFactory(List$.MODULE$.iterableFactory())), (Function1 & Serializable)l -> Pretty$.MODULE$.prettyList(l), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.ByteIsIntegral$.MODULE$), (Function1 & Serializable)t -> Pretty$.MODULE$.prettyAny(t)).viewSeed("testLogSegmentPropertyTest"), (Seq<Configuration.PropertyCheckConfigParam>)Nil$.MODULE$, (Configuration.PropertyCheckConfigurable)this.generatorDrivenConfig(), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("LogSegmentPropertyTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
    }

    private final void org$scalatestplus$scalacheck$ScalaCheckConfiguration$$InternalPropertyCheckConfiguration$lzycompute$1() {
        synchronized (this) {
            if (this.InternalPropertyCheckConfiguration$module == null) {
                this.InternalPropertyCheckConfiguration$module = new ScalaCheckConfiguration$InternalPropertyCheckConfiguration$((ScalaCheckConfiguration)this);
            }
            return;
        }
    }

    private final void PropertyCheckConfiguration$lzycompute$1() {
        synchronized (this) {
            if (this.PropertyCheckConfiguration$module == null) {
                this.PropertyCheckConfiguration$module = new Configuration$PropertyCheckConfiguration$((Configuration)this);
            }
            return;
        }
    }

    private final void PropertyCheckConfig$lzycompute$1() {
        synchronized (this) {
            if (this.PropertyCheckConfig$module == null) {
                this.PropertyCheckConfig$module = new Configuration$PropertyCheckConfig$((Configuration)this);
            }
            return;
        }
    }

    private final void MinSuccessful$lzycompute$1() {
        synchronized (this) {
            if (this.MinSuccessful$module == null) {
                this.MinSuccessful$module = new Configuration$MinSuccessful$((Configuration)this);
            }
            return;
        }
    }

    private final void MaxDiscarded$lzycompute$1() {
        synchronized (this) {
            if (this.MaxDiscarded$module == null) {
                this.MaxDiscarded$module = new Configuration$MaxDiscarded$((Configuration)this);
            }
            return;
        }
    }

    private final void MaxDiscardedFactor$lzycompute$1() {
        synchronized (this) {
            if (this.MaxDiscardedFactor$module == null) {
                this.MaxDiscardedFactor$module = new Configuration$MaxDiscardedFactor$((Configuration)this);
            }
            return;
        }
    }

    private final void MinSize$lzycompute$1() {
        synchronized (this) {
            if (this.MinSize$module == null) {
                this.MinSize$module = new Configuration$MinSize$((Configuration)this);
            }
            return;
        }
    }

    private final void MaxSize$lzycompute$1() {
        synchronized (this) {
            if (this.MaxSize$module == null) {
                this.MaxSize$module = new Configuration$MaxSize$((Configuration)this);
            }
            return;
        }
    }

    private final void SizeRange$lzycompute$1() {
        synchronized (this) {
            if (this.SizeRange$module == null) {
                this.SizeRange$module = new Configuration$SizeRange$((Configuration)this);
            }
            return;
        }
    }

    private final void Workers$lzycompute$1() {
        synchronized (this) {
            if (this.Workers$module == null) {
                this.Workers$module = new Configuration$Workers$((Configuration)this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$hasAllRecords$2(ObjectRef readOffsets$1, LongRef readOffset$1, Record rec) {
        readOffsets$1.elem = (Set)((Set)readOffsets$1.elem).$plus((Object)BoxesRunTime.boxToLong((long)rec.offset()));
        readOffset$1.elem = rec.offset() + 1L;
    }

    public static final /* synthetic */ boolean $anonfun$lookupIndividually$2(LongRef fetchOffset$1, Record x$2) {
        return x$2.offset() == fetchOffset$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$logSegmentPropertyTest$3(byte x$3) {
        return x$3 != 0;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$logSegmentPropertyTest$6(LongRef lastOffset$1, ByteBufferChannel channel$1, ObjectRef batchAlignment$1, ObjectRef segment$2, ByteBuffer buffer$1, MemoryRecords memoryRecords) {
        void withRecords_compressionType;
        void withRecords_initialOffset;
        MutableRecordBatch batch = (MutableRecordBatch)CollectionConverters$.MODULE$.IterableHasAsScala(memoryRecords.batches()).asScala().head();
        int maxRecords = batch.magic() < 2 ? 1 : Integer.MAX_VALUE;
        SimpleRecord[] withOffsets = (SimpleRecord[])((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.IterableHasAsScala(memoryRecords.records()).asScala().map((Function1 & Serializable)rec -> new SimpleRecord(rec.timestamp(), rec.key(), rec.value()))).take(maxRecords)).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType compressionType = CompressionType.NONE;
        long l = lastOffset$1.elem;
        byte withRecords_magic = batch.magic();
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var14_12 = null;
        compressionType = null;
        MemoryRecords recordsNew = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withOffsets);
        lastOffset$1.elem += (long)withOffsets.length;
        recordsNew.writeFullyTo((GatheringByteChannel)channel$1);
        batchAlignment$1.elem = (Set)((Set)batchAlignment$1.elem).$plus((Object)BoxesRunTime.boxToLong((long)(((LogSegment)segment$2.elem).log().channel().size() + (long)buffer$1.position())));
    }

    public static final /* synthetic */ void $anonfun$logSegmentPropertyTest$5(ByteBuffer buffer$1, LongRef lastOffset$1, ByteBufferChannel channel$1, ObjectRef batchAlignment$1, ObjectRef segment$2, List appends) {
        buffer$1.clear();
        appends.foreach((Function1 & Serializable)memoryRecords -> {
            LogSegmentPropertyTest.$anonfun$logSegmentPropertyTest$6(lastOffset$1, channel$1, batchAlignment$1, segment$2, buffer$1, memoryRecords);
            return BoxedUnit.UNIT;
        });
        buffer$1.flip();
        ((LogSegment)segment$2.elem).append(lastOffset$1.elem, new MemoryRecords(buffer$1));
    }

    public static final /* synthetic */ boolean $anonfun$logSegmentPropertyTest$4(LogSegmentPropertyTest $this, int readSize, int indexInterval, int logSegmentBaseOffset, List batchesOfBatches, byte corruptionByte) {
        boolean bl;
        File baseDir = TestUtils.tempDirectory(null, null);
        File segmentDir = new File(new StringBuilder(1).append(baseDir.getParent()).append("/").append(UUID.randomUUID().toString()).toString());
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        segmentDir.mkdir();
        ObjectRef segment = ObjectRef.create((Object)LogTestUtils$.MODULE$.createSegment(logSegmentBaseOffset, segmentDir, indexInterval, (Time)new MockTime(), false));
        try {
            LongRef lastOffset = LongRef.create((long)((LogSegment)segment.elem).readNextOffset());
            ByteBufferChannel channel = new ByteBufferChannel(1000000L);
            ObjectRef batchAlignment = ObjectRef.create((Object)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L}))));
            ByteBuffer buffer = channel.buffer();
            batchesOfBatches.foreach((Function1 & Serializable)appends -> {
                LogSegmentPropertyTest.$anonfun$logSegmentPropertyTest$5(buffer, lastOffset, channel, batchAlignment, segment, appends);
                return BoxedUnit.UNIT;
            });
            boolean hasAllBefore = $this.hasAllRecords((LogSegment)segment.elem, readSize);
            boolean individuallyBefore = $this.lookupIndividually((LogSegment)segment.elem);
            int numTimeIndexEntries = ((LogSegment)segment.elem).timeIndex().entries();
            int numOffsetIndexEntries = ((LogSegment)segment.elem).offsetIndex().entries();
            MockTime time = new MockTime();
            ((LogSegment)segment.elem).close();
            segment.elem = LogTestUtils$.MODULE$.createSegment(logSegmentBaseOffset, segmentDir, indexInterval, (Time)time, true);
            ProducerStateManager stateManager = new ProducerStateManager(topicPartition, segmentDir, 300000, new ProducerStateManagerConfig(3600000), (Time)time, Optional.empty());
            ((LogSegment)segment.elem).recover(stateManager, (Option)None$.MODULE$);
            boolean hasAllAfter = $this.hasAllRecords((LogSegment)segment.elem, readSize);
            boolean correctAfterReload = hasAllBefore && hasAllAfter && (((LogSegment)segment.elem).timeIndex().entries() == numTimeIndexEntries || ((LogSegment)segment.elem).timeIndex().entries() - 1 == numTimeIndexEntries) && ((LogSegment)segment.elem).offsetIndex().entries() == numOffsetIndexEntries && individuallyBefore && $this.lookupIndividually((LogSegment)segment.elem);
            ByteBuffer corruptionBuffer = ByteBuffer.allocate(62);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), corruptionBuffer.limit()).foreach((Function1 & Serializable)i -> corruptionBuffer.put(BoxesRunTime.unboxToInt((Object)i), corruptionByte));
            long corruptionPoint = ((LogSegment)segment.elem).log().channel().size() / 2L;
            ((LogSegment)segment.elem).log().channel().write(corruptionBuffer, corruptionPoint);
            ((LogSegment)segment.elem).close();
            segment.elem = LogTestUtils$.MODULE$.createSegment(logSegmentBaseOffset, segmentDir, indexInterval, (Time)new MockTime(), true);
            ProducerStateManager stateManager2 = new ProducerStateManager(topicPartition, segmentDir, 300000, new ProducerStateManagerConfig(3600000), (Time)time, Optional.empty());
            ((LogSegment)segment.elem).recover(stateManager2, (Option)None$.MODULE$);
            bl = correctAfterReload && ((LogSegment)segment.elem).log().channel().size() <= corruptionPoint && ((Set)batchAlignment.elem).contains((Object)BoxesRunTime.boxToLong((long)((LogSegment)segment.elem).log().channel().size()));
        }
        finally {
            ((LogSegment)segment.elem).deleteIfExists();
            segmentDir.delete();
        }
        return bl;
    }

    public LogSegmentPropertyTest() {
        Configuration.$init$((Configuration)this);
        ScalaCheckConfiguration.$init$((ScalaCheckConfiguration)this);
        Checkers.$init$((Checkers)this);
        int x$1 = ((PosInt)PosInt$.MODULE$.from(100).get()).value();
        int x$2 = ((PosInt)PosInt$.MODULE$.from(1).get()).value();
        double x$3 = this.PropertyCheckConfiguration().apply$default$2();
        int x$4 = this.PropertyCheckConfiguration().apply$default$3();
        int x$5 = this.PropertyCheckConfiguration().apply$default$4();
        this.generatorDrivenConfig = new Configuration.PropertyCheckConfiguration((Configuration)this, x$1, x$3, x$4, x$5, x$2);
    }
}

