/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.audit.AuditJobSummary;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.audit.job.BrokerAuditJob;
import kafka.durability.audit.manager.DurabilityAuditCheck$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.DurabilityDB$;
import kafka.log.AbstractLog;
import kafka.log.CleanParams;
import kafka.log.Cleaner;
import kafka.log.FaultInjectedTierObjectStoreWrapper;
import kafka.log.HarnessParams;
import kafka.log.LogCleanerManager$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.MergedLogHarness$;
import kafka.log.MergedLogHarnessHelpers$;
import kafka.log.MergedLogStateSnapshot;
import kafka.log.OffsetsToClean;
import kafka.log.RecordState;
import kafka.log.RecordState$;
import kafka.log.SegmentFields;
import kafka.log.TierLogComponents;
import kafka.log.TierLogSegment;
import kafka.log.ValidateLogResult$;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedOperationKey;
import kafka.server.ReplicaManager;
import kafka.tier.DeletionState;
import kafka.tier.InProgressDeletion;
import kafka.tier.MaterializingState$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.MemoryTracker;
import kafka.tier.fetcher.PendingFetch;
import kafka.tier.fetcher.TierFetchDataInfo;
import kafka.tier.fetcher.TierFetchResult;
import kafka.tier.fetcher.offsetcache.FetchOffsetCache;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.tasks.delete.DeletionTask;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.Throttler;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AbstractFetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.TxnMetadata;
import org.apache.kafka.test.TestUtils;
import org.mockito.Mockito;
import org.scalatest.time.Span$;
import org.scalatest.time.SpanSugar$;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\r}t!B'O\u0011\u0003\u0019f!B+O\u0011\u00031\u0006\"B2\u0002\t\u0003!\u0007bB3\u0002\u0005\u0004%\tA\u001a\u0005\u0007U\u0006\u0001\u000b\u0011B4\t\u000f-\f!\u0019!C\u0001Y\"110\u0001Q\u0001\n5Dq\u0001`\u0001C\u0002\u0013\u0005a\r\u0003\u0004~\u0003\u0001\u0006Ia\u001a\u0005\b}\u0006\u0011\r\u0011\"\u0001g\u0011\u0019y\u0018\u0001)A\u0005O\"I\u0011\u0011A\u0001C\u0002\u0013\u0005\u00111\u0001\u0005\t\u0003\u0017\t\u0001\u0015!\u0003\u0002\u0006!9\u0011QB\u0001\u0005\u0002\u0005=\u0001bBAO\u0003\u0011\u0005\u0011q\u0014\u0005\b\u0007?\nA\u0011AB1\u0011\u001d\u00199(\u0001C\u0001\u0007s2Q!\u0016(\u0001\u0003GC\u0011bT\t\u0003\u0002\u0004%\t!!*\t\u0015\u0005\u001d\u0016C!a\u0001\n\u0003\tI\u000b\u0003\u0006\u00026F\u0011\t\u0011)Q\u0005\u0003\u007fB\u0011\"a.\u0012\u0005\u0003\u0007I\u0011\u00014\t\u0015\u0005e\u0016C!a\u0001\n\u0003\tY\fC\u0005\u0002@F\u0011\t\u0011)Q\u0005O\"Q\u0011\u0011S\t\u0003\u0006\u0004%\t!!1\t\u0015\u0005\r\u0017C!A!\u0002\u0013\t\u0019\n\u0003\u0006\u0002\bF\u0011)\u0019!C\u0001\u0003\u000bD!\"a2\u0012\u0005\u0003\u0005\u000b\u0011BAE\u0011)\tI-\u0005BA\u0002\u0013\u0005\u00111\u001a\u0005\u000b\u0003\u001b\f\"\u00111A\u0005\u0002\u0005=\u0007BCAj#\t\u0005\t\u0015)\u0003\u0002x!Q\u0011Q[\t\u0003\u0002\u0004%\t!a6\t\u0015\u0005}\u0017C!a\u0001\n\u0003\t\t\u000f\u0003\u0006\u0002fF\u0011\t\u0011)Q\u0005\u00033D!\"a:\u0012\u0005\u0003\u0007I\u0011AAu\u0011)\tY/\u0005BA\u0002\u0013\u0005\u0011Q\u001e\u0005\u000b\u0003c\f\"\u0011!Q!\n\u0005]\u0001BCAz#\t\u0005\r\u0011\"\u0001\u0002v\"Q\u0011q_\t\u0003\u0002\u0004%\t!!?\t\u0015\u0005u\u0018C!A!B\u0013\t9\u0003\u0003\u0006\u0002\u0000F\u0011\t\u0019!C\u0001\u0005\u0003A!Ba\u0001\u0012\u0005\u0003\u0007I\u0011\u0001B\u0003\u0011)\u0011I!\u0005B\u0001B\u0003&\u00111\u0007\u0005\u000b\u0005\u0017\t\"\u00111A\u0005\u0002\t5\u0001B\u0003B\b#\t\u0005\r\u0011\"\u0001\u0003\u0012!Q!QC\t\u0003\u0002\u0003\u0006K!a\u0010\t\u0015\t]\u0011C!b\u0001\n\u0003\u0011I\u0002\u0003\u0006\u0003\"E\u0011\t\u0011)A\u0005\u00057A!Ba\t\u0012\u0005\u0003\u0007I\u0011\u0001B\u0013\u0011)\u00119#\u0005BA\u0002\u0013\u0005!\u0011\u0006\u0005\u000b\u0005[\t\"\u0011!Q!\n\u0005-\u0003B\u0003B\u0018#\t\u0005\r\u0011\"\u0001\u00032!Q!1G\t\u0003\u0002\u0004%\tA!\u000e\t\u0015\te\u0012C!A!B\u0013\tY\u0007\u0003\u0004d#\u0011\u0005!1\b\u0005\n\u0005/\n\"\u0019!C\u0001\u00053B\u0001B!\u001b\u0012A\u0003%!1\f\u0005\b\u0005W\nB\u0011\u0001B7\u0011\u001d\u0011y'\u0005C\u0001\u0005[BqA!\u001d\u0012\t\u0003\u0011\u0019\bC\u0004\u0003zE!\tAa\u001f\t\u000f\te\u0014\u0003\"\u0001\u0003\u001c\"9!qU\t\u0005\u0002\t%\u0006\"\u0003Bm#E\u0005I\u0011\u0001Bn\u0011\u001d\u0011\t0\u0005C\u0001\u0005[BqAa=\u0012\t\u0003\u0011)\u0010C\u0004\u0003|F!\tA!@\t\u000f\r\u0015\u0011\u0003\"\u0003\u0002\u0004!91qA\t\u0005\u0002\r%\u0001bBB\u0006#\u0011\u00051Q\u0002\u0005\b\u0007\u001f\tB\u0011AB\t\u0011%\u0019y#EI\u0001\n\u0003\u0019\t\u0004C\u0004\u0004\u0010E!\ta!\u000e\t\u000f\r\u0005\u0013\u0003\"\u0003\u0002\u0004!911I\t\u0005\n\r\u0015\u0003bBB%#\u0011\u0005!Q\u000e\u0005\b\u0007\u0017\nB\u0011\u0002B7\u0003AiUM]4fI2{w\rS1s]\u0016\u001c8O\u0003\u0002P!\u0006\u0019An\\4\u000b\u0003E\u000bQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002U\u00035\taJ\u0001\tNKJ<W\r\u001a'pO\"\u000b'O\\3tgN\u0019\u0011aV/\u0011\u0005a[V\"A-\u000b\u0003i\u000bQa]2bY\u0006L!\u0001X-\u0003\r\u0005s\u0017PU3g!\tq\u0016-D\u0001`\u0015\t\u0001\u0007+A\u0003vi&d7/\u0003\u0002c?\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001T\u0003]i\u0015\r\u001f+sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5/F\u0001h!\tA\u0006.\u0003\u0002j3\n\u0019\u0011J\u001c;\u000215\u000b\u0007\u0010\u0016:b]N\f7\r^5p]RKW.Z8vi6\u001b\b%\u0001\u000eqe>$WoY3s'R\fG/Z'b]\u0006<WM]\"p]\u001aLw-F\u0001n!\tq\u00170D\u0001p\u0015\ty\u0005O\u0003\u0002re\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0003gR\fqa\u001d;pe\u0006<WM\u0003\u0002Rk*\u0011ao^\u0001\u0007CB\f7\r[3\u000b\u0003a\f1a\u001c:h\u0013\tQxN\u0001\u000eQe>$WoY3s'R\fG/Z'b]\u0006<WM]\"p]\u001aLw-A\u000eqe>$WoY3s'R\fG/Z'b]\u0006<WM]\"p]\u001aLw\rI\u0001$!J|G-^2fe&#W\t\u001f9je\u0006$\u0018n\u001c8DQ\u0016\u001c7.\u00138uKJ4\u0018\r\\'t\u0003\u0011\u0002&o\u001c3vG\u0016\u0014\u0018\nZ#ya&\u0014\u0018\r^5p]\u000eCWmY6J]R,'O^1m\u001bN\u0004\u0013\u0001\u0003\"s_.,'/\u00133\u0002\u0013\t\u0013xn[3s\u0013\u0012\u0004\u0013\u0001F'j]\u0006\u0013wN\u001d;fIB\u0013x\u000eZ;dKJLE-\u0006\u0002\u0002\u0006A\u0019\u0001,a\u0002\n\u0007\u0005%\u0011L\u0001\u0003M_:<\u0017!F'j]\u0006\u0013wN\u001d;fIB\u0013x\u000eZ;dKJLE\rI\u0001\u0015S:LG/[1mSj,7i\\7q_:,g\u000e^:\u0015\u0015\u0005E\u0011QPAC\u0003\u001f\u000bI\nE\tY\u0003'\t9\"a\n\u00024\u0005}\u00121JA6\u0003oJ1!!\u0006Z\u0005\u0019!V\u000f\u001d7foA!\u0011\u0011DA\u0012\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011!\u0002;bg.\u001c(bAA\u0011!\u0006!A/[3s\u0013\u0011\t)#a\u0007\u0003\u001fQKWM\u001d+bg.\u001c8i\u001c8gS\u001e\u0004B!!\u000b\u000205\u0011\u00111\u0006\u0006\u0005\u0003[\tY\"A\u0004be\u000eD\u0017N^3\n\t\u0005E\u00121\u0006\u0002\f\u0003J\u001c\u0007.\u001b<f)\u0006\u001c8\u000e\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\u0011\tI$a\u0007\u0002\u0015\r|W\u000e]1di&|g.\u0003\u0003\u0002>\u0005]\"AD\"p[B\f7\r^5p]R\u000b7o\u001b\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)!\u0011QIA\u0010\u0003\u0015!x\u000e]5d\u0013\u0011\tI%a\u0011\u0003#QKWM\u001d+pa&\u001c\u0017\t\u001d9f]\u0012,'\u000f\u0005\u0004\u0002N\u0005m\u0013qL\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005U\u0013qK\u0001\u0005kRLGN\u0003\u0002\u0002Z\u0005!!.\u0019<b\u0013\u0011\ti&a\u0014\u0003)\r{\u0007/_(o/JLG/Z!se\u0006LH*[:u!\u0011\t\t'a\u001a\u000e\u0005\u0005\r$\u0002BA3\u0003?\ta\u0001Z8nC&t\u0017\u0002BA5\u0003G\u0012A#\u00112tiJ\f7\r\u001e+jKJlU\r^1eCR\f\u0007\u0003BA7\u0003gj!!a\u001c\u000b\u0007\u0005E\u0004+\u0001\u0004tKJ4XM]\u0005\u0005\u0003k\nyG\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0011\u0007Q\u000bI(C\u0002\u0002|9\u0013qa\u00117fC:,'\u000f\u0003\u0004P\u001b\u0001\u0007\u0011q\u0010\t\u0004)\u0006\u0005\u0015bAAB\u001d\nIQ*\u001a:hK\u0012dun\u001a\u0005\b\u0003\u000fk\u0001\u0019AAE\u0003%!\bN]8ui2,'\u000fE\u0002_\u0003\u0017K1!!$`\u0005%!\u0006N]8ui2,'\u000fC\u0004\u0002\u00126\u0001\r!a%\u0002\rA\f'/Y7t!\r!\u0016QS\u0005\u0004\u0003/s%!\u0004%be:,7o\u001d)be\u0006l7\u000f\u0003\u0004\u0002\u001c6\u0001\raZ\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007.A\u0003baBd\u0017\u0010\u0006\u0005\u0002\"\u000e53\u0011LB/!\t!\u0016cE\u0002\u0012/v+\"!a \u0002\u000f1|wm\u0018\u0013fcR!\u00111VAY!\rA\u0016QV\u0005\u0004\u0003_K&\u0001B+oSRD\u0011\"a-\u0014\u0003\u0003\u0005\r!a \u0002\u0007a$\u0013'\u0001\u0003m_\u001e\u0004\u0013!B3q_\u000eD\u0017!C3q_\u000eDw\fJ3r)\u0011\tY+!0\t\u0011\u0005Mf#!AA\u0002\u001d\fa!\u001a9pG\"\u0004SCAAJ\u0003\u001d\u0001\u0018M]1ng\u0002*\"!!#\u0002\u0015QD'o\u001c;uY\u0016\u0014\b%A\u0004dY\u0016\fg.\u001a:\u0016\u0005\u0005]\u0014aC2mK\u0006tWM]0%KF$B!a+\u0002R\"I\u00111W\u000f\u0002\u0002\u0003\u0007\u0011qO\u0001\tG2,\u0017M\\3sA\u0005iQM^3s\u0007>l\u0007/Y2uK\u0012,\"!!7\u0011\u0007a\u000bY.C\u0002\u0002^f\u0013qAQ8pY\u0016\fg.A\tfm\u0016\u00148i\\7qC\u000e$X\rZ0%KF$B!a+\u0002d\"I\u00111\u0017\u0011\u0002\u0002\u0003\u0007\u0011\u0011\\\u0001\u000fKZ,'oQ8na\u0006\u001cG/\u001a3!\u0003=!\u0018.\u001a:UCN\\7oQ8oM&<WCAA\f\u0003M!\u0018.\u001a:UCN\\7oQ8oM&<w\fJ3r)\u0011\tY+a<\t\u0013\u0005M6%!AA\u0002\u0005]\u0011\u0001\u0005;jKJ$\u0016m]6t\u0007>tg-[4!\u0003-\t'o\u00195jm\u0016$\u0016m]6\u0016\u0005\u0005\u001d\u0012aD1sG\"Lg/\u001a+bg.|F%Z9\u0015\t\u0005-\u00161 \u0005\n\u0003g3\u0013\u0011!a\u0001\u0003O\tA\"\u0019:dQ&4X\rV1tW\u0002\nabY8na\u0006\u001cG/[8o)\u0006\u001c8.\u0006\u0002\u00024\u0005\u00112m\\7qC\u000e$\u0018n\u001c8UCN\\w\fJ3r)\u0011\tYKa\u0002\t\u0013\u0005M\u0016&!AA\u0002\u0005M\u0012aD2p[B\f7\r^5p]R\u000b7o\u001b\u0011\u0002\u0011\u0005\u0004\b/\u001a8eKJ,\"!a\u0010\u0002\u0019\u0005\u0004\b/\u001a8eKJ|F%Z9\u0015\t\u0005-&1\u0003\u0005\n\u0003gc\u0013\u0011!a\u0001\u0003\u007f\t\u0011\"\u00199qK:$WM\u001d\u0011\u0002\u0017=\u0014'.Z2u'R|'/Z\u000b\u0003\u00057\u00012\u0001\u0016B\u000f\u0013\r\u0011yB\u0014\u0002$\r\u0006,H\u000e^%oU\u0016\u001cG/\u001a3US\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f/J\f\u0007\u000f]3s\u00031y'M[3diN#xN]3!\u0003A\t\u0007\u000f]3oI\u0016$W*\u001a;bI\u0006$\u0018-\u0006\u0002\u0002L\u0005!\u0012\r\u001d9f]\u0012,G-T3uC\u0012\fG/Y0%KF$B!a+\u0003,!I\u00111W\u0019\u0002\u0002\u0003\u0007\u00111J\u0001\u0012CB\u0004XM\u001c3fI6+G/\u00193bi\u0006\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0003\u0003W\n!C]3qY&\u001c\u0017-T1oC\u001e,'o\u0018\u0013fcR!\u00111\u0016B\u001c\u0011%\t\u0019\fNA\u0001\u0002\u0004\tY'A\bsKBd\u0017nY1NC:\fw-\u001a:!)q\t\tK!\u0010\u0003@\t\u0005#1\tB#\u0005\u000f\u0012IEa\u0013\u0003N\t=#\u0011\u000bB*\u0005+Baa\u0014\u001cA\u0002\u0005}\u0004BBA\\m\u0001\u0007q\rC\u0004\u0002\u0012Z\u0002\r!a%\t\u000f\u0005\u001de\u00071\u0001\u0002\n\"9\u0011\u0011\u001a\u001cA\u0002\u0005]\u0004bBAkm\u0001\u0007\u0011\u0011\u001c\u0005\b\u0003O4\u0004\u0019AA\f\u0011\u001d\t\u0019P\u000ea\u0001\u0003OAq!a@7\u0001\u0004\t\u0019\u0004C\u0004\u0003\fY\u0002\r!a\u0010\t\u000f\t]a\u00071\u0001\u0003\u001c!9!1\u0005\u001cA\u0002\u0005-\u0003b\u0002B\u0018m\u0001\u0007\u00111N\u0001\b[\u0016$(/[2t+\t\u0011Y\u0006\u0005\u0003\u0003^\t\u0015TB\u0001B0\u0015\u0011\u00119F!\u0019\u000b\u0007\t\rD/\u0001\u0004d_6lwN\\\u0005\u0005\u0005O\u0012yFA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\nq\u0001Z3tiJ|\u0017\u0010\u0006\u0002\u0002,\u00069b/\u00197jI\u0006$X\rU1si&$\u0018n\u001c8EK2,G/Z\u0001\u0007e\u0016|\u0007/\u001a8\u0015\t\u0005-&Q\u000f\u0005\b\u0005oZ\u0004\u0019AAm\u0003%)hN\u001a7vg\",G-\u0001\u0007va\u0012\fG/Z\"p]\u001aLw\r\u0006\u0004\u0002,\nu$q\u0013\u0005\b\u0005\u007fb\u0004\u0019\u0001BA\u0003\rYW-\u001f\t\u0005\u0005\u0007\u0013\tJ\u0004\u0003\u0003\u0006\n5\u0005c\u0001BD36\u0011!\u0011\u0012\u0006\u0004\u0005\u0017\u0013\u0016A\u0002\u001fs_>$h(C\u0002\u0003\u0010f\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002BJ\u0005+\u0013aa\u0015;sS:<'b\u0001BH3\"9!\u0011\u0014\u001fA\u0002\t\u0005\u0015!\u0002<bYV,G\u0003BAV\u0005;CqAa(>\u0001\u0004\u0011\t+A\u0005oK^\u001cuN\u001c4jOB\u0019aNa)\n\u0007\t\u0015vNA\u0005M_\u001e\u001cuN\u001c4jO\u0006\u0011\"/Z1e\u0017\u0016L8/\u00118e\u001f\u001a47/\u001a;t)\u0011\u0011YK!6\u0011\u000fa\u0013iK!-\u0003@&\u0019!qV-\u0003\rQ+\b\u000f\\33!!\u0011\u0019L!.\u0003:\u0006\u0015QBAA*\u0013\u0011\u00119,a\u0015\u0003\u000f!\u000b7\u000f['baB)\u0001La/\u0003\u0002&\u0019!QX-\u0003\r=\u0003H/[8o!\u0019\u0011\tMa3\u0003P6\u0011!1\u0019\u0006\u0005\u0005\u000b\u00149-A\u0004nkR\f'\r\\3\u000b\u0007\t%\u0017,\u0001\u0006d_2dWm\u0019;j_:LAA!4\u0003D\nQA*[:u\u0005V4g-\u001a:\u0011\u0007Q\u0013\t.C\u0002\u0003T:\u00131BU3d_J$7\u000b^1uK\"I!q\u001b \u0011\u0002\u0003\u0007\u0011\u0011\\\u0001\u0016Kb\u001cG.\u001e3f\u0003\n|'\u000f^3e%\u0016\u001cwN\u001d3t\u0003q\u0011X-\u00193LKf\u001c\u0018I\u001c3PM\u001a\u001cX\r^:%I\u00164\u0017-\u001e7uIE*\"A!8+\t\u0005e'q\\\u0016\u0003\u0005C\u0004BAa9\u0003n6\u0011!Q\u001d\u0006\u0005\u0005O\u0014I/A\u0005v]\u000eDWmY6fI*\u0019!1^-\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003p\n\u0015(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Qa/\u001a:jMf$\u0006P\\:\u0002\u0019\u0005$g/\u00198dK\u000ecwnY6\u0015\t\u0005-&q\u001f\u0005\b\u0005s\f\u0005\u0019AA\u0003\u0003\ti7/A\tuC.,7\u000b^1uKNs\u0017\r]:i_R$\"Aa@\u0011\u0007Q\u001b\t!C\u0002\u0004\u00049\u0013a#T3sO\u0016$Gj\\4Ti\u0006$Xm\u00158baNDw\u000e^\u0001\rO\u0016$Hj\\:t\u0007>,h\u000e^\u0001\u0011[\u0006L(-\u001a+jKJ\u001cVmZ7f]R$\"!!7\u0002\u001bQLWM\u001d*fi\u0016tG/[8o)\u00059\u0017AC7bs\n,7\t\\3b]R!11CB\u000b!\u001dA&QVA\u0003\u0003\u000bA\u0011ba\u0006G!\u0003\u0005\ra!\u0007\u00021\u0015D\b/Z2uK\u00124\u0016\r\\5eCRLwN\u001c*fgVdG\u000f\u0005\u0003\u0004\u001c\r%b\u0002BB\u000f\u0007KqAaa\b\u0004$9!!qQB\u0011\u0013\u0005\t\u0016BA(Q\u0013\r\u00199CT\u0001\u0012-\u0006d\u0017\u000eZ1uK2{wMU3tk2$\u0018\u0002BB\u0016\u0007[\u0011\u0011CV1mS\u0012\fG/\u001a'pOJ+7/\u001e7u\u0015\r\u00199CT\u0001\u0015[\u0006L(-Z\"mK\u0006tG\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\rM\"\u0006BB\r\u0005?$\u0002ba\u0005\u00048\rm2q\b\u0005\b\u0007sA\u0005\u0019AAm\u0003\u0015awnY1m\u0011\u001d\u0019i\u0004\u0013a\u0001\u00033\fa\u0001^5fe\u0016$\u0007bBB\f\u0011\u0002\u00071\u0011D\u0001\u0010[\u0006L(-\u001a'pG\u0006d7\t\\3b]\u0006qQ.Y=cKRKWM]\"mK\u0006tG\u0003BA\u0003\u0007\u000fBqaa\u0006K\u0001\u0004\u0019I\"\u0001\ttS6,H.\u0019;f\t\u0006$\u0018\rT8tg\u0006AB-\u001a7fi\u00164\u0015N]:u)&,'/\u001a3TK\u001elWM\u001c;\t\u000f\r=c\u00021\u0001\u0004R\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003BB*\u0007+j!A!\u0019\n\t\r]#\u0011\r\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\u0019YF\u0004a\u0001\u0005C\u000baaY8oM&<\u0007bBAI\u001d\u0001\u0007\u00111S\u0001\u001bIJ|\u0007OR5sgR\u0014VmY8sI\u001a\u0013x.\\*fO6,g\u000e\u001e\u000b\u0007\u0003W\u001b\u0019ga\u001d\t\u000f\r\u0015t\u00021\u0001\u0004h\u0005\u0001\u0012N\u001c9vi\u001aKG.\u001a*fG>\u0014Hm\u001d\t\u0005\u0007S\u001ay'\u0004\u0002\u0004l)!1Q\u000eB1\u0003\u0019\u0011XmY8sI&!1\u0011OB6\u0005-1\u0015\u000e\\3SK\u000e|'\u000fZ:\t\u000f\rUt\u00021\u0001\u0004h\u0005\tr.\u001e;qkR4\u0015\u000e\\3SK\u000e|'\u000fZ:\u0002'%\u001c\u0018IY8si\u0016$\u0007K]8ek\u000e,'/\u00133\u0015\t\u0005e71\u0010\u0005\b\u0007{\u0002\u0002\u0019AA\u0003\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a")
public class MergedLogHarness
implements Logging {
    private MergedLog log;
    private int epoch;
    private final HarnessParams params;
    private final Throttler throttler;
    private Cleaner cleaner;
    private boolean everCompacted;
    private TierTasksConfig tierTasksConfig;
    private ArchiveTask archiveTask;
    private CompactionTask compactionTask;
    private TierTopicAppender appender;
    private final FaultInjectedTierObjectStoreWrapper objectStore;
    private CopyOnWriteArrayList<AbstractTierMetadata> appendedMetadata;
    private ReplicaManager replicaManager;
    private final Metrics metrics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean isAbortedProducerId(long producerId) {
        return MergedLogHarness$.MODULE$.isAbortedProducerId(producerId);
    }

    public static void dropFirstRecordFromSegment(FileRecords inputFileRecords, FileRecords outputFileRecords) {
        MergedLogHarness$.MODULE$.dropFirstRecordFromSegment(inputFileRecords, outputFileRecords);
    }

    public static MergedLogHarness apply(TopicPartition topicPartition, LogConfig config, HarnessParams params) {
        return MergedLogHarness$.MODULE$.apply(topicPartition, config, params);
    }

    public static Tuple7<TierTasksConfig, ArchiveTask, CompactionTask, TierTopicAppender, CopyOnWriteArrayList<AbstractTierMetadata>, ReplicaManager, Cleaner> initializeComponents(MergedLog log, Throttler throttler, HarnessParams params, int leaderEpoch) {
        return MergedLogHarness$.MODULE$.initializeComponents(log, throttler, params, leaderEpoch);
    }

    public static long MinAbortedProducerId() {
        return MergedLogHarness$.MODULE$.MinAbortedProducerId();
    }

    public static int BrokerId() {
        return MergedLogHarness$.MODULE$.BrokerId();
    }

    public static int ProducerIdExpirationCheckIntervalMs() {
        return MergedLogHarness$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    public static ProducerStateManagerConfig producerStateManagerConfig() {
        return MergedLogHarness$.MODULE$.producerStateManagerConfig();
    }

    public static int MaxTransactionTimeoutMs() {
        return MergedLogHarness$.MODULE$.MaxTransactionTimeoutMs();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public MergedLog log() {
        return this.log;
    }

    public void log_$eq(MergedLog x$1) {
        this.log = x$1;
    }

    public int epoch() {
        return this.epoch;
    }

    public void epoch_$eq(int x$1) {
        this.epoch = x$1;
    }

    public HarnessParams params() {
        return this.params;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public Cleaner cleaner() {
        return this.cleaner;
    }

    public void cleaner_$eq(Cleaner x$1) {
        this.cleaner = x$1;
    }

    public boolean everCompacted() {
        return this.everCompacted;
    }

    public void everCompacted_$eq(boolean x$1) {
        this.everCompacted = x$1;
    }

    public TierTasksConfig tierTasksConfig() {
        return this.tierTasksConfig;
    }

    public void tierTasksConfig_$eq(TierTasksConfig x$1) {
        this.tierTasksConfig = x$1;
    }

    public ArchiveTask archiveTask() {
        return this.archiveTask;
    }

    public void archiveTask_$eq(ArchiveTask x$1) {
        this.archiveTask = x$1;
    }

    public CompactionTask compactionTask() {
        return this.compactionTask;
    }

    public void compactionTask_$eq(CompactionTask x$1) {
        this.compactionTask = x$1;
    }

    public TierTopicAppender appender() {
        return this.appender;
    }

    public void appender_$eq(TierTopicAppender x$1) {
        this.appender = x$1;
    }

    public FaultInjectedTierObjectStoreWrapper objectStore() {
        return this.objectStore;
    }

    public CopyOnWriteArrayList<AbstractTierMetadata> appendedMetadata() {
        return this.appendedMetadata;
    }

    public void appendedMetadata_$eq(CopyOnWriteArrayList<AbstractTierMetadata> x$1) {
        this.appendedMetadata = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void destroy() {
        this.log().info((Function0 & Serializable)() -> new StringBuilder(27).append("Final log at destroy time: ").append(this.log()).toString());
        this.validatePartitionDelete();
        this.log().time().sleep(10000L);
        this.log().close();
        Utils.delete((File)this.log().dir().getParentFile(), (boolean)false);
        this.objectStore().close();
        Mockito.framework().clearInlineMocks();
        this.log_$eq(null);
    }

    public void validatePartitionDelete() {
        this.log().topicIdPartition().foreach((Function1 & Serializable)topicIdPartition -> {
            MergedLogHarness.$anonfun$validatePartitionDelete$1(this, topicIdPartition);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void reopen(boolean unflushed) {
        void var23_20;
        void var22_19;
        void var20_17;
        void var19_16;
        void var18_15;
        void var17_14;
        void var21_18;
        MockTime time = (MockTime)this.log().localLog().time();
        MockScheduler scheduler = time.scheduler();
        long recoveryPoint = unflushed ? this.log().recoveryPoint() : 0L;
        File logDir = this.log().localLog().dir();
        long logStartOffset = this.log().logStartOffset();
        long hwm = this.log().highWatermark();
        LogConfig logConfig = this.log().config();
        TierLogComponents tierLogComponents = this.log().tierLogComponents();
        LogDirFailureChannel logDirFailureChannel = this.log().localLog().logDirFailureChannel();
        int nextEpoch = this.epoch() + 1;
        this.log().close();
        MergedLog newLog = MergedLog$.MODULE$.apply(logDir, logConfig, logStartOffset, recoveryPoint, (Scheduler)scheduler, new BrokerTopicStats(), this.metrics(), (Time)time, MergedLogHarness$.MODULE$.MaxTransactionTimeoutMs(), MergedLogHarness$.MODULE$.producerStateManagerConfig(), MergedLogHarness$.MODULE$.ProducerIdExpirationCheckIntervalMs(), (Option)None$.MODULE$, logDirFailureChannel, tierLogComponents, unflushed, (Option)None$.MODULE$, true, LogOffsetsListener.NO_OP_OFFSETS_LISTENER, (Option)None$.MODULE$, new ConcurrentHashMap());
        if (newLog.config().confluentLogConfig().tierEnable()) {
            newLog.tierPartitionState().setTieringEnabled();
            MergedLogHarnessHelpers$.MODULE$.ensureTierEnabledState(newLog);
        }
        newLog.updateHighWatermark(hwm);
        this.compactionTask().offsetMapSupplier().close();
        Tuple7<TierTasksConfig, ArchiveTask, CompactionTask, TierTopicAppender, CopyOnWriteArrayList<AbstractTierMetadata>, ReplicaManager, Cleaner> tuple7 = MergedLogHarness$.MODULE$.initializeComponents(newLog, this.throttler(), this.params(), nextEpoch);
        if (tuple7 == null) {
            throw new MatchError(null);
        }
        TierTasksConfig newTierTasksConfig = (TierTasksConfig)tuple7._1();
        ArchiveTask newArchiveTask = (ArchiveTask)tuple7._2();
        CompactionTask newCompactionTask = (CompactionTask)tuple7._3();
        TierTopicAppender newAppender = (TierTopicAppender)tuple7._4();
        CopyOnWriteArrayList newAppendedMetadata = (CopyOnWriteArrayList)tuple7._5();
        ReplicaManager newReplicaManager = (ReplicaManager)tuple7._6();
        Cleaner newCleaner = (Cleaner)tuple7._7();
        var21_18.addAll(this.appendedMetadata());
        this.log_$eq(newLog);
        this.tierTasksConfig_$eq((TierTasksConfig)var17_14);
        this.archiveTask_$eq((ArchiveTask)var18_15);
        this.compactionTask_$eq((CompactionTask)var19_16);
        this.appender_$eq((TierTopicAppender)var20_17);
        this.appendedMetadata_$eq((CopyOnWriteArrayList<AbstractTierMetadata>)var21_18);
        this.replicaManager_$eq((ReplicaManager)var22_19);
        this.cleaner_$eq((Cleaner)var23_20);
        this.epoch_$eq(nextEpoch);
    }

    public void updateConfig(String key, String value) {
        Map map = this.log().config().originals();
        map.put(key, value);
        this.log().updateConfig(new LogConfig(map));
        MergedLogHarnessHelpers$.MODULE$.ensureTierEnabledState(this.log());
    }

    public void updateConfig(LogConfig newConfig) {
        this.log().updateConfig(newConfig);
        MergedLogHarnessHelpers$.MODULE$.ensureTierEnabledState(this.log());
    }

    public Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> readKeysAndOffsets(boolean excludeAbortedRecords) {
        this.verifyTxns();
        FetchOffsetCache fetchOffsetCache = new FetchOffsetCache(this.log().localLog().time(), 1000, 1000);
        MemoryTracker memoryTracker = new MemoryTracker(this.log().localLog().time(), Long.MAX_VALUE);
        ArrayList ignored = new ArrayList(0);
        Consumer<DelayedOperationKey> callback = new Consumer<DelayedOperationKey>(null){

            public Consumer<DelayedOperationKey> andThen(Consumer<? super DelayedOperationKey> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(DelayedOperationKey t) {
            }
        };
        LongRef fetchOffset = LongRef.create((long)this.log().logStartOffset());
        HashMap offsetMap = new HashMap();
        ListBuffer records = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ObjectRef priorOffsetRead = ObjectRef.create((Object)None$.MODULE$);
        while (fetchOffset.elem < this.log().logEndOffset()) {
            long startFetchOffset = fetchOffset.elem;
            AbstractFetchDataInfo fetchInfo = this.log().read(fetchOffset.elem, this.params().readSize(), FetchIsolation.LOG_END, true, true);
            if (fetchInfo instanceof FetchDataInfo) {
                FetchDataInfo fetchDataInfo = (FetchDataInfo)fetchInfo;
                CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.batches()).asScala().foreach((Function1 & Serializable)batch -> {
                    this.process$1(batch, excludeAbortedRecords, offsetMap, records, priorOffsetRead, fetchOffset);
                    return BoxedUnit.UNIT;
                });
                CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.batches()).asScala().lastOption().map((Function1 & Serializable)batch -> {
                    fetchOffset.elem = batch.lastOffset() + 1L;
                    return BoxedUnit.UNIT;
                });
                if (fetchDataInfo.fetchOffsetMetadata.messageOffset == this.log().logEndOffset() && CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().isEmpty() && this.log().activeSegment().size() == 0) {
                    fetchOffset.elem = fetchDataInfo.fetchOffsetMetadata.messageOffset;
                }
            } else if (fetchInfo instanceof TierFetchDataInfo) {
                TierFetchDataInfo tierFetchDataInfo = (TierFetchDataInfo)fetchInfo;
                PendingFetch fetch = new PendingFetch(CancellationContext.newContext(), ((FaultInjectedTierObjectStoreWrapper)this.log().tierLogComponents().objectStoreOpt().get()).innerTierObjectStore(), fetchOffsetCache, Optional.empty(), tierFetchDataInfo.fetchMetadata().segmentMetadata(), (Consumer)callback, fetchOffset.elem, this.params().readSize(), Integer.MAX_VALUE, IsolationLevel.READ_UNCOMMITTED, memoryTracker, ignored, this.log().localLog().time());
                fetch.run();
                TierFetchResult result = (TierFetchResult)fetch.finish().get(this.log().topicPartition());
                CollectionConverters$.MODULE$.IterableHasAsScala(result.records.batches()).asScala().foreach((Function1 & Serializable)batch -> {
                    this.process$1(batch, excludeAbortedRecords, offsetMap, records, priorOffsetRead, fetchOffset);
                    return BoxedUnit.UNIT;
                });
                CollectionConverters$.MODULE$.IterableHasAsScala(result.records.batches()).asScala().lastOption().map((Function1 & Serializable)batch -> {
                    fetchOffset.elem = batch.lastOffset() + 1L;
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new IllegalStateException(new StringBuilder(52).append("Unexpected implementation of AbstractFetchDataInfo: ").append(fetchInfo.getClass()).toString());
            }
            Predef$.MODULE$.assert(fetchOffset.elem != startFetchOffset || fetchOffset.elem == this.log().logEndOffset(), (Function0 & Serializable)() -> new StringBuilder(34).append("fetch offset didn't advance after ").append(fetchOffset$1.elem).toString());
        }
        return new Tuple2(offsetMap, (Object)records);
    }

    public boolean readKeysAndOffsets$default$1() {
        return false;
    }

    public void verifyTxns() {
        FetchOffsetCache fetchOffsetCache = new FetchOffsetCache(this.log().localLog().time(), 1000, 1000);
        MemoryTracker memoryTracker = new MemoryTracker(this.log().localLog().time(), Long.MAX_VALUE);
        ArrayList ignored = new ArrayList(0);
        Consumer<DelayedOperationKey> callback = new Consumer<DelayedOperationKey>(null){

            public Consumer<DelayedOperationKey> andThen(Consumer<? super DelayedOperationKey> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(DelayedOperationKey t) {
            }
        };
        LongRef fetchOffset = LongRef.create((long)this.log().logStartOffset());
        long endpoint = this.log().lastStableOffset();
        while (fetchOffset.elem < endpoint) {
            long startFetchOffset = fetchOffset.elem;
            AbstractFetchDataInfo fetchInfo = this.log().read(fetchOffset.elem, this.params().readSize(), FetchIsolation.TXN_COMMITTED, true, false);
            if (fetchInfo instanceof FetchDataInfo) {
                FetchDataInfo fetchDataInfo = (FetchDataInfo)fetchInfo;
                scala.collection.immutable.Set abortedProducerIds = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)fetchDataInfo.abortedTransactions.get()).asScala().map((Function1 & Serializable)abort -> BoxesRunTime.boxToLong((long)abort.producerId()))).toSet();
                scala.collection.immutable.Set abortedProducerIdsFromRecords = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.batches()).asScala().filter((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)MergedLogHarness.$anonfun$verifyTxns$2(batch)))).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.producerId()))).toSet();
                Predef$.MODULE$.assert(abortedProducerIdsFromRecords.subsetOf((Set)abortedProducerIds), (Function0 & Serializable)() -> new StringBuilder(86).append("Aborted producer ids collected from records: ").append(abortedProducerIdsFromRecords).append(" vs aborted producer ids from txn index: ").append(abortedProducerIds).toString());
                CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.batches()).asScala().lastOption().map((Function1 & Serializable)batch -> {
                    fetchOffset.elem = batch.lastOffset() + 1L;
                    return BoxedUnit.UNIT;
                });
                if (fetchDataInfo.fetchOffsetMetadata.messageOffset == endpoint && CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().isEmpty() && this.log().activeSegment().size() == 0) {
                    fetchOffset.elem = fetchDataInfo.fetchOffsetMetadata.messageOffset;
                }
            } else if (fetchInfo instanceof TierFetchDataInfo) {
                TierFetchDataInfo tierFetchDataInfo = (TierFetchDataInfo)fetchInfo;
                PendingFetch fetch = new PendingFetch(CancellationContext.newContext(), ((FaultInjectedTierObjectStoreWrapper)this.log().tierLogComponents().objectStoreOpt().get()).innerTierObjectStore(), fetchOffsetCache, Optional.empty(), tierFetchDataInfo.fetchMetadata().segmentMetadata(), (Consumer)callback, fetchOffset.elem, this.params().readSize(), Integer.MAX_VALUE, IsolationLevel.READ_COMMITTED, memoryTracker, ignored, this.log().localLog().time());
                fetch.run();
                TierFetchResult result = (TierFetchResult)fetch.finish().get(this.log().topicPartition());
                CollectionConverters$.MODULE$.IterableHasAsScala(result.records.batches()).asScala().foreach((Function1 & Serializable)batch -> {
                    MergedLogHarness.process2$1(batch, fetchOffset);
                    return BoxedUnit.UNIT;
                });
                scala.collection.immutable.Set abortedProducerIds = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(result.abortedTxns).asScala().map((Function1 & Serializable)txn -> BoxesRunTime.boxToLong((long)txn.producerId()))).toSet();
                scala.collection.immutable.Set abortedProducerIdsFromRecords = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.IterableHasAsScala(result.records.batches()).asScala().filter((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)MergedLogHarness.$anonfun$verifyTxns$8(batch)))).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.producerId()))).toSet();
                Predef$.MODULE$.assert(abortedProducerIdsFromRecords.subsetOf((Set)abortedProducerIds), (Function0 & Serializable)() -> new StringBuilder(86).append("Aborted producer ids collected from records: ").append(abortedProducerIdsFromRecords).append(" vs aborted producer ids from txn index: ").append(abortedProducerIds).toString());
            } else {
                throw new IllegalStateException(new StringBuilder(52).append("Unexpected implementation of AbstractFetchDataInfo: ").append(fetchInfo.getClass()).toString());
            }
            if (fetchOffset.elem != startFetchOffset) continue;
            fetchOffset.elem = endpoint;
        }
    }

    public void advanceClock(long ms) {
        this.log().localLog().time().sleep(ms);
    }

    /*
     * WARNING - void declaration
     */
    public MergedLogStateSnapshot takeStateSnapshot() {
        void var3_3;
        void var2_2;
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.readKeysAndOffsets(true);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        HashMap offsetMap = (HashMap)tuple2._1();
        ListBuffer records = (ListBuffer)tuple2._2();
        Predef$.MODULE$.assert(!this.log().localLogSegments().exists((Function1 & Serializable)seg -> BoxesRunTime.boxToBoolean((boolean)MergedLogHarness.$anonfun$takeStateSnapshot$1(seg))), (Function0 & Serializable)() -> "Next offset caching resulted in incorrect next offset");
        long lossCount = this.getLossCount();
        Predef$.MODULE$.assert(lossCount == 0L, (Function0 & Serializable)() -> "lossCount was > 0");
        return new MergedLogStateSnapshot(this.log().topicPartition(), this.log().time().milliseconds(), this.log().logStartOffset(), this.log().localLogStartOffset(), this.log().logEndOffset(), this.log().size(), this.log().tierPartitionState().totalSize(), this.log().highWatermark(), this.log().lastStableOffset(), (Vector<SegmentFields>)((IterableOnceOps)this.log().localLogSegments().map((Function1 & Serializable)seg -> new SegmentFields(seg.baseOffset(), seg.readNextOffset(), seg.getFirstBatchTimestamp(), seg.largestTimestamp(), seg.size()))).toVector(), (List<TierLogSegment>)this.log().tieredLogSegments().toList(), Predef$.MODULE$.Long2long(this.log().tierPartitionState().startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), this.log().tierPartitionState().endOffset(), this.log().tierPartitionState().committedEndOffset(), this.log().tierPartitionState().status(), (scala.collection.immutable.Map<Object, ProducerStateEntry>)CollectionConverters$.MODULE$.MapHasAsScala(this.log().producerStateManager().activeProducers()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Long k = (Long)x0$1._1();
                ProducerStateEntry v = (ProducerStateEntry)x0$1._2();
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)k), (Object)v.copy());
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (scala.collection.immutable.Map<Object, TxnMetadata>)CollectionConverters$.MODULE$.MapHasAsScala(this.log().producerStateManager().ongoingTxns()).asScala().map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                Long k = (Long)x0$2._1();
                TxnMetadata v = (TxnMetadata)x0$2._2();
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)k), (Object)new TxnMetadata(v.producerId, v.firstOffset, v.startTimeUpperBoundMs, v.lastOffset));
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (HashMap<Option<String>, Object>)var2_2, (ListBuffer<RecordState>)var3_3);
    }

    private long getLossCount() {
        MockTime durabilityMockTime = new MockTime(this.log().time().milliseconds(), 0L);
        DurabilityMetricsManager metricsManager = (DurabilityMetricsManager)Mockito.mock(DurabilityMetricsManager.class);
        Mockito.when((Object)metricsManager.startAuditJob()).thenReturn((Object)Instant.ofEpochMilli(durabilityMockTime.milliseconds()));
        AuditReporter simpleReporter = new AuditReporter(metricsManager);
        AuditJobSummary simpleAuditSummary = new AuditJobSummary();
        DurabilityDB db = DurabilityDB$.MODULE$.apply(TestUtils.tempDirectory(null, null));
        DurabilityAuditConfig durabilityAuditConfig = (DurabilityAuditConfig)Mockito.mock(DurabilityAuditConfig.class);
        new BrokerAuditJob((Seq)new .colon.colon((Object)new Tuple2((Object)this.log().topicPartition(), (Object)BoxesRunTime.boxToLong((long)0L)), (List)Nil$.MODULE$), this.replicaManager().logManager(), new CountDownLatch(1), simpleReporter, simpleAuditSummary, 0, (Option)new Some((Object)this.objectStore()), (Time)durabilityMockTime, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit()})), durabilityAuditConfig, db, (Option)None$.MODULE$, false, (Option)None$.MODULE$).run();
        return simpleReporter.getDurabilityCounters(this.log().topicPartition()).loss();
    }

    public boolean maybeTierSegment() {
        if (this.log().tierPartitionState().isTieringEnabled()) {
            boolean bl;
            if (this.archiveTask().state() instanceof BeforeLeader) {
                ArchiveTask result = (ArchiveTask)Await$.MODULE$.result((Awaitable)this.archiveTask().transition(this.log().localLog().time(), this.appender(), (TierObjectStore)this.objectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)new Some((Object)this.throttler()), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()));
                Predef$.MODULE$.assert(result.state() instanceof BeforeUpload);
            }
            Predef$.MODULE$.assert(this.archiveTask().state() instanceof BeforeUpload);
            long initialTierEndOffset = this.log().tierPartitionState().endOffset();
            if (((ArchiveTask)Await$.MODULE$.result((Awaitable)this.archiveTask().transition(this.log().localLog().time(), this.appender(), (TierObjectStore)this.objectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)new Some((Object)this.throttler()), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()))).state() instanceof Upload) {
                ArchiveTask result2 = (ArchiveTask)Await$.MODULE$.result((Awaitable)this.archiveTask().transition(this.log().localLog().time(), this.appender(), (TierObjectStore)this.objectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)new Some((Object)this.throttler()), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()));
                Predef$.MODULE$.assert(result2.state() instanceof AfterUpload);
                ArchiveTask result3 = (ArchiveTask)Await$.MODULE$.result((Awaitable)this.archiveTask().transition(this.log().localLog().time(), this.appender(), (TierObjectStore)this.objectStore(), this.replicaManager(), this.tierTasksConfig(), (Option)new Some((Object)this.throttler()), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()));
                Predef$.MODULE$.assert(result3.state() instanceof BeforeUpload);
                this.log().tierPartitionState().flush();
                Predef$.MODULE$.assert(initialTierEndOffset != this.log().tierPartitionState().endOffset(), (Function0 & Serializable)() -> "tier end offset should have changed after upload");
                bl = true;
            } else {
                bl = false;
            }
            boolean uploaded = bl;
            Predef$.MODULE$.assert(this.archiveTask().state() instanceof BeforeUpload);
            return uploaded;
        }
        return false;
    }

    public int tierRetention() {
        int deleted = 0;
        if (this.log().tierPartitionState().isTieringEnabled()) {
            try {
                DeletionTask.CollectDeletableObjects state = new DeletionTask.CollectDeletableObjects((DeletionTask.StateMetadata)new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager(), this.log().tierPartitionState().tierEpoch()));
                DeletionTask.State currState = (DeletionTask.State)((Try)((Future)Await$.MODULE$.ready((Awaitable)state.transition((TopicIdPartition)this.log().topicIdPartition().get(), this.replicaManager(), this.appender(), (TierObjectStore)this.objectStore(), this.tierTasksConfig(), this.log().localLog().time(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()))).value().get()).get();
                while (currState instanceof DeletionTask.InitiateDelete) {
                    DeletionTask.State state3 = (DeletionTask.State)((Try)((Future)Await$.MODULE$.ready((Awaitable)currState.transition((TopicIdPartition)this.log().topicIdPartition().get(), this.replicaManager(), this.appender(), (TierObjectStore)this.objectStore(), this.tierTasksConfig(), this.log().localLog().time(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()))).value().get()).get();
                    Predef$.MODULE$.assert(state3 instanceof DeletionTask.Delete);
                    DeletionTask.State completeDelete = (DeletionTask.State)((Try)((Future)Await$.MODULE$.ready((Awaitable)state3.transition((TopicIdPartition)this.log().topicIdPartition().get(), this.replicaManager(), this.appender(), (TierObjectStore)this.objectStore(), this.tierTasksConfig(), this.log().localLog().time(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()))).value().get()).get();
                    Predef$.MODULE$.assert(completeDelete instanceof DeletionTask.CompleteDelete);
                    ++deleted;
                    Future nextIteration = (Future)Await$.MODULE$.ready((Awaitable)completeDelete.transition((TopicIdPartition)this.log().topicIdPartition().get(), this.replicaManager(), this.appender(), (TierObjectStore)this.objectStore(), this.tierTasksConfig(), this.log().localLog().time(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()));
                    nextIteration.value().get();
                    currState = (DeletionTask.State)((Try)nextIteration.value().get()).get();
                }
                Predef$.MODULE$.assert(currState instanceof DeletionTask.CollectDeletableObjects);
            }
            catch (TierMetadataRetriableException tierMetadataRetriableException) {
                Predef$.MODULE$.assert(this.archiveTask().state() instanceof BeforeLeader);
            }
        }
        return deleted;
    }

    public Tuple2<Object, Object> maybeClean(Enumeration.Value expectedValidationResult) {
        return this.maybeClean(true, true, expectedValidationResult);
    }

    public Tuple2<Object, Object> maybeClean(boolean local, boolean tiered, Enumeration.Value expectedValidationResult) {
        long localDirtyOffset = local ? this.maybeLocalClean() : -1L;
        long tierDirtyOffset = tiered ? this.maybeTierClean(expectedValidationResult) : -1L;
        return new Tuple2.mcJJ.sp(localDirtyOffset, tierDirtyOffset);
    }

    public Enumeration.Value maybeClean$default$1() {
        return ValidateLogResult$.MODULE$.Passed();
    }

    /*
     * WARNING - void declaration
     */
    private long maybeLocalClean() {
        if (this.log().isLocallyCompactable()) {
            OffsetsToClean cleaningPoint = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)this.log(), (Option)None$.MODULE$, this.log().localLog().time().milliseconds());
            LogToClean logToClean = new LogToClean(this.log().topicPartition(), (AbstractLog)this.log(), cleaningPoint.firstDirtyOffset(), cleaningPoint.firstUncleanableDirtyOffset(), true);
            if (logToClean.cleanableBytes() > 0L) {
                void var4_4;
                Tuple2 tuple2 = this.cleaner().clean((CleanParams)logToClean);
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                long cleanedEndOffset = tuple2._1$mcJ$sp();
                this.everCompacted_$eq(true);
                return (long)var4_4;
            }
            return cleaningPoint.firstDirtyOffset();
        }
        return -1L;
    }

    private long maybeTierClean(Enumeration.Value expectedValidationResult) {
        if (this.log().isTierCompactable()) {
            try {
                if (CollectionConverters$.MODULE$.IteratorHasAsScala(this.log().tierPartitionState().segments()).asScala().nonEmpty()) {
                    long prevValidationFailedCount = this.compactionTask().tierCompactionMetrics().cleanerMetrics().validationFailedPerSec().count();
                    long prevValidationAbortedCount = this.compactionTask().tierCompactionMetrics().cleanerMetrics().validationAbortedPerSec().count();
                    Await$.MODULE$.result((Awaitable)this.compactionTask().state().transition(this.compactionTask().ctx(), (TopicIdPartition)this.log().topicIdPartition().get(), this.replicaManager(), this.appender(), (TierObjectStore)this.objectStore(), this.tierTasksConfig(), this.throttler(), this.compactionTask().offsetMapSupplier(), this.compactionTask().tierCompactionMetrics(), this.log().localLog().time(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Span$.MODULE$.convertSpanToDuration(SpanSugar$.MODULE$.convertIntToGrainOfTime(1).day()));
                    Enumeration.Value value = expectedValidationResult;
                    Enumeration.Value value2 = ValidateLogResult$.MODULE$.Failed();
                    if (!(value != null ? !value.equals(value2) : value2 != null)) {
                        Predef$.MODULE$.assert(this.compactionTask().tierCompactionMetrics().cleanerMetrics().validationFailedPerSec().count() > prevValidationFailedCount, (Function0 & Serializable)() -> "dual compaction validation is expected to fail");
                    } else {
                        Enumeration.Value value3 = expectedValidationResult;
                        Enumeration.Value value4 = ValidateLogResult$.MODULE$.Aborted();
                        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                            Predef$.MODULE$.assert(this.compactionTask().tierCompactionMetrics().cleanerMetrics().validationAbortedPerSec().count() > prevValidationAbortedCount, (Function0 & Serializable)() -> "dual compaction validation is expected to abort");
                        }
                    }
                }
            }
            catch (TierMetadataRetriableException tierMetadataRetriableException) {
                Predef$.MODULE$.assert(this.archiveTask().state() instanceof BeforeLeader);
            }
            this.everCompacted_$eq(true);
            return this.log().tierPartitionState().compactDirtyStartOffset();
        }
        return -1L;
    }

    public void simulateDataLoss() {
        this.deleteFirstTieredSegment();
    }

    private void deleteFirstTieredSegment() {
        TierLogSegment firstSegment = (TierLogSegment)this.log().tierPartitionState().segments().next();
        TierSegmentDeleteInitiate deleteInitiate = new TierSegmentDeleteInitiate(firstSegment.metadata().topicIdPartition(), firstSegment.metadata().tierEpoch(), firstSegment.objectId(), this.log().tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch());
        this.appender().addMetadata((AbstractTierMetadata)deleteInitiate);
        this.objectStore().deleteSegment(firstSegment.metadata());
        TierSegmentDeleteComplete deleteComplete = new TierSegmentDeleteComplete(firstSegment.metadata().topicIdPartition(), firstSegment.metadata().tierEpoch(), firstSegment.objectId(), this.log().tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), this.log().time().milliseconds());
        this.appender().addMetadata((AbstractTierMetadata)deleteComplete);
    }

    public static final /* synthetic */ void $anonfun$validatePartitionDelete$9(MergedLogHarness $this, TierObjectStore.ObjectMetadata seg) {
        $this.objectStore().innerTierObjectStore().deleteSegment(seg);
    }

    public static final /* synthetic */ void $anonfun$validatePartitionDelete$1(MergedLogHarness $this, TopicIdPartition topicIdPartition) {
        ReplicaManager x$52 = $this.replicaManager();
        MockScheduler x$6 = ((MockTime)$this.log().localLog().time()).scheduler();
        MockTime x$7 = (MockTime)$this.log().localLog().time();
        scala.collection.mutable.Map x$8 = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        TierPartitionStatus x$9 = TierPartitionStatus.INIT;
        MaterializingState$ x$10 = MaterializingState$.MODULE$;
        InProgressDeletion inProgress = new InProgressDeletion(0, topicIdPartition, 0L, null, x$8, x$9, (DeletionState)x$10, x$52, (Scheduler)x$6, (Time)x$7);
        CollectionConverters$.MODULE$.ListHasAsScala($this.appendedMetadata()).asScala().foreach((Function1 & Serializable)metadata -> inProgress.process(metadata, OffsetAndEpoch.EMPTY));
        scala.collection.immutable.Set collectedIds = inProgress.allTieredObjects().map((Function1 & Serializable)x$3 -> x$3.objectId()).toSet();
        scala.collection.immutable.Set stateObjectIds = CollectionConverters$.MODULE$.IteratorHasAsScala($this.log().tierPartitionState().segments()).asScala().$plus$plus((Function0 & Serializable)() -> CollectionConverters$.MODULE$.CollectionHasAsScala($this.log().tierPartitionState().fencedSegments()).asScala()).$plus$plus((Function0 & Serializable)() -> CollectionConverters$.MODULE$.CollectionHasAsScala($this.log().tierPartitionState().compactedSegments()).asScala()).map((Function1 & Serializable)x$4 -> x$4.objectId()).toSet();
        Predef$.MODULE$.assert(stateObjectIds.diff((Set)collectedIds).isEmpty());
        String objectStorePrefix = new StringBuilder(1).append(((TopicIdPartition)$this.log().topicIdPartition().get()).toString()).append("/").toString();
        scala.collection.immutable.Set segmentsInObjectStore = CollectionConverters$.MODULE$.ListHasAsScala(((MockInMemoryTierObjectStore)$this.objectStore().innerTierObjectStore()).getStoredKeys()).asScala().toList().filter((Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)k.endsWith(TierObjectStore.FileType.SEGMENT.suffix()))).toSet();
        scala.collection.immutable.Set toDeleteSegmentKeys = inProgress.allTieredObjects().map((Function1 & Serializable)x$5 -> x$5.toPath(objectStorePrefix, TierObjectStore.FileType.SEGMENT)).toSet();
        Predef$.MODULE$.assert(segmentsInObjectStore.diff((Set)toDeleteSegmentKeys).isEmpty());
        inProgress.allTieredObjects().foreach((Function1 & Serializable)seg -> {
            MergedLogHarness.$anonfun$validatePartitionDelete$9($this, seg);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(CollectionConverters$.MODULE$.ListHasAsScala(((MockInMemoryTierObjectStore)$this.objectStore().innerTierObjectStore()).getStoredKeys()).asScala().isEmpty());
    }

    public static final /* synthetic */ void $anonfun$readKeysAndOffsets$1(MergedLogHarness $this, RecordBatch batch$1, boolean excludeAbortedRecords$1, HashMap offsetMap$1, ListBuffer records$1, ObjectRef priorOffsetRead$1, LongRef fetchOffset$1, Record rec) {
        RecordState recordState = RecordState$.MODULE$.apply(batch$1, rec);
        if (!(batch$1.isControlBatch() || excludeAbortedRecords$1 && MergedLogHarness$.MODULE$.isAbortedProducerId(batch$1.producerId()))) {
            offsetMap$1.put(recordState.key(), BoxesRunTime.boxToLong((long)recordState.offset()));
        }
        records$1.$plus$eq((Object)recordState);
        if (!$this.log().config().compact()) {
            if (((Option)priorOffsetRead$1.elem).isEmpty()) {
                if (rec.offset() > fetchOffset$1.elem) {
                    throw new IllegalThreadStateException("First read offset should never skip forward from the first fetch offset.");
                }
            } else if (BoxesRunTime.unboxToLong((Object)((Option)priorOffsetRead$1.elem).get()) + 1L != rec.offset()) {
                throw new IllegalThreadStateException(new StringBuilder(53).append("Next read offset ").append(rec.offset()).append(" is not equal to prior offset + 1 (").append(fetchOffset$1.elem).append(")").toString());
            }
        }
        priorOffsetRead$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)rec.offset()));
    }

    private final void process$1(RecordBatch batch, boolean excludeAbortedRecords$1, HashMap offsetMap$1, ListBuffer records$1, ObjectRef priorOffsetRead$1, LongRef fetchOffset$1) {
        CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)rec -> {
            MergedLogHarness.$anonfun$readKeysAndOffsets$1(this, batch, excludeAbortedRecords$1, offsetMap$1, records$1, priorOffsetRead$1, fetchOffset$1, rec);
            return BoxedUnit.UNIT;
        });
    }

    private static final void process2$1(RecordBatch batch, LongRef fetchOffset$2) {
        fetchOffset$2.elem = batch.lastOffset() + 1L;
    }

    public static final /* synthetic */ boolean $anonfun$verifyTxns$2(RecordBatch batch) {
        return batch.isTransactional() && !batch.isControlBatch();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTxns$8(MutableRecordBatch batch) {
        return batch.isTransactional() && !batch.isControlBatch();
    }

    public static final /* synthetic */ boolean $anonfun$takeStateSnapshot$1(LogSegment seg) {
        return seg.readNextOffset() != seg.scanNextOffset();
    }

    public MergedLogHarness(MergedLog log, int epoch, HarnessParams params, Throttler throttler, Cleaner cleaner, boolean everCompacted, TierTasksConfig tierTasksConfig, ArchiveTask archiveTask, CompactionTask compactionTask, TierTopicAppender appender, FaultInjectedTierObjectStoreWrapper objectStore, CopyOnWriteArrayList<AbstractTierMetadata> appendedMetadata, ReplicaManager replicaManager) {
        this.log = log;
        this.epoch = epoch;
        this.params = params;
        this.throttler = throttler;
        this.cleaner = cleaner;
        this.everCompacted = everCompacted;
        this.tierTasksConfig = tierTasksConfig;
        this.archiveTask = archiveTask;
        this.compactionTask = compactionTask;
        this.appender = appender;
        this.objectStore = objectStore;
        this.appendedMetadata = appendedMetadata;
        this.replicaManager = replicaManager;
        this.metrics = new Metrics();
        LogManager$.MODULE$.createProducerStateSensors(this.metrics());
    }
}

