/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.OffsetPosition;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\u0005-d\u0001\u0002\u000e\u001c\u0001\u0001BQa\n\u0001\u0005\u0002!B\u0011b\u000b\u0001A\u0002\u0003\u0007I\u0011\u0001\u0017\t\u0013m\u0002\u0001\u0019!a\u0001\n\u0003a\u0004\"\u0003\"\u0001\u0001\u0004\u0005\t\u0015)\u0003.\u0011\u001d\u0019\u0005A1A\u0005\u0002\u0011Ca\u0001\u0013\u0001!\u0002\u0013)\u0005bB%\u0001\u0005\u0004%\tA\u0013\u0005\u0007\u001d\u0002\u0001\u000b\u0011B&\t\u000b=\u0003A\u0011\u0001)\t\u000bq\u0003A\u0011\u0001)\t\u000b\u0005\u0004A\u0011\u0001)\t\u000b\u0019\u0004A\u0011\u0001)\t\u000b!\u0004A\u0011\u0001)\t\u000b)\u0004A\u0011\u0001)\t\u000b1\u0004A\u0011\u0001)\t\u000b9\u0004A\u0011\u0001)\t\u000bA\u0004A\u0011\u0001)\t\u000bI\u0004A\u0011\u0001)\t\u000bQ\u0004A\u0011\u0001)\t\u000bY\u0004A\u0011\u0001)\t\u000ba\u0004A\u0011\u0001)\t\u000bi\u0004A\u0011\u0001)\t\u000bq\u0004A\u0011A?\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u0011q\u000b\u0001\u0005\u0002\u0005e#aD(gMN,G/\u00138eKb$Vm\u001d;\u000b\u0005qi\u0012a\u00017pO*\ta$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002SA\u0011!\u0006A\u0007\u00027\u0005\u0019\u0011\u000e\u001a=\u0016\u00035\u0002\"AL\u001d\u000e\u0003=R!\u0001\b\u0019\u000b\u0005E\u0012\u0014!C5oi\u0016\u0014h.\u00197t\u0015\t\u0019D'A\u0004ti>\u0014\u0018mZ3\u000b\u0005y)$B\u0001\u001c8\u0003\u0019\t\u0007/Y2iK*\t\u0001(A\u0002pe\u001eL!AO\u0018\u0003\u0017=3gm]3u\u0013:$W\r_\u0001\bS\u0012Dx\fJ3r)\ti\u0004\t\u0005\u0002#}%\u0011qh\t\u0002\u0005+:LG\u000fC\u0004B\u0007\u0005\u0005\t\u0019A\u0017\u0002\u0007a$\u0013'\u0001\u0003jIb\u0004\u0013AC7bq\u0016sGO]5fgV\tQ\t\u0005\u0002#\r&\u0011qi\t\u0002\u0004\u0013:$\u0018aC7bq\u0016sGO]5fg\u0002\n!BY1tK>3gm]3u+\u0005Y\u0005C\u0001\u0012M\u0013\ti5E\u0001\u0003M_:<\u0017a\u00032bg\u0016|eMZ:fi\u0002\nQa]3ukB$\u0012!\u0010\u0015\u0003\u0013I\u0003\"a\u0015.\u000e\u0003QS!!\u0016,\u0002\u0007\u0005\u0004\u0018N\u0003\u0002X1\u00069!.\u001e9ji\u0016\u0014(BA-8\u0003\u0015QWO\\5u\u0013\tYFK\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0003\u0015y\u0003\"aU0\n\u0005\u0001$&!C!gi\u0016\u0014X)Y2i\u0003A\u0011\u0018M\u001c3p[2{wn[;q)\u0016\u001cH\u000f\u000b\u0002\fGB\u00111\u000bZ\u0005\u0003KR\u0013A\u0001V3ti\u0006\u0011Bn\\8lkB,\u0005\u0010\u001e:f[\u0016\u001c\u0015m]3tQ\ta1-A\u0005uKN$XI\u001c;ss\"\u0012QbY\u0001\u0012i\u0016\u001cH/\u00128uef|e/\u001a:gY><\bF\u0001\bd\u00035\t\u0007\u000f]3oIR{w.T1os\"\u0012qbY\u0001\u0011CB\u0004XM\u001c3PkR|em\u0014:eKJD#\u0001E2\u00023Q,7\u000f\u001e$fi\u000eDW\u000b\u001d9fe\n{WO\u001c3PM\u001a\u001cX\r\u001e\u0015\u0003#\r\f!\u0002^3tiJ+w\u000e]3oQ\t\u00112-A\u0012uKN$(+Z8qK:4\u0015-\u001b7XQ\u0016tg)\u001b7f\u00032\u0014X-\u00193z\u000bbL7\u000f^:)\u0005M\u0019\u0017\u0001\u0003;sk:\u001c\u0017\r^3)\u0005Q\u0019\u0017A\u00044pe\u000e,WK\\7baR+7\u000f\u001e\u0015\u0003+\r\fQ\u0005^3tiN\u000bg.\u001b;z\u0019\u0006\u001cHo\u00144gg\u0016$X)];bYR{')Y:f\u001f\u001a47/\u001a;)\u0005Y\u0019\u0017\u0001E1tg\u0016\u0014Ho\u0016:ji\u00164\u0015-\u001b7t+\rq\u0018Q\u0006\u000b\t{}\fI\"a\u0007\u0002 !9\u0011\u0011A\fA\u0002\u0005\r\u0011aB7fgN\fw-\u001a\t\u0005\u0003\u000b\t\u0019B\u0004\u0003\u0002\b\u0005=\u0001cAA\u0005G5\u0011\u00111\u0002\u0006\u0004\u0003\u001by\u0012A\u0002\u001fs_>$h(C\u0002\u0002\u0012\r\na\u0001\u0015:fI\u00164\u0017\u0002BA\u000b\u0003/\u0011aa\u0015;sS:<'bAA\tG!)1f\u0006a\u0001[!1\u0011QD\fA\u0002\u0015\u000baa\u001c4gg\u0016$\bbBA\u0011/\u0001\u0007\u00111E\u0001\u0006W2\f7o\u001d\t\u0007\u0003\u000b\t)#!\u000b\n\t\u0005\u001d\u0012q\u0003\u0002\u0006\u00072\f7o\u001d\t\u0005\u0003W\ti\u0003\u0004\u0001\u0005\u000f\u0005=rC1\u0001\u00022\t\tA+\u0005\u0003\u00024\u0005e\u0002c\u0001\u0012\u00026%\u0019\u0011qG\u0012\u0003\u000f9{G\u000f[5oOB\u0019!%a\u000f\n\u0007\u0005u2EA\u0002B]f\fA\"\\8o_R|g.[2TKF$b!a\u0011\u0002P\u0005M\u0003#BA#\u0003\u0017*UBAA$\u0015\r\tIeI\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA'\u0003\u000f\u00121aU3r\u0011\u0019\t\t\u0006\u0007a\u0001\u000b\u0006!!-Y:f\u0011\u0019\t)\u0006\u0007a\u0001\u000b\u0006\u0019A.\u001a8\u0002'9|g.\u0012=jgR,g\u000e\u001e+f[B4\u0015\u000e\\3\u0015\u0005\u0005m\u0003\u0003BA/\u0003Oj!!a\u0018\u000b\t\u0005\u0005\u00141M\u0001\u0003S>T!!!\u001a\u0002\t)\fg/Y\u0005\u0005\u0003S\nyF\u0001\u0003GS2,\u0007")
public class OffsetIndexTest {
    private OffsetIndex idx;
    private final int maxEntries;
    private final long baseOffset;

    public OffsetIndex idx() {
        return this.idx;
    }

    public void idx_$eq(OffsetIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    @BeforeEach
    public void setup() {
        this.idx_$eq(new OffsetIndex(this.nonExistentTempFile(), this.baseOffset(), 240));
    }

    @AfterEach
    public void teardown() {
        if (this.idx() != null) {
            this.idx().file().delete();
            return;
        }
    }

    @Test
    public void randomLookupTest() {
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(92L), (String)"Not present value should return physical offset 0.");
        int base = (int)this.idx().baseOffset() + 1;
        int size = this.idx().maxEntries();
        Seq vals = (Seq)((IterableOps)this.monotonicSeq(base, size).map((Function1)(JFunction1.mcJI.sp & Serializable)x$2 -> x$2)).zip(this.monotonicSeq(0, size));
        vals.foreach((Function1 & Serializable)x -> {
            OffsetIndexTest.$anonfun$randomLookupTest$2(this, x);
            return BoxedUnit.UNIT;
        });
        vals.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)OffsetIndexTest.$anonfun$randomLookupTest$3(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
            OffsetIndexTest.$anonfun$randomLookupTest$4(this, x$3);
            return BoxedUnit.UNIT;
        });
        TreeMap valMap = (TreeMap)new TreeMap((Ordering)Ordering.Long$.MODULE$).$plus$plus((IterableOnce)vals.map((Function1 & Serializable)p -> new Tuple2((Object)BoxesRunTime.boxToLong((long)p._1$mcJ$sp()), p)));
        long[] offsets = (long[])new RichLong(Predef$.MODULE$.longWrapper(this.idx().baseOffset())).until((Object)BoxesRunTime.boxToLong((long)((int)((Tuple2)vals.last())._1$mcJ$sp()))).toArray((ClassTag)ClassTag$.MODULE$.Long());
        Collections.shuffle(Arrays.asList(new long[][]{offsets}));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.longArrayOps(offsets), 30)), (Function1)(JFunction1.mcVJ.sp & Serializable)offset -> Assertions.assertEquals((Object)(offset < BoxesRunTime.unboxToLong((Object)valMap.firstKey()) ? new OffsetPosition(this.idx().baseOffset(), 0) : new OffsetPosition(((TreeMap)valMap.to((Object)BoxesRunTime.boxToLong((long)offset))).last()._1$mcJ$sp(), ((Tuple2)((TreeMap)valMap.to((Object)BoxesRunTime.boxToLong((long)offset))).last()._2())._2$mcI$sp())), (Object)this.idx().lookup(offset), (String)"The index should give the same answer as the sorted map"));
    }

    @Test
    public void lookupExtremeCases() {
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()), (String)"Lookup on empty file");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.idx().append(this.idx().baseOffset() + (long)i + 1L, i));
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)this.idx().maxEntries(), this.idx().maxEntries() - 1), (Object)this.idx().lookup(this.idx().baseOffset() + (long)this.idx().maxEntries()));
    }

    @Test
    public void testEntry() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.idx().append(this.idx().baseOffset() + (long)i + 1L, i));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)i + 1L, i), (Object)this.idx().entry(i)));
    }

    @Test
    public void testEntryOverflow() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.idx().entry(0));
    }

    @Test
    public void appendTooMany() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            long offset = this.idx().baseOffset() + (long)i + 1L;
            this.idx().append(offset, i);
        });
        this.assertWriteFails("Append should fail on a full index", this.idx(), this.idx().maxEntries() + 1, IllegalArgumentException.class);
    }

    @Test
    public void appendOutOfOrder() {
        this.idx().append(51L, 0);
        Assertions.assertThrows(InvalidOffsetException.class, () -> this.idx().append(50L, 1));
    }

    @Test
    public void testFetchUpperBoundOffset() {
        OffsetPosition first = new OffsetPosition(this.baseOffset() + 0L, 0);
        OffsetPosition second = new OffsetPosition(this.baseOffset() + 1L, 10);
        OffsetPosition third = new OffsetPosition(this.baseOffset() + 2L, 23);
        OffsetPosition fourth = new OffsetPosition(this.baseOffset() + 3L, 37);
        Assertions.assertEquals(Optional.empty(), (Object)this.idx().fetchUpperBoundOffset(first, 5));
        new .colon.colon((Object)first, (List)new .colon.colon((Object)second, (List)new .colon.colon((Object)third, (List)new .colon.colon((Object)fourth, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)offsetPosition -> {
            OffsetIndexTest.$anonfun$testFetchUpperBoundOffset$1(this, offsetPosition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(Optional.of(second), (Object)this.idx().fetchUpperBoundOffset(first, 5));
        Assertions.assertEquals(Optional.of(second), (Object)this.idx().fetchUpperBoundOffset(first, 10));
        Assertions.assertEquals(Optional.of(third), (Object)this.idx().fetchUpperBoundOffset(first, 23));
        Assertions.assertEquals(Optional.of(third), (Object)this.idx().fetchUpperBoundOffset(first, 22));
        Assertions.assertEquals(Optional.of(fourth), (Object)this.idx().fetchUpperBoundOffset(second, 24));
        Assertions.assertEquals(Optional.empty(), (Object)this.idx().fetchUpperBoundOffset(fourth, 1));
        Assertions.assertEquals(Optional.empty(), (Object)this.idx().fetchUpperBoundOffset(first, 200));
        Assertions.assertEquals(Optional.empty(), (Object)this.idx().fetchUpperBoundOffset(second, 200));
    }

    @Test
    public void testReopen() {
        OffsetPosition first = new OffsetPosition(51L, 0);
        OffsetPosition sec = new OffsetPosition(52L, 1);
        this.idx().append(first.offset, first.position);
        this.idx().append(sec.offset, sec.position);
        this.idx().close();
        OffsetIndex idxRo = new OffsetIndex(this.idx().file(), this.idx().baseOffset(), -1, true, true);
        Assertions.assertEquals((Object)first, (Object)idxRo.lookup(first.offset));
        Assertions.assertEquals((Object)sec, (Object)idxRo.lookup(sec.offset));
        Assertions.assertEquals((long)sec.offset, (long)idxRo.lastOffset());
        Assertions.assertEquals((int)2, (int)idxRo.entries());
        this.assertWriteFails("Append should fail on read-only index", idxRo, 53, IllegalArgumentException.class);
    }

    @Test
    public void testReopenFailWhenFileAlreadyExists() {
        OffsetPosition entry = new OffsetPosition(51L, 0);
        this.idx().append(entry.offset, entry.position);
        this.idx().close();
        Assertions.assertThrows(IllegalStateException.class, () -> new OffsetIndex(this.idx().file(), this.idx().baseOffset()));
        this.idx_$eq(new OffsetIndex(this.idx().file(), this.idx().baseOffset(), -1, true, true));
    }

    @Test
    public void truncate() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80);
        idx.truncate();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> idx.append((long)i, i));
        idx.truncateTo(12L);
        Assertions.assertEquals((Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L), (String)"Index should be unchanged by truncate past the end");
        Assertions.assertEquals((long)9L, (long)idx.lastOffset(), (String)"9 should be the last entry in the index");
        idx.append(10L, 10);
        idx.truncateTo(10L);
        Assertions.assertEquals((Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L), (String)"Index should be unchanged by truncate at the end");
        Assertions.assertEquals((long)9L, (long)idx.lastOffset(), (String)"9 should be the last entry in the index");
        idx.append(10L, 10);
        idx.truncateTo(9L);
        Assertions.assertEquals((Object)new OffsetPosition(8L, 8), (Object)idx.lookup(10L), (String)"Index should truncate off last entry");
        Assertions.assertEquals((long)8L, (long)idx.lastOffset(), (String)"8 should be the last entry in the index");
        idx.append(9L, 9);
        idx.truncateTo(5L);
        Assertions.assertEquals((Object)new OffsetPosition(4L, 4), (Object)idx.lookup(10L), (String)"4 should be the last entry in the index");
        Assertions.assertEquals((long)4L, (long)idx.lastOffset(), (String)"4 should be the last entry in the index");
        idx.append(5L, 5);
        idx.truncate();
        Assertions.assertEquals((int)0, (int)idx.entries(), (String)"Full truncation should leave no entries");
        idx.append(0L, 0);
    }

    @Test
    public void forceUnmapTest() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80);
        idx.forceUnmap();
        Assertions.assertThrows(NullPointerException.class, () -> idx.lookup(1L));
    }

    @Test
    public void testSanityLastOffsetEqualToBaseOffset() {
        long baseOffset = 20L;
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), baseOffset, 80);
        idx.append(baseOffset, 0);
        idx.sanityCheck();
    }

    public <T> void assertWriteFails(String message, OffsetIndex idx, int offset, Class<T> klass) {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> idx.append((long)offset, 1), () -> message);
        Assertions.assertEquals(klass, e.getClass(), (String)"Got an unexpected exception.");
    }

    public Seq<Object> monotonicSeq(int base, int len) {
        Random rand = new Random(1L);
        ArrayBuffer vals = new ArrayBuffer(len);
        IntRef last = IntRef.create((int)base);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach((Function1 & Serializable)x$4 -> OffsetIndexTest.$anonfun$monotonicSeq$1(last, rand, vals, BoxesRunTime.unboxToInt((Object)x$4)));
        return vals;
    }

    public File nonExistentTempFile() {
        File file = TestUtils.tempFile((String)"kafka", (String)".tmp");
        Files.delete(file.toPath());
        return file;
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$2(OffsetIndexTest $this, Tuple2 x) {
        $this.idx().append(x._1$mcJ$sp(), x._2$mcI$sp());
    }

    public static final /* synthetic */ boolean $anonfun$randomLookupTest$3(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$4(OffsetIndexTest $this, Tuple2 x$3) {
        if (x$3 != null) {
            long logical = x$3._1$mcJ$sp();
            int physical = x$3._2$mcI$sp();
            Assertions.assertEquals((Object)new OffsetPosition(logical, physical), (Object)$this.idx().lookup(logical), (String)"Should be able to find values that are present.");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testFetchUpperBoundOffset$1(OffsetIndexTest $this, OffsetPosition offsetPosition) {
        $this.idx().append(offsetPosition.offset, offsetPosition.position);
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$monotonicSeq$1(IntRef last$1, Random rand$1, ArrayBuffer vals$1, int x$4) {
        last$1.elem += rand$1.nextInt(15) + 1;
        return (ArrayBuffer)vals$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)last$1.elem));
    }

    public OffsetIndexTest() {
        this.maxEntries = 30;
        this.baseOffset = 45L;
    }
}

