/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileStore;
import java.util.Map;
import java.util.Properties;
import kafka.log.SegmentDeletionThrottlerConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001\u0002\r\u001a\u0001yAQ!\n\u0001\u0005\u0002\u00192A!\u000b\u0001\u0001U!AaF\u0001B\u0001B\u0003%q\u0006\u0003\u0005=\u0005\t\u0005\t\u0015!\u0003>\u0011!\u0019%A!A!\u0002\u0013!\u0005\"B\u0013\u0003\t\u00039\u0005\"B'\u0003\t\u0003r\u0005b\u0002\u0018\u0001\u0005\u0004%\t\u0001\u001b\u0005\u0007]\u0002\u0001\u000b\u0011B5\t\u000f\u0001\u0004!\u0019!C\u0001_\"1\u0001\u000f\u0001Q\u0001\n\u0005Dq!\u001d\u0001C\u0002\u0013\u0005!\u000fC\u0004\u0002\u0006\u0001\u0001\u000b\u0011B:\t\u0013\u0005\u001d\u0001A1A\u0005\u0002\u0005%\u0001bBA\u0006\u0001\u0001\u0006I\u0001\u0012\u0005\n\u0003\u001b\u0001!\u0019!C\u0001\u0003\u001fA\u0001\"a\u0006\u0001A\u0003%\u0011\u0011\u0003\u0005\ty\u0001\u0011\r\u0011\"\u0001\u0002\u001a!9\u00111\u0004\u0001!\u0002\u0013i\u0004\"CA\u000f\u0001\t\u0007I\u0011AA\u0010\u0011\u001d\t\t\u0003\u0001Q\u0001\n!Cq!a\t\u0001\t\u0003\t)\u0003C\u0004\u0002D\u0001!\t!!\n\u0003EM+w-\\3oi\u0012+G.\u001a;j_:$\u0006N]8ui2,'oQ8oM&<G+Z:u\u0015\tQ2$A\u0002m_\u001eT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0002\"\u0001\u000b\u0001\u000e\u0003e\u0011!\u0005V3tiN+w-\\3oi\u0012+G.\u001a;j_:$\u0006N]8ui2,'oQ8oM&<7C\u0001\u0002,!\tAC&\u0003\u0002.3\tq2+Z4nK:$H)\u001a7fi&|g\u000e\u00165s_R$H.\u001a:D_:4\u0017nZ\u0001\u0005i&lW\r\u0005\u00021u5\t\u0011G\u0003\u00023g\u0005)Q\u000f^5mg*\u0011A'N\u0001\u0007G>lWn\u001c8\u000b\u0005q1$BA\u001c9\u0003\u0019\t\u0007/Y2iK*\t\u0011(A\u0002pe\u001eL!aO\u0019\u0003\tQKW.Z\u0001\u0007G>tg-[4\u0011\u0005y\nU\"A \u000b\u0005\u0001[\u0012AB:feZ,'/\u0003\u0002C\u007f\tY1*\u00194lC\u000e{gNZ5h\u0003M!\u0017n]6DQ\u0016\u001c7.T5o\t\u0016d\u0017-_'t!\t\u0001S)\u0003\u0002GC\t\u0019\u0011J\u001c;\u0015\t!S5\n\u0014\t\u0003\u0013\ni\u0011\u0001\u0001\u0005\u0006]\u0019\u0001\ra\f\u0005\u0006y\u0019\u0001\r!\u0010\u0005\u0006\u0007\u001a\u0001\r\u0001R\u0001\u000bM&dWm\u0015;pe\u0016\u001cHCA(`!\r\u00016+V\u0007\u0002#*\u0011!+I\u0001\u000bG>dG.Z2uS>t\u0017B\u0001+R\u0005\r\u0019V-\u001d\t\u0003-vk\u0011a\u0016\u0006\u00031f\u000bAAZ5mK*\u0011!lW\u0001\u0004]&|'\"\u0001/\u0002\t)\fg/Y\u0005\u0003=^\u0013\u0011BR5mKN#xN]3\t\u000b\u0001<\u0001\u0019A1\u0002\u000f1|w\rR5sgB\u0019\u0001k\u00152\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015\\\u0016AA5p\u0013\t9GM\u0001\u0003GS2,W#A5\u0011\u0005)dW\"A6\u000b\u0005IZ\u0012BA7l\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004S#A1\u0002\u00111|w\rR5sg\u0002\na\u0002^3ti\u001aKG.Z*u_J,7/F\u0001t!\r\u00016\u000b\u001e\t\u0003k~t!A^?\u000f\u0005]dhB\u0001=|\u001b\u0005I(B\u0001>\u001e\u0003\u0019a$o\\8u}%\tA$\u0003\u000237%\u0011ap[\u0001\n)\u0016\u001cH/\u0016;jYNLA!!\u0001\u0002\u0004\t1B)\u001a;fe6Lg.[:uS\u000e4\u0015\u000e\\3Ti>\u0014XM\u0003\u0002\u007fW\u0006yA/Z:u\r&dWm\u0015;pe\u0016\u001c\b%\u0001\teSN\\7\t[3dW\u0012+G.Y=NgV\tA)A\teSN\\7\t[3dW\u0012+G.Y=Ng\u0002\na\u0005Z3mKRLwN\u001c+ie>$H\u000f\\3s\t&\u001c8N\u0012:fK\"+\u0017\r\u001a:p_6\u0014\u0015\u0010^3t+\t\t\t\u0002E\u0002!\u0003'I1!!\u0006\"\u0005\u0011auN\\4\u0002O\u0011,G.\u001a;j_:$\u0006N]8ui2,'\u000fR5tW\u001a\u0013X-\u001a%fC\u0012\u0014xn\\7CsR,7\u000fI\u000b\u0002{\u000591m\u001c8gS\u001e\u0004\u0013A\u0003;fgR\u001cuN\u001c4jOV\t\u0001*A\u0006uKN$8i\u001c8gS\u001e\u0004\u0013\u0001\t;fgR,\u0006\u000fZ1uK\u0012K7o\u001b$sK\u0016$\u0006N]3tQ>dGMQ=uKN$\"!a\n\u0011\u0007\u0001\nI#C\u0002\u0002,\u0005\u0012A!\u00168ji\"\u001aa#a\f\u0011\t\u0005E\u0012qH\u0007\u0003\u0003gQA!!\u000e\u00028\u0005\u0019\u0011\r]5\u000b\t\u0005e\u00121H\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\ti\u0004O\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u0003\n\u0019D\u0001\u0003UKN$\u0018a\u000b;fgR<U\r\u001e#fY\u0016$\u0018n\u001c8NCb\u001cVmZ7f]R\u001c\b+\u001a:Sk:$&/\u00198tSRLwN\\:)\u0007]\ty\u0003")
public class SegmentDeletionThrottlerConfigTest {
    private final MockTime time = new MockTime();
    private final Seq<File> logDirs = new .colon.colon((Object)TestUtils.tempFile((String)"kafka", (String)".tmp"), (List)new .colon.colon((Object)TestUtils.tempFile((String)"kafka", (String)".tmp"), (List)Nil$.MODULE$));
    private final Seq<TestUtils.DeterministicFileStore> testFileStores = (Seq)this.logDirs().map((Function1 & Serializable)x$1 -> new TestUtils.DeterministicFileStore(TestUtils$.MODULE$.DefaultTotalAvailableBytes(), TestUtils$.MODULE$.DefaultInitialUsableBytes()));
    private final int diskCheckDelayMs;
    private final long deletionThrottlerDiskFreeHeadroomBytes;
    private final KafkaConfig config;
    private final TestSegmentDeletionThrottlerConfig testConfig;

    public MockTime time() {
        return this.time;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Seq<TestUtils.DeterministicFileStore> testFileStores() {
        return this.testFileStores;
    }

    public int diskCheckDelayMs() {
        return this.diskCheckDelayMs;
    }

    public long deletionThrottlerDiskFreeHeadroomBytes() {
        return this.deletionThrottlerDiskFreeHeadroomBytes;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public TestSegmentDeletionThrottlerConfig testConfig() {
        return this.testConfig;
    }

    @Test
    public void testUpdateDiskFreeThresholdBytes() {
        Assertions.assertEquals((long)this.deletionThrottlerDiskFreeHeadroomBytes(), (long)this.testConfig().diskFreeThresholdBytes());
        this.testConfig().maybeUpdateDiskFreeThresholdBytes(false, 0x500000000L);
        Assertions.assertEquals((long)this.deletionThrottlerDiskFreeHeadroomBytes(), (long)this.testConfig().diskFreeThresholdBytes());
        this.testConfig().maybeUpdateDiskFreeThresholdBytes(true, 0x500000000L);
        Assertions.assertEquals((long)0xF00000000L, (long)this.testConfig().diskFreeThresholdBytes());
    }

    @Test
    public void testGetDeletionMaxSegmentsPerRunTransitions() {
        Assertions.assertEquals((int)25, (int)this.testConfig().deletionMaxSegmentsPerRun(this.logDirs()));
        Assertions.assertTrue((boolean)this.testConfig().isDeletionMaxSegmentsPerRunEnabled());
        this.time().sleep(this.diskCheckDelayMs());
        Assertions.assertEquals((int)25, (int)this.testConfig().deletionMaxSegmentsPerRun(this.logDirs()));
        Assertions.assertTrue((boolean)this.testConfig().isDeletionMaxSegmentsPerRunEnabled());
        this.time().sleep(this.diskCheckDelayMs());
        this.testFileStores().headOption().foreach((Function1 & Serializable)fileStore -> {
            SegmentDeletionThrottlerConfigTest.$anonfun$testGetDeletionMaxSegmentsPerRunTransitions$1(this, fileStore);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)25, (int)this.testConfig().deletionMaxSegmentsPerRun(this.logDirs()));
        Assertions.assertTrue((boolean)this.testConfig().isDeletionMaxSegmentsPerRunEnabled());
        this.testFileStores().headOption().foreach((Function1 & Serializable)fileStore -> {
            fileStore.writeLargeFile(1L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)25, (int)this.testConfig().deletionMaxSegmentsPerRun(this.logDirs()));
        Assertions.assertTrue((boolean)this.testConfig().isDeletionMaxSegmentsPerRunEnabled());
        this.time().sleep(this.diskCheckDelayMs());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)this.testConfig().deletionMaxSegmentsPerRun(this.logDirs()));
        Assertions.assertFalse((boolean)this.testConfig().isDeletionMaxSegmentsPerRunEnabled());
        this.testFileStores().headOption().foreach((Function1 & Serializable)fileStore -> {
            fileStore.deleteLargeFile(1L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)this.testConfig().deletionMaxSegmentsPerRun(this.logDirs()));
        Assertions.assertFalse((boolean)this.testConfig().isDeletionMaxSegmentsPerRunEnabled());
        this.time().sleep(this.diskCheckDelayMs());
        Assertions.assertEquals((int)25, (int)this.testConfig().deletionMaxSegmentsPerRun(this.logDirs()));
        Assertions.assertTrue((boolean)this.testConfig().isDeletionMaxSegmentsPerRunEnabled());
    }

    public static final /* synthetic */ void $anonfun$testGetDeletionMaxSegmentsPerRunTransitions$1(SegmentDeletionThrottlerConfigTest $this, TestUtils.DeterministicFileStore fileStore) {
        long fileSize = fileStore.getUsableSpace() - $this.testConfig().diskFreeThresholdBytes();
        Assertions.assertTrue((fileSize > 0L ? 1 : 0) != 0);
        fileStore.writeLargeFile(fileSize);
    }

    public SegmentDeletionThrottlerConfigTest() {
        this.diskCheckDelayMs = 100;
        this.deletionThrottlerDiskFreeHeadroomBytes = 0xA00000000L;
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), TestUtils$.MODULE$.MockZkConnect());
        props.put(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "25");
        props.put(KafkaConfig$.MODULE$.LogDeletionThrottlerDiskFreeHeadroomBytesProp(), Long.toString(this.deletionThrottlerDiskFreeHeadroomBytes()));
        this.config = new KafkaConfig((Map)props);
        this.testConfig = new TestSegmentDeletionThrottlerConfig((Time)this.time(), this.config(), this.diskCheckDelayMs());
    }

    public class TestSegmentDeletionThrottlerConfig
    extends SegmentDeletionThrottlerConfig {
        public Seq<FileStore> fileStores(Seq<File> logDirs) {
            return this.kafka$log$SegmentDeletionThrottlerConfigTest$TestSegmentDeletionThrottlerConfig$$$outer().testFileStores();
        }

        public /* synthetic */ SegmentDeletionThrottlerConfigTest kafka$log$SegmentDeletionThrottlerConfigTest$TestSegmentDeletionThrottlerConfig$$$outer() {
            return SegmentDeletionThrottlerConfigTest.this;
        }

        public TestSegmentDeletionThrottlerConfig(Time time, KafkaConfig config, int diskCheckMinDelayMs) {
            if (SegmentDeletionThrottlerConfigTest.this == null) {
                throw null;
            }
            super(time, config, diskCheckMinDelayMs);
        }
    }
}

