/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.PrintWriter;
import kafka.log.StrayLogMetadataFile$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Option$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005I3AAC\u0006\u0001!!)q\u0003\u0001C\u00011!91\u0004\u0001b\u0001\n\u0003a\u0002BB\u0013\u0001A\u0003%Q\u0004C\u0004'\u0001\t\u0007I\u0011A\u0014\t\rM\u0002\u0001\u0015!\u0003)\u0011\u001d!\u0004A1A\u0005\u0002UBaa\u0010\u0001!\u0002\u00131\u0004\"\u0002!\u0001\t\u0003\t\u0005\"\u0002)\u0001\t\u0003\t%\u0001G*ue\u0006LHj\\4NKR\fG-\u0019;b\r&dW\rV3ti*\u0011A\"D\u0001\u0004Y><'\"\u0001\b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Ui\u0011a\u0005\u0006\u0002)\u0005)1oY1mC&\u0011ac\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005Y\u0011A\u00027pO\u0012K'/F\u0001\u001e!\tq2%D\u0001 \u0015\t\u0001\u0013%\u0001\u0002j_*\t!%\u0001\u0003kCZ\f\u0017B\u0001\u0013 \u0005\u00111\u0015\u000e\\3\u0002\u000f1|w\rR5sA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tW#\u0001\u0015\u0011\u0005%\nT\"\u0001\u0016\u000b\u0005-b\u0013AB2p[6|gN\u0003\u0002\u000f[)\u0011afL\u0001\u0007CB\f7\r[3\u000b\u0003A\n1a\u001c:h\u0013\t\u0011$F\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\nA\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016dW#\u0001\u001c\u0011\u0005]jT\"\u0001\u001d\u000b\u00051I$B\u0001\u001e<\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002=Y\u000591\u000f^8sC\u001e,\u0017B\u0001 9\u0005Qaun\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0006)Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u0004\u0013!\n;fgR\u001c%/Z1uK\u0006sGMU3bIN#(/Y=M_\u001elU\r^1eCR\fg)\u001b7f)\u0005\u0011\u0005C\u0001\nD\u0013\t!5C\u0001\u0003V]&$\bF\u0001\u0005G!\t9e*D\u0001I\u0015\tI%*A\u0002ba&T!a\u0013'\u0002\u000f),\b/\u001b;fe*\u0011QjL\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u001f\"\u0013A\u0001V3ti\u0006aC/Z:u\u000bb\u001cW\r\u001d;j_:<\u0006.\u001a8SK\u0006$\u0017N\\4TiJ\f\u0017\u0010T8h\u001b\u0016$\u0018\rZ1uC\u001aKG.\u001a\u0015\u0003\u0013\u0019\u0003")
public class StrayLogMetadataFileTest {
    private final File logDir = TestUtils.tempDirectory(null, null);
    private final TopicPartition topicPartition = new TopicPartition("test", 123);
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    @Test
    public void testCreateAndReadStrayLogMetadataFile() {
        StrayLogMetadataFile$.MODULE$.createFileWithData(this.logDir(), this.topicPartition(), this.logDirFailureChannel());
        Assertions.assertTrue((boolean)new File(this.logDir(), "partition.stray").exists());
        TopicPartition topicPartitionFromFile = (TopicPartition)StrayLogMetadataFile$.MODULE$.read(this.logDir(), this.logDirFailureChannel()).get();
        Assertions.assertEquals((Object)this.topicPartition(), (Object)topicPartitionFromFile);
        Utils.delete((File)this.logDir(), (boolean)false);
    }

    @Test
    public void testExceptionWhenReadingStrayLogMetadataFile() {
        Assertions.assertEquals((Object)Option$.MODULE$.empty(), (Object)StrayLogMetadataFile$.MODULE$.read(this.logDir(), this.logDirFailureChannel()));
        StrayLogMetadataFile$.MODULE$.createFileWithData(this.logDir(), this.topicPartition(), this.logDirFailureChannel());
        File strayLogMetadataFile = new File(this.logDir(), "partition.stray");
        Assertions.assertTrue((boolean)strayLogMetadataFile.exists());
        PrintWriter pw = new PrintWriter(strayLogMetadataFile);
        pw.print("aaa");
        pw.close();
        Assertions.assertThrows(KafkaException.class, () -> StrayLogMetadataFile$.MODULE$.read(this.logDir(), this.logDirFailureChannel()));
        Utils.delete((File)this.logDir(), (boolean)false);
    }
}

