/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import kafka.metrics.ConsumerLagEmitter;
import kafka.metrics.ConsumerLagEmitter$;
import kafka.metrics.MemberTopicPartition;
import kafka.utils.MockTime;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r\u001de\u0001\u0002'N\u0001ICQ!\u0017\u0001\u0005\u0002iCqA\u0014\u0001A\u0002\u0013%Q\fC\u0004k\u0001\u0001\u0007I\u0011B6\t\rE\u0004\u0001\u0015)\u0003_\u0011\u001d\u0011\b\u00011A\u0005\nMDq\u0001 \u0001A\u0002\u0013%Q\u0010\u0003\u0004\u0000\u0001\u0001\u0006K\u0001\u001e\u0005\n\u0003\u0003\u0001\u0001\u0019!C\u0005\u0003\u0007A\u0011\"!\u0006\u0001\u0001\u0004%I!a\u0006\t\u0011\u0005m\u0001\u0001)Q\u0005\u0003\u000bA\u0011\"!\b\u0001\u0001\u0004%I!a\b\t\u0013\u0005E\u0002\u00011A\u0005\n\u0005M\u0002\u0002CA\u001c\u0001\u0001\u0006K!!\t\t\u0013\u0005e\u0002\u00011A\u0005\n\u0005m\u0002\"CA\"\u0001\u0001\u0007I\u0011BA#\u0011!\tI\u0005\u0001Q!\n\u0005u\u0002\"CA&\u0001\t\u0007I\u0011BA'\u0011!\tY\u0006\u0001Q\u0001\n\u0005=\u0003\"CA/\u0001\t\u0007I\u0011BA0\u0011!\t9\b\u0001Q\u0001\n\u0005\u0005\u0004\"CA=\u0001\t\u0007I\u0011BA>\u0011!\tY\t\u0001Q\u0001\n\u0005u\u0004\"CAG\u0001\t\u0007I\u0011BA>\u0011!\ty\t\u0001Q\u0001\n\u0005u\u0004\"CAI\u0001\t\u0007I\u0011BAJ\u0011!\t)\u000b\u0001Q\u0001\n\u0005U\u0005\"CAT\u0001\t\u0007I\u0011BAU\u0011!\t\u0019\f\u0001Q\u0001\n\u0005-\u0006\"CA[\u0001\t\u0007I\u0011BAU\u0011!\t9\f\u0001Q\u0001\n\u0005-\u0006\"CA]\u0001\t\u0007I\u0011BAU\u0011!\tY\f\u0001Q\u0001\n\u0005-\u0006\"CA_\u0001\t\u0007I\u0011BAU\u0011!\ty\f\u0001Q\u0001\n\u0005-\u0006\"CAa\u0001\t\u0007I\u0011BA>\u0011!\t\u0019\r\u0001Q\u0001\n\u0005u\u0004\"CAc\u0001\t\u0007I\u0011BA>\u0011!\t9\r\u0001Q\u0001\n\u0005u\u0004bBAe\u0001\u0011\u0005\u00111\u001a\u0005\b\u0003G\u0004A\u0011AAf\u0011\u001d\ti\u000f\u0001C\u0001\u0003\u0017Dq!a>\u0001\t\u0003\tY\rC\u0004\u0002|\u0002!\t!a3\t\u000f\u0005}\b\u0001\"\u0001\u0002L\"9!1\u0001\u0001\u0005\u0002\u0005-\u0007b\u0002B\u0004\u0001\u0011\u0005\u00111\u001a\u0005\b\u0005\u0017\u0001A\u0011AAf\u0011\u001d\u0011y\u0001\u0001C\u0001\u0003\u0017DqAa\u0005\u0001\t\u0003\tY\rC\u0004\u0003\u0018\u0001!\t!a3\t\u000f\tm\u0001\u0001\"\u0001\u0003\u001e!9!1\u0005\u0001\u0005\u0002\u0005-\u0007b\u0002B\u0014\u0001\u0011\u0005\u00111\u001a\u0005\b\u0005W\u0001A\u0011AAf\u0011\u001d\u0011y\u0003\u0001C\u0001\u0003\u0017DqAa\r\u0001\t\u0003\tY\rC\u0004\u00038\u0001!\t!a3\t\u000f\tm\u0002\u0001\"\u0001\u0002L\"9!q\b\u0001\u0005\u0002\u0005-\u0007b\u0002B\"\u0001\u0011\u0005\u00111\u001a\u0005\b\u0005\u000f\u0002A\u0011\u0002B%\u0011\u001d\u0011y\u0006\u0001C\u0005\u0005CBqAa!\u0001\t\u0013\u0011)\tC\u0004\u00036\u0002!IAa.\t\u000f\t%\u0007\u0001\"\u0003\u0003L\"9!q\u001c\u0001\u0005\n\t\u0005\bb\u0002B\u007f\u0001\u0011%!q \u0005\b\u0007\u000b\u0001A\u0011BB\u0004\u0011%\u0019I\u0003AI\u0001\n\u0013\u0019Y\u0003C\u0004\u0004B\u0001!Iaa\u0011\t\u000f\r\u001d\u0003\u0001\"\u0003\u0004J!911\u000b\u0001\u0005\n\rU\u0003\"CB4\u0001E\u0005I\u0011BB\u0016\u0011\u001d\u0019I\u0007\u0001C\u0005\u0007WBqaa\u001f\u0001\t\u0013\u0019iH\u0001\fD_:\u001cX/\\3s\u0019\u0006<W)\\5ui\u0016\u0014H+Z:u\u0015\tqu*A\u0004nKR\u0014\u0018nY:\u000b\u0003A\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001'B\u0011AkV\u0007\u0002+*\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y+\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A.\u0011\u0005q\u0003Q\"A'\u0016\u0003y\u0003\"a\u00185\u000e\u0003\u0001T!AT1\u000b\u0005\t\u001c\u0017AB2p[6|gN\u0003\u0002QI*\u0011QMZ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\f1a\u001c:h\u0013\tI\u0007MA\u0004NKR\u0014\u0018nY:\u0002\u00175,GO]5dg~#S-\u001d\u000b\u0003Y>\u0004\"\u0001V7\n\u00059,&\u0001B+oSRDq\u0001]\u0002\u0002\u0002\u0003\u0007a,A\u0002yIE\n\u0001\"\\3ue&\u001c7\u000fI\u0001\u0010[>\u001c7.\u00113nS:\u001cE.[3oiV\tA\u000f\u0005\u0002vu6\taO\u0003\u0002xq\u0006)\u0011\rZ7j]*\u0011\u0011pY\u0001\bG2LWM\u001c;t\u0013\tYhOA\bN_\u000e\\\u0017\tZ7j]\u000ec\u0017.\u001a8u\u0003MiwnY6BI6Lgn\u00117jK:$x\fJ3r)\tag\u0010C\u0004q\r\u0005\u0005\t\u0019\u0001;\u0002!5|7m[!e[&t7\t\\5f]R\u0004\u0013\u0001E4s_V\u00048i\\8sI&t\u0017\r^8s+\t\t)\u0001\u0005\u0003\u0002\b\u0005EQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\u000b\u001d\u0014x.\u001e9\u000b\u0007\u0005=1-A\u0006d_>\u0014H-\u001b8bi>\u0014\u0018\u0002BA\n\u0003\u0013\u0011\u0001c\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:\u0002)\u001d\u0014x.\u001e9D_>\u0014H-\u001b8bi>\u0014x\fJ3r)\ra\u0017\u0011\u0004\u0005\ta&\t\t\u00111\u0001\u0002\u0006\u0005\trM]8va\u000e{wN\u001d3j]\u0006$xN\u001d\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014XCAA\u0011!\u0011\t\u0019#!\f\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\tA!\u001e;jY*\u0019\u00111F2\u0002\rM,'O^3s\u0013\u0011\ty#!\n\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018!D:dQ\u0016$W\u000f\\3s?\u0012*\u0017\u000fF\u0002m\u0003kA\u0001\u0002\u001d\u0007\u0002\u0002\u0003\u0007\u0011\u0011E\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013AE2p]N,X.\u001a:MC\u001e,U.\u001b;uKJ,\"!!\u0010\u0011\u0007q\u000by$C\u0002\u0002B5\u0013!cQ8ogVlWM\u001d'bO\u0016k\u0017\u000e\u001e;fe\u000612m\u001c8tk6,'\u000fT1h\u000b6LG\u000f^3s?\u0012*\u0017\u000fF\u0002m\u0003\u000fB\u0001\u0002]\b\u0002\u0002\u0003\u0007\u0011QH\u0001\u0014G>t7/^7fe2\u000bw-R7jiR,'\u000fI\u0001\u0005i&lW-\u0006\u0002\u0002PA!\u0011\u0011KA,\u001b\t\t\u0019FC\u0002\u0002V=\u000bQ!\u001e;jYNLA!!\u0017\u0002T\tAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\u0007qe>$xnY8m)f\u0004X-\u0006\u0002\u0002bA!\u00111MA9\u001d\u0011\t)'!\u001c\u0011\u0007\u0005\u001dT+\u0004\u0002\u0002j)\u0019\u00111N)\u0002\rq\u0012xn\u001c;?\u0013\r\ty'V\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0014Q\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=T+A\u0007qe>$xnY8m)f\u0004X\rI\u0001\tOJ|W\u000f]%eaU\u0011\u0011Q\u0010\t\u0005\u0003\u007f\nI)\u0004\u0002\u0002\u0002*!\u00111QAC\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0015\u0001\u00026bm\u0006LA!a\u001d\u0002\u0002\u0006IqM]8va&#\u0007\u0007I\u0001\tOJ|W\u000f]%ec\u0005IqM]8va&#\u0017\u0007I\u0001\nC2dwI]8vaN,\"!!&\u0011\r\u0005]\u0015\u0011UA?\u001b\t\tIJ\u0003\u0003\u0002\u001c\u0006u\u0015!C5n[V$\u0018M\u00197f\u0015\r\ty*V\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAR\u00033\u0013A\u0001T5ti\u0006Q\u0011\r\u001c7He>,\bo\u001d\u0011\u0002!Q|\u0007/[21!\u0006\u0014H/\u001b;j_:\u0004TCAAV!\u0011\ti+a,\u000e\u0003\u0005L1!!-b\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0011\u0003^8qS\u000e\u0004\u0004+\u0019:uSRLwN\u001c\u0019!\u0003A!x\u000e]5daA\u000b'\u000f^5uS>t\u0017'A\tu_BL7\r\r)beRLG/[8oc\u0001\n\u0001\u0003^8qS\u000e\f\u0004+\u0019:uSRLwN\u001c\u0019\u0002#Q|\u0007/[22!\u0006\u0014H/\u001b;j_:\u0004\u0004%\u0001\tu_BL7-\r)beRLG/[8oc\u0005\tBo\u001c9jGF\u0002\u0016M\u001d;ji&|g.\r\u0011\u0002)\u0011+7o\u0019:jE\u0016<%o\\;q\u0011\u0006tG\r\\3s\u0003U!Um]2sS\n,wI]8va\"\u000bg\u000e\u001a7fe\u0002\n1CR3uG\"|eMZ:fiND\u0015M\u001c3mKJ\fACR3uG\"|eMZ:fiND\u0015M\u001c3mKJ\u0004\u0013AC5oSRL\u0017\r\\5{KR\tA\u000eK\u0002(\u0003\u001f\u0004B!!5\u0002`6\u0011\u00111\u001b\u0006\u0005\u0003+\f9.A\u0002ba&TA!!7\u0002\\\u00069!.\u001e9ji\u0016\u0014(bAAoM\u0006)!.\u001e8ji&!\u0011\u0011]Aj\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0006G2|7/\u001a\u0015\u0004Q\u0005\u001d\b\u0003BAi\u0003SLA!a;\u0002T\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0017i\u0016\u001cHoQ8ogVlWM\u001d'bO6+GO]5dg\"\u001a\u0011&!=\u0011\t\u0005E\u00171_\u0005\u0005\u0003k\f\u0019N\u0001\u0003UKN$\u0018\u0001\u0005;fgR,\u0005\u0010]5sK\u001e\u0013x.\u001e9tQ\rQ\u0013\u0011_\u0001(i\u0016\u001cH\u000fT5ti\u001e\u0013x.\u001e9t\u0011\u0006tG\r\\3s\u000bJ\u0014xN]*i_VdGmU6ja\u0006cG\u000eK\u0002,\u0003c\fA\u0006^3ti2K7\u000f^$s_V\u00048\u000fS1oI2,'/\u0012:s_J\u001c\u0006n\\;mIJ+G/Y5o\u000f\u0006,x-Z:)\u00071\n\t0\u0001\u0017uKN$H)Z:de&\u0014Wm\u0012:pkBD\u0015M\u001c3mKJ,%O]8s'\"|W\u000f\u001c3TW&\u0004xI]8va\"\u001aQ&!=\u0002MQ,7\u000f^%om\u0006d\u0017\u000e\u001a)s_R|7m\u001c7UsB,7\u000b[8vY\u0012\u001c6.\u001b9He>,\b\u000fK\u0002/\u0003c\f1\u0006^3ti\u001a+Go\u00195PM\u001a\u001cX\r^:IC:$G.\u001a:FeJ|'o\u00155pk2$7k[5q\u000fJ|W\u000f\u001d\u0015\u0004_\u0005E\u0018a\t;fgR|e\u000e\\=GKR\u001c\u0007n\u00144gg\u0016$8OR8s'R\f'\r\\3He>,\bo\u001d\u0015\u0004a\u0005E\u0018\u0001\u0011;fgR$Um]2sS\n,wI]8va\"\u000bg\u000e\u001a7fe\u0016\u0013(o\u001c:TQ>,H\u000eZ#ya&\u0014XmR1vO\u0016<\u0006.\u001a8O_R\u001cun\u001c:eS:\fGo\u001c:)\u0007E\n\t0A uKN$h)\u001a;dQ>3gm]3ug\"\u000bg\u000e\u001a7fe\u0016\u0013(o\u001c:TQ>,H\u000eZ#ya&\u0014XmR1vO\u0016<\u0006.\u001a8O_R\u001cun\u001c:eS:\fGo\u001c:)\u0007I\n\t0A\u0018iC:$G.\u001a:FeJ|'o\u00155pk2$W\t\u001f9je\u0016<\u0015-^4f/\",gNT8u\u0007>|'\u000fZ5oCR|'\u000fF\u0002m\u0005?AqA!\t4\u0001\u0004\t\t'A\u0004iC:$G.\u001a:\u0002iQ,7\u000f^#yG\u0016\u0004H/[8o\u0013:$Um]3sS\u0006d\u0017N_3BgNLwM\\7f]R\u001c\u0006n\\;mIN[\u0017\u000e]'f[\n,'\u000fK\u00025\u0003c\f\u0001\b^3ti\u001a+Go\u00195PM\u001a\u001cX\r^:IC:$G.\u001a:QCJ$\u0018\u000e^5p]\u0016\u0013(o\u001c:TQ>,H\u000eZ*lSB\u0004\u0016M\u001d;ji&|g\u000eK\u00026\u0003c\f\u0001\u0007^3ti2K7\u000f^(gMN,Go\u001d)beRLG/[8o\u000bJ\u0014xN]*i_VdGmU6jaB\u000b'\u000f^5uS>t\u0007f\u0001\u001c\u0002r\u00069C/Z:u\u0007\"\fgnZ3J]6+WNY3sg\"L\u0007o\u00155pk2$W\u000b\u001d3bi\u0016<\u0015-^4fQ\r9\u0014\u0011_\u0001&i\u0016\u001cHOU3cC2\fgnY5oO\u001e\u0013x.\u001e9TQ>,H\u000e\u001a*fi\u0006LgnR1vO\u0016D3\u0001OAy\u00035\"Xm\u001d;OK\u001e\fG/\u001b<f\u0007>t7/^7fe2\u000bwm\u00155pk2$')\u001a*fG>\u0014H-\u001a3Bgj+'o\u001c\u0015\u0004s\u0005E\u0018A\f;fgR,U\u000e\u001d;z\u0007V\u0014(/\u001a8u\u001f\u001a47/\u001a;t'\"|W\u000f\u001c3O_R\u001cu.\u001e8u\u0003N,\u0005\u0010]5sK\u0012D3AOAy\u0003q!Xm\u001d;NK6\u0014WM\u001d+pa&\u001c\u0007+\u0019:uSRLwN\u001c+bOND3aOAy\u0003A\"Xm\u001d;NCf\u0014W\r\u0015:fM&DHk\u001c9jGB\u000b'\u000f^5uS>t7oV5uQR+g.\u00198u\rVt7\r^5p]\"\u001aA(!=\u0002%Y,'/\u001b4z\u001b\u0016l'-\u001a:NKR\u0014\u0018n\u0019\u000b\u0006Y\n-#Q\u000b\u0005\b\u0005\u001bj\u0004\u0019\u0001B(\u0003\u0019iW-\u001c2feB\u0019AL!\u0015\n\u0007\tMSJ\u0001\u000bNK6\u0014WM\u001d+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0005/j\u0004\u0019\u0001B-\u0003-)\u0007\u0010]3di\u0016$G*Y4\u0011\u0007Q\u0013Y&C\u0002\u0003^U\u0013A\u0001T8oO\u0006\tb/\u001a:jMflU\r\u001e:jGZ\u000bG.^3\u0016\t\t\r$\u0011\u000f\u000b\u0006Y\n\u0015$\u0011\u000e\u0005\b\u0005Or\u0004\u0019AA1\u0003)iW\r\u001e:jG:\u000bW.\u001a\u0005\b\u0005Wr\u0004\u0019\u0001B7\u00035)\u0007\u0010]3di\u0016$g+\u00197vKB!!q\u000eB9\u0019\u0001!qAa\u001d?\u0005\u0004\u0011)HA\u0001U#\u0011\u00119H! \u0011\u0007Q\u0013I(C\u0002\u0003|U\u0013qAT8uQ&tw\rE\u0002U\u0005\u007fJ1A!!V\u0005\r\te._\u0001\u0019GJ,\u0017\r^3MSN$xI]8vaN\u0014Vm\u001d9p]N,G\u0003\u0002BD\u0005C\u0003bA!#\u0003\u0012\nUUB\u0001BF\u0015\u0011\u0011iIa$\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002(\u0005\u0015\u0015\u0002\u0002BJ\u0005\u0017\u0013\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!\u0011\u00119J!(\u000e\u0005\te%b\u0001BNC\u00069Q.Z:tC\u001e,\u0017\u0002\u0002BP\u00053\u0013a\u0003T5ti\u001e\u0013x.\u001e9t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\b\u0005G{\u0004\u0019\u0001BS\u0003\u00199'o\\;qgB1!q\u0015BY\u0003CrAA!+\u0003.:!\u0011q\rBV\u0013\u00051\u0016b\u0001BX+\u00069\u0001/Y2lC\u001e,\u0017\u0002BAR\u0005gS1Aa,V\u0003u\u0019'/Z1uK2K7\u000f^$s_V\u00048/\u0012:s_J\u0014Vm\u001d9p]N,G\u0003\u0002BD\u0005sCqAa/A\u0001\u0004\u0011i,A\u0003feJ|'\u000f\u0005\u0003\u0003@\n\u0015WB\u0001Ba\u0015\r\u0011\u0019-Y\u0001\taJ|Go\\2pY&!!q\u0019Ba\u0005\u0019)%O]8sg\u0006\t2M]3bi\u0016d\u0015n\u001d;fI\u001e\u0013x.\u001e9\u0015\t\t5'1\u001c\t\u0005\u0005\u001f\u0014)N\u0004\u0003\u0003\u0018\nE\u0017\u0002\u0002Bj\u00053\u000ba\u0003T5ti\u001e\u0013x.\u001e9t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0005/\u0014INA\u0006MSN$X\rZ$s_V\u0004(\u0002\u0002Bj\u00053CqA!8B\u0001\u0004\t\t'A\u0004he>,\b/\u00133\u00029\r\u0014X-\u0019;f\t\u0016\u001c8M]5cK\u001e\u0013x.\u001e9t%\u0016\u001c\bo\u001c8tKR!!1\u001dB}!\u0019\u0011II!%\u0003fB1!q\u001dBu\u0005Wl!Aa$\n\t\u0005\r&q\u0012\t\u0005\u0005[\u0014\u0019P\u0004\u0003\u0003\u0018\n=\u0018\u0002\u0002By\u00053\u000b!\u0004R3tGJL'-Z$s_V\u00048OU3ta>t7/\u001a#bi\u0006LAA!>\u0003x\nqA)Z:de&\u0014W\rZ$s_V\u0004(\u0002\u0002By\u00053CqAa)C\u0001\u0004\u0011Y\u0010\u0005\u0004\u0003(\nE&1^\u0001\"GJ,\u0017\r^3EKN\u001c'/\u001b2f\u000fJ|W\u000f]:FeJ|'OU3ta>t7/\u001a\u000b\u0007\u0005G\u001c\taa\u0001\t\u000f\tu7\t1\u0001\u0002b!9!1X\"A\u0002\tu\u0016AG2sK\u0006$XMR3uG\"|eMZ:fiN\u0014Vm\u001d9p]N,G\u0003CB\u0005\u00077\u0019\tc!\n\u0011\r\t%%\u0011SB\u0006!\u0019\u00119O!;\u0004\u000eA!1qBB\u000b\u001d\u0011\u00119j!\u0005\n\t\rM!\u0011T\u0001\u0018\u001f\u001a47/\u001a;GKR\u001c\u0007NU3ta>t7/\u001a#bi\u0006LAaa\u0006\u0004\u001a\tIrJ\u001a4tKR4U\r^2i%\u0016\u001c\bo\u001c8tKR{\u0007/[2t\u0015\u0011\u0019\u0019B!'\t\u000f\ruA\t1\u0001\u0004 \u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0005\u0004\u0003(\nE\u00161\u0016\u0005\b\u0007G!\u0005\u0019\u0001B-\u0003)\u0011\u0017m]3PM\u001a\u001cX\r\u001e\u0005\n\u0007O!\u0005\u0013!a\u0001\u00053\n!#\u001b8de\u0016lWM\u001c;j]\u001e|eMZ:fi\u0006!3M]3bi\u00164U\r^2i\u001f\u001a47/\u001a;t%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$3'\u0006\u0002\u0004.)\"!\u0011LB\u0018W\t\u0019\t\u0004\u0005\u0003\u00044\ruRBAB\u001b\u0015\u0011\u00199d!\u000f\u0002\u0013Ut7\r[3dW\u0016$'bAB\u001e+\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r}2Q\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aH2sK\u0006$XMR3uG\"|eMZ:fiN,%O]8s%\u0016\u001c\bo\u001c8tKR!1\u0011BB#\u0011\u001d\u0011YL\u0012a\u0001\u0005{\u000bAc\u0019:fCR,7)\u001e:sK:$xJ\u001a4tKR\u001cH\u0003CB&\u0007\u001b\u001aye!\u0015\u0011\r\t\u001d&\u0011WB\u0007\u0011\u001d\u0019ib\u0012a\u0001\u0007?Aqaa\tH\u0001\u0004\u0011I\u0006C\u0004\u0004(\u001d\u0003\rA!\u0017\u0002'\r\u0014X-\u0019;f\u0019\u0006$Xm\u001d;PM\u001a\u001cX\r^:\u0015\u0011\r]3\u0011MB2\u0007K\u0002\u0002Ba:\u0004Z\u0005-6QL\u0005\u0005\u00077\u0012yIA\u0002NCB\u0004B!a \u0004`%!!QLAA\u0011\u001d\u0019i\u0002\u0013a\u0001\u0007?Aqaa\tI\u0001\u0004\u0011I\u0006C\u0005\u0004(!\u0003\n\u00111\u0001\u0003Z\u0005i2M]3bi\u0016d\u0015\r^3ti>3gm]3ug\u0012\"WMZ1vYR$3'\u0001\tde\u0016\fG/Z!tg&<g.\\3oiR!1QNB=!\u0015!6qNB:\u0013\r\u0019\t(\u0016\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004)\u000eU\u0014bAB<+\n!!)\u001f;f\u0011\u001d\u0019iB\u0013a\u0001\u0007?\t\u0001d\u0019:fCR,7i\u001c8tk6,'\u000fT1h\u000b6LG\u000f^3s)\u0011\tida \t\r]\\\u0005\u0019ABA!\r)81Q\u0005\u0004\u0007\u000b3(!B!e[&t\u0007")
public class ConsumerLagEmitterTest {
    private Metrics metrics = null;
    private MockAdminClient mockAdminClient = null;
    private GroupCoordinator groupCoordinator = null;
    private Scheduler scheduler = null;
    private ConsumerLagEmitter consumerLagEmitter = null;
    private final MockTime time = new MockTime();
    private final String protocolType;
    private final String groupId0;
    private final String groupId1;
    private final List<String> allGroups = new .colon.colon((Object)this.groupId0(), (List)new .colon.colon((Object)this.groupId1(), (List)Nil$.MODULE$));
    private final TopicPartition topic0Partition0 = new TopicPartition("topic-0", 0);
    private final TopicPartition topic0Partition1 = new TopicPartition("topic-0", 1);
    private final TopicPartition topic1Partition0 = new TopicPartition("topic-1", 0);
    private final TopicPartition topic1Partition1 = new TopicPartition("topic-1", 1);
    private final String DescribeGroupHandler;
    private final String FetchOffsetsHandler;

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private MockAdminClient mockAdminClient() {
        return this.mockAdminClient;
    }

    private void mockAdminClient_$eq(MockAdminClient x$1) {
        this.mockAdminClient = x$1;
    }

    private GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    private void groupCoordinator_$eq(GroupCoordinator x$1) {
        this.groupCoordinator = x$1;
    }

    private Scheduler scheduler() {
        return this.scheduler;
    }

    private void scheduler_$eq(Scheduler x$1) {
        this.scheduler = x$1;
    }

    private ConsumerLagEmitter consumerLagEmitter() {
        return this.consumerLagEmitter;
    }

    private void consumerLagEmitter_$eq(ConsumerLagEmitter x$1) {
        this.consumerLagEmitter = x$1;
    }

    private MockTime time() {
        return this.time;
    }

    private String protocolType() {
        return this.protocolType;
    }

    private String groupId0() {
        return this.groupId0;
    }

    private String groupId1() {
        return this.groupId1;
    }

    private List<String> allGroups() {
        return this.allGroups;
    }

    private TopicPartition topic0Partition0() {
        return this.topic0Partition0;
    }

    private TopicPartition topic0Partition1() {
        return this.topic0Partition1;
    }

    private TopicPartition topic1Partition0() {
        return this.topic1Partition0;
    }

    private TopicPartition topic1Partition1() {
        return this.topic1Partition1;
    }

    private String DescribeGroupHandler() {
        return this.DescribeGroupHandler;
    }

    private String FetchOffsetsHandler() {
        return this.FetchOffsetsHandler;
    }

    @BeforeEach
    public void initialize() {
        java.util.List brokers = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new Node(0, "localhost", 9092), (List)Nil$.MODULE$)).asJava();
        this.metrics_$eq(new Metrics());
        this.groupCoordinator_$eq((GroupCoordinator)Mockito.mock(GroupCoordinator.class));
        this.scheduler_$eq((Scheduler)new MockScheduler((Time)this.time()));
        this.mockAdminClient_$eq(new MockAdminClient(brokers, (Node)brokers.get(0)));
        this.consumerLagEmitter_$eq(this.createConsumerLagEmitter((Admin)this.mockAdminClient()));
    }

    @AfterEach
    public void close() {
        if (this.consumerLagEmitter() != null) {
            this.consumerLagEmitter().shutdown();
        }
        if (this.metrics() != null) {
            this.metrics().close();
        }
        if (this.mockAdminClient() != null) {
            this.mockAdminClient().close();
            return;
        }
    }

    @Test
    public void testConsumerLagMetrics() {
        String groupId2 = "lkc-xxxxx_group-2";
        TopicPartition topic2Partition0 = new TopicPartition("lkc-xxxxx_topic-2", 0);
        TopicPartition unprefixedTopic2Partition0 = new TopicPartition("topic-2", 0);
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 2, (short)1), (List)new .colon.colon((Object)new NewTopic("topic-1", 2, (short)1), (List)new .colon.colon((Object)new NewTopic("lkc-xxxxx_topic-2", 1, (short)1), (List)Nil$.MODULE$)));
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member0 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-0:member-0").setGroupInstanceId("group.instance.0").setClientId("client-0").setClientHost("host-0").setMemberAssignment(this.createAssignment((List<TopicPartition>)new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$)));
        DescribeGroupsResponseData.DescribedGroupMember member1 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-0:member-1").setClientId("client-1").setClientHost("host-1").setMemberAssignment(this.createAssignment((List<TopicPartition>)new .colon.colon((Object)this.topic0Partition1(), (List)Nil$.MODULE$)));
        DescribeGroupsResponseData.DescribedGroupMember member2 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-1:member-0").setGroupInstanceId("group.instance.1").setClientId("client-2").setClientHost("host-2").setMemberAssignment(this.createAssignment((List<TopicPartition>)new .colon.colon((Object)this.topic1Partition0(), (List)Nil$.MODULE$)));
        DescribeGroupsResponseData.DescribedGroupMember member3 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-1:member-1").setClientId("client-3").setClientHost("host-3").setMemberAssignment(this.createAssignment((List<TopicPartition>)new .colon.colon((Object)this.topic1Partition1(), (List)Nil$.MODULE$)));
        DescribeGroupsResponseData.DescribedGroupMember member4 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("lkc-xxxxx_group-2:member-0").setClientId("client-4").setClientHost("host-4").setMemberAssignment(this.createAssignment((List<TopicPartition>)new .colon.colon((Object)unprefixedTopic2Partition0, (List)Nil$.MODULE$)));
        DescribeGroupsResponseData.DescribedGroup group0 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member0, (List)new .colon.colon((Object)member1, (List)Nil$.MODULE$))).asJava());
        DescribeGroupsResponseData.DescribedGroup group1 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId1()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member2, (List)new .colon.colon((Object)member3, (List)Nil$.MODULE$))).asJava());
        DescribeGroupsResponseData.DescribedGroup group2 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId2).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member4, (List)Nil$.MODULE$)).asJava());
        .colon.colon topic0Partitions = new .colon.colon((Object)this.topic0Partition0(), (List)new .colon.colon((Object)this.topic0Partition1(), (List)Nil$.MODULE$));
        .colon.colon topic1Partitions = new .colon.colon((Object)this.topic1Partition0(), (List)new .colon.colon((Object)this.topic1Partition1(), (List)Nil$.MODULE$));
        .colon.colon topic2Partitions = new .colon.colon((Object)topic2Partition0, (List)Nil$.MODULE$);
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)new .colon.colon((Object)this.groupId1(), (List)new .colon.colon((Object)groupId2, (List)Nil$.MODULE$)))));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)new .colon.colon((Object)this.groupId1(), (List)new .colon.colon((Object)groupId2, (List)Nil$.MODULE$)))).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group0, (List)new .colon.colon((Object)group1, (List)new .colon.colon((Object)group2, (List)Nil$.MODULE$)))));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)this.groupId0()), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topic0Partitions, 10000L, 5000L));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)this.groupId1()), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topic1Partitions, 15000L, 3500L));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)groupId2), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topic2Partitions, 6000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topic0Partitions, 25000L, 4000L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topic1Partitions, 35000L, 3000L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topic2Partitions, 35000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)3))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member0.groupInstanceId()), member0.memberId(), member0.clientId(), this.topic0Partition0()), 15000L);
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member1.groupInstanceId()), member1.memberId(), member1.clientId(), this.topic0Partition1()), 14000L);
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), Option$.MODULE$.apply((Object)member2.groupInstanceId()), member2.memberId(), member2.clientId(), this.topic1Partition0()), 20000L);
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), Option$.MODULE$.apply((Object)member3.groupInstanceId()), member3.memberId(), member3.clientId(), this.topic1Partition1()), 19500L);
        this.verifyMemberMetric(new MemberTopicPartition(groupId2, Option$.MODULE$.apply((Object)member4.groupInstanceId()), member4.memberId(), member4.clientId(), topic2Partition0), 29000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)5L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)3));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
    }

    @Test
    public void testExpireGroups() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        DescribeGroupsResponseData.DescribedGroupMember member0 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-0:member-0").setClientId("client-0").setClientHost("host-0").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroupMember member1 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-1:member-0").setClientId("client-1").setClientHost("host-1").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group0 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member0, (List)Nil$.MODULE$)).asJava());
        DescribeGroupsResponseData.DescribedGroup group1 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId1()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member1, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse(this.allGroups())).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId1(), (List)Nil$.MODULE$))).thenReturn(this.createListGroupsResponse((List<String>)package$.MODULE$.List().empty()));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)new .colon.colon((Object)this.groupId1(), (List)Nil$.MODULE$))).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group0, (List)new .colon.colon((Object)group1, (List)Nil$.MODULE$))));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId1(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group1, (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)this.groupId0()), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 10000L, 0L));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)this.groupId1()), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 5000L, 0L)).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member0.groupInstanceId()), member0.memberId(), member0.clientId(), this.topic0Partition0()), 15000L);
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), Option$.MODULE$.apply((Object)member1.groupInstanceId()), member1.memberId(), member1.clientId(), this.topic0Partition0()), 20000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)2L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 35000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), Option$.MODULE$.apply((Object)member1.groupInstanceId()), member1.memberId(), member1.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)0L));
        Assertions.assertEquals((int)0, (int)this.consumerLagEmitter().consumerLagMetrics().size());
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)3))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)3))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testListGroupsHandlerErrorShouldSkipAll() {
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsErrorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)0))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)0))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)0L));
        Assertions.assertEquals((int)0, (int)this.consumerLagEmitter().consumerLagMetrics().size());
    }

    @Test
    public void testListGroupsHandlerErrorShouldRetainGauges() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$))).thenReturn(this.createListGroupsErrorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)this.groupId0()), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 15000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        Assertions.assertEquals((int)1, (int)this.consumerLagEmitter().consumerLagMetrics().size());
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        Assertions.assertEquals((int)1, (int)this.consumerLagEmitter().consumerLagMetrics().size());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testDescribeGroupHandlerErrorShouldSkipGroup() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group0 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code());
        DescribeGroupsResponseData.DescribedGroup group1 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId1()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse(this.allGroups()));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava(this.allGroups()).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group0, (List)new .colon.colon((Object)group1, (List)Nil$.MODULE$))));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 15000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
    }

    @Test
    public void testInvalidProtocolTypeShouldSkipGroup() {
        String invalidProtocolType = "invalid-protocol";
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId1()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        DescribeGroupsResponseData.DescribedGroup invalidGroupSummary = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(invalidProtocolType).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse(this.allGroups()));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava(this.allGroups()).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)invalidGroupSummary, (List)new .colon.colon((Object)group, (List)Nil$.MODULE$))));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 15000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
    }

    @Test
    public void testFetchOffsetsHandlerErrorShouldSkipGroup() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group0 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        DescribeGroupsResponseData.DescribedGroup group1 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId1()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse(this.allGroups()));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava(this.allGroups()).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group0, (List)new .colon.colon((Object)group1, (List)Nil$.MODULE$))));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)this.groupId1()), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 15000L, 0L));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)this.groupId0()), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsErrorResponse(Errors.COORDINATOR_NOT_AVAILABLE));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
    }

    @Test
    public void testOnlyFetchOffsetsForStableGroups() {
        String groupId2 = "group-2";
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup stableGroup = new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId2).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        DescribeGroupsResponseData.DescribedGroup rebalancingGroup = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.PREPARING_REBALANCE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        DescribeGroupsResponseData.DescribedGroup emptyGroup = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId1()).setGroupState(ConsumerGroupState.EMPTY.toString()).setProtocolType(this.protocolType());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)new .colon.colon((Object)this.groupId1(), (List)new .colon.colon((Object)groupId2, (List)Nil$.MODULE$)))));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)new .colon.colon((Object)this.groupId1(), (List)new .colon.colon((Object)groupId2, (List)Nil$.MODULE$)))).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)rebalancingGroup, (List)new .colon.colon((Object)emptyGroup, (List)new .colon.colon((Object)stableGroup, (List)Nil$.MODULE$)))));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)groupId2), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 15000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMemberMetric(new MemberTopicPartition("group-2", Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
    }

    @Test
    public void testDescribeGroupHandlerErrorShouldExpireGaugeWhenNotCoordinator() {
        this.handlerErrorShouldExpireGaugeWhenNotCoordinator(this.DescribeGroupHandler());
    }

    @Test
    public void testFetchOffsetsHandlerErrorShouldExpireGaugeWhenNotCoordinator() {
        this.handlerErrorShouldExpireGaugeWhenNotCoordinator(this.FetchOffsetsHandler());
    }

    public void handlerErrorShouldExpireGaugeWhenNotCoordinator(String handler) {
        if (!((SetOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.DescribeGroupHandler(), this.FetchOffsetsHandler()}))).contains((Object)handler)) {
            Assertions.fail((String)new StringBuilder(16).append("unknown handler ").append(handler).toString());
        }
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)));
        String string = handler;
        String string2 = this.DescribeGroupHandler();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$))).thenReturn(this.createDescribeGroupsErrorResponse(this.groupId0(), Errors.COORDINATOR_LOAD_IN_PROGRESS)).thenReturn(this.createDescribeGroupsErrorResponse(this.groupId0(), Errors.NOT_COORDINATOR));
            Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)this.groupId0()), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 15000L, 0L));
        } else {
            Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$)));
            Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)this.groupId0()), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 15000L, 0L)).thenReturn(this.createFetchOffsetsErrorResponse(Errors.COORDINATOR_NOT_AVAILABLE)).thenReturn(this.createFetchOffsetsErrorResponse(Errors.NOT_COORDINATOR));
        }
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        Assertions.assertEquals((int)1, (int)this.consumerLagEmitter().consumerLagMetrics().size());
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        Assertions.assertEquals((int)1, (int)this.consumerLagEmitter().consumerLagMetrics().size());
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)0L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
        Assertions.assertEquals((int)0, (int)this.consumerLagEmitter().consumerLagMetrics().size());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)3))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        String string3 = handler;
        String string4 = this.DescribeGroupHandler();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
            return;
        }
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)3))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testExceptionInDeserializeAssignmentShouldSkipMember() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member0 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-0:member-0").setClientId("client-0").setClientHost("host-0").setMemberAssignment(new byte[]{0, 1});
        DescribeGroupsResponseData.DescribedGroupMember member1 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-0:member-1").setClientId("client-1").setClientHost("host-1").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroupMember member2 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-0:member-2").setClientId("client-2").setClientHost("host-2").setMemberAssignment((byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()));
        DescribeGroupsResponseData.DescribedGroup group = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member0, (List)new .colon.colon((Object)member1, (List)new .colon.colon((Object)member2, (List)Nil$.MODULE$)))).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)this.groupId0()), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 15000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member1.groupInstanceId()), member1.memberId(), member1.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
    }

    @Test
    public void testFetchOffsetsHandlerPartitionErrorShouldSkipPartition() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 2, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)new .colon.colon((Object)this.topic0Partition1(), (List)Nil$.MODULE$));
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        .colon.colon currentOffsets = new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(this.topic0Partition0().topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(this.topic0Partition0().partition()).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setCommittedOffset(-1L).setCommittedLeaderEpoch(-1).setMetadata(""), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(this.topic0Partition1().topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(this.topic0Partition1().partition()).setErrorCode(Errors.NONE.code()).setCommittedOffset(15000L).setCommittedLeaderEpoch(-1).setMetadata(""), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$));
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)this.groupId0()), ArgumentMatchers.eq((boolean)false))).thenReturn(CompletableFuture.completedFuture(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)currentOffsets).asJava()));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition1()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
    }

    @Test
    public void testListOffsetsPartitionErrorShouldSkipPartition() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 2, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)new .colon.colon((Object)this.topic0Partition1(), (List)Nil$.MODULE$));
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        java.util.Map failedTopicPartitions = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic0Partition0()), (Object)Errors.LEADER_NOT_AVAILABLE.exception())}))).asJava();
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)this.groupId0()), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 15000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.mockAdminClient().updateOffsetsWithExceptions(failedTopicPartitions);
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition1()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
    }

    @Test
    public void testChangeInMembershipShouldUpdateGauge() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        DescribeGroupsResponseData.DescribedGroupMember member0 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-0:member-0").setClientId("client-0").setClientHost("host-0").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroupMember member1 = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-0:member-1").setClientId("client-1").setClientHost("host-1").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group0 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member0, (List)Nil$.MODULE$)).asJava());
        DescribeGroupsResponseData.DescribedGroup group1 = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member1, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group0, (List)Nil$.MODULE$))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group1, (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)this.groupId0()), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 5000L, 0L)).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member0.groupInstanceId()), member0.memberId(), member0.clientId(), this.topic0Partition0()), 20000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 35000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member1.groupInstanceId()), member1.memberId(), member1.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testRebalancingGroupShouldRetainGauge() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("group-0:member-0").setClientId("client-0").setClientHost("host-0").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        DescribeGroupsResponseData.DescribedGroup rebalancingGroup = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.PREPARING_REBALANCE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)rebalancingGroup, (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)this.groupId0()), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 40000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 46000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 6000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 6000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testNegativeConsumerLagShouldBeRecordedAsZero() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)this.groupId0()), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)topicPartitions, 30000L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), Option$.MODULE$.apply((Object)member.groupInstanceId()), member.memberId(), member.clientId(), this.topic0Partition0()), 0L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
    }

    @Test
    public void testEmptyCurrentOffsetsShouldNotCountAsExpired() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava());
        DescribeGroupsResponseData.DescribedGroupMember member = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setClientId("client").setClientHost("host").setMemberAssignment(this.createAssignment((List<TopicPartition>)topicPartitions));
        DescribeGroupsResponseData.DescribedGroup group = new DescribeGroupsResponseData.DescribedGroup().setGroupId(this.groupId0()).setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(this.protocolType()).setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)member, (List)Nil$.MODULE$)).asJava());
        Mockito.when((Object)this.groupCoordinator().listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.eq((Object)new ListGroupsRequestData().setStatesFilter(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ConsumerLagEmitter$.MODULE$.ValidStates().toList()).asJava())))).thenReturn(this.createListGroupsResponse((List<String>)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.groupId0(), (List)Nil$.MODULE$)).asJava()))).thenReturn(this.createDescribeGroupsResponse((List<DescribeGroupsResponseData.DescribedGroup>)new .colon.colon((Object)group, (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)this.groupId0()), ArgumentMatchers.eq((boolean)false))).thenReturn(this.createFetchOffsetsResponse((List<TopicPartition>)package$.MODULE$.List().empty(), 0L, 0L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, 0L));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).listGroups((RequestContext)ArgumentMatchers.any(), (ListGroupsRequestData)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).describeGroups((RequestContext)ArgumentMatchers.any(), (java.util.List)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).fetchAllOffsets((RequestContext)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)0L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
    }

    @Test
    public void testMemberTopicPartitionTags() {
        scala.collection.mutable.Map externalTags = new MemberTopicPartition("lkc-yyyyy_external-group", (Option)new Some((Object)"group-instance-0"), "member-0", "client-0", new TopicPartition("lkc-yyyyy_external-topic", 0)).tags();
        Assertions.assertEquals((Object)((scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer-group"), (Object)"external-group"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group-instance-id"), (Object)"group-instance-0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"member"), (Object)"member-0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"client-0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)"external-topic"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"lkc-yyyyy")}))), (Object)externalTags);
        scala.collection.mutable.Map internalTags = new MemberTopicPartition("internal-group", (Option)None$.MODULE$, "member-1", "client-1", new TopicPartition("__consumer_offsets", 50)).tags();
        Assertions.assertEquals((Object)((scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer-group"), (Object)"internal-group"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"member"), (Object)"member-1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"client-1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)"__consumer_offsets"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)"50")}))), (Object)internalTags);
    }

    @Test
    public void testMaybePrefixTopicPartitionsWithTenantFunction() {
        .colon.colon unprefixedTopicPartitions = new .colon.colon((Object)new TopicPartition("test-topic", 0), (List)new .colon.colon((Object)new TopicPartition("test-topic", 1), (List)new .colon.colon((Object)new TopicPartition("test-topic", 2), (List)new .colon.colon((Object)new TopicPartition("test-topic", 3), (List)Nil$.MODULE$))));
        String externalGroup = "lkc-yyyyy_test-group";
        ((List)this.consumerLagEmitter().maybePrefixTopicPartitionsWithTenantFunction(externalGroup).apply((Object)unprefixedTopicPartitions)).foreach((Function1 & Serializable)topicPartition -> {
            ConsumerLagEmitterTest.$anonfun$testMaybePrefixTopicPartitionsWithTenantFunction$1(topicPartition);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyMemberMetric(MemberTopicPartition member, long expectedLag) {
        Option metric = CollectionConverters$.MODULE$.MapHasAsScala(this.metrics().metrics()).asScala().get((Object)this.metrics().metricName(ConsumerLagEmitter$.MODULE$.ConsumerLagMetricName(), "tenant-metrics", CollectionConverters$.MODULE$.MutableMapHasAsJava(member.tags()).asJava()));
        Assertions.assertTrue((boolean)metric.isDefined());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)expectedLag), (Object)((KafkaMetric)metric.get()).metricValue());
    }

    private <T> void verifyMetricValue(String metricName, T expectedValue) {
        Option metric = CollectionConverters$.MODULE$.MapHasAsScala(this.metrics().metrics()).asScala().get((Object)this.metrics().metricName(metricName, ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        Assertions.assertTrue((boolean)metric.isDefined());
        Assertions.assertEquals(expectedValue, (Object)((KafkaMetric)metric.get()).metricValue());
    }

    private CompletableFuture<ListGroupsResponseData> createListGroupsResponse(List<String> groups) {
        return CompletableFuture.completedFuture(new ListGroupsResponseData().setGroups(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)groups.map((Function1 & Serializable)groupId -> this.createListedGroup((String)groupId))).asJava()));
    }

    private CompletableFuture<ListGroupsResponseData> createListGroupsErrorResponse(Errors error) {
        return CompletableFuture.completedFuture(new ListGroupsResponseData().setErrorCode(error.code()));
    }

    private ListGroupsResponseData.ListedGroup createListedGroup(String groupId) {
        return new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType(this.protocolType()).setGroupState(ConsumerGroupState.STABLE.toString());
    }

    private CompletableFuture<java.util.List<DescribeGroupsResponseData.DescribedGroup>> createDescribeGroupsResponse(List<DescribeGroupsResponseData.DescribedGroup> groups) {
        return CompletableFuture.completedFuture(CollectionConverters$.MODULE$.SeqHasAsJava(groups).asJava());
    }

    private CompletableFuture<java.util.List<DescribeGroupsResponseData.DescribedGroup>> createDescribeGroupsErrorResponse(String groupId, Errors error) {
        return CompletableFuture.completedFuture(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new DescribeGroupsResponseData.DescribedGroup().setGroupId(groupId).setErrorCode(error.code()), (List)Nil$.MODULE$)).asJava());
    }

    private CompletableFuture<java.util.List<OffsetFetchResponseData.OffsetFetchResponseTopics>> createFetchOffsetsResponse(List<TopicPartition> topicPartitions, long baseOffset, long incrementingOffset) {
        return CompletableFuture.completedFuture(CollectionConverters$.MODULE$.SeqHasAsJava(this.createCurrentOffsets(topicPartitions, baseOffset, incrementingOffset)).asJava());
    }

    private long createFetchOffsetsResponse$default$3() {
        return 0L;
    }

    private CompletableFuture<java.util.List<OffsetFetchResponseData.OffsetFetchResponseTopics>> createFetchOffsetsErrorResponse(Errors error) {
        CompletableFuture<java.util.List<OffsetFetchResponseData.OffsetFetchResponseTopics>> failedFuture = new CompletableFuture<java.util.List<OffsetFetchResponseData.OffsetFetchResponseTopics>>();
        failedFuture.completeExceptionally(error.exception());
        return failedFuture;
    }

    private List<OffsetFetchResponseData.OffsetFetchResponseTopics> createCurrentOffsets(List<TopicPartition> topicPartitions, long baseOffset, long incrementingOffset) {
        return ((IterableOnceOps)((List)topicPartitions.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                int index = x0$1._2$mcI$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(topicPartition.partition()).setCommittedOffset(baseOffset + (long)index * incrementingOffset).setMetadata("").setCommittedLeaderEpoch(-1));
            }
            throw new MatchError(null);
        }).groupBy((Function1 & Serializable)x$1 -> ((TopicPartition)x$1._1()).topic()).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                String topic = (String)x0$2._1();
                List partitions = (List)x0$2._2();
                return new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(topic).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitions.map((Function1 & Serializable)x$2 -> (OffsetFetchResponseData.OffsetFetchResponsePartitions)x$2._2())).asJava());
            }
            throw new MatchError(null);
        })).toList();
    }

    private java.util.Map<TopicPartition, Long> createLatestOffsets(List<TopicPartition> topicPartitions, long baseOffset, long incrementingOffset) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)((List)topicPartitions.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                int index = x0$1._2$mcI$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)(baseOffset + (long)index * incrementingOffset));
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    private long createLatestOffsets$default$3() {
        return 0L;
    }

    private byte[] createAssignment(List<TopicPartition> topicPartitions) {
        return ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(CollectionConverters$.MODULE$.SeqHasAsJava(topicPartitions).asJava()), (short)3).array();
    }

    private ConsumerLagEmitter createConsumerLagEmitter(Admin admin) {
        return new ConsumerLagEmitter(this.metrics(), this.scheduler(), this.groupCoordinator(), 60000L, admin);
    }

    public static final /* synthetic */ void $anonfun$testMaybePrefixTopicPartitionsWithTenantFunction$1(TopicPartition topicPartition) {
        Assertions.assertEquals((Object)"lkc-yyyyy_test-topic", (Object)topicPartition.topic());
    }

    public ConsumerLagEmitterTest() {
        this.protocolType = "consumer";
        this.groupId0 = "group-0";
        this.groupId1 = "group-1";
        this.DescribeGroupHandler = "describeGroup";
        this.FetchOffsetsHandler = "fetchOffsets";
    }
}

