/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kafka.metrics.LinuxCpuMetricsCollector;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120000L)
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001B\b\u0011\u0001UAQA\t\u0001\u0005\u0002\rBqA\n\u0001A\u0002\u0013\u0005q\u0005C\u00041\u0001\u0001\u0007I\u0011A\u0019\t\r]\u0002\u0001\u0015)\u0003)\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u00159\u0005\u0001\"\u0001:\u0011\u0015a\u0005\u0001\"\u0001:\u0011\u0015\t\u0006\u0001\"\u0003S\u0011\u0015q\u0007\u0001\"\u0001:\u0011\u0015\u0001\b\u0001\"\u0001:\u0011\u0015\u0011\b\u0001\"\u0001:\u0011\u0015!\b\u0001\"\u0001:\u0011\u00151\b\u0001\"\u0001:\u0011\u0015A\b\u0001\"\u0001:\u0005qa\u0015N\\;y\u0007B,X*\u001a;sS\u000e\u001c8i\u001c7mK\u000e$xN\u001d+fgRT!!\u0005\n\u0002\u000f5,GO]5dg*\t1#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u00011B\u0004\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VM\u001a\t\u0003;\u0001j\u0011A\b\u0006\u0003?I\tQ!\u001e;jYNL!!\t\u0010\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001\n\t\u0003K\u0001i\u0011\u0001E\u0001\bE\u0006\u001cX\rR5s+\u0005A\u0003CA\u0015/\u001b\u0005Q#BA\u0016-\u0003\tIwNC\u0001.\u0003\u0011Q\u0017M^1\n\u0005=R#\u0001\u0002$jY\u0016\f1BY1tK\u0012K'o\u0018\u0013fcR\u0011!'\u000e\t\u0003/MJ!\u0001\u000e\r\u0003\tUs\u0017\u000e\u001e\u0005\bm\r\t\t\u00111\u0001)\u0003\rAH%M\u0001\tE\u0006\u001cX\rR5sA\u0005)1/\u001a;VaR\t!\u0007\u000b\u0002\u0006wA\u0011A(R\u0007\u0002{)\u0011ahP\u0001\u0004CBL'B\u0001!B\u0003\u001dQW\u000f]5uKJT!AQ\"\u0002\u000b),h.\u001b;\u000b\u0003\u0011\u000b1a\u001c:h\u0013\t1UH\u0001\u0006CK\u001a|'/Z#bG\"\fqa\u00197fC:,\u0006\u000f\u000b\u0002\u0007\u0013B\u0011AHS\u0005\u0003\u0017v\u0012\u0011\"\u00114uKJ,\u0015m\u00195\u00021Q,7\u000f^*zgR,Wn\u00119v+RLG.\u001b>bi&|g\u000e\u000b\u0002\b\u001dB\u0011AhT\u0005\u0003!v\u0012A\u0001V3ti\u0006Y1/\u001a;D!V\u001bF/\u0019;t)%\u00196\f\u00192eM\"TG\u000e\u0005\u0002U36\tQK\u0003\u0002W/\u0006!a-\u001b7f\u0015\tAF&A\u0002oS>L!AW+\u0003\tA\u000bG\u000f\u001b\u0005\u00069\"\u0001\r!X\u0001\u0005kN,'\u000f\u0005\u0002\u0018=&\u0011q\f\u0007\u0002\u0004\u0013:$\b\"B1\t\u0001\u0004i\u0016\u0001\u00028jG\u0016DQa\u0019\u0005A\u0002u\u000baa]=ti\u0016l\u0007\"B3\t\u0001\u0004i\u0016\u0001B5eY\u0016DQa\u001a\u0005A\u0002u\u000ba![8XC&$\b\"B5\t\u0001\u0004i\u0016aA5sc\")1\u000e\u0003a\u0001;\u000691o\u001c4u\u0013J\f\b\"B7\t\u0001\u0004i\u0016!B:uK\u0006d\u0017\u0001\u000e;fgR,\u0005\u0010]8oK:$\u0018.\u00197ms\u0012+7-Y=j]\u001e\u001c\u0016p\u001d;f[\u000e\u0003X/\u0016;jY&T\u0018\r^5p]\u00063XM]1hK\"\u0012\u0011BT\u0001\u000bi\u0016\u001cH/V:bE2,\u0007F\u0001\u0006O\u0003=!Xm\u001d;SK\u0006$Gj\\1e\u0003Z<\u0007FA\u0006O\u0003\r\"Xm\u001d;V]\u0006\u0014G.\u001a+p%\u0016\fGMT8oKbL7\u000f^3oiB\u0013xn\u0019$jY\u0016D#\u0001\u0004(\u00023Q,7\u000f\u001e)s_\u000e,7o]\"qkV#\u0018\u000e\\5{CRLwN\u001c\u0015\u0003\u001b9\u000b\u0001\u0004^3ti\u000e+(O]3oiNK8\u000f^3n\u0015&4g-[3tQ\tqa\n\u000b\u0003\u0001wz|\bC\u0001\u001f}\u0013\tiXHA\u0004US6,w.\u001e;\u0002\u000bY\fG.^3\u001f\u0007\u0005!\u000e\u0019")
public class LinuxCpuMetricsCollectorTest
implements Logging {
    private File baseDir = null;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File baseDir() {
        return this.baseDir;
    }

    public void baseDir_$eq(File x$1) {
        this.baseDir = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.baseDir_$eq(TestUtils.tempDirectory(null, null));
    }

    @AfterEach
    public void cleanUp() {
        Utils.delete((File)this.baseDir(), (boolean)false);
    }

    @Test
    public void testSystemCpuUtilization() {
        MockTime time = new MockTime(100L, 1000L);
        LinuxCpuMetricsCollector collector = new LinuxCpuMetricsCollector(this.baseDir().getAbsolutePath(), (Time)time, (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), this.logger().underlying(), 60, 100);
        String cpuStat = "cpu  10686260 408 4178845 124269072 516344 0 2369063 120000 0 0";
        Files.write(this.baseDir().toPath().resolve("stat"), cpuStat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertEquals((double)0.0, (double)collector.systemCpuUtilization(), (double)0.0);
        cpuStat = "cpu  10711892 409 4188649 124938617 516537 0 2369826 126200 0 0";
        Files.write(this.baseDir().toPath().resolve("stat"), cpuStat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertEquals((double)5.95, (double)collector.systemCpuUtilization(), (double)0.01);
        cpuStat = "cpu  10754158 411 4204810 126043403 516852 0 2371170 126600 0 0";
        Files.write(this.baseDir().toPath().resolve("stat"), cpuStat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertEquals((double)5.16, (double)collector.systemCpuUtilization(), (double)0.01);
    }

    private Path setCPUStats(int user, int nice, int system, int idle, int ioWait, int irq, int softIrq, int steal) {
        String cpuStat = new StringBuilder(16).append("cpu  ").append(user).append(" ").append(nice).append(" ").append(system).append(" ").append(idle).append(" ").append(ioWait).append(" ").append(irq).append(" ").append(softIrq).append(" ").append(steal).append(" 0 0").toString();
        return Files.write(this.baseDir().toPath().resolve("stat"), cpuStat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @Test
    public void testExponentiallyDecayingSystemCpuUtilizationAverage() {
        MockTime time = new MockTime(100L, 1000L);
        int jiffiesPerSecond = 100;
        int windowSizeInSeconds = 60;
        ObjectRef collector = ObjectRef.create((Object)new LinuxCpuMetricsCollector(this.baseDir().getAbsolutePath(), (Time)time, (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), this.logger().underlying(), windowSizeInSeconds, jiffiesPerSecond));
        int initialValue = 86400 * jiffiesPerSecond;
        IntRef user = IntRef.create((int)initialValue);
        int nice = initialValue * 4;
        IntRef idle = IntRef.create((int)(initialValue / 2));
        IntRef ioWait = IntRef.create((int)(initialValue / 2));
        this.setCPUStats(user.elem, nice, initialValue, idle.elem, ioWait.elem, initialValue, initialValue, initialValue);
        Assertions.assertEquals((double)90.0, (double)((LinuxCpuMetricsCollector)collector.elem).exponentiallyDecayingSystemCpuUtilizationAverage(), (double)1.0);
        user.elem += 15 * jiffiesPerSecond;
        this.setCPUStats(user.elem, nice, initialValue, idle.elem, ioWait.elem, initialValue, initialValue, initialValue);
        Assertions.assertEquals((double)92.0, (double)((LinuxCpuMetricsCollector)collector.elem).exponentiallyDecayingSystemCpuUtilizationAverage(), (double)1.0);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
            this.setCPUStats(user$1.elem, nice, initialValue, idle$1.elem, ioWait$1.elem, initialValue, initialValue, initialValue);
            Assertions.assertEquals((double)92.0, (double)((LinuxCpuMetricsCollector)collector$1.elem).exponentiallyDecayingSystemCpuUtilizationAverage(), (double)1.0);
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
            ++user$1.elem;
            this.setCPUStats(user$1.elem, nice, initialValue, idle$1.elem, ioWait$1.elem, initialValue, initialValue, initialValue);
            Assertions.assertEquals((double)92.3, (double)((LinuxCpuMetricsCollector)collector$1.elem).exponentiallyDecayingSystemCpuUtilizationAverage(), (double)0.1);
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            ++user$1.elem;
            this.setCPUStats(user$1.elem, nice, initialValue, idle$1.elem, ioWait$1.elem, initialValue, initialValue, initialValue);
            Assertions.assertEquals((double)92.4, (double)((LinuxCpuMetricsCollector)collector$1.elem).exponentiallyDecayingSystemCpuUtilizationAverage(), (double)0.1);
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
            ++user$1.elem;
            this.setCPUStats(user$1.elem, nice, initialValue, idle$1.elem, ioWait$1.elem, initialValue, initialValue, initialValue);
            Assertions.assertEquals((double)92.5, (double)((LinuxCpuMetricsCollector)collector$1.elem).exponentiallyDecayingSystemCpuUtilizationAverage(), (double)0.1);
        });
        idle.elem += 300 * jiffiesPerSecond;
        this.setCPUStats(user.elem, nice, initialValue, idle.elem, ioWait.elem, initialValue, initialValue, initialValue);
        Assertions.assertEquals((double)0.0, (double)((LinuxCpuMetricsCollector)collector.elem).exponentiallyDecayingSystemCpuUtilizationAverage(), (double)1.0);
        user.elem += 15 * jiffiesPerSecond;
        ioWait.elem += 15 * jiffiesPerSecond;
        this.setCPUStats(user.elem, nice, initialValue, idle.elem, ioWait.elem, initialValue, initialValue, initialValue);
        Assertions.assertEquals((double)20.0, (double)((LinuxCpuMetricsCollector)collector.elem).exponentiallyDecayingSystemCpuUtilizationAverage(), (double)1.0);
        collector.elem = new LinuxCpuMetricsCollector(this.baseDir().getAbsolutePath(), (Time)time, (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), this.logger().underlying(), windowSizeInSeconds, jiffiesPerSecond);
        LinuxCpuMetricsCollector collector2 = new LinuxCpuMetricsCollector(this.baseDir().getAbsolutePath(), (Time)time, (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), this.logger().underlying(), windowSizeInSeconds, jiffiesPerSecond);
        Assertions.assertEquals((double)((LinuxCpuMetricsCollector)collector.elem).exponentiallyDecayingSystemCpuUtilizationAverage(), (double)collector2.exponentiallyDecayingSystemCpuUtilizationAverage(), (double)0.1);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 10000).foreach((Function1)(JFunction1.mcDI.sp & Serializable)x$5 -> {
            ++user$1.elem;
            this.setCPUStats(user$1.elem, nice, initialValue, idle$1.elem, ioWait$1.elem, initialValue, initialValue, initialValue);
            return ((LinuxCpuMetricsCollector)collector$1.elem).exponentiallyDecayingSystemCpuUtilizationAverage();
        });
        Assertions.assertEquals((double)((LinuxCpuMetricsCollector)collector.elem).exponentiallyDecayingSystemCpuUtilizationAverage(), (double)collector2.exponentiallyDecayingSystemCpuUtilizationAverage(), (double)0.001);
    }

    @Test
    public void testUsable() {
        MockTime time = new MockTime(100L, 1000L);
        LinuxCpuMetricsCollector collector = new LinuxCpuMetricsCollector(this.baseDir().getAbsolutePath(), (Time)time, (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), this.logger().underlying(), 60, 100);
        String loadStr = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%f %f %f 1/80 11206"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)0.11), BoxesRunTime.boxToDouble((double)0.22), BoxesRunTime.boxToDouble((double)0.33)}));
        Files.write(this.baseDir().toPath().resolve("loadavg"), loadStr.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        String cpuStat = "cpu  10686260 408 4178845 124269072 516344 0 2369063 1260 0 0";
        Files.write(this.baseDir().toPath().resolve("stat"), cpuStat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertTrue((boolean)collector.usable());
    }

    @Test
    public void testReadLoadAvg() {
        MockTime time = new MockTime(100L, 1000L);
        LinuxCpuMetricsCollector collector = new LinuxCpuMetricsCollector(this.baseDir().getAbsolutePath(), (Time)time, (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), this.logger().underlying(), 60, 100);
        String loadStr = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%f %f %f 1/80 11206"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)0.11), BoxesRunTime.boxToDouble((double)0.22), BoxesRunTime.boxToDouble((double)0.33)}));
        Files.write(this.baseDir().toPath().resolve("loadavg"), loadStr.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertEquals((double)0.11, (double)collector.oneMinLoadAvg(), (double)0.0);
        Assertions.assertEquals((double)0.22, (double)collector.fiveMinLoadAvg(), (double)0.0);
        Assertions.assertEquals((double)0.33, (double)collector.fifteenMinLoadAvg(), (double)0.0);
    }

    @Test
    public void testUnableToReadNonexistentProcFile() {
        MockTime time = new MockTime(100L, 1000L);
        Assertions.assertFalse((boolean)new LinuxCpuMetricsCollector(this.baseDir().getAbsolutePath(), (Time)time, (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), this.logger().underlying(), 60, 100).usable());
    }

    @Test
    public void testProcessCpuUtilization() {
        String processCpuStatTemplate = "1 (java -Dcom.sun.management.jmxremote -Dcom.sun.management.jmxremote.authenticate=false) S 0 1 1 0 -1 1077952768 1330953 251903 2308 0 %s %s 625 162 20 0 194 0 112096471 19638837248 1238367 18446744073709551615 93983261564928 93983261568680 140721374129216 0 0 0 0 0 16800975 0 0 0 17 7 0 0 0 0 0 93983261576440 93983261577240 93983283015680 140721374145345 140721374165341 140721374165341 140721374228443 0";
        this.baseDir().toPath().resolve("1").toFile().mkdir();
        MockTime time = new MockTime(100L, 1000L);
        LinuxCpuMetricsCollector collector = new LinuxCpuMetricsCollector(this.baseDir().getAbsolutePath(), (Time)time, (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), this.logger().underlying(), 60, 100);
        String cpuStat = "cpu  100 100 100 100 100 0 100 0 0 0";
        this.writeProcessStat$1(20L, 30L, processCpuStatTemplate);
        this.writeSystemStat$1(cpuStat);
        Assertions.assertEquals((double)0.0, (double)collector.processCpuUtilization(), (double)0.0);
        cpuStat = "cpu  120 130 105 104 106 0 110 0 0 0";
        this.writeSystemStat$1(cpuStat);
        this.writeProcessStat$1(35L, 40L, processCpuStatTemplate);
        Assertions.assertEquals((double)33.33, (double)collector.processCpuUtilization(), (double)1.0);
        cpuStat = "cpu  150 160 112 115 109 0 125 0 0 0";
        this.writeSystemStat$1(cpuStat);
        this.writeProcessStat$1(57L, 67L, processCpuStatTemplate);
        Assertions.assertEquals((double)51.04, (double)collector.processCpuUtilization(), (double)1.0);
    }

    @Test
    public void testCurrentSystemJiffies() {
        String cpuStat = "cpu  100 100 100 100 100 50 100 60 0 0";
        Files.write(this.baseDir().toPath().resolve("stat"), cpuStat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        MockTime time = new MockTime(100L, 1000L);
        LinuxCpuMetricsCollector collector = new LinuxCpuMetricsCollector(this.baseDir().getAbsolutePath(), (Time)time, (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), this.logger().underlying(), 60, 100);
        Assertions.assertEquals((long)710L, (long)collector.currentSystemJiffies().total());
        cpuStat = "cpu  200 100 300 100 100 50 300 100 50 70";
        Files.write(this.baseDir().toPath().resolve("stat"), cpuStat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Assertions.assertEquals((long)1250L, (long)collector.currentSystemJiffies().total());
    }

    private final void writeProcessStat$1(long userMode, long kernelMode, String processCpuStatTemplate$1) {
        String stat = String.format(processCpuStatTemplate$1, Long.toString(userMode), Long.toString(kernelMode));
        Files.write(this.baseDir().toPath().resolve("1").resolve("stat"), stat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private final void writeSystemStat$1(String stat) {
        Files.write(this.baseDir().toPath().resolve("stat"), stat.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

