/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.telemetry.api.events.NoOpEventEmitter;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kafka.network.RequestChannel;
import kafka.network.RequestConvertToJson$;
import kafka.network.RequestMetrics;
import kafka.server.ActionQueue;
import kafka.server.EnvelopeUtils$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t}d\u0001B\u0010!\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013%\u0011\u0007\u0003\u0004:\u0001\u0001\u0006IA\r\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u0019y\u0004\u0001)A\u0005y!)q\u000b\u0001C\u00011\")q\r\u0001C\u00011\")A\u000e\u0001C\u00011\")a\u000e\u0001C\u00011\")\u0001\u000f\u0001C\u0005c\"I\u00111\u0001\u0001\u0012\u0002\u0013%\u0011Q\u0001\u0005\b\u00037\u0001A\u0011BA\u000f\u0011\u0019\tI\u0004\u0001C\u00011\"1\u0011Q\b\u0001\u0005\u0002aCa!!\u0011\u0001\t\u0003A\u0006BBA#\u0001\u0011\u0005\u0001\fC\u0004\u0002J\u0001!\t!a\u0013\t\u000f\u00055\u0005\u0001\"\u0003\u0002\u0010\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0006bBAc\u0001\u0011%\u0011q\u0019\u0005\b\u0003#\u0004A\u0011BAj\u0011\u001d\ty\u000e\u0001C\u0001\u0003CD\u0011\"!<\u0001#\u0003%\t!a<\t\u0013\u0005M\b!%A\u0005\u0002\u0005\u0015\u0001bBA\u0014\u0001\u0011\u0005\u0011Q\u001f\u0005\n\u0003w\u0004\u0011\u0013!C\u0001\u0003\u000bAq!!@\u0001\t\u0013\ty\u0010C\u0004\u0003\u001a\u0001!IAa\u0007\t\u000f\te\u0001\u0001\"\u0003\u0003P!9!q\r\u0001\u0005\n\t%$A\u0005*fcV,7\u000f^\"iC:tW\r\u001c+fgRT!!\t\u0012\u0002\u000f9,Go^8sW*\t1%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002]A\u0011q\u0006A\u0007\u0002A\u0005)\"/Z9vKN$8\t[1o]\u0016dW*\u001a;sS\u000e\u001cX#\u0001\u001a\u0011\u0005M2dBA\u00185\u0013\t)\u0004%\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\u0005]B$aB'fiJL7m\u001d\u0006\u0003k\u0001\naC]3rk\u0016\u001cHo\u00115b]:,G.T3ue&\u001c7\u000fI\u0001\u000faJLgnY5qC2\u001cVM\u001d3f+\u0005a$cA\u001fA\u0011\u001a!a(\u0002\u0001=\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0003=\u0001(/\u001b8dSB\fGnU3sI\u0016\u0004\u0003CA!G\u001b\u0005\u0011%BA\"E\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\u000bAA[1wC&\u0011qI\u0011\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005%+V\"\u0001&\u000b\u0005-c\u0015\u0001B1vi\"T!!\u0014(\u0002\u0011M,7-\u001e:jifT!a\u0014)\u0002\r\r|W.\\8o\u0015\t\u0019\u0013K\u0003\u0002S'\u00061\u0011\r]1dQ\u0016T\u0011\u0001V\u0001\u0004_J<\u0017B\u0001,K\u0005MY\u0015MZ6b!JLgnY5qC2\u001cVM\u001d3f\u0003!!X-\u0019:E_^tG#A-\u0011\u0005\u001dR\u0016BA.)\u0005\u0011)f.\u001b;)\u0005\u0019i\u0006C\u00010f\u001b\u0005y&B\u00011b\u0003\r\t\u0007/\u001b\u0006\u0003E\u000e\fqA[;qSR,'O\u0003\u0002e'\u0006)!.\u001e8ji&\u0011am\u0018\u0002\n\u0003\u001a$XM]#bG\"\fA\u0003^3tiN+'/[1mSj,'+Z9vKN$\bFA\u0004j!\tq&.\u0003\u0002l?\n!A+Z:u\u0003E!Xm\u001d;BYR,'OU3rk\u0016\u001cHo\u001d\u0015\u0003\u0011%\f!\u0004^3ti\"+\u0017\r\u001c;i\u0007\",7m\u001b+pi\u0006dG+[7f\u001bND#!C5\u0002'\t,\u0018\u000e\u001c3Qe>$WoY3SKF,Xm\u001d;\u0015\tI,(\u0010 \t\u0003gML!\u0001\u001e\u001d\u0003\u000fI+\u0017/^3ti\")aO\u0003a\u0001o\u0006q1\u000f^1siRKW.\u001a(b]>\u001c\bCA\u0014y\u0013\tI\bF\u0001\u0003M_:<\u0007\"B>\u000b\u0001\u0004\u0011\u0014aB7fiJL7m\u001d\u0005\b{*\u0001\n\u00111\u0001\u007f\u0003%\u0001(/\u001b8dSB\fG\u000e\u0005\u0002J\u007f&\u0019\u0011\u0011\u0001&\u0003\u001d-\u000bgm[1Qe&t7-\u001b9bY\u0006i\"-^5mIB\u0013x\u000eZ;dKJ+\u0017/^3ti\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\b)\u001aa0!\u0003,\u0005\u0005-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0006)\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\tyAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fACY;jY\u0012\u0004&o\u001c3vG\u0016\u0014Vm\u001d9p]N,GCBA\u0010\u0003K\tI\u0003E\u00024\u0003CI1!a\t9\u0005!\u0011Vm\u001d9p]N,\u0007BBA\u0014\u0019\u0001\u0007!/A\u0004sKF,Xm\u001d;\t\u000f\u0005-B\u00021\u0001\u0002.\u0005Y\u0011m\u0019;j_:\fV/Z;f!\u0011\ty#!\u000e\u000e\u0005\u0005E\"bAA\u001aE\u000511/\u001a:wKJLA!a\u000e\u00022\tY\u0011i\u0019;j_:\fV/Z;f\u0003q!Xm\u001d;J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;feJ+\u0017/^3tiND#!D5\u0002-Q,7\u000f^\"sK\u0006$Xm\u00117vgR,'\u000fT5oWND#AD5\u0002EQ,7\u000f\u001e(p]\u0006cG/\u001a:SKF,Xm\u001d;t\u001d>$HK]1og\u001a|'/\\3eQ\ty\u0011.\u0001\tuKN$(j]8o%\u0016\fX/Z:ug\"\u0012\u0001#[\u0001\u001ai\u0016\u001cHOQ;jY\u0012,eN^3m_B,'+Z:q_:\u001cX\rF\u0002Z\u0003\u001bBq!a\u0014\u0012\u0001\u0004\t\t&A\u0003feJ|'\u000f\u0005\u0003\u0002T\u0005eSBAA+\u0015\r\t9FT\u0001\taJ|Go\\2pY&!\u00111LA+\u0005\u0019)%O]8sg\"Z\u0011#a\u0018\u0002p\u0005E\u00141OA;!\u0011\t\t'a\u001b\u000e\u0005\u0005\r$\u0002BA3\u0003O\n\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0004\u0003S\n\u0017A\u00029be\u0006l7/\u0003\u0003\u0002n\u0005\r$AC#ok6\u001cv.\u001e:dK\u0006)a/\u00197vK\u000e\u0012\u0011\u0011K\u0001\u0006]\u0006lWm\u001d\u0017\u0007\u0003o\nY(a \"\u0005\u0005e\u0014\u0001\u0002(P\u001d\u0016\u000b#!! \u00029\rcUk\u0015+F%~\u000bU\u000b\u0016%P%&S\u0016\tV%P\u001d~3\u0015)\u0013'F\t\u0006\u0012\u0011\u0011Q\u0001\u000f\u001d>#vlQ(O)J{E\nT#SQ\r\t\u0012Q\u0011\t\u0005\u0003\u000f\u000bI)\u0004\u0002\u0002h%!\u00111RA4\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0018EVLG\u000eZ\"sK\u0006$X\rV8qS\u000e\u0014V-];fgR$B!!%\u0002\u001eB!\u00111SAM\u001b\t\t)JC\u0002\u0002\u0018:\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u00037\u000b)JA\nDe\u0016\fG/\u001a+pa&\u001c7OU3rk\u0016\u001cH\u000fC\u0004\u0002 J\u0001\r!!)\u0002\u000bQ|\u0007/[2\u0011\t\u0005\r\u0016\u0011\u0017\b\u0005\u0003K\u000bi\u000bE\u0002\u0002(\"j!!!+\u000b\u0007\u0005-F%\u0001\u0004=e>|GOP\u0005\u0004\u0003_C\u0013A\u0002)sK\u0012,g-\u0003\u0003\u00024\u0006U&AB*ue&twMC\u0002\u00020\"\n\u0001DY;jY\u0012\u001c%/Z1uKR{\u0007/[2SKN\u0004xN\\:f)\u0019\tY,!1\u0002DB!\u00111SA_\u0013\u0011\ty,!&\u0003)\r\u0013X-\u0019;f)>\u0004\u0018nY:SKN\u0004xN\\:f\u0011\u001d\tyj\u0005a\u0001\u0003CCq!a\u0014\u0014\u0001\u0004\t\t&A\u000fck&dG-\u00168xe\u0006\u0004\b/\u001a3F]Z,Gn\u001c9f%\u0016\fX/Z:u)\r\u0011\u0018\u0011\u001a\u0005\b\u0003O!\u0002\u0019AAf!\u0011\t\u0019*!4\n\t\u0005=\u0017Q\u0013\u0002\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti\u0006Y\u0011n\u001d,bY&$'j]8o)\u0011\t).a7\u0011\u0007\u001d\n9.C\u0002\u0002Z\"\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002^V\u0001\r!!)\u0002\u0007M$(/\u0001\nsKF,Xm\u001d;XSRDW*\u001a;sS\u000e\u001cH#\u0003:\u0002d\u0006\u001d\u0018\u0011^Av\u0011\u001d\t)O\u0006a\u0001\u0003\u0017\f1A]3r\u0011\u0015Yh\u00031\u00013\u0011\u001d1h\u0003%AA\u0002]Dq! \f\u0011\u0002\u0003\u0007a0\u0001\u000fsKF,Xm\u001d;XSRDW*\u001a;sS\u000e\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005E(fA<\u0002\n\u0005a\"/Z9vKN$x+\u001b;i\u001b\u0016$(/[2tI\u0011,g-Y;mi\u0012\"D#\u0002:\u0002x\u0006e\bbBAs3\u0001\u0007\u00111\u001a\u0005\b{f\u0001\n\u00111\u0001\u007f\u0003E\u0011X-];fgR$C-\u001a4bk2$HEM\u0001\u0012]\u0016<(+Z9vKN$8i\u001c8uKb$HC\u0002B\u0001\u0005\u000f\u00119\u0002\u0005\u0003\u0002\u0014\n\r\u0011\u0002\u0002B\u0003\u0003+\u0013aBU3rk\u0016\u001cHoQ8oi\u0016DH\u000fC\u0004\u0003\nm\u0001\rAa\u0003\u0002\r\t,hMZ3s!\u0011\u0011iAa\u0005\u000e\u0005\t=!b\u0001B\t\t\u0006\u0019a.[8\n\t\tU!q\u0002\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"B?\u001c\u0001\u0004q\u0018!\u0002;p\u001b\u0006\u0004H\u0003\u0002B\u000f\u0005S\u0001\u0002Ba\b\u0003&\u0005\u0005\u0016\u0011U\u0007\u0003\u0005CQ1Aa\t)\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005O\u0011\tCA\u0002NCBDqAa\u000b\u001d\u0001\u0004\u0011i#\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0005_\u0011IE\u0004\u0003\u00032\t\u0015c\u0002\u0002B\u001a\u0005\u0007rAA!\u000e\u0003B9!!q\u0007B \u001d\u0011\u0011ID!\u0010\u000f\t\u0005\u001d&1H\u0005\u0002)&\u0011!kU\u0005\u0003GEK!a\u0014)\n\u0007\u0005]e*\u0003\u0003\u0003H\u0005U\u0015aE!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z9vKN$\u0018\u0002\u0002B&\u0005\u001b\u0012aaQ8oM&<'\u0002\u0002B$\u0003+#BA!\b\u0003R!9!1F\u000fA\u0002\tM\u0003\u0003\u0002B+\u0005CrAAa\u0016\u0003^5\u0011!\u0011\f\u0006\u0004\u00057r\u0015aB7fgN\fw-Z\u0005\u0005\u0005?\u0012I&\u0001\u0012J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u000e{gNZ5hgJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0005G\u0012)GA\rBYR,'/\u00192mK\u000e{gNZ5h\u0007>dG.Z2uS>t'\u0002\u0002B0\u00053\nQCY;jY\u0012,eN^3m_B,'+Z:q_:\u001cX\r\u0006\u0004\u0003l\tE$Q\u000f\t\u0005\u0003'\u0013i'\u0003\u0003\u0003p\u0005U%\u0001E#om\u0016dw\u000e]3SKN\u0004xN\\:f\u0011\u0019\u0011\u0019H\ba\u0001e\u0006IQO\\<sCB\u0004X\r\u001a\u0005\b\u0005or\u0002\u0019\u0001B=\u0003!\u0011Xm\u001d9p]N,\u0007\u0003BAJ\u0005wJAA! \u0002\u0016\n\u0001\u0012IY:ue\u0006\u001cGOU3ta>t7/\u001a")
public class RequestChannelTest {
    private final RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
    private final KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null){

        public byte[] serialize(KafkaPrincipal principal) {
            return principal.toString().getBytes(StandardCharsets.UTF_8);
        }

        public KafkaPrincipal deserialize(byte[] bytes) {
            return SecurityUtils.parseKafkaPrincipal((String)new String(bytes, StandardCharsets.UTF_8));
        }
    };

    private RequestChannel.Metrics requestChannelMetrics() {
        return this.requestChannelMetrics;
    }

    private KafkaPrincipalSerde principalSerde() {
        return this.principalSerde;
    }

    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    @Test
    public void testSerializeRequest() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(brokerResource, new AlterConfigsRequest.Config((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$)).asJava())), true).build(), this.request$default$2());
        ByteBuffer serialized = alterConfigs.serialize();
        Assertions.assertEquals((Object)alterConfigs.buffer().rewind(), (Object)serialized.rewind());
    }

    @Test
    public void testAlterRequests() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry keystoreLocation = new AlterConfigsRequest.ConfigEntry("ssl.keystore.location", "/path/to/keystore");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystoreLocation, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")})), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystoreLocation, (List)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$)), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry listenerKeyPassword = new AlterConfigsRequest.ConfigEntry(new StringBuilder(39).append("listener.name.internal.").append("ssl.key.password").toString(), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)listenerKeyPassword, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)listenerKeyPassword.name()), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry listenerKeystore = new AlterConfigsRequest.ConfigEntry(new StringBuilder(44).append("listener.name.internal.").append("ssl.keystore.location").toString(), "/path/to/keystore");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)listenerKeystore, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)listenerKeystore.name()), (Object)"/path/to/keystore")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry plainJaasConfig = new AlterConfigsRequest.ConfigEntry(new StringBuilder(45).append("listener.name.internal.plain.").append("sasl.jaas.config").toString(), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)plainJaasConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plainJaasConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry plainLoginCallback = new AlterConfigsRequest.ConfigEntry(new StringBuilder(62).append("listener.name.internal.plain.").append("sasl.login.callback.handler.class").toString(), "test.LoginClass");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)plainLoginCallback, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plainLoginCallback.name()), (Object)plainLoginCallback.value())})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry customConfig = new AlterConfigsRequest.ConfigEntry("custom.config", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)customConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)customConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "testTopic");
        AlterConfigsRequest.ConfigEntry compressionType = new AlterConfigsRequest.ConfigEntry("compression.type", "lz4");
        this.verifyConfig$1(topicResource, (Seq)new .colon.colon((Object)compressionType, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)"lz4")})), sensitiveValue);
        this.verifyConfig$1(topicResource, (Seq)new .colon.colon((Object)customConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)customConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.emptyMap(), true).build(), this.request$default$2());
        Assertions.assertEquals(Collections.emptyMap(), (Object)((AlterConfigsRequest)alterConfigs.loggableRequest()).configs());
    }

    @Test
    public void testHealthCheckTotalTimeMs() {
        TenantMetadata healthCheckTenantMetadata = new TenantMetadata.Builder("ClusterId2", "UserResourceId2").healthcheckTenant(true).build();
        MultiTenantPrincipal healthCheckPrincipal = new MultiTenantPrincipal("user2", healthCheckTenantMetadata);
        long startTimeNanos = Time.SYSTEM.nanoseconds();
        RequestChannel.Metrics requestMetrics = new RequestChannel.Metrics(ApiMessageType.ListenerType.BROKER);
        ActionQueue actionQueue = new ActionQueue();
        RequestChannel.Request healthCheckRequest = this.buildProduceRequest(startTimeNanos, requestMetrics, (KafkaPrincipal)healthCheckPrincipal);
        RequestChannel.Response healthCheckResponse = this.buildProduceResponse(healthCheckRequest, actionQueue);
        RequestChannel.Request nonHealthCheckRequest = this.buildProduceRequest(startTimeNanos, requestMetrics, this.buildProduceRequest$default$3());
        RequestChannel.Response nonHealthCheckResponse = this.buildProduceResponse(nonHealthCheckRequest, actionQueue);
        healthCheckRequest.updateRequestMetrics(startTimeNanos, startTimeNanos, healthCheckResponse, (Option)None$.MODULE$, null, healthCheckRequest.updateRequestMetrics$default$6());
        nonHealthCheckRequest.updateRequestMetrics(startTimeNanos, startTimeNanos, nonHealthCheckResponse, (Option)None$.MODULE$, null, nonHealthCheckRequest.updateRequestMetrics$default$6());
        actionQueue.tryCompleteActions();
        RequestMetrics m = requestMetrics.apply(ApiKeys.PRODUCE.name);
        Assertions.assertEquals((long)1L, (long)m.healthCheckTotalTimeHist().count());
        Assertions.assertEquals((long)2L, (long)m.totalTimeHist().count());
    }

    private RequestChannel.Request buildProduceRequest(long startTimeNanos, RequestChannel.Metrics metrics, KafkaPrincipal principal) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(256), (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, null, "a".getBytes());
        ProduceRequest.Builder requestBuilder = ProduceRequest.forMagic((byte)2, (ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("test").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(9).setRecords((BaseRecords)builder.build())))).iterator())).setAcks((short)1).setTimeoutMs(5000));
        return this.requestWithMetrics(requestBuilder.build(), metrics, startTimeNanos, principal);
    }

    private KafkaPrincipal buildProduceRequest$default$3() {
        return new KafkaPrincipal("User", "user");
    }

    private RequestChannel.Response buildProduceResponse(RequestChannel.Request request, ActionQueue actionQueue) {
        ProduceResponse rawProduceResponse = new ProduceResponse(new ProduceResponseData());
        return new RequestChannel.SendResponse(request, request.buildResponseSend((AbstractResponse)rawProduceResponse, actionQueue), (Option)None$.MODULE$);
    }

    @Test
    public void testIncrementalAlterRequests() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        Map keystorePassword = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystorePassword, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map keystoreLocation = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystoreLocation, keystoreLocation, sensitiveValue);
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, (Map)keystoreLocation.$plus$plus((IterableOnce)keystorePassword), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map listenerKeyPassword = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(39).append("listener.name.internal.").append("ssl.key.password").toString()), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, listenerKeyPassword, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(39).append("listener.name.internal.").append("ssl.key.password").toString()), (Object)"[hidden]")})), sensitiveValue);
        Map listenerKeystore = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(44).append("listener.name.internal.").append("ssl.keystore.location").toString()), (Object)"/path/to/keystore")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, listenerKeystore, listenerKeystore, sensitiveValue);
        Map plainJaasConfig = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(45).append("listener.name.internal.plain.").append("sasl.jaas.config").toString()), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, plainJaasConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(45).append("listener.name.internal.plain.").append("sasl.jaas.config").toString()), (Object)"[hidden]")})), sensitiveValue);
        Map plainLoginCallback = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(62).append("listener.name.internal.plain.").append("sasl.login.callback.handler.class").toString()), (Object)"test.LoginClass")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, plainLoginCallback, plainLoginCallback, sensitiveValue);
        Map sslProtocols = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.APPEND, sslProtocols, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")})), sensitiveValue);
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SUBTRACT, sslProtocols, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")})), sensitiveValue);
        Map cipherSuites = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.cipher.suites"), null)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.DELETE, cipherSuites, cipherSuites, sensitiveValue);
        Map customConfig = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, customConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "testTopic");
        Map compressionType = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)"lz4")}));
        this.verifyConfig$2(topicResource, AlterConfigOp.OpType.SET, compressionType, compressionType, sensitiveValue);
        this.verifyConfig$2(topicResource, AlterConfigOp.OpType.SET, customConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource linkResource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, "link1");
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, keystorePassword, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, keystoreLocation, keystoreLocation, sensitiveValue);
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, (Map)keystoreLocation.$plus$plus((IterableOnce)keystorePassword), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map linkJaasConfig = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)sensitiveValue)}));
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, linkJaasConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)"[hidden]")})), sensitiveValue);
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, customConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
    }

    @Test
    public void testCreateClusterLinks() {
        String sensitiveValue = "secret";
        Map keystorePassword = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)sensitiveValue)}));
        this.verifyConfigs$1(keystorePassword, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map keystoreLocation = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")}));
        this.verifyConfigs$1(keystoreLocation, keystoreLocation, sensitiveValue);
        this.verifyConfigs$1((Map)keystoreLocation.$plus$plus((IterableOnce)keystorePassword), (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map plainJaasConfig = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)sensitiveValue)}));
        this.verifyConfigs$1(plainJaasConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)"[hidden]")})), sensitiveValue);
    }

    @Test
    public void testNonAlterRequestsNotTransformed() {
        RequestChannel.Request metadataRequest = this.request(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"topic", (List)Nil$.MODULE$)).asJava(), true).build(), this.request$default$2());
        Assertions.assertSame((Object)metadataRequest.body(ClassTag$.MODULE$.apply(MetadataRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl())), (Object)metadataRequest.loggableRequest());
    }

    @Test
    public void testJsonRequests() {
        String sensitiveValue = "secret";
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        .colon.colon entries = new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(resource, new AlterConfigsRequest.Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)entries).asJavaCollection())), true).build(), this.request$default$2());
        Assertions.assertTrue((boolean)this.isValidJson(RequestConvertToJson$.MODULE$.request(alterConfigs.loggableRequest()).toString()));
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"NONE", "CLUSTER_AUTHORIZATION_FAILED", "NOT_CONTROLLER"})
    public void testBuildEnvelopeResponse(Errors error) {
        String topic = "foo";
        CreateTopicsRequest createTopicRequest = this.buildCreateTopicRequest(topic);
        RequestChannel.Request unwrapped = this.buildUnwrappedEnvelopeRequest((AbstractRequest)createTopicRequest);
        CreateTopicsResponse createTopicResponse = this.buildCreateTopicResponse(topic, error);
        EnvelopeResponse envelopeResponse = this.buildEnvelopeResponse(unwrapped, (AbstractResponse)createTopicResponse);
        if (Errors.NOT_CONTROLLER.equals(error)) {
            Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)envelopeResponse.error());
            Assertions.assertNull((Object)envelopeResponse.responseData());
            return;
        }
        Assertions.assertEquals((Object)Errors.NONE, (Object)envelopeResponse.error());
        AbstractResponse unwrappedResponse = AbstractResponse.parseResponse((ByteBuffer)envelopeResponse.responseData(), (RequestHeader)unwrapped.header(), (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals((Object)createTopicResponse.data(), (Object)unwrappedResponse.data());
    }

    private CreateTopicsRequest buildCreateTopicRequest(String topic) {
        CreateTopicsRequestData requestData = new CreateTopicsRequestData();
        requestData.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName(topic).setReplicationFactor((short)-1).setNumPartitions(-1));
        return (CreateTopicsRequest)new CreateTopicsRequest.Builder(requestData).build();
    }

    private CreateTopicsResponse buildCreateTopicResponse(String topic, Errors error) {
        CreateTopicsResponseData responseData = new CreateTopicsResponseData();
        responseData.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(topic).setErrorCode(error.code()));
        return new CreateTopicsResponse(responseData);
    }

    private RequestChannel.Request buildUnwrappedEnvelopeRequest(AbstractRequest request2) {
        RequestChannel.Request wrappedRequest = TestUtils$.MODULE$.buildEnvelopeRequest(request2, this.principalSerde(), this.requestChannelMetrics(), System.nanoTime(), -1L, true);
        AtomicReference unwrappedRequest = new AtomicReference();
        EnvelopeUtils$.MODULE$.handleEnvelopeRequest(wrappedRequest, this.requestChannelMetrics(), (Function1 & Serializable)request -> {
            unwrappedRequest.set(request);
            return BoxedUnit.UNIT;
        });
        return (RequestChannel.Request)unwrappedRequest.get();
    }

    private boolean isValidJson(String str) {
        try {
            new ObjectMapper().readTree(str);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public RequestChannel.Request requestWithMetrics(AbstractRequest req, RequestChannel.Metrics metrics, long startTimeNanos, KafkaPrincipal principal) {
        ByteBuffer buffer = req.serializeWithHeader(new RequestHeader(req.apiKey(), req.version(), "client-id", 1));
        RequestContext requestContext = this.newRequestContext(buffer, principal);
        return new RequestChannel.Request(1, requestContext, startTimeNanos, (MemoryPool)Mockito.mock(MemoryPool.class), buffer, metrics, (Option)None$.MODULE$, NoOpEventEmitter.INSTANCE, (AuditLogProvider)NoOpAuditLogProvider.INSTANCE, RequestLogFilter.MATCH_NONE, 0L);
    }

    public RequestChannel.Request request(AbstractRequest req, KafkaPrincipal principal) {
        ByteBuffer buffer = req.serializeWithHeader(new RequestHeader(req.apiKey(), req.version(), "client-id", 1));
        RequestContext requestContext = this.newRequestContext(buffer, principal);
        return new RequestChannel.Request(1, requestContext, 0L, (MemoryPool)Mockito.mock(MemoryPool.class), buffer, (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class), (Option)None$.MODULE$, NoOpEventEmitter.INSTANCE, (AuditLogProvider)NoOpAuditLogProvider.INSTANCE, RequestLogFilter.MATCH_NONE, 0L);
    }

    public long requestWithMetrics$default$3() {
        return 0L;
    }

    public KafkaPrincipal requestWithMetrics$default$4() {
        return new KafkaPrincipal("User", "user");
    }

    public KafkaPrincipal request$default$2() {
        return new KafkaPrincipal("User", "user");
    }

    private RequestContext newRequestContext(ByteBuffer buffer, KafkaPrincipal principal) {
        return new RequestContext(RequestHeader.parse((ByteBuffer)buffer), "connection-id", InetAddress.getLoopbackAddress(), principal, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, new ClientInformation("name", "version"), null, false);
    }

    private Map<String, String> toMap(AlterConfigsRequest.Config config) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(config.entries()).asScala().map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, String> toMap(IncrementalAlterConfigsRequestData.AlterableConfigCollection config) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)config).asScala().map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private EnvelopeResponse buildEnvelopeResponse(RequestChannel.Request unwrapped, AbstractResponse response) {
        Assertions.assertTrue((boolean)unwrapped.envelope().isDefined());
        RequestChannel.Request envelope = (RequestChannel.Request)unwrapped.envelope().get();
        ActionQueue actionQueue = new ActionQueue();
        Send send = unwrapped.buildResponseSend(response, actionQueue);
        actionQueue.tryCompleteActions();
        ByteBuffer sendBytes = TestUtils.toBuffer((Send)send);
        Assertions.assertEquals((int)sendBytes.getInt(), (int)sendBytes.remaining());
        AbstractResponse envelopeResponse = AbstractResponse.parseResponse((ByteBuffer)sendBytes, (RequestHeader)envelope.header(), (MessageContext)MessageContext.IDENTITY);
        Assertions.assertTrue((boolean)(envelopeResponse instanceof EnvelopeResponse));
        return (EnvelopeResponse)envelopeResponse;
    }

    private final void verifyConfig$1(ConfigResource resource, Seq entries, Map expectedValues, String sensitiveValue$1) {
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(resource, new AlterConfigsRequest.Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)entries).asJavaCollection())), true).build(), this.request$default$2());
        AlterConfigsRequest.Config loggedConfig = (AlterConfigsRequest.Config)((AlterConfigsRequest)alterConfigs.loggableRequest()).configs().get(resource);
        Assertions.assertEquals((Object)expectedValues, this.toMap(loggedConfig));
        String alterConfigsDesc = RequestConvertToJson$.MODULE$.requestDesc(alterConfigs.header(), alterConfigs.requestLog(), alterConfigs.isForwarded()).toString();
        Assertions.assertFalse((boolean)alterConfigsDesc.contains(sensitiveValue$1), (String)new StringBuilder(24).append("Sensitive config logged ").append(alterConfigsDesc).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterRequests$1(IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs$1, AlterConfigOp.OpType op$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            String value = (String)x0$1._2();
            return alterableConfigs$1.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setName(name).setValue(value).setConfigOperation(op$1.id()));
        }
        throw new MatchError(null);
    }

    private static final IncrementalAlterConfigsRequest incrementalAlterConfigs$1(ConfigResource resource, Map entries, AlterConfigOp.OpType op) {
        IncrementalAlterConfigsRequestData data = new IncrementalAlterConfigsRequestData();
        IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
        entries.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RequestChannelTest.$anonfun$testIncrementalAlterRequests$1(alterableConfigs, op, x0$1)));
        data.resources().add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName(resource.name()).setResourceType(resource.type().id()).setConfigs(alterableConfigs));
        return (IncrementalAlterConfigsRequest)new IncrementalAlterConfigsRequest.Builder(data).build();
    }

    private final void verifyConfig$2(ConfigResource resource, AlterConfigOp.OpType op, Map entries, Map expectedValues, String sensitiveValue$2) {
        RequestChannel.Request alterConfigs = this.request((AbstractRequest)RequestChannelTest.incrementalAlterConfigs$1(resource, entries, op), this.request$default$2());
        IncrementalAlterConfigsRequestData.AlterableConfigCollection loggedConfig = ((IncrementalAlterConfigsRequest)alterConfigs.loggableRequest()).data().resources().find(resource.type().id(), resource.name()).configs();
        Assertions.assertEquals((Object)expectedValues, this.toMap(loggedConfig));
        String alterConfigsDesc = RequestConvertToJson$.MODULE$.requestDesc(alterConfigs.header(), alterConfigs.requestLog(), alterConfigs.isForwarded()).toString();
        Assertions.assertFalse((boolean)alterConfigsDesc.contains(sensitiveValue$2), (String)new StringBuilder(24).append("Sensitive config logged ").append(alterConfigsDesc).toString());
    }

    private final void verifyConfigs$1(Map requestConfigs, Map expectedLoggedConfigs, String sensitiveValue$3) {
        Set<NewClusterLink> link = Collections.singleton(new NewClusterLink("linkName", "clusterId", CollectionConverters$.MODULE$.MapHasAsJava(requestConfigs).asJava()));
        CreateClusterLinksRequest createRequest = (CreateClusterLinksRequest)new CreateClusterLinksRequest.Builder(link, false, false, 10000).build();
        RequestChannel.Request createLinks = this.request((AbstractRequest)createRequest, this.request$default$2());
        CreateClusterLinksRequest loggableRequest = (CreateClusterLinksRequest)createLinks.loggableRequest();
        scala.collection.mutable.Map loggedConfigs = CollectionConverters$.MODULE$.MapHasAsScala(((NewClusterLink)CollectionConverters$.MODULE$.CollectionHasAsScala(loggableRequest.newClusterLinks()).asScala().head()).configs()).asScala();
        Assertions.assertEquals((Object)expectedLoggedConfigs, (Object)loggedConfigs);
        String createLinksDesc = RequestConvertToJson$.MODULE$.requestDesc(createLinks.header(), createLinks.requestLog(), true).toString();
        Assertions.assertFalse((boolean)createLinksDesc.contains(sensitiveValue$3), (String)new StringBuilder(24).append("Sensitive config logged ").append(createLinksDesc).toString());
    }
}

