/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.telemetry.api.events.NoOpEventEmitter;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import kafka.network.PrincipalConvertToJson$;
import kafka.network.RequestChannel;
import kafka.network.RequestConvertToJson$;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.DescribeAclsRequestData;
import org.apache.kafka.common.message.DescribeLogDirsResponseData;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.message.RequestHeaderDataJsonConverter;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.AdaptiveSampler;
import org.apache.kafka.common.utils.LogAction;
import org.apache.kafka.common.utils.SlowLogAction;
import org.apache.kafka.common.utils.TimeBasedSampler;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015c\u0001B\n\u0015\u0001eAQ\u0001\t\u0001\u0005\u0002\u0005BQ\u0001\n\u0001\u0005\u0002\u0015BQA\u000e\u0001\u0005\u0002\u0015BQ\u0001\u000f\u0001\u0005\u0002\u0015BQA\u000f\u0001\u0005\u0002\u0015BQ\u0001\u0010\u0001\u0005\u0002\u0015BQA\u0010\u0001\u0005\u0002\u0015BQ\u0001\u0011\u0001\u0005\u0002\u0015BQA\u0011\u0001\u0005\u0002\u0015BQ\u0001\u0012\u0001\u0005\u0002\u0015BQA\u0012\u0001\u0005\u0002\u0015BQ\u0001\u0013\u0001\u0005\u0002\u0015BQA\u0013\u0001\u0005\n-CQa\u0017\u0001\u0005\nqCQ\u0001\u001c\u0001\u0005\n5DQa\u001d\u0001\u0005\nQDq!!\u0002\u0001\t\u0003\t9\u0001C\u0004\u0002(\u0001!I!!\u000b\u00031I+\u0017/^3ti\u000e{gN^3siR{'j]8o)\u0016\u001cHO\u0003\u0002\u0016-\u00059a.\u001a;x_J\\'\"A\f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0007\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005!\u0012A\u0007;fgR\fE\u000e\u001c*fcV,7\u000f\u001e+za\u0016\u001c\b*\u00198eY\u0016$G#\u0001\u0014\u0011\u0005m9\u0013B\u0001\u0015\u001d\u0005\u0011)f.\u001b;)\u0005\tQ\u0003CA\u00165\u001b\u0005a#BA\u0017/\u0003\r\t\u0007/\u001b\u0006\u0003_A\nqA[;qSR,'O\u0003\u00022e\u0005)!.\u001e8ji*\t1'A\u0002pe\u001eL!!\u000e\u0017\u0003\tQ+7\u000f^\u0001\"i\u0016\u001cH/\u00117m\u0003BLg+\u001a:tS>t7OU3ta>t7/\u001a%b]\u0012dW\r\u001a\u0015\u0003\u0007)\n1\u0004^3ti\u0006cGNU3ta>t7/\u001a+za\u0016\u001c\b*\u00198eY\u0016$\u0007F\u0001\u0003+\u0003U!Xm\u001d;SKF,Xm\u001d;IK\u0006$WM\u001d(pI\u0016D#!\u0002\u0016\u0002%Q,7\u000f^\"mS\u0016tG/\u00138g_:{G-\u001a\u0015\u0003\r)\nq\u0002^3tiJ+\u0017/^3ti\u0012+7o\u0019\u0015\u0003\u000f)\na\u0003^3tiJ+\u0017/^3ti\u0012+7oY'fiJL7m\u001d\u0015\u0003\u0011)\n!\u0003^3tiNcwn\u001e'pOJ+\u0017\u000fR3tG\"\u0012\u0011BK\u0001!i\u0016\u001cHoS1gW\u0006\u0004&/\u001b8dSB\fGNS:p]\u000e{gN^3sg&|g\u000e\u000b\u0002\u000bU\u0005!C/Z:u\u0007>tg\r\\;f]R\u0004&/\u001b8dSB\fGNS:p]\u000e{gN^3sg&|g\u000e\u000b\u0002\fU\u0005\tC/Z:u)\u0016t\u0017M\u001c;Qe&t7-\u001b9bY*\u001bxN\\\"p]Z,'o]5p]\"\u0012ABK\u0001\u0014CN\u001cXM\u001d;Qe&t7-\u001b9bY*\u001bxN\u001c\u000b\u0003M1CQ!T\u0007A\u00029\u000b\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\u0011\u0005=KV\"\u0001)\u000b\u0005E\u0013\u0016\u0001B1vi\"T!a\u0015+\u0002\u0011M,7-\u001e:jifT!!\u0016,\u0002\r\r|W.\\8o\u0015\t9rK\u0003\u0002Ye\u00051\u0011\r]1dQ\u0016L!A\u0017)\u0003\u001d-\u000bgm[1Qe&t7-\u001b9bY\u0006A\u0012m]:feR\\\u0015MZ6b!JLgnY5qC2T5o\u001c8\u0015\u0007\u0019jf\fC\u0003N\u001d\u0001\u0007a\nC\u0003`\u001d\u0001\u0007\u0001-\u0001\u0003kg>t\u0007CA1k\u001b\u0005\u0011'BA2e\u0003!!\u0017\r^1cS:$'BA3g\u0003\u001dQ\u0017mY6t_:T!a\u001a5\u0002\u0013\u0019\f7\u000f^3sq6d'\"A5\u0002\u0007\r|W.\u0003\u0002lE\nA!j]8o\u001d>$W-\u0001\u000fbgN,'\u000f^\"p]\u001adW/\u001a8u!JLgnY5qC2T5o\u001c8\u0015\u0007\u0019r'\u000fC\u0003N\u001f\u0001\u0007q\u000e\u0005\u0002Pa&\u0011\u0011\u000f\u0015\u0002\u0013\u0007>tg\r\\;f]R\u0004&/\u001b8dSB\fG\u000eC\u0003`\u001f\u0001\u0007\u0001-A\rbgN,'\u000f\u001e+f]\u0006tG\u000f\u0015:j]\u000eL\u0007/\u00197Kg>tG\u0003\u0002\u0014v\u0003\u0007AQ!\u0014\tA\u0002Y\u0004\"a^@\u000e\u0003aT!!\u001f>\u0002\u00175,H\u000e^5uK:\fg\u000e\u001e\u0006\u0003/mT!\u0001`?\u0002\u0013\r|gN\u001a7vK:$(\"\u0001@\u0002\u0005%|\u0017bAA\u0001q\n!R*\u001e7uSR+g.\u00198u!JLgnY5qC2DQa\u0018\tA\u0002\u0001\fqA]3rk\u0016\u001cH\u000f\u0006\u0003\u0002\n\u0005]\u0001\u0003BA\u0006\u0003#q1aIA\u0007\u0013\r\ty\u0001F\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\u0011\t\u0019\"!\u0006\u0003\u000fI+\u0017/^3ti*\u0019\u0011q\u0002\u000b\t\u000f\u0005e\u0011\u00031\u0001\u0002\u001c\u0005\u0019!/Z9\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\tU\u0003!\u0011X-];fgR\u001c\u0018\u0002BA\u0013\u0003?\u0011q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f^\u0001\u0012]\u0016<(+Z9vKN$8i\u001c8uKb$H\u0003BA\u0016\u0003c\u0001B!!\b\u0002.%!\u0011qFA\u0010\u00059\u0011V-];fgR\u001cuN\u001c;fqRDq!a\r\u0013\u0001\u0004\t)$\u0001\u0004ck\u001a4WM\u001d\t\u0005\u0003o\t\t%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003\rq\u0017n\u001c\u0006\u0003\u0003\u007f\tAA[1wC&!\u00111IA\u001d\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d")
public class RequestConvertToJsonTest {
    @Test
    public void testAllRequestTypesHandled() {
        ArrayBuffer unhandledKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ApiKeys.values()), (Function1 & Serializable)key -> {
            short version = key.latestVersion();
            ByteBuffer bytes = MessageUtil.toByteBuffer((Message)(ApiKeys.DESCRIBE_ACLS.equals(key) ? ((DescribeAclsRequestData)ApiMessageType.fromApiKey((short)key.id).newRequest()).setPatternTypeFilter((byte)1).setResourceTypeFilter((byte)1).setPermissionType((byte)1).setOperation((byte)1) : ApiMessageType.fromApiKey((short)key.id).newRequest()), (short)version);
            AbstractRequest req = AbstractRequest.parseRequest((ApiKeys)key, (short)version, (ByteBuffer)bytes, (MessageContext)MessageContext.IDENTITY).request;
            try {
                return RequestConvertToJson$.MODULE$.request(req);
            }
            catch (IllegalStateException illegalStateException) {
                return unhandledKeys.$plus$eq((Object)key.toString());
            }
        });
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), (Object)unhandledKeys, (String)"Unhandled request keys");
    }

    @Test
    public void testAllApiVersionsResponseHandled() {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ApiKeys.values()), (Function1 & Serializable)key -> {
            RequestConvertToJsonTest.$anonfun$testAllApiVersionsResponseHandled$1(key);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAllResponseTypesHandled() {
        ArrayBuffer unhandledKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ApiKeys.values()), (Function1 & Serializable)key -> {
            short version = key.latestVersion();
            ByteBuffer bytes = MessageUtil.toByteBuffer((Message)ApiMessageType.fromApiKey((short)key.id).newResponse(), (short)version);
            AbstractResponse res = AbstractResponse.parseResponse((ApiKeys)key, (ByteBuffer)bytes, (short)version, (MessageContext)MessageContext.IDENTITY);
            try {
                return RequestConvertToJson$.MODULE$.response(res, version);
            }
            catch (IllegalStateException illegalStateException) {
                return unhandledKeys.$plus$eq((Object)key.toString());
            }
        });
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), (Object)unhandledKeys, (String)"Unhandled response keys");
    }

    @Test
    public void testRequestHeaderNode() {
        AlterPartitionRequest alterIsrRequest = new AlterPartitionRequest(new AlterPartitionRequestData(), 0);
        RequestHeader header = this.request((AbstractRequest)alterIsrRequest).header();
        ObjectNode expectedNode = (ObjectNode)RequestHeaderDataJsonConverter.write((RequestHeaderData)header.data(), (short)header.headerVersion(), (boolean)false);
        expectedNode.set("requestApiKeyName", (JsonNode)new TextNode(header.apiKey().toString()));
        JsonNode actualNode = RequestConvertToJson$.MODULE$.requestHeaderNode(header);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testClientInfoNode() {
        ClientInformation clientInfo = new ClientInformation("name", "1");
        ObjectNode expectedNode = new ObjectNode(JsonNodeFactory.instance);
        expectedNode.set("softwareName", (JsonNode)new TextNode(clientInfo.softwareName()));
        expectedNode.set("softwareVersion", (JsonNode)new TextNode(clientInfo.softwareVersion()));
        JsonNode actualNode = RequestConvertToJson$.MODULE$.clientInfoNode(clientInfo);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testRequestDesc() {
        AlterPartitionRequest alterIsrRequest = new AlterPartitionRequest(new AlterPartitionRequestData(), 0);
        RequestChannel.Request req = this.request((AbstractRequest)alterIsrRequest);
        ObjectNode expectedNode = new ObjectNode(JsonNodeFactory.instance);
        expectedNode.set("isForwarded", (JsonNode)(req.isForwarded() ? BooleanNode.TRUE : BooleanNode.FALSE));
        expectedNode.set("requestHeader", RequestConvertToJson$.MODULE$.requestHeaderNode(req.header()));
        expectedNode.set("request", (JsonNode)req.requestLog().getOrElse((Function0 & Serializable)() -> new TextNode("")));
        JsonNode actualNode = RequestConvertToJson$.MODULE$.requestDesc(req.header(), req.requestLog(), req.isForwarded());
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testRequestDescMetrics() {
        AlterPartitionRequest alterIsrRequest = new AlterPartitionRequest(new AlterPartitionRequestData(), 0);
        RequestChannel.Request req = this.request((AbstractRequest)alterIsrRequest);
        boolean totalTimeMs = true;
        int requestQueueTimeMs = 2;
        int apiLocalTimeMs = 3;
        int apiRemoteTimeMs = 4;
        int apiThrottleTimeMs = 5;
        int responseQueueTimeMs = 6;
        int responseSendTimeMs = 7;
        int responseSendIoTimeMs = 8;
        int responseSizeBytes = 9;
        int temporaryMemoryBytes = 10;
        int messageConversionsTimeMs = 11;
        ObjectNode expectedPrincipalNode = new ObjectNode(JsonNodeFactory.instance);
        expectedPrincipalNode.set("class", (JsonNode)new TextNode("KafkaPrincipal"));
        expectedPrincipalNode.set("type", (JsonNode)new TextNode("User"));
        expectedPrincipalNode.set("name", (JsonNode)new TextNode("user"));
        expectedPrincipalNode.set("tokenAuthenticated", (JsonNode)BooleanNode.FALSE);
        ObjectNode expectedNode = (ObjectNode)RequestConvertToJson$.MODULE$.requestDesc(req.header(), req.requestLog(), req.isForwarded());
        expectedNode.set("response", (JsonNode)req.responseLog().getOrElse((Function0 & Serializable)() -> new TextNode("")));
        expectedNode.set("connection", (JsonNode)new TextNode(req.context().connectionId));
        expectedNode.set("clientAddress", (JsonNode)new TextNode(req.context().clientAddress.getHostAddress()));
        expectedNode.set("totalTimeMs", (JsonNode)new DoubleNode((double)totalTimeMs));
        expectedNode.set("requestQueueTimeMs", (JsonNode)new DoubleNode((double)requestQueueTimeMs));
        expectedNode.set("localTimeMs", (JsonNode)new DoubleNode((double)apiLocalTimeMs));
        expectedNode.set("remoteTimeMs", (JsonNode)new DoubleNode((double)apiRemoteTimeMs));
        expectedNode.set("throttleTimeMs", (JsonNode)new LongNode((long)apiThrottleTimeMs));
        expectedNode.set("responseQueueTimeMs", (JsonNode)new DoubleNode((double)responseQueueTimeMs));
        expectedNode.set("sendTimeMs", (JsonNode)new DoubleNode((double)responseSendTimeMs));
        expectedNode.set("sendIoTimeMs", (JsonNode)new DoubleNode((double)responseSendIoTimeMs));
        expectedNode.set("responseSize", (JsonNode)new LongNode((long)responseSizeBytes));
        expectedNode.set("securityProtocol", (JsonNode)new TextNode(req.context().securityProtocol.toString()));
        expectedNode.set("principal", (JsonNode)expectedPrincipalNode);
        expectedNode.set("listener", (JsonNode)new TextNode(req.context().listenerName.value()));
        expectedNode.set("clientInformation", RequestConvertToJson$.MODULE$.clientInfoNode(req.context().clientInformation));
        expectedNode.set("temporaryMemoryBytes", (JsonNode)new LongNode((long)temporaryMemoryBytes));
        expectedNode.set("messageConversionsTime", (JsonNode)new DoubleNode((double)messageConversionsTimeMs));
        expectedNode.set("isDisconnectedClient", (JsonNode)BooleanNode.TRUE);
        ObjectNode actualNode = (ObjectNode)RequestConvertToJson$.MODULE$.requestDescMetrics(req.header(), req.requestLog(), req.responseLog(), req.context(), req.session(), req.isForwarded(), (double)totalTimeMs, (double)requestQueueTimeMs, (double)apiLocalTimeMs, (double)apiRemoteTimeMs, (long)apiThrottleTimeMs, (double)responseQueueTimeMs, (double)responseSendTimeMs, (double)responseSendIoTimeMs, (long)responseSizeBytes, (long)temporaryMemoryBytes, (double)messageConversionsTimeMs, true, LogAction.LOGGED, 0.0);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testSlowLogReqDesc() {
        ProduceRequest produceRequest = new ProduceRequest(new ProduceRequestData(), 0);
        RequestChannel.Request req = this.request((AbstractRequest)produceRequest);
        AdaptiveSampler slowLogSampler = new AdaptiveSampler(false, 48L);
        boolean totalTimeMs = true;
        int requestQueueTimeMs = 2;
        int apiLocalTimeMs = 3;
        int apiRemoteTimeMs = 4;
        int apiThrottleTimeMs = 5;
        int responseQueueTimeMs = 6;
        int responseSendTimeMs = 7;
        int responseSendIoTimeMs = 8;
        int responseSizeBytes = 9;
        int temporaryMemoryBytes = 10;
        int messageConversionsTimeMs = 11;
        int slowLogThresholdOverride = -1;
        int minP99SlowLogThreshold = -1;
        ObjectNode expectedPrincipalNode = new ObjectNode(JsonNodeFactory.instance);
        expectedPrincipalNode.set("class", (JsonNode)new TextNode("KafkaPrincipal"));
        expectedPrincipalNode.set("type", (JsonNode)new TextNode("User"));
        expectedPrincipalNode.set("name", (JsonNode)new TextNode("user"));
        expectedPrincipalNode.set("tokenAuthenticated", (JsonNode)BooleanNode.FALSE);
        ObjectNode expectedNode = (ObjectNode)RequestConvertToJson$.MODULE$.requestDesc(req.header(), req.requestLog(), req.isForwarded());
        expectedNode.set("response", (JsonNode)req.responseLog().getOrElse((Function0 & Serializable)() -> new TextNode("")));
        expectedNode.set("connection", (JsonNode)new TextNode(req.context().connectionId));
        expectedNode.set("clientAddress", (JsonNode)new TextNode(req.context().clientAddress.getHostAddress()));
        expectedNode.set("totalTimeMs", (JsonNode)new DoubleNode((double)totalTimeMs));
        expectedNode.set("requestQueueTimeMs", (JsonNode)new DoubleNode((double)requestQueueTimeMs));
        expectedNode.set("localTimeMs", (JsonNode)new DoubleNode((double)apiLocalTimeMs));
        expectedNode.set("remoteTimeMs", (JsonNode)new DoubleNode((double)apiRemoteTimeMs));
        expectedNode.set("throttleTimeMs", (JsonNode)new LongNode((long)apiThrottleTimeMs));
        expectedNode.set("responseQueueTimeMs", (JsonNode)new DoubleNode((double)responseQueueTimeMs));
        expectedNode.set("sendTimeMs", (JsonNode)new DoubleNode((double)responseSendTimeMs));
        expectedNode.set("sendIoTimeMs", (JsonNode)new DoubleNode((double)responseSendIoTimeMs));
        expectedNode.set("responseSize", (JsonNode)new LongNode((long)responseSizeBytes));
        expectedNode.set("securityProtocol", (JsonNode)new TextNode(req.context().securityProtocol.toString()));
        expectedNode.set("principal", (JsonNode)expectedPrincipalNode);
        expectedNode.set("listener", (JsonNode)new TextNode(req.context().listenerName.value()));
        expectedNode.set("clientInformation", RequestConvertToJson$.MODULE$.clientInfoNode(req.context().clientInformation));
        expectedNode.set("isDisconnectedClient", (JsonNode)BooleanNode.TRUE);
        expectedNode.set("temporaryMemoryBytes", (JsonNode)new LongNode((long)temporaryMemoryBytes));
        expectedNode.set("messageConversionsTime", (JsonNode)new DoubleNode((double)messageConversionsTimeMs));
        expectedNode.set("isSlowLog", (JsonNode)BooleanNode.TRUE);
        expectedNode.set("slowLogThreshold", (JsonNode)new DoubleNode(100.0));
        ObjectNode actualNode = (ObjectNode)RequestConvertToJson$.MODULE$.requestDescMetrics(req.header(), req.requestLog(), req.responseLog(), req.context(), req.session(), req.isForwarded(), (double)totalTimeMs, (double)requestQueueTimeMs, (double)apiLocalTimeMs, (double)apiRemoteTimeMs, (long)apiThrottleTimeMs, (double)responseQueueTimeMs, (double)responseSendTimeMs, (double)responseSendIoTimeMs, (long)responseSizeBytes, (long)temporaryMemoryBytes, (double)messageConversionsTimeMs, true, (LogAction)new SlowLogAction((TimeBasedSampler)slowLogSampler, Predef$.MODULE$.double2Double((double)slowLogThresholdOverride), Predef$.MODULE$.double2Double((double)minP99SlowLogThreshold)), 100.0);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testKafkaPrincipalJsonConversion() {
        this.assertPrincipalJson(KafkaPrincipal.ANONYMOUS);
        this.assertPrincipalJson(new KafkaPrincipal("User", "userfoo"));
        this.assertPrincipalJson(new KafkaPrincipal("group", "userfoo"));
        this.assertPrincipalJson(new KafkaPrincipal("User", "userbar", true));
        this.assertPrincipalJson(new KafkaPrincipal("group", "userbar", false));
    }

    @Test
    public void testConfluentPrincipalJsonConversion() {
        this.assertPrincipalJson((KafkaPrincipal)new ConfluentPrincipal("User", "userfoo", "authfoo"));
        this.assertPrincipalJson((KafkaPrincipal)new ConfluentPrincipal("group", "userbar", "authfoo", false));
        this.assertPrincipalJson((KafkaPrincipal)new ConfluentPrincipal("User", "userbar", "authfoo", true));
    }

    @Test
    public void testTenantPrincipalJsonConversion() {
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userfoo", RequestConvertToJsonTest.tenantMetadata$1("clusterfoo", "orgfoo", "envfoo", false, false, false)));
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userbar", RequestConvertToJsonTest.tenantMetadata$1("clusterbar", "orgfoo", "envfoo", false, false, false)));
        String x$2 = "clusterfoo";
        String x$3 = "orgfoo";
        boolean x$4 = false;
        boolean x$5 = false;
        boolean x$6 = false;
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userfoo", RequestConvertToJsonTest.tenantMetadata$1(x$2, x$3, "envbar", x$4, x$5, x$6)));
        String x$8 = "clusterfoo";
        String x$9 = "envfoo";
        boolean x$10 = false;
        boolean x$11 = false;
        boolean x$12 = false;
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userbar", RequestConvertToJsonTest.tenantMetadata$1(x$8, "orgbar", x$9, x$10, x$11, x$12)));
        String x$14 = "clusterfoo";
        String x$15 = "orgfoo";
        String x$16 = "envfoo";
        boolean x$17 = false;
        boolean x$18 = false;
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userfoo", RequestConvertToJsonTest.tenantMetadata$1(x$14, x$15, x$16, true, x$17, x$18)));
        String x$20 = "clusterfoo";
        String x$21 = "orgfoo";
        String x$22 = "envfoo";
        boolean x$23 = false;
        boolean x$24 = false;
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userbar", RequestConvertToJsonTest.tenantMetadata$1(x$20, x$21, x$22, x$23, true, x$24)));
        String x$26 = "clusterfoo";
        String x$27 = "orgfoo";
        String x$28 = "envfoo";
        boolean x$29 = false;
        boolean x$30 = false;
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userbar", RequestConvertToJsonTest.tenantMetadata$1(x$26, x$27, x$28, x$29, x$30, true)));
    }

    private void assertPrincipalJson(KafkaPrincipal principal) {
        JsonNode jsonNode = PrincipalConvertToJson$.MODULE$.convert(principal);
        if (principal instanceof MultiTenantPrincipal) {
            MultiTenantPrincipal multiTenantPrincipal = (MultiTenantPrincipal)principal;
            this.assertTenantPrincipalJson(multiTenantPrincipal, jsonNode);
            return;
        }
        if (principal instanceof ConfluentPrincipal) {
            ConfluentPrincipal confluentPrincipal = (ConfluentPrincipal)principal;
            this.assertConfluentPrincipalJson(confluentPrincipal, jsonNode);
            return;
        }
        if (principal != null) {
            this.assertKafkaPrincipalJson(principal, jsonNode);
            return;
        }
        throw new MatchError(null);
    }

    private void assertKafkaPrincipalJson(KafkaPrincipal principal, JsonNode json) {
        Assertions.assertEquals((Object)principal.getClass().getSimpleName(), (Object)json.get(PrincipalConvertToJson$.MODULE$.PrincipalClassKey()).textValue());
        Assertions.assertEquals((Object)principal.getPrincipalType(), (Object)json.get(PrincipalConvertToJson$.MODULE$.PrincipalTypeKey()).textValue());
        Assertions.assertEquals((Object)principal.getName(), (Object)json.get(PrincipalConvertToJson$.MODULE$.PrincipalNameKey()).textValue());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)principal.tokenAuthenticated()), (Object)BoxesRunTime.boxToBoolean((boolean)json.get(PrincipalConvertToJson$.MODULE$.TokenAuthenticatedKey()).booleanValue()));
    }

    private void assertConfluentPrincipalJson(ConfluentPrincipal principal, JsonNode json) {
        this.assertKafkaPrincipalJson((KafkaPrincipal)principal, json);
        Assertions.assertEquals((Object)principal.authenticationId(), (Object)json.get(PrincipalConvertToJson$.MODULE$.AuthenticationIdKey()).textValue());
    }

    private void assertTenantPrincipalJson(MultiTenantPrincipal principal, JsonNode json) {
        this.assertConfluentPrincipalJson((ConfluentPrincipal)principal, json);
        Assertions.assertEquals((Object)principal.user(), (Object)json.get(PrincipalConvertToJson$.MODULE$.UserKey()).textValue());
        Assertions.assertEquals((Object)principal.tenantMetadata().tenantName, (Object)json.get(PrincipalConvertToJson$.MODULE$.TenantNameKey()).textValue());
        Assertions.assertEquals((Object)principal.tenantMetadata().clusterId, (Object)json.get(PrincipalConvertToJson$.MODULE$.ClusterIdKey()).textValue());
        Assertions.assertEquals((Object)principal.tenantMetadata().organizationId, (Object)json.get(PrincipalConvertToJson$.MODULE$.OrganizationIdKey()).textValue());
        Assertions.assertEquals((Object)principal.tenantMetadata().environmentId, (Object)json.get(PrincipalConvertToJson$.MODULE$.EnvironmentIdKey()).textValue());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)principal.tenantMetadata().isServiceAccount), (Object)BoxesRunTime.boxToBoolean((boolean)json.get(PrincipalConvertToJson$.MODULE$.IsServiceAccountKey()).booleanValue()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)principal.tenantMetadata().isApiKeyAuthenticated), (Object)BoxesRunTime.boxToBoolean((boolean)json.get(PrincipalConvertToJson$.MODULE$.IsApiKeyAuthenticatedKey()).booleanValue()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)principal.tenantMetadata().isHealthcheckTenant), (Object)BoxesRunTime.boxToBoolean((boolean)json.get(PrincipalConvertToJson$.MODULE$.IsHealthcheckTenantKey()).booleanValue()));
    }

    public RequestChannel.Request request(AbstractRequest req) {
        ByteBuffer buffer = req.serializeWithHeader(new RequestHeader(req.apiKey(), req.version(), "client-id", 1));
        RequestContext requestContext = this.newRequestContext(buffer);
        return new RequestChannel.Request(1, requestContext, 0L, (MemoryPool)Mockito.mock(MemoryPool.class), buffer, (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class), (Option)None$.MODULE$, NoOpEventEmitter.INSTANCE, (AuditLogProvider)NoOpAuditLogProvider.INSTANCE, RequestLogFilter.MATCH_NONE, 0L);
    }

    private RequestContext newRequestContext(ByteBuffer buffer) {
        return new RequestContext(RequestHeader.parse((ByteBuffer)buffer), "connection-id", InetAddress.getLoopbackAddress(), new KafkaPrincipal("User", "user"), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, new ClientInformation("name", "version"), null, false);
    }

    public static final /* synthetic */ void $anonfun$testAllApiVersionsResponseHandled$1(ApiKeys key) {
        ArrayBuffer unhandledVersions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        key.allVersions().forEach(version -> {
            ByteBuffer bytes = MessageUtil.toByteBuffer((Message)(ApiKeys.DESCRIBE_LOG_DIRS.equals(key) ? ((DescribeLogDirsResponseData)ApiMessageType.fromApiKey((short)key$1.id).newResponse()).setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()) : ApiMessageType.fromApiKey((short)key$1.id).newResponse()), (short)Predef$.MODULE$.Short2short(version));
            AbstractResponse response = AbstractResponse.parseResponse((ApiKeys)key, (ByteBuffer)bytes, (short)Predef$.MODULE$.Short2short(version), (MessageContext)MessageContext.IDENTITY);
            try {
                RequestConvertToJson$.MODULE$.response(response, Predef$.MODULE$.Short2short(version));
                return;
            }
            catch (IllegalStateException illegalStateException) {
                unhandledVersions.$plus$eq(version);
                return;
            }
        });
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), (Object)unhandledVersions, (String)new StringBuilder(34).append("API: ").append(key.toString()).append(" - Unhandled request versions").toString());
    }

    private static final TenantMetadata tenantMetadata$1(String clusterId, String organizationId, String environmentId, boolean serviceAccount, boolean apiKeyAuthenticated, boolean healthcheckTenant) {
        return new TenantMetadata.Builder(clusterId, null).organizationId(organizationId).environmentId(environmentId).serviceAccount(serviceAccount).apiKeyAuthenticated(apiKeyAuthenticated).healthcheckTenant(healthcheckTenant).build();
    }

    private static final String tenantMetadata$default$1$1() {
        return "clusterfoo";
    }

    private static final String tenantMetadata$default$2$1() {
        return "orgfoo";
    }

    private static final String tenantMetadata$default$3$1() {
        return "envfoo";
    }

    private static final boolean tenantMetadata$default$4$1() {
        return false;
    }

    private static final boolean tenantMetadata$default$5$1() {
        return false;
    }

    private static final boolean tenantMetadata$default$6$1() {
        return false;
    }
}

