/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.configmap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import kafka.restore.configmap.ConfigmapUtil;
import kafka.restore.configmap.PartitionConfig;
import kafka.restore.configmap.RestoreTopicListConfig;
import kafka.restore.configmap.TopicConfig;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TopicPartitionConfigMapGeneratorTest {
    private MockAdminClient mockAdminClient;
    private String topic;

    @BeforeEach
    public void setup() {
        this.topic = "testTopic";
        List<Node> brokers = Arrays.asList(new Node(0, "localhost", 9092), new Node(1, "localhost", 9093));
        this.mockAdminClient = new MockAdminClient(brokers, brokers.get(0));
        ArrayList<NewTopic> newTopics = new ArrayList<NewTopic>();
        newTopics.add(new NewTopic(this.topic, 2, 2));
        this.mockAdminClient.createTopics(newTopics);
    }

    @Test
    public void testBuildRestorePartitionConfigWithFromTimestamp() throws ExecutionException, InterruptedException {
        long fromTimestamp = System.currentTimeMillis();
        long revertCompactionSinceTimestamp = System.currentTimeMillis();
        RestoreTopicListConfig restoreTopicListConfig = ConfigmapUtil.buildRestorePartitionConfig((AdminClient)this.mockAdminClient, (long)fromTimestamp, (long)revertCompactionSinceTimestamp, null);
        Assertions.assertEquals((int)1, (int)restoreTopicListConfig.getTopicConfigs().size());
        TopicConfig topic1Config = (TopicConfig)restoreTopicListConfig.getTopicConfigs().get(0);
        Assertions.assertEquals((int)2, (int)topic1Config.getPartitionConfigs().size());
        Assertions.assertEquals((long)fromTimestamp, (long)topic1Config.getFromTimestamp());
        Assertions.assertEquals((long)revertCompactionSinceTimestamp, (long)topic1Config.getRevertCompactionSinceTimestamp());
        PartitionConfig partitionConfig = (PartitionConfig)topic1Config.getPartitionConfigs().get(0);
        Assertions.assertEquals((int)0, (int)partitionConfig.getPartition());
        Assertions.assertEquals((int)9092, (int)partitionConfig.getLeader().getPort());
        Assertions.assertEquals((int)2, (int)partitionConfig.getReplicas().size());
    }

    @Test
    public void testBuildRestorePartitionConfigWithNoFromTimestamp() throws ExecutionException, InterruptedException {
        AdminClient kafkaAdminClient = (AdminClient)Mockito.mock(AdminClient.class);
        HashSet<String> topics = new HashSet<String>();
        topics.add("testTopic1");
        ListTopicsResult listTopicsResult = (ListTopicsResult)Mockito.mock(ListTopicsResult.class);
        KafkaFuture names = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        Mockito.when((Object)listTopicsResult.names()).thenReturn((Object)names);
        Mockito.when((Object)names.get()).thenReturn(topics);
        Mockito.when((Object)kafkaAdminClient.listTopics((ListTopicsOptions)Mockito.any())).thenReturn((Object)listTopicsResult);
        long retentionTimeInMs = 3600000L;
        HashMap<ConfigResource, Config> allConfigs = new HashMap<ConfigResource, Config>();
        ArrayList<ConfigEntry> entries = new ArrayList<ConfigEntry>();
        entries.add(new ConfigEntry("cleanup.policy", "delete"));
        entries.add(new ConfigEntry("retention.ms", String.valueOf(retentionTimeInMs)));
        Config config = new Config(entries);
        allConfigs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.topic), config);
        DescribeConfigsResult describeConfigsResult = (DescribeConfigsResult)Mockito.mock(DescribeConfigsResult.class);
        KafkaFuture configFuture = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        Mockito.when((Object)configFuture.get()).thenReturn(allConfigs);
        Mockito.when((Object)describeConfigsResult.all()).thenReturn((Object)configFuture);
        Mockito.when((Object)kafkaAdminClient.describeConfigs((Collection)Mockito.any())).thenReturn((Object)describeConfigsResult);
        HashMap<String, TopicDescription> topicDescriptions = new HashMap<String, TopicDescription>();
        Uuid topicId = Uuid.randomUuid();
        TopicDescription topicDescription = new TopicDescription(this.topic, false, new ArrayList(), null, topicId);
        topicDescriptions.put(this.topic, topicDescription);
        KafkaFuture describeFuture = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        Mockito.when((Object)describeFuture.get()).thenReturn(topicDescriptions);
        DescribeTopicsResult describeTopicsResult = (DescribeTopicsResult)Mockito.mock(DescribeTopicsResult.class);
        Mockito.when((Object)describeTopicsResult.allTopicNames()).thenReturn((Object)describeFuture);
        Mockito.when((Object)kafkaAdminClient.describeTopics((Collection)Mockito.anySet())).thenReturn((Object)describeTopicsResult);
        long fromTimestamp = 0L;
        RestoreTopicListConfig restoreTopicListConfig = ConfigmapUtil.buildRestorePartitionConfig((AdminClient)kafkaAdminClient, (long)fromTimestamp, (long)Long.MAX_VALUE, null);
        Assertions.assertEquals((int)1, (int)restoreTopicListConfig.getTopicConfigs().size());
        TopicConfig topic1Config = (TopicConfig)restoreTopicListConfig.getTopicConfigs().get(0);
        long estimatedTimestamp = System.currentTimeMillis() - retentionTimeInMs;
        Assertions.assertTrue((estimatedTimestamp >= topic1Config.getFromTimestamp() ? 1 : 0) != 0, (String)("estimated time: " + estimatedTimestamp + " should no less than retention time: " + topic1Config.getFromTimestamp()));
        Assertions.assertTrue((System.currentTimeMillis() - retentionTimeInMs - 1000L < topic1Config.getFromTimestamp() ? 1 : 0) != 0);
        Assertions.assertEquals((Object)topicId.toString(), (Object)topic1Config.getTopicId());
    }
}

