/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.InternalRestServer;
import io.confluent.rest.ResponseContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Optional;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpsDownloadHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(InternalRestServer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final int BUFFER_SIZE = 4096;
    private static final int FTPS_FILE_SIZE_IN_BYTES = 102400;

    private static ResponseContainer.ErrorResponse genericErrorResponse(String message) {
        return new ResponseContainer.ErrorResponse(0, 500, message);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (target.equals("/ftps")) {
            log.debug("Handling download of ftps file");
            this.handleFtpsDownload(request, response);
        }
    }

    private void handleFtpsDownload(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            FtpsDownloadRequest ftpsDownloadRequest = (FtpsDownloadRequest)OBJECT_MAPPER.readValue((InputStream)inputStream, FtpsDownloadRequest.class);
            log.debug(String.format("input request: %s", ftpsDownloadRequest));
            Optional<File> ftpsFile = this.generateTestFtpsFile(ftpsDownloadRequest.topicName, ftpsDownloadRequest.partition, 102400);
            if (!ftpsFile.isPresent()) {
                String errorMessage = String.format("Ftps file not found for partition: %s", ftpsDownloadRequest);
                log.error(errorMessage);
                ResponseContainer.ErrorResponse resp = FtpsDownloadHandler.genericErrorResponse(errorMessage);
                ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
                return;
            }
            response.setContentType("application/octet-stream");
            response.setContentLength((int)ftpsFile.get().length());
            response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", ftpsFile.get().getName()));
            try (FileInputStream in = new FileInputStream(ftpsFile.get());
                 ServletOutputStream out = response.getOutputStream();){
                int numBytesRead;
                byte[] buffer = new byte[4096];
                while ((numBytesRead = ((InputStream)in).read(buffer)) > 0) {
                    out.write(buffer, 0, numBytesRead);
                }
            }
        }
        catch (Exception e) {
            String errorMessage = "Failed to handle ftps file download";
            log.error(errorMessage, (Throwable)e);
            ResponseContainer.ErrorResponse resp = FtpsDownloadHandler.genericErrorResponse(errorMessage);
            ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
        }
    }

    public Optional<File> generateTestFtpsFile(String topic, int partition, int sizeInByte) throws IOException {
        File ftpsFile = new File("/tmp/source/" + topic + "-" + partition + ".tmp");
        if (!ftpsFile.exists()) {
            log.debug("generate a new temp file for downloading");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < sizeInByte; ++i) {
                sb.append("a");
            }
            String inputFtpsContent = sb.toString();
            ftpsFile = File.createTempFile("ftps-temp", null);
            FileOutputStream ftpsOutputStream = new FileOutputStream(ftpsFile.getAbsolutePath());
            byte[] strToBytes = inputFtpsContent.getBytes();
            ftpsOutputStream.write(strToBytes);
            ftpsOutputStream.close();
        }
        return Optional.of(ftpsFile);
    }

    static final class FtpsDownloadRequest {
        @JsonProperty(value="topic_name")
        final String topicName;
        @JsonProperty(value="partition")
        final int partition;

        @JsonCreator
        public FtpsDownloadRequest(@JsonProperty(value="topic_name", required=true) String topicName, @JsonProperty(value="partition", required=true) int partition) {
            this.topicName = topicName;
            this.partition = partition;
        }

        public String toString() {
            return "FtpsDownloadRequest{topic_name=" + this.topicName + ", partition=" + this.partition + '}';
        }
    }
}

