/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.server.ActiveTenantsManager;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005U4Aa\u0004\t\u0001+!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0003BB\u0018\u0001A\u0003%!\u0005C\u00051\u0001\u0001\u0007\t\u0019!C\u0005c!Iq\u0007\u0001a\u0001\u0002\u0004%I\u0001\u000f\u0005\n}\u0001\u0001\r\u0011!Q!\nIB\u0011b\u0010\u0001A\u0002\u0003\u0007I\u0011\u0002!\t\u0013\u0011\u0003\u0001\u0019!a\u0001\n\u0013)\u0005\"C$\u0001\u0001\u0004\u0005\t\u0015)\u0003B\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015)\u0006\u0001\"\u0001J\u0011\u0015Q\u0006\u0001\"\u0001J\u0011\u0015y\u0006\u0001\"\u0001J\u0011\u0015\t\u0007\u0001\"\u0001c\u0005a\t5\r^5wKR+g.\u00198ug6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003#I\taa]3sm\u0016\u0014(\"A\n\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005q\u0002CA\u0010\u0001\u001b\u0005\u0001\u0012\u0001\u0002;j[\u0016,\u0012A\t\t\u0003G5j\u0011\u0001\n\u0006\u0003K\u0019\nQ!\u001e;jYNT!a\n\u0015\u0002\r\r|W.\\8o\u0015\t\u0019\u0012F\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018%\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013aB7fiJL7m]\u000b\u0002eA\u00111'N\u0007\u0002i)\u0011\u0001GJ\u0005\u0003mQ\u0012q!T3ue&\u001c7/A\u0006nKR\u0014\u0018nY:`I\u0015\fHCA\u001d=!\t9\"(\u0003\u0002<1\t!QK\\5u\u0011\u001diT!!AA\u0002I\n1\u0001\u001f\u00132\u0003!iW\r\u001e:jGN\u0004\u0013\u0001F1di&4X\rV3oC:$8/T1oC\u001e,'/F\u0001B!\ty\")\u0003\u0002D!\t!\u0012i\u0019;jm\u0016$VM\\1oiNl\u0015M\\1hKJ\f\u0001$Y2uSZ,G+\u001a8b]R\u001cX*\u00198bO\u0016\u0014x\fJ3r)\tId\tC\u0004>\u0011\u0005\u0005\t\u0019A!\u0002+\u0005\u001cG/\u001b<f)\u0016t\u0017M\u001c;t\u001b\u0006t\u0017mZ3sA\u0005a!-\u001a4pe\u0016lU\r\u001e5pIR\t\u0011\b\u000b\u0002\u000b\u0017B\u0011AjU\u0007\u0002\u001b*\u0011ajT\u0001\u0004CBL'B\u0001)R\u0003\u001dQW\u000f]5uKJT!AU\u0016\u0002\u000b),h.\u001b;\n\u0005Qk%A\u0003\"fM>\u0014X-R1dQ\u0006Y\u0011M\u001a;fe6+G\u000f[8eQ\tYq\u000b\u0005\u0002M1&\u0011\u0011,\u0014\u0002\n\u0003\u001a$XM]#bG\"\f\u0011\u0006^3ti\u001e+G/Q2uSZ,G+\u001a8b]R\u001c\bK];oKNLe.Y2uSZ,G+\u001a8b]R\u001c\bF\u0001\u0007]!\taU,\u0003\u0002_\u001b\n!A+Z:u\u0003u!Xm\u001d;SK\u000e|'\u000fZ!di&4X\rV3oC:$8/T3ue&\u001c\u0007FA\u0007]\u0003)iW\r\u001e:jGR\u000bwm\u001d\u000b\u0004GF\u001c\b\u0003\u00023l]:t!!Z5\u0011\u0005\u0019DR\"A4\u000b\u0005!$\u0012A\u0002\u001fs_>$h(\u0003\u0002k1\u00051\u0001K]3eK\u001aL!\u0001\\7\u0003\u00075\u000b\u0007O\u0003\u0002k1A\u0011Am\\\u0005\u0003a6\u0014aa\u0015;sS:<\u0007\"\u0002:\u000f\u0001\u0004q\u0017\u0001B;tKJDQ\u0001\u001e\bA\u00029\f\u0001b\u00197jK:$\u0018\n\u001a")
public class ActiveTenantsManagerTest {
    private final MockTime time = new MockTime();
    private Metrics metrics;
    private ActiveTenantsManager activeTenantsManager;

    private MockTime time() {
        return this.time;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private ActiveTenantsManager activeTenantsManager() {
        return this.activeTenantsManager;
    }

    private void activeTenantsManager_$eq(ActiveTenantsManager x$1) {
        this.activeTenantsManager = x$1;
    }

    @BeforeEach
    public void beforeMethod() {
        this.metrics_$eq(new Metrics());
        this.activeTenantsManager_$eq(new ActiveTenantsManager(this.metrics(), (Time)this.time(), 2L));
    }

    @AfterEach
    public void afterMethod() {
        this.metrics().close();
    }

    @Test
    public void testGetActiveTenantsPrunesInactiveTenants() {
        Set activeTenants = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        Map<String, String> metricTags1 = this.metricTags("", "Client1");
        Map<String, String> metricTags2 = this.metricTags("", "Client2");
        this.activeTenantsManager().trackActiveTenant(metricTags1, this.time().milliseconds());
        activeTenants.$plus$eq(metricTags1);
        Assertions.assertEquals((Object)activeTenants, (Object)this.activeTenantsManager().getActiveTenants().toSet());
        this.time().sleep(1L);
        this.activeTenantsManager().trackActiveTenant(metricTags2, this.time().milliseconds());
        activeTenants.$plus$eq(metricTags2);
        Assertions.assertEquals((Object)activeTenants, (Object)this.activeTenantsManager().getActiveTenants().toSet());
        this.time().sleep(1L);
        this.activeTenantsManager().trackActiveTenant(metricTags1, this.time().milliseconds());
        activeTenants.$plus$eq(metricTags1);
        Assertions.assertEquals((Object)activeTenants, (Object)this.activeTenantsManager().getActiveTenants().toSet());
        this.time().sleep(2L);
        activeTenants.$minus$eq(metricTags2);
        Assertions.assertEquals((Object)activeTenants, (Object)this.activeTenantsManager().getActiveTenants().toSet());
        this.time().sleep(3L);
        activeTenants.$minus$eq(metricTags1);
        activeTenants.$minus$eq(metricTags2);
        Assertions.assertEquals((Object)activeTenants, (Object)this.activeTenantsManager().getActiveTenants().toSet());
    }

    @Test
    public void testRecordActiveTenantsMetric() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        String mBeanName = "kafka.server:type=multi-tenant-metrics";
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.server");
        reporter.contextChange((MetricsContext)metricsContext);
        this.metrics().addReporter((MetricsReporter)reporter);
        Map<String, String> metricTags1 = this.metricTags("", "Client1");
        Map<String, String> metricTags2 = this.metricTags("", "Client2");
        Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(mBeanName)));
        Assertions.assertEquals((double)0.0, (double)ActiveTenantsManagerTest.numActiveTenants$1(server, mBeanName), (double)0.0);
        Assertions.assertTrue((boolean)reporter.containsMbean(mBeanName));
        this.time().sleep(1L);
        this.activeTenantsManager().trackActiveTenant(metricTags1, this.time().milliseconds());
        Assertions.assertEquals((double)0.0, (double)ActiveTenantsManagerTest.numActiveTenants$1(server, mBeanName), (double)0.0);
        this.time().sleep(3L);
        this.activeTenantsManager().trackActiveTenant(metricTags2, this.time().milliseconds());
        Assertions.assertEquals((double)1.0, (double)ActiveTenantsManagerTest.numActiveTenants$1(server, mBeanName), (double)0.0);
    }

    public Map<String, String> metricTags(String user, String clientId) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)user), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)clientId)}));
    }

    private static final double numActiveTenants$1(MBeanServer server$1, String mBeanName$1) {
        return BoxesRunTime.unboxToDouble((Object)server$1.getAttribute(new ObjectName(mBeanName$1), "active-tenants-count"));
    }
}

