/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.api.IntegrationTestHarness;
import kafka.server.BaseRequestTest;
import kafka.server.link.ClusterLinkTopicState;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateClusterLinksOptions;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AlterMirrorsRequestData;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterMirrorsRequest;
import org.apache.kafka.common.requests.AlterMirrorsResponse;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExtendWith(value={ClusterTestExtensions.class})
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\tEe\u0001B\u0013'\u0001-BQ\u0001\r\u0001\u0005\u0002EB\u0011b\r\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001b\t\u000b\u0001\u0003A\u0011I!\t\u000b!\u0003A\u0011I%\t\u000f]\u0003!\u0019!C\u00051\"1q\f\u0001Q\u0001\neCQ\u0001\u0019\u0001\u0005B\u0005DQ\u0001\u001b\u0001\u0005\u0002%DQa\u001c\u0001\u0005\u0002ADa!a\u0002\u0001\t\u0003\u0001\bBBA\u0006\u0001\u0011\u0005\u0001\u000f\u0003\u0004\u0002\u0010\u0001!\t\u0001\u001d\u0005\u0007\u0003'\u0001A\u0011\u00019\t\r\u0005]\u0001\u0001\"\u0001q\u0011\u0019\t\t\u0003\u0001C\u0001a\"1\u0011Q\u0005\u0001\u0005\u0002ADa!!\u000b\u0001\t\u0003\u0001\bBBA\u0017\u0001\u0011\u0005\u0001\u000f\u0003\u0004\u00022\u0001!\t\u0001\u001d\u0005\b\u0003k\u0001A\u0011BA\u001c\u0011\u001d\ti\u0007\u0001C\u0005\u0003_B\u0011\"a!\u0001#\u0003%I!!\"\t\u0013\u0005e\u0005!%A\u0005\n\u0005\u0015\u0005bBAN\u0001\u0011%\u0011Q\u0014\u0005\b\u0003W\u0003A\u0011BAW\u0011\u001d\t\t\f\u0001C\u0005\u0003gCq!a/\u0001\t\u0013\ti\fC\u0004\u0002b\u0002!I!a9\t\u0013\te\u0001!%A\u0005\n\tm\u0001\"\u0003B\u0010\u0001E\u0005I\u0011\u0002B\u0011\u0011\u001d\u0011)\u0003\u0001C\u0005\u0005OAqAa\u000f\u0001\t\u0013\u0011i\u0004C\u0004\u0003P\u0001!IA!\u0015\t\u000f\tU\u0003\u0001\"\u0003\u0003X!9!1\f\u0001\u0005\n\tu\u0003b\u0002B1\u0001\u0011%!1\r\u0002\u0018\u00032$XM]'jeJ|'o\u001d*fcV,7\u000f\u001e+fgRT!a\n\u0015\u0002\rM,'O^3s\u0015\u0005I\u0013!B6bM.\f7\u0001A\n\u0003\u00011\u0002\"!\f\u0018\u000e\u0003\u0019J!a\f\u0014\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#\u0001\u001a\u0011\u00055\u0002\u0011!C0uKN$\u0018J\u001c4p!\t)d(D\u00017\u0015\t9\u0004(A\u0002ba&T!!\u000f\u001e\u0002\u000f),\b/\u001b;fe*\u00111\bP\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002{\u0005\u0019qN]4\n\u0005}2$\u0001\u0003+fgRLeNZ8\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\n\u0019\u0011J\u001c;\u0002/\t\u0014xn[3s!J|\u0007/\u001a:us>3XM\u001d:jI\u0016\u001cHC\u0001&N!\t\u00195*\u0003\u0002M\t\n!QK\\5u\u0011\u0015qE\u00011\u0001P\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0003!Vk\u0011!\u0015\u0006\u0003%N\u000bA!\u001e;jY*\tA+\u0001\u0003kCZ\f\u0017B\u0001,R\u0005)\u0001&o\u001c9feRLWm]\u0001\tY&t7NT1nKV\t\u0011\f\u0005\u0002[;6\t1L\u0003\u0002]'\u0006!A.\u00198h\u0013\tq6L\u0001\u0004TiJLgnZ\u0001\nY&t7NT1nK\u0002\nQa]3u+B$\"A\u00132\t\u000b\r<\u0001\u0019\u0001\u001b\u0002\u0011Q,7\u000f^%oM>D#aB3\u0011\u0005U2\u0017BA47\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]R\u0011!J\u001b\u0005\u0006G\"\u0001\r\u0001\u000e\u0015\u0003\u00111\u0004\"!N7\n\u000594$!C!gi\u0016\u0014X)Y2i\u0003U!Xm\u001d;BYR,'/T5se>\u00148/R7qif$\u0012A\u0013\u0015\r\u0013IT80!\u0001\u0002\u0004\u0005\u0015\u00111\u0001\t\u0003gbl\u0011\u0001\u001e\u0006\u0003kZ\f!\"\u00198o_R\fG/[8o\u0015\t9\b&\u0001\u0003uKN$\u0018BA=u\u0005-\u0019E.^:uKJ$Vm\u001d;\u0002\u0017\rdWo\u001d;feRK\b/\u001a\u0013\u0002y&\u0011QP`\u0001\u0013\u00032cuLT(O?\u000e{%+R*J\t\u0016sEK\u0003\u0002\u0000i\u0006!A+\u001f9f\u0003\u001d\u0011'o\\6feNl\u0012!A\u0001\fG>tGO]8mY\u0016\u00148/A\u000buKN$\u0018\t\u001c;fe6K'O]8sg\n\u000bGm\u00149)\u0019)\u0011(p_A\u0001\u0003\u0007\t)!a\u0001\u0002'Q,7\u000f^*u_Bl\u0015N\u001d:peR{\u0007/[2)\u0019-\u0011(p_A\u0001\u0003\u0007\t)!a\u0001\u0002?Q,7\u000f^*u_Bl\u0015N\u001d:peR{\u0007/[2J]Z\fG.\u001b3U_BL7\r\u000b\u0007\rej\\\u0018\u0011AA\u0002\u0003\u000b\t\u0019!A\u0012uKN$8\u000b^8q\u001b&\u0014(o\u001c:U_BL7MT8oKbL7\u000f^3oiR{\u0007/[2)\u00195\u0011(p_A\u0001\u0003\u0007\t)!a\u0001\u0002)Q,7\u000f^\"mK\u0006\u0014X*\u001b:s_J$v\u000e]5dQ%q!O_A\u000e\u0003\u0003\t\u0019\u0001\n\u0002\u0002\u001e%\u0019\u0011q\u0004@\u0002\u0005i[\u0015\u0001\t;fgR\u001cE.Z1s\u001b&\u0014(o\u001c:U_BL7-\u00138wC2LG\rV8qS\u000eD\u0013b\u0004:{\u00037\t\t!a\u0001\u0002IQ,7\u000f^\"mK\u0006\u0014X*\u001b:s_J$v\u000e]5d\u001d>tW\r_5ti\u0016tG\u000fV8qS\u000eD\u0013\u0002\u0005:{\u00037\t\t!a\u0001\u0002)Q,7\u000f\u001e)bkN,W*\u001b:s_J$v\u000e]5dQ1\t\"O_>\u0002\u0002\u0005\r\u0011QAA\u0002\u0003\u0001\"Xm\u001d;QCV\u001cX-T5se>\u0014Hk\u001c9jG&sg/\u00197jIR{\u0007/[2)\u0019I\u0011(p_A\u0001\u0003\u0007\t)!a\u0001\u0002IQ,7\u000f\u001e)bkN,W*\u001b:s_J$v\u000e]5d\u001d>tW\r_5ti\u0016tG\u000fV8qS\u000eDCb\u0005:{w\u0006\u0005\u00111AA\u0003\u0003\u0007\tQc\u0019:fCR,7\t\\;ti\u0016\u0014H*\u001b8l/&$\b\u000eF\u0004K\u0003s\t\u0019&!\u001b\t\u000f\u0005mB\u00031\u0001\u0002>\u0005Y\u0011\rZ7j]\u000ec\u0017.\u001a8u!\u0011\ty$a\u0014\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\nQ!\u00193nS:TA!a\u0012\u0002J\u000591\r\\5f]R\u001c(bA\u0015\u0002L)\u0019\u0011Q\n\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t\t&!\u0011\u0003\u000b\u0005#W.\u001b8\t\r]#\u0002\u0019AA+!\u0011\t9&!\u001a\u000f\t\u0005e\u0013\u0011\r\t\u0004\u00037\"UBAA/\u0015\r\tyFK\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\rD)\u0001\u0004Qe\u0016$WMZ\u0005\u0004=\u0006\u001d$bAA2\t\"9\u00111\u000e\u000bA\u0002\u0005U\u0013\u0001\u00052p_R\u001cHO]1q'\u0016\u0014h/\u001a:t\u0003=\u0019'/Z1uKR{\u0007/[2XSRDG#\u0003&\u0002r\u0005M\u0014qOA@\u0011\u001d\tY$\u0006a\u0001\u0003{Aq!!\u001e\u0016\u0001\u0004\t)&A\u0003u_BL7\r\u0003\u0005X+A\u0005\t\u0019AA=!\u0015\u0019\u00151PA+\u0013\r\ti\b\u0012\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005\u0005U\u0003%AA\u0002\u0005e\u0014aC7jeJ|'\u000fV8qS\u000e\f\u0011d\u0019:fCR,Gk\u001c9jG^KG\u000f\u001b\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0011\u0016\u0005\u0003s\nIi\u000b\u0002\u0002\fB!\u0011QRAK\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006M\u0015!C;oG\",7m[3e\u0015\t)H)\u0003\u0003\u0002\u0018\u0006=%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006I2M]3bi\u0016$v\u000e]5d/&$\b\u000e\n3fM\u0006,H\u000e\u001e\u00135\u0003=\u0019Ho\u001c9NSJ\u0014xN\u001d+pa&\u001cG#\u0002&\u0002 \u0006\u0005\u0006bBA;1\u0001\u0007\u0011Q\u000b\u0005\b\u0003GC\u0002\u0019AAS\u0003-\u0019\u0018P\\2ie>t\u0017N_3\u0011\u0007\r\u000b9+C\u0002\u0002*\u0012\u0013qAQ8pY\u0016\fg.\u0001\tdY\u0016\f'/T5se>\u0014Hk\u001c9jGR\u0019!*a,\t\u000f\u0005U\u0014\u00041\u0001\u0002V\u0005\u0001\u0002/Y;tK6K'O]8s)>\u0004\u0018n\u0019\u000b\u0006\u0015\u0006U\u0016q\u0017\u0005\b\u0003kR\u0002\u0019AA+\u0011\u001d\tIL\u0007a\u0001\u0003K\u000ba!\u001a8bE2,\u0017aC1mi\u0016\u0014X*\u001b:s_J$b!a0\u0002V\u0006]\u0007CBAa\u0003\u0017\fy-\u0004\u0002\u0002D*!\u0011QYAd\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0003\u0002J\u0006%\u0013AB2p[6|g.\u0003\u0003\u0002N\u0006\r'aD&bM.\fg)\u001e;ve\u0016LU\u000e\u001d7\u0011\u0007i\u000b\t.C\u0002\u0002Tn\u0013AAV8jI\"9\u0011QO\u000eA\u0002\u0005U\u0003bBAm7\u0001\u0007\u00111\\\u0001\u0003_B\u0004B!a\u0010\u0002^&!\u0011q\\A!\u00055\tE\u000e^3s\u001b&\u0014(o\u001c:Pa\u0006a\u0011\r\u001c;fe6K'O]8sgRA\u0011Q]A|\u0005#\u0011)\u0002\u0005\u0004\u0002h\u0006E\u0018q\u0018\b\u0005\u0003S\fiO\u0004\u0003\u0002\\\u0005-\u0018\"A#\n\u0007\u0005=H)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0018Q\u001f\u0002\u0005\u0019&\u001cHOC\u0002\u0002p\u0012Cq!!?\u001d\u0001\u0004\tY0A\u0002paN\u0004b!a:\u0002r\u0006u\b\u0003BA\u0000\u0005\u0017qAA!\u0001\u0003\b5\u0011!1\u0001\u0006\u0005\u0005\u000b\t9-A\u0004nKN\u001c\u0018mZ3\n\t\t%!1A\u0001\u0018\u00032$XM]'jeJ|'o\u001d*fcV,7\u000f\u001e#bi\u0006LAA!\u0004\u0003\u0010\tyQ*\u001b:s_J|\u0005/\u001a:bi&|gN\u0003\u0003\u0003\n\t\r\u0001\"\u0003B\n9A\u0005\t\u0019AAS\u000311\u0018\r\\5eCR,wJ\u001c7z\u0011!\u00119\u0002\bI\u0001\u0002\u0004\u0011\u0015!\u0003;j[\u0016|W\u000f^'t\u0003Y\tG\u000e^3s\u001b&\u0014(o\u001c:tI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u000fU\u0011\t)+!#\u0002-\u0005dG/\u001a:NSJ\u0014xN]:%I\u00164\u0017-\u001e7uIM*\"Aa\t+\u0007\t\u000bI)A\ftK:$\u0017\t\u001c;fe6K'O]8sgJ+\u0017/^3tiRA!\u0011\u0006B\u001b\u0005o\u0011I\u0004\u0005\u0003\u0003,\tERB\u0001B\u0017\u0015\u0011\u0011y#a2\u0002\u0011I,\u0017/^3tiNLAAa\r\u0003.\t!\u0012\t\u001c;fe6K'O]8sgJ+7\u000f]8og\u0016Dq!!? \u0001\u0004\tY\u0010C\u0004\u0003\u0014}\u0001\r!!*\t\r\t]q\u00041\u0001C\u0003Y9W\r^\"mkN$XM\u001d'j].4uN\u001d+pa&\u001cG\u0003\u0002B \u0005\u001b\u0002RaQA>\u0005\u0003\u0002BAa\u0011\u0003J5\u0011!Q\t\u0006\u0004\u0005\u000f2\u0013\u0001\u00027j].LAAa\u0013\u0003F\t)2\t\\;ti\u0016\u0014H*\u001b8l)>\u0004\u0018nY*uCR,\u0007bBA;A\u0001\u0007\u0011QK\u0001\u0014i>\u0004\u0018nY%t\u0003\u000e$\u0018N^3NSJ\u0014xN\u001d\u000b\u0005\u0003K\u0013\u0019\u0006C\u0004\u0002v\u0005\u0002\r!!\u0016\u0002'Q|\u0007/[2JgB\u000bWo]3e\u001b&\u0014(o\u001c:\u0015\t\u0005\u0015&\u0011\f\u0005\b\u0003k\u0012\u0003\u0019AA+\u0003m!x\u000e]5d\u0013N\u0004VM\u001c3j]\u001e\u001cFo\u001c9qK\u0012l\u0015N\u001d:peR!\u0011Q\u0015B0\u0011\u001d\t)h\ta\u0001\u0003+\nA\u0003^8qS\u000eL5o\u0015;paB,G-T5se>\u0014H\u0003BAS\u0005KBq!!\u001e%\u0001\u0004\t)\u0006K\u0004\u0001\u0005S\u0012yG!\u001d\u0011\u0007U\u0012Y'C\u0002\u0003nY\u00121\u0001V1h\u0003\u00151\u0018\r\\;fC\t\u0011\u0019(A\u0006j]R,wM]1uS>t\u0007f\u0002\u0001\u0003x\t=$1\u0011\t\u0005\u0005s\u0012y(\u0004\u0002\u0003|)\u0019!Q\u0010\u001c\u0002\u0013\u0015DH/\u001a8tS>t\u0017\u0002\u0002BA\u0005w\u0012!\"\u0012=uK:$w+\u001b;iY\t\u0011)i\t\u0002\u0003\bB!!\u0011\u0012BG\u001b\t\u0011YI\u0003\u0002<m&!!q\u0012BF\u0005U\u0019E.^:uKJ$Vm\u001d;FqR,gn]5p]N\u0004")
public class AlterMirrorsRequestTest
extends BaseRequestTest {
    private TestInfo _testInfo;
    private final String linkName;

    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put("confluent.cluster.link.metadata.topic.replication.factor", "1");
    }

    private String linkName() {
        return this.linkName;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo = testInfo;
        super.setUp(testInfo);
    }

    @AfterEach
    public void tearDown(TestInfo testInfo) {
        super.tearDown();
        TestUtils$.MODULE$.verifyNoUnexpectedThreads(this.getClass().getName());
    }

    @ClusterTest(clusterType=Type.ALL_NON_CORESIDENT, brokers=1, controllers=1)
    public void testAlterMirrorsEmpty() {
        Assertions.assertTrue((boolean)this.alterMirrors((List<AlterMirrorsRequestData.MirrorOperation>)package$.MODULE$.List().empty(), false, 5000).isEmpty());
    }

    @ClusterTest(clusterType=Type.ALL_NON_CORESIDENT, brokers=1, controllers=1)
    public void testAlterMirrorsBadOp() {
        AlterMirrorsRequestData.MirrorOperation badOp = new AlterMirrorsRequestData.MirrorOperation().setTopic("topic").setOperationCode((byte)127);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((Future)this.alterMirrors((List<AlterMirrorsRequestData.MirrorOperation>)new .colon.colon((Object)badOp, (List)Nil$.MODULE$), false, 5000).head(), InvalidRequestException.class, (Option<String>)None$.MODULE$);
    }

    @ClusterTest(clusterType=Type.ALL_NON_CORESIDENT, brokers=1, controllers=1)
    public void testStopMirrorTopic() {
        .colon.colon topics = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test-topic-no-sync"), (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test-topic-sync"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$));
        ConfluentAdmin localAdmin = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());
        TestInfo runWithRemoteCluster_testInfo = this._testInfo;
        IntegrationTestHarness runWithRemoteCluster_remoteCluster = new IntegrationTestHarness(){

            public int brokerCount() {
                return 1;
            }
        };
        runWithRemoteCluster_remoteCluster.setUp(runWithRemoteCluster_testInfo);
        try {
            AlterMirrorsRequestTest.$anonfun$testStopMirrorTopic$1(this, localAdmin, (Seq)topics, runWithRemoteCluster_remoteCluster);
        }
        finally {
            runWithRemoteCluster_remoteCluster.tearDown();
        }
    }

    @ClusterTest(clusterType=Type.ALL_NON_CORESIDENT, brokers=1, controllers=1)
    public void testStopMirrorTopicInvalidTopic() {
        Assertions.assertThrows(InvalidTopicException.class, () -> this.stopMirrorTopic("topic!", false));
    }

    @ClusterTest(clusterType=Type.ALL_NON_CORESIDENT, brokers=1, controllers=1)
    public void testStopMirrorTopicNonexistentTopic() {
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.stopMirrorTopic("unknown-topic", false));
    }

    @ClusterTest(clusterType=Type.ZK, brokers=1)
    public void testClearMirrorTopic() {
        String activeTopic = "active-topic";
        String stoppedTopic = "stopped-topic";
        try (ConfluentAdmin localAdmin = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());){
            TestInfo runWithRemoteCluster_testInfo = this._testInfo;
            IntegrationTestHarness runWithRemoteCluster_remoteCluster = new /* invalid duplicate definition of identical inner class */;
            runWithRemoteCluster_remoteCluster.setUp(runWithRemoteCluster_testInfo);
            try {
                AlterMirrorsRequestTest.$anonfun$testClearMirrorTopic$1(this, localAdmin, activeTopic, stoppedTopic, runWithRemoteCluster_remoteCluster);
            }
            finally {
                runWithRemoteCluster_remoteCluster.tearDown();
            }
            Object var5_4 = null;
            Object var6_5 = null;
        }
    }

    @ClusterTest(clusterType=Type.ZK, brokers=1)
    public void testClearMirrorTopicInvalidTopic() {
        Assertions.assertThrows(InvalidTopicException.class, () -> this.clearMirrorTopic("topic!"));
    }

    @ClusterTest(clusterType=Type.ZK, brokers=1)
    public void testClearMirrorTopicNonexistentTopic() {
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.clearMirrorTopic("unknown-topic"));
    }

    @ClusterTest(clusterType=Type.ALL_NON_CORESIDENT, brokers=1, controllers=1)
    public void testPauseMirrorTopic() {
        String topic = "topic";
        try (ConfluentAdmin localAdmin = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());){
            TestInfo runWithRemoteCluster_testInfo = this._testInfo;
            IntegrationTestHarness runWithRemoteCluster_remoteCluster = new /* invalid duplicate definition of identical inner class */;
            runWithRemoteCluster_remoteCluster.setUp(runWithRemoteCluster_testInfo);
            try {
                AlterMirrorsRequestTest.$anonfun$testPauseMirrorTopic$1(this, localAdmin, topic, runWithRemoteCluster_remoteCluster);
            }
            finally {
                runWithRemoteCluster_remoteCluster.tearDown();
            }
            Object var4_3 = null;
            Object var5_4 = null;
        }
    }

    @ClusterTest(clusterType=Type.ALL_NON_CORESIDENT, brokers=1, controllers=1)
    public void testPauseMirrorTopicInvalidTopic() {
        Assertions.assertThrows(InvalidTopicException.class, () -> this.pauseMirrorTopic("topic!", true));
        Assertions.assertThrows(InvalidTopicException.class, () -> this.pauseMirrorTopic("topic!", false));
    }

    @ClusterTest(clusterType=Type.ALL_NON_CORESIDENT, brokers=1, controllers=1)
    public void testPauseMirrorTopicNonexistentTopic() {
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.pauseMirrorTopic("unknown-topic", true));
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.pauseMirrorTopic("unknown-topic", false));
    }

    private void createClusterLinkWith(Admin adminClient, String linkName, String bootstrapServers) {
        ConfluentAdmin admin = (ConfluentAdmin)adminClient;
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)bootstrapServers)}));
        NewClusterLink newClusterLink = new NewClusterLink(linkName, null, CollectionConverters$.MODULE$.MapHasAsJava((Map)configs).asJava());
        admin.createClusterLinks(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)newClusterLink, (List)Nil$.MODULE$)).asJavaCollection(), (CreateClusterLinksOptions)new CreateClusterLinksOptions().timeoutMs(Predef$.MODULE$.int2Integer(1000))).all().get();
    }

    private void createTopicWith(Admin adminClient, String topic, Option<String> linkName, Option<String> mirrorTopic) {
        ConfluentAdmin admin = (ConfluentAdmin)adminClient;
        NewTopic newTopic = new NewTopic(topic, Optional.empty(), Optional.of(BoxesRunTime.boxToShort((short)1)));
        linkName.foreach((Function1 & Serializable)ln -> newTopic.mirror(Optional.of(new NewMirrorTopic(ln, (String)mirrorTopic.get()))));
        admin.createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJavaCollection(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(1000))).all().get();
    }

    private Option<String> createTopicWith$default$3() {
        return None$.MODULE$;
    }

    private Option<String> createTopicWith$default$4() {
        return None$.MODULE$;
    }

    private void stopMirrorTopic(String topic, boolean synchronize) {
        try {
            AlterMirrorOp stopOp = synchronize ? AlterMirrorOp.PROMOTE : AlterMirrorOp.FAILOVER;
            this.alterMirror(topic, stopOp).get();
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private void clearMirrorTopic(String topic) {
        try {
            this.alterMirror(topic, AlterMirrorOp.CLEAR).get();
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private void pauseMirrorTopic(String topic, boolean enable) {
        try {
            AlterMirrorOp pauseOp = enable ? AlterMirrorOp.PAUSE : AlterMirrorOp.RESUME;
            this.alterMirror(topic, pauseOp).get();
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private KafkaFutureImpl<Void> alterMirror(String topic, AlterMirrorOp op) {
        AlterMirrorsRequestData.MirrorOperation mirrorOp = new AlterMirrorsRequestData.MirrorOperation().setTopic(topic).setOperationCode(op.id());
        return (KafkaFutureImpl)this.alterMirrors((List<AlterMirrorsRequestData.MirrorOperation>)new .colon.colon((Object)mirrorOp, (List)Nil$.MODULE$), false, 5000).head();
    }

    private List<KafkaFutureImpl<Void>> alterMirrors(List<AlterMirrorsRequestData.MirrorOperation> ops, boolean validateOnly, int timeoutMs) {
        LinkedHashMap results = new LinkedHashMap();
        ops.foreach((Function1 & Serializable)op -> results.put(op.topic(), new KafkaFutureImpl()));
        this.sendAlterMirrorsRequest(ops, validateOnly, timeoutMs).complete(results);
        Assertions.assertEquals((int)ops.size(), (int)results.size());
        return CollectionConverters$.MODULE$.CollectionHasAsScala(results.values()).asScala().toList();
    }

    private boolean alterMirrors$default$2() {
        return false;
    }

    private int alterMirrors$default$3() {
        return 5000;
    }

    private AlterMirrorsResponse sendAlterMirrorsRequest(List<AlterMirrorsRequestData.MirrorOperation> ops, boolean validateOnly, int timeoutMs) {
        AlterMirrorsRequest request = (AlterMirrorsRequest)new AlterMirrorsRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava(ops).asJava(), validateOnly, timeoutMs).build();
        return (AlterMirrorsResponse)this.connectAndReceive((AbstractRequest)request, this.controllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterMirrorsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private Option<ClusterLinkTopicState> getClusterLinkForTopic(String topic) {
        return this.zkClient().getClusterLinkForTopics((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get((Object)topic);
    }

    private boolean topicIsActiveMirror(String topic) {
        return this.getClusterLinkForTopic(topic).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AlterMirrorsRequestTest.$anonfun$topicIsActiveMirror$1(x$2)));
    }

    private boolean topicIsPausedMirror(String topic) {
        return this.getClusterLinkForTopic(topic).exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AlterMirrorsRequestTest.$anonfun$topicIsPausedMirror$1(x$3)));
    }

    private boolean topicIsPendingStoppedMirror(String topic) {
        return this.getClusterLinkForTopic(topic).exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AlterMirrorsRequestTest.$anonfun$topicIsPendingStoppedMirror$1(x$4)));
    }

    private boolean topicIsStoppedMirror(String topic) {
        return this.getClusterLinkForTopic(topic).exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AlterMirrorsRequestTest.$anonfun$topicIsStoppedMirror$1(x$5)));
    }

    public static final /* synthetic */ void $anonfun$testStopMirrorTopic$1(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$1, Seq topics$1, IntegrationTestHarness remoteCluster) {
        ConfluentAdmin remoteAdmin = remoteCluster.createConfluentAdminClient(remoteCluster.createConfluentAdminClient$default$1());
        $this.createClusterLinkWith((Admin)localAdmin$1, $this.linkName(), remoteCluster.bootstrapServers(remoteCluster.bootstrapServers$default$1()));
        topics$1.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                boolean synchronize = x0$1._2$mcZ$sp();
                $this.createTopicWith((Admin)remoteAdmin, topic, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
                $this.createTopicWith((Admin)localAdmin$1, topic, (Option<String>)new Some((Object)$this.linkName()), (Option<String>)new Some((Object)topic));
                $this.stopMirrorTopic(topic, synchronize);
                return (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> $this.stopMirrorTopic(topic, synchronize));
            }
            throw new MatchError(null);
        });
    }

    private final boolean hasClusterLink$1(String topic) {
        return this.getClusterLinkForTopic(topic).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$testClearMirrorTopic$1(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$2, String activeTopic$1, String stoppedTopic$1, IntegrationTestHarness remoteCluster) {
        try (ConfluentAdmin remoteAdmin = remoteCluster.createConfluentAdminClient(remoteCluster.createConfluentAdminClient$default$1());){
            $this.createClusterLinkWith((Admin)localAdmin$2, $this.linkName(), remoteCluster.bootstrapServers(remoteCluster.bootstrapServers$default$1()));
            $this.createTopicWith((Admin)remoteAdmin, activeTopic$1, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
            $this.createTopicWith((Admin)localAdmin$2, activeTopic$1, (Option<String>)new Some((Object)$this.linkName()), (Option<String>)new Some((Object)activeTopic$1));
            Assertions.assertTrue((boolean)$this.topicIsActiveMirror(activeTopic$1));
            $this.clearMirrorTopic(activeTopic$1);
            Assertions.assertFalse((boolean)$this.hasClusterLink$1(activeTopic$1));
            $this.clearMirrorTopic(activeTopic$1);
            Assertions.assertFalse((boolean)$this.hasClusterLink$1(activeTopic$1));
            $this.createTopicWith((Admin)remoteAdmin, stoppedTopic$1, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
            $this.createTopicWith((Admin)localAdmin$2, stoppedTopic$1, (Option<String>)new Some((Object)$this.linkName()), (Option<String>)new Some((Object)stoppedTopic$1));
            Assertions.assertTrue((boolean)$this.topicIsActiveMirror(stoppedTopic$1));
            $this.stopMirrorTopic(stoppedTopic$1, false);
            Assertions.assertTrue(($this.topicIsPendingStoppedMirror(stoppedTopic$1) || $this.topicIsStoppedMirror(stoppedTopic$1) ? 1 : 0) != 0, (String)new StringBuilder(23).append("Unexpected topic state ").append($this.getClusterLinkForTopic(stoppedTopic$1)).toString());
            $this.clearMirrorTopic(stoppedTopic$1);
            Assertions.assertFalse((boolean)$this.hasClusterLink$1(stoppedTopic$1));
        }
    }

    public static final /* synthetic */ void $anonfun$testPauseMirrorTopic$1(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$3, String topic$2, IntegrationTestHarness remoteCluster) {
        try (ConfluentAdmin remoteAdmin = remoteCluster.createConfluentAdminClient(remoteCluster.createConfluentAdminClient$default$1());){
            $this.createClusterLinkWith((Admin)localAdmin$3, $this.linkName(), remoteCluster.bootstrapServers(remoteCluster.bootstrapServers$default$1()));
            $this.createTopicWith((Admin)remoteAdmin, topic$2, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
            $this.createTopicWith((Admin)localAdmin$3, topic$2, (Option<String>)new Some((Object)$this.linkName()), (Option<String>)new Some((Object)topic$2));
            Assertions.assertTrue((boolean)$this.topicIsActiveMirror(topic$2));
            $this.pauseMirrorTopic(topic$2, true);
            Assertions.assertTrue((boolean)$this.topicIsPausedMirror(topic$2));
            $this.pauseMirrorTopic(topic$2, true);
            Assertions.assertTrue((boolean)$this.topicIsPausedMirror(topic$2));
            $this.pauseMirrorTopic(topic$2, false);
            Assertions.assertFalse((boolean)$this.topicIsPausedMirror(topic$2));
            $this.pauseMirrorTopic(topic$2, false);
            Assertions.assertFalse((boolean)$this.topicIsPausedMirror(topic$2));
        }
    }

    public static final /* synthetic */ boolean $anonfun$topicIsActiveMirror$1(ClusterLinkTopicState x$2) {
        return x$2 instanceof ClusterLinkTopicState.Mirror;
    }

    public static final /* synthetic */ boolean $anonfun$topicIsPausedMirror$1(ClusterLinkTopicState x$3) {
        return x$3 instanceof ClusterLinkTopicState.PausedMirror;
    }

    public static final /* synthetic */ boolean $anonfun$topicIsPendingStoppedMirror$1(ClusterLinkTopicState x$4) {
        return x$4 instanceof ClusterLinkTopicState.PendingStoppedMirror;
    }

    public static final /* synthetic */ boolean $anonfun$topicIsStoppedMirror$1(ClusterLinkTopicState x$5) {
        return x$5 instanceof ClusterLinkTopicState.StoppedMirror;
    }

    public AlterMirrorsRequestTest() {
        this.linkName = "test-link";
    }

    public static final /* synthetic */ Object $anonfun$testStopMirrorTopic$1$adapted(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$1, Seq topics$1, IntegrationTestHarness remoteCluster) {
        AlterMirrorsRequestTest.$anonfun$testStopMirrorTopic$1($this, localAdmin$1, topics$1, remoteCluster);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testClearMirrorTopic$1$adapted(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$2, String activeTopic$1, String stoppedTopic$1, IntegrationTestHarness remoteCluster) {
        AlterMirrorsRequestTest.$anonfun$testClearMirrorTopic$1($this, localAdmin$2, activeTopic$1, stoppedTopic$1, remoteCluster);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testPauseMirrorTopic$1$adapted(AlterMirrorsRequestTest $this, ConfluentAdmin localAdmin$3, String topic$2, IntegrationTestHarness remoteCluster) {
        AlterMirrorsRequestTest.$anonfun$testPauseMirrorTopic$1($this, localAdmin$3, topic$2, remoteCluster);
        return BoxedUnit.UNIT;
    }
}

