/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.BrokerToControllerChannelManagerImpl;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.KafkaConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.AutoStart;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.RaftClusterInvocationContext;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Timeout(value=120L)
@Tag(value="integration")
@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0005\tEa\u0001\u0002\u0007\u000e\u0001IAQ!\u0007\u0001\u0005\u0002iAQ!\b\u0001\u0005\u0002yAQA\u000b\u0001\u0005\u0002-BQ!\u0017\u0001\u0005\u0002iC\u0011\"!\u0006\u0001#\u0003%\t!a\u0006\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0002bBAI\u0001\u0011\u0005\u00111\u0013\u0005\b\u0003G\u0003A\u0011AAS\u0011\u001d\t\u0019\f\u0001C\u0001\u0003kCq!!0\u0001\t\u0003\tyLA\u000fCe>\\WM\u001d*fO&\u001cHO]1uS>t'+Z9vKN$H+Z:u\u0015\tqq\"\u0001\u0004tKJ4XM\u001d\u0006\u0002!\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0014!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011!D\u0001!EJ|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'\u000f\u0006\u0002 EA\u0011A\u0004I\u0005\u0003C5\u0011\u0001E\u0011:pW\u0016\u0014Hk\\\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\")1E\u0001a\u0001I\u0005y1\r\\;ti\u0016\u0014\u0018J\\:uC:\u001cW\r\u0005\u0002&Q5\taE\u0003\u0002(\u001f\u0005!A/Z:u\u0013\tIcEA\bDYV\u001cH/\u001a:J]N$\u0018M\\2f\u00039\u0019XM\u001c3B]\u0012\u0014VmY3jm\u0016,2\u0001\f(0)\u0011i#\t\u0012+\u0011\u00059zC\u0002\u0001\u0003\u0006a\r\u0011\r!\r\u0002\u0002%F\u0011!'\u000e\t\u0003)MJ!\u0001N\u000b\u0003\u000f9{G\u000f[5oOB\u0011a\u0007Q\u0007\u0002o)\u0011\u0001(O\u0001\te\u0016\fX/Z:ug*\u0011!hO\u0001\u0007G>lWn\u001c8\u000b\u0005Aa$BA\u001f?\u0003\u0019\t\u0007/Y2iK*\tq(A\u0002pe\u001eL!!Q\u001c\u0003!\u0005\u00137\u000f\u001e:bGR\u0014Vm\u001d9p]N,\u0007\"B\"\u0004\u0001\u0004y\u0012AD2iC:tW\r\\'b]\u0006<WM\u001d\u0005\u0006\u000b\u000e\u0001\rAR\u0001\u000be\u0016\f()^5mI\u0016\u0014\bcA$K\u001b:\u0011a\u0007S\u0005\u0003\u0013^\nq\"\u00112tiJ\f7\r\u001e*fcV,7\u000f^\u0005\u0003\u00172\u0013qAQ;jY\u0012,'O\u0003\u0002JoA\u0011aF\u0014\u0003\u0006\u001f\u000e\u0011\r\u0001\u0015\u0002\u0002)F\u0011!'\u0015\t\u0003mIK!aU\u001c\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRDQ!V\u0002A\u0002Y\u000b\u0011\u0002^5nK>,H/T:\u0011\u0005Q9\u0016B\u0001-\u0016\u0005\rIe\u000e^\u0001\u000fe\u0016<\u0017n\u001d;fe\n\u0013xn[3s)!Y\u0016MY8rs\u0006-\u0001C\u0001/`\u001b\u0005i&B\u00010:\u0003!\u0001(o\u001c;pG>d\u0017B\u00011^\u0005\u0019)%O]8sg\")1\t\u0002a\u0001?!)1\r\u0002a\u0001I\u0006I1\r\\;ti\u0016\u0014\u0018\n\u001a\t\u0003K2t!A\u001a6\u0011\u0005\u001d,R\"\u00015\u000b\u0005%\f\u0012A\u0002\u001fs_>$h(\u0003\u0002l+\u00051\u0001K]3eK\u001aL!!\u001c8\u0003\rM#(/\u001b8h\u0015\tYW\u0003C\u0003q\t\u0001\u0007a+\u0001\u0005ce>\\WM]%e\u0011\u0015\u0011H\u00011\u0001t\u0003\u001dQ8.\u00129pG\"\u00042\u0001\u0006;w\u0013\t)XC\u0001\u0004PaRLwN\u001c\t\u0003)]L!\u0001_\u000b\u0003\t1{gn\u001a\u0005\u0006u\u0012\u0001\ra_\u0001\nS\n\u0004Hk\\*f]\u0012\u00042\u0001\u0006;}!\u0011!Rp`@\n\u0005y,\"A\u0002+va2,'\u0007\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\rQ\u0014Q\u0001\u0006\u0003\u001dmJA!!\u0003\u0002\u0004\tyQ*\u001a;bI\u0006$\u0018MV3sg&|g\u000eC\u0005\u0002\u000e\u0011\u0001\n\u00111\u0001\u0002\u0010\u0005\tRo]3Ba\u0006\u001c\u0007.\u001a,feNLwN\\:\u0011\u0007Q\t\t\"C\u0002\u0002\u0014U\u0011qAQ8pY\u0016\fg.\u0001\rsK\u001eL7\u000f^3s\u0005J|7.\u001a:%I\u00164\u0017-\u001e7uIY*\"!!\u0007+\t\u0005=\u00111D\u0016\u0003\u0003;\u0001B!a\b\u0002*5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#A\u0005v]\u000eDWmY6fI*\u0019\u0011qE\u000b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002,\u0005\u0005\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006a1M]3bi\u0016$v\u000e]5dgR)1,!\r\u00024!)1I\u0002a\u0001?!1\u0011Q\u0007\u0004A\u0002\u0011\f\u0011\u0002^8qS\u000et\u0015-\\3\u0002qQ,7\u000f\u001e*fO&\u001cH/\u001a:[W^KG\u000f[&SC\u001a$X*[4sCRLwN\\#oC\ndW\rZ,ji\"\f\u0005/Y2iKZ+'o]5p]R!\u00111HA!!\r!\u0012QH\u0005\u0004\u0003\u007f)\"\u0001B+oSRDQaI\u0004A\u0002\u0011B3dBA#\u0003\u001f\n\t&a\u0017\u0002^\u0005}\u0013QLA1\u0003G\ni'a\u001c\u0002z\u0005m\u0004\u0003BA$\u0003\u0017j!!!\u0013\u000b\u0007\u0005\u001db%\u0003\u0003\u0002N\u0005%#aC\"mkN$XM\u001d+fgR\f1b\u00197vgR,'\u000fV=qK\u0012\u0012\u00111K\u0005\u0005\u0003+\n9&A\u0003L%\u00063EK\u0003\u0003\u0002Z\u0005%\u0013\u0001\u0002+za\u0016\fqA\u0019:pW\u0016\u00148/H\u0001\u0002\u0003-\u0019wN\u001c;s_2dWM]:\u0002\u001f5,G/\u00193bi\u00064VM]:j_:$#!!\u001a\n\t\u0005\u001d\u0014\u0011N\u0001\f\u0013\n\u0003vlM05?&3\u0006G\u0003\u0003\u0002l\u0005\r\u0011aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0002\u0013\u0005,Ho\\*uCJ$HEAA9\u0013\u0011\t\u0019(!\u001e\u0002\u00059{%\u0002BA<\u0003\u0013\n\u0011\"Q;u_N#\u0018M\u001d;\u0002!M,'O^3s!J|\u0007/\u001a:uS\u0016\u001cHFAA?W)\ty(!\"\u0002\b\u0006-\u0015Q\u0012\t\u0005\u0003\u000f\n\t)\u0003\u0003\u0002\u0004\u0006%#!F\"mkN$XM]\"p]\u001aLw\r\u0015:pa\u0016\u0014H/_\u0001\u0004W\u0016L\u0018EAAE\u0003\rRxn\\6fKB,'OL7fi\u0006$\u0017\r^1/[&<'/\u0019;j_:tSM\\1cY\u0016\fQA^1mk\u0016\f#!a$\u0002\tQ\u0014X/Z\u0001)i\u0016\u001cHOU3hSN$XM\u001d.l/&$\bn\u0013*bMRl\u0015n\u001a:bi&|g\u000eR5tC\ndW\r\u001a\u000b\u0005\u0003w\t)\nC\u0003$\u0011\u0001\u0007A\u0005K\f\t\u0003\u000b\ny%!\u0015\u0002\\\u0005e\u0015qLA/\u0003C\n\u0019'!\u001f\u0002\u001cv\t\u0001\u0001\f\u0002\u0002\u001e.R\u0011qPAC\u0003\u000f\u000bY)a(\"\u0005\u0005\u0005\u0016!\u00024bYN,\u0017A\b;fgR\u0014VmZ5ti\u0016\u0014(l[,ji\"\u001c4gQ8oiJ|G\u000e\\3s)\u0011\tY$a*\t\u000b\rJ\u0001\u0019\u0001\u0013)/%\t)%a\u0014\u0002R\u0005m\u0013\u0011TA0\u0003;\n\t'a+\u0002z\u0005EFEAAW\u0013\u0011\ty+!\u001b\u0002\u0017%\u0013\u0005kX\u001a`g}Kek\r\u0017\u0003\u0003;\u000bq\u0005^3tiJ+w-[:uKJT6nV5uQ.\u0013\u0016M\u001a;NS\u001e\u0014\u0018\r^5p]\u0016s\u0017M\u00197fIR!\u00111HA\\\u0011\u0015\u0019#\u00021\u0001%QmQ\u0011QIA(\u0003#\nY&!\u0018\u0002`\u0005u\u0013\u0011MA2\u0003[\ny'!\u001f\u0002<2\u0012\u0011QP\u0001(i\u0016\u001cHOT8NKR\fG-\u0019;b\u0007\"\fgnZ3t\u0013:\u0004&/Z'jOJ\fG/[8o\u001b>$W\r\u0006\u0003\u0002<\u0005\u0005\u0007\"B\u0012\f\u0001\u0004!\u0003fB\u0006\u0002F\u0006-\u00151\u001a\t\u0005\u0003\u000f\n9-\u0003\u0003\u0002J\u0006%#\u0001D\"mkN$XM\u001d+fgR\u001cHFAAgWY\t)%a\u0014\u0002R\u00055\u0014qNA0\u0003;\n\t'a\u0019\u0002z\u0005=GFAA?Q\u001d\u0001\u00111[AF\u0003W\u0004B!!6\u0002h6\u0011\u0011q\u001b\u0006\u0005\u00033\fY.A\u0005fqR,gn]5p]*!\u0011Q\\Ap\u0003\r\t\u0007/\u001b\u0006\u0005\u0003C\f\u0019/A\u0004kkBLG/\u001a:\u000b\u0007\u0005\u0015h(A\u0003kk:LG/\u0003\u0003\u0002j\u0006]'AC#yi\u0016tGmV5uQ2\u0012\u0011Q^\u0012\u0003\u0003_\u0004B!!=\u0002v6\u0011\u00111\u001f\u0006\u0004\u0003K4\u0013\u0002BA|\u0003g\u0014Qc\u00117vgR,'\u000fV3ti\u0016CH/\u001a8tS>t7\u000fK\u0004\u0001\u0003w\fYIa\u0001\u0011\t\u0005u\u0018q`\u0007\u0003\u00037LAA!\u0001\u0002\\\n\u0019A+Y4\"\u0005\t\u0015\u0011aC5oi\u0016<'/\u0019;j_:Ds\u0001\u0001B\u0005\u0003\u0017\u0013y\u0001\u0005\u0003\u0002~\n-\u0011\u0002\u0002B\u0007\u00037\u0014q\u0001V5nK>,HOH\u0001y\u0001")
public class BrokerRegistrationRequestTest {
    /*
     * WARNING - void declaration
     */
    public BrokerToControllerChannelManager brokerToControllerChannelManager(ClusterInstance clusterInstance) {
        void apply_retryTimeoutMs;
        void apply_threadNamePrefix;
        void apply_channelName;
        void apply_config;
        void apply_metrics;
        long l = 10000L;
        String string = "test-heartbeat-";
        String string2 = "heartbeat";
        KafkaConfig kafkaConfig = clusterInstance.anyControllerSocketServer().config();
        Metrics metrics = new Metrics();
        Time apply_time = Time.SYSTEM;
        ControllerNodeProvider apply_controllerNodeProvider = new ControllerNodeProvider(null, clusterInstance){
            private final SecurityProtocol securityProtocol;
            private final String saslMechanism;
            private final ClusterInstance clusterInstance$1;

            private Option<Node> node() {
                return new Some((Object)new Node(this.clusterInstance$1.anyControllerSocketServer().config().nodeId(), "127.0.0.1", this.clusterInstance$1.anyControllerSocketServer().boundPort(this.clusterInstance$1.controllerListenerName().get())));
            }

            private ListenerName listenerName() {
                return this.clusterInstance$1.controllerListenerName().get();
            }

            private SecurityProtocol securityProtocol() {
                return this.securityProtocol;
            }

            private String saslMechanism() {
                return this.saslMechanism;
            }

            private boolean isZkController() {
                return !this.clusterInstance$1.isKRaftTest();
            }

            public ControllerInformation getControllerInfo() {
                return new ControllerInformation(this.node(), this.listenerName(), this.securityProtocol(), this.saslMechanism(), this.isZkController());
            }
            {
                this.clusterInstance$1 = clusterInstance$1;
                this.securityProtocol = SecurityProtocol.PLAINTEXT;
                this.saslMechanism = "";
            }
        };
        return new BrokerToControllerChannelManagerImpl(apply_controllerNodeProvider, apply_time, (Metrics)apply_metrics, (KafkaConfig)apply_config, (String)apply_channelName, (String)apply_threadNamePrefix, (long)apply_retryTimeoutMs);
    }

    public <T extends AbstractRequest, R extends AbstractResponse> R sendAndReceive(BrokerToControllerChannelManager channelManager, AbstractRequest.Builder<T> reqBuilder, int timeoutMs) {
        CompletableFuture responseFuture = new CompletableFuture();
        channelManager.sendRequest(reqBuilder, new ControllerRequestCompletionHandler(null, responseFuture){
            private final CompletableFuture responseFuture$1;

            public void onTimeout() {
                this.responseFuture$1.completeExceptionally(new TimeoutException());
            }

            public void onComplete(ClientResponse response) {
                this.responseFuture$1.complete(response.responseBody());
            }
            {
                this.responseFuture$1 = responseFuture$1;
            }
        });
        return (R)((AbstractResponse)responseFuture.get(timeoutMs, TimeUnit.MILLISECONDS));
    }

    public Errors registerBroker(BrokerToControllerChannelManager channelManager, String clusterId, int brokerId, Option<Object> zkEpoch, Option<Tuple2<MetadataVersion, MetadataVersion>> ibpToSend, boolean useApacheVersions) {
        BrokerRegistrationRequestData.FeatureCollection features = new BrokerRegistrationRequestData.FeatureCollection();
        ibpToSend.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerRegistrationRequestTest.$anonfun$registerBroker$1(useApacheVersions, features, x0$1)));
        BrokerRegistrationRequestData req = new BrokerRegistrationRequestData().setBrokerId(brokerId).setClusterId(clusterId).setIncarnationId(Uuid.randomUuid()).setIsMigratingZkBroker(zkEpoch.isDefined()).setFeatures(features);
        return Errors.forCode((short)((BrokerRegistrationResponse)this.sendAndReceive(channelManager, (AbstractRequest.Builder)new BrokerRegistrationRequest.Builder(req), 30000)).data().errorCode());
    }

    public boolean registerBroker$default$6() {
        return false;
    }

    public Errors createTopics(BrokerToControllerChannelManager channelManager, String topicName) {
        CreateTopicsRequestData createTopics = new CreateTopicsRequestData();
        createTopics.setTopics(new CreateTopicsRequestData.CreatableTopicCollection());
        createTopics.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName(topicName).setNumPartitions(10).setReplicationFactor((short)1));
        createTopics.setTimeoutMs(500);
        CreateTopicsRequest.Builder req = new CreateTopicsRequest.Builder(createTopics);
        return Errors.forCode((short)((CreateTopicsResponse)this.sendAndReceive(channelManager, (AbstractRequest.Builder)req, 3000)).data().topics().find(topicName).errorCode());
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=1, metadataVersion=MetadataVersion.IBP_3_4_IV0, autoStart=AutoStart.NO, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="true")})
    public void testRegisterZkWithKRaftMigrationEnabledWithApacheVersion(ClusterInstance clusterInstance) {
        ((RaftClusterInvocationContext.RaftClusterInstance)clusterInstance).controllers().forEach(x$1 -> x$1.startup());
        String clusterId = clusterInstance.clusterId();
        BrokerToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV0, (Object)MetadataVersion.IBP_3_3_IV0)), true));
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$, this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0)), true));
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0)), true));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=0, controllers=1, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="false")})
    public void testRegisterZkWithKRaftMigrationDisabled(ClusterInstance clusterInstance) {
        String clusterId = clusterInstance.clusterId();
        BrokerToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV0, (Object)MetadataVersion.IBP_3_3_IV0)), this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$, this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0)), this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0)), this.registerBroker$default$6()));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=0, controllers=1, metadataVersion=MetadataVersion.IBP_3_3_IV3, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="false")})
    public void testRegisterZkWith33Controller(ClusterInstance clusterInstance) {
        String clusterId = clusterInstance.clusterId();
        BrokerToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV0, (Object)MetadataVersion.IBP_3_3_IV3)), this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$, this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0)), this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.IBP_3_4_IV0)), this.registerBroker$default$6()));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=1, metadataVersion=MetadataVersion.IBP_3_4_IV0, autoStart=AutoStart.NO, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="true")})
    public void testRegisterZkWithKRaftMigrationEnabled(ClusterInstance clusterInstance) {
        ((RaftClusterInvocationContext.RaftClusterInstance)clusterInstance).controllers().forEach(x$2 -> x$2.startup());
        String clusterId = clusterInstance.clusterId();
        BrokerToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0)), this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$, this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.IBP_3_3_IV3)), this.registerBroker$default$6()));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0)), this.registerBroker$default$6()));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.KRAFT, autoStart=AutoStart.NO, controllers=1, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="true")})})
    public void testNoMetadataChangesInPreMigrationMode(ClusterInstance clusterInstance) {
        ((RaftClusterInvocationContext.RaftClusterInstance)clusterInstance).controllers().forEach(x$3 -> x$3.startup());
        BrokerToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertThrows(TimeoutException.class, () -> this.createTopics(channelManager, "test-pre-migration"));
        }
        finally {
            channelManager.shutdown();
        }
    }

    public static final /* synthetic */ boolean $anonfun$registerBroker$1(boolean useApacheVersions$1, BrokerRegistrationRequestData.FeatureCollection features$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetadataVersion min = (MetadataVersion)x0$1._1();
            MetadataVersion max = (MetadataVersion)x0$1._2();
            if (useApacheVersions$1) {
                return features$1.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(min.apacheFeatureLevel()).setMaxSupportedVersion(max.apacheFeatureLevel()));
            }
            return features$1.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName("confluent.metadata.version").setMinSupportedVersion(min.confluentFeatureLevel()).setMaxSupportedVersion(max.confluentFeatureLevel()));
        }
        throw new MatchError(null);
    }
}

