/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.rest.CheckReadyControllerStatus;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import kafka.server.CheckReadyControllerHandleAdapter;
import kafka.server.ControllerStatusHandleAdapter$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumOptions;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumResult;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.None$;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005q4A\u0001E\t\u0001-!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0003\u0011\u0003BB\u0016\u0001A\u0003%1\u0005C\u0004-\u0001\t\u0007I\u0011A\u0017\t\rE\u0002\u0001\u0015!\u0003/\u0011\u0015\u0011\u0004\u0001\"\u00014\u0011\u0015!\u0005\u0001\"\u00014\u0011\u00151\u0005\u0001\"\u00014\u0011\u0015A\u0005\u0001\"\u00014\u0011\u0015Q\u0005\u0001\"\u00014\u0011\u0015a\u0005\u0001\"\u00014\u0011\u0015q\u0005\u0001\"\u00014\u0011\u0015\u0001\u0006\u0001\"\u0003R\u0011\u0015\u0001\u0006\u0001\"\u0003g\u0011\u0015)\b\u0001\"\u0003w\u0005\u0015\u001a\u0005.Z2l%\u0016\fG-_\"p]R\u0014x\u000e\u001c7fe\"\u000bg\u000e\u001a7f\u0003\u0012\f\u0007\u000f^3s)\u0016\u001cHO\u0003\u0002\u0013'\u000511/\u001a:wKJT\u0011\u0001F\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003E\tQ\u0001\u001d:paN,\u0012a\t\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nA!\u001e;jY*\t\u0001&\u0001\u0003kCZ\f\u0017B\u0001\u0016&\u0005)\u0001&o\u001c9feRLWm]\u0001\u0007aJ|\u0007o\u001d\u0011\u0002\r\r|gNZ5h+\u0005q\u0003C\u0001\u00110\u0013\t\u0001\u0014CA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u0013i\u0016\u001cHOU3bIf<\u0016\u000e\u001e5O_2\u000bw\rF\u00015!\tAR'\u0003\u000273\t!QK\\5uQ\t1\u0001\b\u0005\u0002:\u00056\t!H\u0003\u0002<y\u0005\u0019\u0011\r]5\u000b\u0005ur\u0014a\u00026va&$XM\u001d\u0006\u0003\u007f\u0001\u000bQA[;oSRT\u0011!Q\u0001\u0004_J<\u0017BA\";\u0005\u0011!Vm\u001d;\u0002GQ,7\u000f\u001e*fC\u0012Lx+\u001b;i\u000bb\f7\r\u001e7z\u001b\u0006D\u0018\t\u001c7po\u0006\u0014G.\u001a'bO\"\u0012q\u0001O\u00013i\u0016\u001cHOT8u%\u0016\fG-_,iK:$\u0006.[:O_\u0012,G*Y4t\u0005fluN]3UQ\u0006tW*\u0019=BY2|w/\u00192mK\"\u0012\u0001\u0002O\u00015i\u0016\u001cHOU3bIf<\u0006.\u001a8T_6,w\n\u001e5fe:{G-\u001a'bON\u0014\u00150T8sKRC\u0017M\\'bq\u0006cGn\\<bE2,\u0007FA\u00059\u0003\r\"Xm\u001d;O_R\u0014V-\u00193z/\",g\u000e\u00165jg:{G-\u001a%bg:{wJ\u001a4tKRD#A\u0003\u001d\u0002KQ,7\u000f\u001e*fC\u0012Lx\u000b[3o'>lWm\u0014;iKJtu\u000eZ3ICNtun\u00144gg\u0016$\bFA\u00069\u0003}!Xm\u001d;O_R\u0014V-\u00193z/\",g.\u0012=dKB$\u0018n\u001c8PG\u000e,(o\u001d\u0015\u0003\u0019a\nqb\u0019:fCR,Wj\\2l\u0003\u0012l\u0017N\u001c\u000b\u0005%v\u0013G\r\u0005\u0002T76\tAK\u0003\u0002V-\u0006)\u0011\rZ7j]*\u0011q\u000bW\u0001\bG2LWM\u001c;t\u0015\t!\u0012L\u0003\u0002[\u0001\u00061\u0011\r]1dQ\u0016L!\u0001\u0018+\u0003\u001d\r{gN\u001a7vK:$\u0018\tZ7j]\")a,\u0004a\u0001?\u0006!\"/\u001a9mS\u000e\f\u0017\u0007T8h\u000b:$wJ\u001a4tKR\u0004\"\u0001\u00071\n\u0005\u0005L\"\u0001\u0002'p]\u001eDQaY\u0007A\u0002}\u000bAC]3qY&\u001c\u0017M\r'pO\u0016sGm\u00144gg\u0016$\b\"B3\u000e\u0001\u0004y\u0016\u0001\u0006:fa2L7-Y\u001aM_\u001e,e\u000eZ(gMN,G\u000f\u0006\u0002SO\")\u0001N\u0004a\u0001S\u0006\tQ\r\u0005\u0002ke:\u00111\u000e\u001d\b\u0003Y>l\u0011!\u001c\u0006\u0003]V\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u0005EL\u0012a\u00029bG.\fw-Z\u0005\u0003gR\u0014\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0005EL\u0012!J4f]\u0016\u0014\u0018\r^3SK\u0006$\u0017N\\3tgN#\u0018\r^;t\u0003:$\u0017i]:feR\u0014V-\u00193z)\t!t\u000fC\u0003y\u001f\u0001\u0007\u00110A\u0004bI\u0006\u0004H/\u001a:\u0011\u0005\u0001R\u0018BA>\u0012\u0005\u0005\u001a\u0005.Z2l%\u0016\fG-_\"p]R\u0014x\u000e\u001c7fe\"\u000bg\u000e\u001a7f\u0003\u0012\f\u0007\u000f^3s\u0001")
public class CheckReadyControllerHandleAdapterTest {
    private final Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2121", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
    private final KafkaConfig config;

    public Properties props() {
        return this.props;
    }

    public KafkaConfig config() {
        return this.config;
    }

    @Test
    public void testReadyWithNoLag() {
        ConfluentAdmin admin = this.createMockAdmin(100L, 200L, 300L);
        CheckReadyControllerHandleAdapter adapter = new CheckReadyControllerHandleAdapter("", this.config(), admin);
        this.generateReadinessStatusAndAssertReady(adapter);
    }

    @Test
    public void testReadyWithExactlyMaxAllowableLag() {
        ConfluentAdmin admin = this.createMockAdmin(ControllerStatusHandleAdapter$.MODULE$.MaxAllowedOffsetLag(), ControllerStatusHandleAdapter$.MODULE$.MaxAllowedOffsetLag() + 1, ControllerStatusHandleAdapter$.MODULE$.MaxAllowedOffsetLag() * 2);
        CheckReadyControllerHandleAdapter adapter = new CheckReadyControllerHandleAdapter("", this.config(), admin);
        this.generateReadinessStatusAndAssertReady(adapter);
    }

    @Test
    public void testNotReadyWhenThisNodeLagsByMoreThanMaxAllowable() {
        ConfluentAdmin admin = this.createMockAdmin(1L, ControllerStatusHandleAdapter$.MODULE$.MaxAllowedOffsetLag(), ControllerStatusHandleAdapter$.MODULE$.MaxAllowedOffsetLag() + 2);
        CheckReadyControllerStatus status = new CheckReadyControllerHandleAdapter("", this.config(), admin).generateReadinessStatus();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)status.ready()));
        Assertions.assertEquals((Object)new StringBuilder(110).append("Found at least one quorum voter with an offset 1 while the highest offset was ").append(ControllerStatusHandleAdapter$.MODULE$.MaxAllowedOffsetLag() + 2).append(". The max allowed offset lag is ").append(ControllerStatusHandleAdapter$.MODULE$.MaxAllowedOffsetLag()).toString(), (Object)status.reason());
    }

    @Test
    public void testReadyWhenSomeOtherNodeLagsByMoreThanMaxAllowable() {
        ConfluentAdmin admin = this.createMockAdmin(ControllerStatusHandleAdapter$.MODULE$.MaxAllowedOffsetLag(), 1L, ControllerStatusHandleAdapter$.MODULE$.MaxAllowedOffsetLag() + 2);
        CheckReadyControllerHandleAdapter adapter = new CheckReadyControllerHandleAdapter("", this.config(), admin);
        this.generateReadinessStatusAndAssertReady(adapter);
    }

    @Test
    public void testNotReadyWhenThisNodeHasNoOffset() {
        ConfluentAdmin admin = this.createMockAdmin(-1L, 1L, 1L);
        CheckReadyControllerStatus status = new CheckReadyControllerHandleAdapter("", this.config(), admin).generateReadinessStatus();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)status.ready()));
        Assertions.assertEquals((Object)ControllerStatusHandleAdapter$.MODULE$.UnreachableQuorumMemberMsg(), (Object)status.reason());
    }

    @Test
    public void testReadyWhenSomeOtherNodeHasNoOffset() {
        ConfluentAdmin admin = this.createMockAdmin(1L, -1L, 1L);
        CheckReadyControllerHandleAdapter adapter = new CheckReadyControllerHandleAdapter("", this.config(), admin);
        this.generateReadinessStatusAndAssertReady(adapter);
    }

    @Test
    public void testNotReadyWhenExceptionOccurs() {
        ConfluentAdmin admin = this.createMockAdmin(new UnsupportedOperationException());
        CheckReadyControllerStatus status = new CheckReadyControllerHandleAdapter("", this.config(), admin).generateReadinessStatus();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)status.ready()));
        Assertions.assertTrue((boolean)status.reason().contains("There was an exception"));
    }

    private ConfluentAdmin createMockAdmin(long replica1LogEndOffset, long replica2LogEndOffset, long replica3LogEndOffset) {
        QuorumInfo.ReplicaState repl1 = (QuorumInfo.ReplicaState)Mockito.mock(QuorumInfo.ReplicaState.class);
        QuorumInfo.ReplicaState repl2 = (QuorumInfo.ReplicaState)Mockito.mock(QuorumInfo.ReplicaState.class);
        QuorumInfo.ReplicaState repl3 = (QuorumInfo.ReplicaState)Mockito.mock(QuorumInfo.ReplicaState.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl1.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl2.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)2));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)repl3.replicaId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)3));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl1.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)replica1LogEndOffset));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl2.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)replica2LogEndOffset));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)repl3.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)replica3LogEndOffset));
        Buffer voters = (Buffer)Buffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuorumInfo.ReplicaState[]{repl1, repl2, repl3}));
        QuorumInfo quorumInfo = (QuorumInfo)Mockito.mock(QuorumInfo.class);
        Mockito.when((Object)quorumInfo.voters()).thenReturn((Object)CollectionConverters$.MODULE$.BufferHasAsJava(voters).asJava());
        KafkaFuture quorumFuture = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        Mockito.when((Object)quorumFuture.get()).thenReturn((Object)quorumInfo);
        DescribeMetadataQuorumResult metadataQuorumResult = (DescribeMetadataQuorumResult)Mockito.mock(DescribeMetadataQuorumResult.class);
        Mockito.when((Object)metadataQuorumResult.quorumInfo()).thenReturn((Object)quorumFuture);
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        Mockito.when((Object)admin.describeMetadataQuorum((DescribeMetadataQuorumOptions)ArgumentMatchers.any())).thenReturn((Object)metadataQuorumResult);
        return admin;
    }

    private ConfluentAdmin createMockAdmin(Exception e) {
        KafkaFuture quorumFuture = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        Mockito.when((Object)quorumFuture.get()).thenThrow(new Throwable[]{e});
        DescribeMetadataQuorumResult metadataQuorumResult = (DescribeMetadataQuorumResult)Mockito.mock(DescribeMetadataQuorumResult.class);
        Mockito.when((Object)metadataQuorumResult.quorumInfo()).thenReturn((Object)quorumFuture);
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        Mockito.when((Object)admin.describeMetadataQuorum((DescribeMetadataQuorumOptions)ArgumentMatchers.any())).thenReturn((Object)metadataQuorumResult);
        return admin;
    }

    private void generateReadinessStatusAndAssertReady(CheckReadyControllerHandleAdapter adapter) {
        CheckReadyControllerStatus readinessStatus = adapter.generateReadinessStatus();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)readinessStatus.ready()));
        Assertions.assertEquals((Object)"", (Object)readinessStatus.reason());
    }

    public CheckReadyControllerHandleAdapterTest() {
        this.props().put(KafkaConfig$.MODULE$.RequestTimeoutMsProp(), "10000");
        boolean apply_doLog = true;
        Properties apply_props = this.props();
        this.config = new KafkaConfig((Map)apply_props, apply_doLog);
    }
}

