/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import kafka.network.RequestChannel;
import kafka.server.AbstractQuotaChannelManager;
import kafka.server.ActiveTenantsManager;
import kafka.server.BaseClientQuotaManagerTest;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.Defaults$;
import kafka.server.DiskThrottleListenerManager;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.DiskUsageBasedThrottlingConfig;
import kafka.server.DiskUsageBasedThrottlingConfig$;
import kafka.server.DynamicQuotaReportingRequestThread;
import kafka.server.QuotaType;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.message.ReportQuotaConsumptionRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rub\u0001B*U\u0001eCQA\u0018\u0001\u0005\u0002}Cq!\u0019\u0001C\u0002\u0013%!\r\u0003\u0004g\u0001\u0001\u0006Ia\u0019\u0005\bO\u0002\u0011\r\u0011\"\u0003i\u0011\u0019a\u0007\u0001)A\u0005S\")Q\u000e\u0001C\u0005]\"9\u00111\u001e\u0001\u0005\u0002\u00055\bb\u0002B\u0005\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0005\u001b\u0001A\u0011AAw\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0003[DqA!\u0006\u0001\t\u0003\ti\u000fC\u0004\u0003\u001a\u0001!IAa\u0007\t\u000f\tu\u0002\u0001\"\u0001\u0002n\"9!\u0011\t\u0001\u0005\u0002\u00055\bb\u0002B#\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0005\u0013\u0002A\u0011AAw\u0011\u001d\u0011i\u0005\u0001C\u0001\u0003[DqA!\u0015\u0001\t\u0003\ti\u000fC\u0004\u0003V\u0001!\t!!<\t\u000f\te\u0003\u0001\"\u0001\u0002n\"9!Q\f\u0001\u0005\u0002\u00055\bb\u0002B1\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0005K\u0002A\u0011AAw\u0011\u001d\u0011I\u0007\u0001C\u0001\u0003[DqA!\u001c\u0001\t\u0003\ti\u000fC\u0004\u0003r\u0001!\t!!<\t\u000f\tU\u0004\u0001\"\u0001\u0002n\"9!\u0011\u0010\u0001\u0005\u0002\u00055\bb\u0002B?\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0005\u0003\u0003A\u0011AAw\u0011\u001d\u0011)\t\u0001C\u0001\u0003[DqA!#\u0001\t\u0003\ti\u000fC\u0004\u0003\u000e\u0002!\t!!<\t\u000f\tE\u0005\u0001\"\u0001\u0002n\"9!Q\u0013\u0001\u0005\u0002\u00055\bb\u0002BM\u0001\u0011%!1\u0014\u0005\b\u0005_\u0003A\u0011AAw\u0011\u001d\u0011\u0019\f\u0001C\u0001\u0003[DqAa.\u0001\t\u0003\ti\u000fC\u0004\u0003<\u0002!\t!!<\t\u000f\t}\u0006\u0001\"\u0001\u0002n\"9!1\u0019\u0001\u0005\u0002\u00055\bb\u0002Bd\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0005\u0017\u0004A\u0011AAw\u0011\u001d\u0011y\r\u0001C\u0001\u0005#DqAa6\u0001\t\u0003\u0011I\u000eC\u0004\u0003b\u0002!\tAa9\u0007\ti\u0004Ai\u001f\u0005\u000b\u0003;\u0001$Q3A\u0005\u0002\u0005}\u0001BCA\u0019a\tE\t\u0015!\u0003\u0002\"!Q\u00111\u0007\u0019\u0003\u0016\u0004%\t!a\b\t\u0015\u0005U\u0002G!E!\u0002\u0013\t\t\u0003\u0003\u0006\u00028A\u0012)\u001a!C\u0001\u0003sA!\"!\u00111\u0005#\u0005\u000b\u0011BA\u001e\u0011)\t\u0019\u0005\rBK\u0002\u0013\u0005\u0011\u0011\b\u0005\u000b\u0003\u000b\u0002$\u0011#Q\u0001\n\u0005m\u0002B\u000201\t\u0003\t9\u0005C\u0004\u0002RA\"\t!a\u0015\t\u0013\u0005\u0015\u0004'!A\u0005\u0002\u0005\u001d\u0004\"CA9aE\u0005I\u0011AA:\u0011%\tI\tMI\u0001\n\u0003\t\u0019\bC\u0005\u0002\fB\n\n\u0011\"\u0001\u0002\u000e\"I\u0011\u0011\u0013\u0019\u0012\u0002\u0013\u0005\u0011Q\u0012\u0005\n\u0003'\u0003\u0014\u0011!C!\u0003+C\u0011\"a&1\u0003\u0003%\t!!'\t\u0013\u0005\u0005\u0006'!A\u0005\u0002\u0005\r\u0006\"CAXa\u0005\u0005I\u0011IAY\u0011%\ty\fMA\u0001\n\u0003\t\t\rC\u0005\u0002LB\n\t\u0011\"\u0011\u0002N\"I\u0011\u0011\u001b\u0019\u0002\u0002\u0013\u0005\u00131\u001b\u0005\n\u0003+\u0004\u0014\u0011!C!\u0003/D\u0011\"!71\u0003\u0003%\t%a7\b\u0013\tm\b!!A\t\n\tuh\u0001\u0003>\u0001\u0003\u0003EIAa@\t\rySE\u0011AB\f\u0011%\t)NSA\u0001\n\u000b\n9\u000eC\u0005\u0004\u001a)\u000b\t\u0011\"!\u0004\u001c!I1Q\u0005&\u0012\u0002\u0013\u0005\u0011Q\u0012\u0005\n\u0007OQ\u0015\u0013!C\u0001\u0003\u001bC\u0011b!\u000bK\u0003\u0003%\tia\u000b\t\u0013\re\"*%A\u0005\u0002\u00055\u0005\"CB\u001e\u0015F\u0005I\u0011AAG\u0005Y\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:UKN$(BA+W\u0003\u0019\u0019XM\u001d<fe*\tq+A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0006CA.]\u001b\u0005!\u0016BA/U\u0005i\u0011\u0015m]3DY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014H+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0001\r\u0005\u0002\\\u0001\u000511m\u001c8gS\u001e,\u0012a\u0019\t\u00037\u0012L!!\u001a+\u00031\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\u001d\rD\u0017M\u001c8fY6\u000bg.Y4feV\t\u0011\u000e\u0005\u0002\\U&\u00111\u000e\u0016\u0002\u001c\u0003\n\u001cHO]1diF+x\u000e^1DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0002\u001f\rD\u0017M\u001c8fY6\u000bg.Y4fe\u0002\n\u0001\u0003^3tiF+x\u000e^1QCJ\u001c\u0018N\\4\u0015\u0013=,h/a8\u0002d\u0006\u001d\bC\u00019t\u001b\u0005\t(\"\u0001:\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\f(\u0001B+oSRDQ!\u0019\u0004A\u0002\rDQa\u001e\u0004A\u0002a\fqa\u00197jK:$\u0018\u0007\u0005\u0002za5\t\u0001A\u0001\u0006Vg\u0016\u00148\t\\5f]R\u001cR\u0001\r?\u0000\u0003\u000b\u0001\"\u0001]?\n\u0005y\f(AB!osJ+g\rE\u0002q\u0003\u0003I1!a\u0001r\u0005\u001d\u0001&o\u001c3vGR\u0004B!a\u0002\u0002\u00189!\u0011\u0011BA\n\u001d\u0011\tY!!\u0005\u000e\u0005\u00055!bAA\b1\u00061AH]8pizJ\u0011A]\u0005\u0004\u0003+\t\u0018a\u00029bG.\fw-Z\u0005\u0005\u00033\tYB\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002\u0016E\fA!^:feV\u0011\u0011\u0011\u0005\t\u0005\u0003G\tYC\u0004\u0003\u0002&\u0005\u001d\u0002cAA\u0006c&\u0019\u0011\u0011F9\u0002\rA\u0013X\rZ3g\u0013\u0011\ti#a\f\u0003\rM#(/\u001b8h\u0015\r\tI#]\u0001\u0006kN,'\u000fI\u0001\tG2LWM\u001c;JI\u0006I1\r\\5f]RLE\rI\u0001\u000bG>tg-[4Vg\u0016\u0014XCAA\u001e!\u0015\u0001\u0018QHA\u0011\u0013\r\ty$\u001d\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0017\r|gNZ5h+N,'\u000fI\u0001\u000fG>tg-[4DY&,g\u000e^%e\u0003=\u0019wN\u001c4jO\u000ec\u0017.\u001a8u\u0013\u0012\u0004C#\u0003=\u0002J\u0005-\u0013QJA(\u0011\u001d\ti\"\u000fa\u0001\u0003CAq!a\r:\u0001\u0004\t\t\u0003C\u0005\u00028e\u0002\n\u00111\u0001\u0002<!I\u00111I\u001d\u0011\u0002\u0003\u0007\u00111H\u0001\u0018g\u0006t\u0017\u000e^5{K\u0012\u001cuN\u001c4jO\u000ec\u0017.\u001a8u\u0013\u0012,\"!!\u0016\u0011\u000bA\fi$a\u0016\u0011\t\u0005e\u00131M\u0007\u0003\u00037RA!!\u0018\u0002`\u0005!A.\u00198h\u0015\t\t\t'\u0001\u0003kCZ\f\u0017\u0002BA\u0017\u00037\nAaY8qsRI\u00010!\u001b\u0002l\u00055\u0014q\u000e\u0005\n\u0003;Y\u0004\u0013!a\u0001\u0003CA\u0011\"a\r<!\u0003\u0005\r!!\t\t\u0013\u0005]2\b%AA\u0002\u0005m\u0002\"CA\"wA\u0005\t\u0019AA\u001e\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u001e+\t\u0005\u0005\u0012qO\u0016\u0003\u0003s\u0002B!a\u001f\u0002\u00066\u0011\u0011Q\u0010\u0006\u0005\u0003\u007f\n\t)A\u0005v]\u000eDWmY6fI*\u0019\u00111Q9\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\b\u0006u$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u001fSC!a\u000f\u0002x\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002X\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u0014\t\u0004a\u0006u\u0015bAAPc\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QUAV!\r\u0001\u0018qU\u0005\u0004\u0003S\u000b(aA!os\"I\u0011Q\u0016\"\u0002\u0002\u0003\u0007\u00111T\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005M\u0006CBA[\u0003w\u000b)+\u0004\u0002\u00028*\u0019\u0011\u0011X9\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002>\u0006]&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a1\u0002JB\u0019\u0001/!2\n\u0007\u0005\u001d\u0017OA\u0004C_>dW-\u00198\t\u0013\u00055F)!AA\u0002\u0005\u0015\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0016\u0002P\"I\u0011QV#\u0002\u0002\u0003\u0007\u00111T\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111T\u0001\ti>\u001cFO]5oOR\u0011\u0011qK\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\r\u0017Q\u001c\u0005\n\u0003[C\u0015\u0011!a\u0001\u0003KCa!!9\u0007\u0001\u0004A\u0018aB2mS\u0016tGO\r\u0005\u0007\u0003K4\u0001\u0019\u0001=\u0002\u0019I\fg\u000eZ8n\u00072LWM\u001c;\t\r\u0005%h\u00011\u0001y\u0003M!WMZ1vYR\u001cuN\u001c4jO\u000ec\u0017.\u001a8u\u0003a!Xm\u001d;DY&,g\u000e^%e#V|G/\u0019)beNLgn\u001a\u000b\u0002_\"\u001aq!!=\u0011\t\u0005M(QA\u0007\u0003\u0003kTA!a>\u0002z\u0006\u0019\u0011\r]5\u000b\t\u0005m\u0018Q`\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\tyP!\u0001\u0002\u000b),h.\u001b;\u000b\u0005\t\r\u0011aA8sO&!!qAA{\u0005\u0011!Vm\u001d;\u0002)Q,7\u000f^+tKJ\fVo\u001c;b!\u0006\u00148/\u001b8hQ\rA\u0011\u0011_\u0001\u001di\u0016\u001cH/V:fe\u000ec\u0017.\u001a8u\u0013\u0012\fVo\u001c;b!\u0006\u00148/\u001b8hQ\rI\u0011\u0011_\u0001-i\u0016\u001cH/V:feF+x\u000e^1QCJ\u001c\u0018N\\4XSRDG)\u001a4bk2$8\t\\5f]RLE-U;pi\u0006D3ACAy\u0003Q\"Xm\u001d;Vg\u0016\u00148\t\\5f]R\fVo\u001c;b!\u0006\u00148/\u001b8h\u0013\u0012<\u0016\u000e\u001e5EK\u001a\fW\u000f\u001c;DY&,g\u000e^%e#V|G/\u0019\u0015\u0004\u0017\u0005E\u0018AC2iK\u000e\\\u0017+^8uCRiqN!\b\u0003(\t%\"1\u0006B\u001b\u0005sAqAa\b\r\u0001\u0004\u0011\t#\u0001\u0007rk>$\u0018-T1oC\u001e,'\u000fE\u0002\\\u0005GI1A!\nU\u0005I\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:\t\u000f\u0005uA\u00021\u0001\u0002\"!9\u00111\u0007\u0007A\u0002\u0005\u0005\u0002b\u0002B\u0017\u0019\u0001\u0007!qF\u0001\u000eKb\u0004Xm\u0019;fI\n{WO\u001c3\u0011\u0007A\u0014\t$C\u0002\u00034E\u0014A\u0001T8oO\"9!q\u0007\u0007A\u0002\u0005m\u0015!\u0002<bYV,\u0007b\u0002B\u001e\u0019\u0001\u0007\u00111Y\u0001\u000fKb\u0004Xm\u0019;UQJ|G\u000f\u001e7f\u0003U\"Xm\u001d;HKRl\u0015\r\u001f,bYV,\u0017J\\)v_R\fw+\u001b8e_^<\u0016\u000e\u001e5O_:$UMZ1vYR\fVo\u001c;b/&tGm\\<)\u00075\t\t0\u0001\u0011uKN$8+\u001a;B]\u0012\u0014V-\\8wK\u0012+g-Y;miV\u001bXM])v_R\f\u0007f\u0001\b\u0002r\u0006IB/Z:u'\u0016$\u0018I\u001c3SK6|g/Z+tKJ\fVo\u001c;bQ\ry\u0011\u0011_\u0001 i\u0016\u001cHoU3u\u0003:$'+Z7pm\u0016,6/\u001a:DY&,g\u000e^)v_R\f\u0007f\u0001\t\u0002r\u0006IB/Z:u#V|G/Y\"p]\u001aLw\r\u0015:fG\u0016$WM\\2fQ\r\t\u0012\u0011_\u0001\u0013i\u0016\u001cH/U;pi\u00064\u0016n\u001c7bi&|g\u000eK\u0002\u0013\u0003c\fQ\u0005^3tiF+x\u000e^1WS>d\u0017\r^5p]^KG\u000f['bqRC'o\u001c;uY\u0016$\u0016.\\3)\u0007M\t\t0\u0001\u000fuKN$X\t\u001f9je\u0016$\u0006N]8ui2,G+[7f'\u0016t7o\u001c:)\u0007Q\t\t0\u0001\fuKN$X\t\u001f9je\u0016\fVo\u001c;b'\u0016t7o\u001c:tQ\r)\u0012\u0011_\u0001\u0019i\u0016\u001cHo\u00117jK:$\u0018\n\u001a(piN\u000bg.\u001b;ju\u0016$\u0007f\u0001\f\u0002r\u0006yB/Z:u+:Lg/\u001a:tC2LG/_(g\u0003\u000e$\u0018N^3UK:\fg\u000e^:)\u0007]\t\t0\u0001\u000fuKN$hI]3rk\u0016t7-_(g\u0003V$x\u000eV;oKF+x\u000e^1)\u0007a\t\t0A\u000fuKN$\u0018J\\1di&4X\rV3oC:$8OU3tKR\fVo\u001c;bQ\rI\u0012\u0011_\u0001,i\u0016\u001cH/Q;u_R+h.\u001a\"b]\u0012<\u0018\u000e\u001a;i#V|G/Y!mY\u0006\u0013wN^3GC&\u0014H*[7ji\"\u001a!$!=\u0002aQ,7\u000f^!vi>$VO\\3CC:$w/\u001b3uQF+x\u000e^1BE>4X-\u00118e\u0005\u0016dwn\u001e$bSJd\u0015.\\5uQ\rY\u0012\u0011_\u0001,i\u0016\u001cH/Q;u_R+h.\u001a\"b]\u0012<\u0018\u000e\u001a;i#V|G/Y!mY\n+Gn\\<GC&\u0014H*[7ji\"\u001aA$!=\u0002SQ,7\u000f^!vi>$VO\\3CC:$w/\u001b3uQF+x\u000e^1Nk2$\u0018\u000e\u001d7f)\u0016t\u0017M\u001c;tQ\ri\u0012\u0011_\u0001)i\u0016\u001cH/Q;u_R+h.Z,ji\"\u001c\u0005.\u00198hS:<'I]8lKJ\fVo\u001c;b\u0019&l\u0017\u000e\u001e\u0015\u0004=\u0005E\u0018a\u000b;fgR\fU\u000f^8Uk:,w+\u001b;i\u0007\"\fgnZ5oO>\u0013\u0018nZ5oC2\u001cE.[3oiF+x\u000e^1)\u0007}\t\t0\u0001\u0014uKN$\u0018)\u001e;p)VtWm\u00165f]\u000ec\u0017.\u001a8u'R|\u0007o]*f]\u0012Lgn\u001a'pC\u0012D3\u0001IAy\u0003M\"Xm\u001d;BkR|G+\u001e8f/\",gn\u00117jK:$Xk]1hK\u0012+7M]3bg&tw-\u00114uKJ$\u0006N]8ui2,G\rK\u0002\"\u0003c\f\u0011\u0005^3tiF+x\u000e^1SKB|'\u000f^5oO\u000e\u000bG\u000e\u001c2bG.,e.\u00192mK\u0012D3AIAy\u0003=\"Xm\u001d;Rk>$\u0018MU3q_J$\u0018N\\4DC2d'-Y2l/&$\b.Q2uSZ,7i\u001c8tk6\u0004H/[8oQ\r\u0019\u0013\u0011_\u0001\u0014m\u0016\u0014\u0018NZ=Es:\fW.[2Rk>$\u0018m\u001d\u000b\u0006_\nu%q\u0014\u0005\b\u0005?!\u0003\u0019\u0001B\u0011\u0011\u001d\u0011\t\u000b\na\u0001\u0005G\u000b\u0001$\u001a=qK\u000e$X\rZ)v_R\f7OR8s\u00072LWM\u001c;t!!\t\u0019C!*\u0002\"\t%\u0016\u0002\u0002BT\u0003_\u00111!T1q!\r\u0001(1V\u0005\u0004\u0005[\u000b(A\u0002#pk\ndW-A\u001auKN$\u0018)\u001e;p)Vt\u0017N\\4BY2|7-\u0019;fg\n\u000bg\u000eZ<jIRD\u0007K]8q_J$\u0018n\u001c8bYR{\u0017+^8uC\"\u001aQ%!=\u0002SQ,7\u000f^!vi>$VO\\5oOVsG.[7ji\u0016$\u0017+^8uC\u001a{'/\u00117m\u00072LWM\u001c;tQ\r1\u0013\u0011_\u0001+i\u0016\u001cH/Q;u_R+h.\u001b8h+:d\u0017.\\5uK\u0012\fVo\u001c;b\r>\u00148k\\7f\u00072LWM\u001c;tQ\r9\u0013\u0011_\u00010i\u0016\u001cH/Q;u_R+h.\u001b8h+:d\u0017.\\5uK\u0012\fVo\u001c;b/&$\b\u000eT8x+N\fw-Z\"mS\u0016tGo\u001d\u0015\u0004Q\u0005E\u0018\u0001\u000b;fgR\fU\u000f^8Uk:LgnZ+oY&l\u0017\u000e^3e#V|G/Y,ji\"dun^+tC\u001e,\u0007fA\u0015\u0002r\u0006qB/Z:u\u0003V$x\u000eV;oS:<\u0007*\u00198eY\u0016\u001c(,\u001a:p#V|G/\u0019\u0015\u0004U\u0005E\u0018\u0001\t;fgR\fU\u000f^8Uk:LgnZ*peR\u001c()_+uS2L'0\u0019;j_:D3aKAy\u0003%\"Xm\u001d;Qe>$WoY3s\u0013N$\u0006N]8ui2,Gm\u00165f]\u0012K7o[*qC\u000e,\u0017j\u001d'po\"\u001aA&!=\u0002\u001f5LG\u000e\\5t)>\u0004VM]2f]R$BA!+\u0003T\"9!Q[\u0017A\u0002\t%\u0016AB7jY2L7/\u0001\u0006nKR\u0014\u0018n\u0019+bON$bAa7\u0003^\n}\u0007\u0003CA\u0012\u0005K\u000b\t#!\t\t\u000f\u0005ua\u00061\u0001\u0002\"!9\u00111\u0007\u0018A\u0002\u0005\u0005\u0012A\u00038fo6+GO]5dgV\u0011!Q\u001d\t\u0005\u0005O\u001490\u0004\u0002\u0003j*!!1\u001eBw\u0003\u001diW\r\u001e:jGNTAAa<\u0003r\u000611m\\7n_:T1a\u0016Bz\u0015\u0011\u0011)P!\u0001\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\u0011IP!;\u0003\u000f5+GO]5dg\u0006QQk]3s\u00072LWM\u001c;\u0011\u0005eT5#\u0002&\u0004\u0002\r5\u0001#DB\u0002\u0007\u0013\t\t#!\t\u0002<\u0005m\u00020\u0004\u0002\u0004\u0006)\u00191qA9\u0002\u000fI,h\u000e^5nK&!11BB\u0003\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\t\u0005\u0007\u001f\u0019)\"\u0004\u0002\u0004\u0012)!11CA0\u0003\tIw.\u0003\u0003\u0002\u001a\rEAC\u0001B\u007f\u0003\u0015\t\u0007\u000f\u001d7z)%A8QDB\u0010\u0007C\u0019\u0019\u0003C\u0004\u0002\u001e5\u0003\r!!\t\t\u000f\u0005MR\n1\u0001\u0002\"!I\u0011qG'\u0011\u0002\u0003\u0007\u00111\b\u0005\n\u0003\u0007j\u0005\u0013!a\u0001\u0003w\tq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u00059QO\\1qa2LH\u0003BB\u0017\u0007k\u0001R\u0001]A\u001f\u0007_\u00012\u0002]B\u0019\u0003C\t\t#a\u000f\u0002<%\u001911G9\u0003\rQ+\b\u000f\\35\u0011!\u00199\u0004UA\u0001\u0002\u0004A\u0018a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0004")
public class ClientQuotaManagerTest
extends BaseClientQuotaManagerTest {
    private volatile ClientQuotaManagerTest$UserClient$ UserClient$module;
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0);
    private final AbstractQuotaChannelManager channelManager = (AbstractQuotaChannelManager)EasyMock.createMock(AbstractQuotaChannelManager.class);

    private ClientQuotaManagerTest$UserClient$ UserClient() {
        if (this.UserClient$module == null) {
            this.UserClient$lzycompute$1();
        }
        return this.UserClient$module;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private AbstractQuotaChannelManager channelManager() {
        return this.channelManager;
    }

    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(config, this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota(client2.configUser(), client2.configClientId(), client2.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)Long.MAX_VALUE, (double)clientQuotaManager.quota(randomClient.user(), randomClient.clientId()).bound(), (double)0.0, (String)new StringBuilder(33).append("Default producer quota should be ").append((double)Long.MAX_VALUE).toString());
            Assertions.assertEquals((double)2000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (2000)");
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client2.user(), client2.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (4000)");
            int throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 2500 * config.numQuotaSamples());
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            this.time().sleep((long)(throttleTimeMs + 1));
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assertions.assertEquals((double)3000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (3000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 0.0);
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the default value (500)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 600 * config.numQuotaSamples());
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            this.time().sleep((long)(throttleTimeMs + 1));
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)None$.MODULE$);
            clientQuotaManager.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), defaultConfigClient.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (4000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 1000 * config.numQuotaSamples());
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0);
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0);
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    private void checkQuota(ClientQuotaManager quotaManager, String user, String clientId, long expectedBound, int value, boolean expectThrottle) {
        Assertions.assertEquals((double)expectedBound, (double)quotaManager.quota(user, clientId).bound(), (double)0.0);
        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", user), InetAddress.getLocalHost());
        Assertions.assertEquals((double)(expectedBound < Long.MAX_VALUE ? (double)(this.config().quotaWindowSizeSeconds() * (this.config().numQuotaSamples() - 1)) * (double)expectedBound : Double.MAX_VALUE), (double)quotaManager.getMaxValueInQuotaWindow(session, clientId), (double)0.01);
        int throttleTimeMs = this.maybeRecord(quotaManager, user, clientId, value * this.config().numQuotaSamples());
        if (expectThrottle) {
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            return;
        }
        Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
    }

    @Test
    public void testGetMaxValueInQuotaWindowWithNonDefaultQuotaWindow() {
        int numFullQuotaWindows = 3;
        ClientQuotaManagerConfig nonDefaultConfig = new ClientQuotaManagerConfig(numFullQuotaWindows + 1, Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0);
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(nonDefaultConfig, this.metrics(), (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        RequestChannel.Session userSession = new RequestChannel.Session(new KafkaPrincipal("User", "userA"), InetAddress.getLocalHost());
        try {
            Assertions.assertEquals((double)Double.MAX_VALUE, (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            Assertions.assertEquals((double)(10 * numFullQuotaWindows), (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveDefaultUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserClientQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Defaults$.MODULE$.DefaultNumQuotaSamples(), Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), 9.223372036854776E18, 0L, 0), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(3000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 4500, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 4000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client3", 4000L, 0, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 0, false);
            this.checkQuota(clientQuotaManager, "userB", "client1", 7000L, 8000, true);
            this.checkQuota(clientQuotaManager, "userB", "client2", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userB", "client3", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userD", "client1", 3000L, 3500, true);
            this.checkQuota(clientQuotaManager, "userD", "client2", 3000L, 2500, false);
            this.checkQuota(clientQuotaManager, "userE", "client1", 3000L, 2500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userD", "client1", 1000L, 0, false);
            this.checkQuota(clientQuotaManager, "userE", "client4", 1000L, 1500, true);
            this.checkQuota(clientQuotaManager, "userF", "client4", 1000L, 800, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 1000L, 800, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userF", "client4", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 2500, true);
            this.checkQuota(clientQuotaManager, "userG", "client5", 2000L, 0, true);
            this.time().sleep(1000L);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 6000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 8000L, 0, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client6", 11000L, 8500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(12000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 12000L, 4000, true);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolation() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0));
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int throttleTime = this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 6550.0);
            Assertions.assertEquals((int)2100, (int)throttleTime, (String)"Should be throttled");
            this.throttle(clientQuotaManager, "ANONYMOUS", "unknown", throttleTime, this.callback());
            Assertions.assertEquals((int)1, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assertions.assertEquals((int)1, (int)this.numCallbacks());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0);
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 0.0), (String)"Should be unthrottled since bursty sample has rolled over");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolationWithMaxThrottleTime() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            int throttleTime = this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 200000.0);
            Assertions.assertEquals((long)ClientQuotaManager$.MODULE$.MaxThrottleTimeMs(), (long)throttleTime, (String)"Should be throttled");
            this.throttle(clientQuotaManager, "ANONYMOUS", "unknown", throttleTime, this.callback());
            Assertions.assertEquals((int)1, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assertions.assertEquals((int)1, (int)this.numCallbacks());
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireThrottleTimeSensor() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireQuotaSensors() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            this.metrics().removeSensor("Produce-ANONYMOUS:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Assertions.assertNotNull((Object)this.metrics().getSensor("ProduceThrottleTime-:client1"), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor("Produce-:client1"), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdNotSanitized() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        String clientId = "client@#$%";
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", clientId, 100.0);
            Assertions.assertNotNull((Object)this.metrics().getSensor(new StringBuilder(21).append("ProduceThrottleTime-:").append(clientId).toString()), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor(new StringBuilder(9).append("Produce-:").append(clientId).toString()), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testUniversalityOfActiveTenants() {
        Metrics metrics = this.newMetrics();
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 1L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        ClientRequestQuotaManager requestQuotaManager = new ClientRequestQuotaManager(this.config(), metrics, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        scala.collection.mutable.Set activeTenants = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            requestQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(quotaManager, "User1", "Client1", 100.0);
            activeTenants.$plus$eq(this.metricTags("", "Client1"));
            Assertions.assertEquals((Object)activeTenants, (Object)activeTenantsManager.getActiveTenants().toSet());
            this.maybeRecord((ClientQuotaManager)requestQuotaManager, "User3", "Client3", 100.0);
            activeTenants.$plus$eq(this.metricTags("", "Client3"));
            Assertions.assertEquals((Object)activeTenants, (Object)activeTenantsManager.getActiveTenants().toSet());
        }
        finally {
            quotaManager.shutdown();
            requestQuotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testFrequencyOfAutoTuneQuota() {
        Metrics metrics = this.newMetrics();
        BrokerBackpressureConfig x$1 = new BrokerBackpressureConfig(true, 1000L, (Seq)Nil$.MODULE$, Double.MAX_VALUE, (double)Predef$.MODULE$.Long2long(ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT), "p95");
        int x$32 = Defaults$.MODULE$.DefaultNumQuotaSamples();
        int x$42 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(x$32, x$42, x$1, x$5, 250.0, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBackpressure, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            Assertions.assertEquals((double)9.223372036854776E18, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
                this.time().sleep(100L);
            });
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
                this.time().sleep(100L);
            });
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testInactiveTenantsResetQuota() {
        Metrics metrics = this.newMetrics();
        BrokerBackpressureConfig x$1 = new BrokerBackpressureConfig(true, 1000L, (Seq)Nil$.MODULE$, Double.MAX_VALUE, (double)Predef$.MODULE$.Long2long(ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT), "p95");
        int x$3 = Defaults$.MODULE$.DefaultNumQuotaSamples();
        int x$4 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        DiskUsageBasedThrottlingConfig x$52 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(x$3, x$4, x$1, x$52, 250.0, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBackpressure, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            Assertions.assertEquals((double)9.223372036854776E18, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
                this.time().sleep(100L);
            });
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            this.time().sleep(11000L);
            this.maybeRecord(quotaManager, "", "", 300.0);
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)quotaManager.quota("", "Client1").bound()))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaAllAboveFairLimit() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 500.0, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client2", 300.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaAboveAndBelowFairLimit() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 500.0, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 350.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client2", 200.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaAllBelowFairLimit() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 500.0, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 200.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client2", 200.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)quotaManager.quota("", "Client1").bound())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)quotaManager.quota("", "Client2").bound()))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaMultipleTenants() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 500.0, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            Assertions.assertEquals((Object)quotaManager.quota("", "Client1"), (Object)quotaManager.dynamicQuota("", "Client1"));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertTrue((boolean)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.maybeRecord(quotaManager, "", "Client1", 250.0), this.maybeRecord(quotaManager, "", "Client2", 100.0), this.maybeRecord(quotaManager, "", "Client3", 200.0), this.maybeRecord(quotaManager, "", "Client4", 50.0)}))).forall((Function1)(JFunction1.mcZI.sp & Serializable)throttleTime -> throttleTime == 0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)175.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)150.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client3"), (Object)BoxesRunTime.boxToDouble((double)175.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client4"), (Object)BoxesRunTime.boxToDouble((double)125.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWithChangingBrokerQuotaLimit() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 250.0, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)0.0, (double)this.maybeRecord(quotaManager, "", "Client1", 300.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            quotaManager.setBrokerQuotaLimit(500.0);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
            quotaManager.setBrokerQuotaLimit(250.0);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWithChangingOriginalClientQuota() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 250.0, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)new Quota(300.0, true)));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)new Quota(200.0, true)));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)200.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWhenClientStopsSendingLoad() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 500.0, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 1000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 200.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            Assertions.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "C1").bound(), (double)0.0);
            Assertions.assertEquals((double)300.0, (double)quotaManager.dynamicQuota("", "C2").bound(), (double)0.0);
            int throttleTimeMs1 = this.maybeRecord(quotaManager, "", "C2", 400.0);
            this.time().sleep((long)Math.max(1000, throttleTimeMs1));
            quotaManager.maybeAutoTuneQuota();
            Assertions.assertEquals((double)500.0, (double)quotaManager.dynamicQuota("", "C1").bound(), (double)0.0);
            Assertions.assertEquals((double)500.0, (double)quotaManager.dynamicQuota("", "C2").bound(), (double)0.0);
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWhenClientUsageDecreasingAfterThrottled() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 500.0, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 350.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 200.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 350.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 190.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)310.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testQuotaReportingCallbackEnabled() {
        Metrics metrics = this.newMetrics();
        int x$2 = Defaults$.MODULE$.DefaultNumQuotaSamples();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        double x$6 = 9.223372036854776E18;
        int x$7 = 0;
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(x$2, x$3, x$4, x$5, x$6, 30000L, x$7);
        DynamicQuotaReportingRequestThread reportingRequestThread = (DynamicQuotaReportingRequestThread)EasyMock.createMock(DynamicQuotaReportingRequestThread.class);
        EasyMock.expect((Object)this.channelManager().getReportRequestThread()).andReturn((Object)reportingRequestThread).times(1);
        reportingRequestThread.schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.eq((long)config.consumptionReportingIntervalMs()));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{this.channelManager()});
        EasyMock.replay((Object[])new Object[]{reportingRequestThread});
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(config, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)new Some((Object)activeTenantsManager), (Option)new Some((Object)this.channelManager()));
        EasyMock.verify((Object[])new Object[]{this.channelManager()});
        EasyMock.verify((Object[])new Object[]{reportingRequestThread});
        quotaManager.shutdown();
    }

    @Test
    public void testQuotaReportingCallbackWithActiveConsumption() {
        Metrics metrics = this.newMetrics();
        int x$5 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(2, x$5, x$6, x$7, 100000.0, 1000L, 102400);
        DynamicQuotaReportingRequestThread reportingRequestThread = (DynamicQuotaReportingRequestThread)EasyMock.createMock(DynamicQuotaReportingRequestThread.class);
        EasyMock.expect((Object)this.channelManager().getReportRequestThread()).andReturn((Object)reportingRequestThread).times(1);
        reportingRequestThread.schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.anyLong());
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        ReportQuotaConsumptionRequestData.EntryData entryData = new ReportQuotaConsumptionRequestData.EntryData();
        entryData.setEntity(Arrays.asList(new ReportQuotaConsumptionRequestData.EntityData().setEntityType("user").setEntityName(""), new ReportQuotaConsumptionRequestData.EntityData().setEntityType("client-id").setEntityName("C1")));
        entryData.setConsumptions(Arrays.asList(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType("PRODUCE").setUsage(102400.0).setThrottled(false)));
        ReportQuotaConsumptionRequestData.EntryData entryData2 = new ReportQuotaConsumptionRequestData.EntryData();
        entryData2.setEntity(Arrays.asList(new ReportQuotaConsumptionRequestData.EntityData().setEntityType("user").setEntityName(""), new ReportQuotaConsumptionRequestData.EntityData().setEntityType("client-id").setEntityName("C2")));
        entryData2.setConsumptions(Arrays.asList(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType("PRODUCE").setUsage(160000.0).setThrottled(true)));
        reportingRequestThread.addEntryForNode(EasyMock.eq((Object)entryData));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        reportingRequestThread.addEntryForNode(EasyMock.eq((Object)entryData2));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        reportingRequestThread.wakeup();
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{this.channelManager()});
        EasyMock.replay((Object[])new Object[]{reportingRequestThread});
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(config, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), Option$.MODULE$.apply((Object)this.channelManager()));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(30000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(70000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(2.147483647E9, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 1000.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 100.0));
            int throttleTime = this.maybeRecord(quotaManager, "", "C2", 80000 * config.numQuotaSamples());
            Assertions.assertTrue((throttleTime > 0 ? 1 : 0) != 0);
            this.throttle(quotaManager, "", "C2", throttleTime, this.callback());
            quotaManager.quotaUsageReportingCallback();
            EasyMock.verify((Object[])new Object[]{this.channelManager()});
            EasyMock.verify((Object[])new Object[]{reportingRequestThread});
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    private void verifyDynamicQuotas(ClientQuotaManager quotaManager, Map<String, Object> expectedQuotasForClients) {
        expectedQuotasForClients.foreach((Function1 & Serializable)x0$1 -> {
            ClientQuotaManagerTest.$anonfun$verifyDynamicQuotas$1(quotaManager, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAutoTuningAllocatesBandwidthProportionalToQuota() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 1000.0, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(600.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(1400.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 600.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 800.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)700.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaForAllClients() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 1000.0, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 600.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 800.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)9.223372036854776E18)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)9.223372036854776E18))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaForSomeClients() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 1000.0, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 400.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)500.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)600.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)200.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaWithLowUsageClients() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 600.0, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(600.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(600.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 0.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)600.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)200.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)100.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaWithLowUsage() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 1000.0, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 100.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)9.223372036854776E18)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)9.223372036854776E18)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningHandlesZeroQuota() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 500.0, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(0.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(700.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 0.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 600.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)0.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningSortsByUtilization() {
        Metrics metrics = this.newMetrics();
        int x$3 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = 0L;
        int x$7 = 0;
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(2, x$3, x$4, x$5, 1000.0, x$6, x$7);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), (Option)None$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(1000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(500.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 300.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 400.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)500.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)300.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testProducerIsThrottledWhenDiskSpaceIsLow() {
        Path tempLogDir = Files.createTempDirectory("some-dir", new FileAttribute[0]);
        long diskThreshold = Long.MAX_VALUE;
        Metrics metrics = this.newMetrics();
        int throttledBandwidth = 300;
        long x$1 = throttledBandwidth;
        .colon.colon x$2 = new .colon.colon((Object)((Object)tempLogDir).toString(), (List)Nil$.MODULE$);
        long x$5 = 0x500000000L;
        double x$6 = 1.5;
        boolean x$7 = false;
        DiskUsageBasedThrottlingConfig qual$1 = DiskUsageBasedThrottlingConfig$.MODULE$.apply(x$5, x$1, (Seq)x$2, true, 1000L, x$6, x$7);
        Seq x$10 = qual$1.copy$default$3();
        boolean x$11 = qual$1.copy$default$4();
        long x$12 = qual$1.copy$default$5();
        double x$13 = qual$1.copy$default$6();
        boolean x$14 = qual$1.copy$default$7();
        DiskUsageBasedThrottlingConfig diskThrottlingConfig = qual$1.copy(diskThreshold, 300L, x$10, x$11, x$12, x$13, x$14);
        BrokerBackpressureConfig x$16 = new BrokerBackpressureConfig(false, BrokerBackpressureConfig$.MODULE$.DefaultBackpressureCheckFrequencyMs(), (Seq)Nil$.MODULE$, Double.MAX_VALUE, (double)Predef$.MODULE$.Long2long(ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT), "p95");
        int x$18 = Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
        double x$19 = 9.223372036854776E18;
        long x$20 = 0L;
        int x$21 = 0;
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(2, x$18, x$16, diskThrottlingConfig, x$19, x$20, x$21);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 1L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this, configWithBackpressure, metrics, activeTenantsManager){
            private final DiskThrottleListenerManager listenerManager;

            public DiskThrottleListenerManager listenerManager() {
                return this.listenerManager;
            }
            {
                QuotaType.Produce$ x$3 = QuotaType.Produce$.MODULE$;
                MockTime x$4 = $outer.time();
                Some x$6 = new Some((Object)activeTenantsManager$1);
                None$ x$7 = None$.MODULE$;
                None$ x$8 = None$.MODULE$;
                super(configWithBackpressure$1, metrics$1, (QuotaType)x$3, (Time)x$4, "", (Option)x$7, (Option)x$6, (Option)x$8);
                this.listenerManager = new DiskThrottleListenerManager(null){
                    private ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners;

                    public void registerListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.registerListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public void deRegisterListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.deRegisterListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public Set<DiskUsageBasedThrottleListener> getListeners() {
                        return DiskThrottleListenerManager.getListeners$((DiskThrottleListenerManager)this);
                    }

                    public boolean anyListenerIsThrottled() {
                        return DiskThrottleListenerManager.anyListenerIsThrottled$((DiskThrottleListenerManager)this);
                    }

                    public boolean diskThrottlingActive(DiskUsageBasedThrottleListener listener) {
                        return DiskThrottleListenerManager.diskThrottlingActive$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners() {
                        return this.kafka$server$DiskThrottleListenerManager$$listeners;
                    }

                    public final void kafka$server$DiskThrottleListenerManager$_setter_$kafka$server$DiskThrottleListenerManager$$listeners_$eq(ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> x$1) {
                        this.kafka$server$DiskThrottleListenerManager$$listeners = x$1;
                    }
                    {
                        DiskThrottleListenerManager.$init$((DiskThrottleListenerManager)this);
                        Statics.releaseFence();
                    }
                };
            }
        };
        quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(1000.0, true)));
        quotaManager.listenerManager().registerListener((DiskUsageBasedThrottleListener)quotaManager);
        Assertions.assertEquals((double)9.223372036854776E18, (double)quotaManager.getBrokerQuotaLimit(), (double)0.0);
        Assertions.assertFalse((boolean)quotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)quotaManager));
        Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "ANONYMOUS", "client1", 400.0));
        this.time().sleep(Math.max(configWithBackpressure.backpressureConfig().backpressureCheckFrequencyMs(), quotaManager.getCurrentDiskThrottlingConfig().diskCheckFrequencyMs()) + 1000L);
        Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "ANONYMOUS", "client1", 400.0));
        Assertions.assertEquals((double)throttledBandwidth, (double)quotaManager.getBrokerQuotaLimit(), (double)0.0);
        Assertions.assertTrue((boolean)quotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)quotaManager));
        Assertions.assertEquals((long)throttledBandwidth, (long)BoxesRunTime.unboxToLong((Object)((Option)quotaManager.lastSignalledQuotaOptRef().get()).get()));
        quotaManager.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)quotaManager);
    }

    public double millisToPercent(double millis) {
        return millis * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public Map<String, String> metricTags(String user, String clientId) {
        return (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)user), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)clientId)}));
    }

    public Metrics newMetrics() {
        return new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());
    }

    private final void UserClient$lzycompute$1() {
        synchronized (this) {
            if (this.UserClient$module == null) {
                this.UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$verifyDynamicQuotas$1(ClientQuotaManager quotaManager$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            String clientId = (String)x0$1._1();
            Assertions.assertEquals((double)x0$1._2$mcD$sp(), (double)quotaManager$3.dynamicQuota("", clientId).bound(), (double)0.1, (String)new StringBuilder(21).append("Unexpected quota for ").append(clientId).toString());
            return;
        }
        throw new MatchError(null);
    }

    private class UserClient
    implements Product,
    Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public Option<String> sanitizedConfigClientId() {
            return this.configClientId().map((Function1 & Serializable)x -> {
                String string = x;
                String string2 = ConfigEntityName$.MODULE$.Default();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return ConfigEntityName$.MODULE$.Default();
                }
                return Sanitizer.sanitize((String)x);
            });
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.user();
                }
                case 1: {
                    return this.clientId();
                }
                case 2: {
                    return this.configUser();
                }
                case 3: {
                    return this.configClientId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "user";
                }
                case 1: {
                    return "clientId";
                }
                case 2: {
                    return "configUser";
                }
                case 3: {
                    return "configClientId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof UserClient && ((UserClient)x$1).kafka$server$ClientQuotaManagerTest$UserClient$$$outer() == this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer())) break block3;
                    UserClient userClient = (UserClient)x$1;
                    String string = this.user();
                    String string2 = userClient.user();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                    String string3 = this.clientId();
                    String string4 = userClient.clientId();
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
                    Option<String> option = this.configUser();
                    Option<String> option2 = userClient.configUser();
                    if (option != null ? !option.equals(option2) : option2 != null) break block3;
                    Option<String> option3 = this.configClientId();
                    Option<String> option4 = userClient.configClientId();
                    if ((option3 != null ? !option3.equals(option4) : option4 != null) || !userClient.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

