/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.cluster.BrokerEndPoint;
import kafka.log.TierLogSegment;
import kafka.server.ConfluentReplicaFetcherTierStateMachine;
import kafka.server.FailedPartitions;
import kafka.server.Fetching$;
import kafka.server.InitialFetchState;
import kafka.server.MockFetcherThread;
import kafka.server.MockFetcherThread$;
import kafka.server.MockLeaderEndPoint;
import kafka.server.MockLeaderEndPoint$;
import kafka.server.MockTierStateMachine;
import kafka.server.MockTierStateMachine$;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionState;
import kafka.server.PartitionState$;
import kafka.server.TierOffsetInfo;
import kafka.server.TierOffsetInfo$;
import kafka.server.TierState;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.SegmentState;
import kafka.tier.store.TierObjectStore;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnknownLeaderEpochException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001B\t\u0013\u0001]AQA\b\u0001\u0005\u0002}AqA\t\u0001C\u0002\u0013\u00051\u0005\u0003\u0004(\u0001\u0001\u0006I\u0001\n\u0005\bQ\u0001\u0011\r\u0011\"\u0001*\u0011\u0019i\u0003\u0001)A\u0005U!)a\u0006\u0001C\u0005_!)q\n\u0001C\u0005!\")\u0001\r\u0001C\u0001C\")\u0001\u000f\u0001C\u0001C\")!\u000f\u0001C\u0001C\")A\u000f\u0001C\u0001C\")a\u000f\u0001C\u0001C\")\u0001\u0010\u0001C\u0001C\")!\u0010\u0001C\u0001C\")A\u0010\u0001C\u0001C\")a\u0010\u0001C\u0001C\nY3i\u001c8gYV,g\u000e\u001e*fa2L7-\u0019$fi\u000eDWM\u001d+jKJ\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f)\u0016\u001cHO\u0003\u0002\u0014)\u000511/\u001a:wKJT\u0011!F\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"!\t\u0001\u000e\u0003I\tq\u0002\u001e:v]\u000e\fG/Z(o\r\u0016$8\r[\u000b\u0002IA\u0011\u0011$J\u0005\u0003Mi\u0011qAQ8pY\u0016\fg.\u0001\tueVt7-\u0019;f\u001f:4U\r^2iA\u00059a/\u001a:tS>tW#\u0001\u0016\u0011\u0005eY\u0013B\u0001\u0017\u001b\u0005\u0015\u0019\u0006n\u001c:u\u0003!1XM]:j_:\u0004\u0013aB7l\u0005\u0006$8\r\u001b\u000b\u0005au\u0012u\t\u0005\u00022w5\t!G\u0003\u00024i\u00051!/Z2pe\u0012T!!\u000e\u001c\u0002\r\r|W.\\8o\u0015\t)rG\u0003\u00029s\u00051\u0011\r]1dQ\u0016T\u0011AO\u0001\u0004_J<\u0017B\u0001\u001f3\u0005-\u0011VmY8sI\n\u000bGo\u00195\t\u000by2\u0001\u0019A \u0002\u0015\t\f7/Z(gMN,G\u000f\u0005\u0002\u001a\u0001&\u0011\u0011I\u0007\u0002\u0005\u0019>tw\rC\u0003D\r\u0001\u0007A)A\u0006mK\u0006$WM]#q_\u000eD\u0007CA\rF\u0013\t1%DA\u0002J]RDQ\u0001\u0013\u0004A\u0002%\u000bqA]3d_J$7\u000fE\u0002\u001a\u00152K!a\u0013\u000e\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u00022\u001b&\u0011aJ\r\u0002\r'&l\u0007\u000f\\3SK\u000e|'\u000fZ\u0001\u0012S:LG/[1m\r\u0016$8\r[*uCR,G\u0003B)U;~\u0003\"!\t*\n\u0005M\u0013\"!E%oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uK\")Qk\u0002a\u0001-\u00069Ao\u001c9jG&#\u0007cA\rX3&\u0011\u0001L\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005i[V\"\u0001\u001b\n\u0005q#$\u0001B+vS\u0012DQAX\u0004A\u0002}\n1BZ3uG\"|eMZ:fi\")1i\u0002a\u0001\t\u00061B/Z:u)&,'/\u00138ji&\fG.\u001b>fI2{w\rF\u0001c!\tI2-\u0003\u0002e5\t!QK\\5uQ\tAa\r\u0005\u0002h]6\t\u0001N\u0003\u0002jU\u0006\u0019\u0011\r]5\u000b\u0005-d\u0017a\u00026va&$XM\u001d\u0006\u0003[f\nQA[;oSRL!a\u001c5\u0003\tQ+7\u000f^\u0001#i\u0016\u001cH\u000fV5feJ+G/\u001a8uS>t7\u000b^1si>3Gj\\4SK6|g/\u001a3)\u0005%1\u0017A\n;fgR$\u0016.\u001a:G_2dwn^3s\u001fZ,'\u000f\\1q\u0019\u0016\fG-\u001a:B]\u0012$\u0016.\u001a:fI\"\u0012!BZ\u0001 i\u0016\u001cHOR3uG\"$U\r\\3uK\u0012$\u0015\r^1XSRDG+[3sS:<\u0007FA\u0006g\u0003\u0001\"Xm\u001d;US\u0016\u0014H+[3sK\u00124u\u000e\u001c7po\u0016\u0014x)\u00199SKN$xN]3)\u000511\u0017\u0001\r;fgR$\u0016.\u001a:US\u0016\u0014X\r\u001a$pY2|w/\u001a:HCB\u0014Vm\u001d;pe\u0016|%M[3di&#'+Z2pm\u0016\u0014\u0018\u0010\u000b\u0002\u000eM\u0006YC/Z:u\u001f\u001a47/\u001a;US\u0016\u0014X\r\u001a'fC\u0012,'/\u00129pG\",\u0005pY3qi&|gNU3ue&,G\r\u000b\u0002\u000fM\u0006\tC/Z:u\u001b\u0006$XM]5bY&T\u0018\r^5p]\u0016C8-\u001a9uS>t'+\u001a;ss\"\u0012qBZ\u0001\u001ei\u0016\u001cH\u000fV5fe\u001a+Go\u00195fe\u0016C8-\u001a9uS>t'+\u001a;ss\"\u0012\u0001C\u001a")
public class ConfluentReplicaFetcherTierStateMachineTest {
    private final boolean truncateOnFetch;
    private final short version = ApiKeys.FETCH.latestVersion();

    public boolean truncateOnFetch() {
        return this.truncateOnFetch;
    }

    public short version() {
        return this.version;
    }

    /*
     * WARNING - void declaration
     */
    private RecordBatch mkBatch(long baseOffset, int leaderEpoch, scala.collection.immutable.Seq<SimpleRecord> records) {
        void withRecords_records;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        Object var5_5 = null;
        simpleRecordArray = null;
        return (RecordBatch)CollectionConverters$.MODULE$.IterableHasAsScala(MemoryRecords.withRecords((byte)2, (long)baseOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)leaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records).batches()).asScala().head();
    }

    private InitialFetchState initialFetchState(Option<Uuid> topicId, long fetchOffset, int leaderEpoch) {
        BrokerEndPoint x$2 = new BrokerEndPoint(0, "localhost", 9092);
        return new InitialFetchState(topicId, x$2, leaderEpoch, fetchOffset);
    }

    @Test
    public void testTierInitializedLog() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint leader = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockFetcherThread fetcher = new MockFetcherThread(leader, new MockTierStateMachine(leader, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2()), 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 0L, 0))})));
        PartitionState leaderState = PartitionState$.MODULE$.apply((scala.collection.immutable.Seq<RecordBatch>)Nil$.MODULE$, 0, 0L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)fetcher.fetchState(partition).get()).state());
    }

    @Test
    public void testTierRetentionStartOfLogRemoved() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint leader = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockFetcherThread fetcher = new MockFetcherThread(leader, new MockTierStateMachine(null, leader){

            public CompletableFuture<TierState> fetchTierState(TopicPartition topicPartition, TierLogSegment tierSegment) {
                throw new Exception("should not fetch state");
            }
        }, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        int leaderEpoch = 0;
        long leaderStart = 55L;
        .colon.colon leaderLog = new .colon.colon((Object)this.mkBatch(leaderStart, leaderEpoch, (scala.collection.immutable.Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$);
        PartitionState replicaState = PartitionState$.MODULE$.apply(0);
        replicaState.logStartOffset_$eq(55L);
        replicaState.logEndOffset_$eq(55L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 55L, 0))})));
        PartitionState leaderState = PartitionState$.MODULE$.apply((scala.collection.immutable.Seq<RecordBatch>)leaderLog, 0, 56L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)55L, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        fetcher.doWork();
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)fetcher.fetchState(partition).get()).state());
        Assertions.assertEquals((long)56L, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
    }

    @Test
    public void testTierFollowerOverlapLeaderAndTiered() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint leader = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockFetcherThread fetcher = new MockFetcherThread(leader, new MockTierStateMachine(leader, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2()), 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 41L, 0))})));
        .colon.colon leaderLog = new .colon.colon((Object)this.mkBatch(41L, 0, (scala.collection.immutable.Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(79L, 0, (scala.collection.immutable.Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)Nil$.MODULE$));
        PartitionState leaderState = PartitionState$.MODULE$.apply((scala.collection.immutable.Seq<RecordBatch>)leaderLog, 0, 80L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        .colon.colon replicaLog = new .colon.colon((Object)this.mkBatch(1L, 0, (scala.collection.immutable.Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(39L, 0, (scala.collection.immutable.Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes()), new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$));
        PartitionState followerState = PartitionState$.MODULE$.apply((scala.collection.immutable.Seq<RecordBatch>)replicaLog, 0, 41L, false);
        fetcher.setReplicaState(partition, followerState);
        Assertions.assertEquals((long)41L, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        fetcher.doWork();
        Assertions.assertEquals((long)43L, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assertions.assertEquals((long)43L, (long)followerState.logEndOffset());
    }

    @Test
    public void testFetchDeletedDataWithTiering() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("topic", UUID.randomUUID(), 0);
        TopicPartition partition = topicIdPartition.topicPartition();
        MockLeaderEndPoint leader = new MockLeaderEndPoint(this, partition){
            private final TopicPartition partition$1;

            public TierOffsetInfo fetchTierMaterializationTarget(TopicPartition topicPartition, int leaderEpoch) {
                throw new Exception("Must not attempt to use tier list offset request");
            }

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                if (((FetchRequest.PartitionData)fetchRequest.fetchData().get((Object)this.partition$1)).fetchOffset >= 100L) {
                    return super.fetch(fetchRequest);
                }
                return CollectionConverters$.MODULE$.MapHasAsScala(fetchRequest.fetchData()).asScala().map((Function1 & Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        TopicPartition partition = (TopicPartition)x0$1._1();
                        MemoryRecords memoryRecords = MemoryRecords.EMPTY;
                        Errors errors = Errors.OFFSET_OUT_OF_RANGE;
                        PartitionState leaderState = this.leaderPartitionState(partition);
                        FetchResponseData.PartitionData fetchData = new FetchResponseData.PartitionData().setPartitionIndex(partition.partition()).setHighWatermark(leaderState.highWatermark()).setLastStableOffset(leaderState.highWatermark()).setLogStartOffset(leaderState.logStartOffset()).setRecords((BaseRecords)memoryRecords).setErrorCode(errors.code());
                        return new Tuple2((Object)partition, (Object)fetchData);
                    }
                    throw new MatchError(null);
                }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            {
                this.partition$1 = partition$1;
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fetch$1(kafka.server.ConfluentReplicaFetcherTierStateMachineTest$$anon$2 scala.Tuple2 )}, serializedLambda);
            }
        };
        MockFetcherThread fetcher = new MockFetcherThread(leader, new MockTierStateMachine(null, leader){

            public CompletableFuture<TierState> fetchTierState(TopicPartition topicPartition, TierLogSegment tierSegment) {
                throw new Exception("Must not fetch tier state");
            }
        }, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        int leaderEpoch = 1;
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(leaderEpoch));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)topicIdPartition.kafkaTopicId()), 21L, leaderEpoch))})));
        .colon.colon leaderLog = new .colon.colon((Object)this.mkBatch(100L, leaderEpoch, (scala.collection.immutable.Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(120L, leaderEpoch, (scala.collection.immutable.Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes()), new SimpleRecord("c".getBytes()), new SimpleRecord("d".getBytes()), new SimpleRecord("e".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(139L, leaderEpoch, (scala.collection.immutable.Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("f".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((scala.collection.immutable.Seq<RecordBatch>)leaderLog, leaderEpoch, 139L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertEquals((long)100L, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        fetcher.doWork();
        Assertions.assertTrue((((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset() > 100L ? 1 : 0) != 0);
    }

    @Test
    public void testTierTieredFollowerGapRestore() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("topic", UUID.randomUUID(), 0);
        TopicPartition partition = topicIdPartition.topicPartition();
        CompletableFuture<TierLogSegment> promise = new CompletableFuture<TierLogSegment>();
        CompletableFuture<TierState> stateFuture = new CompletableFuture<TierState>();
        MockLeaderEndPoint leader = new MockLeaderEndPoint(this, promise){
            private final CompletableFuture promise$1;

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                if (this.promise$1.isDone()) {
                    return super.fetch(fetchRequest);
                }
                return CollectionConverters$.MODULE$.MapHasAsScala(fetchRequest.fetchData()).asScala().map((Function1 & Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        TopicPartition partition = (TopicPartition)x0$1._1();
                        MemoryRecords memoryRecords = MemoryRecords.EMPTY;
                        Errors errors = Errors.OFFSET_TIERED;
                        PartitionState leaderState = this.leaderPartitionState(partition);
                        FetchResponseData.PartitionData fetchData = new FetchResponseData.PartitionData().setPartitionIndex(partition.partition()).setHighWatermark(leaderState.highWatermark()).setLastStableOffset(leaderState.highWatermark()).setLogStartOffset(leaderState.logStartOffset()).setRecords((BaseRecords)memoryRecords).setErrorCode(errors.code());
                        return new Tuple2((Object)partition, (Object)fetchData);
                    }
                    throw new MatchError(null);
                }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            {
                this.promise$1 = promise$1;
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fetch$2(kafka.server.ConfluentReplicaFetcherTierStateMachineTest$$anon$4 scala.Tuple2 )}, serializedLambda);
            }
        };
        MockFetcherThread fetcher = new MockFetcherThread(leader, new MockTierStateMachine(null, leader, stateFuture, promise){
            private final CompletableFuture stateFuture$1;
            private final CompletableFuture promise$1;

            public CompletableFuture<TierState> fetchTierState(TopicPartition topicPartition, TierLogSegment tierSegment) {
                return this.stateFuture$1;
            }

            public Future<TierLogSegment> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
                return this.promise$1;
            }
            {
                this.stateFuture$1 = stateFuture$1;
                this.promise$1 = promise$1;
                super(leader$3, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
            }
        }, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        int leaderEpoch = 1;
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(leaderEpoch));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)topicIdPartition.kafkaTopicId()), 21L, leaderEpoch))})));
        .colon.colon leaderLog = new .colon.colon((Object)this.mkBatch(40L, leaderEpoch, (scala.collection.immutable.Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(50L, leaderEpoch, (scala.collection.immutable.Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes()), new SimpleRecord("c".getBytes()), new SimpleRecord("d".getBytes()), new SimpleRecord("e".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(79L, leaderEpoch, (scala.collection.immutable.Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("f".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((scala.collection.immutable.Seq<RecordBatch>)leaderLog, leaderEpoch, 80L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertTrue((boolean)(((PartitionFetchState)fetcher.fetchState(partition).get()).state() instanceof ConfluentReplicaFetcherTierStateMachine.MaterializingTierMetadata));
        fetcher.doWork();
        Assertions.assertTrue((boolean)(((PartitionFetchState)fetcher.fetchState(partition).get()).state() instanceof ConfluentReplicaFetcherTierStateMachine.MaterializingTierMetadata));
        promise.complete(new TierLogSegment(topicIdPartition, new SegmentState(leaderEpoch, UUID.randomUUID(), 40L, 40L, 49L, 0L, 100L, 100, TierObjectMetadata.State.SEGMENT_UPLOAD_INITIATE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, TierObjectMetadata.State.INVALID, 99L)));
        fetcher.doWork();
        Assertions.assertTrue((boolean)(((PartitionFetchState)fetcher.fetchState(partition).get()).state() instanceof ConfluentReplicaFetcherTierStateMachine.FetchingTierState));
        fetcher.doWork();
        Assertions.assertTrue((boolean)(((PartitionFetchState)fetcher.fetchState(partition).get()).state() instanceof ConfluentReplicaFetcherTierStateMachine.FetchingTierState));
        .colon.colon apply_leaderEpochState = new .colon.colon((Object)new EpochEntry(1, 0L), (List)Nil$.MODULE$);
        Object var10_10 = null;
        stateFuture.complete(new TierState((Seq)apply_leaderEpochState, (Option)None$.MODULE$));
        fetcher.doWork();
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)fetcher.fetchState(partition).get()).state());
        Assertions.assertEquals((long)50L, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        fetcher.doWork();
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)fetcher.fetchState(partition).get()).state());
        Assertions.assertEquals((long)55L, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)fetcher.fetchState(partition).get()).state());
    }

    @Test
    public void testTierTieredFollowerGapRestoreObjectIdRecovery() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("topic", UUID.randomUUID(), 0);
        TopicPartition partition = topicIdPartition.topicPartition();
        CompletableFuture<TierLogSegment> promise = new CompletableFuture<TierLogSegment>();
        CompletableFuture<TierState> stateFuture = new CompletableFuture<TierState>();
        UUID restoreObjectId = UUID.randomUUID();
        int restoreEpoch = 100;
        MockLeaderEndPoint leader = new MockLeaderEndPoint(this, promise, restoreObjectId, restoreEpoch){
            private final CompletableFuture promise$2;
            private final UUID restoreObjectId$1;
            private final int restoreEpoch$1;

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                if (this.promise$2.isDone()) {
                    return super.fetch(fetchRequest);
                }
                return CollectionConverters$.MODULE$.MapHasAsScala(fetchRequest.fetchData()).asScala().map((Function1 & Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        TopicPartition partition = (TopicPartition)x0$1._1();
                        MemoryRecords memoryRecords = MemoryRecords.EMPTY;
                        Errors errors = Errors.OFFSET_TIERED;
                        PartitionState leaderState = this.leaderPartitionState(partition);
                        FetchResponseData.PartitionData fetchData = new FetchResponseData.PartitionData().setPartitionIndex(partition.partition()).setErrorCode(errors.code()).setHighWatermark(leaderState.highWatermark()).setLastStableOffset(leaderState.highWatermark()).setLogStartOffset(leaderState.logStartOffset()).setRecords((BaseRecords)memoryRecords);
                        return new Tuple2((Object)partition, (Object)fetchData);
                    }
                    throw new MatchError(null);
                }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }

            public TierOffsetInfo fetchTierMaterializationTarget(TopicPartition topicPartition, int leaderEpoch) {
                OffsetAndEpoch offsetAndEpoch = this.fetchEarliestOffset(topicPartition, leaderEpoch);
                return TierOffsetInfo$.MODULE$.apply(offsetAndEpoch.offset(), this.restoreObjectId$1, this.restoreEpoch$1);
            }
            {
                this.promise$2 = promise$2;
                this.restoreObjectId$1 = restoreObjectId$1;
                this.restoreEpoch$1 = restoreEpoch$1;
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fetch$3(kafka.server.ConfluentReplicaFetcherTierStateMachineTest$$anon$6 scala.Tuple2 )}, serializedLambda);
            }
        };
        MockFetcherThread fetcher = new MockFetcherThread(leader, new MockTierStateMachine(null, leader, stateFuture, promise){
            private final CompletableFuture stateFuture$2;
            private final CompletableFuture promise$2;

            public CompletableFuture<TierState> fetchTierState(TopicPartition topicPartition, TierLogSegment tierSegment) {
                return this.stateFuture$2;
            }

            public Future<TierLogSegment> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
                throw new IllegalAccessError("Should not have been called as OffsetFromLeader with objectId will be found");
            }

            public Future<TierLogSegment> materializeTierStateUntilObjectId(TopicPartition topicPartition, long targetOffset, UUID targetObjectId, int targetRestoreEpoch) {
                return this.promise$2;
            }
            {
                this.stateFuture$2 = stateFuture$2;
                this.promise$2 = promise$2;
                super(leader$4, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
            }
        }, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        int leaderEpoch = 1;
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(leaderEpoch));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)topicIdPartition.kafkaTopicId()), 21L, leaderEpoch))})));
        .colon.colon leaderLog = new .colon.colon((Object)this.mkBatch(40L, leaderEpoch, (scala.collection.immutable.Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(50L, leaderEpoch, (scala.collection.immutable.Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes()), new SimpleRecord("c".getBytes()), new SimpleRecord("d".getBytes()), new SimpleRecord("e".getBytes())})), (List)new .colon.colon((Object)this.mkBatch(79L, leaderEpoch, (scala.collection.immutable.Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("f".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((scala.collection.immutable.Seq<RecordBatch>)leaderLog, leaderEpoch, 80L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertTrue((boolean)(((PartitionFetchState)fetcher.fetchState(partition).get()).state() instanceof ConfluentReplicaFetcherTierStateMachine.MaterializingTierMetadata));
        fetcher.doWork();
        Assertions.assertTrue((boolean)(((PartitionFetchState)fetcher.fetchState(partition).get()).state() instanceof ConfluentReplicaFetcherTierStateMachine.MaterializingTierMetadata));
        promise.complete(new TierLogSegment(topicIdPartition, new SegmentState(leaderEpoch, UUID.randomUUID(), 20L, 20L, 30L, 0L, 100L, 100, TierObjectMetadata.State.SEGMENT_UPLOAD_INITIATE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, TierObjectMetadata.State.INVALID, -1L)));
        fetcher.doWork();
        Assertions.assertTrue((boolean)(((PartitionFetchState)fetcher.fetchState(partition).get()).state() instanceof ConfluentReplicaFetcherTierStateMachine.FetchingTierState));
        fetcher.doWork();
        Assertions.assertTrue((boolean)(((PartitionFetchState)fetcher.fetchState(partition).get()).state() instanceof ConfluentReplicaFetcherTierStateMachine.FetchingTierState));
        .colon.colon apply_leaderEpochState = new .colon.colon((Object)new EpochEntry(1, 0L), (List)Nil$.MODULE$);
        Object var12_12 = null;
        stateFuture.complete(new TierState((Seq)apply_leaderEpochState, (Option)None$.MODULE$));
        fetcher.doWork();
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)fetcher.fetchState(partition).get()).state());
        Assertions.assertEquals((long)40L, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        fetcher.doWork();
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)fetcher.fetchState(partition).get()).state());
        Assertions.assertEquals((long)42L, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)fetcher.fetchState(partition).get()).state());
    }

    @Test
    public void testOffsetTieredLeaderEpochExceptionRetried() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("topic", UUID.randomUUID(), 0);
        TopicPartition partition = topicIdPartition.topicPartition();
        AtomicInteger tries = new AtomicInteger(0);
        CompletableFuture stateFuture = new CompletableFuture();
        MockLeaderEndPoint leader = new MockLeaderEndPoint(this, tries){
            private final AtomicInteger tries$1;

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                return CollectionConverters$.MODULE$.MapHasAsScala(fetchRequest.fetchData()).asScala().map((Function1 & Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        TopicPartition partition = (TopicPartition)x0$1._1();
                        MemoryRecords memoryRecords = MemoryRecords.EMPTY;
                        Errors errors = Errors.OFFSET_TIERED;
                        PartitionState leaderState = this.leaderPartitionState(partition);
                        FetchResponseData.PartitionData fetchData = new FetchResponseData.PartitionData().setPartitionIndex(partition.partition()).setErrorCode(errors.code()).setHighWatermark(leaderState.highWatermark()).setLastStableOffset(leaderState.highWatermark()).setLogStartOffset(leaderState.logStartOffset()).setRecords((BaseRecords)memoryRecords);
                        return new Tuple2((Object)partition, (Object)fetchData);
                    }
                    throw new MatchError(null);
                }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }

            public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int leaderEpoch) {
                if (this.tries$1.getAndIncrement() == 0) {
                    throw new UnknownLeaderEpochException("Unexpected leader epoch");
                }
                return super.fetchEarliestOffset(topicPartition, leaderEpoch);
            }
            {
                this.tries$1 = tries$1;
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fetch$4(kafka.server.ConfluentReplicaFetcherTierStateMachineTest$$anon$8 scala.Tuple2 )}, serializedLambda);
            }
        };
        MockFetcherThread fetcher = new MockFetcherThread(leader, new MockTierStateMachine(null, leader, stateFuture){
            private final CompletableFuture stateFuture$3;

            public CompletableFuture<TierState> fetchTierState(TopicPartition topicPartition, TierLogSegment tierLogSegment) {
                return this.stateFuture$3;
            }

            public Future<TierLogSegment> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
                return new CompletableFuture<TierLogSegment>();
            }
            {
                this.stateFuture$3 = stateFuture$3;
                super(leader$5, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
            }
        }, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)topicIdPartition.kafkaTopicId()), 0L, 0))})));
        RecordBatch batch = this.mkBatch(10L, 0, (scala.collection.immutable.Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes()), new SimpleRecord("c".getBytes()), new SimpleRecord("d".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((scala.collection.immutable.Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 20L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)fetcher.fetchState(partition).get()).state(), (String)"Should be set back to fetching state after hitting unknown leader epoch exception on trying to get start offset");
        fetcher.doWork();
        Assertions.assertTrue((boolean)(((PartitionFetchState)fetcher.fetchState(partition).get()).state() instanceof ConfluentReplicaFetcherTierStateMachine.MaterializingTierMetadata), (String)"On second try, no unexpected leader epoch exception will be hit, and state should move to materializing");
    }

    @Test
    public void testMaterializationExceptionRetry() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("topic", UUID.randomUUID(), 0);
        TopicPartition partition = topicIdPartition.topicPartition();
        CompletableFuture promise = new CompletableFuture();
        CompletableFuture<TierLogSegment> promiseSuccessful = new CompletableFuture<TierLogSegment>();
        CompletableFuture<TierState> stateFuture = new CompletableFuture<TierState>();
        MockLeaderEndPoint leader = new MockLeaderEndPoint(this, promiseSuccessful){
            private final CompletableFuture promiseSuccessful$1;

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                if (this.promiseSuccessful$1.isDone()) {
                    return super.fetch(fetchRequest);
                }
                return CollectionConverters$.MODULE$.MapHasAsScala(fetchRequest.fetchData()).asScala().map((Function1 & Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        TopicPartition partition = (TopicPartition)x0$1._1();
                        MemoryRecords memoryRecords = MemoryRecords.EMPTY;
                        Errors errors = Errors.OFFSET_TIERED;
                        PartitionState leaderState = this.leaderPartitionState(partition);
                        FetchResponseData.PartitionData fetchData = new FetchResponseData.PartitionData().setPartitionIndex(partition.partition()).setErrorCode(errors.code()).setHighWatermark(leaderState.highWatermark()).setLastStableOffset(leaderState.highWatermark()).setLogStartOffset(leaderState.logStartOffset()).setRecords((BaseRecords)memoryRecords);
                        return new Tuple2((Object)partition, (Object)fetchData);
                    }
                    throw new MatchError(null);
                }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            {
                this.promiseSuccessful$1 = promiseSuccessful$1;
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fetch$5(kafka.server.ConfluentReplicaFetcherTierStateMachineTest$$anon$10 scala.Tuple2 )}, serializedLambda);
            }
        };
        MockFetcherThread fetcher = new MockFetcherThread(leader, new MockTierStateMachine(null, leader, stateFuture, promise, promiseSuccessful){
            private boolean isFirstMaterializeCall;
            private final CompletableFuture stateFuture$4;
            private final CompletableFuture promise$3;
            private final CompletableFuture promiseSuccessful$1;

            private boolean isFirstMaterializeCall() {
                return this.isFirstMaterializeCall;
            }

            private void isFirstMaterializeCall_$eq(boolean x$1) {
                this.isFirstMaterializeCall = x$1;
            }

            public CompletableFuture<TierState> fetchTierState(TopicPartition topicPartition, TierLogSegment tierLogSegment) {
                return this.stateFuture$4;
            }

            public Future<TierLogSegment> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
                if (this.isFirstMaterializeCall()) {
                    this.isFirstMaterializeCall_$eq(false);
                    return this.promise$3;
                }
                return this.promiseSuccessful$1;
            }
            {
                this.stateFuture$4 = stateFuture$4;
                this.promise$3 = promise$3;
                this.promiseSuccessful$1 = promiseSuccessful$1;
                super(leader$6, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
                this.isFirstMaterializeCall = true;
            }
        }, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)topicIdPartition.kafkaTopicId()), 0L, 0))})));
        RecordBatch batch = this.mkBatch(10L, 0, (scala.collection.immutable.Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes()), new SimpleRecord("c".getBytes()), new SimpleRecord("d".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((scala.collection.immutable.Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 20L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertTrue((boolean)(((PartitionFetchState)fetcher.fetchState(partition).get()).state() instanceof ConfluentReplicaFetcherTierStateMachine.MaterializingTierMetadata));
        fetcher.doWork();
        Assertions.assertTrue((boolean)(((PartitionFetchState)fetcher.fetchState(partition).get()).state() instanceof ConfluentReplicaFetcherTierStateMachine.MaterializingTierMetadata));
        promise.completeExceptionally(new Exception("Failure"));
        fetcher.doWork();
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)fetcher.fetchState(partition).get()).state(), (String)"Should start trying to fetch again, in order to get offset tiered exception");
        fetcher.doWork();
        Assertions.assertTrue((boolean)(((PartitionFetchState)fetcher.fetchState(partition).get()).state() instanceof ConfluentReplicaFetcherTierStateMachine.MaterializingTierMetadata), (String)"should be trying to materialize state again");
        promiseSuccessful.complete(new TierLogSegment(topicIdPartition, new SegmentState(0, UUID.randomUUID(), 9L, 9L, 10L, 0L, 100L, 100, TierObjectMetadata.State.SEGMENT_UPLOAD_INITIATE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, TierObjectMetadata.State.INVALID, -1L)));
        fetcher.doWork();
        Assertions.assertTrue((boolean)(((PartitionFetchState)fetcher.fetchState(partition).get()).state() instanceof ConfluentReplicaFetcherTierStateMachine.FetchingTierState));
        fetcher.doWork();
        Assertions.assertTrue((boolean)(((PartitionFetchState)fetcher.fetchState(partition).get()).state() instanceof ConfluentReplicaFetcherTierStateMachine.FetchingTierState));
        Nil$ apply_leaderEpochState = Nil$.MODULE$;
        Object var10_10 = null;
        stateFuture.complete(new TierState((Seq)apply_leaderEpochState, (Option)None$.MODULE$));
        fetcher.doWork();
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)fetcher.fetchState(partition).get()).state());
        fetcher.doWork();
        Assertions.assertEquals((long)11L, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)fetcher.fetchState(partition).get()).state());
    }

    @Test
    public void testTierFetcherExceptionRetry() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("topic", UUID.randomUUID(), 0);
        TopicPartition partition = topicIdPartition.topicPartition();
        CompletableFuture<TierLogSegment> materialization1 = new CompletableFuture<TierLogSegment>();
        CompletableFuture tierStateFut = new CompletableFuture();
        MockLeaderEndPoint leader = new MockLeaderEndPoint(this){

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                return CollectionConverters$.MODULE$.MapHasAsScala(fetchRequest.fetchData()).asScala().map((Function1 & Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        TopicPartition partition = (TopicPartition)x0$1._1();
                        MemoryRecords memoryRecords = MemoryRecords.EMPTY;
                        Errors errors = Errors.OFFSET_TIERED;
                        PartitionState leaderState = this.leaderPartitionState(partition);
                        FetchResponseData.PartitionData fetchData = new FetchResponseData.PartitionData().setPartitionIndex(partition.partition()).setErrorCode(errors.code()).setHighWatermark(leaderState.highWatermark()).setLastStableOffset(leaderState.highWatermark()).setLogStartOffset(leaderState.logStartOffset()).setRecords((BaseRecords)memoryRecords);
                        return new Tuple2((Object)partition, (Object)fetchData);
                    }
                    throw new MatchError(null);
                }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$fetch$6(kafka.server.ConfluentReplicaFetcherTierStateMachineTest$$anon$12 scala.Tuple2 )}, serializedLambda);
            }
        };
        MockFetcherThread fetcher = new MockFetcherThread(leader, new MockTierStateMachine(null, leader, tierStateFut, materialization1){
            private boolean isFirstMaterializeCall;
            private final CompletableFuture tierStateFut$1;
            private final CompletableFuture materialization1$1;

            private boolean isFirstMaterializeCall() {
                return this.isFirstMaterializeCall;
            }

            private void isFirstMaterializeCall_$eq(boolean x$1) {
                this.isFirstMaterializeCall = x$1;
            }

            public CompletableFuture<TierState> fetchTierState(TopicPartition topicPartition, TierLogSegment tierLogSegment) {
                return this.tierStateFut$1;
            }

            public Future<TierLogSegment> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
                if (this.isFirstMaterializeCall()) {
                    this.isFirstMaterializeCall_$eq(false);
                    return this.materialization1$1;
                }
                return new CompletableFuture<TierLogSegment>();
            }
            {
                this.tierStateFut$1 = tierStateFut$1;
                this.materialization1$1 = materialization1$1;
                super(leader$7, MockTierStateMachine$.MODULE$.$lessinit$greater$default$2());
                this.isFirstMaterializeCall = true;
            }
        }, 0, 1, MockFetcherThread$.MODULE$.$lessinit$greater$default$5(), new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)topicIdPartition.kafkaTopicId()), 0L, 0))})));
        RecordBatch batch = this.mkBatch(10L, 0, (scala.collection.immutable.Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes()), new SimpleRecord("c".getBytes()), new SimpleRecord("d".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((scala.collection.immutable.Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 20L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.mockTierStateMachine().setRestoreTierStateCallback((Function2<TopicPartition, Object, BoxedUnit>)(Function2 & Serializable)(topicPartition, proposedLocalLogStart) -> {
            fetcher.restoreTierState(topicPartition, BoxesRunTime.unboxToLong((Object)proposedLocalLogStart));
            return BoxedUnit.UNIT;
        });
        fetcher.doWork();
        Assertions.assertTrue((boolean)(((PartitionFetchState)fetcher.fetchState(partition).get()).state() instanceof ConfluentReplicaFetcherTierStateMachine.MaterializingTierMetadata));
        materialization1.complete(new TierLogSegment(topicIdPartition, new SegmentState(0, UUID.randomUUID(), 9L, 9L, 10L, 0L, 100L, 100, TierObjectMetadata.State.SEGMENT_UPLOAD_INITIATE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, TierObjectMetadata.State.INVALID, 1L)));
        fetcher.doWork();
        Assertions.assertTrue((boolean)(((PartitionFetchState)fetcher.fetchState(partition).get()).state() instanceof ConfluentReplicaFetcherTierStateMachine.FetchingTierState));
        tierStateFut.completeExceptionally(new Exception("Failed to fetch tier state."));
        fetcher.doWork();
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)fetcher.fetchState(partition).get()).state(), (String)"state should be back to Fetching again after failure to fetch tier state. This will cause us to restart the whole init process again");
        fetcher.doWork();
        Assertions.assertTrue((boolean)(((PartitionFetchState)fetcher.fetchState(partition).get()).state() instanceof ConfluentReplicaFetcherTierStateMachine.MaterializingTierMetadata), (String)"back to tier materializing state");
    }

    public ConfluentReplicaFetcherTierStateMachineTest() {
        this.truncateOnFetch = true;
    }
}

