/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import kafka.server.ControllerConfigurationValidator;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ea\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u00040\u0001\u0001\u0006I\u0001\f\u0005\u0006a\u0001!\t!\r\u0005\u0006\u0005\u0002!\t!\r\u0005\u0006\t\u0002!\t!\r\u0005\u0006\r\u0002!\t!\r\u0005\u0006\u0011\u0002!\t!\r\u0005\u0006\u0015\u0002!\t!\r\u0005\u0006\u0019\u0002!\t!\r\u0005\u0006\u001d\u0002!\t!\r\u0005\u0006!\u0002!\t!\r\u0005\u0006%\u0002!\t!\r\u0005\u0006)\u0002!I!\u0016\u0005\u0006[\u0002!\t!\r\u0005\u0006_\u0002!\t!\r\u0005\u0006c\u0002!\t!\r\u0005\u0006g\u0002!\t!\r\u0005\u0006k\u0002!\t!\r\u0005\u0006o\u0002!\t!\r\u0005\u0006s\u0002!\t!\r\u0005\u0006w\u0002!\t!\r\u0005\u0006{\u0002!IA \u0005\u0007{\u0002!I!a\u0004\u0003I\r{g\u000e\u001e:pY2,'oQ8oM&<WO]1uS>tg+\u00197jI\u0006$xN\u001d+fgRT!a\u0007\u000f\u0002\rM,'O^3s\u0015\u0005i\u0012!B6bM.\f7\u0001A\n\u0003\u0001\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001)!\tI\u0003!D\u0001\u001b\u0003%1\u0018\r\\5eCR|'/F\u0001-!\tIS&\u0003\u0002/5\t\u00013i\u001c8ue>dG.\u001a:D_:4\u0017nZ;sCRLwN\u001c,bY&$\u0017\r^8s\u0003)1\u0018\r\\5eCR|'\u000fI\u0001#i\u0016\u001cH\u000fR3gCVdG\u000fV8qS\u000e\u0014Vm]8ve\u000e,\u0017j\u001d*fU\u0016\u001cG/\u001a3\u0015\u0003I\u0002\"!I\u001a\n\u0005Q\u0012#\u0001B+oSRD#\u0001\u0002\u001c\u0011\u0005]\u0002U\"\u0001\u001d\u000b\u0005eR\u0014aA1qS*\u00111\bP\u0001\bUV\u0004\u0018\u000e^3s\u0015\tid(A\u0003kk:LGOC\u0001@\u0003\ry'oZ\u0005\u0003\u0003b\u0012A\u0001V3ti\u0006aB/Z:u\u0013:4\u0018\r\\5e)>\u0004\u0018n\u0019(b[\u0016\u0014VM[3di\u0016$\u0007FA\u00037\u0003]!Xm\u001d;V].twn\u001e8SKN|WO]2f)f\u0004X\r\u000b\u0002\u0007m\u0005AB/Z:u\u001dVdG\u000eV8qS\u000e\u001cuN\u001c4jOZ\u000bG.^3)\u0005\u001d1\u0014\u0001\u0006;fgR4\u0016\r\\5e)>\u0004\u0018nY\"p]\u001aLw\r\u000b\u0002\tm\u00051B/Z:u\u0013:4\u0018\r\\5e)>\u0004\u0018nY\"p]\u001aLw\r\u000b\u0002\nm\u0005\tC/Z:u\u0013:4\u0018\r\\5e'\u000eDW-\\1WC2LG-\u0019;j_:\u001cuN\u001c4jO\"\u0012!BN\u0001/i\u0016\u001cH/\u00138wC2LGmU2iK6\fg+\u00197jI\u0006$\u0018n\u001c8D_:4\u0017nZ\"mCN\u001chj\u001c;G_VtG\r\u000b\u0002\fm\u00059B/Z:u\u0013:4\u0018\r\\5e\u0005J|7.\u001a:F]RLG/\u001f\u0015\u0003\u0019Y\n1\u0004^3ti&sg/\u00197jI:+w-\u0019;jm\u0016\u0014%o\\6fe&#\u0007FA\u00077\u0003U1XM]5gs2{wmQ8oM&<7\t[1oO\u0016$bA\r,XI\u001a\\\u0007\"\u0002\u0016\u000f\u0001\u0004a\u0003\"\u0002-\u000f\u0001\u0004I\u0016!\u00059sKZ\u001cE.Z1okB\u0004v\u000e\\5dsB\u0011!,\u0019\b\u00037~\u0003\"\u0001\u0018\u0012\u000e\u0003uS!A\u0018\u0010\u0002\rq\u0012xn\u001c;?\u0013\t\u0001'%\u0001\u0004Qe\u0016$WMZ\u0005\u0003E\u000e\u0014aa\u0015;sS:<'B\u00011#\u0011\u0015)g\u00021\u0001Z\u0003AqWm^\"mK\u0006tW\u000f\u001d)pY&\u001c\u0017\u0010C\u0003h\u001d\u0001\u0007\u0001.A\ruS\u0016\u00148\t\\3b]\u0016\u0014h)Z1ukJ,WI\\1cY\u0016$\u0007CA\u0011j\u0013\tQ'EA\u0004C_>dW-\u00198\t\u000b1t\u0001\u0019A-\u0002+\u0015D\b/Z2uK\u0012,\u0005pY3qi&|g\u000eV3yi\u0006iC/Z:u-\u0006d\u0017\u000eZ1uKR{\u0007/[2D_:4\u0017nZ\"iC:<WmQ8na\u0006\u001cG/[8o'R\fG/^:)\u0005=1\u0014!\u000b;fgR$v\u000e]5d!2\f7-Z7f]R\u001c\u0005.\u00198hKN\u001cVoY2fgNtUm^\"p]\u001aLw\r\u000b\u0002\u0011m\u0005aC/Z:u)>\u0004\u0018n\u0019)mC\u000e,W.\u001a8u\u0007\"\fgnZ3t'V\u001c7-Z:t+B$\u0017\r^3D_:4\u0017n\u001a\u0015\u0003#Y\n\u0001\u0006^3tiR{\u0007/[2QY\u0006\u001cW-\\3oi\u000eC\u0017M\\4fgN+8mY3tg:{7\t[1oO\u0016D#A\u0005\u001c\u0002_Q,7\u000f\u001e+pa&\u001c\u0007\u000b\\1dK6,g\u000e^\"iC:<Wm]*vG\u000e,7o\u001d*f[>4X\r\u00157bG\u0016lWM\u001c;)\u0005M1\u0014\u0001\n;fgR$v\u000e]5d!2\f7-Z7f]R\u001c\u0005.\u00198hKNLeN^1mS\u0012T5o\u001c8)\u0005Q1\u0014A\u000b;fgRtUm\u001e+pa&\u001c\u0007\u000b\\1dK6,g\u000e^\"p]\u001aLwMQ;u\u001d>$8+\u001e9q_J$X\r\u001a\u0015\u0003+Y\n\u0001\b^3ti\u0012+G.\u001a;f)>\u0004\u0018n\u0019)mC\u000e,W.\u001a8u\u0007>tg-[4BG\u000e,\u0007\u000f^3e\u000bZ,g.\u00134O_R\u001cV\u000f\u001d9peR,G\r\u000b\u0002\u0017m\u0005\u00112M]3bi\u0016\u0014%o\\6fe\u000e{gNZ5h)\u0005y\b\u0003BA\u0001\u0003\u0017i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0005kRLGN\u0003\u0002\u0002\n\u0005!!.\u0019<b\u0013\u0011\ti!a\u0001\u0003\u0015A\u0013x\u000e]3si&,7\u000fF\u0003\u0000\u0003#\t)\u0002\u0003\u0004\u0002\u0014a\u0001\r\u0001[\u0001\fi&,'OR3biV\u0014X\r\u0003\u0004\u0002\u0018a\u0001\r\u0001[\u0001\u0013i&,'o\u00117fC:,'OR3biV\u0014X\r")
public class ControllerConfigurationValidatorTest {
    private final ControllerConfigurationValidator validator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig(true, true)));

    public ControllerConfigurationValidator validator() {
        return this.validator;
    }

    @Test
    public void testDefaultTopicResourceIsRejected() {
        Assertions.assertEquals((Object)"Default topic resources are not allowed.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, ""), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testInvalidTopicNameRejected() {
        Assertions.assertEquals((Object)"Topic name is invalid: '(<-invalid->)' contains one or more characters other than ASCII alphanumerics, '.', '_' and '-'", (Object)Assertions.assertThrows(InvalidTopicException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "(<-invalid->)"), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testUnknownResourceType() {
        Assertions.assertEquals((Object)"Unknown resource type BROKER_LOGGER", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "foo"), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testNullTopicConfigValue() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "10");
        config.put("segment.bytes", null);
        config.put("segment.ms", null);
        Assertions.assertEquals((Object)"Null value not supported for topic configs: segment.bytes,segment.ms", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (java.util.Map)config)).getMessage());
    }

    @Test
    public void testValidTopicConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), config);
    }

    @Test
    public void testInvalidTopicConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        config.put("foobar", "abc");
        Assertions.assertEquals((Object)"Unknown topic config name: foobar", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (java.util.Map)config)).getMessage());
    }

    @Test
    public void testInvalidSchemaValidationConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("confluent.key.schema.validation", "true");
        Properties brokerConfig = this.createBrokerConfig(false, false);
        brokerConfig.put("confluent.schema.validator.interceptor.class", "io.confluent.kafka.schemaregistry.validator.RecordSchemaValidator");
        ControllerConfigurationValidator newValidator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)brokerConfig));
        Assertions.assertEquals((Object)"confluent.key.schema.validation and / or confluent.value.schema.validation is enabled but there is no confluent.schema.registry.url specified at the broker side, will not add the corresponding validator", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> newValidator.validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (java.util.Map)config)).getMessage());
    }

    @Test
    public void testInvalidSchemaValidationConfigClassNotFound() {
        String className = "random.class";
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("confluent.value.schema.validation", "true");
        Properties brokerConfig = this.createBrokerConfig(false, false);
        brokerConfig.put("confluent.schema.validator.interceptor.class", className);
        brokerConfig.put("confluent.schema.registry.url", "sr_url");
        ControllerConfigurationValidator newValidator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)brokerConfig));
        Assertions.assertEquals((Object)new StringBuilder(22).append("Class ").append(className).append(" cannot be found").toString(), (Object)Assertions.assertThrows(KafkaException.class, () -> newValidator.validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (java.util.Map)config)).getMessage());
    }

    @Test
    public void testInvalidBrokerEntity() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        Assertions.assertEquals((Object)"Unable to parse broker name as a base 10 number.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER, "blah"), (java.util.Map)config)).getMessage());
    }

    @Test
    public void testInvalidNegativeBrokerId() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        Assertions.assertEquals((Object)"Invalid negative broker ID.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER, "-1"), (java.util.Map)config)).getMessage());
    }

    private void verifyLogConfigChange(ControllerConfigurationValidator validator, String prevCleanupPolicy, String newCleanupPolicy, boolean tierCleanerFeatureEnabled, String expectedExceptionText) {
        if (expectedExceptionText.isEmpty()) {
            try {
                validator.validateTopicConfigChange(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)prevCleanupPolicy)}))).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)newCleanupPolicy), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.tier.cleaner.enable"), (Object)Boolean.toString(tierCleanerFeatureEnabled))}))).asJava(), new ArrayList().iterator(), true);
                return;
            }
            catch (Exception e) {
                throw new RuntimeException("unexpected validation failure", e);
            }
        }
        Assertions.assertEquals((Object)expectedExceptionText, (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> validator.validateTopicConfigChange(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)prevCleanupPolicy)}))).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)newCleanupPolicy), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.tier.cleaner.enable"), (Object)Boolean.toString(tierCleanerFeatureEnabled))}))).asJava(), new ArrayList().iterator(), true)).getMessage());
    }

    @Test
    public void testValidateTopicConfigChangeCompactionStatus() {
        ControllerConfigurationValidator noTiering = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig(false, false)));
        this.verifyLogConfigChange(noTiering, "compact", "compact", false, "");
        this.verifyLogConfigChange(noTiering, "compact", "delete", false, "");
        this.verifyLogConfigChange(noTiering, "compact", "compact,delete", false, "");
        this.verifyLogConfigChange(noTiering, "delete", "compact", false, "");
        this.verifyLogConfigChange(noTiering, "delete", "delete", false, "");
        this.verifyLogConfigChange(noTiering, "delete", "compact,delete", false, "");
        this.verifyLogConfigChange(noTiering, "compact,delete", "compact", false, "");
        this.verifyLogConfigChange(noTiering, "compact,delete", "delete", false, "");
        this.verifyLogConfigChange(noTiering, "compact,delete", "compact,delete", false, "");
        ControllerConfigurationValidator noCleaner = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig(true, false)));
        this.verifyLogConfigChange(noCleaner, "compact", "compact", false, "");
        this.verifyLogConfigChange(noCleaner, "compact", "delete", false, "");
        this.verifyLogConfigChange(noCleaner, "compact", "compact,delete", false, "");
        this.verifyLogConfigChange(noCleaner, "delete", "compact", false, "Altering topic configuration from `delete` to `compact` is not currently supported. Please create a new topic with `compact` policy specified instead.");
        this.verifyLogConfigChange(noCleaner, "delete", "delete", false, "");
        this.verifyLogConfigChange(noCleaner, "delete", "compact,delete", false, "Altering topic configuration from `delete` to `compact` is not currently supported. Please create a new topic with `compact` policy specified instead.");
        this.verifyLogConfigChange(noCleaner, "compact,delete", "compact", false, "");
        this.verifyLogConfigChange(noCleaner, "compact,delete", "delete", false, "");
        this.verifyLogConfigChange(noCleaner, "compact,delete", "compact,delete", false, "");
        ControllerConfigurationValidator latest = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig(true, true)));
        this.verifyLogConfigChange(latest, "compact", "compact", true, "");
        this.verifyLogConfigChange(latest, "compact", "delete", true, "");
        this.verifyLogConfigChange(latest, "compact", "compact,delete", true, "");
        this.verifyLogConfigChange(latest, "delete", "compact", true, "");
        this.verifyLogConfigChange(latest, "delete", "delete", true, "");
        this.verifyLogConfigChange(latest, "delete", "compact,delete", true, "Altering topic configuration from `delete` to `compact` and `delete` is not currently supported. Please set `cleanup.policy` to either `delete` or `compact`.");
        this.verifyLogConfigChange(latest, "compact,delete", "compact", true, "");
        this.verifyLogConfigChange(latest, "compact,delete", "delete", true, "");
        this.verifyLogConfigChange(latest, "compact,delete", "compact,delete", true, "");
    }

    @Test
    public void testTopicPlacementChangesSuccessNewConfig() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          |  \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack0\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack0\"\n                          |    }\n                          |  }]\n                          |}"));
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig()));
        TreeMap prevConfig = new TreeMap();
        java.util.Map newConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)placementJson)}))).asJava();
        .colon.colon brokers = new .colon.colon((Object)new UsableBroker(0, Optional.of("rack0"), false), (List)new .colon.colon((Object)new UsableBroker(1, Optional.of("rack0"), false), (List)Nil$.MODULE$));
        validator.validateTopicConfigChange(prevConfig, newConfig, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava().iterator(), true);
    }

    @Test
    public void testTopicPlacementChangesSuccessUpdateConfig() {
        String prevPlacementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          |  \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack0\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack0\"\n                          |    }\n                          |  }]\n                          |}"));
        String newPlacementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          |  \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack1\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack1\"\n                          |    }\n                          |  }]\n                          |}"));
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig()));
        java.util.Map prevConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)prevPlacementJson)}))).asJava();
        java.util.Map newConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)newPlacementJson)}))).asJava();
        .colon.colon brokers = new .colon.colon((Object)new UsableBroker(0, Optional.of("rack0"), false), (List)new .colon.colon((Object)new UsableBroker(1, Optional.of("rack0"), false), (List)new .colon.colon((Object)new UsableBroker(0, Optional.of("rack1"), false), (List)new .colon.colon((Object)new UsableBroker(1, Optional.of("rack1"), false), (List)Nil$.MODULE$))));
        validator.validateTopicConfigChange(prevConfig, newConfig, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava().iterator(), true);
    }

    @Test
    public void testTopicPlacementChangesSuccessNoChange() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          |  \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack0\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack0\"\n                          |    }\n                          |  }]\n                          |}"));
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig()));
        java.util.Map prevConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)placementJson)}))).asJava();
        java.util.Map newConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)placementJson)}))).asJava();
        .colon.colon brokers = new .colon.colon((Object)new UsableBroker(0, Optional.of("rack0"), false), (List)new .colon.colon((Object)new UsableBroker(1, Optional.of("rack0"), false), (List)Nil$.MODULE$));
        validator.validateTopicConfigChange(prevConfig, newConfig, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava().iterator(), true);
    }

    @Test
    public void testTopicPlacementChangesSuccessRemovePlacement() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          |  \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack0\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack0\"\n                          |    }\n                          |  }]\n                          |}"));
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig()));
        java.util.Map prevConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)placementJson)}))).asJava();
        .colon.colon brokers = new .colon.colon((Object)new UsableBroker(0, Optional.of("rack0"), false), (List)new .colon.colon((Object)new UsableBroker(1, Optional.of("rack0"), false), (List)Nil$.MODULE$));
        java.util.Map newConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)"")}))).asJava();
        validator.validateTopicConfigChange(prevConfig, newConfig, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava().iterator(), true);
        TreeMap emptyConfig = new TreeMap();
        validator.validateTopicConfigChange(prevConfig, emptyConfig, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava().iterator(), true);
    }

    @Test
    public void testTopicPlacementChangesInvalidJson() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          |  \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack0\"\n                          |  }]\n                          |}"));
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig()));
        TreeMap prevConfig = new TreeMap();
        java.util.Map newConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)placementJson)}))).asJava();
        .colon.colon brokers = new .colon.colon((Object)new UsableBroker(0, Optional.of("rack0"), false), (List)new .colon.colon((Object)new UsableBroker(1, Optional.of("rack0"), false), (List)Nil$.MODULE$));
        ConfigException throwable = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> ControllerConfigurationValidatorTest.$anonfun$testTopicPlacementChangesInvalidJson$1(validator, prevConfig, newConfig, (scala.collection.immutable.Seq)brokers));
        Assertions.assertEquals((Object)new StringBuilder(113).append("Invalid value ").append(placementJson).append(" for configuration confluent.placement.constraints: Exception while parsing placement configuration").toString(), (Object)throwable.getMessage());
    }

    @Test
    public void testNewTopicPlacementConfigButNotSupported() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          |  \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack0\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack0\"\n                          |    }\n                          |  }]\n                          |}"));
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig()));
        TreeMap prevConfig = new TreeMap();
        java.util.Map newConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)placementJson)}))).asJava();
        .colon.colon brokers = new .colon.colon((Object)new UsableBroker(0, Optional.of("rack0"), false), (List)new .colon.colon((Object)new UsableBroker(1, Optional.of("rack0"), false), (List)Nil$.MODULE$));
        InvalidConfigurationException throwable = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> ControllerConfigurationValidatorTest.$anonfun$testNewTopicPlacementConfigButNotSupported$1(validator, prevConfig, newConfig, (scala.collection.immutable.Seq)brokers));
        Assertions.assertEquals((Object)"Topic placement is not supported.", (Object)throwable.getMessage());
    }

    @Test
    public void testDeleteTopicPlacementConfigAcceptedEvenIfNotSupported() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          |  \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 1,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack0\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 1,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack0\"\n                          |    }\n                          |  }]\n                          |}"));
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator(new KafkaConfig((java.util.Map)this.createBrokerConfig()));
        java.util.Map prevConfig = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent.placement.constraints"), (Object)placementJson)}))).asJava();
        TreeMap newConfig = new TreeMap();
        .colon.colon brokers = new .colon.colon((Object)new UsableBroker(0, Optional.of("rack0"), false), (List)new .colon.colon((Object)new UsableBroker(1, Optional.of("rack0"), false), (List)Nil$.MODULE$));
        validator.validateTopicConfigChange(prevConfig, newConfig, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava().iterator(), false);
    }

    private Properties createBrokerConfig() {
        return this.createBrokerConfig(false, false);
    }

    private Properties createBrokerConfig(boolean tierFeature, boolean tierCleanerFeature) {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        config.put(KafkaConfig$.MODULE$.TierFeatureProp(), Boolean.toString(tierFeature));
        config.put(KafkaConfig$.MODULE$.TierCleanerFeatureEnableProp(), Boolean.toString(tierCleanerFeature));
        return config;
    }

    public static final /* synthetic */ void $anonfun$testTopicPlacementChangesInvalidJson$1(ControllerConfigurationValidator validator$2, TreeMap prevConfig$1, java.util.Map newConfig$1, scala.collection.immutable.Seq brokers$1) {
        validator$2.validateTopicConfigChange((java.util.Map)prevConfig$1, newConfig$1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers$1).asJava().iterator(), true);
    }

    public static final /* synthetic */ void $anonfun$testNewTopicPlacementConfigButNotSupported$1(ControllerConfigurationValidator validator$3, TreeMap prevConfig$2, java.util.Map newConfig$2, scala.collection.immutable.Seq brokers$2) {
        validator$3.validateTopicConfigChange((java.util.Map)prevConfig$2, newConfig$2, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers$2).asJava().iterator(), false);
    }
}

