/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.telemetry.api.events.NoOpEventEmitter;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kafka.network.RequestChannel;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.ForwardingManager;
import kafka.server.ForwardingManagerImpl;
import kafka.server.MockBrokerToControllerChannelManager;
import kafka.utils.MockTime;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tua\u0001B\u0012%\u0001%BQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013%Q\u0007\u0003\u0004=\u0001\u0001\u0006IA\u000e\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019Q\u0005\u0001)A\u0005\u007f!91\n\u0001b\u0001\n\u0013a\u0005B\u0002)\u0001A\u0003%Q\nC\u0004R\u0001\t\u0007I\u0011\u0002*\t\rY\u0003\u0001\u0015!\u0003T\u0011\u001d9\u0006A1A\u0005\naCa\u0001\u0018\u0001!\u0002\u0013I\u0006bB/\u0001\u0005\u0004%IA\u0018\u0005\u0007S\u0002\u0001\u000b\u0011B0\t\u000b)\u0004A\u0011B6\t\u000b=\u0004A\u0011\u00029\t\u000bQ\u0004A\u0011\u00029\t\u000bU\u0004A\u0011\u0001<\u0007\r\u0005-\u0001\u0001AA\u0007\u0011\u0019\u0001$\u0003\"\u0001\u0002\u0016!I\u00111\u0004\nA\u0002\u0013\u0005\u0011Q\u0004\u0005\n\u0003K\u0011\u0002\u0019!C\u0001\u0003OA\u0001\"!\f\u0013A\u0003&\u0011q\u0004\u0005\b\u0003o\u0011B\u0011IA\u001d\u0011\u001d\t9D\u0005C!\u0003sBaA\u001b\n\u0005B\u0005}\u0006BBAb\u0001\u0011\u0005a\u000f\u0003\u0004\u0002H\u0002!\tA\u001e\u0005\u0007\u0003\u0017\u0004A\u0011\u0001<\t\r\u0005=\u0007\u0001\"\u0001w\u0011\u0019\t\u0019\u000e\u0001C\u0001m\"1\u0011q\u001b\u0001\u0005\u0002YDq!a7\u0001\t\u0013\ti\u000eC\u0004\u0002\\\u0002!I!!?\t\u000f\tM\u0001\u0001\"\u0003\u0003\u0016\t)bi\u001c:xCJ$\u0017N\\4NC:\fw-\u001a:UKN$(BA\u0013'\u0003\u0019\u0019XM\u001d<fe*\tq%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002eA\u00111\u0007A\u0007\u0002I\u0005!A/[7f+\u00051\u0004CA\u001c;\u001b\u0005A$BA\u001d'\u0003\u0015)H/\u001b7t\u0013\tY\u0004H\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u0019\u0019G.[3oiV\tq\b\u0005\u0002A\u00116\t\u0011I\u0003\u0002C\u0007\u000691\r\\5f]R\u001c(BA\u0014E\u0015\t)e)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u000f\u0006\u0019qN]4\n\u0005%\u000b%AC'pG.\u001cE.[3oi\u000691\r\\5f]R\u0004\u0013AF2p]R\u0014x\u000e\u001c7fe:{G-\u001a)s_ZLG-\u001a:\u0016\u00035\u0003\"a\r(\n\u0005=##AF\"p]R\u0014x\u000e\u001c7fe:{G-\u001a)s_ZLG-\u001a:\u0002/\r|g\u000e\u001e:pY2,'OT8eKB\u0013xN^5eKJ\u0004\u0013A\u00052s_.,'\u000fV8D_:$(o\u001c7mKJ,\u0012a\u0015\t\u0003gQK!!\u0016\u0013\u0003I5{7m\u001b\"s_.,'\u000fV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\f1C\u0019:pW\u0016\u0014Hk\\\"p]R\u0014x\u000e\u001c7fe\u0002\n\u0011CZ8so\u0006\u0014H-\u001b8h\u001b\u0006t\u0017mZ3s+\u0005I\u0006CA\u001a[\u0013\tYFEA\u000bG_J<\u0018M\u001d3j]\u001el\u0015M\\1hKJLU\u000e\u001d7\u0002%\u0019|'o^1sI&tw-T1oC\u001e,'\u000fI\u0001\u0011aJLgnY5qC2\u0014U/\u001b7eKJ,\u0012a\u0018\t\u0003A\u001el\u0011!\u0019\u0006\u0003E\u000e\fQ\"Y;uQ\u0016tG/[2bi>\u0014(B\u00013f\u0003!\u0019XmY;sSRL(B\u00014D\u0003\u0019\u0019w.\\7p]&\u0011\u0001.\u0019\u0002\u001d\t\u00164\u0017-\u001e7u\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0005VLG\u000eZ3s\u0003E\u0001(/\u001b8dSB\fGNQ;jY\u0012,'\u000fI\u0001\u0016G>tGO]8mY\u0016\u0014\u0018\t]5WKJ\u001c\u0018n\u001c8t+\u0005a\u0007C\u0001!n\u0013\tq\u0017IA\bO_\u0012,\u0017\t]5WKJ\u001c\u0018n\u001c8t\u00039\u0019wN\u001c;s_2dWM]%oM>,\u0012!\u001d\t\u0003gIL!a\u001d\u0013\u0003+\r{g\u000e\u001e:pY2,'/\u00138g_Jl\u0017\r^5p]\u0006\u0019R-\u001c9us\u000e{g\u000e\u001e:pY2,'/\u00138g_\u0006\tC/Z:u%\u0016\u001c\bo\u001c8tK\u000e{'O]3mCRLwN\\%e\u001b&\u001cX.\u0019;dQR\tq\u000f\u0005\u0002,q&\u0011\u0011\u0010\f\u0002\u0005+:LG\u000f\u000b\u0002\u0012wB\u0019A0a\u0002\u000e\u0003uT!A`@\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u0002\u0005\r\u0011a\u00026va&$XM\u001d\u0006\u0004\u0003\u000b1\u0015!\u00026v]&$\u0018bAA\u0005{\n!A+Z:u\u0005\r2uN]<be\u0012LgnZ'b]\u0006<WM\u001d$pe6+H\u000e^5UK:\fg\u000e\u001e+fgR\u001cBA\u0005\u0016\u0002\u0010A\u00191'!\u0005\n\u0007\u0005MAEA\tG_J<\u0018M\u001d3j]\u001el\u0015M\\1hKJ$\"!a\u0006\u0011\u0007\u0005e!#D\u0001\u0001\u0003A\u0011Xm]3sS\u0006d\u0017N_3e\u0005>$\u00170\u0006\u0002\u0002 A\u00191&!\t\n\u0007\u0005\rBFA\u0004C_>dW-\u00198\u0002)I,7/\u001a:jC2L'0\u001a3C_\u0012Lx\fJ3r)\r9\u0018\u0011\u0006\u0005\n\u0003W)\u0012\u0011!a\u0001\u0003?\t1\u0001\u001f\u00132\u0003E\u0011Xm]3sS\u0006d\u0017N_3e\u0005>$\u0017\u0010\t\u0015\u0004-\u0005E\u0002cA\u0016\u00024%\u0019\u0011Q\u0007\u0017\u0003\u0011Y|G.\u0019;jY\u0016\faBZ8so\u0006\u0014HMU3rk\u0016\u001cH\u000fF\u0004x\u0003w\t\u0019&a\u0019\t\u000f\u0005ur\u00031\u0001\u0002@\u0005yqN]5hS:\fGNU3rk\u0016\u001cH\u000f\u0005\u0003\u0002B\u00055c\u0002BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001dc%A\u0004oKR<xN]6\n\t\u0005-\u0013QI\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\u0011\ty%!\u0015\u0003\u000fI+\u0017/^3ti*!\u00111JA#\u0011\u001d\t)f\u0006a\u0001\u0003/\naB\\3x%\u0016\fX/Z:u\u0005>$\u0017\u0010\u0005\u0003\u0002Z\u0005}SBAA.\u0015\r\ti&Z\u0001\te\u0016\fX/Z:ug&!\u0011\u0011MA.\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\bbBA3/\u0001\u0007\u0011qM\u0001\u0011e\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0004baKA5\u0003[:\u0018bAA6Y\tIa)\u001e8di&|g.\r\t\u0006W\u0005=\u00141O\u0005\u0004\u0003cb#AB(qi&|g\u000e\u0005\u0003\u0002Z\u0005U\u0014\u0002BA<\u00037\u0012\u0001#\u00112tiJ\f7\r\u001e*fgB|gn]3\u0015\u0017]\fY(!\"\u0002\u001a\u0006u\u0015Q\u0018\u0005\b\u0003{B\u0002\u0019AA@\u00039\u0011X-];fgR\u001cuN\u001c;fqR\u0004B!!\u0017\u0002\u0002&!\u00111QA.\u00059\u0011V-];fgR\u001cuN\u001c;fqRDq!a\"\u0019\u0001\u0004\tI)A\tsKF,Xm\u001d;Ck\u001a4WM]\"paf\u0004B!a#\u0002\u00166\u0011\u0011Q\u0012\u0006\u0005\u0003\u001f\u000b\t*A\u0002oS>T!!a%\u0002\t)\fg/Y\u0005\u0005\u0003/\u000biI\u0001\u0006CsR,')\u001e4gKJDq!a'\u0019\u0001\u0004\t9&A\u0006sKF,Xm\u001d;C_\u0012L\bbBAP1\u0001\u0007\u0011\u0011U\u0001\u0010e\u0016\fX/Z:u)>\u001cFO]5oOB)1&a)\u0002(&\u0019\u0011Q\u0015\u0017\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004\u0003BAU\u0003osA!a+\u00024B\u0019\u0011Q\u0016\u0017\u000e\u0005\u0005=&bAAYQ\u00051AH]8pizJ1!!.-\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011XA^\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0017\u0017\t\u000f\u0005\u0015\u0004\u00041\u0001\u0002hU\u0011\u0011\u0011\u0019\t\u0005W\u0005=D.A\ruKN$X*\u001e7uSR+g.\u00198u\r>\u0014x/\u0019:eS:<\u0007F\u0001\u000e|\u0003]!Xm\u001d;V]N,\b\u000f]8si\u0016$g+\u001a:tS>t7\u000f\u000b\u0002\u001cw\u0006\u0011D/Z:u\r>\u0014x/\u0019:eS:<G+[7f_V$x+Y5uS:<gi\u001c:D_:$(o\u001c7mKJ$\u0015n]2pm\u0016\u0014\u0018\u0010\u000b\u0002\u001dw\u0006yB/Z:u\r>\u0014x/\u0019:eS:<G+[7f_V$\u0018I\u001a;feJ+GO]=)\u0005uY\u0018a\n;fgR,fn];qa>\u0014H/\u001a3WKJ\u001c\u0018n\u001c8Ge>lg*\u001a;x_J\\7\t\\5f]RD#AH>\u00021Q,7\u000f\u001e$bS2,G-Q;uQ\u0016tG/[2bi&|g\u000e\u000b\u0002 w\u0006a!-^5mIJ+\u0017/^3tiR1\u0011q\\Av\u0003_\u0004raKAq\u0003K\fI)C\u0002\u0002d2\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BA-\u0003OLA!!;\u0002\\\ti!+Z9vKN$\b*Z1eKJDq!!<!\u0001\u0004\t9&\u0001\u0003c_\u0012L\bbBAyA\u0001\u0007\u00111_\u0001\u000eG>\u0014(/\u001a7bi&|g.\u00133\u0011\u0007-\n)0C\u0002\u0002x2\u00121!\u00138u)!\ty$a?\u0002\u0000\n\r\u0001bBA\u007fC\u0001\u0007\u0011Q]\u0001\u000ee\u0016\fX/Z:u\u0011\u0016\fG-\u001a:\t\u000f\t\u0005\u0011\u00051\u0001\u0002\n\u0006i!/Z9vKN$()\u001e4gKJDqA!\u0002\"\u0001\u0004\u00119!A\u0005qe&t7-\u001b9bYB!!\u0011\u0002B\b\u001b\t\u0011YAC\u0002\u0003\u000e\r\fA!Y;uQ&!!\u0011\u0003B\u0006\u00059Y\u0015MZ6b!JLgnY5qC2\fa\u0003^3ti\u0006cG/\u001a:D_:4\u0017n\u001a*fcV,7\u000f^\u000b\u0003\u0005/\u0001B!!\u0017\u0003\u001a%!!1DA.\u0005M\tE\u000e^3s\u0007>tg-[4t%\u0016\fX/Z:u\u0001")
public class ForwardingManagerTest {
    private final MockTime time = new MockTime();
    private final MockClient client = new MockClient((Time)this.time());
    private final ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
    private final MockBrokerToControllerChannelManager brokerToController = new MockBrokerToControllerChannelManager(this.client(), this.time(), this.controllerNodeProvider(), this.controllerApiVersions(), 60000, 30000);
    private final ForwardingManagerImpl forwardingManager = new ForwardingManagerImpl((BrokerToControllerChannelManager)this.brokerToController());
    private final DefaultKafkaPrincipalBuilder principalBuilder = new DefaultKafkaPrincipalBuilder(null, null);

    private MockTime time() {
        return this.time;
    }

    private MockClient client() {
        return this.client;
    }

    private ControllerNodeProvider controllerNodeProvider() {
        return this.controllerNodeProvider;
    }

    private MockBrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    private ForwardingManagerImpl forwardingManager() {
        return this.forwardingManager;
    }

    private DefaultKafkaPrincipalBuilder principalBuilder() {
        return this.principalBuilder;
    }

    private NodeApiVersions controllerApiVersions() {
        ApiVersionsResponseData.ApiVersion envelopeApiVersion = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.ENVELOPE.id).setMinVersion(ApiKeys.ENVELOPE.oldestVersion()).setMaxVersion(ApiKeys.ENVELOPE.latestVersion());
        return NodeApiVersions.create((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)envelopeApiVersion, (List)Nil$.MODULE$)).asJava());
    }

    private ControllerInformation controllerInfo() {
        return new ControllerInformation((Option)new Some((Object)new Node(0, "host", 1234)), new ListenerName(""), SecurityProtocol.PLAINTEXT, "", true);
    }

    private ControllerInformation emptyControllerInfo() {
        return new ControllerInformation((Option)None$.MODULE$, new ListenerName(""), SecurityProtocol.PLAINTEXT, "", true);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResponseCorrelationIdMismatch() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request2 = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        ByteBuffer responseBuffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)new AlterConfigsResponse(new AlterConfigsResponseData()), (short)var4_4.apiVersion(), (int)(requestCorrelationId + 1));
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        MockClient.RequestMatcher isEnvelopeRequest = request -> request instanceof EnvelopeRequest;
        this.client().prepareResponse(isEnvelopeRequest, (AbstractResponse)new EnvelopeResponse(responseBuffer, Errors.NONE));
        AtomicReference responseOpt = new AtomicReference();
        this.forwardingManager().forwardRequest(request2, (Function1 & Serializable)x$1 -> {
            responseOpt.set(x$1);
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertTrue((boolean)Option$.MODULE$.apply(responseOpt.get()).isDefined());
        AbstractResponse response = (AbstractResponse)((Option)responseOpt.get()).get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)response.errorCounts());
    }

    @Test
    public void testMultiTenantForwarding() {
        ForwardingManagerForMultiTenantTest forwardingManager = new ForwardingManagerForMultiTenantTest();
        RequestChannel.Request request = (RequestChannel.Request)Mockito.mock(RequestChannel.Request.class);
        RequestContext context = (RequestContext)Mockito.mock(RequestContext.class);
        MultiTenantPrincipal principal = (MultiTenantPrincipal)Mockito.mock(MultiTenantPrincipal.class);
        Mockito.when((Object)request.context()).thenReturn((Object)context);
        Mockito.when((Object)context.getPrincipal()).thenReturn((Object)principal);
        forwardingManager.forwardRequest(request, (Function1<Option<AbstractResponse>, BoxedUnit>)(Function1 & Serializable)x$2 -> {
            ForwardingManagerTest.$anonfun$testMultiTenantForwarding$1(x$2);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)forwardingManager.reserializedBody());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnsupportedVersions() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request2 = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        ByteBuffer responseBuffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)new AlterConfigsResponse(new AlterConfigsResponseData()), (short)var4_4.apiVersion(), (int)requestCorrelationId);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        MockClient.RequestMatcher isEnvelopeRequest = request -> request instanceof EnvelopeRequest;
        this.client().prepareResponse(isEnvelopeRequest, (AbstractResponse)new EnvelopeResponse(responseBuffer, Errors.UNSUPPORTED_VERSION));
        AtomicReference responseOpt = new AtomicReference();
        this.forwardingManager().forwardRequest(request2, (Function1 & Serializable)x$1 -> {
            responseOpt.set(x$1);
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertEquals((Object)None$.MODULE$, responseOpt.get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testForwardingTimeoutWaitingForControllerDiscovery() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.emptyControllerInfo());
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable)res -> {
            res.foreach((Function1 & Serializable)x$1 -> {
                response$1.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNull(response.get());
        this.time().sleep(this.brokerToController().retryTimeoutMs());
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.REQUEST_TIMED_OUT), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testForwardingTimeoutAfterRetry() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable)res -> {
            res.foreach((Function1 & Serializable)x$1 -> {
                response$2.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNull(response.get());
        this.time().sleep(this.brokerToController().retryTimeoutMs());
        this.client().respond(this.testAlterConfigRequest().getErrorResponse(0, (Throwable)Errors.UNKNOWN_SERVER_ERROR.exception()), true);
        this.brokerToController().poll();
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.REQUEST_TIMED_OUT), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnsupportedVersionFromNetworkClient() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        this.client().prepareUnsupportedVersionResponse(arg_0 -> ForwardingManagerTest.$anonfun$testUnsupportedVersionFromNetworkClient$1((RequestHeader)var4_4, arg_0));
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable)res -> {
            res.foreach((Function1 & Serializable)x$1 -> {
                response$3.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFailedAuthentication() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        RequestChannel.Request request = this.buildRequest((RequestHeader)var4_4, (ByteBuffer)var5_5, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().getControllerInfo()).thenReturn((Object)this.controllerInfo());
        this.client().createPendingAuthenticationError((Node)this.controllerInfo().node().get(), 50L);
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable)res -> {
            res.foreach((Function1 & Serializable)x$1 -> {
                response$4.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    private Tuple2<RequestHeader, ByteBuffer> buildRequest(AbstractRequest body, int correlationId) {
        RequestHeader header = new RequestHeader(body.apiKey(), body.version(), "clientId", correlationId);
        ByteBuffer buffer = body.serializeWithHeader(header);
        RequestHeader.parse((ByteBuffer)buffer);
        return new Tuple2((Object)header, (Object)buffer);
    }

    private RequestChannel.Request buildRequest(RequestHeader requestHeader, ByteBuffer requestBuffer, KafkaPrincipal principal) {
        RequestContext requestContext = new RequestContext(requestHeader, "1", InetAddress.getLocalHost(), principal, new ListenerName("client"), SecurityProtocol.SASL_PLAINTEXT, ClientInformation.EMPTY, null, false, Optional.of(this.principalBuilder()));
        return new RequestChannel.Request(1, requestContext, this.time().nanoseconds(), MemoryPool.NONE, requestBuffer, new RequestChannel.Metrics(ApiMessageType.ListenerType.CONTROLLER), (Option)None$.MODULE$, NoOpEventEmitter.INSTANCE, (AuditLogProvider)NoOpAuditLogProvider.INSTANCE, RequestLogFilter.MATCH_NONE, 0L);
    }

    private AlterConfigsRequest testAlterConfigRequest() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, "foo");
        java.util.List configs = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new AlterConfigsRequest.ConfigEntry("min.insync.replicas", "1"), (List)Nil$.MODULE$)).asJava();
        return (AlterConfigsRequest)new AlterConfigsRequest.Builder(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)new AlterConfigsRequest.Config((Collection)configs))}))).asJava(), false).build();
    }

    public static final /* synthetic */ void $anonfun$testMultiTenantForwarding$1(Option x$2) {
    }

    public static final /* synthetic */ boolean $anonfun$testUnsupportedVersionFromNetworkClient$1(RequestHeader requestHeader$1, AbstractRequest req) {
        ApiKeys apiKeys = req.apiKey();
        ApiKeys apiKeys2 = requestHeader$1.apiKey();
        return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
    }

    public class ForwardingManagerForMultiTenantTest
    implements ForwardingManager {
        private volatile boolean reserializedBody;

        public void forwardRequest(RequestChannel.Request originalRequest, Function1<Option<AbstractResponse>, BoxedUnit> responseCallback) {
            ForwardingManager.forwardRequest$((ForwardingManager)this, (RequestChannel.Request)originalRequest, responseCallback);
        }

        public boolean reserializedBody() {
            return this.reserializedBody;
        }

        public void reserializedBody_$eq(boolean x$1) {
            this.reserializedBody = x$1;
        }

        public void forwardRequest(RequestChannel.Request originalRequest, AbstractRequest newRequestBody, Function1<Option<AbstractResponse>, BoxedUnit> responseCallback) {
            this.reserializedBody_$eq(true);
        }

        public void forwardRequest(RequestContext requestContext, ByteBuffer requestBufferCopy, AbstractRequest requestBody, Function0<String> requestToString, Function1<Option<AbstractResponse>, BoxedUnit> responseCallback) {
            throw new UnsupportedOperationException();
        }

        public Option<NodeApiVersions> controllerApiVersions() {
            return None$.MODULE$;
        }

        public /* synthetic */ ForwardingManagerTest kafka$server$ForwardingManagerTest$ForwardingManagerForMultiTenantTest$$$outer() {
            return ForwardingManagerTest.this;
        }

        public ForwardingManagerForMultiTenantTest() {
            if (ForwardingManagerTest.this == null) {
                throw null;
            }
            this.reserializedBody = false;
        }
    }
}

