/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.raft.KafkaRaftManager;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.FaultHandlerFactory;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.server.MetaProperties;
import kafka.server.QuorumImplementation;
import kafka.server.SharedServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.slf4j.event.Level;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005me\u0001B\f\u0019\u0001uA\u0001\u0002\u000b\u0001\u0003\u0002\u0004%\t!\u000b\u0005\t[\u0001\u0011\t\u0019!C\u0001]!AA\u0007\u0001B\u0001B\u0003&!\u0006\u0003\u00056\u0001\t\u0015\r\u0011\"\u00017\u0011!Q\u0004A!A!\u0002\u00139\u0004\u0002C\u001e\u0001\u0005\u000b\u0007I\u0011\u0001\u001f\t\u0011\u0015\u0003!\u0011!Q\u0001\nuB\u0001B\u0012\u0001\u0003\u0006\u0004%\ta\u0012\u0005\tg\u0002\u0011\t\u0011)A\u0005\u0011\"AA\u000f\u0001BC\u0002\u0013\u0005Q\u000f\u0003\u0005\u007f\u0001\t\u0005\t\u0015!\u0003w\u0011%y\bA!b\u0001\n\u0003\t\t\u0001\u0003\u0006\u0002\u0010\u0001\u0011\t\u0011)A\u0005\u0003\u0007A!\"!\u0005\u0001\u0005\u000b\u0007I\u0011AA\n\u0011)\t\u0019\u0003\u0001B\u0001B\u0003%\u0011Q\u0003\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011\u001d\tI\u0004\u0001C!\u0003wAq!a\u001d\u0001\t\u0003\n)\bC\u0004\u0002x\u0001!\t!!\u001f\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~!9\u00111\u0010\u0001\u0005\u0002\u0005U\u0004bBAB\u0001\u0011\u0005\u0011Q\u0011\u0002\u001a\u0017J\u000bg\r^)v_J,X.S7qY\u0016lWM\u001c;bi&|gN\u0003\u0002\u001a5\u000511/\u001a:wKJT\u0011aG\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001a\u0004\n\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u00152S\"\u0001\r\n\u0005\u001dB\"\u0001F)v_J,X.S7qY\u0016lWM\u001c;bi&|g.\u0001\td_:$(o\u001c7mKJ\u001cVM\u001d<feV\t!\u0006\u0005\u0002&W%\u0011A\u0006\u0007\u0002\u0011\u0007>tGO]8mY\u0016\u00148+\u001a:wKJ\fAcY8oiJ|G\u000e\\3s'\u0016\u0014h/\u001a:`I\u0015\fHCA\u00183!\ty\u0002'\u0003\u00022A\t!QK\\5u\u0011\u001d\u0019$!!AA\u0002)\n1\u0001\u001f\u00132\u0003E\u0019wN\u001c;s_2dWM]*feZ,'\u000fI\u0001\u0014M\u0006,H\u000e\u001e%b]\u0012dWM\u001d$bGR|'/_\u000b\u0002oA\u0011Q\u0005O\u0005\u0003sa\u00111CR1vYRD\u0015M\u001c3mKJ4\u0015m\u0019;pef\fACZ1vYRD\u0015M\u001c3mKJ4\u0015m\u0019;pef\u0004\u0013aC7fi\u0006$\u0017\r^1ESJ,\u0012!\u0010\t\u0003}\rk\u0011a\u0010\u0006\u0003\u0001\u0006\u000b!![8\u000b\u0003\t\u000bAA[1wC&\u0011Ai\u0010\u0002\u0005\r&dW-\u0001\u0007nKR\fG-\u0019;b\t&\u0014\b%\u0001\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3\u0016\u0003!\u00032!\u0013(Q\u001b\u0005Q%BA&M\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u001b\u0006\u000bA!\u001e;jY&\u0011qJ\u0013\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003B)S)jk\u0011\u0001T\u0005\u0003'2\u00131!T1q!\t)\u0006,D\u0001W\u0015\t9\u0016)\u0001\u0003mC:<\u0017BA-W\u0005\u001dIe\u000e^3hKJ\u0004\"a\u00179\u000f\u0005qkgBA/k\u001d\tq\u0006N\u0004\u0002`K:\u0011\u0001mY\u0007\u0002C*\u0011!\rH\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011\f1a\u001c:h\u0013\t1w-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I&\u00111$\u001b\u0006\u0003M\u001eL!a\u001b7\u0002\tI\fg\r\u001e\u0006\u00037%L!A\\8\u0002\u0015I\u000bg\r^\"p]\u001aLwM\u0003\u0002lY&\u0011\u0011O\u001d\u0002\f\u0003\u0012$'/Z:t'B,7M\u0003\u0002o_\u0006i2m\u001c8ue>dG.\u001a:Rk>\u0014X/\u001c,pi\u0016\u00148OR;ukJ,\u0007%A\u0005dYV\u001cH/\u001a:JIV\ta\u000f\u0005\u0002xw:\u0011\u00010\u001f\t\u0003A\u0002J!A\u001f\u0011\u0002\rA\u0013X\rZ3g\u0013\taXP\u0001\u0004TiJLgn\u001a\u0006\u0003u\u0002\n!b\u00197vgR,'/\u00133!\u0003\rawnZ\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013Q\u0012!B;uS2\u001c\u0018\u0002BA\u0007\u0003\u000f\u0011q\u0001T8hO&tw-\u0001\u0003m_\u001e\u0004\u0013\u0001\u00044bk2$\b*\u00198eY\u0016\u0014XCAA\u000b!\u0011\t9\"a\b\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\tQAZ1vYRT!!\u00077\n\t\u0005\u0005\u0012\u0011\u0004\u0002\r\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u000eM\u0006,H\u000e\u001e%b]\u0012dWM\u001d\u0011\u0002\rqJg.\u001b;?)A\tI#a\u000b\u0002.\u0005=\u0012\u0011GA\u001a\u0003k\t9\u0004\u0005\u0002&\u0001!)\u0001\u0006\u0005a\u0001U!)Q\u0007\u0005a\u0001o!)1\b\u0005a\u0001{!)a\t\u0005a\u0001\u0011\")A\u000f\u0005a\u0001m\"1q\u0010\u0005a\u0001\u0003\u0007Aq!!\u0005\u0011\u0001\u0004\t)\"\u0001\u0007de\u0016\fG/\u001a\"s_.,'\u000f\u0006\u0006\u0002>\u0005\r\u0013QJA0\u0003S\u00022!JA \u0013\r\t\t\u0005\u0007\u0002\f\u0017\u000647.\u0019\"s_.,'\u000fC\u0004\u0002FE\u0001\r!a\u0012\u0002\r\r|gNZ5h!\r)\u0013\u0011J\u0005\u0004\u0003\u0017B\"aC&bM.\f7i\u001c8gS\u001eD\u0011\"a\u0014\u0012!\u0003\u0005\r!!\u0015\u0002\tQLW.\u001a\t\u0005\u0003'\nY&\u0004\u0002\u0002V)!\u0011\u0011BA,\u0015\r\tI\u0006\\\u0001\u0007G>lWn\u001c8\n\t\u0005u\u0013Q\u000b\u0002\u0005)&lW\rC\u0005\u0002bE\u0001\n\u00111\u0001\u0002d\u000591\u000f^1siV\u0004\bcA\u0010\u0002f%\u0019\u0011q\r\u0011\u0003\u000f\t{w\u000e\\3b]\"I\u00111N\t\u0011\u0002\u0003\u0007\u0011QN\u0001\u0011i\"\u0014X-\u00193OC6,\u0007K]3gSb\u0004BaHA8m&\u0019\u0011\u0011\u000f\u0011\u0003\r=\u0003H/[8o\u0003!\u0019\b.\u001e;e_^tG#A\u0018\u0002%MDW\u000f\u001e3po:\u001cuN\u001c;s_2dWM\u001d\u000b\u0002)\u0006\t\"/Z:uCJ$8i\u001c8ue>dG.\u001a:\u0015\u0007=\ny\b\u0003\u0004\u0002\u0002R\u0001\r\u0001V\u0001\taJ,g\u000fU8si\u0006Y!/\u00194u\u001b\u0006t\u0017mZ3s+\t\t9\t\u0005\u0004\u0002\n\u00065\u0015\u0011S\u0007\u0003\u0003\u0017S!a\u001b\u000e\n\t\u0005=\u00151\u0012\u0002\u0011\u0017\u000647.\u0019*bMRl\u0015M\\1hKJ\u0004B!a%\u0002\u00186\u0011\u0011Q\u0013\u0006\u0005\u00033\ni\"\u0003\u0003\u0002\u001a\u0006U%\u0001F!qS6+7o]1hK\u0006sGMV3sg&|g\u000e")
public class KRaftQuorumImplementation
implements QuorumImplementation {
    private ControllerServer controllerServer;
    private final FaultHandlerFactory faultHandlerFactory;
    private final File metadataDir;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final String clusterId;
    private final Logging log;
    private final FaultHandler faultHandler;

    @Override
    public Time createBroker$default$2() {
        return QuorumImplementation.createBroker$default$2$(this);
    }

    @Override
    public boolean createBroker$default$3() {
        return QuorumImplementation.createBroker$default$3$(this);
    }

    @Override
    public Option<String> createBroker$default$4() {
        return QuorumImplementation.createBroker$default$4$(this);
    }

    public ControllerServer controllerServer() {
        return this.controllerServer;
    }

    public void controllerServer_$eq(ControllerServer x$1) {
        this.controllerServer = x$1;
    }

    public FaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    public File metadataDir() {
        return this.metadataDir;
    }

    public CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Logging log() {
        return this.log;
    }

    public FaultHandler faultHandler() {
        return this.faultHandler;
    }

    @Override
    public KafkaBroker createBroker(KafkaConfig config, Time time, boolean startup, Option<String> threadNamePrefix) {
        SharedServer sharedServer = new SharedServer(config, new MetaProperties(this.clusterId(), config.nodeId()), Time.SYSTEM, new Metrics(), this.controllerQuorumVotersFuture(), this.faultHandlerFactory(), (Option)None$.MODULE$, KafkaRaftServer$.MODULE$.configSchema());
        ObjectRef broker = ObjectRef.create(null);
        try {
            broker.elem = new BrokerServer(sharedServer, (Seq)Nil$.MODULE$);
            if (startup) {
                ((BrokerServer)broker.elem).startup();
            }
            return (BrokerServer)broker.elem;
        }
        catch (Throwable e) {
            if ((BrokerServer)broker.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> ((BrokerServer)broker$1.elem).shutdown(), this.log(), Level.WARN);
            }
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> sharedServer.stopForBroker(), this.log(), Level.WARN);
            throw e;
        }
    }

    @Override
    public void shutdown() {
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> this.controllerServer().shutdown(), this.log(), Level.WARN);
    }

    public Integer shutdownController() {
        int prevPort = ((RaftConfig.InetAddressSpec)this.controllerQuorumVotersFuture().get().get((Object)BoxesRunTime.boxToInteger((int)1000))).address.getPort();
        this.log().info((Function0 & Serializable)() -> "Stopping the KRaft-based controller");
        this.controllerServer().shutdown();
        return Predef$.MODULE$.int2Integer(prevPort);
    }

    public void restartController(Integer prevPort) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.controllerServer().config().originals());
        props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(23).append("CONTROLLER://localhost:").append(prevPort).toString());
        props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append("1000@localhost:").append(prevPort).toString());
        this.log().info((Function0 & Serializable)() -> new StringBuilder(58).append("Setting KRaft-based controller port to ").append(prevPort).append(" as part of restart").toString());
        this.controllerServer().sharedServer().controllerConfig_$eq(new KafkaConfig((Map)props));
        ControllerServer newControllerServer = new ControllerServer(this.controllerServer().sharedServer(), this.controllerServer().configSchema(), this.controllerServer().bootstrapMetadata(), this.controllerServer().clusterBalanceManager());
        this.controllerServer_$eq(newControllerServer);
        if (this.controllerServer().sharedServer().metrics() == null) {
            this.controllerServer().sharedServer().metrics_$eq(new Metrics());
        }
        this.log().info((Function0 & Serializable)() -> "Restarting the KRaft-based controller");
        newControllerServer.startup();
    }

    public void restartController() {
        Integer prevPort = this.shutdownController();
        this.restartController(prevPort);
    }

    public KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.controllerServer().sharedServer().raftManager();
    }

    public KRaftQuorumImplementation(ControllerServer controllerServer, FaultHandlerFactory faultHandlerFactory, File metadataDir, CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, String clusterId, Logging log, FaultHandler faultHandler) {
        this.controllerServer = controllerServer;
        this.faultHandlerFactory = faultHandlerFactory;
        this.metadataDir = metadataDir;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.clusterId = clusterId;
        this.log = log;
        this.faultHandler = faultHandler;
    }
}

