/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.Configuration;
import kafka.controller.ClusterBalanceManager;
import kafka.server.ControllerServer;
import kafka.server.FaultHandlerFactory;
import kafka.server.KRaftQuorumImplementation;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.server.MetaProperties;
import kafka.server.QuorumImplementation;
import kafka.server.QuorumTestHarness$;
import kafka.server.QuorumTestHarnessFaultHandlerFactory;
import kafka.server.SharedServer;
import kafka.server.ZooKeeperQuorumImplementation;
import kafka.tools.StorageTool$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\r}a!B!C\u0003\u00039\u0005\"\u0002+\u0001\t\u0003)\u0006b\u0002-\u0001\u0005\u0004%\t!\u0017\u0005\u0007;\u0002\u0001\u000b\u0011\u0002.\t\u000fy\u0003!\u0019!C\u00013\"1q\f\u0001Q\u0001\niCq\u0001\u0019\u0001C\u0002\u0013\u0005\u0011\f\u0003\u0004b\u0001\u0001\u0006IA\u0017\u0005\u0006E\u0002!\tb\u0019\u0005\u0006U\u0002!\tb\u001b\u0005\u0006w\u0002!\t\u0002 \u0005\b\u0003/\u0001A\u0011CA\r\u0011-\t9\u0003\u0001a\u0001\u0002\u0004%I!!\u000b\t\u0017\u0005}\u0002\u00011AA\u0002\u0013%\u0011\u0011\t\u0005\f\u0003\u001b\u0002\u0001\u0019!A!B\u0013\tY\u0003C\u0006\u0002P\u0001\u0001\r\u00111A\u0005\n\u0005E\u0003bCA-\u0001\u0001\u0007\t\u0019!C\u0005\u00037B1\"a\u0018\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002T!I\u0011\u0011\r\u0001C\u0002\u0013\u0005\u00111\r\u0005\t\u0003o\u0002\u0001\u0015!\u0003\u0002f!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0004bBA?\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003\u007f\u0002A\u0011AAA\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u0003Cq!!\"\u0001\t\u0013\t9\tC\u0004\u0002\u0010\u0002!I!!%\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\"9\u0011\u0011\u0016\u0001\u0005\u0002\u0005-\u0006bBAZ\u0001\u0011\u0005\u00111\u0016\u0005\b\u0003k\u0003A\u0011AA\\\u0011\u0019\ty\f\u0001C\u00013\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0007bBAn\u0001\u0011\u0005\u00111\u0019\u0005\b\u0003;\u0004A\u0011AAp\u0011\u001d\t9\u000f\u0001C\u0001\u0003SDq!a>\u0001\t\u0003\tI\u0010C\u0004\u0002x\u0002!\t!!!\t\u000f\u0005}\b\u0001\"\u0001\u0003\u0002!I!Q\u0001\u0001C\u0002\u0013\u0005!q\u0001\u0005\t\u0005\u001f\u0001\u0001\u0015!\u0003\u0003\n!I!\u0011\u0003\u0001A\u0002\u0013\u0005!1\u0003\u0005\n\u0005G\u0001\u0001\u0019!C\u0001\u0005KA\u0001B!\u000b\u0001A\u0003&!Q\u0003\u0005\n\u0005W\u0001!\u0019!C\u0001\u0005[A\u0001Ba\u000f\u0001A\u0003%!q\u0006\u0005\b\u0005{\u0001A\u0011\u0001B \u0011\u001d\u0011Y\u0005\u0001C\u0001\u0005\u001bB\u0011Ba\u001e\u0001#\u0003%\tA!\u001f\t\u0013\t=\u0005!%A\u0005\u0002\tE\u0005\"\u0003BK\u0001E\u0005I\u0011\u0001BL\u0011\u001d\u0011Y\n\u0001C\u0001\u0003\u0003CqA!(\u0001\t\u0003\t\t\tC\u0004\u0003 \u0002!\tA!)\t\u000f\t-\u0006\u0001\"\u0003\u0003.\"9!q\u0019\u0001\u0005\u0002\t%\u0007b\u0002Bg\u0001\u0011%\u0011q\u0011\u0005\b\u0005\u001f\u0004A\u0011AAA\u0011\u001d\u0011I\u000e\u0001C\u0001\u00057<qA!?C\u0011\u0003\u0011YP\u0002\u0004B\u0005\"\u0005!Q \u0005\u0007)n\"\tAa@\t\u0013\r\u00051H1A\u0005\u0002\r\r\u0001\u0002CB\u0005w\u0001\u0006Ia!\u0002\t\u000f\r-1\b\"\u0001\u0002\u0002\"91QC\u001e\u0005\u0002\u0005\u0005%!E)v_J,X\u000eV3ti\"\u000b'O\\3tg*\u00111\tR\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\u000bQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011:\u0003\"!\u0013'\u000e\u0003)S\u0011aS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b*\u0013a!\u00118z%\u00164\u0007CA(S\u001b\u0005\u0001&BA)E\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0006KA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u00051\u0006CA,\u0001\u001b\u0005\u0011\u0015a\u0005>l\u0007>tg.Z2uS>tG+[7f_V$X#\u0001.\u0011\u0005%[\u0016B\u0001/K\u0005\rIe\u000e^\u0001\u0015u.\u001cuN\u001c8fGRLwN\u001c+j[\u0016|W\u000f\u001e\u0011\u0002!i\\7+Z:tS>tG+[7f_V$\u0018!\u0005>l'\u0016\u001c8/[8o)&lWm\\;uA\u0005)\"p['bq&sg\t\\5hQR\u0014V-];fgR\u001c\u0018A\u0006>l\u001b\u0006D\u0018J\u001c$mS\u001eDGOU3rk\u0016\u001cHo\u001d\u0011\u0002\u001bi\\\u0017i\u00197t\u000b:\f'\r\\3e+\u0005!\u0007cA%fO&\u0011aM\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005%C\u0017BA5K\u0005\u001d\u0011un\u001c7fC:\f!eY8oiJ|G\u000e\\3s\u0019&\u001cH/\u001a8feN+7-\u001e:jif\u0004&o\u001c;pG>dW#\u00017\u0011\u00055LX\"\u00018\u000b\u0005=\u0004\u0018\u0001B1vi\"T!!\u001d:\u0002\u0011M,7-\u001e:jifT!a\u001d;\u0002\r\r|W.\\8o\u0015\t)UO\u0003\u0002wo\u00061\u0011\r]1dQ\u0016T\u0011\u0001_\u0001\u0004_J<\u0017B\u0001>o\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G.\u0001\fle\u00064GoQ8oiJ|G\u000e\\3s\u0007>tg-[4t)\u0005i\b#\u0002@\u0002\u0004\u0005\u001dQ\"A@\u000b\u0007\u0005\u0005!*\u0001\u0006d_2dWm\u0019;j_:L1!!\u0002\u0000\u0005\r\u0019V-\u001d\t\u0005\u0003\u0013\t\u0019\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\u0011)H/\u001b7\u000b\u0005\u0005E\u0011\u0001\u00026bm\u0006LA!!\u0006\u0002\f\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u001f5,G/\u00193bi\u00064VM]:j_:,\"!a\u0007\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1a]A\u0011\u0015\t\u0019E/\u0003\u0003\u0002&\u0005}!aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0002\u0011Q,7\u000f^%oM>,\"!a\u000b\u0011\t\u00055\u00121H\u0007\u0003\u0003_QA!!\r\u00024\u0005\u0019\u0011\r]5\u000b\t\u0005U\u0012qG\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\tId^\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003{\tyC\u0001\u0005UKN$\u0018J\u001c4p\u00031!Xm\u001d;J]\u001a|w\fJ3r)\u0011\t\u0019%!\u0013\u0011\u0007%\u000b)%C\u0002\u0002H)\u0013A!\u00168ji\"I\u00111J\u0007\u0002\u0002\u0003\u0007\u00111F\u0001\u0004q\u0012\n\u0014!\u0003;fgRLeNZ8!\u00039IW\u000e\u001d7f[\u0016tG/\u0019;j_:,\"!a\u0015\u0011\u0007]\u000b)&C\u0002\u0002X\t\u0013A#U;peVl\u0017*\u001c9mK6,g\u000e^1uS>t\u0017AE5na2,W.\u001a8uCRLwN\\0%KF$B!a\u0011\u0002^!I\u00111\n\t\u0002\u0002\u0003\u0007\u00111K\u0001\u0010S6\u0004H.Z7f]R\fG/[8oA\u0005\u0001\"m\\8ugR\u0014\u0018\r\u001d*fG>\u0014Hm]\u000b\u0003\u0003K\u0002b!a\u001a\u0002n\u0005ETBAA5\u0015\r\tYg`\u0001\b[V$\u0018M\u00197f\u0013\u0011\ty'!\u001b\u0003\u00151K7\u000f\u001e\"vM\u001a,'\u000f\u0005\u0003\u0002\u001e\u0005M\u0014\u0002BA;\u0003?\u0011A#\u00119j\u001b\u0016\u001c8/Y4f\u0003:$g+\u001a:tS>t\u0017!\u00052p_R\u001cHO]1q%\u0016\u001cwN\u001d3tA\u0005Y\u0011n]&SC\u001a$H+Z:u)\u00059\u0017!E5t5.l\u0015n\u001a:bi&|g\u000eV3ti\u0006i1\r[3dW&\u001b(l\u0013+fgR$\"!a\u0011\u0002!\rDWmY6Jg.\u0013\u0016M\u001a;UKN$\u0018\u0001B1t5.$\"!!#\u0011\u0007]\u000bY)C\u0002\u0002\u000e\n\u0013QDW8p\u0017\u0016,\u0007/\u001a:Rk>\u0014X/\\%na2,W.\u001a8uCRLwN\\\u0001\bCN\\%+\u00194u)\t\t\u0019\nE\u0002X\u0003+K1!a&C\u0005eY%+\u00194u#V|'/^7J[BdW-\\3oi\u0006$\u0018n\u001c8\u0002\u0013i|wn[3fa\u0016\u0014XCAAO!\u0011\ty*!*\u000e\u0005\u0005\u0005&bAAR\t\u0006\u0011!p[\u0005\u0005\u0003O\u000b\tKA\tF[\n,G\rZ3e5>|7.Z3qKJ\f\u0001B_6DY&,g\u000e^\u000b\u0003\u0003[\u0003B!a(\u00020&!\u0011\u0011WAQ\u00055Y\u0015MZ6b5.\u001cE.[3oi\u0006q!p[\"mS\u0016tGo\u0014:Ok2d\u0017!D1e[&t'l[\"mS\u0016tG/\u0006\u0002\u0002:B!\u0011qTA^\u0013\u0011\ti,!)\u0003\u001b\u0005#W.\u001b8[W\u000ec\u0017.\u001a8u\u0003\u0019Q8\u000eU8si\u0006I!p[\"p]:,7\r^\u000b\u0003\u0003\u000b\u0004B!a2\u0002V:!\u0011\u0011ZAi!\r\tYMS\u0007\u0003\u0003\u001bT1!a4G\u0003\u0019a$o\\8u}%\u0019\u00111\u001b&\u0002\rA\u0013X\rZ3g\u0013\u0011\t9.!7\u0003\rM#(/\u001b8h\u0015\r\t\u0019NS\u0001\u0010u.\u001cuN\u001c8fGR|%OT;mY\u0006\u00012m\u001c8ue>dG.\u001a:TKJ4XM]\u000b\u0003\u0003C\u00042aVAr\u0013\r\t)O\u0011\u0002\u0011\u0007>tGO]8mY\u0016\u00148+\u001a:wKJ\f\u0001d\u001d5vi\u0012|wO\\\"p]R\u0014x\u000e\u001c7feN+'O^3s)\t\tY\u000f\u0005\u0003\u0002n\u0006MXBAAx\u0015\u0011\t\t0a\u0004\u0002\t1\fgnZ\u0005\u0005\u0003k\fyOA\u0004J]R,w-\u001a:\u0002/I,7\u000f^1si\u000e{g\u000e\u001e:pY2,'oU3sm\u0016\u0014H\u0003BA\"\u0003wDq!!@$\u0001\u0004\tY/\u0001\u0005qe\u00164\bk\u001c:u\u0003E\u0019wN\u001c;s_2dWM]*feZ,'o]\u000b\u0003\u0005\u0007\u0001RA`A\u0002\u0003C\f1CZ1vYRD\u0015M\u001c3mKJ4\u0015m\u0019;pef,\"A!\u0003\u0011\u0007]\u0013Y!C\u0002\u0003\u000e\t\u0013A%U;peVlG+Z:u\u0011\u0006\u0014h.Z:t\r\u0006,H\u000e\u001e%b]\u0012dWM\u001d$bGR|'/_\u0001\u0015M\u0006,H\u000e\u001e%b]\u0012dWM\u001d$bGR|'/\u001f\u0011\u0002+\rdWo\u001d;fe\n\u000bG.\u00198dK6\u000bg.Y4feV\u0011!Q\u0003\t\u0005\u0013\u0016\u00149\u0002\u0005\u0003\u0003\u001a\t}QB\u0001B\u000e\u0015\r\u0011i\u0002R\u0001\u000bG>tGO]8mY\u0016\u0014\u0018\u0002\u0002B\u0011\u00057\u0011Qc\u00117vgR,'OQ1mC:\u001cW-T1oC\u001e,'/A\rdYV\u001cH/\u001a:CC2\fgnY3NC:\fw-\u001a:`I\u0015\fH\u0003BA\"\u0005OA\u0011\"a\u0013*\u0003\u0003\u0005\rA!\u0006\u0002-\rdWo\u001d;fe\n\u000bG.\u00198dK6\u000bg.Y4fe\u0002\nABZ1vYRD\u0015M\u001c3mKJ,\"Aa\f\u0011\t\tE\"qG\u0007\u0003\u0005gQAA!\u000e\u0002\"\u0005)a-Y;mi&!!\u0011\bB\u001a\u0005AiunY6GCVdG\u000fS1oI2,'/A\u0007gCVdG\u000fS1oI2,'\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0005\u0003\u0007\u0012\t\u0005C\u0004\u0002(5\u0002\r!a\u000b)\u00075\u0012)\u0005\u0005\u0003\u0002.\t\u001d\u0013\u0002\u0002B%\u0003_\u0011!BQ3g_J,W)Y2i\u00031\u0019'/Z1uK\n\u0013xn[3s))\u0011yE!\u0016\u0003`\t5$\u0011\u000f\t\u0004/\nE\u0013b\u0001B*\u0005\nY1*\u00194lC\n\u0013xn[3s\u0011\u001d\u00119F\fa\u0001\u00053\naaY8oM&<\u0007cA,\u0003\\%\u0019!Q\f\"\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\n\u0005Cr\u0003\u0013!a\u0001\u0005G\nA\u0001^5nKB!!Q\rB5\u001b\t\u00119G\u0003\u0002Re&!!1\u000eB4\u0005\u0011!\u0016.\\3\t\u0011\t=d\u0006%AA\u0002\u001d\fqa\u001d;beR,\b\u000fC\u0005\u0003t9\u0002\n\u00111\u0001\u0003v\u0005\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\t\u0005\u0013\u0016\f)-\u0001\fde\u0016\fG/\u001a\"s_.,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011YH\u000b\u0003\u0003d\tu4F\u0001B@!\u0011\u0011\tIa#\u000e\u0005\t\r%\u0002\u0002BC\u0005\u000f\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t%%*\u0001\u0006b]:|G/\u0019;j_:LAA!$\u0003\u0004\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002-\r\u0014X-\u0019;f\u0005J|7.\u001a:%I\u00164\u0017-\u001e7uIM*\"Aa%+\u0007\u001d\u0014i(\u0001\fde\u0016\fG/\u001a\"s_.,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011IJ\u000b\u0003\u0003v\tu\u0014!E:ikR$wn\u001e8[_>\\U-\u001a9fe\u000692\u000f[;uI><hn\u0013*bMR\u001cuN\u001c;s_2dWM]\u0001\u0018_B$\u0018n\u001c8bY6+G/\u00193bi\u0006\u0014VmY8sIN,\"Aa)\u0011\t%+'Q\u0015\t\u0007\u0003O\u00129+!\u001d\n\t\t%\u0016\u0011\u000e\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'/A\tg_Jl\u0017\r\u001e#je\u0016\u001cGo\u001c:jKN$b!a\u0011\u00030\nu\u0006b\u0002BYk\u0001\u0007!1W\u0001\fI&\u0014Xm\u0019;pe&,7\u000f\u0005\u0004\u00036\nm\u0016QY\u0007\u0003\u0005oS1A!/\u0000\u0003%IW.\\;uC\ndW-\u0003\u0003\u0002\u0006\t]\u0006b\u0002B`k\u0001\u0007!\u0011Y\u0001\u000f[\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t!\r9&1Y\u0005\u0004\u0005\u000b\u0014%AD'fi\u0006\u0004&o\u001c9feRLWm]\u0001\u000f]\u0016<8JU1giF+xN];n)\u0011\t\u0019Ja3\t\u000f\u0005\u001db\u00071\u0001\u0002,\u0005\u0011b.Z<[_>\\U-\u001a9feF+xN];n\u0003!!X-\u0019:E_^t\u0007f\u0001\u001d\u0003TB!\u0011Q\u0006Bk\u0013\u0011\u00119.a\f\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017aK2sK\u0006$XMW8p\u0017\u0016,\u0007/\u001a:DY&,g\u000e\u001e+p)JLwmZ3s'\u0016\u001c8/[8o\u000bb\u0004\u0018N]=\u0015\t\tu'q\u001d\t\u0005\u0005?\u0014\u0019/\u0004\u0002\u0003b*\u0019\u0011\u0011T;\n\t\t\u0015(\u0011\u001d\u0002\n5>|7*Z3qKJDqA!;:\u0001\u0004\u0011i.A\u0005{_>\\U-\u001a9fe\":\u0001A!<\u0003t\nU\b\u0003BA\u0017\u0005_LAA!=\u00020\t\u0019A+Y4\u0002\u000bY\fG.^3\"\u0005\t]\u0018aC5oi\u0016<'/\u0019;j_:\f\u0011#U;peVlG+Z:u\u0011\u0006\u0014h.Z:t!\t96h\u0005\u0002<\u0011R\u0011!1`\u0001\u001a5.\u001cE.[3oi\u00163XM\u001c;UQJ,\u0017\rZ*vM\u001aL\u00070\u0006\u0002\u0004\u0006A!\u0011Q^B\u0004\u0013\u0011\t9.a<\u00025i[7\t\\5f]R,e/\u001a8u)\"\u0014X-\u00193Tk\u001a4\u0017\u000e\u001f\u0011\u0002\u0015M,G/\u00169DY\u0006\u001c8\u000fK\u0002@\u0007\u001f\u0001B!!\f\u0004\u0012%!11CA\u0018\u0005%\u0011UMZ8sK\u0006cG.A\u0007uK\u0006\u0014Hi\\<o\u00072\f7o\u001d\u0015\u0004\u0001\u000ee\u0001\u0003BA\u0017\u00077IAa!\b\u00020\tA\u0011I\u001a;fe\u0006cG\u000e")
public abstract class QuorumTestHarness
implements Logging {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final int zkMaxInFlightRequests = Integer.MAX_VALUE;
    private TestInfo testInfo;
    private QuorumImplementation implementation;
    private final ListBuffer<ApiMessageAndVersion> bootstrapRecords = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final QuorumTestHarnessFaultHandlerFactory faultHandlerFactory = new QuorumTestHarnessFaultHandlerFactory(new MockFaultHandler("quorumTestHarnessFaultHandler"));
    private Option<ClusterBalanceManager> clusterBalanceManager = Option$.MODULE$.empty();
    private final MockFaultHandler faultHandler = this.faultHandlerFactory().faultHandler();
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @AfterAll
    public static void tearDownClass() {
        QuorumTestHarness$.MODULE$.tearDownClass();
    }

    @BeforeAll
    public static void setUpClass() {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@BeforeAll");
    }

    public static String ZkClientEventThreadSuffix() {
        return QuorumTestHarness$.MODULE$.ZkClientEventThreadSuffix();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    public int zkMaxInFlightRequests() {
        return this.zkMaxInFlightRequests;
    }

    public Option<Object> zkAclsEnabled() {
        return None$.MODULE$;
    }

    public SecurityProtocol controllerListenerSecurityProtocol() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Seq<Properties> kraftControllerConfigs() {
        return new .colon.colon((Object)new Properties(), (List)Nil$.MODULE$);
    }

    public MetadataVersion metadataVersion() {
        return MetadataVersion.latest();
    }

    private TestInfo testInfo() {
        return this.testInfo;
    }

    private void testInfo_$eq(TestInfo x$1) {
        this.testInfo = x$1;
    }

    private QuorumImplementation implementation() {
        return this.implementation;
    }

    private void implementation_$eq(QuorumImplementation x$1) {
        this.implementation = x$1;
    }

    public ListBuffer<ApiMessageAndVersion> bootstrapRecords() {
        return this.bootstrapRecords;
    }

    public boolean isKRaftTest() {
        return TestInfoUtils$.MODULE$.isKRaft(this.testInfo());
    }

    public boolean isZkMigrationTest() {
        return TestInfoUtils$.MODULE$.isZkMigrationTest(this.testInfo());
    }

    public void checkIsZKTest() {
        if (this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in KRaft mode. ZooKeeper mode is required.");
        }
    }

    public void checkIsKRaftTest() {
        if (!this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in ZooKeeper mode. KRaft mode is required.");
        }
    }

    private ZooKeeperQuorumImplementation asZk() {
        this.checkIsZKTest();
        return (ZooKeeperQuorumImplementation)this.implementation();
    }

    private KRaftQuorumImplementation asKRaft() {
        this.checkIsKRaftTest();
        return (KRaftQuorumImplementation)this.implementation();
    }

    public EmbeddedZookeeper zookeeper() {
        return this.asZk().zookeeper();
    }

    public KafkaZkClient zkClient() {
        return this.asZk().zkClient();
    }

    public KafkaZkClient zkClientOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.asZk().zkClient();
    }

    public AdminZkClient adminZkClient() {
        return this.asZk().adminZkClient();
    }

    public int zkPort() {
        return this.asZk().zookeeper().port();
    }

    public String zkConnect() {
        return new StringBuilder(10).append("127.0.0.1:").append(this.zkPort()).toString();
    }

    public String zkConnectOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.zkConnect();
    }

    public ControllerServer controllerServer() {
        return this.asKRaft().controllerServer();
    }

    public Integer shutdownControllerServer() {
        if (!this.isKRaftTest()) {
            throw new UnsupportedOperationException("Non-KRaft tests do not have a controller server");
        }
        return this.asKRaft().shutdownController();
    }

    public void restartControllerServer(Integer prevPort) {
        if (!this.isKRaftTest()) {
            throw new UnsupportedOperationException("Non-KRaft tests do not have a controller server");
        }
        this.asKRaft().restartController(prevPort);
    }

    public void restartControllerServer() {
        if (!this.isKRaftTest()) {
            throw new UnsupportedOperationException("Non-KRaft tests do not have a controller server");
        }
        this.asKRaft().restartController();
    }

    public Seq<ControllerServer> controllerServers() {
        if (this.isKRaftTest()) {
            return new .colon.colon((Object)this.asKRaft().controllerServer(), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    public QuorumTestHarnessFaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    public Option<ClusterBalanceManager> clusterBalanceManager() {
        return this.clusterBalanceManager;
    }

    public void clusterBalanceManager_$eq(Option<ClusterBalanceManager> x$1) {
        this.clusterBalanceManager = x$1;
    }

    public MockFaultHandler faultHandler() {
        return this.faultHandler;
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testInfo_$eq(testInfo);
        Exit.setExitProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("exit(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        Exit.setHaltProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("halt(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        String name = (String)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(testInfo.getTestMethod())).map((Function1 & Serializable)x$3 -> x$3.toString()).getOrElse((Function0 & Serializable)() -> "[unspecified]");
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("Running KRAFT test ").append(name).toString());
            this.implementation_$eq(this.newKRaftQuorum(testInfo));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(16).append("Running ZK test ").append(name).toString());
        this.implementation_$eq(this.newZooKeeperQuorum());
    }

    public KafkaBroker createBroker(KafkaConfig config, Time time, boolean startup, Option<String> threadNamePrefix) {
        return this.implementation().createBroker(config, time, startup, threadNamePrefix);
    }

    public Time createBroker$default$2() {
        return Time.SYSTEM;
    }

    public boolean createBroker$default$3() {
        return true;
    }

    public Option<String> createBroker$default$4() {
        return None$.MODULE$;
    }

    public void shutdownZooKeeper() {
        this.asZk().shutdown();
    }

    public void shutdownKRaftController() {
        KRaftQuorumImplementation kRaftQuorumImplementation = this.asKRaft();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> kRaftQuorumImplementation.controllerServer().shutdown(), kRaftQuorumImplementation.log(), Level.WARN);
    }

    public Option<ArrayBuffer<ApiMessageAndVersion>> optionalMetadataRecords() {
        return None$.MODULE$;
    }

    private void formatDirectories(scala.collection.immutable.Seq<String> directories, MetaProperties metaProperties) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream out = null;
        try {
            out = new PrintStream(stream);
            BootstrapMetadata bootstrapMetadata = StorageTool$.MODULE$.buildBootstrapMetadata(this.metadataVersion(), this.optionalMetadataRecords(), "format command");
            if (StorageTool$.MODULE$.formatCommand(out, directories, metaProperties, bootstrapMetadata, this.metadataVersion(), false) != 0) {
                throw new RuntimeException(stream.toString());
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Formatted storage directory(ies) ").append(directories).toString());
        }
        catch (Throwable throwable) {
            if (out != null) {
                out.close();
            }
            stream.close();
            throw throwable;
        }
        out.close();
        stream.close();
    }

    public KRaftQuorumImplementation newKRaftQuorum(TestInfo testInfo) {
        Seq<Properties> propsList = this.kraftControllerConfigs();
        if (propsList.size() != 1) {
            throw new RuntimeException("Only one KRaft controller is supported for now.");
        }
        Properties props = (Properties)propsList.apply(0);
        props.setProperty(KafkaConfig$.MODULE$.ServerMaxStartupTimeMsProp(), Long.toString(TimeUnit.MINUTES.toMillis(10L)));
        if (TestInfoUtils$.MODULE$.isCombinedKRaft(testInfo)) {
            props.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller,broker");
            props.setProperty(KafkaConfig$.MODULE$.LogDirProp(), TestUtils$.MODULE$.tempDir().getAbsolutePath());
        } else {
            props.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        }
        if (props.getProperty(KafkaConfig$.MODULE$.NodeIdProp()) == null) {
            props.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1000");
        }
        props.setProperty("confluent.security.event.logger.exporter.kafka.topic.replicas", "1");
        int nodeId = Integer.parseInt(props.getProperty(KafkaConfig$.MODULE$.NodeIdProp()));
        File metadataDir = TestUtils$.MODULE$.tempDir();
        MetaProperties metaProperties = new MetaProperties(Uuid.randomUuid().toString(), nodeId);
        this.formatDirectories((scala.collection.immutable.Seq<String>)new .colon.colon((Object)metadataDir.getAbsolutePath(), (List)Nil$.MODULE$), metaProperties);
        ArrayList<ApiMessageAndVersion> metadataRecords = new ArrayList<ApiMessageAndVersion>();
        metadataRecords.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel(this.metadataVersion().confluentFeatureLevel()), (short)0));
        this.optionalMetadataRecords().foreach((Function1 & Serializable)metadataArguments -> {
            metadataArguments.foreach((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)metadataRecords$1.add(record)));
            return BoxedUnit.UNIT;
        });
        BootstrapMetadata bootstrapMetadata = BootstrapMetadata.fromRecords(metadataRecords, (String)"test harness");
        props.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), metadataDir.getAbsolutePath());
        if (!props.containsKey(KafkaConfig$.MODULE$.ControllerListenerNamesProp())) {
            String proto = this.controllerListenerSecurityProtocol().toString();
            props.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(11).append("CONTROLLER:").append(proto).toString());
            props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "CONTROLLER://localhost:0");
            props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
        }
        props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        KafkaConfig config = new KafkaConfig((Map)props);
        CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture = new CompletableFuture<Map<Integer, RaftConfig.AddressSpec>>();
        SharedServer sharedServer = new SharedServer(config, metaProperties, Time.SYSTEM, new Metrics(), controllerQuorumVotersFuture, (FaultHandlerFactory)this.faultHandlerFactory(), (Option)None$.MODULE$, KafkaRaftServer$.MODULE$.configSchema());
        ObjectRef controllerServer = ObjectRef.create(null);
        try {
            this.clusterBalanceManager_$eq((Option<ClusterBalanceManager>)Option$.MODULE$.apply((Object)ClusterBalanceManager.clusterBalanceManager((KafkaConfig)config)));
            controllerServer.elem = new ControllerServer(sharedServer, KafkaRaftServer$.MODULE$.configSchema(), bootstrapMetadata, this.clusterBalanceManager());
            ((ControllerServer)controllerServer.elem).socketServerFirstBoundPortFuture().whenComplete((port, e) -> {
                if (e != null) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error completing controller socket server future", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    controllerQuorumVotersFuture.completeExceptionally((Throwable)e);
                    return;
                }
                controllerQuorumVotersFuture.complete(Collections.singletonMap(Predef$.MODULE$.int2Integer(nodeId), new RaftConfig.InetAddressSpec(new InetSocketAddress("localhost", Predef$.MODULE$.Integer2int(port)))));
            });
            ((ControllerServer)controllerServer.elem).startup();
        }
        catch (Throwable e2) {
            if ((ControllerServer)controllerServer.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> ((ControllerServer)controllerServer$1.elem).shutdown(), (Logging)this, Level.WARN);
            }
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> sharedServer.stopForController(), (Logging)this, Level.WARN);
            throw e2;
        }
        return new KRaftQuorumImplementation((ControllerServer)controllerServer.elem, this.faultHandlerFactory(), metadataDir, controllerQuorumVotersFuture, metaProperties.clusterId(), this, (FaultHandler)this.faultHandler());
    }

    private ZooKeeperQuorumImplementation newZooKeeperQuorum() {
        AdminZkClient adminZkClient;
        EmbeddedZookeeper zookeeper = new EmbeddedZookeeper();
        ObjectRef zkClient = ObjectRef.create(null);
        String zkConnect = new StringBuilder(10).append("127.0.0.1:").append(zookeeper.port()).toString();
        try {
            zkClient.elem = KafkaZkClient$.MODULE$.apply(zkConnect, BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> JaasUtils.isZkSaslEnabled())), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "ZooKeeperTestHarness", new ZKClientConfig(), "kafka.server", "SessionExpireListener", false);
            adminZkClient = new AdminZkClient((KafkaZkClient)zkClient.elem);
        }
        catch (Throwable t) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> zookeeper.shutdown(), (Logging)this, Level.WARN);
            if ((KafkaZkClient)zkClient.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> ((KafkaZkClient)zkClient$1.elem).close(), (Logging)this, Level.WARN);
            }
            throw t;
        }
        return new ZooKeeperQuorumImplementation(zookeeper, zkConnect, (KafkaZkClient)zkClient.elem, adminZkClient, this);
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        this.clusterBalanceManager().foreach((Function1 & Serializable)c -> {
            QuorumTestHarness.$anonfun$tearDown$1(this, c);
            return BoxedUnit.UNIT;
        });
        if (this.implementation() != null) {
            this.implementation().shutdown();
        }
        TestUtils$.MODULE$.clearYammerMetrics();
        System.clearProperty("java.security.auth.login.config");
        Configuration.setConfiguration(null);
        this.faultHandler().maybeRethrowFirstException();
    }

    public ZooKeeper createZooKeeperClientToTriggerSessionExpiry(ZooKeeper zooKeeper) {
        Watcher dummyWatcher = new Watcher(null){

            public void process(WatchedEvent event) {
            }
        };
        ZooKeeper anotherZkClient = new ZooKeeper(this.zkConnect(), 1000, dummyWatcher, zooKeeper.getSessionId(), zooKeeper.getSessionPasswd());
        Assertions.assertNull((Object)anotherZkClient.exists("/nonexistent", false));
        return anotherZkClient;
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(QuorumTestHarness $this, ClusterBalanceManager c) {
        c.onControllerChange(LeaderAndEpoch.UNKNOWN);
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> c.shutdown(), (Logging)$this, Level.WARN);
    }

    public QuorumTestHarness() {
        this.zkConnectionTimeout = 10000;
        this.zkSessionTimeout = 15000;
    }
}

