/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.BrokerFeatures$;
import kafka.server.BrokerTopicStats;
import kafka.server.DiskThrottleListenerManager;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.DiskUsageBasedThrottler$;
import kafka.server.FailedPartitions;
import kafka.server.Fetching$;
import kafka.server.FollowerFetchThrottler;
import kafka.server.FollowerThrottler;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LeaderEndPoint;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory;
import kafka.server.RemoteLeaderEndPoint;
import kafka.server.RemoteLeaderRequestBuilder;
import kafka.server.ReplicaAlterLogDirsManager;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaFetcherThreadTest$Quota$1$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicaState;
import kafka.server.ReplicationQuotaManager;
import kafka.server.RequestBuilder;
import kafka.server.Truncating$;
import kafka.server.epoch.util.MockBlockingSender;
import kafka.server.metadata.ZkMetadataCache;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.utils.DelayedItem;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011=a\u0001B#G\u0001-CQA\u0015\u0001\u0005\u0002MCqA\u0016\u0001C\u0002\u0013%q\u000b\u0003\u0004d\u0001\u0001\u0006I\u0001\u0017\u0005\bI\u0002\u0011\r\u0011\"\u0003X\u0011\u0019)\u0007\u0001)A\u00051\"9a\r\u0001b\u0001\n\u00139\u0006BB4\u0001A\u0003%\u0001\fC\u0004i\u0001\t\u0007I\u0011C5\t\rA\u0004\u0001\u0015!\u0003k\u0011\u001d\t\bA1A\u0005\u0012IDaA\u001e\u0001!\u0002\u0013\u0019\bbB<\u0001\u0005\u0004%I\u0001\u001f\u0005\u0007y\u0002\u0001\u000b\u0011B=\t\u000fu\u0004!\u0019!C\u0005q\"1a\u0010\u0001Q\u0001\neD\u0001b \u0001C\u0002\u0013%\u0011\u0011\u0001\u0005\t\u0003?\u0001\u0001\u0015!\u0003\u0002\u0004!I\u0011\u0011\u0005\u0001C\u0002\u0013%\u00111\u0005\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u0002&!I\u0011q\t\u0001C\u0002\u0013%\u0011\u0011\n\u0005\t\u0003/\u0002\u0001\u0015!\u0003\u0002L!I\u0011\u0011\f\u0001A\u0002\u0013%\u00111\f\u0005\n\u0003S\u0002\u0001\u0019!C\u0005\u0003WB\u0001\"a\u001e\u0001A\u0003&\u0011Q\f\u0005\b\u0003s\u0002A\u0011BA>\u0011%\t\t\u000bAI\u0001\n\u0013\t\u0019\u000bC\u0004\u0002:\u0002!\t!a/\t\u000f\u0005M\u0007\u0001\"\u0005\u0002V\"I!1\u0005\u0001\u0012\u0002\u0013E!Q\u0005\u0005\n\u0005S\u0001\u0011\u0013!C\t\u0005WAqAa\f\u0001\t#\u0011\t\u0004C\u0005\u0003\u0018\u0002\t\n\u0011\"\u0005\u0003&!9!\u0011\u0014\u0001\u0005\u0002\u0005m\u0006b\u0002BR\u0001\u0011\u0005\u00111\u0018\u0005\b\u0005O\u0003A\u0011\u0001BU\u0011\u001d\u0011)\r\u0001C\u0001\u0003wCqA!3\u0001\t\u0003\tY\fC\u0004\u0003N\u0002!\t!a/\t\u000f\tE\u0007\u0001\"\u0005\u0003T\"I!\u0011\u001e\u0001\u0012\u0002\u0013E\u00111\u0015\u0005\b\u0005W\u0004A\u0011\u0003Bw\u0011\u001d\u0019\u0019\u0002\u0001C\u0001\u0007+A\u0011ba\b\u0001#\u0003%\t!a)\t\u000f\r\u0005\u0002\u0001\"\u0001\u0002<\"91Q\u0005\u0001\u0005\u0002\u0005m\u0006bBB\u0015\u0001\u0011\u0005\u00111\u0018\u0005\b\u0007[\u0001A\u0011AA^\u0011\u001d\u0019\t\u0004\u0001C\u0001\u0003wCqa!\u000e\u0001\t\u0003\tY\fC\u0004\u0004:\u0001!\t!a/\t\u000f\ru\u0002\u0001\"\u0001\u0002<\"91\u0011\t\u0001\u0005\u0002\u0005m\u0006bBB#\u0001\u0011\u0005\u00111\u0018\u0005\b\u0007\u0013\u0002A\u0011AA^\u0011\u001d\u0019i\u0005\u0001C\u0001\u0007\u001fBqa!\u0016\u0001\t\u0003\tY\fC\u0004\u0004Z\u0001!\t!a/\t\u000f\ru\u0003\u0001\"\u0001\u0002<\"91\u0011\r\u0001\u0005\u0002\u0005m\u0006bBB3\u0001\u0011\u0005\u00111\u0018\u0005\b\u0007S\u0002A\u0011AA^\u0011\u001d\u0019i\u0007\u0001C\u0001\u0003wCqa!\u001d\u0001\t\u0003\u0019\u0019\bC\u0004\u0004\u001e\u0002!Iaa(\t\u000f\ru\u0005\u0001\"\u0003\u0004N\"91Q\u001d\u0001\u0005\n\r\u001d\bbBBw\u0001\u0011\u00051q\u001e\u0005\b\t\u0017\u0001A\u0011\u0002C\u0007\u0005a\u0011V\r\u001d7jG\u00064U\r^2iKJ$\u0006N]3bIR+7\u000f\u001e\u0006\u0003\u000f\"\u000baa]3sm\u0016\u0014(\"A%\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0014\t\u0003\u001bBk\u0011A\u0014\u0006\u0002\u001f\u0006)1oY1mC&\u0011\u0011K\u0014\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0006CA+\u0001\u001b\u00051\u0015\u0001\u0002;2aB*\u0012\u0001\u0017\t\u00033\u0006l\u0011A\u0017\u0006\u00037r\u000baaY8n[>t'BA%^\u0015\tqv,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0006\u0019qN]4\n\u0005\tT&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0006iF\u0002\b\u0007I\u0001\u0005iF\u0002\u0018'A\u0003ucA\f\u0004%\u0001\u0003ueA\f\u0014!\u0002;3aF\u0002\u0013A\u00042s_.,'/\u00128e!>Lg\u000e^\u000b\u0002UB\u00111N\\\u0007\u0002Y*\u0011Q\u000eS\u0001\bG2,8\u000f^3s\u0013\tyGN\u0001\bCe>\\WM]#oIB{\u0017N\u001c;\u0002\u001f\t\u0014xn[3s\u000b:$\u0007k\\5oi\u0002\n\u0001CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0016\u0003M\u0004\"!\u0016;\n\u0005U4%\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003E1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7\u000fI\u0001\ti>\u0004\u0018nY%ecU\t\u0011\u0010\u0005\u0002Zu&\u00111P\u0017\u0002\u0005+VLG-A\u0005u_BL7-\u001332A\u0005AAo\u001c9jG&#''A\u0005u_BL7-\u001333A\u0005AAo\u001c9jG&#7/\u0006\u0002\u0002\u0004A9\u0011QAA\u0006\u0003\u001fIXBAA\u0004\u0015\r\tIAT\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0007\u0003\u000f\u00111!T1q!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\tA\u0001\\1oO*\u0011\u0011\u0011D\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001e\u0005M!AB*ue&tw-A\u0005u_BL7-\u00133tA\u0005y\u0001/\u0019:uSRLwN\\*uCR,7/\u0006\u0002\u0002&A1\u0011qEA\u0017\u0003ci!!!\u000b\u000b\t\u0005-\u0012qC\u0001\u0005kRLG.\u0003\u0003\u00020\u0005%\"\u0001\u0002'jgR\u0004B!a\r\u0002@9!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:i\u000bq!\\3tg\u0006<W-\u0003\u0003\u0002>\u0005]\u0012!G+qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e#bi\u0006LA!!\u0011\u0002D\taR\u000b\u001d3bi\u0016lU\r^1eCR\f\u0007+\u0019:uSRLwN\\*uCR,'\u0002BA\u001f\u0003o\t\u0001\u0003]1si&$\u0018n\u001c8Ti\u0006$Xm\u001d\u0011\u0002+U\u0004H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiV\u0011\u00111\n\t\u0005\u0003\u001b\n\u0019&\u0004\u0002\u0002P)\u0019\u0011\u0011\u000b.\u0002\u0011I,\u0017/^3tiNLA!!\u0016\u0002P\t)R\u000b\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$\u0018AF;qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\u0011\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f+\t\ti\u0006\u0005\u0003\u0002`\u0005\u0015TBAA1\u0015\r\t\u0019GR\u0001\t[\u0016$\u0018\rZ1uC&!\u0011qMA1\u0005=Q6.T3uC\u0012\fG/Y\"bG\",\u0017!E7fi\u0006$\u0017\r^1DC\u000eDWm\u0018\u0013fcR!\u0011QNA:!\ri\u0015qN\u0005\u0004\u0003cr%\u0001B+oSRD\u0011\"!\u001e\u0018\u0003\u0003\u0005\r!!\u0018\u0002\u0007a$\u0013'\u0001\bnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0011\u0002#%t\u0017\u000e^5bY\u001a+Go\u00195Ti\u0006$X\r\u0006\u0005\u0002~\u0005\r\u0015QRAL!\r)\u0016qP\u0005\u0004\u0003\u00033%!E%oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uK\"9\u0011QQ\rA\u0002\u0005\u001d\u0015a\u0002;pa&\u001c\u0017\n\u001a\t\u0005\u001b\u0006%\u00150C\u0002\u0002\f:\u0013aa\u00149uS>t\u0007bBAH3\u0001\u0007\u0011\u0011S\u0001\fM\u0016$8\r[(gMN,G\u000fE\u0002N\u0003'K1!!&O\u0005\u0011auN\\4\t\u0013\u0005e\u0015\u0004%AA\u0002\u0005m\u0015a\u00037fC\u0012,'/\u00129pG\"\u00042!TAO\u0013\r\tyJ\u0014\u0002\u0004\u0013:$\u0018aG5oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uK\u0012\"WMZ1vYR$3'\u0006\u0002\u0002&*\"\u00111TATW\t\tI\u000b\u0005\u0003\u0002,\u0006UVBAAW\u0015\u0011\ty+!-\u0002\u0013Ut7\r[3dW\u0016$'bAAZ\u001d\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0016Q\u0016\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aB2mK\u0006tW\u000f\u001d\u000b\u0003\u0003[B3aGA`!\u0011\t\t-a4\u000e\u0005\u0005\r'\u0002BAc\u0003\u000f\f1!\u00199j\u0015\u0011\tI-a3\u0002\u000f),\b/\u001b;fe*\u0019\u0011QZ0\u0002\u000b),h.\u001b;\n\t\u0005E\u00171\u0019\u0002\n\u0003\u001a$XM]#bG\"\f!d\u0019:fCR,'+Z7pi\u0016dU-\u00193fe\u0016sG\rU8j]R$b\"a6\u0002^\u0006\u001d\u0018\u0011_A~\u0005\u000b\u00119\u0002E\u0002V\u00033L1!a7G\u0005Q\u0011V-\\8uK2+\u0017\rZ3s\u000b:$\u0007k\\5oi\"9\u0011q\u001c\u000fA\u0002\u0005\u0005\u0018\u0001\u00042s_.,'oQ8oM&<\u0007cA+\u0002d&\u0019\u0011Q\u001d$\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b\u0003Sd\u0002\u0019AAv\u0003)\u0011X\r\u001d7jG\u0006luM\u001d\t\u0004+\u00065\u0018bAAx\r\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bbBAz9\u0001\u0007\u0011Q_\u0001\u0006cV|G/\u0019\t\u0004+\u0006]\u0018bAA}\r\na!+\u001a9mS\u000e\f\u0017+^8uC\"9\u0011Q \u000fA\u0002\u0005}\u0018A\u00077fC\u0012,'/\u00128ea>Lg\u000e\u001e\"m_\u000e\\\u0017N\\4TK:$\u0007cA+\u0003\u0002%\u0019!1\u0001$\u0003\u0019\tcwnY6j]\u001e\u001cVM\u001c3\t\u0013\t\u001dA\u0004%AA\u0002\t%\u0011!\u00047pO\u000e{g\u000e^3yi>\u0003H\u000fE\u0003N\u0003\u0013\u0013Y\u0001\u0005\u0003\u0003\u000e\tMQB\u0001B\b\u0015\r\u0011\tBW\u0001\u0006kRLGn]\u0005\u0005\u0005+\u0011yA\u0001\u0006M_\u001e\u001cuN\u001c;fqRD\u0011B!\u0007\u001d!\u0003\u0005\rAa\u0007\u0002\u000fQLW.Z(qiB)Q*!#\u0003\u001eA!!Q\u0002B\u0010\u0013\u0011\u0011\tCa\u0004\u0003\tQKW.Z\u0001%GJ,\u0017\r^3SK6|G/\u001a'fC\u0012,'/\u00128e!>Lg\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!q\u0005\u0016\u0005\u0005\u0013\t9+\u0001\u0013de\u0016\fG/\u001a*f[>$X\rT3bI\u0016\u0014XI\u001c3Q_&tG\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011iC\u000b\u0003\u0003\u001c\u0005\u001d\u0016AG2sK\u0006$XMU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$G\u0003\bB\u001a\u0005s\u0011\tF!\u0016\u0003Z\tm#Q\fB4\u0005S\u00129Ha\u001f\u0003~\t}$Q\u0013\t\u0004+\nU\u0012b\u0001B\u001c\r\n!\"+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012DqAa\u000f \u0001\u0004\u0011i$\u0001\u0003oC6,\u0007\u0003\u0002B \u0005\u001brAA!\u0011\u0003JA\u0019!1\t(\u000e\u0005\t\u0015#b\u0001B$\u0015\u00061AH]8pizJ1Aa\u0013O\u0003\u0019\u0001&/\u001a3fM&!\u0011Q\u0004B(\u0015\r\u0011YE\u0014\u0005\b\u0005'z\u0002\u0019AAN\u0003%1W\r^2iKJLE\r\u0003\u0004\u0003X}\u0001\rA[\u0001\rg>,(oY3Ce>\\WM\u001d\u0005\b\u0003?|\u0002\u0019AAq\u0011\u0015\tx\u00041\u0001t\u0011\u001d\u0011yf\ba\u0001\u0005C\n!#\u001a=q_:,g\u000e^5bY\n\u000b7m[8gMB!!Q\u0002B2\u0013\u0011\u0011)Ga\u0004\u0003%\u0015C\bo\u001c8f]RL\u0017\r\u001c\"bG.|gM\u001a\u0005\b\u0003S|\u0002\u0019AAv\u0011\u001d\u0011Yg\ba\u0001\u0005[\nq!\\3ue&\u001c7\u000f\u0005\u0003\u0003p\tMTB\u0001B9\u0015\r\u0011YGW\u0005\u0005\u0005k\u0012\tHA\u0004NKR\u0014\u0018nY:\t\u000f\tet\u00041\u0001\u0003\u001e\u0005!A/[7f\u0011\u001d\t\u0019p\ba\u0001\u0003kDq!!@ \u0001\u0004\ty\u0010C\u0004\u0003\u0002~\u0001\rAa!\u0002!QLWM]*uCR,g)\u001a;dQ\u0016\u0014\b#B'\u0002\n\n\u0015\u0005\u0003\u0002BD\u0005#k!A!#\u000b\t\t-%QR\u0001\bM\u0016$8\r[3s\u0015\r\u0011y\tS\u0001\u0005i&,'/\u0003\u0003\u0003\u0014\n%%\u0001\u0005+jKJ\u001cF/\u0019;f\r\u0016$8\r[3s\u0011%\u00119a\bI\u0001\u0002\u0004\u0011I!A\u0013de\u0016\fG/\u001a*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fG\r\n3fM\u0006,H\u000e\u001e\u00132g\u0005A3\u000f[8vY\u0012\u001cVM\u001c3MCR,7\u000f\u001e*fcV,7\u000f\u001e,feNLwN\\:Cs\u0012+g-Y;mi\"\u001a\u0011E!(\u0011\t\u0005\u0005'qT\u0005\u0005\u0005C\u000b\u0019M\u0001\u0003UKN$\u0018A\u0010;fgR4U\r^2i\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3rk\u0016\u001cH/\u00134MCN$X\t]8dQ\u0012+g-\u001b8fI\u001a{'oU8nKB\u000b'\u000f^5uS>t7\u000fK\u0002#\u0005;\u000bQ#Y:tKJ$\b+\u0019:uSRLwN\\*uCR,7\u000f\u0006\u0006\u0002n\t-&1\u0017B_\u0005\u0003DqAa#$\u0001\u0004\u0011i\u000bE\u0002V\u0005_K1A!-G\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012DqA!.$\u0001\u0004\u00119,A\u000btQ>,H\u000e\u001a\"f%\u0016\fG-\u001f$pe\u001a+Go\u00195\u0011\u00075\u0013I,C\u0002\u0003<:\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0003@\u000e\u0002\rAa.\u0002+MDw.\u001e7e\u0005\u0016$&/\u001e8dCRLgn\u001a'pO\"9!1Y\u0012A\u0002\t]\u0016aD:i_VdGMQ3EK2\f\u00170\u001a3\u0002KMDw.\u001e7e\u0011\u0006tG\r\\3Fq\u000e,\u0007\u000f^5p]\u001a\u0013x.\u001c\"m_\u000e\\\u0017N\\4TK:$\u0007f\u0001\u0013\u0003\u001e\u0006\u00195\u000f[8vY\u00124U\r^2i\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00148GSJ\u001cHOR3uG\"|e\u000e\\=JM2+\u0017\rZ3s\u000bB|7\r[&o_^tGk\u001c\"pi\"L%\r\u001d\u001a7Q\r)#QT\u00019g\"|W\u000f\u001c3O_R4U\r^2i\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00148GSJ\u001cHOR3uG\"<\u0016\u000e\u001e5UeVt7-\u0019;f\u001f:4U\r^2iQ\r1#QT\u0001#m\u0016\u0014\u0018NZ=GKR\u001c\u0007\u000eT3bI\u0016\u0014X\t]8dQ>sg)\u001b:ti\u001a+Go\u00195\u0015\r\u00055$Q\u001bBs\u0011\u001d\u00119n\na\u0001\u00053\f1!\u001b2q!\u0011\u0011YN!9\u000e\u0005\tu'bA.\u0003`*\u0011q\tX\u0005\u0005\u0005G\u0014iNA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0011%\u00119o\nI\u0001\u0002\u0004\tY*A\bfa>\u001c\u0007NR3uG\"\u001cu.\u001e8u\u000312XM]5gs\u001a+Go\u00195MK\u0006$WM]#q_\u000eDwJ\u001c$jeN$h)\u001a;dQ\u0012\"WMZ1vYR$#'\u0001\u000ewKJLg-_(gMN,GOU3rk\u0016\u001cHOV3sg&|g\u000e\u0006\u0005\u0002n\t=(\u0011_B\u0002\u0011\u001d\u00119.\u000ba\u0001\u00053DqAa=*\u0001\u0004\u0011)0A\u000epM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fcV,7\u000f\u001e\t\u0005\u0005o\u0014iP\u0004\u0003\u0002N\te\u0018\u0002\u0002B~\u0003\u001f\nAd\u00144gg\u0016$8OR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0003\u0003\u0000\u000e\u0005!a\u0002\"vS2$WM\u001d\u0006\u0005\u0005w\fy\u0005C\u0004\u0004\u0006%\u0002\raa\u0002\u0002%1L7\u000f^(gMN,Go\u001d*fcV,7\u000f\u001e\t\u0005\u0007\u0013\u0019yA\u0004\u0003\u0002N\r-\u0011\u0002BB\u0007\u0003\u001f\n!\u0003T5ti>3gm]3ugJ+\u0017/^3ti&!!q`B\t\u0015\u0011\u0019i!a\u0014\u00023Y,'/\u001b4z\u001b\u0006\u00148NU3qY&\u001c\u0017\r\u00165s_R$H.\u001a\u000b\u0007\u0003[\u001a9ba\u0007\t\u000f\re!\u00061\u0001\u0002l\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\"CB\u000fUA\u0005\t\u0019AAN\u0003\u0015!\u0018.\\3t\u0003\r2XM]5gs6\u000b'o\u001b*fa2L7-\u0019+ie>$H\u000f\\3%I\u00164\u0017-\u001e7uII\nQd\u001d5pk2$G\u000b\u001b:piRdWMR8mY><XM\u001d*fa2L7-\u0019\u0015\u0004Y\tu\u0015\u0001\t;fgR4u\u000e\u001c7po\u0016\u0014\u0018j\u001d+ie>$H\u000f\\3e\u001f:dun\u001e#jg.D3!\fBO\u0003Q\u001a\bn\\;mIR\u0013XO\\2bi\u0016$vn\u00144gg\u0016$8\u000b]3dS\u001aLW\rZ%o\u000bB|7\r[(gMN,GOU3ta>t7/\u001a\u0015\u0004]\tu\u0015!T:i_VdG\r\u0016:v]\u000e\fG/\u001a+p\u001f\u001a47/\u001a;Ta\u0016\u001c\u0017NZ5fI&sW\t]8dQ>3gm]3u%\u0016\u001c\bo\u001c8tK&3gi\u001c7m_^,'\u000fS1t\u001d>luN]3Fa>\u001c\u0007n\u001d\u0015\u0004_\tu\u0015AS:i_VdGMR3uG\"dU-\u00193fe\u0016\u0003xn\u00195TK\u000e|g\u000e\u001a+j[\u0016Le\rT3bI\u0016\u0014(+\u001a9mS\u0016\u001cx+\u001b;i\u000bB|7\r\u001b(pi.swn\u001e8U_\u001a{G\u000e\\8xKJD3\u0001\rBO\u0003\u0005\u001b\bn\\;mIR\u0013XO\\2bi\u0016Le\rT3bI\u0016\u0014(+\u001a9mS\u0016\u001cx+\u001b;i\t&4XM]4j]\u001e,\u0005o\\2i\u001d>$8J\\8x]R{gi\u001c7m_^,'\u000fK\u00022\u0005;\u000bQ\u0006^3tiR\u0013XO\\2bi\u0016|eNR3uG\"$u.Z:O_R,\u0006\u000fZ1uK\"Kw\r[,bi\u0016\u0014X.\u0019:lQ\r\u0011$QT\u0001\u001ei\u0016\u001cH\u000fT1h\u0013N,\u0006\u000fZ1uK\u0012<\u0006.\u001a8O_J+7m\u001c:eg\"\u001a1G!(\u0002gMDw.\u001e7e+N,G*Z1eKJ,e\u000eZ(gMN,G/\u00134J]R,'O\u0011:pW\u0016\u0014h+\u001a:tS>t')\u001a7poJ\u0002\u0004f\u0001\u001b\u0003\u001e\u0006\u00015\u000f[8vY\u0012$&/\u001e8dCR,Gk\\%oSRL\u0017\r\u001c$fi\u000eDwJ\u001a4tKRLe\rT3bI\u0016\u0014(+\u001a;ve:\u001cXK\u001c3fM&tW\rZ(gMN,G\u000fK\u00026\u0005;\u000bq\u0004^3tiR\u0013XO\\2bi&|g\u000eT3tgRC\u0017M\u001c%X\u001b6+GO]5dQ\r1$QT\u0001\"m\u0016\u0014\u0018NZ=UeVt7-\u0019;j_:dUm]:UQ\u0006t\u0007jV'NKR\u0014\u0018n\u0019\u000b\u0005\u0003[\u001a\t\u0006C\u0004\u0004T]\u0002\rAa.\u0002;%\u001c\u0018i\u0019;jm\u0016d\u0015N\\6EKN$\u0018N\\1uS>tG*Z1eKJ\f\u0011g\u001d5pk2$\u0007k\u001c7m\u0013:$WMZ5oSR,G._%g\u0019\u0016\fG-\u001a:SKR,(O\\:B]f,\u0005pY3qi&|g\u000eK\u00029\u0005;\u000b1f\u001d5pk2$Wj\u001c<f!\u0006\u0014H/\u001b;j_:\u001cx*\u001e;PMR\u0013XO\\2bi&tw\rT8h'R\fG/\u001a\u0015\u0004s\tu\u0015\u0001O:i_VdGMR5mi\u0016\u0014\b+\u0019:uSRLwN\\:NC\u0012,G*Z1eKJ$UO]5oO2+\u0017\rZ3s\u000bB|7\r\u001b*fcV,7\u000f\u001e\u0015\u0004u\tu\u0015\u0001S:i_VdGmQ1uG\",\u0005pY3qi&|gN\u0012:p[\ncwnY6j]\u001e\u001cVM\u001c3XQ\u0016t7\u000b[;ui&tw\rR8x]J+\u0007\u000f\\5dC\u001a+Go\u00195feRC'/Z1eQ\rY$QT\u0001'g\"|W\u000f\u001c3Va\u0012\fG/\u001a*fCN\u001c\u0018n\u001a8nK:$()\u001f;fg&sW*\u001a;sS\u000e\u001c\bf\u0001\u001f\u0003\u001e\u000615\u000f[8vY\u0012tu\u000e^+qI\u0006$XMU3bgNLwM\\7f]R\u0014\u0015\u0010^3t\u0013:lU\r\u001e:jGN<\u0006.\u001a8O_J+\u0017m]:jO:lWM\u001c;t\u0013:\u0004&o\\4sKN\u001c\bfA\u001f\u0003\u001e\u0006qA/Z:u\u0005VLG\u000e\u001a$fi\u000eD\u0007f\u0001 \u0003\u001e\u0006qC/Z:u\u0019>\u001c\u0017\r\u001c$fi\u000eD7i\\7qY\u0016$\u0018n\u001c8JM\"Kw\r[,bi\u0016\u0014X.\u0019:l+B$\u0017\r^3e)\u0011\tig!\u001e\t\u000f\r]t\b1\u0001\u00038\u0006!\u0002.[4i/\u0006$XM]7be.,\u0006\u000fZ1uK\u0012DsaPB>\u0007\u0017\u001bi\t\u0005\u0003\u0004~\r\u001dUBAB@\u0015\u0011\u0019\tia!\u0002\u0011A\u0014xN^5eKJTAa!\"\u0002H\u00061\u0001/\u0019:b[NLAa!#\u0004\u0000\tYa+\u00197vKN{WO]2f\u0003!\u0011wn\u001c7fC:\u001cH\u0006BBH\u0007#K\u0012!A\r\u0002\u0001!\u001aqh!&\u0011\t\r]5\u0011T\u0007\u0003\u0007\u0007KAaa'\u0004\u0004\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002C9,wo\u00144gg\u0016$hi\u001c:MK\u0006$WM\u001d)beRLG/[8o%\u0016\u001cX\u000f\u001c;\u0015\u0011\r\u000561YBd\u0007\u0013\u0004Baa)\u0004>:!1QUB]\u001d\u0011\u00199ka.\u000f\t\r%6Q\u0017\b\u0005\u0007W\u001b\u0019L\u0004\u0003\u0004.\u000eEf\u0002\u0002B\"\u0007_K\u0011\u0001Y\u0005\u0003=~K!!S/\n\u0005mc\u0016bAA\u001d5&!11XA\u001c\u0003\u0001zeMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQJ+7\u000f]8og\u0016$\u0015\r^1\n\t\r}6\u0011\u0019\u0002\u000f\u000bB|7\r[#oI>3gm]3u\u0015\u0011\u0019Y,a\u000e\t\r\r\u0015\u0007\t1\u0001Y\u0003\t!\b\u000fC\u0004\u0002\u001a\u0002\u0003\r!a'\t\u000f\r-\u0007\t1\u0001\u0002\u0012\u0006IQM\u001c3PM\u001a\u001cX\r\u001e\u000b\u000b\u0007C\u001bym!5\u0004b\u000e\r\bBBBc\u0003\u0002\u0007\u0001\fC\u0004\u0004T\u0006\u0003\ra!6\u0002\u000b\u0015\u0014(o\u001c:\u0011\t\r]7Q\\\u0007\u0003\u00073T1aa7[\u0003!\u0001(o\u001c;pG>d\u0017\u0002BBp\u00073\u0014a!\u0012:s_J\u001c\bbBAM\u0003\u0002\u0007\u00111\u0014\u0005\b\u0007\u0017\f\u0005\u0019AAI\u0003y\t7o]3siB\u0013xnY3tgB\u000b'\u000f^5uS>tG)\u0019;b/\",g\u000e\u0006\u0003\u0002n\r%\bbBBv\u0005\u0002\u0007!qW\u0001\u000eSN\u0014V-Y:tS\u001et\u0017N\\4\u0002\tM$XO\u0019\u000b\t\u0003[\u001a\tpa?\u0004~\"911_\"A\u0002\rU\u0018!\u00039beRLG/[8o!\rY7q_\u0005\u0004\u0007sd'!\u0003)beRLG/[8o\u0011\u001d\u0019Ib\u0011a\u0001\u0003WDqaa@D\u0001\u0004!\t!A\u0002m_\u001e\u0004B\u0001b\u0001\u0005\b5\u0011AQ\u0001\u0006\u0004\u0007\u007fD\u0015\u0002\u0002C\u0005\t\u000b\u00111\"\u00112tiJ\f7\r\u001e'pO\u0006a2.\u00194lC\u000e{gNZ5h\u001d>$&/\u001e8dCR,wJ\u001c$fi\u000eDWCAAq\u0001")
public class ReplicaFetcherThreadTest {
    private final TopicPartition kafka$server$ReplicaFetcherThreadTest$$t1p0 = new TopicPartition("topic1", 0);
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);
    private final TopicPartition t2p1 = new TopicPartition("topic2", 1);
    private final BrokerEndPoint brokerEndPoint = new BrokerEndPoint(0, "localhost", 1000);
    private final FailedPartitions failedPartitions = new FailedPartitions();
    private final Uuid topicId1 = Uuid.randomUuid();
    private final Uuid topicId2 = Uuid.randomUuid();
    private final Map<String, Uuid> topicIds = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)this.topicId1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic2"), (Object)this.topicId2())}));
    private final java.util.List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic1").setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic2").setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0), (List)Nil$.MODULE$))).asJava();
    private final UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, 0L, Collections.emptyList(), this.partitionStates(), Collections.emptyList(), CollectionConverters$.MODULE$.MapHasAsJava(this.topicIds()).asJava(), Collections.emptyList(), false).build();
    private ZkMetadataCache metadataCache = new ZkMetadataCache(0, MetadataVersion.latest(), BrokerFeatures$.MODULE$.createEmpty(), (Seq)Seq$.MODULE$.empty(), false);

    public TopicPartition kafka$server$ReplicaFetcherThreadTest$$t1p0() {
        return this.kafka$server$ReplicaFetcherThreadTest$$t1p0;
    }

    private TopicPartition t1p1() {
        return this.t1p1;
    }

    private TopicPartition t2p1() {
        return this.t2p1;
    }

    public BrokerEndPoint brokerEndPoint() {
        return this.brokerEndPoint;
    }

    public FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    private Uuid topicId1() {
        return this.topicId1;
    }

    private Uuid topicId2() {
        return this.topicId2;
    }

    private Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    private java.util.List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates() {
        return this.partitionStates;
    }

    private UpdateMetadataRequest updateMetadataRequest() {
        return this.updateMetadataRequest;
    }

    private ZkMetadataCache metadataCache() {
        return this.metadataCache;
    }

    private void metadataCache_$eq(ZkMetadataCache x$1) {
        this.metadataCache = x$1;
    }

    private InitialFetchState initialFetchState(Option<Uuid> topicId, long fetchOffset, int leaderEpoch) {
        BrokerEndPoint x$2 = new BrokerEndPoint(0, "localhost", 9092);
        return new InitialFetchState(topicId, x$2, leaderEpoch, fetchOffset);
    }

    private int initialFetchState$default$3() {
        return 1;
    }

    @AfterEach
    public void cleanup() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    public RemoteLeaderEndPoint createRemoteLeaderEndPoint(KafkaConfig brokerConfig, ReplicaManager replicaMgr, ReplicaQuota quota, BlockingSend leaderEndpointBlockingSend, Option<LogContext> logContextOpt, Option<Time> timeOpt) {
        LogContext logContext = (LogContext)logContextOpt.getOrElse((Function0 & Serializable)() -> new LogContext());
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, leaderEndpointBlockingSend.brokerEndPoint().id());
        RemoteLeaderRequestBuilder requestBuilder = new RemoteLeaderRequestBuilder(brokerConfig, (Function0 & Serializable)() -> brokerConfig.interBrokerProtocolVersion(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L);
        FollowerFetchThrottler throttler = new FollowerFetchThrottler();
        return new RemoteLeaderEndPoint(logContext.logPrefix(), leaderEndpointBlockingSend, fetchSessionHandler, (RequestBuilder)requestBuilder, (FollowerThrottler)throttler, brokerConfig, replicaMgr, quota, (Function0 & Serializable)() -> brokerConfig.interBrokerProtocolVersion());
    }

    public Option<LogContext> createRemoteLeaderEndPoint$default$5() {
        return None$.MODULE$;
    }

    public Option<Time> createRemoteLeaderEndPoint$default$6() {
        return None$.MODULE$;
    }

    public ReplicaFetcherThread createReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ExponentialBackoff exponentialBackoff, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicaQuota quota, BlockingSend leaderEndpointBlockingSend, Option<TierStateFetcher> tierStateFetcher, Option<LogContext> logContextOpt) {
        RemoteLeaderEndPoint leader = this.createRemoteLeaderEndPoint(brokerConfig, replicaMgr, quota, leaderEndpointBlockingSend, logContextOpt, (Option<Time>)new Some((Object)time));
        Function0 & Serializable x$10 = (Function0 & Serializable)() -> brokerConfig.interBrokerProtocolVersion();
        Map x$11 = (Map)scala.collection.Map$.MODULE$.empty();
        return new ReplicaFetcherThread(name, fetcherId, (LeaderEndPoint)leader, brokerConfig, failedPartitions, exponentialBackoff, replicaMgr, quota, logContextOpt, x$11, (Function0)x$10);
    }

    public Option<LogContext> createReplicaFetcherThread$default$13() {
        return None$.MODULE$;
    }

    @Test
    public void shouldSendLatestRequestVersionsByDefault() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), exponentialBackoff, replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, new MockBlockingSender(CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)).asJava(), this.brokerEndPoint(), (Time)new SystemTime()), (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$13());
        Assertions.assertEquals((short)ApiKeys.FETCH.latestVersion(), (short)config.interBrokerProtocolVersion().fetchRequestVersion());
        Assertions.assertEquals((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (short)config.interBrokerProtocolVersion().offsetForLeaderEpochRequestVersion());
        Assertions.assertEquals((short)ApiKeys.LIST_OFFSETS.latestVersion(), (short)config.interBrokerProtocolVersion().listOffsetRequestVersion());
    }

    @Test
    public void testFetchLeaderEpochRequestIfLastEpochDefinedForSomePartitions() {
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), leaderEpoch, 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), leaderEpoch, 1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), exponentialBackoff, replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$13());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, 1))})));
        this.assertPartitionStates((AbstractFetcherThread)thread, false, true, false);
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)3, (int)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)3))).truncateTo(ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
    }

    public void assertPartitionStates(AbstractFetcherThread fetcher, boolean shouldBeReadyForFetch, boolean shouldBeTruncatingLog, boolean shouldBeDelayed) {
        new .colon.colon((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), (List)new .colon.colon((Object)this.t1p1(), (List)new .colon.colon((Object)this.t2p1(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$assertPartitionStates$1(fetcher, shouldBeReadyForFetch, shouldBeTruncatingLog, shouldBeDelayed, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void shouldHandleExceptionFromBlockingSend() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        Mockito.when((Object)mockBlockingSend.sendRequest((AbstractRequest.Builder)ArgumentMatchers.any())).thenThrow(new Throwable[]{new NullPointerException()});
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        BrokerEndPoint x$3 = this.brokerEndPoint();
        FailedPartitions x$5 = this.failedPartitions();
        None$ x$8 = None$.MODULE$;
        Metrics x$9 = new Metrics();
        SystemTime x$10 = new SystemTime();
        Option<LogContext> x$13 = this.createReplicaFetcherThread$default$13();
        Map result = this.createReplicaFetcherThread("bob", 0, x$3, config, x$5, exponentialBackoff, replicaManager, x$9, (Time)x$10, null, mockBlockingSend, (Option<TierStateFetcher>)x$8, x$13).leader().fetchEpochEndOffsets((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.kafka$server$ReplicaFetcherThreadTest$$t1p0().partition()).setLeaderEpoch(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p1().partition()).setLeaderEpoch(0))})));
        Assertions.assertEquals((Object)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), Errors.UNKNOWN_SERVER_ERROR, -1, -1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), Errors.UNKNOWN_SERVER_ERROR, -1, -1L))}))), (Object)result, (String)"results from leader epoch request should have undefined offset");
        ((BlockingSend)Mockito.verify((Object)mockBlockingSend)).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any());
    }

    @Test
    public void shouldFetchLeaderEpochOnFirstFetchOnlyIfLeaderEpochKnownToBothIbp26() {
        this.verifyFetchLeaderEpochOnFirstFetch(MetadataVersion.IBP_2_6_IV0, this.verifyFetchLeaderEpochOnFirstFetch$default$2());
    }

    @Test
    public void shouldNotFetchLeaderEpochOnFirstFetchWithTruncateOnFetch() {
        this.verifyFetchLeaderEpochOnFirstFetch(MetadataVersion.latest(), 0);
    }

    public void verifyFetchLeaderEpochOnFirstFetch(MetadataVersion ibp, int epochFetchCount) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), ibp.version());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.metadataCache_$eq(new ZkMetadataCache(0, ibp, BrokerFeatures$.MODULE$.createEmpty(), (Seq)Seq$.MODULE$.empty(), false));
        this.metadataCache().updateMetadata(0, this.updateMetadataRequest());
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), leaderEpoch, 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), leaderEpoch, 1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        RemoteLeaderEndPoint leader = this.createRemoteLeaderEndPoint(config, replicaManager, (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, mockNetwork, this.createRemoteLeaderEndPoint$default$5(), this.createRemoteLeaderEndPoint$default$6());
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        FailedPartitions x$5 = this.failedPartitions();
        QuotaFactory.UnboundedQuota$ x$8 = QuotaFactory.UnboundedQuota$.MODULE$;
        Function0 & Serializable x$9 = (Function0 & Serializable)() -> config.interBrokerProtocolVersion();
        None$ x$10 = None$.MODULE$;
        Map x$11 = (Map)scala.collection.Map$.MODULE$.empty();
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, (LeaderEndPoint)leader, config, x$5, exponentialBackoff, replicaManager, (ReplicaQuota)x$8, (Option)x$10, x$11, (Function0)x$9);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        thread.doWork();
        Assertions.assertEquals((int)epochFetchCount, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        thread.doWork();
        Assertions.assertEquals((int)epochFetchCount, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        thread.doWork();
        Assertions.assertEquals((int)epochFetchCount, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)3, (int)mockNetwork.fetchCount());
        if (epochFetchCount > 0) {
            ListOffsetsRequestData.ListOffsetsTopic topic = (ListOffsetsRequestData.ListOffsetsTopic)Mockito.mock(ListOffsetsRequestData.ListOffsetsTopic.class);
            ListOffsetsRequest.Builder listOffsetsRequest = leader.requestBuilder().buildListOffsetRequest(topic);
            this.verifyOffsetRequestVersion(ibp, (OffsetsForLeaderEpochRequest.Builder)mockNetwork.lastUsedOffsetsForLeaderEpochRequest().get(), listOffsetsRequest);
            return;
        }
    }

    public int verifyFetchLeaderEpochOnFirstFetch$default$2() {
        return 1;
    }

    public void verifyOffsetRequestVersion(MetadataVersion ibp, OffsetsForLeaderEpochRequest.Builder offsetForLeaderEpochRequest, ListOffsetsRequest.Builder listOffsetsRequest) {
        MetadataVersion metadataVersion = ibp;
        MetadataVersion metadataVersion2 = MetadataVersion.IBP_2_6_IV0;
        if (!(metadataVersion != null ? !metadataVersion.equals(metadataVersion2) : metadataVersion2 != null)) {
            Assertions.assertEquals((int)3, (int)offsetForLeaderEpochRequest.oldestAllowedVersion());
            Assertions.assertEquals((int)3, (int)offsetForLeaderEpochRequest.latestAllowedVersion());
            Assertions.assertEquals((int)0, (int)listOffsetsRequest.oldestAllowedVersion());
            Assertions.assertEquals((int)5, (int)listOffsetsRequest.latestAllowedVersion());
            return;
        }
        Assertions.assertEquals((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (short)offsetForLeaderEpochRequest.oldestAllowedVersion());
        Assertions.assertEquals((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (short)offsetForLeaderEpochRequest.latestAllowedVersion());
        Assertions.assertEquals((int)0, (int)listOffsetsRequest.oldestAllowedVersion());
        Assertions.assertEquals((short)ApiKeys.LIST_OFFSETS.latestVersion(), (short)listOffsetsRequest.latestAllowedVersion());
    }

    public void verifyMarkReplicaThrottle(ReplicaManager replicaManager, int times) {
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)times))).markFollowerReplicaThrottle();
    }

    public int verifyMarkReplicaThrottle$default$2() {
        return 1;
    }

    @Test
    public void shouldThrottleFollowerReplica() {
        LazyRef Quota$module = new LazyRef();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), MetadataVersion.IBP_2_6_IV0.version());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch)));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(0).setLeaderEpoch(leaderEpoch).setEndOffset(100L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(1).setLeaderEpoch(leaderEpoch).setEndOffset(1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), exponentialBackoff, replicaManager, new Metrics(), (Time)new SystemTime(), this.Quota$2(Quota$module), mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$13());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        Assertions.assertEquals((Object)new Some(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.t1p1()}))), (Object)mockNetwork.lastFetchRequest().map((Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.SetHasAsScala(x$1.fetchData().keySet()).asScala()));
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
        this.verifyMarkReplicaThrottle(replicaManager, 1);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFollowerIsThrottledOnLowDisk() {
        void apply_failedAttempts;
        void apply_lastFetchedEpoch;
        void apply_state;
        void apply_lag;
        void apply_offset;
        void apply_failedAttempts2;
        void apply_lastFetchedEpoch2;
        void apply_state2;
        void apply_lag2;
        void apply_offset2;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isThrottled((TopicPartition)ArgumentMatchers.any(TopicPartition.class)))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AtomicReference<Some> retVal = new AtomicReference<Some>(new Some((Object)BoxesRunTime.boxToLong((long)42L)));
        Mockito.when((Object)quotaManager.lastSignalledQuotaOptRef()).thenReturn(retVal, (Object[])new AtomicReference[]{retVal, retVal, null});
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setLeaderEpoch(leaderEpoch).setEndOffset(100L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setLeaderEpoch(leaderEpoch).setEndOffset(1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("audi", 0, this.brokerEndPoint(), config, this.failedPartitions(), exponentialBackoff, replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quotaManager, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$13());
        Object[] objectArray = new Tuple2[2];
        boolean bl = false;
        None$ none$ = None$.MODULE$;
        Fetching$ fetching$ = Fetching$.MODULE$;
        Some some = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        long l = 0L;
        Some apply_topicId = new Some((Object)this.topicId1());
        Object var15_19 = null;
        some = null;
        fetching$ = null;
        none$ = null;
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)new PartitionFetchState((Option)apply_topicId, (long)apply_offset2, (Option)apply_lag2, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state2, (Option)apply_lastFetchedEpoch2, (int)apply_failedAttempts2));
        boolean bl2 = false;
        None$ none$2 = None$.MODULE$;
        Fetching$ fetching$2 = Fetching$.MODULE$;
        None$ none$3 = None$.MODULE$;
        long l2 = 0L;
        Some apply_topicId2 = new Some((Object)this.topicId1());
        Object var22_25 = null;
        none$3 = null;
        fetching$2 = null;
        none$2 = null;
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)apply_topicId2, (long)apply_offset, (Option)apply_lag, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state, (Option)apply_lastFetchedEpoch, (int)apply_failedAttempts));
        Map partitionMap = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        thread.leader().buildFetch(partitionMap);
        DiskThrottleListenerManager.registerListener$((DiskThrottleListenerManager)DiskUsageBasedThrottler$.MODULE$, (DiskUsageBasedThrottleListener)quotaManager);
        thread.leader().buildFetch(partitionMap);
        DiskThrottleListenerManager.deRegisterListener$((DiskThrottleListenerManager)DiskUsageBasedThrottler$.MODULE$, (DiskUsageBasedThrottleListener)quotaManager);
        thread.leader().buildFetch(partitionMap);
        this.verifyMarkReplicaThrottle(replicaManager, 4);
    }

    @Test
    public void shouldTruncateToOffsetSpecifiedInEpochOffsetResponse() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Meter mockTruncationBelowHWMMeter = (Meter)Mockito.mock(Meter.class);
        int leaderEpoch = 5;
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 1L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLEO, leaderEpoch)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        Mockito.when((Object)replicaManager.truncationBelowHWM()).thenReturn((Object)mockTruncationBelowHWMMeter);
        this.stub(partition, replicaManager, log);
        ((Meter)Mockito.doNothing().when((Object)mockTruncationBelowHWMMeter)).mark();
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), leaderEpoch, 156L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t2p1(), leaderEpoch, 172L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), exponentialBackoff, replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$13());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, 1))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)156)), (String)new StringBuilder(58).append("Expected ").append(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).append(" to truncate to offset 156 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)172)), (String)new StringBuilder(58).append("Expected ").append(this.t2p1()).append(" to truncate to offset 172 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldTruncateToOffsetSpecifiedInEpochOffsetResponseIfFollowerHasNoMoreEpochs() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Meter mockTruncationBelowHWMMeter = (Meter)Mockito.mock(Meter.class);
        int leaderEpochAtFollower = 5;
        int leaderEpochAtLeader = 4;
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 3L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpochAtFollower)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpochAtLeader)).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        Mockito.when((Object)replicaManager.truncationBelowHWM()).thenReturn((Object)mockTruncationBelowHWMMeter);
        this.stub(partition, replicaManager, log);
        ((Meter)Mockito.doNothing().when((Object)mockTruncationBelowHWMMeter)).mark();
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), leaderEpochAtLeader, 156L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t2p1(), leaderEpochAtLeader, 202L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), exponentialBackoff, replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$13());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, 1))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)156)), (String)new StringBuilder(58).append("Expected ").append(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).append(" to truncate to offset 156 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)initialLEO)), (String)new StringBuilder(55).append("Expected ").append(this.t2p1()).append(" to truncate to offset ").append(initialLEO).append(" (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldFetchLeaderEpochSecondTimeIfLeaderRepliesWithEpochNotKnownToFollower() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Meter mockTruncationBelowHWMMeter = (Meter)Mockito.mock(Meter.class);
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 2L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)log.endOffsetForEpoch(3)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        Mockito.when((Object)replicaManager.truncationBelowHWM()).thenReturn((Object)mockTruncationBelowHWMMeter);
        this.stub(partition, replicaManager, log);
        ((Meter)Mockito.doNothing().when((Object)mockTruncationBelowHWMMeter)).mark();
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), 4, 155L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), 4, 143L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), exponentialBackoff, replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$13());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)0, (int)mockNetwork.fetchCount());
        java.util.Map nextOffsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), 3, 101L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), 3, 102L))}))).asJava();
        mockNetwork.setOffsetsForNextResponse(nextOffsets);
        thread.doWork();
        Assertions.assertEquals((int)2, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        Assertions.assertTrue((mockNetwork.lastUsedOffsetForLeaderEpochVersion() >= 3 ? 1 : 0) != 0, (String)"OffsetsForLeaderEpochRequest version.");
        thread.doWork();
        Assertions.assertEquals((int)2, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)4))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)102)), (String)new StringBuilder(58).append("Expected ").append(this.t1p1()).append(" to truncate to offset 102 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)101)), (String)new StringBuilder(58).append("Expected ").append(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).append(" to truncate to offset 101 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int initialLEO = 200;
        ObjectRef latestLogEpoch = ObjectRef.create((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)115L));
        Mockito.when((Object)log.latestEpoch()).thenAnswer(x$2 -> (Option)latestLogEpoch$1.elem);
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(149L, 4)));
        Mockito.when((Object)log.endOffsetForEpoch(3)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(129L, 2)));
        Mockito.when((Object)log.endOffsetForEpoch(2)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(119L, 1)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        this.stub(partition, replicaManager, log);
        MockBlockingSender mockNetwork = new MockBlockingSender(Collections.emptyMap(), this.brokerEndPoint(), (Time)new SystemTime());
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(new LogContext(), mockNetwork.brokerEndPoint().id());
        RemoteLeaderRequestBuilder requestBuilder = new RemoteLeaderRequestBuilder(config, (Function0 & Serializable)() -> config.interBrokerProtocolVersion(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L);
        FollowerFetchThrottler throttler = new FollowerFetchThrottler();
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint("", (BlockingSend)mockNetwork, fetchSessionHandler, (RequestBuilder)requestBuilder, (FollowerThrottler)throttler, config, replicaManager, (ReplicaQuota)quota, (Function0 & Serializable)() -> config.interBrokerProtocolVersion());
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaFetcherThread thread = new ReplicaFetcherThread(this, leader, config, exponentialBackoff, replicaManager, quota){

            public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
                return None$.MODULE$;
            }
            {
                FailedPartitions x$5 = $outer.failedPartitions();
                Serializable x$9 = new Serializable(null, config$2){
                    private static final long serialVersionUID = 0L;
                    private final KafkaConfig config$2;

                    public final MetadataVersion apply() {
                        return this.config$2.interBrokerProtocolVersion();
                    }
                    {
                        this.config$2 = config$2;
                    }
                };
                None$ x$10 = None$.MODULE$;
                Map x$11 = (Map)scala.collection.Map$.MODULE$.empty();
                super("bob", 0, (LeaderEndPoint)leader$1, config$2, x$5, exponentialBackoff$1, replicaManager$1, (ReplicaQuota)quota$1, (Option)x$10, x$11, (Function0)x$9);
            }
        };
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), initialLEO, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), initialLEO, 1))})));
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), this.t1p1()}));
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$5(thread, tp);
            return BoxedUnit.UNIT;
        });
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.kafka$server$ReplicaFetcherThreadTest$$t1p0().partition(), new FetchResponseData.EpochEndOffset().setEpoch(4).setEndOffset(140L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p1().partition(), new FetchResponseData.EpochEndOffset().setEpoch(4).setEndOffset(141L)))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        latestLogEpoch.elem = new Some((Object)BoxesRunTime.boxToInteger((int)4));
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)140)), (String)new StringBuilder(58).append("Expected ").append(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).append(" to truncate to offset 140 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)141)), (String)new StringBuilder(58).append("Expected ").append(this.t1p1()).append(" to truncate to offset 141 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$6(thread, tp);
            return BoxedUnit.UNIT;
        });
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.kafka$server$ReplicaFetcherThreadTest$$t1p0().partition(), new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(130L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p1().partition(), new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(131L)))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)3, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)4))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)129)), (String)new StringBuilder(57).append("Expected to truncate to offset 129 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$7(thread, tp);
            return BoxedUnit.UNIT;
        });
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.kafka$server$ReplicaFetcherThreadTest$$t1p0().partition(), new FetchResponseData.EpochEndOffset().setEpoch(2).setEndOffset(120L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p1().partition(), new FetchResponseData.EpochEndOffset().setEpoch(2).setEndOffset(121L)))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        latestLogEpoch.elem = None$.MODULE$;
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)4, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)6))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)119)), (String)new StringBuilder(57).append("Expected to truncate to offset 119 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$8(thread, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testTruncateOnFetchDoesNotUpdateHighWatermark() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int logEndOffset = 150;
        int highWatermark = 130;
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(highWatermark)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(149L, 4)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(logEndOffset)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.localLogOrException(this.kafka$server$ReplicaFetcherThreadTest$$t1p0())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.kafka$server$ReplicaFetcherThreadTest$$t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)partition.appendRecordsToFollowerOrFutureReplica((MemoryRecords)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()))).thenReturn((Object)None$.MODULE$);
        LogContext logContext = new LogContext(new StringBuilder(52).append("[ReplicaFetcher replicaId=").append(config.brokerId()).append(", leaderId=").append(this.brokerEndPoint().id()).append(", fetcherId=0] ").toString());
        MockBlockingSender mockNetwork = new MockBlockingSender(Collections.emptyMap(), this.brokerEndPoint(), (Time)new SystemTime());
        FollowerFetchThrottler throttler = new FollowerFetchThrottler(null){

            public boolean shouldThrottleDueToLowDisk(ReplicaQuota quota) {
                return false;
            }
        };
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), (BlockingSend)mockNetwork, new FetchSessionHandler(logContext, this.brokerEndPoint().id()), (RequestBuilder)new RemoteLeaderRequestBuilder(config, (Function0 & Serializable)() -> config.interBrokerProtocolVersion(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L), (FollowerThrottler)throttler, config, replicaManager, (ReplicaQuota)quota, (Function0 & Serializable)() -> config.interBrokerProtocolVersion());
        FailedPartitions x$5 = this.failedPartitions();
        ExponentialBackoff x$6 = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        Some x$9 = new Some((Object)logContext);
        Function0 & Serializable x$10 = (Function0 & Serializable)() -> config.interBrokerProtocolVersion();
        Map x$11 = (Map)scala.collection.Map$.MODULE$.empty();
        ReplicaFetcherThread thread = new ReplicaFetcherThread("fetcher-thread", 0, (LeaderEndPoint)leader, config, x$5, x$6, replicaManager, (ReplicaQuota)quota, (Option)x$9, x$11, (Function0)x$10);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), logEndOffset, 1))})));
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)new FetchResponseData.PartitionData().setPartitionIndex(this.kafka$server$ReplicaFetcherThreadTest$$t1p0().partition()).setLastStableOffset(0L).setLogStartOffset(0L).setHighWatermark(160L).setDivergingEpoch(new FetchResponseData.EpochEndOffset().setEpoch(4).setEndOffset(140L)))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)1))).truncateTo(140L, false);
        ((AbstractLog)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)0))).maybeUpdateHighWatermark(ArgumentMatchers.anyLong());
    }

    @Test
    public void testLagIsUpdatedWhenNoRecords() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int lastFetchedEpoch = 2;
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)lastFetchedEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(0)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(0L, 0)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.maybeUpdateHighWatermark(0L)).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.localLogOrException(this.kafka$server$ReplicaFetcherThreadTest$$t1p0())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.kafka$server$ReplicaFetcherThreadTest$$t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)replicaManager.appendRecordsToFollowerReplica((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (MemoryRecords)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (ReplicaQuota)ArgumentMatchers.any(), (Function4)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)new LogAppendInfo(Optional.empty(), 0L, OptionalInt.empty(), -1L, -1L, -1L, -1L, RecordConversionStats.EMPTY, CompressionType.NONE, CompressionType.NONE, -1, 0, false, -1L)));
        LogContext logContext = new LogContext(new StringBuilder(52).append("[ReplicaFetcher replicaId=").append(config.brokerId()).append(", leaderId=").append(this.brokerEndPoint().id()).append(", fetcherId=0] ").toString());
        MockBlockingSender mockNetwork = new MockBlockingSender(Collections.emptyMap(), this.brokerEndPoint(), (Time)new SystemTime());
        FollowerFetchThrottler throttler = new FollowerFetchThrottler(null){

            public boolean shouldThrottleDueToLowDisk(ReplicaQuota quota) {
                return false;
            }
        };
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), (BlockingSend)mockNetwork, new FetchSessionHandler(logContext, this.brokerEndPoint().id()), (RequestBuilder)new RemoteLeaderRequestBuilder(config, (Function0 & Serializable)() -> config.interBrokerProtocolVersion(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L), (FollowerThrottler)throttler, config, replicaManager, (ReplicaQuota)quota, (Function0 & Serializable)() -> config.interBrokerProtocolVersion());
        FailedPartitions x$52 = this.failedPartitions();
        ExponentialBackoff x$6 = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        Some x$9 = new Some((Object)logContext);
        Function0 & Serializable x$10 = (Function0 & Serializable)() -> config.interBrokerProtocolVersion();
        Map x$11 = (Map)scala.collection.Map$.MODULE$.empty();
        ReplicaFetcherThread thread = new ReplicaFetcherThread("fetcher-thread", 0, (LeaderEndPoint)leader, config, x$52, x$6, replicaManager, (ReplicaQuota)quota, (Option)x$9, x$11, (Function0)x$10);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).flatMap((Function1 & Serializable)x$3 -> x$3.lag()));
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)new FetchResponseData.PartitionData().setPartitionIndex(this.kafka$server$ReplicaFetcherThreadTest$$t1p0().partition()).setLastStableOffset(0L).setLogStartOffset(0L).setHighWatermark(0L).setRecords((BaseRecords)MemoryRecords.EMPTY))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)thread.fetchState(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).flatMap((Function1 & Serializable)x$4 -> x$4.lag()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)lastFetchedEpoch)), (Object)thread.fetchState(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).flatMap((Function1 & Serializable)x$5 -> x$5.lastFetchedEpoch()));
    }

    @Test
    public void shouldUseLeaderEndOffsetIfInterBrokerVersionBelow20() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.11.0");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Meter mockTruncationBelowHWMMeter = (Meter)Mockito.mock(Meter.class);
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 2L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)log.endOffsetForEpoch(3)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        Mockito.when((Object)replicaManager.truncationBelowHWM()).thenReturn((Object)mockTruncationBelowHWMMeter);
        this.stub(partition, replicaManager, log);
        ((Meter)Mockito.doNothing().when((Object)mockTruncationBelowHWMMeter)).mark();
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), -1, 155L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), -1, 143L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), exponentialBackoff, replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$13());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        Assertions.assertEquals((int)0, (int)mockNetwork.lastUsedOffsetForLeaderEpochVersion(), (String)"OffsetsForLeaderEpochRequest version.");
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)155)), (String)new StringBuilder(58).append("Expected ").append(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).append(" to truncate to offset 155 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)143)), (String)new StringBuilder(58).append("Expected ").append(this.t1p1()).append(" to truncate to offset 143 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldTruncateToInitialFetchOffsetIfLeaderReturnsUndefinedOffset() {
        ArgumentCaptor truncated = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int initialFetchOffset = 100;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialFetchOffset)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), -1, -1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), exponentialBackoff, replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$13());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), initialFetchOffset, 1))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((long)initialFetchOffset, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void testTruncationLessThanHWMMetric() {
        this.verifyTruncationLessThanHWMMetric(false);
    }

    public void verifyTruncationLessThanHWMMetric(boolean isActiveLinkDestinationLeader) {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Meter mockTruncationBelowHWMMeter = (Meter)Mockito.mock(Meter.class);
        Meter mockClusterLinkTruncationBelowHWMMeter = (Meter)Mockito.mock(Meter.class);
        int leaderEpoch = 5;
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isActiveLinkDestinationLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isActiveLinkDestinationLeader));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 1L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLEO, leaderEpoch)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        Mockito.when((Object)replicaManager.truncationBelowHWM()).thenReturn((Object)mockTruncationBelowHWMMeter);
        Mockito.when((Object)replicaManager.clusterLinkTruncationBelowHWM()).thenReturn((Object)mockClusterLinkTruncationBelowHWMMeter);
        this.stub(partition, replicaManager, log);
        ((Meter)Mockito.doNothing().when((Object)mockTruncationBelowHWMMeter)).mark();
        ((Meter)Mockito.doNothing().when((Object)mockClusterLinkTruncationBelowHWMMeter)).mark();
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), leaderEpoch, 156L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t2p1(), leaderEpoch, 172L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        Metrics metrics = new Metrics();
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), exponentialBackoff, replicaManager, metrics, (Time)new SystemTime(), (ReplicaQuota)quota, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$13());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, 1))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)156)), (String)new StringBuilder(58).append("Expected ").append(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).append(" to truncate to offset 156 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)172)), (String)new StringBuilder(58).append("Expected ").append(this.t2p1()).append(" to truncate to offset 172 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        if (isActiveLinkDestinationLeader) {
            ((Meter)Mockito.verify((Object)mockTruncationBelowHWMMeter, (VerificationMode)Mockito.times((int)0))).mark();
            ((Meter)Mockito.verify((Object)mockClusterLinkTruncationBelowHWMMeter, (VerificationMode)Mockito.times((int)2))).mark();
            return;
        }
        ((Meter)Mockito.verify((Object)mockTruncationBelowHWMMeter, (VerificationMode)Mockito.times((int)2))).mark();
        ((Meter)Mockito.verify((Object)mockClusterLinkTruncationBelowHWMMeter, (VerificationMode)Mockito.times((int)0))).mark();
    }

    @Test
    public void shouldPollIndefinitelyIfLeaderReturnsAnyException() {
        ArgumentCaptor truncated = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        int highWatermark = 100;
        int initialLeo = 300;
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(highWatermark)));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLeo, leaderEpoch)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLeo)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), Errors.NOT_LEADER_OR_FOLLOWER, -1, -1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), Errors.UNKNOWN_SERVER_ERROR, -1, -1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(100L, 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), exponentialBackoff, replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, (Option<LogContext>)None$.MODULE$);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        int[] expectedBackoffTimes = new int[]{100, 200, 400, 800};
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x -> {
            thread.doWork();
            Assertions.assertEquals((long)expectedBackoffTimes[x], (long)((DelayedItem)((PartitionFetchState)thread.fetchState(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).get()).delay().get()).delayMs());
        });
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.never())).truncateTo(ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
        offsetsReply.put(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), leaderEpoch, 156L));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((long)156L, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldMovePartitionsOutOfTruncatingLogState() {
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 4;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), leaderEpoch, 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), leaderEpoch, 1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), exponentialBackoff, replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$13());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)thread.fetchState(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).map((Function1 & Serializable)x$6 -> x$6.state()));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)thread.fetchState(this.t1p1()).map((Function1 & Serializable)x$7 -> x$7.state()));
        thread.doWork();
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)thread.fetchState(this.kafka$server$ReplicaFetcherThreadTest$$t1p0()).map((Function1 & Serializable)x$8 -> x$8.state()));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)thread.fetchState(this.t1p1()).map((Function1 & Serializable)x$9 -> x$9.state()));
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(0L, false);
    }

    @Test
    public void shouldFilterPartitionsMadeLeaderDuringLeaderEpochRequest() {
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        int initialLEO = 100;
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Meter mockTruncationBelowHWMMeter = (Meter)Mockito.mock(Meter.class);
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 2L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)log.endOffsetForEpoch(5)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLEO, 5)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)quota.lastSignalledQuotaOptRef()).thenReturn(new AtomicReference<None$>(None$.MODULE$));
        Mockito.when((Object)replicaManager.truncationBelowHWM()).thenReturn((Object)mockTruncationBelowHWMMeter);
        this.stub(partition, replicaManager, log);
        ((Meter)Mockito.doNothing().when((Object)mockTruncationBelowHWMMeter)).mark();
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), 5, 52L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), 5, 49L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, this.brokerEndPoint(), config, this.failedPartitions(), exponentialBackoff, replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, mockNetwork, (Option<TierStateFetcher>)None$.MODULE$, this.createReplicaFetcherThread$default$13());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        TopicPartition partitionThatBecameLeader = this.kafka$server$ReplicaFetcherThreadTest$$t1p0();
        mockNetwork.setEpochRequestCallback((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> thread.removePartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionThatBecameLeader}))));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((long)49L, (long)BoxesRunTime.unboxToLong((Object)truncateToCapture.getValue()));
    }

    @Test
    public void shouldCatchExceptionFromBlockingSendWhenShuttingDownReplicaFetcherThread() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        mockBlockingSend.initiateClose();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new IllegalArgumentException()});
        mockBlockingSend.close();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new IllegalStateException()});
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        BrokerEndPoint x$3 = this.brokerEndPoint();
        FailedPartitions x$5 = this.failedPartitions();
        None$ x$8 = None$.MODULE$;
        Metrics x$9 = new Metrics();
        SystemTime x$10 = new SystemTime();
        Option<LogContext> x$13 = this.createReplicaFetcherThread$default$13();
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, x$3, config, x$5, exponentialBackoff, replicaManager, x$9, (Time)x$10, null, mockBlockingSend, (Option<TierStateFetcher>)x$8, x$13);
        thread.start();
        thread.initiateShutdown();
        thread.awaitShutdown();
        ((BlockingSend)Mockito.verify((Object)mockBlockingSend)).initiateClose();
        ((BlockingSend)Mockito.verify((Object)mockBlockingSend)).close();
    }

    @Test
    public void shouldUpdateReassignmentBytesInMetrics() {
        this.assertProcessPartitionDataWhen(true);
    }

    @Test
    public void shouldNotUpdateReassignmentBytesInMetricsWhenNoReassignmentsInProgress() {
        this.assertProcessPartitionDataWhen(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBuildFetch() {
        void var28_28;
        void var20_20;
        TopicIdPartition tid1p0 = new TopicIdPartition(this.topicId1(), this.kafka$server$ReplicaFetcherThreadTest$$t1p0());
        TopicIdPartition tid1p1 = new TopicIdPartition(this.topicId1(), this.t1p1());
        TopicIdPartition tid2p1 = new TopicIdPartition(this.topicId2(), this.t2p1());
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaQuota.isThrottled((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        RemoteLeaderEndPoint leader = this.createRemoteLeaderEndPoint(config, replicaManager, replicaQuota, mockBlockingSend, this.createRemoteLeaderEndPoint$default$5(), this.createRemoteLeaderEndPoint$default$6());
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        FailedPartitions x$5 = this.failedPartitions();
        Function0 & Serializable x$9 = (Function0 & Serializable)() -> config.interBrokerProtocolVersion();
        None$ x$10 = None$.MODULE$;
        Map x$11 = (Map)scala.collection.Map$.MODULE$.empty();
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, (LeaderEndPoint)leader, config, x$5, exponentialBackoff, replicaManager, replicaQuota, (Option)x$10, x$11, (Function0)x$9);
        int leaderEpoch = 1;
        Object[] objectArray = new Tuple2[3];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$ReplicaFetcherThreadTest$$t1p0()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId1()), 150L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, 0));
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId1()), 155L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, 0));
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId2()), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, 0));
        Map partitionMap = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.leader().buildFetch(partitionMap);
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt = (Option)resultWithPartitions.result();
        Assertions.assertTrue((boolean)var20_20.isDefined());
        FetchRequest.Builder fetchRequestBuilder = ((AbstractFetcherThread.ReplicaFetch)var20_20.get()).fetchRequest();
        Map partitionDataMap = (Map)partitionMap.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                PartitionFetchState state = (PartitionFetchState)x0$1._2();
                return new Tuple2((Object)tp, (Object)new FetchRequest.PartitionData((Uuid)state.topicId().get(), state.fetchOffset(), 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(state.currentLeaderEpoch())), Optional.empty()));
            }
            throw new MatchError(null);
        });
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava(partitionDataMap).asJava(), (Object)fetchRequestBuilder.fetchData());
        Assertions.assertEquals((int)0, (int)fetchRequestBuilder.replaced().size());
        Assertions.assertEquals((int)0, (int)fetchRequestBuilder.removed().size());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> responseData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        responseData.put(tid1p0, new FetchResponseData.PartitionData());
        responseData.put(tid1p1, new FetchResponseData.PartitionData());
        responseData.put(tid2p1, new FetchResponseData.PartitionData());
        FetchResponse fetchResponse = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)123, responseData);
        leader.fetchSessionHandler().handleResponse(fetchResponse, ApiKeys.FETCH.latestVersion());
        Uuid newTopicId = Uuid.randomUuid();
        Object[] objectArray2 = new Tuple2[2];
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId1()), 155L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, 0));
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)new PartitionFetchState((Option)new Some((Object)newTopicId), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$, 0));
        Map partitionMap2 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions2 = thread.leader().buildFetch(partitionMap2);
        if (resultWithPartitions2 == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt2 = (Option)resultWithPartitions2.result();
        Map partitionDataMap2 = (Map)((MapOps)partitionMap2.drop(1)).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartition tp = (TopicPartition)x0$2._1();
                PartitionFetchState state = (PartitionFetchState)x0$2._2();
                return new Tuple2((Object)tp, (Object)new FetchRequest.PartitionData((Uuid)state.topicId().get(), state.fetchOffset(), 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(state.currentLeaderEpoch())), Optional.empty()));
            }
            throw new MatchError(null);
        });
        Assertions.assertTrue((boolean)var28_28.isDefined());
        FetchRequest.Builder fetchRequestBuilder2 = ((AbstractFetcherThread.ReplicaFetch)var28_28.get()).fetchRequest();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava(partitionDataMap2).asJava(), (Object)fetchRequestBuilder2.fetchData());
        Assertions.assertEquals(Collections.singletonList(tid2p1), (Object)fetchRequestBuilder2.replaced());
        Assertions.assertEquals(Collections.singletonList(tid1p0), (Object)fetchRequestBuilder2.removed());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLocalFetchCompletionIfHighWatermarkUpdated(boolean highWatermarkUpdated) {
        void withRecords_records;
        void withRecords_timestampType;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        long highWatermarkReceivedFromLeader = 100L;
        TopicPartition tp0 = new TopicPartition("testTopic", 0);
        TopicPartition tp1 = new TopicPartition("testTopic", 1);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        None$ maybeNewHighWatermark = highWatermarkUpdated ? new Some((Object)BoxesRunTime.boxToLong((long)highWatermarkReceivedFromLeader)) : None$.MODULE$;
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)log.maybeUpdateHighWatermark(highWatermarkReceivedFromLeader)).thenReturn((Object)maybeNewHighWatermark);
        Some appendInfo = new Some(Mockito.mock(LogAppendInfo.class));
        scala.collection.immutable.Map partitions = ((IterableOnceOps)new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)Nil$.MODULE$)).map((Function1 & Serializable)tp -> new Tuple2(tp, Mockito.mock(Partition.class)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        partitions.foreach(arg_0 -> ReplicaFetcherThreadTest.$anonfun$testLocalFetchCompletionIfHighWatermarkUpdated$2(log, (Option)appendInfo, arg_0));
        Buffer completeDelayedFetchRequestsArgument = (Buffer)Buffer$.MODULE$.empty();
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenAnswer(i -> (Partition)partitions.apply((Object)((TopicPartition)i.getArgument(0))));
        replicaManager.completeDelayedFetchRequests((Seq)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> (Buffer)completeDelayedFetchRequestsArgument.$plus$plus$eq((IterableOnce)((scala.collection.immutable.Seq)invocation.getArgument(0))));
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn((Object)brokerTopicStats);
        Mockito.when((Object)replicaManager.appendRecordsToFollowerReplica((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (MemoryRecords)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (ReplicaQuota)ArgumentMatchers.any(), (Function4)ArgumentMatchers.any())).thenCallRealMethod();
        ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        BrokerEndPoint x$3 = this.brokerEndPoint();
        FailedPartitions x$5 = this.failedPartitions();
        Metrics x$8 = new Metrics();
        SystemTime x$9 = new SystemTime();
        None$ x$10 = None$.MODULE$;
        Option<LogContext> x$13 = this.createReplicaFetcherThread$default$13();
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("replica-fetcher", 0, x$3, config, x$5, exponentialBackoff, replicaManager, x$8, (Time)x$9, replicaQuota, mockBlockingSend, (Option<TierStateFetcher>)x$10, x$13);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(1000L, "foo".getBytes(StandardCharsets.UTF_8))};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var27_25 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        FetchResponseData.PartitionData partitionData = new FetchResponseData.PartitionData().setRecords((BaseRecords)records).setHighWatermark(highWatermarkReceivedFromLeader);
        thread.processPartitionData(tp0, 0L, partitionData.setPartitionIndex(0));
        thread.processPartitionData(tp1, 0L, partitionData.setPartitionIndex(1));
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)0))).completeDelayedFetchRequests((Seq)ArgumentMatchers.any());
        thread.doWork();
        if (highWatermarkUpdated) {
            Assertions.assertEquals((Object)new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)Nil$.MODULE$)), (Object)completeDelayedFetchRequestsArgument);
            ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)1))).completeDelayedFetchRequests((Seq)ArgumentMatchers.any());
        } else {
            ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)0))).completeDelayedFetchRequests((Seq)ArgumentMatchers.any());
        }
        Assertions.assertEquals((Object)Buffer$.MODULE$.empty(), (Object)thread.partitionsWithNewHighWatermark());
    }

    private OffsetForLeaderEpochResponseData.EpochEndOffset newOffsetForLeaderPartitionResult(TopicPartition tp, int leaderEpoch, long endOffset) {
        return this.newOffsetForLeaderPartitionResult(tp, Errors.NONE, leaderEpoch, endOffset);
    }

    private OffsetForLeaderEpochResponseData.EpochEndOffset newOffsetForLeaderPartitionResult(TopicPartition tp, Errors error, int leaderEpoch, long endOffset) {
        return new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()).setLeaderEpoch(leaderEpoch).setEndOffset(endOffset);
    }

    /*
     * WARNING - void declaration
     */
    private void assertProcessPartitionDataWhen(boolean isReassigning) {
        void withRecords_records;
        void withRecords_timestampType;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(1000L, "foo".getBytes(StandardCharsets.UTF_8))};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var20_7 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Mockito.when((Object)log.maybeUpdateHighWatermark(0L)).thenReturn((Object)None$.MODULE$);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isReassigning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isReassigning));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isAddingLocalReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isReassigning));
        Mockito.when((Object)partition.appendRecordsToFollowerOrFutureReplica(records, false)).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn((Object)brokerTopicStats);
        Mockito.when((Object)replicaManager.appendRecordsToFollowerReplica((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (MemoryRecords)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (ReplicaQuota)ArgumentMatchers.any(), (Function4)ArgumentMatchers.any())).thenCallRealMethod();
        ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(config.replicaFetchBackoffMs().longValue(), 2, config.replicaFetchBackoffMaxMs().longValue(), 0.0);
        BrokerEndPoint x$3 = this.brokerEndPoint();
        FailedPartitions x$5 = this.failedPartitions();
        Metrics x$8 = new Metrics();
        SystemTime x$9 = new SystemTime();
        None$ x$11 = None$.MODULE$;
        Option<LogContext> x$13 = this.createReplicaFetcherThread$default$13();
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, x$3, config, x$5, exponentialBackoff, replicaManager, x$8, (Time)x$9, replicaQuota, mockBlockingSend, (Option<TierStateFetcher>)x$11, x$13);
        FetchResponseData.PartitionData partitionData = new FetchResponseData.PartitionData().setPartitionIndex(this.kafka$server$ReplicaFetcherThreadTest$$t1p0().partition()).setLastStableOffset(0L).setLogStartOffset(0L).setRecords((BaseRecords)records);
        thread.processPartitionData(this.kafka$server$ReplicaFetcherThreadTest$$t1p0(), 0L, partitionData);
        if (isReassigning) {
            Assertions.assertEquals((long)records.sizeInBytes(), (long)((Meter)brokerTopicStats.allTopicsStats().reassignmentBytesInPerSec().get()).count());
        } else {
            Assertions.assertEquals((long)0L, (long)((Meter)brokerTopicStats.allTopicsStats().reassignmentBytesInPerSec().get()).count());
        }
        Assertions.assertEquals((long)records.sizeInBytes(), (long)((Meter)brokerTopicStats.allTopicsStats().replicationBytesInRate().get()).count());
    }

    public void stub(Partition partition, ReplicaManager replicaManager, AbstractLog log) {
        Mockito.when((Object)replicaManager.localLogOrException(this.kafka$server$ReplicaFetcherThreadTest$$t1p0())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.kafka$server$ReplicaFetcherThreadTest$$t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p1())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.localLogOrException(this.t2p1())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t2p1())).thenReturn((Object)partition);
        Mockito.when((Object)partition.getLinkedLeaderEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)replicaManager.appendRecordsToFollowerReplica((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (MemoryRecords)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (ReplicaQuota)ArgumentMatchers.any(), (Function4)ArgumentMatchers.any())).thenCallRealMethod();
    }

    private KafkaConfig kafkaConfigNoTruncateOnFetch() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), MetadataVersion.IBP_2_6_IV0.version());
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public static final /* synthetic */ void $anonfun$assertPartitionStates$1(AbstractFetcherThread fetcher$1, boolean shouldBeReadyForFetch$1, boolean shouldBeTruncatingLog$1, boolean shouldBeDelayed$1, TopicPartition tp) {
        Assertions.assertTrue((boolean)fetcher$1.fetchState(tp).isDefined());
        PartitionFetchState fetchState = (PartitionFetchState)fetcher$1.fetchState(tp).get();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldBeReadyForFetch$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isReadyForFetch()), (String)new StringBuilder(39).append("Partition ").append(tp).append(" should").append((Object)(!shouldBeReadyForFetch$1 ? " NOT" : "")).append(" be ready for fetching").toString());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldBeTruncatingLog$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isTruncating()), (String)new StringBuilder(39).append("Partition ").append(tp).append(" should").append((Object)(!shouldBeTruncatingLog$1 ? " NOT" : "")).append(" be truncating its log").toString());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldBeDelayed$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isDelayed()), (String)new StringBuilder(28).append("Partition ").append(tp).append(" should").append((Object)(!shouldBeDelayed$1 ? " NOT" : "")).append(" be delayed").toString());
    }

    private final /* synthetic */ ReplicaFetcherThreadTest$Quota$1$ Quota$lzycompute$1(LazyRef Quota$module$1) {
        synchronized (Quota$module$1) {
            ReplicaFetcherThreadTest$Quota$1$ replicaFetcherThreadTest$Quota$1$ = Quota$module$1.initialized() ? (ReplicaFetcherThreadTest$Quota$1$)Quota$module$1.value() : (ReplicaFetcherThreadTest$Quota$1$)Quota$module$1.initialize((Object)new ReplicaFetcherThreadTest$Quota$1$(this));
            return replicaFetcherThreadTest$Quota$1$;
        }
    }

    private final ReplicaFetcherThreadTest$Quota$1$ Quota$2(LazyRef Quota$module$1) {
        if (Quota$module$1.initialized()) {
            return (ReplicaFetcherThreadTest$Quota$1$)Quota$module$1.value();
        }
        return this.Quota$lzycompute$1(Quota$module$1);
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$5(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    private static final FetchResponseData.PartitionData partitionData$1(int partition, FetchResponseData.EpochEndOffset divergingEpoch) {
        return new FetchResponseData.PartitionData().setPartitionIndex(partition).setLastStableOffset(0L).setLogStartOffset(0L).setDivergingEpoch(divergingEpoch);
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$6(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$7(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$8(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    public static final /* synthetic */ OngoingStubbing $anonfun$testLocalFetchCompletionIfHighWatermarkUpdated$2(AbstractLog log$1, Option appendInfo$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            Partition partition = (Partition)x0$1._2();
            Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log$1);
            Mockito.when((Object)partition.topicPartition()).thenReturn((Object)tp);
            return Mockito.when((Object)partition.appendRecordsToFollowerOrFutureReplica((MemoryRecords)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()))).thenReturn((Object)appendInfo$1);
        }
        throw new MatchError(null);
    }

    public ReplicaFetcherThreadTest() {
        this.metadataCache().updateMetadata(0, this.updateMetadataRequest());
    }
}

