/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.Server$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005=2AAB\u0004\u0001\u0019!)1\u0003\u0001C\u0001)!)q\u0003\u0001C\u00011!)\u0011\u0006\u0001C\u00011!)1\u0006\u0001C\u00011!)Q\u0006\u0001C\u00011\tQ1+\u001a:wKJ$Vm\u001d;\u000b\u0005!I\u0011AB:feZ,'OC\u0001\u000b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0007\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\tq!\u0001\u0015uKN$8I]3bi\u0016\u001cV\r\u001c4NC:\fw-\u001a3LC\u001a\\\u0017-T3ue&\u001c7oQ8oi\u0016DH\u000fF\u0001\u001a!\tq!$\u0003\u0002\u001c\u001f\t!QK\\5uQ\t\u0011Q\u0004\u0005\u0002\u001fO5\tqD\u0003\u0002!C\u0005\u0019\u0011\r]5\u000b\u0005\t\u001a\u0013a\u00026va&$XM\u001d\u0006\u0003I\u0015\nQA[;oSRT\u0011AJ\u0001\u0004_J<\u0017B\u0001\u0015 \u0005\u0011!Vm\u001d;\u0002;Q,7\u000f\u001e)s_\u000e,7o\u001d*pY\u0016\u001cH*\u00192fY&\u001b8k\u001c:uK\u0012D#aA\u000f\u0002\u001fQ,7\u000f^\"fY2LE\rT1cK2D#\u0001B\u000f\u0002?Q,7\u000f^\"sK\u0006$XMW6LC\u001a\\\u0017-T3ue&\u001c7oQ8oi\u0016DH\u000f\u000b\u0002\u0006;\u0001")
public class ServerTest {
    @Test
    public void testCreateSelfManagedKafkaMetricsContext() {
        int nodeId = 0;
        String clusterId = Uuid.randomUuid().toString();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        props.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        props.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId + 1).append("@localhost:9093").toString());
        props.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaMetricsContext context = Server$.MODULE$.createKafkaMetricsContext(config, clusterId);
        Object[] objectArray = new Tuple2[4];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"_namespace"), (Object)Server$.MODULE$.MetricsPrefix());
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Server$.MODULE$.ClusterIdLabel()), (Object)clusterId);
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Server$.MODULE$.NodeIdLabel()), (Object)Integer.toString(nodeId));
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Server$.MODULE$.ProcessRoleLabel()), (Object)"broker");
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Object)CollectionConverters$.MODULE$.MapHasAsScala(context.contextLabels()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ServerTest.$anonfun$testCreateSelfManagedKafkaMetricsContext$1(x0$1))));
    }

    @Test
    public void testProcessRolesLabelIsSorted() {
        int nodeId = 0;
        String clusterId = Uuid.randomUuid().toString();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller,broker");
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://localhost:9092,SSL://localhost:9093");
        props.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        props.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
        props.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaMetricsContext context = Server$.MODULE$.createKafkaMetricsContext(config, clusterId);
        Assertions.assertEquals((Object)new StringBuilder(1).append("broker").append(",").append("controller").toString(), context.contextLabels().get(Server$.MODULE$.ProcessRoleLabel()));
    }

    @Test
    public void testCellIdLabel() {
        String clusterId = Uuid.randomUuid().toString();
        int nodeId = 1;
        int brokerId = 1;
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        props.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), Integer.toString(brokerId));
        props.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId + 1).append("@localhost:9093").toString());
        props.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        props.put("confluent.cells.default.size", "3");
        props.put("confluent.cells.enable", "false");
        props.put("confluent.cells.implicit.creation.enable", "false");
        Assertions.assertNull(Server$.MODULE$.createKafkaMetricsContext(KafkaConfig$.MODULE$.fromProps(props), clusterId).contextLabels().get(Server$.MODULE$.CellIdLabel()));
        props.put("confluent.cells.enable", "true");
        Assertions.assertNull(Server$.MODULE$.createKafkaMetricsContext(KafkaConfig$.MODULE$.fromProps(props), clusterId).contextLabels().get(Server$.MODULE$.CellIdLabel()));
        props.put("confluent.cells.implicit.creation.enable", "true");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Assertions.assertNotNull(Server$.MODULE$.createKafkaMetricsContext(config, clusterId).contextLabels().get(Server$.MODULE$.CellIdLabel()));
        Assertions.assertEquals((Object)"0", Server$.MODULE$.createKafkaMetricsContext(config, clusterId).contextLabels().get(Server$.MODULE$.CellIdLabel()));
    }

    @Test
    public void testCreateZkKafkaMetricsContext() {
        int brokerId = 0;
        String clusterId = Uuid.randomUuid().toString();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), Integer.toString(brokerId));
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "127.0.0.1:0");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaMetricsContext context = Server$.MODULE$.createKafkaMetricsContext(config, clusterId);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"_namespace"), (Object)Server$.MODULE$.MetricsPrefix()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Server$.MODULE$.ClusterIdLabel()), (Object)clusterId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Server$.MODULE$.BrokerIdLabel()), (Object)Integer.toString(brokerId))})), (Object)CollectionConverters$.MODULE$.MapHasAsScala(context.contextLabels()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ServerTest.$anonfun$testCreateZkKafkaMetricsContext$1(x0$1))));
    }

    public static final /* synthetic */ boolean $anonfun$testCreateSelfManagedKafkaMetricsContext$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return !((String)x0$1._1()).startsWith("resource");
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateZkKafkaMetricsContext$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return !((String)x0$1._1()).startsWith("resource");
        }
        throw new MatchError(null);
    }
}

