/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kafka.server.link.AbstractClusterLinkClientManager;
import kafka.server.link.ClusterLinkAutoMirroring;
import kafka.server.link.ClusterLinkAutoMirroring$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ConnectionMode;
import kafka.server.link.SourceCluster$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.ListMirrorsOptions;
import org.apache.kafka.clients.admin.ListMirrorsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.ClusterLinkDisabledException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r%f\u0001B/_\u0001\u0015DQ\u0001\u001c\u0001\u0005\u00025Dq\u0001\u001d\u0001C\u0002\u0013%\u0011\u000f\u0003\u0004\u0000\u0001\u0001\u0006IA\u001d\u0005\t\u0003\u0003\u0001!\u0019!C\u0005c\"9\u00111\u0001\u0001!\u0002\u0013\u0011\b\"CA\u0003\u0001\t\u0007I\u0011BA\u0004\u0011!\ty\u0001\u0001Q\u0001\n\u0005%\u0001\"CA\t\u0001\t\u0007I\u0011BA\n\u0011!\tY\u0002\u0001Q\u0001\n\u0005U\u0001\"CA\u000f\u0001\t\u0007I\u0011BA\u0010\u0011!\t9\u0004\u0001Q\u0001\n\u0005\u0005\u0002\"CA\u001d\u0001\t\u0007I\u0011BA\u001e\u0011!\tI\u0005\u0001Q\u0001\n\u0005u\u0002\"CA&\u0001\t\u0007I\u0011BA\u001e\u0011!\ti\u0005\u0001Q\u0001\n\u0005u\u0002\"CA(\u0001\t\u0007I\u0011BA)\u0011!\ty\u0006\u0001Q\u0001\n\u0005M\u0003\"CA1\u0001\t\u0007I\u0011BA2\u0011!\tY\u0007\u0001Q\u0001\n\u0005\u0015\u0004\"CA7\u0001\t\u0007I\u0011BA8\u0011!\t9\b\u0001Q\u0001\n\u0005E\u0004\"CA=\u0001\t\u0007I\u0011BA>\u0011!\t)\n\u0001Q\u0001\n\u0005u\u0004\"CAL\u0001\t\u0007I\u0011BA>\u0011!\tI\n\u0001Q\u0001\n\u0005u\u0004bBAN\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0003w\u0003A\u0011AAO\u0011\u001d\t)\r\u0001C\u0005\u0003;Cq!a2\u0001\t\u0013\tI\rC\u0005\u0002V\u0002\t\n\u0011\"\u0003\u0002X\"9\u0011Q\u001e\u0001\u0005\n\u0005=\b\"CAz\u0001E\u0005I\u0011BAl\u0011\u001d\t)\u0010\u0001C\u0005\u0003oDqA!\u0003\u0001\t\u0013\u0011Y\u0001C\u0004\u0003\u001e\u0001!IAa\b\t\u0013\te\u0002!%A\u0005\n\tm\u0002b\u0002B \u0001\u0011%!\u0011\t\u0005\n\u0005\u001b\u0002\u0011\u0013!C\u0005\u0005wAqAa\u0014\u0001\t\u0013\u0011\t\u0006C\u0005\u0003b\u0001\t\n\u0011\"\u0003\u0003<!9!1\r\u0001\u0005\n\t\u0015\u0004b\u0002B2\u0001\u0011%!Q\u000e\u0005\b\u0005c\u0002A\u0011\u0002B:\u0011\u001d\u0011I\b\u0001C\u0005\u0005wBqA!\u001f\u0001\t\u0013\u0011y\tC\u0004\u0003\u001c\u0002!IA!(\t\u0013\t\u001d\u0006!%A\u0005\n\tm\u0002\"\u0003BU\u0001E\u0005I\u0011\u0002B\u001e\u0011\u001d\u0011Y\u000b\u0001C\u0001\u0003;CqA!.\u0001\t\u0003\ti\nC\u0004\u0003:\u0002!\t!!(\t\u000f\tu\u0006\u0001\"\u0001\u0002\u001e\"9!\u0011\u0019\u0001\u0005\u0002\u0005u\u0005b\u0002Bc\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0005\u0013\u0004A\u0011AAO\u0011\u001d\u0011i\r\u0001C\u0001\u0003;CqA!5\u0001\t\u0003\ti\nC\u0004\u0003V\u0002!\t!!(\t\u000f\te\u0007\u0001\"\u0001\u0002\u001e\"9!Q\u001c\u0001\u0005\u0002\u0005u\u0005b\u0002Bq\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0005K\u0004A\u0011AAO\u0011\u001d\u0011I\u000f\u0001C\u0001\u0003;CqA!<\u0001\t\u0003\ti\nC\u0004\u0003r\u0002!\t!!(\t\u000f\tU\b\u0001\"\u0001\u0002\u001e\"9!\u0011 \u0001\u0005\u0002\u0005u\u0005b\u0002B\u007f\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0007\u0003\u0001A\u0011AAO\u0011\u001d\u0019)\u0001\u0001C\u0001\u0003;Cqa!\u0003\u0001\t\u0003\ti\nC\u0004\u0004\u000e\u0001!\t!!(\t\u000f\rE\u0001\u0001\"\u0003\u0004\u0014!91\u0011\u0004\u0001\u0005\u0002\u0005u\u0005bBB\u000f\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0007C\u0001A\u0011AAO\u0011\u001d\u0019)\u0003\u0001C\u0001\u0003;Cqa!\u000b\u0001\t\u0003\ti\nC\u0004\u0004.\u0001!\t!!(\t\u000f\rE\u0002\u0001\"\u0001\u0002\u001e\u001a11Q\u0007\u0001\u0001\u0007oA!ba\u0010R\u0005\u0003\u0005\u000b\u0011BB!\u0011\u0019a\u0017\u000b\"\u0001\u0004H!I!1E)A\u0002\u0013\u00051q\n\u0005\n\u0007+\n\u0006\u0019!C\u0001\u0007/B\u0001b!\u0018RA\u0003&1\u0011\u000b\u0005\n\u0007?\n\u0006\u0019!C\u0001\u0007CB\u0011ba\u0019R\u0001\u0004%\ta!\u001a\t\u0011\r%\u0014\u000b)Q\u0005\u0003\u001fDqaa\u001bR\t\u0003\u001ai\u0007C\u0004\u0004\u0014F#\te!&\t\u000f\r\u0005\u0016\u000b\"\u0001\u0004$\na2\t\\;ti\u0016\u0014H*\u001b8l\u0003V$x.T5se>\u0014\u0018N\\4UKN$(BA0a\u0003\u0011a\u0017N\\6\u000b\u0005\u0005\u0014\u0017AB:feZ,'OC\u0001d\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u00014\u0011\u0005\u001dTW\"\u00015\u000b\u0003%\fQa]2bY\u0006L!a\u001b5\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u000e\u0005\u0002p\u00015\ta,A\u0006t_V\u00148-Z!e[&tW#\u0001:\u0011\u0005MlX\"\u0001;\u000b\u0005U4\u0018!B1e[&t'BA<y\u0003\u001d\u0019G.[3oiNT!aY=\u000b\u0005i\\\u0018AB1qC\u000eDWMC\u0001}\u0003\ry'oZ\u0005\u0003}R\u0014abQ8oM2,XM\u001c;BI6Lg.\u0001\u0007t_V\u00148-Z!e[&t\u0007%A\u0005eKN$\u0018\tZ7j]\u0006QA-Z:u\u0003\u0012l\u0017N\u001c\u0011\u0002\u001f5,G/\u00193bi\u0006l\u0015M\\1hKJ,\"!!\u0003\u0011\u0007=\fY!C\u0002\u0002\u000ey\u0013!d\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ\f\u0001#\\3uC\u0012\fG/Y'b]\u0006<WM\u001d\u0011\u0002\u001b\rd\u0017.\u001a8u\u001b\u0006t\u0017mZ3s+\t\t)\u0002E\u0002p\u0003/I1!!\u0007_\u0005q\u0019E.^:uKJd\u0015N\\6EKN$8\t\\5f]Rl\u0015M\\1hKJ\fab\u00197jK:$X*\u00198bO\u0016\u0014\b%\u0001\tj]\u000edW\u000fZ3BY24\u0015\u000e\u001c;feV\u0011\u0011\u0011\u0005\t\u0005\u0003G\t\tD\u0004\u0003\u0002&\u00055\u0002cAA\u0014Q6\u0011\u0011\u0011\u0006\u0006\u0004\u0003W!\u0017A\u0002\u001fs_>$h(C\u0002\u00020!\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u001a\u0003k\u0011aa\u0015;sS:<'bAA\u0018Q\u0006\t\u0012N\\2mk\u0012,\u0017\t\u001c7GS2$XM\u001d\u0011\u0002\r1Lgn[%e+\t\ti\u0004\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019\u0005_\u0001\u0007G>lWn\u001c8\n\t\u0005\u001d\u0013\u0011\t\u0002\u0005+VLG-A\u0004mS:\\\u0017\n\u001a\u0011\u0002\u001bM|WO]2f)>\u0004\u0018nY%e\u00039\u0019x.\u001e:dKR{\u0007/[2JI\u0002\n\u0001\u0002\\5oW\u0012\u000bG/Y\u000b\u0003\u0003'\u0002B!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0004\u00033\u0012\u0017A\u0001>l\u0013\u0011\ti&a\u0016\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006\f\u0011\u0002\\5oW\u0012\u000bG/\u0019\u0011\u0002\u000f5,GO]5dgV\u0011\u0011Q\r\t\u0004_\u0006\u001d\u0014bAA5=\n\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\t\t\t\bE\u0002p\u0003gJ1!!\u001e_\u0005Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe\u0006Q1o\u00195fIVdWM\u001d\u0011\u0002)Q|\u0007/[2Fq&\u001cHo]#yG\u0016\u0004H/[8o+\t\ti\bE\u0003h\u0003\u007f\n\u0019)C\u0002\u0002\u0002\"\u0014aa\u00149uS>t\u0007\u0003BAC\u0003\u001fsA!a\"\u0002\f:!\u0011qEAE\u0013\u0005I\u0017bAAGQ\u00069\u0001/Y2lC\u001e,\u0017\u0002BAI\u0003'\u0013\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u00055\u0005.A\u000bu_BL7-\u0012=jgR\u001cX\t_2faRLwN\u001c\u0011\u0002-\u0005,H\u000f[8sSj\fG/[8o\u000bb\u001cW\r\u001d;j_:\fq#Y;uQ>\u0014\u0018N_1uS>tW\t_2faRLwN\u001c\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005}\u0005cA4\u0002\"&\u0019\u00111\u00155\u0003\tUs\u0017\u000e\u001e\u0015\u00045\u0005\u001d\u0006\u0003BAU\u0003ok!!a+\u000b\t\u00055\u0016qV\u0001\u0004CBL'\u0002BAY\u0003g\u000bqA[;qSR,'OC\u0002\u00026n\fQA[;oSRLA!!/\u0002,\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3aGA`!\u0011\tI+!1\n\t\u0005\r\u00171\u0016\u0002\n\u0003\u001a$XM]#bG\"\f\u0011B]3tKRlunY6\u0002\u0013M,G/\u001e9N_\u000e\\G\u0003BAP\u0003\u0017D\u0011\"!4\u001e!\u0003\u0005\r!a4\u0002QM\\\u0017\u000e]'fi\u0006$\u0017\r^1NC:\fw-\u001a:MS:\\W\r\u001a+pa&\u001c7/\u00118e%\u0016\u0004H.Y=\u0011\u0007\u001d\f\t.C\u0002\u0002T\"\u0014qAQ8pY\u0016\fg.A\ntKR,\b/T8dW\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002Z*\"\u0011qZAnW\t\ti\u000e\u0005\u0003\u0002`\u0006%XBAAq\u0015\u0011\t\u0019/!:\u0002\u0013Ut7\r[3dW\u0016$'bAAtQ\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0018\u0011\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u0003<fe&4\u00170T8dWR!\u0011qTAy\u0011%\tim\bI\u0001\u0002\u0004\ty-\u0001\u000bwKJLg-_'pG.$C-\u001a4bk2$H%M\u0001\u0016[&\u0014(o\u001c:U_BL7m]!oIZ+'/\u001b4z)\u0011\tI0a@\u0011\u0007=\fY0C\u0002\u0002~z\u0013\u0001d\u00117vgR,'\u000fT5oW\u0006+Ho\\'jeJ|'/\u001b8h\u0011\u001d\u0011\t!\ta\u0001\u0005\u0007\t\u0011c\u00197vgR,'\u000fT5oW\u000e{gNZ5h!\ry'QA\u0005\u0004\u0005\u000fq&!E\"mkN$XM\u001d'j].\u001cuN\u001c4jO\u0006\u0001Rn\\2l\u0007J,\u0017\r^3U_BL7m\u001d\u000b\u0005\u0005\u001b\u0011\u0019\u0002E\u0002t\u0005\u001fI1A!\u0005u\u0005I\u0019%/Z1uKR{\u0007/[2t%\u0016\u001cX\u000f\u001c;\t\u000f\tU!\u00051\u0001\u0003\u0018\u0005QAo\u001c9jGN$v.\u0012=\u0011\u0011\u0005\r\"\u0011DA\u0011\u0003{JAAa\u0007\u00026\t\u0019Q*\u00199\u000255|7m[\"sK\u0006$X\rV8qS\u000e\u001c8+Y7f%\u0016\u001cX\u000f\u001c;\u0015\r\t5!\u0011\u0005B\u001b\u0011\u001d\u0011\u0019c\ta\u0001\u0005K\ta\u0001^8qS\u000e\u001c\bC\u0002B\u0014\u0005c\t\t#\u0004\u0002\u0003*)!!1\u0006B\u0017\u0003\u001diW\u000f^1cY\u0016T1Aa\fi\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005g\u0011ICA\u0002TKRD\u0011Ba\u000e$!\u0003\u0005\r!! \u0002\u0005\u0015D\u0018\u0001J7pG.\u001c%/Z1uKR{\u0007/[2t'\u0006lWMU3tk2$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tu\"\u0006BA?\u00037\f\u0001$\\8dW:{\u0017J\u001c;fe:\fG\u000eT5tiR{\u0007/[2t)\u0019\u0011\u0019E!\u0013\u0003LA\u00191O!\u0012\n\u0007\t\u001dCO\u0001\tMSN$Hk\u001c9jGN\u0014Vm];mi\"9!1E\u0013A\u0002\t\u0015\u0002\"\u0003B\u001cKA\u0005\t\u0019AA?\u0003\tjwnY6O_&sG/\u001a:oC2d\u0015n\u001d;U_BL7m\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005qQn\\2l\u0019&\u001cH\u000fV8qS\u000e\u001cHC\u0002B\"\u0005'\u0012y\u0006C\u0004\u0003V\u001d\u0002\rAa\u0016\u0002\u001f9\fW.Z:U_2K7\u000f^5oON\u0004\u0002\"a\t\u0003\u001a\u0005\u0005\"\u0011\f\t\u0004g\nm\u0013b\u0001B/i\naAk\u001c9jG2K7\u000f^5oO\"I!qG\u0014\u0011\u0002\u0003\u0007\u0011QP\u0001\u0019[>\u001c7\u000eT5tiR{\u0007/[2tI\u0011,g-Y;mi\u0012\u0012\u0014aD7pG.d\u0015n\u001d;NSJ\u0014xN]:\u0015\u0005\t\u001d\u0004cA:\u0003j%\u0019!1\u000e;\u0003#1K7\u000f^'jeJ|'o\u001d*fgVdG\u000f\u0006\u0003\u0003h\t=\u0004b\u0002B\u0012U\u0001\u0007!QE\u0001\u0007G>tg-[4\u0015\t\t\r!Q\u000f\u0005\b\u0005oZ\u0003\u0019AA\u0011\u0003-!x\u000e]5d\r&dG/\u001a:\u0002!Q,7\u000f^'jeJ|'\u000fV8qS\u000e\u001cH\u0003DAP\u0005{\u0012\tI!\"\u0003\n\n5\u0005b\u0002B@Y\u0001\u0007!QE\u0001\rg>,(oY3U_BL7m\u001d\u0005\b\u0005\u0007c\u0003\u0019\u0001B\u0013\u0003I\u0019x.\u001e:dK6K'O]8s)>\u0004\u0018nY:\t\u000f\t\u001dE\u00061\u0001\u0003&\u0005QA-Z:u)>\u0004\u0018nY:\t\u000f\t-E\u00061\u0001\u0003&\u0005yQ\r\u001f9fGR,G-T5se>\u00148\u000fC\u0004\u0003r1\u0002\rAa\u0001\u0015\u0015\u0005}%\u0011\u0013BJ\u0005+\u00139\nC\u0004\u0003\u00005\u0002\rA!\n\t\u000f\t\u001dU\u00061\u0001\u0003&!9!1R\u0017A\u0002\t\u0015\u0002b\u0002BM[\u0001\u0007\u0011\u0011E\u0001\u0007M&dG/\u001a:\u00023Q,7\u000f^'jeJ|'\u000fV8qS\u000e\u001cX\t_2faRLwN\u001c\u000b\u0007\u0003?\u0013yJa)\t\u0013\t\u0005f\u0006%AA\u0002\u0005u\u0014!F2sK\u0006$X\rV8qS\u000e\u001cX\t_2faRLwN\u001c\u0005\n\u0005Ks\u0003\u0013!a\u0001\u0003{\n1\u0003\\5tiR{\u0007/[2t\u000bb\u001cW\r\u001d;j_:\f1\u0005^3ti6K'O]8s)>\u0004\u0018nY:Fq\u000e,\u0007\u000f^5p]\u0012\"WMZ1vYR$\u0013'A\u0012uKN$X*\u001b:s_J$v\u000e]5dg\u0016C8-\u001a9uS>tG\u0005Z3gCVdG\u000f\n\u001a\u0002%Q,7\u000f^'jeJ|'o\u00148f)>\u0004\u0018n\u0019\u0015\u0004c\t=\u0006\u0003BAU\u0005cKAAa-\u0002,\n!A+Z:u\u0003}!Xm\u001d;O_\u000e\u0013X-\u0019;f)>\u0004\u0018nY:JMR{\u0007/[2Fq&\u001cHo\u001d\u0015\u0004e\t=\u0016A\u0007;fgR\u001c%/Z1uKR{\u0007/[2t/&$\b\u000e\u0015:fM&D\bfA\u001a\u00030\u0006\tC/Z:u\u001d>\u001c%/Z1uKR{\u0007/[2t\u0013\u001a$v\u000e]5d\u0013Nl\u0015N\u001d:pe\"\u001aAGa,\u0002\u001dQ,7\u000f^%oSRL\u0017\r\\5{K\"\u001aQGa,\u0002?Q,7\u000f^'jeJ|'o\u00148f)>\u0004\u0018n\u0019$s_6\f5n\u00117vgR,'\u000fK\u00027\u0005_\u000b\u0001\u0004^3ti&s7\r\\;eK2KG/\u001a:bY\u001aKG\u000e^3sQ\r9$qV\u0001\u001ai\u0016\u001cH/\u00138dYV$W\r\u0015:fM&DX\r\u001a$jYR,'\u000fK\u00029\u0005_\u000b\u0001\u0004^3ti\u0016C8\r\\;eK2KG/\u001a:bY\u001aKG\u000e^3sQ\rI$qV\u0001\u001ai\u0016\u001cH/\u0012=dYV$W\r\u0015:fM&DX\r\u001a$jYR,'\u000fK\u0002;\u0005_\u000b!\u0003^3ti\n\u000bGo\u00195NSJ\u0014xN]5oO\"\u001a1Ha,\u00027Q,7\u000f\u001e'jgR$v\u000e]5dg\u0006+H\u000f[#yG\u0016\u0004H/[8oQ\ra$qV\u0001\u001ei\u0016\u001cHo\u0011:fCR,Gk\u001c9jGN\fU\u000f\u001e5Fq\u000e,\u0007\u000f^5p]\"\u001aQHa,\u0002?Q,7\u000f^\"sK\u0006$X\rV8qS\u000e\u001cX\t_5tiN,\u0005pY3qi&|g\u000eK\u0002?\u0005_\u000b1\u0004^3ti\u0012+7\u000f\u001e'jgR$v\u000e]5dg\u0016C8-\u001a9uS>t\u0007fA \u00030\u0006aB/Z:u%\u0016l\u0017N\u001d:pe\u0012+G.\u001a;fI\u0012+7\u000f\u001e+pa&\u001c\u0007f\u0001!\u00030\u0006AB/Z:u\u001b&\u0014(o\u001c:OK^\u001cv.\u001e:dKR{\u0007/[2)\u0007\u0005\u0013y+\u0001\u000buKN$\u0018\t\u001a3J]\u000edW\u000fZ3GS2$XM\u001d\u0015\u0004\u0005\n=\u0016a\u0006;fgR$U\r\\3uK\u0016C8\r\\;eK\u001aKG\u000e^3sQ\r\u0019%qV\u0001\u0018i\u0016\u001cH\u000fR3mKR,\u0017J\\2mk\u0012,g)\u001b7uKJD3\u0001\u0012BX\u0003=\"Xm\u001d;O_\u0012+\b\u000f\\5dCR,7I]3bi\u0016$v\u000e]5dg\u000e\u000bG\u000e\u001c$pe\u0016C\u0018n\u001d;j]\u001e$v\u000e]5dQ\r)%qV\u00013i\u0016\u001cH\u000fV8qS\u000e\u001c\u0015M\u001c\"f\u0007J,\u0017\r^3e\u0003\u001a$XM]\"p]\u001ad\u0017n\u0019;j]\u001e$v\u000e]5d\t\u0016dW\r^5p]\"\u001aaIa,\u0002MQ,7\u000f\u001e(p\u0007J,\u0017\r^3U_BL7m]\"bY24uN]%oi\u0016\u0014h.\u00197U_BL7\rK\u0002H\u0005_\u000bq\u0005^3ti:{7I]3bi\u0016$v\u000e]5dg\u000e\u000bG\u000e\u001c$pe\u000e{gN\u001a7vK:$Hk\u001c9jG\"\u001a\u0001Ja,\u0002aY,'/\u001b4z\u001d>\u001c%/Z1uKR{\u0007/[2t\r>\u0014\u0018J\u001c;fe:\fGn\u0014:D_:4G.^3oiR{\u0007/[2t)\u0011\tyj!\u0006\t\u000f\r]\u0011\n1\u0001\u0003Z\u0005aAo\u001c9jG2K7\u000f^5oO\u0006qB/Z:u\u0007>tg\r\\5di&tw\rR3ti\u000e\u000b7\r[3WC2,Xm\u001d\u0015\u0004\u0015\n=\u0016!\u000b;fgRtun\u0011:fCR,Gk\u001c9jG^KG\u000f[%oC\u000e$\u0018N^3NSJ\u0014xN\u001d+pa&\u001c7\u000fK\u0002L\u0005_\u000ba\u0005^3ti6+H\u000e^5qY\u0016<&/\u001b;feNlUM]4f)>\u0004\u0018nY:U_\u000e\u0013X-\u0019;fQ\ra%qV\u00014i\u0016\u001cHoU8ve\u000e,7\t\\;ti\u0016\u00148)\u00198D_:$\u0018-\u001b8NSJ\u0014xN\u001d+pa&\u001c7OU3ukJt7OR1mg\u0016D3!\u0014BX\u0003!#Xm\u001d;T_V\u00148-Z\"mkN$XM]\"b]\u000e{g\u000e^1j]6K'O]8s)>\u0004\u0018nY:SKR,(O\\:UeV,G)^3U_^\u0013xN\\4FeJ|'/T3tg\u0006<W\rK\u0002O\u0005_\u000bq\b^3tiN{WO]2f\u00072,8\u000f^3s\u0007\u0006t7i\u001c8uC&tW*\u001b:s_J$v\u000e]5dg\n\u000b7/[2DYV\u001cH/\u001a:SKR,(O\\:GC2\u001cX\rK\u0002P\u0005_\u000bq\u0002^3ti\u001aKG\u000e^3s)>\u0004\u0018n\u0019\u0015\u0004!\n=&a\u0004+fgR\fE-\\5o\u00072LWM\u001c;\u0014\u0007E\u001bI\u0004E\u0002t\u0007wI1a!\u0010u\u0005=iunY6BI6Lgn\u00117jK:$\u0018\u0001\u00028pI\u0016\u0004B!a\u0010\u0004D%!1QIA!\u0005\u0011qu\u000eZ3\u0015\t\r%3Q\n\t\u0004\u0007\u0017\nV\"\u0001\u0001\t\u000f\r}2\u000b1\u0001\u0004BU\u00111\u0011\u000b\t\u0007\u0003G\u0019\u0019&!\t\n\t\tM\u0012QG\u0001\u000bi>\u0004\u0018nY:`I\u0015\fH\u0003BAP\u00073B\u0011ba\u0017V\u0003\u0003\u0005\ra!\u0015\u0002\u0007a$\u0013'A\u0004u_BL7m\u001d\u0011\u0002\u0019\u0011,G.\u001a;f\u0007\u0006dG.\u001a3\u0016\u0005\u0005=\u0017\u0001\u00053fY\u0016$XmQ1mY\u0016$w\fJ3r)\u0011\tyja\u001a\t\u0013\rm\u0003,!AA\u0002\u0005=\u0017!\u00043fY\u0016$XmQ1mY\u0016$\u0007%\u0001\u0007de\u0016\fG/\u001a+pa&\u001c7\u000f\u0006\u0004\u0003\u000e\r=4\u0011\u0012\u0005\b\u0007cR\u0006\u0019AB:\u0003%qWm\u001e+pa&\u001c7\u000f\u0005\u0004\u0004v\r}41Q\u0007\u0003\u0007oRAa!\u001f\u0004|\u0005!Q\u000f^5m\u0015\t\u0019i(\u0001\u0003kCZ\f\u0017\u0002BBA\u0007o\u0012!bQ8mY\u0016\u001cG/[8o!\r\u00198QQ\u0005\u0004\u0007\u000f#(\u0001\u0003(foR{\u0007/[2\t\u000f\r-%\f1\u0001\u0004\u000e\u00069q\u000e\u001d;j_:\u001c\bcA:\u0004\u0010&\u00191\u0011\u0013;\u0003'\r\u0013X-\u0019;f)>\u0004\u0018nY:PaRLwN\\:\u0002\u0019\u0011,G.\u001a;f)>\u0004\u0018nY:\u0015\t\r]5Q\u0014\t\u0004g\u000ee\u0015bABNi\n\u0011B)\u001a7fi\u0016$v\u000e]5dgJ+7/\u001e7u\u0011\u001d\u0011\u0019c\u0017a\u0001\u0007?\u0003ba!\u001e\u0004\u0000\u0005\u0005\u0012!E1eIR{\u0007/[2PkR|eMQ1oIR!\u0011qTBS\u0011\u001d\u00199\u000b\u0018a\u0001\u0003C\tQ\u0001^8qS\u000e\u0004")
public class ClusterLinkAutoMirroringTest {
    private final ConfluentAdmin sourceAdmin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ConfluentAdmin destAdmin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    private final ClusterLinkDestClientManager clientManager = (ClusterLinkDestClientManager)Mockito.mock(ClusterLinkDestClientManager.class);
    private final String includeAllFilter;
    private final Uuid linkId = Uuid.randomUuid();
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final ClusterLinkData linkData = new ClusterLinkData("testLink", this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
    private final ClusterLinkMetrics metrics = new ClusterLinkMetrics("test-link", this.linkId(), ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, false, (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class), (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$);
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final Option<Throwable> topicExistsException = new Some((Object)new TopicExistsException(""));
    private final Option<Throwable> authorizationException = new Some((Object)new AuthorizationException(""));

    private ConfluentAdmin sourceAdmin() {
        return this.sourceAdmin;
    }

    private ConfluentAdmin destAdmin() {
        return this.destAdmin;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    private String includeAllFilter() {
        return this.includeAllFilter;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private ClusterLinkData linkData() {
        return this.linkData;
    }

    private ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private Option<Throwable> topicExistsException() {
        return this.topicExistsException;
    }

    private Option<Throwable> authorizationException() {
        return this.authorizationException;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
        this.metrics().startup();
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
        this.metrics().shutdown();
    }

    private void resetMock() {
        Mockito.reset((Object[])new ConfluentAdmin[]{this.sourceAdmin()});
        Mockito.reset((Object[])new ConfluentAdmin[]{this.destAdmin()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.reset((Object[])new ClusterLinkDestClientManager[]{this.clientManager()});
    }

    private void setupMock(boolean skipMetadataManagerLinkedTopicsAndReplay) {
        this.resetMock();
        Mockito.when((Object)this.clientManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.clientManager().getAdmin()).thenReturn((Object)this.sourceAdmin());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        if (!skipMetadataManagerLinkedTopicsAndReplay) {
            Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)Predef$.MODULE$.Map().empty());
            return;
        }
    }

    private boolean setupMock$default$1() {
        return false;
    }

    private void verifyMock(boolean skipMetadataManagerLinkedTopicsAndReplay) {
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).scheduler();
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).getAdmin();
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.atLeastOnce())).currentConfig();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.atLeastOnce())).isLinkCoordinator(ArgumentMatchers.anyString());
        if (!skipMetadataManagerLinkedTopicsAndReplay) {
            ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.atLeastOnce())).mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any());
            return;
        }
    }

    private boolean verifyMock$default$1() {
        return false;
    }

    private ClusterLinkAutoMirroring mirrorTopicsAndVerify(ClusterLinkConfig clusterLinkConfig) {
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)clusterLinkConfig);
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock(false);
        return clusterLinkAutoMirroring;
    }

    private CreateTopicsResult mockCreateTopics(scala.collection.immutable.Map<String, Option<Throwable>> topicsToEx) {
        HashMap futures = new HashMap();
        KafkaFutureImpl allFuture = new KafkaFutureImpl();
        IntRef numExceptions = IntRef.create((int)0);
        topicsToEx.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                Option ex = (Option)x0$1._2();
                KafkaFutureImpl future = new KafkaFutureImpl();
                if (ex instanceof Some) {
                    Throwable e = (Throwable)((Some)ex).value();
                    future.completeExceptionally(e);
                    ++numExceptions$1.elem;
                } else {
                    future.complete((Object)new CreateTopicsResult.TopicMetadataAndConfig(Uuid.randomUuid(), 1, 1, new Config(Collections.emptyList())));
                }
                return (KafkaFuture)futures.put(topicName, future);
            }
            throw new MatchError(null);
        });
        if (numExceptions.elem > 0) {
            allFuture.completeExceptionally((Throwable)((Option)((Tuple2)topicsToEx.head())._2()).get());
        } else {
            allFuture.complete(null);
        }
        CreateTopicsResult result = (CreateTopicsResult)Mockito.mock(CreateTopicsResult.class);
        Mockito.when((Object)result.values()).thenReturn(futures);
        Mockito.when((Object)result.all()).thenReturn((Object)allFuture);
        return result;
    }

    private CreateTopicsResult mockCreateTopicsSameResult(Set<String> topics, Option<Throwable> ex) {
        return this.mockCreateTopics((scala.collection.immutable.Map<String, Option<Throwable>>)((IterableOnceOps)topics.map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)ex))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private Option<Throwable> mockCreateTopicsSameResult$default$2() {
        return Option$.MODULE$.empty();
    }

    private ListTopicsResult mockNoInternalListTopics(Set<String> topics, Option<Throwable> ex) {
        scala.collection.immutable.Map namesToListings = ((IterableOnceOps)topics.map((Function1 & Serializable)topicName -> new Tuple2(topicName, (Object)new TopicListing(topicName, Uuid.ZERO_UUID, false)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return this.mockListTopics((scala.collection.immutable.Map<String, TopicListing>)namesToListings, ex);
    }

    private Option<Throwable> mockNoInternalListTopics$default$2() {
        return Option$.MODULE$.empty();
    }

    private ListTopicsResult mockListTopics(scala.collection.immutable.Map<String, TopicListing> namesToListings, Option<Throwable> ex) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (ex instanceof Some) {
            Throwable e = (Throwable)((Some)ex).value();
            future.completeExceptionally(e);
        } else {
            future.complete((Object)CollectionConverters$.MODULE$.MapHasAsJava(namesToListings).asJava());
        }
        ListTopicsResult result = (ListTopicsResult)Mockito.mock(ListTopicsResult.class);
        Mockito.when((Object)result.namesToListings()).thenReturn((Object)future);
        KafkaFutureImpl namesFuture = new KafkaFutureImpl();
        namesFuture.complete(CollectionConverters$.MODULE$.MapHasAsJava(namesToListings).asJava().keySet());
        Mockito.when((Object)result.names()).thenReturn((Object)namesFuture);
        return result;
    }

    private Option<Throwable> mockListTopics$default$2() {
        return Option$.MODULE$.empty();
    }

    private ListMirrorsResult mockListMirrors() {
        return this.mockListMirrors((Set<String>)((Set)Set$.MODULE$.empty()));
    }

    private ListMirrorsResult mockListMirrors(Set<String> topics) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete((Object)CollectionConverters$.MODULE$.MutableSetHasAsJava(topics).asJava());
        ListMirrorsResult result = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)result.result()).thenReturn((Object)future);
        return result;
    }

    private ClusterLinkConfig config(String topicFilter) {
        return ClusterLinkConfig$.MODULE$.create(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)topicFilter)}))).asJava(), true);
    }

    private void testMirrorTopics(Set<String> sourceTopics, Set<String> sourceMirrorTopics, Set<String> destTopics, Set<String> expectedMirrors, ClusterLinkConfig config) {
        this.setupMock(true);
        ConcurrentHashMap linkedTopics = new ConcurrentHashMap();
        destTopics.foreach((Function1 & Serializable)destTopic -> {
            ClusterLinkTopicState.Mirror testActiveTopicState = new ClusterLinkTopicState.Mirror(destTopic, this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
            return (ClusterLinkTopicState)linkedTopics.put(destTopic, testActiveTopicState);
        });
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics(sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors(sourceMirrorTopics);
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala());
        int numCreateTopicsCall = 0;
        if (expectedMirrors.nonEmpty()) {
            java.util.List mockCreateTopicsResultList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)expectedMirrors.grouped(100).map((Function1 & Serializable)batch -> this.mockCreateTopicsSameResult((Set<String>)batch, (Option<Throwable>)Option$.MODULE$.empty())).toList()).asJava();
            Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenAnswer(AdditionalAnswers.returnsElementsOf((Collection)mockCreateTopicsResultList));
            numCreateTopicsCall = mockCreateTopicsResultList.size();
        }
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = this.mirrorTopicsAndVerify(config);
        Assertions.assertEquals(expectedMirrors, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        if (expectedMirrors.nonEmpty()) {
            ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)numCreateTopicsCall))).createTopics((Collection)ArgumentMatchers.any());
            return;
        }
    }

    private void testMirrorTopics(Set<String> sourceTopics, Set<String> destTopics, Set<String> expectedMirrors, String filter) {
        this.testMirrorTopics(sourceTopics, (Set<String>)((Set)Set$.MODULE$.empty()), destTopics, expectedMirrors, this.config(filter));
    }

    private void testMirrorTopicsException(Option<Throwable> createTopicsException, Option<Throwable> listTopicsException) {
        this.setupMock(false);
        Set sampleSet = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set emptySet = (Set)Set$.MODULE$.empty();
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sampleSet, listTopicsException);
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        CreateTopicsResult mockCreateTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sampleSet, createTopicsException);
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)mockCreateTopicsResult);
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = this.mirrorTopicsAndVerify(this.config(this.includeAllFilter()));
        Assertions.assertEquals((Object)emptySet, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        ((Admin)Mockito.verify((Object)this.sourceAdmin())).listTopics();
    }

    private Option<Throwable> testMirrorTopicsException$default$1() {
        return Option$.MODULE$.empty();
    }

    private Option<Throwable> testMirrorTopicsException$default$2() {
        return Option$.MODULE$.empty();
    }

    @Test
    public void testMirrorOneTopic() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, this.includeAllFilter());
    }

    @Test
    public void testNoCreateTopicsIfTopicExists() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set destTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set expectedMirrors = (Set)Set$.MODULE$.empty();
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, this.includeAllFilter());
    }

    @Test
    public void testCreateTopicsWithPrefix() {
        String prefix = "prefix-";
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(prefix).append("test-topic").toString()}));
        Set sourceMirrorTopics = (Set)Set$.MODULE$.empty();
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(prefix).append("test-topic").toString()}));
        ClusterLinkConfig clConfig = ClusterLinkConfig$.MODULE$.create(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllFilter()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp()), (Object)prefix)}))).asJava(), true);
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)sourceMirrorTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, clConfig);
    }

    @Test
    public void testNoCreateTopicsIfTopicIsMirror() {
        String prefix = "prefix-";
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(prefix).append("test-topic").toString()}));
        Set sourceMirrorTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(prefix).append("test-topic").toString()}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.empty();
        ClusterLinkConfig clConfig = ClusterLinkConfig$.MODULE$.create(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllFilter()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp()), (Object)prefix)}))).asJava(), true);
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)sourceMirrorTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, clConfig);
    }

    @Test
    public void testInitialize() {
        String prefix = "prefix-";
        Set sourceTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.empty();
        ClusterLinkConfig clConfig = ClusterLinkConfig$.MODULE$.create(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllFilter()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp()), (Object)prefix)}))).asJava(), true);
        this.setupMock(true);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new UnsupportedVersionException("The broker does not support LIST_MIRRORS"));
        ListMirrorsResult listMirrorsResult = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)listMirrorsResult.result()).thenReturn((Object)future);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala());
        int numCreateTopicsCall = 0;
        if (expectedMirrors.nonEmpty()) {
            java.util.List mockCreateTopicsResultList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)expectedMirrors.grouped(100).map((Function1 & Serializable)batch -> this.mockCreateTopicsSameResult((Set<String>)batch, (Option<Throwable>)Option$.MODULE$.empty())).toList()).asJava();
            Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenAnswer(AdditionalAnswers.returnsElementsOf((Collection)mockCreateTopicsResultList));
            numCreateTopicsCall = mockCreateTopicsResultList.size();
        }
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)clConfig);
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        Assertions.assertFalse((boolean)clusterLinkAutoMirroring.getInitialized());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)clusterLinkAutoMirroring.getInitialized());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)clusterLinkAutoMirroring.getInitialized());
        this.verifyMock(true);
        ((ListMirrorsResult)Mockito.verify((Object)listMirrorsResult)).result();
        ((ConfluentAdmin)Mockito.verify((Object)this.sourceAdmin())).listMirrors((ListMirrorsOptions)ArgumentMatchers.any());
        if (expectedMirrors.nonEmpty()) {
            ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)numCreateTopicsCall))).createTopics((Collection)ArgumentMatchers.any());
            return;
        }
    }

    @Test
    public void testMirrorOneTopicFromAkCluster() {
        String prefix = "prefix-";
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(prefix).append("test-topic").toString()}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(prefix).append("test-topic").toString()}));
        ClusterLinkConfig clConfig = ClusterLinkConfig$.MODULE$.create(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllFilter()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp()), (Object)prefix)}))).asJava(), true);
        this.setupMock(true);
        ConcurrentHashMap linkedTopics = new ConcurrentHashMap();
        destTopics.foreach((Function1 & Serializable)destTopic -> {
            ClusterLinkTopicState.Mirror testActiveTopicState = new ClusterLinkTopicState.Mirror(destTopic, this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
            return (ClusterLinkTopicState)linkedTopics.put(destTopic, testActiveTopicState);
        });
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new UnsupportedVersionException("The broker does not support LIST_MIRRORS"));
        ListMirrorsResult listMirrorsResult = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)listMirrorsResult.result()).thenReturn((Object)future);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala());
        int numCreateTopicsCall = 0;
        if (expectedMirrors.nonEmpty()) {
            java.util.List mockCreateTopicsResultList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)expectedMirrors.grouped(100).map((Function1 & Serializable)batch -> this.mockCreateTopicsSameResult((Set<String>)batch, (Option<Throwable>)Option$.MODULE$.empty())).toList()).asJava();
            Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenAnswer(AdditionalAnswers.returnsElementsOf((Collection)mockCreateTopicsResultList));
            numCreateTopicsCall = mockCreateTopicsResultList.size();
        }
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = this.mirrorTopicsAndVerify(clConfig);
        Assertions.assertEquals((Object)expectedMirrors, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        ((ListMirrorsResult)Mockito.verify((Object)listMirrorsResult)).result();
        ((ConfluentAdmin)Mockito.verify((Object)this.sourceAdmin())).listMirrors((ListMirrorsOptions)ArgumentMatchers.any());
        if (expectedMirrors.nonEmpty()) {
            ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)numCreateTopicsCall))).createTopics((Collection)ArgumentMatchers.any());
            return;
        }
    }

    @Test
    public void testIncludeLiteralFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filter = "{\"topicFilters\":[{\"name\":\"include-topic\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"}]}";
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, filter);
    }

    @Test
    public void testIncludePrefixedFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filter = "{\"topicFilters\":[{\"name\":\"include\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, filter);
    }

    @Test
    public void testExcludeLiteralFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filter = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"},{\"name\":\"exclude-topic\",\"filterType\":\"EXCLUDE\",\"patternType\":\"LITERAL\"}]}";
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, filter);
    }

    @Test
    public void testExcludePrefixedFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopics = (Set)Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filter = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"},{\"name\":\"exclude\",\"filterType\":\"EXCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, filter);
    }

    @Test
    public void testBatchMirroring() {
        Set sourceTopics = (Set)Set$.MODULE$.empty();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> sourceTopics.add((Object)new StringBuilder(6).append("topic-").append(i).toString()));
        Set destTopics = (Set)Set$.MODULE$.empty();
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)sourceTopics, this.includeAllFilter());
    }

    @Test
    public void testListTopicsAuthException() {
        Option<Throwable> x$1 = this.authorizationException();
        Option x$2 = Option$.MODULE$.empty();
        this.testMirrorTopicsException((Option<Throwable>)x$2, x$1);
    }

    @Test
    public void testCreateTopicsAuthException() {
        this.testMirrorTopicsException(this.authorizationException(), (Option<Throwable>)Option$.MODULE$.empty());
    }

    @Test
    public void testCreateTopicsExistsException() {
        this.testMirrorTopicsException(this.topicExistsException(), (Option<Throwable>)Option$.MODULE$.empty());
    }

    @Test
    public void testDestListTopicsException() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        this.setupMock(false);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sourceTopics, this.topicExistsException());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResult);
        listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, this.authorizationException());
        Mockito.when((Object)this.destAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.destAdmin())).createTopics((Collection)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.destAdmin())).listTopics();
    }

    @Test
    public void testRemirrorDeletedDestTopic() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        this.setupMock(false);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).listTopics();
    }

    @Test
    public void testMirrorNewSourceTopic() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set sourceTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic", "test-topic-2"}));
        ConcurrentHashMap linkedTopics = new ConcurrentHashMap();
        ConcurrentHashMap<String, ClusterLinkTopicState.Mirror> linkedTopicsNew = new ConcurrentHashMap<String, ClusterLinkTopicState.Mirror>();
        ClusterLinkTopicState.Mirror testActiveTopicState = new ClusterLinkTopicState.Mirror("test-topic", this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
        linkedTopicsNew.put("test-topic", testActiveTopicState);
        this.setupMock(true);
        ListTopicsResult mockSourceTopicsList = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        ListTopicsResult mockSourceTopicsNewList = this.mockNoInternalListTopics((Set<String>)sourceTopicsNew, (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)mockSourceTopicsList).thenReturn((Object)mockSourceTopicsNewList);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala()).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopicsNew).asScala());
        CreateTopicsResult mockSourceCreateTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        CreateTopicsResult mockTestTopics2Result = this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-2"}))), (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)mockSourceCreateTopicsResult).thenReturn((Object)mockTestTopics2Result);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-2"})), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock(true);
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).listTopics();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
    }

    @Test
    public void testAddIncludeFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"old-topic", "new-topic"}));
        ConcurrentHashMap linkedTopics = new ConcurrentHashMap();
        ConcurrentHashMap<String, ClusterLinkTopicState.Mirror> linkedTopicsNew = new ConcurrentHashMap<String, ClusterLinkTopicState.Mirror>();
        ClusterLinkTopicState.Mirror testActiveTopicState = new ClusterLinkTopicState.Mirror("old-topic", this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
        linkedTopicsNew.put("old-topic", testActiveTopicState);
        Set destTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"old-topic"}));
        String filterOne = "{\"topicFilters\":[{\"name\":\"old\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        String filterTwo = "{\"topicFilters\":[{\"name\":\"old\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"},{\"name\":\"new\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        this.setupMock(true);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala()).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopicsNew).asScala());
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"old-topic"}))), (Option<Throwable>)Option$.MODULE$.empty());
        CreateTopicsResult newCreateTopicsResult = this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"new-topic"}))), (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResult).thenReturn((Object)newCreateTopicsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(filterOne)).thenReturn((Object)this.config(filterTwo));
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)destTopicsNew, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"new-topic"})), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock(true);
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).listTopics();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)4))).currentConfig();
    }

    @Test
    public void testDeleteExcludeFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filterOne = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"},{\"name\":\"exclude\",\"filterType\":\"EXCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        String filterTwo = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"}]}";
        this.setupMock(false);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        CreateTopicsResult mockIncludeTopicsResult = this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}))), (Option<Throwable>)Option$.MODULE$.empty());
        CreateTopicsResult mockExcludeTopicsResult = this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"exclude-topic"}))), (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)mockIncludeTopicsResult).thenReturn((Object)mockExcludeTopicsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(filterOne)).thenReturn((Object)this.config(filterTwo));
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)destTopicsNew, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"exclude-topic"})), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).listTopics();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)4))).currentConfig();
    }

    @Test
    public void testDeleteIncludeFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "test-topic-2"}));
        Set sourceTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "test-topic-2", "test-topic-3"}));
        Set destTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "test-topic-2"}));
        String filterOne = "{\"topicFilters\":[{\"name\":\"test\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"},{\"name\":\"include\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        String filterTwo = "{\"topicFilters\":[{\"name\":\"include\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        this.setupMock(true);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        ListTopicsResult listTopicsNewResult = this.mockNoInternalListTopics((Set<String>)sourceTopicsNew, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult, (Object[])new ListTopicsResult[]{listTopicsNewResult});
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "test-topic-2"}))), (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(filterOne), (Object[])new ClusterLinkConfig[]{this.config(filterOne), this.config(filterTwo), this.config(filterTwo)});
        ConcurrentHashMap linkedTopics = new ConcurrentHashMap();
        destTopicsNew.foreach((Function1 & Serializable)destTopic -> {
            ClusterLinkTopicState.Mirror testActiveTopicState = new ClusterLinkTopicState.Mirror(destTopic, this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
            return (ClusterLinkTopicState)linkedTopics.put(destTopic, testActiveTopicState);
        });
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)Predef$.MODULE$.Map().empty()).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala());
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)destTopicsNew, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).listTopics();
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.times((int)2))).mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.destAdmin())).createTopics((Collection)ArgumentMatchers.any());
        ((AbstractClusterLinkClientManager)Mockito.verify((Object)this.clientManager(), (VerificationMode)Mockito.times((int)4))).currentConfig();
    }

    @Test
    public void testNoDuplicateCreateTopicsCallForExistingTopic() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set nonMirrorDestTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set expectedMirrors = (Set)Set$.MODULE$.empty();
        this.setupMock(false);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sourceTopics, this.topicExistsException());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResult);
        ListTopicsResult listDestTopicsResult = this.mockNoInternalListTopics((Set<String>)nonMirrorDestTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().listTopics()).thenReturn((Object)listDestTopicsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)expectedMirrors, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)expectedMirrors, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.destAdmin())).listTopics();
    }

    @Test
    public void testTopicCanBeCreatedAfterConflictingTopicDeletion() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set nonMirrorDestTopics = (Set)Set$.MODULE$.empty();
        this.setupMock(false);
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        CreateTopicsResult createTopicsResultTopicExists = this.mockCreateTopicsSameResult((Set<String>)sourceTopics, this.topicExistsException());
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResultTopicExists).thenReturn((Object)createTopicsResult);
        ListTopicsResult nonMirrorDestTopicsResult = this.mockNoInternalListTopics((Set<String>)nonMirrorDestTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().listTopics()).thenReturn((Object)nonMirrorDestTopicsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.destAdmin())).listTopics();
    }

    @Test
    public void testNoCreateTopicsCallForInternalTopic() {
        TopicListing internalTopic = new TopicListing("_mock_internal_topic", Uuid.ZERO_UUID, true);
        this.verifyNoCreateTopicsForInternalOrConfluentTopics(internalTopic);
    }

    @Test
    public void testNoCreateTopicsCallForConfluentTopic() {
        TopicListing confluentTopic = new TopicListing("_confluent-metadata-auth", Uuid.ZERO_UUID, false);
        this.verifyNoCreateTopicsForInternalOrConfluentTopics(confluentTopic);
    }

    private void verifyNoCreateTopicsForInternalOrConfluentTopics(TopicListing topicListing) {
        this.setupMock(false);
        ListTopicsResult mockListTopicsResult = this.mockListTopics((scala.collection.immutable.Map<String, TopicListing>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicListing.name()), (Object)topicListing)}))), (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)mockListTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics()).runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock(false);
    }

    @Test
    public void testConflictingDestCacheValues() {
        Set sourceTopicsOld = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-1"}));
        Set sourceTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-1", "test-topic-2"}));
        Set destTopicsNew = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-2"}));
        this.setupMock(false);
        ListTopicsResult listOldTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopicsOld, (Option<Throwable>)Option$.MODULE$.empty());
        ListTopicsResult listNewTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopicsNew, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listOldTopicsResult).thenReturn((Object)listNewTopicsResult);
        ListMirrorsResult mirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)mirrorsResult);
        ListTopicsResult listDestTopicsResult = this.mockNoInternalListTopics((Set<String>)destTopicsNew, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.destAdmin().listTopics()).thenReturn((Object)listDestTopicsResult);
        CreateTopicsResult createTopicsResult = this.mockCreateTopicsSameResult((Set<String>)sourceTopicsOld, this.topicExistsException());
        Mockito.when((Object)this.destAdmin().createTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)createTopicsResult).thenReturn((Object)this.mockCreateTopics((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test-topic-2"), this.topicExistsException()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test-topic-1"), (Object)Option$.MODULE$.empty())})))));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopicsOld, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)sourceTopicsOld, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)destTopicsNew, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock(false);
        ((Admin)Mockito.verify((Object)this.sourceAdmin(), (VerificationMode)Mockito.times((int)2))).listTopics();
        ((Admin)Mockito.verify((Object)this.destAdmin(), (VerificationMode)Mockito.times((int)2))).createTopics((Collection)ArgumentMatchers.any());
        ((Admin)Mockito.verify((Object)this.destAdmin())).listTopics();
    }

    @Test
    public void testNoCreateTopicWithInactiveMirrorTopics() {
        this.resetMock();
        Mockito.when((Object)this.clientManager().scheduler()).thenReturn((Object)this.scheduler());
        Mockito.when((Object)this.clientManager().getAdmin()).thenReturn((Object)this.sourceAdmin());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ClusterLinkTopicState.Mirror testActiveTopicState = new ClusterLinkTopicState.Mirror("testLink", this.linkId(), this.sourceTopicId(), Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
        ClusterLinkTopicState.PendingStoppedMirror testPendingStopTopicState = new ClusterLinkTopicState.PendingStoppedMirror("testLink", this.linkId(), this.sourceTopicId(), false, Time.SYSTEM.milliseconds());
        ClusterLinkTopicState.FailedMirror testFailedTopicState = new ClusterLinkTopicState.FailedMirror("testLink", this.linkId(), this.sourceTopicId(), MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, Time.SYSTEM.milliseconds());
        ClusterLinkTopicState.StoppedMirror testStoppedTopicState = new ClusterLinkTopicState.StoppedMirror("testLink", this.linkId(), this.sourceTopicId(), (Seq)package$.MODULE$.Seq().empty(), Time.SYSTEM.milliseconds());
        ClusterLinkTopicState.PausedMirror testPausedTopicState = new ClusterLinkTopicState.PausedMirror("testLink", this.linkId(), this.sourceTopicId(), false, true, false, MirrorTopicError.NO_ERROR, Time.SYSTEM.milliseconds(), (Seq)Seq$.MODULE$.empty());
        ConcurrentHashMap<String, Object> linkedTopics = new ConcurrentHashMap<String, Object>();
        linkedTopics.put("testTopic", testActiveTopicState);
        linkedTopics.put("testTopicPendingStopped", testPendingStopTopicState);
        linkedTopics.put("testTopicFailed", testFailedTopicState);
        linkedTopics.put("testTopicPaused", testPausedTopicState);
        linkedTopics.put("testTopicStopped", testStoppedTopicState);
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(linkedTopics.keySet()).asScala(), (Option<Throwable>)Option$.MODULE$.empty());
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock(false);
    }

    @Test
    public void testMultipleWritersMergeTopicsToCreate() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-1"}));
        String outOfBandTopic = "test-topic-2";
        Set expectedTopicsAtEnd = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-1", "test-topic-2"}));
        this.setupMock(true);
        ConcurrentHashMap linkedTopics = new ConcurrentHashMap();
        ListTopicsResult listTopicsResult = this.mockNoInternalListTopics((Set<String>)sourceTopics, (Option<Throwable>)Option$.MODULE$.empty());
        Mockito.when((Object)this.sourceAdmin().listTopics()).thenReturn((Object)listTopicsResult);
        ListMirrorsResult listMirrorsResult = this.mockListMirrors();
        Mockito.when((Object)this.sourceAdmin().listMirrors((ListMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)listMirrorsResult);
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(linkedTopics).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Mockito.when((Object)this.clientManager().currentConfig()).thenReturn((Object)this.config(this.includeAllFilter()));
        Node node = new Node(1, "localhost", 9092);
        TestAdminClient mockAdminClient = new TestAdminClient(node);
        mockAdminClient.addTopicOutOfBand(outOfBandTopic);
        Assertions.assertEquals((Object)scala.collection.immutable.Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{outOfBandTopic})), mockAdminClient.topics());
        new ClusterLinkAutoMirroring(this.clientManager(), this.metadataManager(), this.linkData(), (Function0 & Serializable)() -> mockAdminClient, this.metrics()).runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock(false);
        Assertions.assertEquals((Object)expectedTopicsAtEnd, mockAdminClient.topics());
        Assertions.assertFalse((boolean)mockAdminClient.deleteCalled());
    }

    @Test
    public void testSourceClusterCanContainMirrorTopicsReturnsFalse() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new UnsupportedVersionException("The broker does not support LIST_MIRRORS"));
        ListMirrorsResult result = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)result.result()).thenReturn((Object)future);
        Assertions.assertFalse((boolean)SourceCluster$.MODULE$.canContainMirrorTopics(this.metrics(), result.result()));
        ((ListMirrorsResult)Mockito.verify((Object)result)).result();
    }

    @Test
    public void testSourceClusterCanContainMirrorTopicsReturnsTrueDueToWrongErrorMessage() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new UnsupportedVersionException("The broker does not support LIST_MIRRORS with version..."));
        ListMirrorsResult result = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)result.result()).thenReturn((Object)future);
        Assertions.assertTrue((boolean)SourceCluster$.MODULE$.canContainMirrorTopics(this.metrics(), result.result()));
        ((ListMirrorsResult)Mockito.verify((Object)result)).result();
    }

    @Test
    public void testSourceClusterCanContainMirrorTopicsBasicClusterReturnsFalse() {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new ClusterLinkDisabledException("Cluster linking is disabled"));
        ListMirrorsResult result = (ListMirrorsResult)Mockito.mock(ListMirrorsResult.class);
        Mockito.when((Object)result.result()).thenReturn((Object)future);
        Assertions.assertFalse((boolean)SourceCluster$.MODULE$.canContainMirrorTopics(this.metrics(), result.result()));
        ((ListMirrorsResult)Mockito.verify((Object)result)).result();
    }

    @Test
    public void testFilterTopic() {
        new .colon.colon((Object)"", (List)new .colon.colon((Object)"src_", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)prefix -> {
            ClusterLinkAutoMirroringTest.$anonfun$testFilterTopic$1(prefix);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testFilterTopic$1(String prefix) {
        String topic = new StringBuilder(5).append(prefix).append("topic").toString();
        String confluentBalancerApiStateTopic = new StringBuilder(29).append(prefix).append("_confluent_balancer_api_state").toString();
        String schemaTopic = new StringBuilder(8).append(prefix).append("_schemas").toString();
        String auditLogEventsTopic = new StringBuilder(26).append(prefix).append("confluent-audit-log-events").toString();
        String ksqlProcessingLogEventsTopic = new StringBuilder(27).append(prefix).append("pksqlc-10j25-processing-log").toString();
        String fakeKsqlProcessingLogEventsTopic1 = new StringBuilder(14).append(prefix).append("pksqlc-a10nvvs").toString();
        String fakeKsqlProcessingLogEventsTopic2 = new StringBuilder(21).append(prefix).append("pksqlc-processing-log").toString();
        String fakeKsqlProcessingLogEventsTopic3 = new StringBuilder(12).append(prefix).append("mzxkn21l-log").toString();
        scala.collection.mutable.Map namesToListings = (scala.collection.mutable.Map)Map$.MODULE$.apply(((IterableOnceOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new TopicListing(topic, Uuid.fromString((String)"2Ew1y9BsQYCP6WVAzdKwPw"), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)schemaTopic), (Object)new TopicListing(schemaTopic, Uuid.fromString((String)"2Ew1y9BsQYCP6WVAzdKwPw"), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)auditLogEventsTopic), (Object)new TopicListing(auditLogEventsTopic, Uuid.fromString((String)"3ww2z11a0ABC7AAAzdzw0w"), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)confluentBalancerApiStateTopic), (Object)new TopicListing(confluentBalancerApiStateTopic, Uuid.fromString((String)"QOtODWOVSnufqbbXBMqitw"), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ksqlProcessingLogEventsTopic), (Object)new TopicListing(confluentBalancerApiStateTopic, Uuid.fromString((String)"U2U10zesDuLtb0lW1zOJxA"), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fakeKsqlProcessingLogEventsTopic1), (Object)new TopicListing(confluentBalancerApiStateTopic, Uuid.fromString((String)"kK5sMF0pRQzrv0xPCJNaBH"), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fakeKsqlProcessingLogEventsTopic2), (Object)new TopicListing(confluentBalancerApiStateTopic, Uuid.fromString((String)"kybFGBW7BfwmX3Dc9zAay5"), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fakeKsqlProcessingLogEventsTopic3), (Object)new TopicListing(confluentBalancerApiStateTopic, Uuid.fromString((String)"KBiRtzOcFvYOKrKSrQ9k5Z"), false))}))).toSeq());
        Assertions.assertFalse((boolean)ClusterLinkAutoMirroring$.MODULE$.filterTopic(namesToListings, prefix.length(), topic));
        Assertions.assertTrue((boolean)ClusterLinkAutoMirroring$.MODULE$.filterTopic(namesToListings, prefix.length(), confluentBalancerApiStateTopic));
        Assertions.assertTrue((boolean)ClusterLinkAutoMirroring$.MODULE$.filterTopic(namesToListings, prefix.length(), schemaTopic));
        Assertions.assertTrue((boolean)ClusterLinkAutoMirroring$.MODULE$.filterTopic(namesToListings, prefix.length(), auditLogEventsTopic));
        Assertions.assertTrue((boolean)ClusterLinkAutoMirroring$.MODULE$.filterTopic(namesToListings, prefix.length(), ksqlProcessingLogEventsTopic));
        Assertions.assertFalse((boolean)ClusterLinkAutoMirroring$.MODULE$.filterTopic(namesToListings, prefix.length(), fakeKsqlProcessingLogEventsTopic1));
        Assertions.assertFalse((boolean)ClusterLinkAutoMirroring$.MODULE$.filterTopic(namesToListings, prefix.length(), fakeKsqlProcessingLogEventsTopic2));
        Assertions.assertFalse((boolean)ClusterLinkAutoMirroring$.MODULE$.filterTopic(namesToListings, prefix.length(), fakeKsqlProcessingLogEventsTopic3));
    }

    public ClusterLinkAutoMirroringTest() {
        this.includeAllFilter = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"}]}";
    }

    public class TestAdminClient
    extends MockAdminClient {
        private scala.collection.immutable.Set<String> topics;
        private boolean deleteCalled;

        public scala.collection.immutable.Set<String> topics() {
            return this.topics;
        }

        public void topics_$eq(scala.collection.immutable.Set<String> x$1) {
            this.topics = x$1;
        }

        public boolean deleteCalled() {
            return this.deleteCalled;
        }

        public void deleteCalled_$eq(boolean x$1) {
            this.deleteCalled = x$1;
        }

        public CreateTopicsResult createTopics(Collection<NewTopic> newTopics, CreateTopicsOptions options) {
            scala.collection.immutable.Map results = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(newTopics).asScala().map((Function1 & Serializable)newTopic -> {
                KafkaFutureImpl future = new KafkaFutureImpl();
                if (this.topics().contains((Object)newTopic.name())) {
                    future.completeExceptionally((Throwable)new TopicExistsException("Topic already exists"));
                } else {
                    this.topics_$eq((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)this.topics().$plus((Object)newTopic.name())));
                    future.complete(null);
                }
                return new Tuple2((Object)newTopic.name(), (Object)future);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            CreateTopicsResult result = (CreateTopicsResult)Mockito.mock(CreateTopicsResult.class);
            Mockito.when((Object)result.values()).thenReturn((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)results).asJava());
            return result;
        }

        public DeleteTopicsResult deleteTopics(Collection<String> topics) {
            this.deleteCalled_$eq(true);
            topics.forEach(x -> topics.remove(x));
            return (DeleteTopicsResult)Mockito.mock(DeleteTopicsResult.class);
        }

        public void addTopicOutOfBand(String topic) {
            this.topics_$eq((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)this.topics().$plus((Object)topic)));
        }

        public /* synthetic */ ClusterLinkAutoMirroringTest kafka$server$link$ClusterLinkAutoMirroringTest$TestAdminClient$$$outer() {
            return ClusterLinkAutoMirroringTest.this;
        }

        public TestAdminClient(Node node) {
            if (ClusterLinkAutoMirroringTest.this == null) {
                throw null;
            }
            super(Collections.singletonList(node), node);
            this.topics = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            this.deleteCalled = false;
        }
    }
}

