/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.login.Configuration;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConfigDefaults$;
import kafka.server.link.ClusterLinkTestUtils$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.GroupFilterJson;
import kafka.server.link.TopicFilterJson;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001\u0002\u000f\u001e\u0001\u0011BQa\u000b\u0001\u0005\u00021Bqa\f\u0001C\u0002\u0013%\u0001\u0007\u0003\u0004=\u0001\u0001\u0006I!\r\u0005\b{\u0001\u0011\r\u0011\"\u00031\u0011\u0019q\u0004\u0001)A\u0005c!9q\b\u0001b\u0001\n\u0013\u0001\u0005B\u0002%\u0001A\u0003%\u0011\tC\u0004J\u0001\t\u0007I\u0011\u0002&\t\rY\u0003\u0001\u0015!\u0003L\u0011\u001d9\u0006A1A\u0005\n\u0001Ca\u0001\u0017\u0001!\u0002\u0013\t\u0005bB-\u0001\u0005\u0004%I\u0001\u0011\u0005\u00075\u0002\u0001\u000b\u0011B!\t\u000bm\u0003A\u0011\u0001/\t\u000b-\u0004A\u0011\u0001/\t\u000bA\u0004A\u0011\u0001/\t\u000bI\u0004A\u0011\u0001/\t\u000bQ\u0004A\u0011\u0001/\t\u000bY\u0004A\u0011\u0001/\t\u000ba\u0004A\u0011\u0001/\t\u000bi\u0004A\u0011\u0001/\t\u000bq\u0004A\u0011\u0001/\t\u000by\u0004A\u0011\u0001/\t\r\u0005\u0005\u0001\u0001\"\u0001]\u0011\u0019\t)\u0001\u0001C\u00019\"1\u0011\u0011\u0002\u0001\u0005\u0002qCq!!\u0004\u0001\t\u0013\tyAA\u000bDYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e$Vm\u001d;\u000b\u0005yy\u0012\u0001\u00027j].T!\u0001I\u0011\u0002\rM,'O^3s\u0015\u0005\u0011\u0013!B6bM.\f7\u0001A\n\u0003\u0001\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001.!\tq\u0003!D\u0001\u001e\u0003%\t7\r\u001c$jYR,'/F\u00012!\t\u0011\u0014H\u0004\u00024oA\u0011AgJ\u0007\u0002k)\u0011agI\u0001\u0007yI|w\u000e\u001e \n\u0005a:\u0013A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001O\u0014\u0002\u0015\u0005\u001cGNR5mi\u0016\u0014\b%A\u0006he>,\bOR5mi\u0016\u0014\u0018\u0001D4s_V\u0004h)\u001b7uKJ\u0004\u0013a\u0003;pa&\u001cg)\u001b7uKJ,\u0012!\u0011\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000bA\u0001\\1oO*\ta)\u0001\u0003kCZ\f\u0017B\u0001\u001eD\u00031!x\u000e]5d\r&dG/\u001a:!\u0003MIg\u000e^3s\u0005J|7.\u001a:MSN$XM\\3s+\u0005Y\u0005C\u0001'U\u001b\u0005i%B\u0001(P\u0003\u0019\u0019w.\\7p]*\u0011!\u0005\u0015\u0006\u0003#J\u000ba!\u00199bG\",'\"A*\u0002\u0007=\u0014x-\u0003\u0002V\u001b\nAQI\u001c3q_&tG/\u0001\u000bj]R,'O\u0011:pW\u0016\u0014H*[:uK:,'\u000fI\u0001\u000bEJ|7.\u001a:KC\u0006\u001c\u0018a\u00032s_.,'OS1bg\u0002\n!b\u00197jK:$(*Y1t\u0003-\u0019G.[3oi*\u000b\u0017m\u001d\u0011\u0002\u0011Q,\u0017M\u001d#po:$\u0012!\u0018\t\u0003MyK!aX\u0014\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u001d\u0005\u0004\"AY5\u000e\u0003\rT!\u0001Z3\u0002\u0007\u0005\u0004\u0018N\u0003\u0002gO\u00069!.\u001e9ji\u0016\u0014(B\u00015S\u0003\u0015QWO\\5u\u0013\tQ7MA\u0005BMR,'/R1dQ\u0006!B/Z:u\u0007>tg-[4DCR,wm\u001c:jKND#aD7\u0011\u0005\tt\u0017BA8d\u0005\u0011!Vm\u001d;\u0002\u0019Q,7\u000f\u001e#fM\u0006,H\u000e^:)\u0005Ai\u0017A\u0005;fgRl\u0015n\u001a:bi&|g\u000e\u0015:paND#!E7\u0002\u001dQ,7\u000f^(gMN,Go\u00159fG\"\u0012!#\\\u0001\u001di\u0016\u001cHOV1mS\u0012\u001cE.^:uKJd\u0015N\\6Qe\u00164\u0017\u000e_3tQ\t\u0019R.\u0001\u0010uKN$\u0018J\u001c<bY&$7\t\\;ti\u0016\u0014H*\u001b8l!J,g-\u001b=fg\"\u0012A#\\\u0001&i\u0016\u001cHo\u00117vgR,'\u000fT5oWB\u0013XMZ5y\u0003:$\u0017i\u00197Ts:\u001c7i\\7c_ND#!F7\u0002{Q,7\u000f^\"mkN$XM\u001d'j].\u001cuN\\:v[\u0016\u0014xI]8vaB\u0013XMZ5y\u0003:$')\u001b3je\u0016\u001cG/[8oC2d\u0015N\\6J]Z\fG.\u001b3)\u0005Yi\u0017\u0001\b;fgR\u001c\u0016m\u001d7KC\u0006\u001c8i\u001c8gS\u001e4\u0016\r\\5eCRLwN\u001c\u0015\u0003/5\fa\u0002^3ti*\u001bxN\u001c$jYR,'\u000f\u000b\u0002\u0019[\u0006aB/Z:u\u0013:$XM\u001d\"s_.,'o\u00117jK:$8i\u001c8gS\u001e\u001c\bFA\rn\u0003}!Xm\u001d;J]R,'O\u0011:pW\u0016\u00148\t\\5f]R\u001c6\u000f\\\"p]\u001aLwm\u001d\u0015\u000355\f1C^3sS\u001aL8\t\\5f]R\u001cuN\u001c4jON$r!XA\t\u0003C\t)\u0003C\u0004\u0002\u0014m\u0001\r!!\u0006\u0002\u001b\t\u0014xn[3s\u0007>tg-[4t!\u0019\t9\"!\b2K5\u0011\u0011\u0011\u0004\u0006\u0004\u00037)\u0015\u0001B;uS2LA!a\b\u0002\u001a\t\u0019Q*\u00199\t\u000f\u0005\r2\u00041\u0001\u0002\u0016\u0005y1\r\\5f]R|e/\u001a:sS\u0012,7\u000fC\u0004\u0002(m\u0001\r!!\u0006\u0002\u001f\u0015D\b/Z2uK\u0012\u001cuN\u001c4jON\u0004")
public class ClusterLinkConfigTest {
    private final String aclFilter = ClusterLinkTestUtils$.MODULE$.AllAclsFilter();
    private final String groupFilter = ClusterLinkTestUtils$.MODULE$.AllGroupsFilter();
    private final String topicFilter = ClusterLinkTestUtils$.MODULE$.AllTopicsFilter();
    private final Endpoint interBrokerListener = new Endpoint("EXTERNAL", SecurityProtocol.SASL_SSL, "source.external", 9092);
    private final String brokerJaas;
    private final String clientJaas;

    private String aclFilter() {
        return this.aclFilter;
    }

    private String groupFilter() {
        return this.groupFilter;
    }

    private String topicFilter() {
        return this.topicFilter;
    }

    private Endpoint interBrokerListener() {
        return this.interBrokerListener;
    }

    private String brokerJaas() {
        return this.brokerJaas;
    }

    private String clientJaas() {
        return this.clientJaas;
    }

    @AfterEach
    public void tearDown() {
        Configuration.setConfiguration(null);
    }

    @Test
    public void testConfigCategories() {
        Set allProps = ClusterLinkConfig$.MODULE$.configNames().toSet();
        Set replicationProps = ClusterLinkConfig$.MODULE$.ReplicationProps();
        Set migrationProps = ClusterLinkConfig$.MODULE$.PeriodicTaskProps();
        Set replicationAndMigrationProps = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()}));
        Set linkProps = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.LinkModeProp(), ClusterLinkConfig$.MODULE$.ConnectionModeProp(), ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp(), ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), ClusterLinkConfig$.MODULE$.ConsumerGroupPrefixEnableProp(), ClusterLinkConfig$.MODULE$.RemoteLinkConnectionModeProp(), ClusterLinkConfig$.MODULE$.MirrorStartOffsetSpecProp()}));
        Set reverseConnectionProps = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.LocalListenerNameProp(), ClusterLinkConfig$.MODULE$.ReverseConnectionSetupTimeoutMsProp()}));
        Set notCategorizedProps = (Set)allProps.$minus$minus((IterableOnce)replicationProps).$minus$minus((IterableOnce)migrationProps).$minus$minus((IterableOnce)replicationAndMigrationProps).$minus$minus((IterableOnce)linkProps).$minus$minus((IterableOnce)reverseConnectionProps).$minus$minus((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(AdminClientConfig.configNames()).asScala()).$minus$minus((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(AdminClientConfig.configNames()).asScala().map((Function1 & Serializable)configName -> new StringBuilder(0).append(ClusterLinkConfig$.MODULE$.LocalPrefix()).append((String)configName).toString()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)notCategorizedProps);
    }

    @Test
    public void testDefaults() {
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:1234");
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, true);
        Assertions.assertEquals((Object)ClusterLinkConfig.LinkMode.DESTINATION, (Object)linkConfig.linkMode());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.NumClusterLinkFetchers(), (Integer)linkConfig.numClusterLinkFetchers());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.ReplicaFetchMaxBytes(), (Integer)linkConfig.replicaFetchMaxBytes());
        Assertions.assertEquals((long)ClusterLinkConfigDefaults$.MODULE$.RetryBackoffMs(), (Long)linkConfig.metadataRefreshBackoffMs());
        Assertions.assertEquals((long)ClusterLinkConfigDefaults$.MODULE$.MetadataMaxAgeMs(), (Long)linkConfig.metadataMaxAgeMs());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.ReverseConnectionSetupTimeoutMs(), (Integer)linkConfig.reverseConnectionSetupTimeoutMs());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.RetryTimeoutMs(), (int)linkConfig.retryTimeoutMs());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.OffsetSyncMsDefault(), (Integer)linkConfig.consumerOffsetSyncMs());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.AclSyncMsDefault(), (Integer)linkConfig.aclSyncMs());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.TopicConfigSyncMsDefault(), (Integer)linkConfig.topicConfigSyncMs());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.AvailabilityCheckMsDefault(), (Integer)linkConfig.availabilityCheckMs());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)ClusterLinkConfigDefaults$.MODULE$.ConsumerGroupPrefixEnableDefault()));
    }

    @Test
    public void testMigrationProps() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:1234");
        props.setProperty(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), "true");
        props.setProperty(ClusterLinkConfig$.MODULE$.TopicFiltersProp(), this.topicFilter());
        props.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        props.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.groupFilter());
        props.setProperty(ClusterLinkConfig$.MODULE$.AclSyncEnableProp(), "true");
        props.setProperty(ClusterLinkConfig$.MODULE$.AclFiltersProp(), this.aclFilter());
        ClusterLinkConfig destLinkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, true);
        Assertions.assertTrue((boolean)destLinkConfig.autoMirroringEnable());
        Assertions.assertTrue((boolean)destLinkConfig.consumerOffsetSyncEnable());
        Assertions.assertTrue((boolean)destLinkConfig.aclSyncEnable());
        Assertions.assertNotEquals((Object)Option$.MODULE$.empty(), (Object)destLinkConfig.topicFilters());
        Assertions.assertNotEquals((Object)Option$.MODULE$.empty(), (Object)destLinkConfig.consumerGroupFilters());
        Assertions.assertNotEquals((Object)Option$.MODULE$.empty(), (Object)destLinkConfig.aclFilters());
        props.setProperty(ClusterLinkConfig$.MODULE$.LinkModeProp(), ClusterLinkConfig.LinkMode.SOURCE.name());
        ClusterLinkConfig sourceLinkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, true);
        Assertions.assertFalse((boolean)sourceLinkConfig.autoMirroringEnable());
        Assertions.assertFalse((boolean)sourceLinkConfig.consumerOffsetSyncEnable());
        Assertions.assertFalse((boolean)sourceLinkConfig.aclSyncEnable());
        Assertions.assertEquals((Object)Option$.MODULE$.empty(), (Object)sourceLinkConfig.topicFilters());
        Assertions.assertEquals((Object)Option$.MODULE$.empty(), (Object)sourceLinkConfig.consumerGroupFilters());
        Assertions.assertEquals((Object)Option$.MODULE$.empty(), (Object)sourceLinkConfig.aclFilters());
    }

    @Test
    public void testOffsetSpec() {
        Properties props = new Properties();
        ClusterLinkConfigTest.verifyOffsetSpec$1((OffsetSpec)new OffsetSpec.EarliestSpec(), (Option)None$.MODULE$, props);
        props.setProperty(ClusterLinkConfig$.MODULE$.MirrorStartOffsetSpecProp(), "earliest");
        ClusterLinkConfigTest.verifyOffsetSpec$1((OffsetSpec)new OffsetSpec.EarliestSpec(), (Option)None$.MODULE$, props);
        props.setProperty(ClusterLinkConfig$.MODULE$.MirrorStartOffsetSpecProp(), "latest");
        ClusterLinkConfigTest.verifyOffsetSpec$1((OffsetSpec)new OffsetSpec.LatestSpec(), (Option)None$.MODULE$, props);
        long timestamp = System.currentTimeMillis();
        props.setProperty(ClusterLinkConfig$.MODULE$.MirrorStartOffsetSpecProp(), TestUtils$.MODULE$.dateTime(timestamp));
        ClusterLinkConfigTest.verifyOffsetSpec$1(OffsetSpec.forTimestamp((long)timestamp), (Option)new Some((Object)BoxesRunTime.boxToLong((long)timestamp)), props);
        props.setProperty(ClusterLinkConfig$.MODULE$.MirrorStartOffsetSpecProp(), "max_timestamp");
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ClusterLinkConfig$.MODULE$.create((Map)props, true).mirrorStartOffsetSpec());
        props.setProperty(ClusterLinkConfig$.MODULE$.MirrorStartOffsetSpecProp(), "12:30");
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ClusterLinkConfig$.MODULE$.create((Map)props, true).mirrorStartOffsetSpec());
    }

    @Test
    public void testValidClusterLinkPrefixes() {
        Properties props = new Properties();
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "");
        ClusterLinkConfig$.MODULE$.create((Map)props, true);
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "ABYZ.cx-019_");
        ClusterLinkConfig$.MODULE$.create((Map)props, true);
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "...");
        ClusterLinkConfig$.MODULE$.create((Map)props, true);
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "_.-_");
        ClusterLinkConfig$.MODULE$.create((Map)props, true);
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0123"), 3));
        ClusterLinkConfig$.MODULE$.create((Map)props, true);
    }

    @Test
    public void testInvalidClusterLinkPrefixes() {
        Properties props = new Properties();
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "test/link_");
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkConfig$.MODULE$.create((Map)props, true), ClassTag$.MODULE$.apply(InvalidConfigurationException.class), new Position("ClusterLinkConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "test:link_");
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkConfig$.MODULE$.create((Map)props, true), ClassTag$.MODULE$.apply(InvalidConfigurationException.class), new Position("ClusterLinkConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "test\\\\link_");
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkConfig$.MODULE$.create((Map)props, true), ClassTag$.MODULE$.apply(InvalidConfigurationException.class), new Position("ClusterLinkConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "test\\nlink_");
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkConfig$.MODULE$.create((Map)props, true), ClassTag$.MODULE$.apply(InvalidConfigurationException.class), new Position("ClusterLinkConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "test\\tlink");
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkConfig$.MODULE$.create((Map)props, true), ClassTag$.MODULE$.apply(InvalidConfigurationException.class), new Position("ClusterLinkConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0123456789_"), 30));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkConfig$.MODULE$.create((Map)props, true), ClassTag$.MODULE$.apply(InvalidConfigurationException.class), new Position("ClusterLinkConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
    }

    @Test
    public void testClusterLinkPrefixAndAclSyncCombos() {
        Properties props = new Properties();
        props.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "prefix");
        props.setProperty(ClusterLinkConfig$.MODULE$.AclSyncEnableProp(), "true");
        String aclFilter = ClusterLinkTestUtils$.MODULE$.AllAclsFilter();
        props.setProperty(ClusterLinkConfig$.MODULE$.AclFiltersProp(), aclFilter);
        InvalidConfigurationException e = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> ClusterLinkConfig$.MODULE$.create((Map)props, true));
        Assertions.assertTrue((boolean)e.getMessage().contains("Cluster link prefixing and ACL syncing cannot be enabled at the same time."), (String)new StringBuilder(26).append("Unexpected error message: ").append(e.getMessage()).toString());
        Properties propsTwo = new Properties();
        propsTwo.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "prefix");
        ClusterLinkConfig$.MODULE$.create((Map)propsTwo, true);
        Properties propsThree = new Properties();
        propsThree.setProperty(ClusterLinkConfig$.MODULE$.AclSyncEnableProp(), "true");
        propsThree.setProperty(ClusterLinkConfig$.MODULE$.AclFiltersProp(), aclFilter);
        ClusterLinkConfig$.MODULE$.create((Map)propsThree, true);
    }

    @Test
    public void testClusterLinkConsumerGroupPrefixAndBidirectionalLinkInvalid() {
        Properties invalidProps = new Properties();
        invalidProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "prefix");
        invalidProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerGroupPrefixEnableProp(), "true");
        invalidProps.setProperty(ClusterLinkConfig$.MODULE$.LinkModeProp(), ClusterLinkConfig.LinkMode.BIDIRECTIONAL.name());
        InvalidConfigurationException e = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> ClusterLinkConfig$.MODULE$.create((Map)invalidProps, true));
        Assertions.assertTrue((boolean)e.getMessage().contains("Consumer group prefixing cannot be enabled for bidirectional links."), (String)new StringBuilder(26).append("Unexpected error message: ").append(e.getMessage()).toString());
        Properties validProps = new Properties();
        validProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), "prefix");
        invalidProps.setProperty(ClusterLinkConfig$.MODULE$.LinkModeProp(), ClusterLinkConfig.LinkMode.BIDIRECTIONAL.name());
        ClusterLinkConfig$.MODULE$.create((Map)validProps, true);
    }

    @Test
    public void testSaslJaasConfigValidation() {
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:1234");
        Set saslProtocols = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SecurityProtocol[]{SecurityProtocol.SASL_PLAINTEXT, SecurityProtocol.SASL_SSL}));
        Set nonSaslProtocols = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SecurityProtocol[]{SecurityProtocol.PLAINTEXT, SecurityProtocol.SSL}));
        ClusterLinkConfigTest.verifyValidSaslJaasConfig$1(props, saslProtocols, nonSaslProtocols);
        props.setProperty("sasl.jaas.config", "test.LoginModule required;");
        ClusterLinkConfigTest.verifyValidSaslJaasConfig$1(props, saslProtocols, nonSaslProtocols);
        props.setProperty("sasl.jaas.config", "invalid secret");
        ClusterLinkConfigTest.verifyInvalidSaslJaasConfig$1("Invalid JAAS configuration", props, saslProtocols, nonSaslProtocols);
        props.setProperty("sasl.jaas.config", "${secretprovider:test}");
        ClusterLinkConfigTest.verifyInvalidSaslJaasConfig$1("Ensure that config provider list and provider class are configured in the cluster link configuration", props, saslProtocols, nonSaslProtocols);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testJsonFilter() {
        void verifyFilter$1_validFilter;
        void verifyFilter$1_filterConfig;
        void verifyFilter$1_validFilter2;
        void verifyFilter$1_filterConfig2;
        void verifyFilter$1_validFilter3;
        String string = this.groupFilter();
        String verifyFilter$1_filterConfig3 = ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp();
        String verifyFilter$1_enableConfig = ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp();
        Properties verifyFilter$1_props = new Properties();
        verifyFilter$1_props.setProperty("bootstrap.servers", "localhost:1234");
        verifyFilter$1_props.setProperty(verifyFilter$1_filterConfig3, (String)verifyFilter$1_validFilter3);
        Some verifyFilter$1_verifySuccess$1_size = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        verifyFilter$1_props.setProperty(verifyFilter$1_enableConfig, "true");
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, true)));
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, false)));
        verifyFilter$1_props.setProperty(verifyFilter$1_enableConfig, "false");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, true)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, false)));
        verifyFilter$1_props.remove(verifyFilter$1_enableConfig);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, true)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, false)));
        Object var5_5 = null;
        verifyFilter$1_props.setProperty(verifyFilter$1_filterConfig3, "{");
        ClusterLinkConfigTest.verifyFailure$1(verifyFilter$1_props, verifyFilter$1_enableConfig);
        verifyFilter$1_props.remove(verifyFilter$1_filterConfig3);
        None$ verifyFilter$1_verifySuccess$1_size2 = None$.MODULE$;
        verifyFilter$1_props.setProperty(verifyFilter$1_enableConfig, "true");
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size2, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, true)));
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size2, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, false)));
        verifyFilter$1_props.setProperty(verifyFilter$1_enableConfig, "false");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, true)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, false)));
        verifyFilter$1_props.remove(verifyFilter$1_enableConfig);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, true)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.groupFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props, false)));
        Object var6_6 = null;
        Object var1_3 = null;
        Object var2_2 = null;
        string = null;
        Object var4_4 = null;
        String string2 = this.topicFilter();
        String string3 = ClusterLinkConfig$.MODULE$.TopicFiltersProp();
        String verifyFilter$1_enableConfig2 = ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp();
        Properties verifyFilter$1_props2 = new Properties();
        verifyFilter$1_props2.setProperty("bootstrap.servers", "localhost:1234");
        verifyFilter$1_props2.setProperty((String)verifyFilter$1_filterConfig2, (String)verifyFilter$1_validFilter2);
        Some verifyFilter$1_verifySuccess$1_size3 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        verifyFilter$1_props2.setProperty(verifyFilter$1_enableConfig2, "true");
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size3, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, true)));
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size3, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, false)));
        verifyFilter$1_props2.setProperty(verifyFilter$1_enableConfig2, "false");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, true)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, false)));
        verifyFilter$1_props2.remove(verifyFilter$1_enableConfig2);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, true)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, false)));
        Object var11_11 = null;
        verifyFilter$1_props2.setProperty((String)verifyFilter$1_filterConfig2, "{");
        ClusterLinkConfigTest.verifyFailure$1(verifyFilter$1_props2, verifyFilter$1_enableConfig2);
        verifyFilter$1_props2.remove(verifyFilter$1_filterConfig2);
        None$ verifyFilter$1_verifySuccess$1_size4 = None$.MODULE$;
        verifyFilter$1_props2.setProperty(verifyFilter$1_enableConfig2, "true");
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size4, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, true)));
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size4, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, false)));
        verifyFilter$1_props2.setProperty(verifyFilter$1_enableConfig2, "false");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, true)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, false)));
        verifyFilter$1_props2.remove(verifyFilter$1_enableConfig2);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, true)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.topicFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props2, false)));
        Object var12_12 = null;
        Object var7_9 = null;
        string3 = null;
        string2 = null;
        Object var10_10 = null;
        String string4 = this.aclFilter();
        String string5 = ClusterLinkConfig$.MODULE$.AclFiltersProp();
        String verifyFilter$1_enableConfig3 = ClusterLinkConfig$.MODULE$.AclSyncEnableProp();
        Properties verifyFilter$1_props3 = new Properties();
        verifyFilter$1_props3.setProperty("bootstrap.servers", "localhost:1234");
        verifyFilter$1_props3.setProperty((String)verifyFilter$1_filterConfig, (String)verifyFilter$1_validFilter);
        Some verifyFilter$1_verifySuccess$1_size5 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        verifyFilter$1_props3.setProperty(verifyFilter$1_enableConfig3, "true");
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size5, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, true)));
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size5, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, false)));
        verifyFilter$1_props3.setProperty(verifyFilter$1_enableConfig3, "false");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, true)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, false)));
        verifyFilter$1_props3.remove(verifyFilter$1_enableConfig3);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, true)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, false)));
        Object var17_17 = null;
        verifyFilter$1_props3.setProperty((String)verifyFilter$1_filterConfig, "{");
        ClusterLinkConfigTest.verifyFailure$1(verifyFilter$1_props3, verifyFilter$1_enableConfig3);
        verifyFilter$1_props3.remove(verifyFilter$1_filterConfig);
        None$ verifyFilter$1_verifySuccess$1_size6 = None$.MODULE$;
        verifyFilter$1_props3.setProperty(verifyFilter$1_enableConfig3, "true");
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size6, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, true)));
        Assertions.assertEquals((Object)verifyFilter$1_verifySuccess$1_size6, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, false)));
        verifyFilter$1_props3.setProperty(verifyFilter$1_enableConfig3, "false");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, true)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, false)));
        verifyFilter$1_props3.remove(verifyFilter$1_enableConfig3);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, true)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkConfigTest.aclFilterSize$1(ClusterLinkConfig$.MODULE$.create((Map)verifyFilter$1_props3, false)));
    }

    @Test
    public void testInterBrokerClientConfigs() {
        HashMap<String, Object> brokerConfigs = new HashMap<String, Object>();
        brokerConfigs.put("security.protocol", "SASL_PLAINTEXT");
        brokerConfigs.put("sasl.mechanism", "PLAIN");
        brokerConfigs.put("sasl.jaas.config", this.brokerJaas());
        brokerConfigs.put("sasl.mechanism.inter.broker.protocol", "OAUTHBEARER");
        brokerConfigs.put("confluent.broker.clients.ssl.file.store.reload.enable", "true");
        HashMap<String, Object> clientOverrides = new HashMap<String, Object>();
        clientOverrides.put(new StringBuilder(17).append(ClusterLinkConfig$.MODULE$.LocalPrefix()).append("bootstrap.servers").toString(), "localhost:9092");
        HashMap<String, Object> expectedConfigs = new HashMap<String, Object>();
        expectedConfigs.put("security.protocol", "SASL_SSL");
        expectedConfigs.put("sasl.mechanism", "OAUTHBEARER");
        expectedConfigs.put("sasl.jaas.config", this.brokerJaas());
        expectedConfigs.put("bootstrap.servers", "localhost:9092");
        expectedConfigs.put("confluent.ssl.enable.dynamic.store.update", "true");
        expectedConfigs.put("confluent.broker.clients.ssl.file.store.reload.enable", "true");
        this.verifyClientConfigs(brokerConfigs, clientOverrides, expectedConfigs);
        clientOverrides.put(new StringBuilder(16).append(ClusterLinkConfig$.MODULE$.LocalPrefix()).append("sasl.jaas.config").toString(), this.clientJaas());
        clientOverrides.put(new StringBuilder(14).append(ClusterLinkConfig$.MODULE$.LocalPrefix()).append("sasl.mechanism").toString(), "SCRAM-SHA-256");
        expectedConfigs.put("sasl.jaas.config", this.clientJaas());
        expectedConfigs.put("sasl.mechanism", "SCRAM-SHA-256");
        this.verifyClientConfigs(brokerConfigs, clientOverrides, expectedConfigs);
        brokerConfigs.remove("sasl.mechanism.inter.broker.protocol");
        clientOverrides.remove(new StringBuilder(14).append(ClusterLinkConfig$.MODULE$.LocalPrefix()).append("sasl.mechanism").toString());
        expectedConfigs.put("sasl.mechanism", "GSSAPI");
        this.verifyClientConfigs(brokerConfigs, clientOverrides, expectedConfigs);
    }

    @Test
    public void testInterBrokerClientSslConfigs() {
        HashMap<String, Object> brokerConfigs = new HashMap<String, Object>();
        brokerConfigs.put("sasl.jaas.config", this.brokerJaas());
        brokerConfigs.put("sasl.mechanism.inter.broker.protocol", "PLAIN");
        brokerConfigs.put("ssl.keystore.location", "/tmp/keystore.p12");
        brokerConfigs.put("ssl.keystore.password", "keystore-password");
        brokerConfigs.put("ssl.key.password", "key-password");
        brokerConfigs.put("ssl.keystore.type", "PKCS12");
        brokerConfigs.put("ssl.truststore.location", "/tmp/truststore.p12");
        brokerConfigs.put("ssl.truststore.password", "truststore-password");
        brokerConfigs.put("ssl.truststore.type", "PKCS12");
        brokerConfigs.put("confluent.broker.clients.ssl.file.store.reload.enable", "true");
        HashMap<String, Object> clientOverrides = new HashMap<String, Object>();
        HashMap<String, Object> expectedConfigs = new HashMap<String, Object>(brokerConfigs);
        expectedConfigs.remove("sasl.mechanism.inter.broker.protocol");
        expectedConfigs.put("bootstrap.servers", "source.external:9092");
        expectedConfigs.put("security.protocol", "SASL_SSL");
        expectedConfigs.put("sasl.mechanism", "PLAIN");
        expectedConfigs.put("confluent.ssl.enable.dynamic.store.update", "true");
        this.verifyClientConfigs(brokerConfigs, clientOverrides, expectedConfigs);
        brokerConfigs.remove("ssl.truststore.type");
        expectedConfigs.remove("ssl.truststore.type");
        this.verifyClientConfigs(brokerConfigs, clientOverrides, expectedConfigs);
        brokerConfigs.put("ssl.truststore.type", "PKCS12");
        clientOverrides.put(new StringBuilder(19).append(ClusterLinkConfig$.MODULE$.LocalPrefix()).append("ssl.truststore.type").toString(), "PKCS12");
        expectedConfigs.put("ssl.truststore.type", "PKCS12");
        this.verifyClientConfigs(brokerConfigs, clientOverrides, expectedConfigs);
        brokerConfigs.put("ssl.truststore.certificates", "certs");
        clientOverrides.put(new StringBuilder(19).append(ClusterLinkConfig$.MODULE$.LocalPrefix()).append("ssl.truststore.type").toString(), "PEM");
        expectedConfigs.put("ssl.truststore.type", "PEM");
        expectedConfigs.remove("ssl.truststore.location");
        expectedConfigs.remove("ssl.truststore.password");
        this.verifyClientConfigs(brokerConfigs, clientOverrides, expectedConfigs);
        clientOverrides.put(new StringBuilder(30).append(ClusterLinkConfig$.MODULE$.LocalPrefix()).append("ssl.keystore.certificate.chain").toString(), "certs");
        expectedConfigs.put("ssl.keystore.certificate.chain", "certs");
        expectedConfigs.remove("ssl.keystore.location");
        expectedConfigs.remove("ssl.keystore.password");
        expectedConfigs.remove("ssl.key.password");
        expectedConfigs.remove("ssl.keystore.type");
        this.verifyClientConfigs(brokerConfigs, clientOverrides, expectedConfigs);
        clientOverrides.put(new StringBuilder(16).append(ClusterLinkConfig$.MODULE$.LocalPrefix()).append("ssl.keystore.key").toString(), "key");
        expectedConfigs.put("ssl.keystore.key", "key");
        clientOverrides.put(new StringBuilder(17).append(ClusterLinkConfig$.MODULE$.LocalPrefix()).append("ssl.keystore.type").toString(), "PEM");
        expectedConfigs.put("ssl.keystore.type", "PEM");
        this.verifyClientConfigs(brokerConfigs, clientOverrides, expectedConfigs);
    }

    private void verifyClientConfigs(Map<String, Object> brokerConfigs, Map<String, Object> clientOverrides, Map<String, Object> expectedConfigs) {
        Properties props = new Properties();
        props.put("bootstrap.servers", "destination:1234");
        props.putAll(clientOverrides);
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)props, true);
        Properties brokerProps = new Properties();
        brokerProps.put(KafkaConfig$.MODULE$.ZkConnectProp(), "zookeeper:2181");
        brokerProps.putAll(brokerConfigs);
        KafkaConfig brokerConfig = new KafkaConfig((Map)brokerProps);
        HashMap<String, Object> parsedBrokerConfigs = new HashMap<String, Object>(brokerConfigs);
        String jaasConfig = (String)brokerConfigs.get("sasl.jaas.config");
        if (jaasConfig != null) {
            parsedBrokerConfigs.put("sasl.jaas.config", new Password(jaasConfig));
        }
        HashMap<String, Object> expectedClientConfigs = new HashMap<String, Object>(expectedConfigs);
        Assertions.assertEquals(expectedClientConfigs, (Object)linkConfig.localLinkClientConfigs(brokerConfig, this.interBrokerListener(), false));
        expectedClientConfigs.put("bootstrap.servers", "source.external:9092");
        expectedClientConfigs.put("security.protocol", "SASL_SSL");
        Assertions.assertEquals(expectedClientConfigs, (Object)linkConfig.localLinkClientConfigs(brokerConfig, this.interBrokerListener(), true));
    }

    private static final void verifyOffsetSpec$1(OffsetSpec expectedSpec, Option expectedTimestamp, Properties props$1) {
        OffsetSpec actualSpec = ClusterLinkConfig$.MODULE$.create((Map)props$1, true).mirrorStartOffsetSpec();
        Assertions.assertEquals((Object)expectedSpec.getClass(), (Object)actualSpec.getClass());
        expectedTimestamp.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)timestamp -> Assertions.assertEquals((long)timestamp, (long)BoxesRunTime.unboxToLong((Object)TestUtils.fieldValue((Object)actualSpec, OffsetSpec.TimestampSpec.class, (String)"timestamp"))));
    }

    private static final Option verifyOffsetSpec$default$2$1() {
        return None$.MODULE$;
    }

    private static final void verifyValidationSucceeds$1(Set protocols, Properties props$4) {
        protocols.foreach((Function1 & Serializable)protocol -> {
            props$4.setProperty("security.protocol", protocol.name);
            return ClusterLinkConfig$.MODULE$.create((Map)props$4, true);
        });
    }

    public static final /* synthetic */ void $anonfun$testSaslJaasConfigValidation$2(Properties props$4, String message$1, SecurityProtocol protocol) {
        props$4.setProperty("security.protocol", protocol.name);
        InvalidConfigurationException e = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> ClusterLinkConfig$.MODULE$.create((Map)props$4, true));
        Assertions.assertTrue((boolean)e.getMessage().contains(message$1), (String)new StringBuilder(26).append("Unexpected error message: ").append(e.getMessage()).toString());
        Assertions.assertFalse((boolean)e.getMessage().contains("secret"), (String)new StringBuilder(41).append("Sensitive data exposed in error message: ").append(e.getMessage()).toString());
    }

    private static final void verifyValidationFails$1(Set protocols, String message, Properties props$4) {
        protocols.foreach((Function1 & Serializable)protocol -> {
            ClusterLinkConfigTest.$anonfun$testSaslJaasConfigValidation$2(props$4, message, protocol);
            return BoxedUnit.UNIT;
        });
    }

    private static final void verifyValidSaslJaasConfig$1(Properties props$4, Set saslProtocols$1, Set nonSaslProtocols$1) {
        props$4.setProperty(ClusterLinkConfig$.MODULE$.ConnectionModeProp(), ConnectionMode.Inbound$.MODULE$.name());
        ClusterLinkConfigTest.verifyValidationSucceeds$1((Set)saslProtocols$1.$plus$plus((IterableOnce)nonSaslProtocols$1), props$4);
        props$4.setProperty(ClusterLinkConfig$.MODULE$.ConnectionModeProp(), ConnectionMode.Outbound$.MODULE$.name());
        ClusterLinkConfigTest.verifyValidationSucceeds$1((Set)saslProtocols$1.$plus$plus((IterableOnce)nonSaslProtocols$1), props$4);
        props$4.remove(ClusterLinkConfig$.MODULE$.ConnectionModeProp());
        ClusterLinkConfigTest.verifyValidationSucceeds$1((Set)saslProtocols$1.$plus$plus((IterableOnce)nonSaslProtocols$1), props$4);
    }

    private static final void verifyInvalidSaslJaasConfig$1(String message, Properties props$4, Set saslProtocols$1, Set nonSaslProtocols$1) {
        props$4.setProperty(ClusterLinkConfig$.MODULE$.ConnectionModeProp(), ConnectionMode.Inbound$.MODULE$.name());
        ClusterLinkConfigTest.verifyValidationSucceeds$1((Set)saslProtocols$1.$plus$plus((IterableOnce)nonSaslProtocols$1), props$4);
        props$4.setProperty(ClusterLinkConfig$.MODULE$.ConnectionModeProp(), ConnectionMode.Outbound$.MODULE$.name());
        ClusterLinkConfigTest.verifyValidationSucceeds$1(nonSaslProtocols$1, props$4);
        ClusterLinkConfigTest.verifyValidationFails$1(saslProtocols$1, message, props$4);
        props$4.remove(ClusterLinkConfig$.MODULE$.ConnectionModeProp());
        ClusterLinkConfigTest.verifyValidationSucceeds$1(nonSaslProtocols$1, props$4);
        ClusterLinkConfigTest.verifyValidationFails$1(saslProtocols$1, message, props$4);
    }

    public static final /* synthetic */ int $anonfun$testJsonFilter$1(GroupFilterJson x$1) {
        return x$1.filters().size();
    }

    private static final Option groupFilterSize$1(ClusterLinkConfig config) {
        return config.consumerGroupFilters().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ClusterLinkConfigTest.$anonfun$testJsonFilter$1(x$1)));
    }

    public static final /* synthetic */ int $anonfun$testJsonFilter$2(TopicFilterJson x$2) {
        return x$2.filters().size();
    }

    private static final Option topicFilterSize$1(ClusterLinkConfig config) {
        return config.topicFilters().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ClusterLinkConfigTest.$anonfun$testJsonFilter$2(x$2)));
    }

    public static final /* synthetic */ int $anonfun$testJsonFilter$3(AclFiltersJson x$3) {
        return x$3.aclFilters().size();
    }

    private static final Option aclFilterSize$1(ClusterLinkConfig config) {
        return config.aclFilters().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ClusterLinkConfigTest.$anonfun$testJsonFilter$3(x$3)));
    }

    private static final void verifySuccess$1(Properties props, String enableConfig, Option size, Function1 filterSize) {
        props.setProperty(enableConfig, "true");
        Assertions.assertEquals((Object)size, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, true)));
        Assertions.assertEquals((Object)size, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, false)));
        props.setProperty(enableConfig, "false");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, true)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, false)));
        props.remove(enableConfig);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, true)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, false)));
    }

    private static final void verifyFailure$1(Properties props, String enableConfig) {
        props.setProperty(enableConfig, "true");
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ClusterLinkConfig$.MODULE$.create((Map)props, true));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ClusterLinkConfig$.MODULE$.create((Map)props, false));
        props.setProperty(enableConfig, "false");
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ClusterLinkConfig$.MODULE$.create((Map)props, true));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ClusterLinkConfig$.MODULE$.create((Map)props, false));
        props.remove(enableConfig);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ClusterLinkConfig$.MODULE$.create((Map)props, true));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ClusterLinkConfig$.MODULE$.create((Map)props, false));
    }

    private static final void verifyFilter$1(String enableConfig, String filterConfig, String validFilter, Function1 filterSize) {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:1234");
        props.setProperty(filterConfig, validFilter);
        Some verifySuccess$1_size = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        props.setProperty(enableConfig, "true");
        Assertions.assertEquals((Object)verifySuccess$1_size, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, true)));
        Assertions.assertEquals((Object)verifySuccess$1_size, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, false)));
        props.setProperty(enableConfig, "false");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, true)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, false)));
        props.remove(enableConfig);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, true)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, false)));
        Object var5_5 = null;
        props.setProperty(filterConfig, "{");
        ClusterLinkConfigTest.verifyFailure$1(props, enableConfig);
        props.remove(filterConfig);
        None$ verifySuccess$1_size2 = None$.MODULE$;
        props.setProperty(enableConfig, "true");
        Assertions.assertEquals((Object)verifySuccess$1_size2, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, true)));
        Assertions.assertEquals((Object)verifySuccess$1_size2, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, false)));
        props.setProperty(enableConfig, "false");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, true)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, false)));
        props.remove(enableConfig);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, true)));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filterSize.apply((Object)ClusterLinkConfig$.MODULE$.create((Map)props, false)));
    }

    public static final /* synthetic */ Option $anonfun$testJsonFilter$10(ClusterLinkConfig config) {
        return ClusterLinkConfigTest.groupFilterSize$1(config);
    }

    public static final /* synthetic */ Option $anonfun$testJsonFilter$11(ClusterLinkConfig config) {
        return ClusterLinkConfigTest.topicFilterSize$1(config);
    }

    public static final /* synthetic */ Option $anonfun$testJsonFilter$12(ClusterLinkConfig config) {
        return ClusterLinkConfigTest.aclFilterSize$1(config);
    }

    public ClusterLinkConfigTest() {
        this.brokerJaas = "org.apache.kafka.common.security.plain.PlainLoginModule required  username=\"brokerUser\" password=\"secret\";";
        this.clientJaas = "org.apache.kafka.common.security.scram.ScramLoginModule required username=\"clientUser\" password=\"secret\";";
    }
}

