/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkInboundConnectionManager;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ConnectionMode;
import kafka.utils.LogCaptureAppender;
import kafka.utils.LogCaptureAppender$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ReverseChannel;
import org.apache.kafka.common.network.ReverseNode;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tmg\u0001\u0002\u001f>\u0001\u0011CQa\u0013\u0001\u0005\u00021Cqa\u0014\u0001C\u0002\u0013%\u0001\u000b\u0003\u0004V\u0001\u0001\u0006I!\u0015\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u0011\u0019\u0001\u0007\u0001)A\u00051\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0007B\u00028\u0001A\u0003%1\rC\u0004p\u0001\t\u0007I\u0011B,\t\rA\u0004\u0001\u0015!\u0003Y\u0011\u001d\t\bA1A\u0005\n]CaA\u001d\u0001!\u0002\u0013A\u0006bB:\u0001\u0005\u0004%I\u0001\u001e\u0005\u0007w\u0002\u0001\u000b\u0011B;\t\u000fq\u0004!\u0019!C\u0005{\"9\u0011\u0011\u0002\u0001!\u0002\u0013q\b\"CA\u0006\u0001\t\u0007I\u0011BA\u0007\u0011!\t)\u0002\u0001Q\u0001\n\u0005=\u0001\"CA\f\u0001\t\u0007I\u0011BA\r\u0011!\t\t\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u0012\u0001\t\u0007I\u0011BA\u0013\u0011!\ti\u0003\u0001Q\u0001\n\u0005\u001d\u0002\"CA\u0018\u0001\t\u0007I\u0011BA\u0019\u0011!\ty\u0004\u0001Q\u0001\n\u0005M\u0002\"CA!\u0001\t\u0007I\u0011BA\"\u0011!\t)\u0006\u0001Q\u0001\n\u0005\u0015\u0003\"CA,\u0001\t\u0007I\u0011BA-\u0011!\t)\u0007\u0001Q\u0001\n\u0005m\u0003\"CA4\u0001\t\u0007I\u0011BA5\u0011!\t\t\t\u0001Q\u0001\n\u0005-\u0004bCAB\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000bC1\"!$\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0010\"Y\u00111\u0014\u0001A\u0002\u0003\u0005\u000b\u0015BAD\u0011-\ti\n\u0001a\u0001\u0002\u0004%I!a(\t\u0017\u0005\u001d\u0006\u00011AA\u0002\u0013%\u0011\u0011\u0016\u0005\f\u0003[\u0003\u0001\u0019!A!B\u0013\t\t\u000bC\u0006\u00020\u0002\u0001\r\u00111A\u0005\n\u0005E\u0006bCA]\u0001\u0001\u0007\t\u0019!C\u0005\u0003wC1\"a0\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00024\"Y\u0011\u0011\u0019\u0001A\u0002\u0003\u0007I\u0011BAb\u0011-\t)\r\u0001a\u0001\u0002\u0004%I!a2\t\u0017\u0005-\u0007\u00011A\u0001B\u0003&\u00111\u0010\u0005\f\u0003\u001b\u0004\u0001\u0019!a\u0001\n\u0013\ty\rC\u0006\u0002Z\u0002\u0001\r\u00111A\u0005\n\u0005m\u0007bCAp\u0001\u0001\u0007\t\u0011)Q\u0005\u0003#Dq!!9\u0001\t\u0003\t\u0019\u000fC\u0004\u0002|\u0002!\t!a9\t\u000f\t\u0015\u0001\u0001\"\u0001\u0002d\"9!q\u0002\u0001\u0005\u0002\u0005\r\bb\u0002B\n\u0001\u0011\u0005\u00111\u001d\u0005\b\u0005/\u0001A\u0011AAr\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0003GDqAa\b\u0001\t\u0003\t\u0019\u000fC\u0004\u0003$\u0001!IA!\n\t\u000f\t\r\u0005\u0001\"\u0003\u0003\u0006\"9!q\u0011\u0001\u0005\n\t%\u0005b\u0002BK\u0001\u0011%!q\u0013\u0005\b\u00053\u0003A\u0011\u0002BN\u0011\u001d\u0011)\u000b\u0001C\u0005\u0005OC\u0011Ba1\u0001#\u0003%IA!2\u0003O\rcWo\u001d;fe2Kgn[%oE>,h\u000eZ\"p]:,7\r^5p]6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003}}\nA\u0001\\5oW*\u0011\u0001)Q\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\t\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u000bB\u0011a)S\u0007\u0002\u000f*\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A'\u0011\u00059\u0003Q\"A\u001f\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0016\u0003E\u0003\"AU*\u000e\u0003}J!\u0001V \u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000eEJ|7.\u001a:D_:4\u0017n\u001a\u0011\u0002\u00111Lgn\u001b(b[\u0016,\u0012\u0001\u0017\t\u00033zk\u0011A\u0017\u0006\u00037r\u000bA\u0001\\1oO*\tQ,\u0001\u0003kCZ\f\u0017BA0[\u0005\u0019\u0019FO]5oO\u0006IA.\u001b8l\u001d\u0006lW\rI\u0001\u0007Y&t7.\u00133\u0016\u0003\r\u0004\"\u0001\u001a7\u000e\u0003\u0015T!AZ4\u0002\r\r|W.\\8o\u0015\t\u0011\u0005N\u0003\u0002jU\u00061\u0011\r]1dQ\u0016T\u0011a[\u0001\u0004_J<\u0017BA7f\u0005\u0011)V/\u001b3\u0002\u000f1Lgn[%eA\u0005y1o\\;sG\u0016\u001cE.^:uKJLE-\u0001\tt_V\u00148-Z\"mkN$XM]%eA\u0005iA-Z:u\u00072,8\u000f^3s\u0013\u0012\fa\u0002Z3ti\u000ecWo\u001d;fe&#\u0007%\u0001\u0005mS:\\G)\u0019;b+\u0005)\bC\u0001<z\u001b\u00059(B\u0001=B\u0003\tQ8.\u0003\u0002{o\ny1\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018-A\u0005mS:\\G)\u0019;bA\u0005IA.\u001b8l!J|\u0007o]\u000b\u0002}B\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u00029\u0006!Q\u000f^5m\u0013\u0011\t9!!\u0001\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\u0006mS:\\\u0007K]8qg\u0002\nq\"\\3uC\u0012\fG/Y'b]\u0006<WM]\u000b\u0003\u0003\u001f\u00012ATA\t\u0013\r\t\u0019\"\u0010\u0002\u001b\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y'b]\u0006<WM]\u0001\u0011[\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0002\n\u0011b]2iK\u0012,H.\u001a:\u0016\u0005\u0005m\u0001c\u0001(\u0002\u001e%\u0019\u0011qD\u001f\u0003)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\fY&t7.T1oC\u001e,'/\u0006\u0002\u0002(A\u0019a*!\u000b\n\u0007\u0005-RH\u0001\nDYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014\u0018\u0001\u00047j].l\u0015M\\1hKJ\u0004\u0013!\u00048fi^|'o[\"mS\u0016tG/\u0006\u0002\u00024A!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:\u001d\fqa\u00197jK:$8/\u0003\u0003\u0002>\u0005]\"!\u0004(fi^|'o[\"mS\u0016tG/\u0001\boKR<xN]6DY&,g\u000e\u001e\u0011\u0002)\u0005$W.\u001b8NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s+\t\t)\u0005\u0005\u0003\u0002H\u0005ESBAA%\u0015\u0011\tY%!\u0014\u0002\u0013%tG/\u001a:oC2\u001c(\u0002BA(\u0003o\tQ!\u00193nS:LA!a\u0015\u0002J\t!\u0012\tZ7j]6+G/\u00193bi\u0006l\u0015M\\1hKJ\fQ#\u00193nS:lU\r^1eCR\fW*\u00198bO\u0016\u0014\b%A\u0004nKR\u0014\u0018nY:\u0016\u0005\u0005m\u0003\u0003BA/\u0003Cj!!a\u0018\u000b\u0007\u0005]S-\u0003\u0003\u0002d\u0005}#aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005i1\r\\8tK\u0012\u001cE.[3oiN,\"!a\u001b\u0011\r\u00055\u0014qOA>\u001b\t\tyG\u0003\u0003\u0002r\u0005M\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003k:\u0015AC2pY2,7\r^5p]&!\u0011\u0011PA8\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u00079\u000bi(C\u0002\u0002\u0000u\u0012ac\u00117vgR,'\u000fT5oW\u0006#W.\u001b8DY&,g\u000e^\u0001\u000fG2|7/\u001a3DY&,g\u000e^:!\u0003)a\u0017N\\6D_:4\u0017nZ\u000b\u0003\u0003\u000f\u00032ATAE\u0013\r\tY)\u0010\u0002\u0012\u00072,8\u000f^3s\u0019&t7nQ8oM&<\u0017A\u00047j].\u001cuN\u001c4jO~#S-\u001d\u000b\u0005\u0003#\u000b9\nE\u0002G\u0003'K1!!&H\u0005\u0011)f.\u001b;\t\u0013\u0005eu$!AA\u0002\u0005\u001d\u0015a\u0001=%c\u0005YA.\u001b8l\u0007>tg-[4!\u0003-a\u0017N\\6NKR\u0014\u0018nY:\u0016\u0005\u0005\u0005\u0006c\u0001(\u0002$&\u0019\u0011QU\u001f\u0003%\rcWo\u001d;fe2Kgn['fiJL7m]\u0001\u0010Y&t7.T3ue&\u001c7o\u0018\u0013fcR!\u0011\u0011SAV\u0011%\tIJIA\u0001\u0002\u0004\t\t+\u0001\u0007mS:\\W*\u001a;sS\u000e\u001c\b%A\u0006d_:tW*\u00198bO\u0016\u0014XCAAZ!\rq\u0015QW\u0005\u0004\u0003ok$aI\"mkN$XM\u001d'j].LeNY8v]\u0012\u001cuN\u001c8fGRLwN\\'b]\u0006<WM]\u0001\u0010G>tg.T1oC\u001e,'o\u0018\u0013fcR!\u0011\u0011SA_\u0011%\tI*JA\u0001\u0002\u0004\t\u0019,\u0001\u0007d_:tW*\u00198bO\u0016\u0014\b%A\u0006sK6|G/Z!e[&tWCAA>\u0003=\u0011X-\\8uK\u0006#W.\u001b8`I\u0015\fH\u0003BAI\u0003\u0013D\u0011\"!')\u0003\u0003\u0005\r!a\u001f\u0002\u0019I,Wn\u001c;f\u0003\u0012l\u0017N\u001c\u0011\u0002\u00151|7-\u00197BI6Lg.\u0006\u0002\u0002RB!\u00111[Ak\u001b\t\ti%\u0003\u0003\u0002X\u00065#AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\\\u0001\u000fY>\u001c\u0017\r\\!e[&tw\fJ3r)\u0011\t\t*!8\t\u0013\u0005e5&!AA\u0002\u0005E\u0017a\u00037pG\u0006d\u0017\tZ7j]\u0002\nQa]3u+B$\"!!%)\u00075\n9\u000f\u0005\u0003\u0002j\u0006]XBAAv\u0015\u0011\ti/a<\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002r\u0006M\u0018a\u00026va&$XM\u001d\u0006\u0004\u0003kT\u0017!\u00026v]&$\u0018\u0002BA}\u0003W\u0014!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007f\u0001\u0018\u0002\u0000B!\u0011\u0011\u001eB\u0001\u0013\u0011\u0011\u0019!a;\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u0007;fgR\u001cuN\u001c8fGRLwN\\'pI\u0016|U\u000f\u001e2pk:$\u0007fA\u0018\u0003\nA!\u0011\u0011\u001eB\u0006\u0013\u0011\u0011i!a;\u0003\tQ+7\u000f^\u0001\u001ai\u0016\u001cHoQ8o]\u0016\u001cG/[8o\u001b>$W-\u00138c_VtG\rK\u00021\u0005\u0013\tq\u0004^3tiB+'o]5ti\u0016tGoQ8o]\u0016\u001cG/[8o\r\u0006LG.\u001e:fQ\r\t$\u0011B\u0001\u0010i\u0016\u001cHOU3d_:4\u0017nZ;sK\"\u001a!G!\u0003\u0002\u0013Q,7\u000f\u001e)bkN,\u0007fA\u001a\u0003\n\u0005aA/Z:u\u0019><G*\u001a<fY\"\u001aAG!\u0003\u0002\u001dY,'/\u001b4z\u0019><G*\u001a<fYRA\u0011\u0011\u0013B\u0014\u00053\u0012I\u0007C\u0004\u0003*U\u0002\rAa\u000b\u0002\u000b\rd\u0017M\u001f>1\t\t5\"q\t\t\u0007\u0005_\u0011iDa\u0011\u000f\t\tE\"\u0011\b\t\u0004\u0005g9UB\u0001B\u001b\u0015\r\u00119dQ\u0001\u0007yI|w\u000e\u001e \n\u0007\tmr)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u007f\u0011\tEA\u0003DY\u0006\u001c8OC\u0002\u0003<\u001d\u0003BA!\u0012\u0003H1\u0001A\u0001\u0004B%\u0005O\t\t\u0011!A\u0003\u0002\t-#aA0%cE!!Q\nB*!\r1%qJ\u0005\u0004\u0005#:%a\u0002(pi\"Lgn\u001a\t\u0004\r\nU\u0013b\u0001B,\u000f\n\u0019\u0011I\\=\t\u000f\tmS\u00071\u0001\u0003^\u0005A\u0011\r\u001d9f]\u0012,'\u000f\u0005\u0003\u0003`\t\u0015TB\u0001B1\u0015\r\u0011\u0019'Q\u0001\u0006kRLGn]\u0005\u0005\u0005O\u0012\tG\u0001\nM_\u001e\u001c\u0015\r\u001d;ve\u0016\f\u0005\u000f]3oI\u0016\u0014\bb\u0002B6k\u0001\u0007!QN\u0001\f[\u0006DHj\\4MKZ,G\u000eE\u0003G\u0005_\u0012\u0019(C\u0002\u0003r\u001d\u0013aa\u00149uS>t\u0007\u0003\u0002B;\u0005\u007fj!Aa\u001e\u000b\t\te$1P\u0001\u0006KZ,g\u000e\u001e\u0006\u0004\u0005{R\u0017!B:mMRR\u0017\u0002\u0002BA\u0005o\u0012Q\u0001T3wK2\f!c\u0019:fCR,'I]8lKJ\u001cuN\u001c4jOR\t\u0011+\u0001\ftKR,\boQ8o]\u0016\u001cG/[8o\u001b\u0006t\u0017mZ3s)\u0011\t\tJa#\t\u000f\t5u\u00071\u0001\u0003\u0010\u0006q1m\u001c8oK\u000e$\u0018n\u001c8N_\u0012,\u0007c\u0001(\u0003\u0012&\u0019!1S\u001f\u0003\u001d\r{gN\\3di&|g.T8eK\u0006\u00012M]3bi\u0016dunY1m\u0003\u0012l\u0017N\u001c\u000b\u0003\u0003#\f\u0011c\u0019:fCR,'+Z7pi\u0016\fE-\\5o)\u0019\tYH!(\u0003\"\"9!qT\u001dA\u0002\u0005\u001d\u0015AB2p]\u001aLw\rC\u0004\u0003$f\u0002\r!a-\u0002\u000f5\fg.Y4fe\u0006Y!/\u001a<feN,gj\u001c3f)\u0019\u0011IK!.\u0003@B!!1\u0016BY\u001b\t\u0011iKC\u0002\u00030\u0016\fqA\\3uo>\u00148.\u0003\u0003\u00034\n5&a\u0003*fm\u0016\u00148/\u001a(pI\u0016DqAa.;\u0001\u0004\u0011I,\u0001\u0004o_\u0012,\u0017\n\u001a\t\u0004\r\nm\u0016b\u0001B_\u000f\n\u0019\u0011J\u001c;\t\u0013\t\u0005'\b%AA\u0002\te\u0016!\u0003:fcV,7\u000f^%e\u0003U\u0011XM^3sg\u0016tu\u000eZ3%I\u00164\u0017-\u001e7uII*\"Aa2+\t\te&\u0011Z\u0016\u0003\u0005\u0017\u0004BA!4\u0003X6\u0011!q\u001a\u0006\u0005\u0005#\u0014\u0019.A\u0005v]\u000eDWmY6fI*\u0019!Q[$\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003Z\n='!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ClusterLinkInboundConnectionManagerTest {
    private final KafkaConfig brokerConfig = this.createBrokerConfig();
    private final String linkName;
    private final Uuid linkId = Uuid.randomUuid();
    private final String sourceClusterId;
    private final String destClusterId;
    private final ClusterLinkData linkData = new ClusterLinkData(this.linkName(), this.linkId(), (Option)new Some((Object)this.sourceClusterId()), (Option)None$.MODULE$, false);
    private final Properties linkProps = new Properties();
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final ClusterLinkManager linkManager = (ClusterLinkManager)Mockito.mock(ClusterLinkManager.class);
    private final NetworkClient networkClient = (NetworkClient)Mockito.mock(NetworkClient.class);
    private final AdminMetadataManager adminMetadataManager = new AdminMetadataManager(new LogContext(), 100L, 10000L);
    private final Metrics metrics = new Metrics();
    private final ArrayBuffer<ClusterLinkAdminClient> closedClients = ArrayBuffer$.MODULE$.empty();
    private ClusterLinkConfig linkConfig;
    private ClusterLinkMetrics linkMetrics;
    private ClusterLinkInboundConnectionManager connManager;
    private ClusterLinkAdminClient remoteAdmin;
    private ConfluentAdmin kafka$server$link$ClusterLinkInboundConnectionManagerTest$$localAdmin;

    private KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    private String linkName() {
        return this.linkName;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private String sourceClusterId() {
        return this.sourceClusterId;
    }

    private String destClusterId() {
        return this.destClusterId;
    }

    private ClusterLinkData linkData() {
        return this.linkData;
    }

    private Properties linkProps() {
        return this.linkProps;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ClusterLinkManager linkManager() {
        return this.linkManager;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private AdminMetadataManager adminMetadataManager() {
        return this.adminMetadataManager;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private ArrayBuffer<ClusterLinkAdminClient> closedClients() {
        return this.closedClients;
    }

    private ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    private void linkConfig_$eq(ClusterLinkConfig x$1) {
        this.linkConfig = x$1;
    }

    private ClusterLinkMetrics linkMetrics() {
        return this.linkMetrics;
    }

    private void linkMetrics_$eq(ClusterLinkMetrics x$1) {
        this.linkMetrics = x$1;
    }

    private ClusterLinkInboundConnectionManager connManager() {
        return this.connManager;
    }

    private void connManager_$eq(ClusterLinkInboundConnectionManager x$1) {
        this.connManager = x$1;
    }

    private ClusterLinkAdminClient remoteAdmin() {
        return this.remoteAdmin;
    }

    private void remoteAdmin_$eq(ClusterLinkAdminClient x$1) {
        this.remoteAdmin = x$1;
    }

    private ConfluentAdmin localAdmin() {
        return this.kafka$server$link$ClusterLinkInboundConnectionManagerTest$$localAdmin;
    }

    public void kafka$server$link$ClusterLinkInboundConnectionManagerTest$$localAdmin_$eq(ConfluentAdmin x$1) {
        this.kafka$server$link$ClusterLinkInboundConnectionManagerTest$$localAdmin = x$1;
    }

    @BeforeEach
    public void setUp() {
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(this.linkName()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    @AfterEach
    public void tearDown() {
        if (this.connManager() != null) {
            this.connManager().shutdown();
        }
        this.scheduler().shutdown();
        this.metrics().close();
    }

    @Test
    public void testConnectionModeOutbound() {
        this.setupConnectionManager((ConnectionMode)ConnectionMode.Outbound$.MODULE$);
        Assertions.assertNull((Object)this.remoteAdmin());
        Assertions.assertThrows(IllegalStateException.class, () -> this.connManager().startup());
        Assertions.assertNull((Object)this.remoteAdmin());
        KafkaChannel channel = (KafkaChannel)Mockito.mock(KafkaChannel.class);
        Assertions.assertThrows(InvalidRequestException.class, () -> this.connManager().processReverseConnection(channel, this.reverseNode(1, -1)));
        Assertions.assertNull((Object)this.localAdmin(), (String)"Local admin client created unnecessarily for outbound dest connection manager");
        this.connManager().shutdown();
    }

    @Test
    public void testConnectionModeInbound() {
        this.setupConnectionManager((ConnectionMode)ConnectionMode.Inbound$.MODULE$);
        Assertions.assertNull((Object)this.remoteAdmin());
        this.connManager().startup();
        Assertions.assertNotNull((Object)this.remoteAdmin());
        Assertions.assertTrue((boolean)this.connManager().reverseConnectionProvider(this.networkClient(), (Option)new Some((Object)this.adminMetadataManager()), "").nonEmpty());
        KafkaChannel channel = (KafkaChannel)Mockito.mock(KafkaChannel.class);
        ReverseNode node1 = this.reverseNode(1, -1);
        this.connManager().processReverseConnection(channel, node1);
        Assertions.assertEquals((int)1, (int)this.connManager().persistentConnectionCount());
        Assertions.assertEquals((int)1, (int)this.connManager().reverseConnectionCount());
        ReverseNode node2 = this.reverseNode(2, 5);
        Assertions.assertThrows(NetworkException.class, () -> this.connManager().processReverseConnection(channel, node2));
        Assertions.assertEquals((int)1, (int)this.connManager().persistentConnectionCount());
        Assertions.assertEquals((int)1, (int)this.connManager().reverseConnectionCount());
        Assertions.assertNotNull((Object)this.localAdmin(), (String)"Local admin client not created for inbound dest connection manager");
        this.connManager().shutdown();
        Assertions.assertNull((Object)this.localAdmin(), (String)"Local admin client was not shutdown");
    }

    @Test
    public void testPersistentConnectionFailure() {
        this.setupConnectionManager((ConnectionMode)ConnectionMode.Inbound$.MODULE$);
        this.connManager().startup();
        KafkaChannel channel = (KafkaChannel)Mockito.mock(KafkaChannel.class);
        ((KafkaChannel)Mockito.doNothing().when((Object)channel)).close();
        ReverseNode node = this.reverseNode(1, -1);
        this.networkClient().reverseAndAdd((ReverseChannel)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new RuntimeException("Test exception")});
        Assertions.assertThrows(RuntimeException.class, () -> this.connManager().processReverseConnection(channel, node));
        ((NetworkClient)Mockito.verify((Object)this.networkClient())).reverseAndAdd((ReverseChannel)ArgumentMatchers.any());
    }

    @Test
    public void testReconfigure() {
        this.setupConnectionManager((ConnectionMode)ConnectionMode.Inbound$.MODULE$);
        this.connManager().startup();
        ConfluentAdmin oldLocalAdmin = this.localAdmin();
        ClusterLinkAdminClient oldAdmin = this.remoteAdmin();
        this.linkProps().setProperty("metadata.max.age.ms", "1000");
        this.linkConfig_$eq(ClusterLinkConfig$.MODULE$.create((Map)this.linkProps(), true));
        this.connManager().reconfigure(this.linkConfig(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"metadata.max.age.ms"})));
        Assertions.assertEquals((Object)this.connManager().currentConfig().originals(), (Object)this.linkConfig().originals());
        Assertions.assertNotNull((Object)this.remoteAdmin());
        Assertions.assertNotSame((Object)oldAdmin, (Object)this.remoteAdmin());
        Assertions.assertEquals((Object)new .colon.colon((Object)oldAdmin, (List)Nil$.MODULE$), (Object)this.closedClients().toSeq());
        Assertions.assertSame((Object)oldLocalAdmin, (Object)this.localAdmin());
    }

    @Test
    public void testPause() {
        this.setupConnectionManager((ConnectionMode)ConnectionMode.Inbound$.MODULE$);
        this.connManager().startup();
        ClusterLinkAdminClient oldAdmin = this.remoteAdmin();
        this.linkProps().setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp(), "true");
        this.linkConfig_$eq(ClusterLinkConfig$.MODULE$.create((Map)this.linkProps(), true));
        this.connManager().reconfigure(this.linkConfig(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()})));
        Assertions.assertEquals((Object)this.connManager().currentConfig().originals(), (Object)this.linkConfig().originals());
        Assertions.assertEquals((Object)new .colon.colon((Object)oldAdmin, (List)Nil$.MODULE$), (Object)this.closedClients().toSeq());
        Assertions.assertNull((Object)this.localAdmin(), (String)"Local admin client was not shutdown");
        Assertions.assertNull((Object)this.remoteAdmin(), (String)"Remote admin client was not shutdown");
        this.linkProps().setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp(), "false");
        this.linkConfig_$eq(ClusterLinkConfig$.MODULE$.create((Map)this.linkProps(), true));
        this.connManager().reconfigure(this.linkConfig(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()})));
        Assertions.assertNotNull((Object)this.localAdmin(), (String)"Local admin client was not recreated");
        Assertions.assertNotNull((Object)this.remoteAdmin(), (String)"Remote admin client was not recreated");
    }

    @Test
    public void testLogLevel() {
        Class<ClusterLinkInboundConnectionManager> clazz = ClusterLinkInboundConnectionManager.class;
        Level oldLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(clazz, Level.ALL);
        LogCaptureAppender appender = LogCaptureAppender$.MODULE$.createAndRegister();
        try {
            this.verifyLogLevel(clazz, appender, (Option<org.slf4j.event.Level>)None$.MODULE$);
            this.verifyLogLevel(clazz, appender, (Option<org.slf4j.event.Level>)new Some(null));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])org.slf4j.event.Level.values()), (Function1 & Serializable)level -> {
                this.verifyLogLevel(clazz, appender, (Option<org.slf4j.event.Level>)new Some((Object)level));
                return BoxedUnit.UNIT;
            });
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(clazz, oldLevel);
            appender.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void verifyLogLevel(Class<?> clazz, LogCaptureAppender appender, Option<org.slf4j.event.Level> maxLogLevel) {
        currentMaxLevel = new AtomicReference<V>();
        if (maxLogLevel instanceof Some) {
            v0 = new LogContext("[TEST] ", currentMaxLevel);
        } else if (None$.MODULE$.equals(maxLogLevel)) {
            v0 = new LogContext("[TEST] ");
        } else {
            throw new MatchError(maxLogLevel);
        }
        logger = v0.logger(clazz);
        var7_6 = false;
        var8_7 = null;
        if (!(maxLogLevel instanceof Some)) ** GOTO lbl-1000
        var7_6 = true;
        var8_7 = (Some)maxLogLevel;
        if ((org.slf4j.event.Level)var8_7.value() == null) {
            v1 = org.slf4j.event.Level.ERROR;
        } else if (var7_6) {
            v1 = (org.slf4j.event.Level)var8_7.value();
        } else if (None$.MODULE$.equals(maxLogLevel)) {
            v1 = org.slf4j.event.Level.ERROR;
        } else {
            throw new MatchError(maxLogLevel);
        }
        maxLevel = v1;
        maxLogLevel.foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$verifyLogLevel$1$adapted(java.util.concurrent.atomic.AtomicReference org.slf4j.event.Level ), (Lorg/slf4j/event/Level;)Ljava/lang/Object;)(currentMaxLevel));
        logger.trace("trace message");
        ClusterLinkInboundConnectionManagerTest.assertLastLog$1(org.slf4j.event.Level.TRACE, "[TEST] trace message", appender, maxLevel);
        logger.debug("debug message");
        ClusterLinkInboundConnectionManagerTest.assertLastLog$1(org.slf4j.event.Level.DEBUG, "[TEST] debug message", appender, maxLevel);
        logger.info("info message");
        ClusterLinkInboundConnectionManagerTest.assertLastLog$1(org.slf4j.event.Level.INFO, "[TEST] info message", appender, maxLevel);
        logger.warn("warn message");
        ClusterLinkInboundConnectionManagerTest.assertLastLog$1(org.slf4j.event.Level.WARN, "[TEST] warn message", appender, maxLevel);
        logger.error("error message");
        ClusterLinkInboundConnectionManagerTest.assertLastLog$1(org.slf4j.event.Level.ERROR, "[TEST] error message", appender, maxLevel);
    }

    private KafkaConfig createBrokerConfig() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    private void setupConnectionManager(ConnectionMode connectionMode) {
        this.linkProps().put(ClusterLinkConfig$.MODULE$.ConnectionModeProp(), connectionMode.name());
        if (ConnectionMode.Outbound$.MODULE$.equals(connectionMode)) {
            this.linkProps().put("bootstrap.servers", "localhost:123");
        }
        this.linkConfig_$eq(ClusterLinkConfig$.MODULE$.create((Map)this.linkProps(), true));
        this.linkMetrics_$eq(new ClusterLinkMetrics(this.linkName(), this.linkId(), ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, false, this.linkManager(), (Option)None$.MODULE$, this.metrics(), (Option)None$.MODULE$));
        this.linkMetrics().startup();
        this.connManager_$eq(new ClusterLinkInboundConnectionManager(this.linkData(), this.linkConfig(), this.destClusterId(), (Option)None$.MODULE$, this.linkMetrics(), (Function2 & Serializable)(config, manager) -> this.createRemoteAdmin((ClusterLinkConfig)config, (ClusterLinkInboundConnectionManager)manager), (Function1 & Serializable)x$6 -> this.createLocalAdmin(), this.metadataManager(), this.brokerConfig(), (Time)new MockTime()));
    }

    private ConfluentAdmin createLocalAdmin() {
        this.kafka$server$link$ClusterLinkInboundConnectionManagerTest$$localAdmin_$eq((ConfluentAdmin)new MockAdminClient(this){
            private final /* synthetic */ ClusterLinkInboundConnectionManagerTest $outer;

            public void close(Duration timeout) {
                super.close(timeout);
                this.$outer.kafka$server$link$ClusterLinkInboundConnectionManagerTest$$localAdmin_$eq(null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return this.localAdmin();
    }

    private ClusterLinkAdminClient createRemoteAdmin(ClusterLinkConfig config, ClusterLinkInboundConnectionManager manager) {
        Assertions.assertEquals((Object)this.linkConfig().originals(), (Object)config.originals());
        Assertions.assertSame((Object)this.connManager(), (Object)manager);
        this.remoteAdmin_$eq((ClusterLinkAdminClient)Mockito.mock(ClusterLinkAdminClient.class));
        ((ClusterLinkAdminClient)Mockito.doAnswer(invocation -> {
            ClusterLinkInboundConnectionManagerTest.$anonfun$createRemoteAdmin$1(this, invocation);
            return BoxedUnit.UNIT;
        }).when((Object)this.remoteAdmin())).close();
        Mockito.when((Object)this.remoteAdmin().networkClient()).thenReturn((Object)this.networkClient());
        Mockito.when((Object)this.remoteAdmin().metadataManager()).thenReturn((Object)this.adminMetadataManager());
        return this.remoteAdmin();
    }

    private ReverseNode reverseNode(int nodeId, int requestId) {
        return new ReverseNode(nodeId, nodeId, new StringBuilder(4).append("host").append(nodeId).toString(), 1234, this.linkId(), requestId, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), KafkaPrincipal.ANONYMOUS, Optional.empty(), null);
    }

    private int reverseNode$default$2() {
        return -1;
    }

    private static final void assertLastLog$1(org.slf4j.event.Level logLevel, String expectedMessage, LogCaptureAppender appender$2, org.slf4j.event.Level maxLevel$1) {
        LoggingEvent event = (LoggingEvent)appender$2.getMessages().last();
        Assertions.assertEquals((Object)(maxLevel$1.toInt() < logLevel.toInt() ? maxLevel$1 : logLevel).name(), (Object)event.getLevel().toString());
        Assertions.assertEquals((Object)expectedMessage, (Object)event.getMessage());
    }

    public static final /* synthetic */ void $anonfun$createRemoteAdmin$1(ClusterLinkInboundConnectionManagerTest $this, InvocationOnMock invocation) {
        $this.closedClients().$plus$eq((Object)$this.remoteAdmin());
        $this.remoteAdmin_$eq(null);
    }

    public ClusterLinkInboundConnectionManagerTest() {
        this.linkName = "testLink";
        this.sourceClusterId = "sourceCluster";
        this.destClusterId = "destCluster";
    }

    public static final /* synthetic */ Object $anonfun$verifyLogLevel$1$adapted(AtomicReference currentMaxLevel$1, org.slf4j.event.Level x$1) {
        currentMaxLevel$1.set(x$1);
        return BoxedUnit.UNIT;
    }
}

