/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import kafka.cluster.ClusterLinkState;
import kafka.cluster.Partition;
import kafka.cluster.PartitionState;
import kafka.controller.KafkaController;
import kafka.network.SocketServer;
import kafka.server.BrokerEpochManager;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.ConfigType$;
import kafka.server.FetcherPool;
import kafka.server.FetcherTag;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.MetadataSupport;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ZkSupport;
import kafka.server.link.AbstractClusterLinkClientManager;
import kafka.server.link.ActiveClusterLink$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConfigDefaults$;
import kafka.server.link.ClusterLinkConfigEncoder;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkInboundConnectionManager;
import kafka.server.link.ClusterLinkInfo;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkOutboundConnectionManager;
import kafka.server.link.ClusterLinkRetryState;
import kafka.server.link.ConnectionMode;
import kafka.server.link.FailedClusterLink$;
import kafka.server.link.FetchResponseSize;
import kafka.server.link.MirrorTopicConfigSyncRules$;
import kafka.server.link.TestCreateClusterLinkPolicy;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.link.UnavailableClusterLink$;
import kafka.server.link.UnresolvableBootstrapUnavailableLinkReason$;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.ClusterLinkExistsException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u001dc\u0001\u0002\u001b6\u0001qBQa\u0011\u0001\u0005\u0002\u0011Cqa\u0012\u0001C\u0002\u0013%\u0001\n\u0003\u0004N\u0001\u0001\u0006I!\u0013\u0005\b\u001d\u0002\u0011\r\u0011\"\u0003P\u0011\u0019a\u0006\u0001)A\u0005!\"9Q\f\u0001b\u0001\n\u0013q\u0006BB3\u0001A\u0003%q\fC\u0004g\u0001\t\u0007I\u0011B4\t\r-\u0004\u0001\u0015!\u0003i\u0011\u001da\u0007A1A\u0005\n5Daa\u001d\u0001!\u0002\u0013q\u0007b\u0002;\u0001\u0005\u0004%I!\u001e\u0005\u0007y\u0002\u0001\u000b\u0011\u0002<\t\u000fu\u0004!\u0019!C\u0005}\"9\u0011Q\u0001\u0001!\u0002\u0013y\bbCA\u0004\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0013A1\"!\u0005\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0014!Y\u0011q\u0004\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0006\u0011-\t\t\u0003\u0001a\u0001\u0002\u0004%I!a\t\t\u0017\u0005-\u0002\u00011AA\u0002\u0013%\u0011Q\u0006\u0005\f\u0003c\u0001\u0001\u0019!A!B\u0013\t)\u0003C\u0005\u00024\u0001\u0011\r\u0011\"\u0003\u00026!A\u0011Q\n\u0001!\u0002\u0013\t9\u0004C\u0004\u0002P\u0001!\t!!\u0015\t\u000f\u0005%\u0004\u0001\"\u0001\u0002R!9\u00111\u000f\u0001\u0005\u0002\u0005E\u0003bBA?\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003\u0003\u0003A\u0011AA)\u0011\u001d\t)\t\u0001C\u0001\u0003#Bq!!#\u0001\t\u0003\t\t\u0006C\u0004\u0002\u000e\u0002!\t!!\u0015\t\u000f\u0005E\u0005\u0001\"\u0003\u0002R!9\u00111\u0013\u0001\u0005\n\u0005E\u0003bBAK\u0001\u0011%\u0011\u0011\u000b\u0005\b\u0003/\u0003A\u0011BA)\u0011\u001d\tI\n\u0001C\u0005\u0003#Bq!a'\u0001\t\u0003\ti\nC\u0004\u0002R\u0002!\t!!\u0015\t\u000f\u0005U\u0007\u0001\"\u0001\u0002R!9\u0011\u0011\u001c\u0001\u0005\u0002\u0005E\u0003bBAo\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003C\u0004A\u0011AA)\u0011\u001d\t)\u000f\u0001C\u0001\u0003#Bq!!;\u0001\t\u0003\t\t\u0006C\u0004\u0002n\u0002!\t!!\u0015\t\u000f\u0005E\b\u0001\"\u0003\u0002t\"9\u0011Q\u001f\u0001\u0005\u0002\u0005]\bb\u0002B\u0002\u0001\u0011%!Q\u0001\u0005\b\u0005\u000f\u0001A\u0011\u0002B\u0005\u0011\u001d\u0011\t\u0002\u0001C\u0005\u0005'AqAa\u000e\u0001\t\u0013\u0011ID\u0001\fDYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014H+Z:u\u0015\t1t'\u0001\u0003mS:\\'B\u0001\u001d:\u0003\u0019\u0019XM\u001d<fe*\t!(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0004C\u0001 B\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u000bB\u0011a\tA\u0007\u0002k\u0005a!M]8lKJ\u001cuN\u001c4jOV\t\u0011\n\u0005\u0002K\u00176\tq'\u0003\u0002Mo\tY1*\u00194lC\u000e{gNZ5h\u00035\u0011'o\\6fe\u000e{gNZ5hA\u00059Q.\u001a;sS\u000e\u001cX#\u0001)\u0011\u0005ESV\"\u0001*\u000b\u00059\u001b&B\u0001+V\u0003\u0019\u0019w.\\7p]*\u0011!H\u0016\u0006\u0003/b\u000ba!\u00199bG\",'\"A-\u0002\u0007=\u0014x-\u0003\u0002\\%\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\tQLW.Z\u000b\u0002?B\u0011\u0001mY\u0007\u0002C*\u0011!mU\u0001\u0006kRLGn]\u0005\u0003I\u0006\u0014\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\u0005A\u0007C\u0001&j\u0013\tQwG\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002\n!bY8oiJ|G\u000e\\3s+\u0005q\u0007CA8r\u001b\u0005\u0001(B\u00017:\u0013\t\u0011\bOA\bLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s\u0003-\u0019wN\u001c;s_2dWM\u001d\u0011\u0002\u0011i\\7\t\\5f]R,\u0012A\u001e\t\u0003ojl\u0011\u0001\u001f\u0006\u0003sf\n!A_6\n\u0005mD(!D&bM.\f'l[\"mS\u0016tG/A\u0005{W\u000ec\u0017.\u001a8uA\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012a \t\u0004\u0015\u0006\u0005\u0011bAA\u0002o\tiQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016\fa\"\\3uC\u0012\fG/Y\"bG\",\u0007%\u0001\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014XCAA\u0006!\r1\u0015QB\u0005\u0004\u0003\u001f)$AE\"mkN$XM\u001d'j].l\u0015M\\1hKJ\fac\u00197vgR,'\u000fT5oW6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003+\tY\u0002E\u0002?\u0003/I1!!\u0007@\u0005\u0011)f.\u001b;\t\u0013\u0005u\u0011#!AA\u0002\u0005-\u0011a\u0001=%c\u0005\u00192\r\\;ti\u0016\u0014H*\u001b8l\u001b\u0006t\u0017mZ3sA\u0005I!p[*vaB|'\u000f^\u000b\u0003\u0003K\u00012ASA\u0014\u0013\r\tIc\u000e\u0002\n5.\u001cV\u000f\u001d9peR\fQB_6TkB\u0004xN\u001d;`I\u0015\fH\u0003BA\u000b\u0003_A\u0011\"!\b\u0015\u0003\u0003\u0005\r!!\n\u0002\u0015i\\7+\u001e9q_J$\b%A\u000fu_BL7mQ8oM&<7+\u001f8d\u0013:\u001cG.\u001e3f\t\u00164\u0017-\u001e7u+\t\t9\u0004\u0005\u0003\u0002:\u0005\u001dc\u0002BA\u001e\u0003\u0007\u00022!!\u0010@\u001b\t\tyDC\u0002\u0002Bm\na\u0001\u0010:p_Rt\u0014bAA#\u007f\u00051\u0001K]3eK\u001aLA!!\u0013\u0002L\t11\u000b\u001e:j]\u001eT1!!\u0012@\u0003y!x\u000e]5d\u0007>tg-[4Ts:\u001c\u0017J\\2mk\u0012,G)\u001a4bk2$\b%A\u0003tKR,\u0006\u000f\u0006\u0002\u0002\u0016!\u001a\u0001$!\u0016\u0011\t\u0005]\u0013QM\u0007\u0003\u00033RA!a\u0017\u0002^\u0005\u0019\u0011\r]5\u000b\t\u0005}\u0013\u0011M\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t\u0019\u0007W\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003O\nIF\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u00043\u00055\u0004\u0003BA,\u0003_JA!!\u001d\u0002Z\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0011i\u0016\u001cHo\u00117vgR,'\u000fT5oWND3AGA<!\u0011\t9&!\u001f\n\t\u0005m\u0014\u0011\f\u0002\u0005)\u0016\u001cH/A,uKN$8I]3bi\u0016\u001cE.^:uKJd\u0015N\\6SK*,7\r^:SKF,Xm\u001d;JMR+g.\u00198u!J,g-\u001b=Jg:+H\u000e\\!oI\u000e\u0013X-\u0019;f\u00072,8\u000f^3s\u0019&t7\u000eU8mS\u000eLX\t_5tiND3aGA<\u0003=!Xm\u001d;SK\u000e|gNZ5hkJ,\u0007f\u0001\u000f\u0002x\u0005)B/Z:u\u0007>tg.Z2uS>tW*\u00198bO\u0016\u0014\bfA\u000f\u0002x\u00059B/Z:u%\u0016$XM\u001c;j_:\u001cuN\u001c4jONKhn\u0019\u0015\u0004=\u0005]\u0014a\n;fgR$v\u000e]5d\u0007>tg-[4Ts:\u001c\u0017J\\2mk\u0012,7i\\7qCRL'-\u001b7jifD3aHA<\u000351XM]5gs\u0012+g-Y;mi\u0006Yb/\u001a:jMfT6\nS1t\u001b\u0006dgm\u001c:nK\u0012\u001cuN\u001c4jON\f\u0011D^3sS\u001aL(l\u0013%bgVs7N\\8x]\u000e{gNZ5hg\u0006Yb/\u001a:jMfT6*T5tg\u0016\u001c\u0018\t\\<bsN\u001cuN\u001c4jON\fQD^3sS\u001aL(l\u0013%bg&sG-\u001a9f]\u0012,g\u000e^\"p]\u001aLwm]\u0001\u0012GJ,\u0017\r^3DYV\u001cH/\u001a:MS:\\G\u0003CAP\u0003[\u000b\t,!0\u0011\t\u0005\u0005\u0016q\u0015\b\u0004\r\u0006\r\u0016bAASk\u0005\u00112\t\\;ti\u0016\u0014H*\u001b8l\r\u0006\u001cGo\u001c:z\u0013\u0011\tI+a+\u0003\u001d\u0019+Go\u00195fe6\u000bg.Y4fe*\u0019\u0011QU\u001b\t\u000f\u0005=V\u00051\u0001\u00028\u0005AA.\u001b8l\u001d\u0006lW\rC\u0004\u00024\u0016\u0002\r!!.\u0002\r1Lgn[%e!\u0011\t9,!/\u000e\u0003MK1!a/T\u0005\u0011)V/\u001b3\t\u000f\u0005}V\u00051\u0001\u0002B\u0006\u00012\r\\;ti\u0016\u0014H*\u001b8l!J|\u0007o\u001d\t\u0005\u0003\u0007\fi-\u0004\u0002\u0002F*!\u0011qYAe\u0003\u0011)H/\u001b7\u000b\u0005\u0005-\u0017\u0001\u00026bm\u0006LA!a4\u0002F\nQ\u0001K]8qKJ$\u0018.Z:\u00021Q,7\u000f\u001e$bS2,G-\u00113e\u00072,8\u000f^3s\u0019&t7\u000eK\u0002'\u0003o\n!\u0005^3tiJ+7m\u001c8gS\u001e,(/\u001a(p]J+GO]5bE2,g)Y5mkJ,\u0007fA\u0014\u0002x\u0005\tD/Z:u%\u0016$(/\u001f*fG>tg-[4ve\u0016\u0014V\r\u001e:jC\ndWMR1jYV\u0014Xm\u00148MS:\\'+\u001e8oS:<\u0007f\u0001\u0015\u0002x\u0005\tD/Z:u%\u0016$(/\u001f*fG>tg-[4ve\u0016\u0014V\r\u001e:jC\ndWMR1jYV\u0014Xm\u00148MS:\\7\u000b^1siV\u0004\bfA\u0015\u0002x\u0005)B/Z:u\t\u0016dW\r^3DYV\u001cH/\u001a:MS:\\\u0007f\u0001\u0016\u0002x\u0005!B/Z:u\tft\u0017-\\5d\r\u0016$8\r[*ju\u0016D3aKA<\u0003\u0005\"Xm\u001d;DYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\u0014V-\u001a8def\u0004H/[8oQ\ra\u0013qO\u0001!i\u0016\u001cH\u000fT3bI\u0016\u0014\u0018I\u001c3JgJ\u0014UMZ8sK2Kgn[+qI\u0006$X\rK\u0002.\u0003o\n!c\u0019:fCR,'I]8lKJ\u001cuN\u001c4jOR\t\u0011*\u0001\u000fhKR\u001cE.^:uKJd\u0015N\\6GC&dW\rZ!ui\u0016l\u0007\u000f^:\u0015\r\u0005e\u0018q B\u0001!\rq\u00141`\u0005\u0004\u0003{|$\u0001\u0002'p]\u001eDq!a\u00020\u0001\u0004\tY\u0001C\u0004\u00024>\u0002\r!!.\u00025\rdWo\u001d;fe2Kgn\u001b)feNL7\u000f^3oiB\u0013x\u000e]:\u0016\u0005\u0005\u0005\u0017!E2mkN$XM\u001d'j].\u001cuN\u001c4jOV\u0011!1\u0002\t\u0004\r\n5\u0011b\u0001B\bk\t\t2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0002\u0013M,G/\u001e9N_\u000e\\G\u0003CA\u000b\u0005+\u0011)Ca\f\t\u000f\t]!\u00071\u0001\u0003\u001a\u0005I\u0001/\u0019:uSRLwN\u001c\t\u0005\u00057\u0011\t#\u0004\u0002\u0003\u001e)\u0019!qD\u001d\u0002\u000f\rdWo\u001d;fe&!!1\u0005B\u000f\u0005%\u0001\u0016M\u001d;ji&|g\u000eC\u0004\u0003(I\u0002\rA!\u000b\u0002\u0005Q\u0004\b\u0003BA\\\u0005WI1A!\fT\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a-3\u0001\u0004\u0011\t\u0004E\u0003?\u0005g\t),C\u0002\u00036}\u0012aa\u00149uS>t\u0017\u0001G2sK\u0006$Xm\u00117vgR,'\u000fT5oW6\u000bg.Y4feR1\u00111\u0002B\u001e\u0005{AQaR\u001aA\u0002%CqAa\u00104\u0001\u0004\u0011\t%A\bnKR\fG-\u0019;b'V\u0004\bo\u001c:u!\rQ%1I\u0005\u0004\u0005\u000b:$aD'fi\u0006$\u0017\r^1TkB\u0004xN\u001d;")
public class ClusterLinkManagerTest {
    private final KafkaConfig brokerConfig = this.createBrokerConfig();
    private final Metrics metrics = new Metrics();
    private final MockTime time = new MockTime();
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final KafkaController controller = (KafkaController)Mockito.mock(KafkaController.class);
    private final KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
    private final MetadataCache metadataCache;
    private ClusterLinkManager clusterLinkManager;
    private ZkSupport zkSupport;
    private final String topicConfigSyncIncludeDefault;

    private KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private MockTime time() {
        return this.time;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    private void clusterLinkManager_$eq(ClusterLinkManager x$1) {
        this.clusterLinkManager = x$1;
    }

    private ZkSupport zkSupport() {
        return this.zkSupport;
    }

    private void zkSupport_$eq(ZkSupport x$1) {
        this.zkSupport = x$1;
    }

    private String topicConfigSyncIncludeDefault() {
        return this.topicConfigSyncIncludeDefault;
    }

    @BeforeEach
    public void setUp() {
        Mockito.when((Object)this.replicaManager().metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)this.replicaManager().zkClient()).thenReturn((Object)new Some((Object)this.zkClient()));
        Mockito.when((Object)this.replicaManager().leaderPartitionsIterator()).thenReturn((Object)Predef$.MODULE$.Set().empty().iterator());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.zkClient().getChildren("/cluster_links")).thenReturn((Object)package$.MODULE$.Seq().empty());
        Mockito.when((Object)this.zkClient().getClusterLinks(Predef$.MODULE$.Set().empty())).thenReturn((Object)Predef$.MODULE$.Map().empty());
        ((KafkaZkClient)Mockito.doNothing().when((Object)this.zkClient())).transformEntityConfigs((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any());
        this.zkSupport_$eq(new ZkSupport(null, this.controller(), this.zkClient(), (Option)None$.MODULE$, (ZkMetadataCache)this.metadataCache(), new BrokerEpochManager(null){

            public long get() {
                return 1L;
            }

            public boolean isBrokerEpochStale(long brokerEpochInRequest, boolean isKRaftControllerRequest) {
                return false;
            }
        }));
        this.clusterLinkManager_$eq(this.createClusterLinkManager(this.brokerConfig(), (MetadataSupport)this.zkSupport()));
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
    }

    @AfterEach
    public void tearDown() {
        this.clusterLinkManager().shutdown();
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClusterLinks() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        UUID javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId);
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        String topic = "testTopic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        Partition partition0 = (Partition)Mockito.mock(Partition.class);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().fetcherManager(linkId));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().clientManager(linkId));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().resolveLinkId(linkName));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> this.clusterLinkManager().resolveLinkIdOrThrow(linkName), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.clusterLinkManager().ensureLinkNameDoesntExist(linkName);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)this.clusterLinkManager().listClusterLinks());
        this.setupMock(partition0, tp0, (Option<Uuid>)None$.MODULE$);
        this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0})));
        this.setupMock(partition0, tp0, (Option<Uuid>)new Some((Object)linkId));
        Assertions.assertEquals((int)0, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))));
        this.setupMock(partition0, tp0, (Option<Uuid>)new Some((Object)linkId));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.clusterLinkManager().createClusterLink(clusterLinkData, this.clusterLinkConfig(), this.clusterLinkPersistentProps());
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().fetcherManager(linkId));
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().clientManager(linkId));
        Assertions.assertEquals((Object)new Some((Object)linkId), (Object)this.clusterLinkManager().resolveLinkId(linkName));
        Assertions.assertEquals((Object)new .colon.colon((Object)clusterLinkData, (List)Nil$.MODULE$), (Object)this.clusterLinkManager().listClusterLinks());
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)this.clusterLinkManager().fetcherManager(linkId).get();
        ClusterLinkDestClientManager clientManager = (ClusterLinkDestClientManager)this.clusterLinkManager().clientManager(linkId).get();
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.clusterLinkManager().createClusterLink(new ClusterLinkData(linkName, Uuid.randomUuid(), (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false), this.clusterLinkConfig(), this.clusterLinkPersistentProps()), ClassTag$.MODULE$.apply(ClusterLinkExistsException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        Assertions.assertEquals((int)1, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))));
        Assertions.assertTrue((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.time().milliseconds()), (String)"Topic not added to metadata");
        Assertions.assertTrue((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic not added to client manager");
        Assertions.assertFalse((boolean)fetcherManager.isEmpty(), (String)"Fetcher not recording active topic");
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).clusterLinkExists(linkId);
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = (LeaderAndIsrRequestData.LeaderAndIsrPartitionState)Mockito.mock(LeaderAndIsrRequestData.LeaderAndIsrPartitionState.class);
        Mockito.when((Object)partitionState.clusterLinkId()).thenReturn((Object)javaLinkId.toString());
        Mockito.when((Object)partitionState.clusterLinkTopicState()).thenReturn((Object)"Mirror");
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionState.linkedLeaderEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)partitionState.clusterLinkSourceTopicId()).thenReturn((Object)Uuid.randomUuid());
        this.clusterLinkManager().removePartitions((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)partitionState)})));
        Assertions.assertTrue((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.time().milliseconds()), (String)"Topic removed from metadata");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic not removed from client manager");
        Mockito.reset((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{partitionState});
        Mockito.when((Object)partitionState.clusterLinkId()).thenReturn(null);
        Mockito.when((Object)partitionState.clusterLinkSourceTopicId()).thenReturn((Object)Uuid.randomUuid());
        this.clusterLinkManager().removePartitions((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)partitionState)})));
        Assertions.assertFalse((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.time().milliseconds()), (String)"Topic not removed from metadata");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic should not be in client manager");
        Mockito.reset((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{partitionState});
        Mockito.when((Object)partitionState.clusterLinkId()).thenReturn((Object)javaLinkId.toString());
        Mockito.when((Object)partitionState.clusterLinkSourceTopicId()).thenReturn((Object)Uuid.randomUuid());
        Mockito.when((Object)partitionState.clusterLinkTopicState()).thenReturn((Object)"FailedMirror");
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionState.linkedLeaderEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)-1));
        Assertions.assertEquals((int)1, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))));
        this.clusterLinkManager().removePartitions((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)partitionState)})));
        Assertions.assertFalse((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.time().milliseconds()), (String)"Topic not removed from metadata for failed mirror");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic should not be in client manager for failed mirror");
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Partition partition1 = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition1, tp1, (Option<Uuid>)new Some((Object)linkId));
        Assertions.assertEquals((int)1, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition1}))));
        Assertions.assertTrue((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.time().milliseconds()), (String)"Topic not added to metadata");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic should not be added to client manager");
        this.clusterLinkManager().removePartitionsAndMetadata((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})));
        Assertions.assertFalse((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.time().milliseconds()), (String)"Topic not removed from metadata");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic should not be in to client manager");
        Object object = this.clusterLinkManager().fetcherManager(linkId).get();
        Assertions.assertTrue((object != null && object.equals(fetcherManager) ? 1 : 0) != 0, (String)"Unexpected fetcher manager");
        Object object2 = this.clusterLinkManager().clientManager(linkId).get();
        Assertions.assertTrue((object2 != null && object2.equals(clientManager) ? 1 : 0) != 0, (String)"Unexpected client manager");
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
        ClusterLinkData cldIsDeleted = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)javaLinkId), (Object)cldIsDeleted)})), (Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)});
        ((KafkaZkClient)Mockito.doNothing().when((Object)this.zkClient())).setClusterLink(cldIsDeleted);
        this.clusterLinkManager().deleteClusterLink(linkName, linkId);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().resolveLinkId(linkName));
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).clusterLinkExists(linkId);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.clusterLinkManager().deleteClusterLink(linkName, linkId), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinks$4(this, linkId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkManagerTest.$anonfun$testClusterLinks$5(linkId));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient(), (VerificationMode)Mockito.times((int)3))).getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})));
    }

    @Test
    public void testCreateClusterLinkRejectsRequestIfTenantPrefixIsNullAndCreateClusterLinkPolicyExists() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        props.put(KafkaConfig$.MODULE$.CreateClusterLinkPolicyClassNameProp(), TestCreateClusterLinkPolicy.class);
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(props);
        ClusterLinkManager clusterLinkManager = this.createClusterLinkManager(brokerConfig, (MetadataSupport)this.zkSupport());
        InvalidRequestException ex = (InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> clusterLinkManager.createClusterLink(clusterLinkData, this.clusterLinkConfig(), this.clusterLinkPersistentProps()));
        Assertions.assertEquals((Object)"Tenant prefix cannot be null if a CreateClusterLinkPolicy is set.", (Object)ex.getMessage());
    }

    @Test
    public void testReconfigure() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        UUID javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.clusterLinkManager().updateClusterLinkConfig(linkName, (Function1 & Serializable)props -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManagerTest.$anonfun$testReconfigure$2(props))), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)javaLinkId), (Object)new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false))})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().fetcherManager(linkId));
        this.clusterLinkManager().createClusterLink(new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false), this.clusterLinkConfig(), this.clusterLinkPersistentProps());
        ClusterLinkFactory.FetcherManager fetcherManager = (ClusterLinkFactory.FetcherManager)this.clusterLinkManager().fetcherManager(linkId).get();
        Assertions.assertEquals(Collections.singletonList("localhost:1234"), (Object)fetcherManager.currentConfig().bootstrapServers());
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).clusterLinkExists(linkId);
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "localhost:5678");
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, newProps, x$3);
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
        Mockito.when((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.ClusterLink(), javaLinkId.toString())).thenReturn((Object)newProps);
        this.clusterLinkManager().updateClusterLinkConfig(linkName, (Function1 & Serializable)props -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManagerTest.$anonfun$testReconfigure$3(props)));
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).getEntityConfigs(ConfigType$.MODULE$.ClusterLink(), javaLinkId.toString());
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.ClusterLink(), javaLinkId.toString())).thenReturn((Object)newProps);
        Mockito.when((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)javaLinkId), (Object)new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false))})));
        ((KafkaZkClient)Mockito.doNothing().when((Object)this.zkClient())).setOrCreateEntityConfigs((String)ArgumentMatchers.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)ArgumentMatchers.eq((Object)linkId.toString()), (Properties)ArgumentMatchers.any(Properties.class));
        this.clusterLinkManager().updateClusterLinkConfig(linkName, (Function1 & Serializable)props -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManagerTest.$anonfun$testReconfigure$4(props)));
        ArgumentCaptor capturedProps = ArgumentCaptor.forClass(Properties.class);
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).setOrCreateEntityConfigs((String)ArgumentMatchers.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)ArgumentMatchers.eq((Object)javaLinkId.toString()), (Properties)capturedProps.capture());
        ClusterLinkManager qual$2 = this.clusterLinkManager();
        Properties x$5 = (Properties)capturedProps.getValue();
        boolean x$6 = qual$2.processClusterLinkChanges$default$3();
        qual$2.processClusterLinkChanges(linkId, x$5, x$6);
        Assertions.assertEquals(Collections.singletonList("localhost:1234"), (Object)fetcherManager.currentConfig().bootstrapServers());
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).clusterLinkExists(linkId);
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).getEntityConfigs(ConfigType$.MODULE$.ClusterLink(), javaLinkId.toString());
    }

    @Test
    public void testConnectionManager() {
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists((Uuid)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.verifyConnectionManager$1(ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (Option)None$.MODULE$, ClusterLinkOutboundConnectionManager.class, false);
        this.verifyConnectionManager$1(ClusterLinkConfig.LinkMode.DESTINATION, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, (Option)None$.MODULE$, ClusterLinkInboundConnectionManager.class, true);
        this.verifyConnectionManager$1(ClusterLinkConfig.LinkMode.SOURCE, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (Option)None$.MODULE$, ClusterLinkOutboundConnectionManager.class, true);
        this.verifyConnectionManager$1(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (Option)new Some((Object)ConnectionMode.Outbound$.MODULE$), ClusterLinkOutboundConnectionManager.class, false);
        this.verifyConnectionManager$1(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (Option)new Some((Object)ConnectionMode.Inbound$.MODULE$), ClusterLinkOutboundConnectionManager.class, true);
        this.verifyConnectionManager$1(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Outbound$.MODULE$, (Option)None$.MODULE$, ClusterLinkOutboundConnectionManager.class, false);
        this.verifyConnectionManager$1(ClusterLinkConfig.LinkMode.BIDIRECTIONAL, (ConnectionMode)ConnectionMode.Inbound$.MODULE$, (Option)None$.MODULE$, ClusterLinkInboundConnectionManager.class, true);
    }

    @Test
    public void testRetentionConfigSync() {
        String linkName = "test-retention";
        Uuid linkId = Uuid.randomUuid();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Assertions.assertFalse((boolean)fetcherManager.currentConfig().useIndependentRetention());
        Properties newProps = new Properties();
        scala.collection.immutable.Set syncInclude = (scala.collection.immutable.Set)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"retention.ms", "retention.bytes"})));
        newProps.put("bootstrap.servers", "localhost:5678");
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), syncInclude.mkString(","));
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, newProps, x$3);
        Assertions.assertEquals((Object)syncInclude, (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        Assertions.assertFalse((boolean)fetcherManager.currentConfig().useIndependentRetention());
        syncInclude = (scala.collection.immutable.Set)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"segment.index.bytes"})));
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), syncInclude.mkString(","));
        ClusterLinkManager qual$2 = this.clusterLinkManager();
        boolean x$6 = qual$2.processClusterLinkChanges$default$3();
        qual$2.processClusterLinkChanges(linkId, newProps, x$6);
        Assertions.assertEquals((Object)syncInclude, (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        Assertions.assertTrue((boolean)fetcherManager.currentConfig().useIndependentRetention());
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
    }

    @Test
    public void testTopicConfigSyncIncludeCompatibility() {
        this.verifyDefault();
        this.verifyZKHasMalformedConfigs();
        this.verifyZKHasUnknownConfigs();
        this.verifyZKMissesAlwaysConfigs();
        this.verifyZKHasIndependentConfigs();
    }

    private void verifyDefault() {
        String linkName = "test-default";
        Uuid linkId = Uuid.randomUuid();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "localhost:5678");
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, newProps, x$3);
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.ListHasAsScala(MirrorTopicConfigSyncRules$.MODULE$.SyncIncludeDefault()).asScala().toSet(), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
    }

    private void verifyZKHasMalformedConfigs() {
        String linkName = "test-malformed";
        Uuid linkId = Uuid.randomUuid();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "localhost:5678");
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), new StringBuilder(22).append(this.topicConfigSyncIncludeDefault()).append(" min.compaction.lag.ms").toString());
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, newProps, x$3);
        Assertions.assertEquals(Collections.singletonList("localhost:1234"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.ListHasAsScala(MirrorTopicConfigSyncRules$.MODULE$.SyncIncludeDefault()).asScala().toSet(), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
    }

    private void verifyZKHasUnknownConfigs() {
        String linkName = "test-unknown";
        Uuid linkId = Uuid.randomUuid();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "localhost:5678");
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), new StringBuilder(21).append(this.topicConfigSyncIncludeDefault()).append(",unknown.topic.config").toString());
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, newProps, x$3);
        Assertions.assertEquals(Collections.singletonList("localhost:1234"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.ListHasAsScala(MirrorTopicConfigSyncRules$.MODULE$.SyncIncludeDefault()).asScala().toSet(), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
    }

    private void verifyZKMissesAlwaysConfigs() {
        String linkName = "test-always";
        Uuid linkId = Uuid.randomUuid();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        String topicConfigSyncIncludeOverride = "min.compaction.lag.ms";
        newProps.put("bootstrap.servers", "localhost:5678");
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), topicConfigSyncIncludeOverride);
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, newProps, x$3);
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"min.compaction.lag.ms"}))), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
    }

    private void verifyZKHasIndependentConfigs() {
        String linkName = "test-independent";
        Uuid linkId = Uuid.randomUuid();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        String topicConfigSyncIncludeOverride = MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.tier.enable"}))).mkString(",");
        newProps.put("bootstrap.servers", "localhost:5678");
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), topicConfigSyncIncludeOverride);
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, newProps, x$3);
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs(), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
    }

    public ClusterLinkFactory.FetcherManager createClusterLink(String linkName, Uuid linkId, Properties clusterLinkProps) {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.clusterLinkManager().updateClusterLinkConfig(linkName, (Function1 & Serializable)props -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManagerTest.$anonfun$createClusterLink$2(props))), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
        UUID javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)javaLinkId), (Object)new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false))})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().fetcherManager(linkId));
        this.clusterLinkManager().createClusterLink(new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false), this.clusterLinkConfig(), clusterLinkProps);
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).clusterLinkExists(linkId);
        return (ClusterLinkFactory.FetcherManager)this.clusterLinkManager().fetcherManager(linkId).get();
    }

    @Test
    public void testFailedAddClusterLink() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        Assertions.assertTrue((boolean)this.clusterLinkManager().resolveLinkId(linkName).isEmpty());
        Assertions.assertTrue((boolean)this.clusterLinkManager().listClusterLinks().isEmpty());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.zkClient().createClusterLink(clusterLinkData);
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new RuntimeException("")});
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.clusterLinkManager().createClusterLink(clusterLinkData, this.clusterLinkConfig(), this.clusterLinkPersistentProps()), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 493));
        Assertions.assertTrue((boolean)this.clusterLinkManager().resolveLinkId(linkName).isEmpty());
        Assertions.assertTrue((boolean)this.clusterLinkManager().listClusterLinks().isEmpty());
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).clusterLinkExists(linkId);
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).createClusterLink(clusterLinkData);
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.clusterLinkManager().createClusterLink(clusterLinkData, this.clusterLinkConfig(), this.clusterLinkPersistentProps());
        Assertions.assertEquals((Object)new Some((Object)linkId), (Object)this.clusterLinkManager().resolveLinkId(linkName));
        Assertions.assertEquals((Object)new .colon.colon((Object)clusterLinkData, (List)Nil$.MODULE$), (Object)this.clusterLinkManager().listClusterLinks());
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).clusterLinkExists(linkId);
    }

    @Test
    public void testReconfigureNonRetriableFailure() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        UUID javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId);
        String clusterId = "testClusterId";
        KafkaException testException = new KafkaException("Test exception");
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        Mockito.when((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)javaLinkId), (Object)clusterLinkData)})));
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "");
        this.clusterLinkManager().configEncoder_$eq((ClusterLinkConfigEncoder)Mockito.mock(ClusterLinkConfigEncoder.class));
        Mockito.when((Object)this.clusterLinkManager().configEncoder().encode((Properties)ArgumentMatchers.any())).thenThrow(new Throwable[]{testException});
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, newProps, x$3);
        Assertions.assertEquals((Object)FailedClusterLink$.MODULE$, (Object)this.clusterLinkManager().linkState(linkName));
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetryReconfigureRetriableFailureOnLinkRunning() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        UUID javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId);
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        Mockito.when((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)javaLinkId), (Object)clusterLinkData)})));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.clusterLinkManager().createClusterLink(clusterLinkData, this.clusterLinkConfig(), this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "");
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, newProps, x$3);
        Assertions.assertEquals((Object)FailedClusterLink$.MODULE$, (Object)this.clusterLinkManager().linkState(linkName));
        Assertions.assertEquals((Object)UnresolvableBootstrapUnavailableLinkReason$.MODULE$, (Object)((ClusterLinkInfo)this.clusterLinkManager().clusterLinkInfo(linkName).get()).linkStateInfo().unavailableLinkReason().get());
        Assertions.assertTrue((this.getClusterLinkFailedAttempts(this.clusterLinkManager(), linkId) > 0L ? 1 : 0) != 0);
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})));
        Assertions.assertTrue((boolean)this.clusterLinkManager().linkPropertiesCache().get((Object)linkId).nonEmpty());
        this.clusterLinkManager().updateLinkPropertiesCache(linkId, this.clusterLinkPersistentProps());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testRetryReconfigureRetriableFailureOnLinkRunning$1(this, linkId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Cluster link retry candidate not removed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)ActiveClusterLink$.MODULE$, (Object)this.clusterLinkManager().linkState(linkName));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetryReconfigureRetriableFailureOnLinkStartup() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        UUID javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId);
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        ClusterLinkMetadataManager oldMetaManager = this.clusterLinkManager().metadataManager();
        this.clusterLinkManager().metadataManager_$eq((ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class));
        Mockito.when((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)javaLinkId), (Object)clusterLinkData)})));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.clusterLinkManager().metadataManager().getClusterLinkData(linkId)).thenReturn((Object)Option$.MODULE$.apply((Object)clusterLinkData));
        Mockito.when((Object)this.clusterLinkManager().metadataManager().metadataCache()).thenReturn((Object)metadataCache);
        Mockito.when((Object)metadataCache.metadataVersion()).thenReturn((Object)MetadataVersion.MINIMUM_BOOTSTRAP_VERSION);
        Properties props = new Properties();
        props.put("bootstrap.servers", "");
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, props, x$3);
        Assertions.assertEquals((Object)FailedClusterLink$.MODULE$, (Object)this.clusterLinkManager().linkState(linkName));
        Assertions.assertEquals((Object)UnresolvableBootstrapUnavailableLinkReason$.MODULE$, (Object)((ClusterLinkInfo)this.clusterLinkManager().clusterLinkInfo(linkName).get()).linkStateInfo().unavailableLinkReason().get());
        Assertions.assertTrue((boolean)this.clusterLinkManager().linkPropertiesCache().get((Object)linkId).nonEmpty());
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "localhost:1234");
        this.clusterLinkManager().updateLinkPropertiesCache(linkId, newProps);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testRetryReconfigureRetriableFailureOnLinkStartup$1(this, linkId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Cluster link retry candidate not removed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)ActiveClusterLink$.MODULE$, (Object)this.clusterLinkManager().linkState(linkName));
        this.clusterLinkManager().metadataManager_$eq(oldMetaManager);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteClusterLink() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        UUID javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId);
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, true);
        Mockito.when((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)javaLinkId), (Object)clusterLinkData)})));
        Mockito.when((Object)this.zkClient().getAllTopicsInCluster(this.zkClient().getAllTopicsInCluster$default$1())).thenReturn((Object)Predef$.MODULE$.Set().empty());
        Assertions.assertEquals((Object)UnavailableClusterLink$.MODULE$, (Object)this.clusterLinkManager().linkState(linkName));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)this.clusterLinkManager().clearMirrorTopics().keySet());
        scala.collection.mutable.Map managers = (scala.collection.mutable.Map)TestUtils.fieldValue((Object)this.clusterLinkManager(), ClusterLinkManager.class, (String)"managers");
        Assertions.assertEquals((Object)Map$.MODULE$.empty(), (Object)managers);
        ClusterLinkManager qual$1 = this.clusterLinkManager();
        Properties x$2 = new Properties();
        boolean x$3 = qual$1.processClusterLinkChanges$default$3();
        qual$1.processClusterLinkChanges(linkId, x$2, x$3);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{linkId})), (Object)this.clusterLinkManager().clearMirrorTopics().keySet());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testDeleteClusterLink$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Cluster link not removed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testDynamicFetchSize() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        FetchResponseSize defaultSize = new FetchResponseSize(Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchMaxBytes()), Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchResponseMaxBytes()));
        Assertions.assertEquals((Object)defaultSize, (Object)this.clusterLinkManager().fetchResponseSize(this.clusterLinkConfig()));
        Uuid linkId = Uuid.randomUuid();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.clusterLinkManager().createClusterLink(new ClusterLinkData("link", linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false), this.clusterLinkConfig(), this.clusterLinkPersistentProps());
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)this.clusterLinkManager().fetcherManager(linkId).get();
        Assertions.assertEquals((int)0, (int)fetcherManager.fetcherThreadCount());
        this.verifyFetchSize$1(defaultSize, props);
        ((KafkaZkClient)Mockito.verify((Object)this.zkClient())).clusterLinkExists(linkId);
        props.setProperty("confluent.cluster.link.fetch.response.total.bytes", "10000");
        this.verifyFetchSize$1(new FetchResponseSize(5000, 10000), props);
        props.setProperty("confluent.cluster.link.fetch.response.min.bytes", "6000");
        this.verifyFetchSize$1(new FetchResponseSize(6000, 10000), props);
        props.setProperty("confluent.cluster.link.fetch.response.total.bytes", Integer.toString(Integer.MAX_VALUE));
        this.verifyFetchSize$1(defaultSize, props);
        ClusterLinkFetcherThread thread = (ClusterLinkFetcherThread)Mockito.mock(ClusterLinkFetcherThread.class);
        IntRef numThreads = IntRef.create((int)0);
        props.setProperty("confluent.cluster.link.fetch.response.total.bytes", Integer.toString(Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchResponseMaxBytes()) * 6));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            ++numThreads$1.elem;
            fetcherManager.fetcherThreadMap().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new FetcherTag(0, numThreads$1.elem, (FetcherPool)FetcherPool.Default$.MODULE$)), (Object)thread));
            this.verifyFetchSize$1(new FetchResponseSize(Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchMaxBytes()), Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchResponseMaxBytes())), props);
        });
        props.setProperty("confluent.cluster.link.fetch.response.total.bytes", "10000");
        props.setProperty("confluent.cluster.link.fetch.response.min.bytes", "1");
        this.verifyFetchSize$1(new FetchResponseSize(1000, 2000), props);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> ClusterLinkManagerTest.addFetcherThread$1(numThreads, fetcherManager, thread));
        this.verifyFetchSize$1(new FetchResponseSize(500, 1000), props);
        fetcherManager.fetcherThreadMap().clear();
        this.verifyFetchSize$1(new FetchResponseSize(5000, 10000), props);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClusterLinkConfigReencryption() {
        String linkName = "link1";
        UUID linkId = UUID.randomUUID();
        KafkaException testException = new KafkaException("Test exception");
        this.setupZkClient$1(linkId, linkName);
        this.zkClient().transformEntityConfigs((String)ArgumentMatchers.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)ArgumentMatchers.eq((Object)linkId.toString()), (Function1)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{testException});
        ClusterLinkManager clm1 = this.recreateClusterLinkManager$1(Long.MAX_VALUE);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$1(clm1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Retry not scheduled after failure");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        clm1.shutdown();
        this.setupZkClient$1(linkId, linkName);
        ((KafkaZkClient)Mockito.doNothing().when((Object)this.zkClient())).transformEntityConfigs((String)ArgumentMatchers.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)ArgumentMatchers.eq((Object)linkId.toString()), (Function1)ArgumentMatchers.any());
        ClusterLinkManager clm2 = this.recreateClusterLinkManager$1(Long.MAX_VALUE);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$3(clm2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Unnecessary retry scheduled");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        clm2.shutdown();
        this.setupZkClient$1(linkId, linkName);
        ((KafkaZkClient)Mockito.doNothing().when((Object)this.zkClient())).transformEntityConfigs((String)ArgumentMatchers.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)ArgumentMatchers.eq((Object)linkId.toString()), (Function1)ArgumentMatchers.any());
        ClusterLinkManager clm3 = this.recreateClusterLinkManager$1(30000L);
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$5(clm3)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Old encoder delete not scheduled");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        clm3.shutdown();
        this.setupZkClient$1(linkId, linkName);
        ((KafkaZkClient)Mockito.doNothing().when((Object)this.zkClient())).transformEntityConfigs((String)ArgumentMatchers.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)ArgumentMatchers.eq((Object)linkId.toString()), (Function1)ArgumentMatchers.any());
        ClusterLinkManager clm4 = this.recreateClusterLinkManager$1(1L);
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 15000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$7(clm4)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"Unnecessary delete retry scheduled");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        clm4.shutdown();
        this.setupZkClient$1(linkId, linkName);
        ((KafkaZkClient)Mockito.doNothing().doThrow(new Throwable[]{testException}).when((Object)this.zkClient())).transformEntityConfigs((String)ArgumentMatchers.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)ArgumentMatchers.eq((Object)linkId.toString()), (Function1)ArgumentMatchers.any());
        ClusterLinkManager clm5 = this.recreateClusterLinkManager$1(1L);
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs5 = 15000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$9(clm5)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"Delete retry not scheduled");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        clm5.shutdown();
    }

    @Test
    public void testLeaderAndIsrBeforeLinkUpdate() {
        String linkName = "testLink";
        Uuid linkId = Uuid.randomUuid();
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        String topic = "testTopic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        Partition partition0 = (Partition)Mockito.mock(Partition.class);
        this.setupMock(partition0, tp0, (Option<Uuid>)new Some((Object)linkId));
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        Mockito.when((Object)this.replicaManager().metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)this.replicaManager().zkClient()).thenReturn((Object)new Some((Object)this.zkClient()));
        Mockito.when((Object)this.replicaManager().leaderPartitionsIterator()).thenReturn((Object)((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))).iterator());
        Assertions.assertEquals((int)0, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))));
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
        ((ClusterLinkFetcherManager)Mockito.doNothing().when((Object)fetcherManager)).addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0})));
        ((ClusterLinkFetcherManager)Mockito.doNothing().when((Object)fetcherManager)).shutdown();
        ClusterLinkOutboundConnectionManager connectionManager = (ClusterLinkOutboundConnectionManager)Mockito.mock(ClusterLinkOutboundConnectionManager.class);
        Mockito.when((Object)connectionManager.currentConfig()).thenReturn((Object)this.clusterLinkConfig());
        Mockito.when((Object)connectionManager.linkData()).thenReturn((Object)new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false));
        ((ClusterLinkOutboundConnectionManager)Mockito.doNothing().when((Object)connectionManager)).shutdown();
        ClusterLinkDestClientManager clientManager = (ClusterLinkDestClientManager)Mockito.mock(ClusterLinkDestClientManager.class);
        ((AbstractClusterLinkClientManager)Mockito.doNothing().when((Object)clientManager)).shutdown();
        ClusterLinkManager.Managers managers = new ClusterLinkManager.Managers((Option)new Some((Object)fetcherManager), (ClusterLinkFactory.ClientManager)clientManager, (ClusterLinkFactory.ConnectionManager)connectionManager, null);
        this.clusterLinkManager().commitAddClusterLink(clusterLinkData, managers, ClusterLinkConfig.LinkMode.DESTINATION);
        ((ClusterLinkFetcherManager)Mockito.verify((Object)fetcherManager)).addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0})));
    }

    private KafkaConfig createBrokerConfig() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public long getClusterLinkFailedAttempts(ClusterLinkManager clusterLinkManager, Uuid linkId) {
        Option option = clusterLinkManager.linkRetryCandidates().get((Object)linkId);
        if (option instanceof Some) {
            return ((ClusterLinkRetryState)((Some)option).value()).getFailedAttempts();
        }
        if (None$.MODULE$.equals(option)) {
            return 0L;
        }
        throw new MatchError((Object)option);
    }

    private Properties clusterLinkPersistentProps() {
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:1234");
        return props;
    }

    private ClusterLinkConfig clusterLinkConfig() {
        return ClusterLinkConfig$.MODULE$.create((java.util.Map)this.clusterLinkPersistentProps(), true);
    }

    private void setupMock(Partition partition, TopicPartition tp, Option<Uuid> linkId) {
        Mockito.reset((Object[])new Partition[]{partition});
        Mockito.when((Object)partition.topicPartition()).thenReturn((Object)tp);
        Mockito.when((Object)partition.getClusterLinkId()).thenReturn(linkId);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isActiveLinkDestinationLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)linkId.nonEmpty()));
        Mockito.when((Object)partition.getLinkedLeaderEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
        PartitionState partitionState = (PartitionState)Mockito.mock(PartitionState.class);
        Mockito.when((Object)partitionState.clusterLink()).thenReturn((Object)linkId.map((Function1 & Serializable)id -> new ClusterLinkState(id, (TopicLinkState)TopicLinkMirror$.MODULE$, null)));
        Mockito.when((Object)partition.partitionState()).thenReturn((Object)partitionState);
    }

    private ClusterLinkManager createClusterLinkManager(KafkaConfig brokerConfig, MetadataSupport metadataSupport) {
        boolean isMultiTenant = ConfluentConfigs.buildMultitenantMetadata((java.util.Map)brokerConfig.values(), (Metrics)this.metrics()) != null;
        ClusterLinkFactory.LinkManager manager = ClusterLinkFactory$.MODULE$.createLinkManager(brokerConfig, "clusterId", (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, this.metrics(), (Time)this.time(), isMultiTenant, (Option)None$.MODULE$);
        Endpoint brokerEndpoint = new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 1234);
        AuthorizerServerInfo serverInfo = (AuthorizerServerInfo)Mockito.mock(AuthorizerServerInfo.class);
        Mockito.when((Object)serverInfo.interBrokerEndpoint()).thenReturn((Object)brokerEndpoint);
        Mockito.when((Object)serverInfo.endpoints()).thenReturn(Collections.singleton(brokerEndpoint));
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)socketServer.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT)))).thenReturn((Object)BoxesRunTime.boxToInteger((int)1234));
        manager.initialize(serverInfo, socketServer, (Option)None$.MODULE$, metadataSupport, null, this.replicaManager(), (Option)None$.MODULE$);
        manager.startup();
        return (ClusterLinkManager)manager;
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinks$4(ClusterLinkManagerTest $this, Uuid linkId$1) {
        return $this.clusterLinkManager().fetcherManager(linkId$1).isEmpty() && $this.clusterLinkManager().clientManager(linkId$1).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinks$5(Uuid linkId$1) {
        return new StringBuilder(38).append("Linked fetcher/client for ").append(linkId$1).append(" not removed").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testReconfigure$2(Properties props) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testReconfigure$3(Properties props) {
        props.put("bootstrap.servers", "localhost:1234");
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testReconfigure$4(Properties props) {
        props.put("bootstrap.servers", "localhost:1234");
        return true;
    }

    private final void verifyConnectionManager$1(ClusterLinkConfig.LinkMode linkMode, ConnectionMode connectionMode, Option remoteConnectionMode, Class expectedClass, boolean reverseEnabled) {
        Properties linkProps = new Properties();
        linkProps.put("bootstrap.servers", "localhost:1234");
        linkProps.put(ClusterLinkConfig$.MODULE$.LinkModeProp(), linkMode.name());
        linkProps.put(ClusterLinkConfig$.MODULE$.ConnectionModeProp(), connectionMode.name());
        remoteConnectionMode.foreach((Function1 & Serializable)mode -> linkProps.put(ClusterLinkConfig$.MODULE$.RemoteLinkConnectionModeProp(), mode.name()));
        linkProps.put(ClusterLinkConfig$.MODULE$.LocalListenerNameProp(), "PLAINTEXT");
        ClusterLinkData linkData = new ClusterLinkData(new StringBuilder(7).append("link-").append(linkMode).append("-").append(connectionMode).append("-").append(remoteConnectionMode).toString(), Uuid.randomUuid(), (Option)new Some((Object)"testClusterId"), (Option)None$.MODULE$, false);
        this.clusterLinkManager().createClusterLink(linkData, ClusterLinkConfig$.MODULE$.create((java.util.Map)linkProps, true), linkProps);
        ClusterLinkFactory.ConnectionManager connManager = (ClusterLinkFactory.ConnectionManager)this.clusterLinkManager().connectionManager(linkData.linkId()).get();
        Assertions.assertEquals((Object)expectedClass, connManager.getClass());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)reverseEnabled), (Object)BoxesRunTime.boxToBoolean((boolean)((ClusterLinkConnectionManager)connManager).reverseConnectionEnabled()));
    }

    public static final /* synthetic */ boolean $anonfun$createClusterLink$2(Properties props) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testRetryReconfigureRetriableFailureOnLinkRunning$1(ClusterLinkManagerTest $this, Uuid linkId$2) {
        return $this.clusterLinkManager().linkRetryCandidates().get((Object)linkId$2).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testRetryReconfigureRetriableFailureOnLinkRunning$2() {
        return "Cluster link retry candidate not removed";
    }

    public static final /* synthetic */ boolean $anonfun$testRetryReconfigureRetriableFailureOnLinkStartup$1(ClusterLinkManagerTest $this, Uuid linkId$3) {
        return $this.clusterLinkManager().linkRetryCandidates().get((Object)linkId$3).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testRetryReconfigureRetriableFailureOnLinkStartup$2() {
        return "Cluster link retry candidate not removed";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteClusterLink$1(ClusterLinkManagerTest $this) {
        return $this.clusterLinkManager().clearMirrorTopics().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDeleteClusterLink$2() {
        return "Cluster link not removed";
    }

    private final void verifyFetchSize$1(FetchResponseSize expectedSize, Properties props$1) {
        this.brokerConfig().updateCurrentConfig(KafkaConfig$.MODULE$.fromProps(props$1));
        this.clusterLinkManager().updateDynamicFetchSize();
        Assertions.assertEquals((Object)expectedSize, (Object)this.clusterLinkManager().fetchResponseSize(this.clusterLinkConfig()));
    }

    private static final void addFetcherThread$1(IntRef numThreads$1, ClusterLinkFetcherManager fetcherManager$1, ClusterLinkFetcherThread thread$1) {
        ++numThreads$1.elem;
        fetcherManager$1.fetcherThreadMap().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new FetcherTag(0, numThreads$1.elem, (FetcherPool)FetcherPool.Default$.MODULE$)), (Object)thread$1));
    }

    private final void setupZkClient$1(UUID linkId$4, String linkName$4) {
        Mockito.reset((Object[])new KafkaZkClient[]{this.zkClient()});
        Mockito.when((Object)this.zkClient().getChildren("/cluster_links")).thenReturn((Object)new .colon.colon((Object)linkId$4.toString(), (List)Nil$.MODULE$));
        Mockito.when((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{linkId$4})))).thenReturn(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkId$4), (Object)new ClusterLinkData(linkName$4, CoreUtils$.MODULE$.toKafkaUUID(linkId$4), (Option)None$.MODULE$, (Option)None$.MODULE$, false))})));
    }

    private final ClusterLinkManager recreateClusterLinkManager$1(long oldSecretTtl) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        props.put("confluent.password.encoder.old.secret.ttl.ms", Long.toString(oldSecretTtl));
        return this.createClusterLinkManager(KafkaConfig$.MODULE$.fromProps(props), (MetadataSupport)this.zkSupport());
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$1(ClusterLinkManager clm1$1) {
        return clm1$1.scheduledTasks().size() == 1 && BoxesRunTime.unboxToInt((Object)clm1$1.scheduledTasks().apply((Object)"Re-encryptCredentials")) == 1;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$2() {
        return "Retry not scheduled after failure";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$3(ClusterLinkManager clm2$1) {
        return clm2$1.scheduledTasks().size() == 0;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$4() {
        return "Unnecessary retry scheduled";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$5(ClusterLinkManager clm3$1) {
        return clm3$1.scheduledTasks().size() == 1 && BoxesRunTime.unboxToInt((Object)clm3$1.scheduledTasks().apply((Object)"DeleteCredentialsEncryptedUsingOldSecret")) == 1;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$6() {
        return "Old encoder delete not scheduled";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$7(ClusterLinkManager clm4$1) {
        return clm4$1.scheduledTasks().size() == 1 && BoxesRunTime.unboxToInt((Object)clm4$1.scheduledTasks().apply((Object)"DeleteCredentialsEncryptedUsingOldSecret")) == 1;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$8() {
        return "Unnecessary delete retry scheduled";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$9(ClusterLinkManager clm5$1) {
        return clm5$1.scheduledTasks().size() == 1 && BoxesRunTime.unboxToInt((Object)clm5$1.scheduledTasks().apply((Object)"DeleteCredentialsEncryptedUsingOldSecret")) == 2;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$10() {
        return "Delete retry not scheduled";
    }

    /*
     * WARNING - void declaration
     */
    public ClusterLinkManagerTest() {
        void zkMetadataCache_isMultiTenant;
        void zkMetadataCache_kraftControllerNodes;
        void zkMetadataCache_brokerFeatures;
        boolean bl = false;
        Seq seq = (Seq)Seq$.MODULE$.empty();
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createEmpty();
        MetadataVersion zkMetadataCache_metadataVersion = this.brokerConfig().interBrokerProtocolVersion();
        int zkMetadataCache_brokerId = 0;
        Object var2_4 = null;
        brokerFeatures = null;
        seq = null;
        this.metadataCache = new ZkMetadataCache(zkMetadataCache_brokerId, zkMetadataCache_metadataVersion, (BrokerFeatures)zkMetadataCache_brokerFeatures, (Seq)zkMetadataCache_kraftControllerNodes, (boolean)zkMetadataCache_isMultiTenant);
        this.topicConfigSyncIncludeDefault = CollectionConverters$.MODULE$.ListHasAsScala(ClusterLinkConfigDefaults$.MODULE$.TopicConfigSyncIncludeDefault()).asScala().mkString(",");
    }
}

