/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.MetadataRefreshListener;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005I4A!\u0005\n\u00013!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001b\u0001\n\u0013)\u0003BB\u0019\u0001A\u0003%a\u0005C\u00043\u0001\t\u0007I\u0011B\u001a\t\rq\u0002\u0001\u0015!\u00035\u0011\u001di\u0004A1A\u0005\nyBaa\u0011\u0001!\u0002\u0013y\u0004b\u0002#\u0001\u0005\u0004%I!\u0012\u0005\u0007\u0013\u0002\u0001\u000b\u0011\u0002$\t\u0013)\u0003\u0001\u0019!a\u0001\n\u0013Y\u0005\"\u0003+\u0001\u0001\u0004\u0005\r\u0011\"\u0003V\u0011%Y\u0006\u00011A\u0001B\u0003&A\nC\u0003]\u0001\u0011\u0005Q\fC\u0003j\u0001\u0011\u0005Q\fC\u0003o\u0001\u0011\u0005Q\fC\u0003q\u0001\u0011\u0005QLA\fDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018\rV3ti*\u00111\u0003F\u0001\u0005Y&t7N\u0003\u0002\u0016-\u000511/\u001a:wKJT\u0011aF\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0004\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0002\"a\t\u0001\u000e\u0003I\ta\u0001\\5oW&#W#\u0001\u0014\u0011\u0005\u001dzS\"\u0001\u0015\u000b\u0005%R\u0013AB2p[6|gN\u0003\u0002\u0018W)\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0013\t\u0001\u0004F\u0001\u0003Vk&$\u0017a\u00027j].LE\rI\u0001\tY&t7NT1nKV\tA\u0007\u0005\u00026u5\taG\u0003\u00028q\u0005!A.\u00198h\u0015\u0005I\u0014\u0001\u00026bm\u0006L!a\u000f\u001c\u0003\rM#(/\u001b8h\u0003%a\u0017N\\6OC6,\u0007%\u0001\u0007ce>\\WM]\"p]\u001aLw-F\u0001@!\t\u0001\u0015)D\u0001\u0015\u0013\t\u0011ECA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!\u00042s_.,'oQ8oM&<\u0007%\u0001\u0005nKR\fG-\u0019;b+\u00051\u0005CA\u0012H\u0013\tA%CA\nDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-A\u0005nKR\fG-\u0019;bA\u0005AQ\r_3dkR|'/F\u0001M!\ti%+D\u0001O\u0015\ty\u0005+\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u0015\u001d\u0002\tU$\u0018\u000e\\\u0005\u0003':\u0013q\"\u0012=fGV$xN]*feZL7-Z\u0001\rKb,7-\u001e;pe~#S-\u001d\u000b\u0003-f\u0003\"aG,\n\u0005ac\"\u0001B+oSRDqAW\u0006\u0002\u0002\u0003\u0007A*A\u0002yIE\n\u0011\"\u001a=fGV$xN\u001d\u0011\u0002\u0011Q,\u0017M\u001d#po:$\u0012A\u0016\u0015\u0003\u001b}\u0003\"\u0001Y4\u000e\u0003\u0005T!AY2\u0002\u0007\u0005\u0004\u0018N\u0003\u0002eK\u00069!.\u001e9ji\u0016\u0014(B\u00014.\u0003\u0015QWO\\5u\u0013\tA\u0017MA\u0005BMR,'/R1dQ\u0006\u0019B/Z:u%\u00164'/Z:i\u0019&\u001cH/\u001a8fe\"\u0012ab\u001b\t\u0003A2L!!\\1\u0003\tQ+7\u000f^\u0001#i\u0016\u001cHOU3ge\u0016\u001c\b\u000eT5ti\u0016tWM]*z]\u000eD'o\u001c8ju\u0006$\u0018n\u001c8)\u0005=Y\u0017A\u0005;fgRlU\r^1eCR\fGk\u001c9jGND#\u0001E6")
public class ClusterLinkMetadataTest {
    private final Uuid linkId = Uuid.randomUuid();
    private final String linkName;
    private final KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
    private final ClusterLinkMetadata kafka$server$link$ClusterLinkMetadataTest$$metadata = new ClusterLinkMetadata(this.brokerConfig(), this.linkName(), this.linkId(), ClusterLinkConfig.LinkMode.DESTINATION, 100L, 60000L);
    private ExecutorService kafka$server$link$ClusterLinkMetadataTest$$executor;

    private Uuid linkId() {
        return this.linkId;
    }

    private String linkName() {
        return this.linkName;
    }

    private KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    public ClusterLinkMetadata kafka$server$link$ClusterLinkMetadataTest$$metadata() {
        return this.kafka$server$link$ClusterLinkMetadataTest$$metadata;
    }

    public ExecutorService kafka$server$link$ClusterLinkMetadataTest$$executor() {
        return this.kafka$server$link$ClusterLinkMetadataTest$$executor;
    }

    private void executor_$eq(ExecutorService x$1) {
        this.kafka$server$link$ClusterLinkMetadataTest$$executor = x$1;
    }

    @AfterEach
    public void tearDown() {
        this.kafka$server$link$ClusterLinkMetadataTest$$metadata().close();
        if (this.kafka$server$link$ClusterLinkMetadataTest$$executor() != null) {
            this.kafka$server$link$ClusterLinkMetadataTest$$executor().shutdownNow();
            return;
        }
    }

    @Test
    public void testRefreshListener() {
        IntRef requestCount = IntRef.create((int)0);
        MetadataRefreshListener listener = new MetadataRefreshListener(null, requestCount){
            private final IntRef requestCount$1;

            public void onMetadataRequestUpdate() {
                ++this.requestCount$1.elem;
            }
            {
                this.requestCount$1 = requestCount$1;
            }
        };
        this.kafka$server$link$ClusterLinkMetadataTest$$metadata().setRefreshListener(listener);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            this.kafka$server$link$ClusterLinkMetadataTest$$metadata().requestUpdate();
            Assertions.assertEquals((int)i, (int)requestCount$1.elem);
        });
    }

    @Test
    public void testRefreshListenerSynchronization() {
        CountDownLatch latch = new CountDownLatch(1);
        this.executor_$eq(Executors.newSingleThreadExecutor());
        MetadataRefreshListener listener = new MetadataRefreshListener(this, latch){
            private final /* synthetic */ ClusterLinkMetadataTest $outer;
            private final CountDownLatch latch$1;

            public void onMetadataRequestUpdate() {
                this.$outer.kafka$server$link$ClusterLinkMetadataTest$$executor().submit(() -> {
                    ClusterLinkMetadata clusterLinkMetadata = $this.$outer.kafka$server$link$ClusterLinkMetadataTest$$metadata();
                    synchronized (clusterLinkMetadata) {
                        $this.latch$1.countDown();
                        return;
                    }
                }, BoxesRunTime.boxToInteger((int)0));
                this.latch$1.await(10L, TimeUnit.SECONDS);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        this.kafka$server$link$ClusterLinkMetadataTest$$metadata().setRefreshListener(listener);
        this.kafka$server$link$ClusterLinkMetadataTest$$metadata().requestUpdate();
        Assertions.assertEquals((long)0L, (long)latch.getCount());
    }

    @Test
    public void testMetadataTopics() {
        long nowMs = System.currentTimeMillis();
        Assertions.assertFalse((boolean)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().retainTopic("test", false, nowMs));
        Assertions.assertEquals(Collections.emptyList(), (Object)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().newMetadataRequestBuilder().topics());
        this.kafka$server$link$ClusterLinkMetadataTest$$metadata().setTopics((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test"})));
        Assertions.assertEquals(Collections.singletonList("test"), (Object)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().newMetadataRequestBuilder().topics());
        Assertions.assertTrue((boolean)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().retainTopic("test", false, nowMs));
        this.kafka$server$link$ClusterLinkMetadataTest$$metadata().setTopics((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2"})));
        Assertions.assertEquals(Arrays.asList("test1", "test2"), (Object)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().newMetadataRequestBuilder().topics());
        Assertions.assertFalse((boolean)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().retainTopic("test", false, nowMs));
        Assertions.assertTrue((boolean)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().retainTopic("test1", false, nowMs));
        Assertions.assertTrue((boolean)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().retainTopic("test2", false, nowMs));
        this.kafka$server$link$ClusterLinkMetadataTest$$metadata().setTopics((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
        Assertions.assertEquals(Collections.emptyList(), (Object)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().newMetadataRequestBuilder().topics());
        Assertions.assertFalse((boolean)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().retainTopic("test1", false, nowMs));
        Assertions.assertFalse((boolean)this.kafka$server$link$ClusterLinkMetadataTest$$metadata().retainTopic("test2", false, nowMs));
    }

    public ClusterLinkMetadataTest() {
        this.linkName = "testLink";
    }
}

