/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005U4A\u0001D\u0007\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003B\u0002\u0017\u0001A\u0003%\u0011\u0005C\u0004.\u0001\t\u0007I\u0011\u0002\u0018\t\r]\u0002\u0001\u0015!\u00030\u0011\u001dA\u0004A1A\u0005\neBa\u0001\u0011\u0001!\u0002\u0013Q\u0004\"B!\u0001\t\u0003\u0011\u0005\"B)\u0001\t\u0003\u0011\u0005\"B*\u0001\t\u0013!\u0006bB5\u0001#\u0003%IA\u001b\u0002\u001d\u00072,8\u000f^3s\u0019&t7NT3uo>\u00148n\u00117jK:$H+Z:u\u0015\tqq\"\u0001\u0003mS:\\'B\u0001\t\u0012\u0003\u0019\u0019XM\u001d<fe*\t!#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001)\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u001b\u00051A.\u001b8l\u0013\u0012,\u0012!\t\t\u0003E)j\u0011a\t\u0006\u0003I\u0015\naaY8n[>t'B\u0001\n'\u0015\t9\u0003&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0005\u0019qN]4\n\u0005-\u001a#\u0001B+vS\u0012\fq\u0001\\5oW&#\u0007%\u0001\u0005mS:\\g*Y7f+\u0005y\u0003C\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\u0011a\u0017M\\4\u000b\u0003Q\nAA[1wC&\u0011a'\r\u0002\u0007'R\u0014\u0018N\\4\u0002\u00131Lgn\u001b(b[\u0016\u0004\u0013\u0001\u0002;j[\u0016,\u0012A\u000f\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{\r\nQ!\u001e;jYNL!a\u0010\u001f\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\n\u0011\u0004^3ti2Kgn[%e\u0013:\u0014V-];fgRDU-\u00193feR\t1\t\u0005\u0002\u0017\t&\u0011Qi\u0006\u0002\u0005+:LG\u000f\u000b\u0002\t\u000fB\u0011\u0001jT\u0007\u0002\u0013*\u0011!jS\u0001\u0004CBL'B\u0001'N\u0003\u001dQW\u000f]5uKJT!A\u0014\u0015\u0002\u000b),h.\u001b;\n\u0005AK%\u0001\u0002+fgR\fa\u0003^3ti&\u001b8\t\\8vIR{7\t\\8vI2Kgn\u001b\u0015\u0003\u0013\u001d\u000bAb\u0019:fCR,7\t\\5f]R$2!\u0016-e!\tqb+\u0003\u0002X\u001b\tA2\t\\;ti\u0016\u0014H*\u001b8l\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\t\u000beS\u0001\u0019\u0001.\u0002!\t|w\u000e^:ue\u0006\u00048+\u001a:wKJ\u001c\bCA.c\u001d\ta\u0006\r\u0005\u0002^/5\taL\u0003\u0002`'\u00051AH]8pizJ!!Y\f\u0002\rA\u0013X\rZ3g\u0013\t14M\u0003\u0002b/!9QM\u0003I\u0001\u0002\u00041\u0017!\u00038fi^|'o[%e!\r1rMW\u0005\u0003Q^\u0011aa\u00149uS>t\u0017AF2sK\u0006$Xm\u00117jK:$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003-T#A\u001a7,\u00035\u0004\"A\\:\u000e\u0003=T!\u0001]9\u0002\u0013Ut7\r[3dW\u0016$'B\u0001:\u0018\u0003)\tgN\\8uCRLwN\\\u0005\u0003i>\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ClusterLinkNetworkClientTest {
    private final Uuid linkId = Uuid.randomUuid();
    private final String linkName;
    private final MockTime time = new MockTime();

    private Uuid linkId() {
        return this.linkId;
    }

    private String linkName() {
        return this.linkName;
    }

    private MockTime time() {
        return this.time;
    }

    @Test
    public void testLinkIdInRequestHeader() {
        ClusterLinkNetworkClient client = this.createClient("localhost:1234", (Option<String>)Option$.MODULE$.empty());
        Assertions.assertNotNull((Object)client.networkClient());
        ((NetworkClient)client.networkClient()).enableClusterLinkRequests(this.linkId(), null, null);
        MetadataRequest.Builder builder = new MetadataRequest.Builder(Collections.emptyList(), false);
        RequestHeader header = client.networkClient().newClientRequest("0", (AbstractRequest.Builder)builder, this.time().milliseconds(), true, 30000, null).makeHeader(ApiKeys.METADATA.latestVersion());
        Assertions.assertEquals(Optional.of(this.linkId()), (Object)header.clusterLinkId());
    }

    @Test
    public void testIsCloudToCloudLink() {
        this.testIsCloudToCloudLink$1("foo.bar.us-west2.aws.confluent.cloud:9003", (Option)new Some((Object)"nr1"), true);
        this.testIsCloudToCloudLink$1("localhost:9003", (Option)new Some((Object)"nr1"), false);
        this.testIsCloudToCloudLink$1("foo.bar.us-west2.aws.confluent.cloud:9003", (Option)new Some((Object)""), false);
        this.testIsCloudToCloudLink$1("foo.bar.us-west2.aws.confluent.cloud:9003", Option$.MODULE$.empty(), false);
        this.testIsCloudToCloudLink$1("localhost:9003", Option$.MODULE$.empty(), false);
    }

    private ClusterLinkNetworkClient createClient(String bootstrapServers, Option<String> networkId) {
        Properties testBrokerProps = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        networkId.foreach((Function1 & Serializable)nid -> testBrokerProps.put("confluent.traffic.network.id", nid));
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(testBrokerProps);
        ClusterLinkMetadata metadata = new ClusterLinkMetadata(brokerConfig, this.linkName(), this.linkId(), ClusterLinkConfig.LinkMode.DESTINATION, 100L, 60000L);
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((java.util.Map)new Properties(null, bootstrapServers){
            {
                this.put("bootstrap.servers", bootstrapServers$1);
            }
        }, true);
        return new ClusterLinkNetworkClient(brokerConfig, linkConfig, "", (Option)new Some((Object)metadata), (Option)None$.MODULE$, new Metrics(), (Map)Map$.MODULE$.empty(), (Time)this.time(), "clientId", "fetcher", new LogContext());
    }

    private Option<String> createClient$default$2() {
        return Option$.MODULE$.empty();
    }

    private final void testIsCloudToCloudLink$1(String bootstrapServers, Option networkId, boolean expectedResult) {
        ClusterLinkNetworkClient client = this.createClient(bootstrapServers, (Option<String>)networkId);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)expectedResult), (Object)BoxesRunTime.boxToBoolean((boolean)client.isCloudToCloudLink()));
    }

    public ClusterLinkNetworkClientTest() {
        this.linkName = "testLink";
    }
}

