/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkPauseMirrorTopics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.concurrent.TrieMap;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t%a\u0001\u0002\u0017.\u0001QBQa\u000f\u0001\u0005\u0002qBqa\u0010\u0001C\u0002\u0013%\u0001\t\u0003\u0004J\u0001\u0001\u0006I!\u0011\u0005\b\u0015\u0002\u0011\r\u0011\"\u0003L\u0011\u00199\u0006\u0001)A\u0005\u0019\"9\u0001\f\u0001b\u0001\n\u0013Y\u0005BB-\u0001A\u0003%A\nC\u0004[\u0001\t\u0007I\u0011\u0002!\t\rm\u0003\u0001\u0015!\u0003B\u0011\u001da\u0006A1A\u0005\n-Ca!\u0018\u0001!\u0002\u0013a\u0005b\u00020\u0001\u0005\u0004%Ia\u0018\u0005\u0007G\u0002\u0001\u000b\u0011\u00021\t\u000f\u0011\u0004!\u0019!C\u0005K\"1Q\u000e\u0001Q\u0001\n\u0019DqA\u001c\u0001C\u0002\u0013%q\u000e\u0003\u0004t\u0001\u0001\u0006I\u0001\u001d\u0005\bi\u0002\u0011\r\u0011\"\u0003v\u0011\u0019I\b\u0001)A\u0005m\")!\u0010\u0001C\u0001w\"1\u0011Q\u0003\u0001\u0005\u0002mDa!a\b\u0001\t\u0003Y\bBBA\u0015\u0001\u0011\u00051\u0010\u0003\u0004\u0002.\u0001!\ta\u001f\u0005\u0007\u0003c\u0001A\u0011A>\t\r\u0005U\u0002\u0001\"\u0001|\u0011\u0019\tI\u0004\u0001C\u0001w\"9\u0011Q\b\u0001\u0005\n\u0005}\u0002BBA&\u0001\u0011%1\u0010\u0003\u0004\u0002N\u0001!Ia\u001f\u0005\b\u0003\u001f\u0002A\u0011BA)\u0011\u001d\t9\u0006\u0001C\u0005\u00033Bq!!\u0018\u0001\t\u0013\ty\u0006C\u0004\u0002j\u0001!I!a\u001b\t\u000f\u0005m\u0004\u0001\"\u0003\u0002~!9\u0011\u0011\u0011\u0001\u0005\n\u0005\r\u0005bBAD\u0001\u0011%\u0011\u0011\u0012\u0005\b\u0003\u001b\u0003A\u0011BAH\u0011\u001d\t\t\u000b\u0001C\u0005\u0003GCq!!+\u0001\t\u0013\tY\u000bC\u0004\u0002:\u0002!I!a/\t\u000f\u0005e\u0007\u0001\"\u0003\u0002\\\"9\u0011Q\u001f\u0001\u0005\n\u0005](\u0001I\"mkN$XM\u001d'j].\u0004\u0016-^:f\u001b&\u0014(o\u001c:U_BL7m\u001d+fgRT!AL\u0018\u0002\t1Lgn\u001b\u0006\u0003aE\naa]3sm\u0016\u0014(\"\u0001\u001a\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u000e\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0004C\u0001 \u0001\u001b\u0005i\u0013\u0001\u00037j].t\u0015-\\3\u0016\u0003\u0005\u0003\"AQ$\u000e\u0003\rS!\u0001R#\u0002\t1\fgn\u001a\u0006\u0002\r\u0006!!.\u0019<b\u0013\tA5I\u0001\u0004TiJLgnZ\u0001\nY&t7NT1nK\u0002\na\u0001\\5oW&#W#\u0001'\u0011\u00055+V\"\u0001(\u000b\u0005=\u0003\u0016AB2p[6|gN\u0003\u00023#*\u0011!kU\u0001\u0007CB\f7\r[3\u000b\u0003Q\u000b1a\u001c:h\u0013\t1fJ\u0001\u0003Vk&$\u0017a\u00027j].LE\rI\u0001\u000eg>,(oY3U_BL7-\u00133\u0002\u001dM|WO]2f)>\u0004\u0018nY%eA\u0005iq\u000e\u001e5fe2Kgn\u001b(b[\u0016\fab\u001c;iKJd\u0015N\\6OC6,\u0007%A\u0006pi\",'\u000fT5oW&#\u0017\u0001D8uQ\u0016\u0014H*\u001b8l\u0013\u0012\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\u0005\u0001\u0007C\u0001 b\u0013\t\u0011WF\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013!B1e[&tW#\u00014\u0011\u0005\u001d\\W\"\u00015\u000b\u0005\u0011L'B\u00016Q\u0003\u001d\u0019G.[3oiNL!\u0001\u001c5\u0003\u001d\r{gN\u001a7vK:$\u0018\tZ7j]\u00061\u0011\rZ7j]\u0002\nq\"\\3uC\u0012\fG/Y'b]\u0006<WM]\u000b\u0002aB\u0011a(]\u0005\u0003e6\u0012!d\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ\f\u0001#\\3uC\u0012\fG/Y'b]\u0006<WM\u001d\u0011\u0002+5\f\u0007\u0010V8qS\u000e\u001c\b+\u001a:Ji\u0016\u0014\u0018\r^5p]V\ta\u000f\u0005\u00027o&\u0011\u0001p\u000e\u0002\u0004\u0013:$\u0018AF7bqR{\u0007/[2t!\u0016\u0014\u0018\n^3sCRLwN\u001c\u0011\u0002\u000bM,G/\u00169\u0015\u0003q\u0004\"AN?\n\u0005y<$\u0001B+oSRD3\u0001FA\u0001!\u0011\t\u0019!!\u0005\u000e\u0005\u0005\u0015!\u0002BA\u0004\u0003\u0013\t1!\u00199j\u0015\u0011\tY!!\u0004\u0002\u000f),\b/\u001b;fe*\u0019\u0011qB*\u0002\u000b),h.\u001b;\n\t\u0005M\u0011Q\u0001\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007U\tI\u0002\u0005\u0003\u0002\u0004\u0005m\u0011\u0002BA\u000f\u0003\u000b\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u00025Q,7\u000f\u001e)bkN,W*\u001b:s_J$v\u000e]5dg\u0016k\u0007\u000f^=)\u0007Y\t\u0019\u0003\u0005\u0003\u0002\u0004\u0005\u0015\u0012\u0002BA\u0014\u0003\u000b\u0011A\u0001V3ti\u0006QB/Z:u!\u0006,8/Z'jeJ|'\u000fV8qS\u000e\u001c\b+Y;tK\"\u001aq#a\t\u00029Q,7\u000f\u001e)bkN,W*\u001b:s_J$v\u000e]5dgVs\u0007/Y;tK\"\u001a\u0001$a\t\u0002EQ,7\u000f\u001e)bkN,W*\u001b:s_J$v\u000e]5dg:{GoQ8oiJ|G\u000e\\3sQ\rI\u00121E\u0001$i\u0016\u001cH\u000fU1vg\u0016l\u0015N\u001d:peR{\u0007/[2t!\u0006,8/Z#yG\u0016\u0004H/[8oQ\rQ\u00121E\u0001\u001di\u0016\u001cH\u000fU1vg\u0016l\u0015N\u001d:peR{\u0007/[2t\u0003\n|'\u000f^3eQ\rY\u00121E\u0001\ng\u0016$X\u000f]'pG.$2\u0001`A!\u0011\u001d\t\u0019\u0005\ba\u0001\u0003\u000b\n\u0001\"[:MK\u0006$WM\u001d\t\u0004m\u0005\u001d\u0013bAA%o\t9!i\\8mK\u0006t\u0017A\u0003:fa2\f\u00170T8dW\u0006Qa/\u001a:jMflunY6\u0002\u0015Q|G*\u001b8l\u001d\u0006lW\rF\u0002B\u0003'Bq!!\u0016 \u0001\u0004\t)%A\u0004jg>#\b.\u001a:\u0002\u0011Q|G*\u001b8l\u0013\u0012$2\u0001TA.\u0011\u001d\t)\u0006\ta\u0001\u0003\u000b\n1\"Y2uSZ,7\u000b^1uKR!\u0011\u0011MA4!\rq\u00141M\u0005\u0004\u0003Kj#!F\"mkN$XM\u001d'j].$v\u000e]5d'R\fG/\u001a\u0005\b\u0003+\n\u0003\u0019AA#\u0003-\u0001\u0018-^:fIN#\u0018\r^3\u0015\u0015\u0005\u0005\u0014QNA8\u0003g\n9\bC\u0004\u0002V\t\u0002\r!!\u0012\t\u000f\u0005E$\u00051\u0001\u0002F\u0005IA.\u001b8l\u0019\u00164X\r\u001c\u0005\b\u0003k\u0012\u0003\u0019AA#\u0003)!x\u000e]5d\u0019\u00164X\r\u001c\u0005\b\u0003s\u0012\u0003\u0019AA#\u0003%9\u0018m\u001d$bS2,G-A\u0006gC&dW\rZ*uCR,G\u0003BA1\u0003\u007fBq!!\u0016$\u0001\u0004\t)%A\nqK:$\u0017N\\4Ti>\u0004\b/\u001a3Ti\u0006$X\r\u0006\u0003\u0002b\u0005\u0015\u0005bBA+I\u0001\u0007\u0011QI\u0001\rgR|\u0007\u000f]3e'R\fG/\u001a\u000b\u0005\u0003C\nY\tC\u0004\u0002V\u0015\u0002\r!!\u0012\u0002)9,w\u000fU1vg\u0016l\u0015N\u001d:peR{\u0007/[2t)\u0011\t\t*a&\u0011\u0007y\n\u0019*C\u0002\u0002\u00166\u0012Ad\u00117vgR,'\u000fT5oWB\u000bWo]3NSJ\u0014xN\u001d+pa&\u001c7\u000fC\u0004\u0002\u001a\u001a\u0002\r!a'\u0002\u00191Lgn[%t!\u0006,8/\u001a3\u0011\u000bY\ni*!\u0012\n\u0007\u0005}uGA\u0005Gk:\u001cG/[8oa\u00059!/\u001e8P]\u000e,Gc\u0001?\u0002&\"9\u0011qU\u0014A\u0002\u0005E\u0015\u0001\u0002;bg.\fQC\\3x!\u0006,8/Z*vG\u000e,7o\u001d$viV\u0014X\r\u0006\u0002\u0002.B)Q*a,\u00024&\u0019\u0011\u0011\u0017(\u0003\u0017-\u000bgm[1GkR,(/\u001a\t\u0004\u0005\u0006U\u0016bAA\\\u0007\n!ak\\5e\u0003UqWm\u001e)bkN,g)Y5mkJ,g)\u001e;ve\u0016$B!!,\u0002>\"9\u0011qX\u0015A\u0002\u0005\u0005\u0017AA3y!\u0011\t\u0019-a5\u000f\t\u0005\u0015\u0017q\u001a\b\u0005\u0003\u000f\fi-\u0004\u0002\u0002J*\u0019\u00111Z\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0014bAAio\u00059\u0001/Y2lC\u001e,\u0017\u0002BAk\u0003/\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005Ew'\u0001\nfqB,7\r\u001e'j].,G\rV8qS\u000e\u001cHc\u0001?\u0002^\"9\u0011q\u001c\u0016A\u0002\u0005\u0005\u0018\u0001\u00047j].,G\rV8qS\u000e\u001c\b\u0003CAr\u0003W\f\t0!\u0019\u000f\t\u0005\u0015\u0018q\u001d\t\u0004\u0003\u000f<\u0014bAAuo\u00051\u0001K]3eK\u001aLA!!<\u0002p\n\u0019Q*\u00199\u000b\u0007\u0005%x\u0007\u0005\u0003\u0002d\u0006M\u0018b\u0001%\u0002p\u0006\u0011R\r\u001f9fGR\u0004\u0016-^:f\u001b&\u0014(o\u001c:t)\u0015a\u0018\u0011 B\u0003\u0011\u001d\tYp\u000ba\u0001\u0003{\faA^1mk\u0016\u001c\b\u0003CAr\u0003W\f\t0a@\u0011\u000bY\u0012\t!!1\n\u0007\t\rqG\u0001\u0004PaRLwN\u001c\u0005\b\u0005\u000fY\u0003\u0019AA#\u0003\u0019)g.\u00192mK\u0002")
public class ClusterLinkPauseMirrorTopicsTest {
    private final String linkName;
    private final Uuid linkId = Uuid.randomUuid();
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final String otherLinkName;
    private final Uuid otherLinkId = Uuid.randomUuid();
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
    private final ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)Mockito.mock(ClusterLinkMetadataManager.class);
    private final int maxTopicsPerIteration;

    private String linkName() {
        return this.linkName;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private String otherLinkName() {
        return this.otherLinkName;
    }

    private Uuid otherLinkId() {
        return this.otherLinkId;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin admin() {
        return this.admin;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private int maxTopicsPerIteration() {
        return this.maxTopicsPerIteration;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
    }

    @Test
    public void testPauseMirrorTopicsEmpty() {
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)Predef$.MODULE$.Map().empty());
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)Predef$.MODULE$.Map().empty());
        package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)isPaused -> {
            ClusterLinkPauseMirrorTopicsTest.$anonfun$testPauseMirrorTopicsEmpty$1(this, BoxesRunTime.unboxToBoolean((Object)isPaused));
            return BoxedUnit.UNIT;
        });
        this.verifyMock();
    }

    @Test
    public void testPauseMirrorTopicsPause() {
        scala.collection.immutable.Map linkedTopics = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"active"), (Object)this.activeState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic"), (Object)this.pausedState(false, false, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both"), (Object)this.pausedState(false, true, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic-failed"), (Object)this.pausedState(false, false, true, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link-failed"), (Object)this.pausedState(false, true, false, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both-failed"), (Object)this.pausedState(false, true, true, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failed"), (Object)this.failedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pending-stopped"), (Object)this.pendingStoppedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stopped"), (Object)this.stoppedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-active"), (Object)this.activeState(true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-paused-topic"), (Object)this.pausedState(true, false, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-paused-link"), (Object)this.pausedState(true, true, false, false))}));
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)linkedTopics);
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"active"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic-failed"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failed"), (Object)None$.MODULE$)}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)Predef$.MODULE$.Map().empty());
        JFunction0.mcZ.sp & Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable)() -> true;
        Object var2_2 = null;
        this.runOnce(new ClusterLinkPauseMirrorTopics(this.linkId(), this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.maxTopicsPerIteration(), 10, 10));
        this.verifyMock();
    }

    @Test
    public void testPauseMirrorTopicsUnpause() {
        scala.collection.immutable.Map linkedTopics = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"active"), (Object)this.activeState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic"), (Object)this.pausedState(false, false, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both"), (Object)this.pausedState(false, true, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic-failed"), (Object)this.pausedState(false, false, true, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link-failed"), (Object)this.pausedState(false, true, false, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both-failed"), (Object)this.pausedState(false, true, true, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failed"), (Object)this.failedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pending-stopped"), (Object)this.pendingStoppedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stopped"), (Object)this.stoppedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-active"), (Object)this.activeState(true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-paused-topic"), (Object)this.pausedState(true, false, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-paused-link"), (Object)this.pausedState(true, true, false, false))}));
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)linkedTopics);
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link-failed"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both-failed"), (Object)None$.MODULE$)}))), false);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)Predef$.MODULE$.Map().empty());
        JFunction0.mcZ.sp & Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable)() -> false;
        Object var2_2 = null;
        this.runOnce(new ClusterLinkPauseMirrorTopics(this.linkId(), this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.maxTopicsPerIteration(), 10, 10));
        this.verifyMock();
    }

    @Test
    public void testPauseMirrorTopicsNotController() {
        this.setupMock(false);
        Function0 & Serializable newPauseMirrorTopics_linkIsPaused = (Function0 & Serializable)() -> {
            throw new RuntimeException("unexpected");
        };
        Object var1_1 = null;
        this.runOnce(new ClusterLinkPauseMirrorTopics(this.linkId(), this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.maxTopicsPerIteration(), 10, 10));
        this.verifyMock();
    }

    @Test
    public void testPauseMirrorTopicsPauseException() {
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)this.activeState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)new Some((Object)new TimeoutException("")))}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)this.activeState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)new Some((Object)new TimeoutException("")))}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)None$.MODULE$)}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)this.pausedState(false, true, false, false))}))));
        JFunction0.mcZ.sp & Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable)() -> true;
        Object var1_1 = null;
        this.runOnce(new ClusterLinkPauseMirrorTopics(this.linkId(), this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.maxTopicsPerIteration(), 10, 10));
        this.verifyMock();
    }

    @Test
    public void testPauseMirrorTopicsAborted() {
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)new Some((Object)new TimeoutException("")))}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)new Some((Object)new TimeoutException("")))}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)this.activeState(false))}))));
        IntRef check = IntRef.create((int)0);
        JFunction0.mcZ.sp & Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable)() -> {
            ++check$1.elem;
            return check$1.elem < 3;
        };
        Object var2_2 = null;
        this.runOnce(new ClusterLinkPauseMirrorTopics(this.linkId(), this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.maxTopicsPerIteration(), 10, 10));
        this.verifyMock();
    }

    private void setupMock(boolean isLeader) {
        Mockito.reset((Object[])new ConfluentAdmin[]{this.admin()});
        Mockito.reset((Object[])new ClusterLinkMetadataManager[]{this.metadataManager()});
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataManager().isLinkCoordinator(ArgumentMatchers.anyString()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isLeader));
    }

    private void replayMock() {
    }

    private void verifyMock() {
        ((ClusterLinkMetadataManager)Mockito.verify((Object)this.metadataManager(), (VerificationMode)Mockito.atLeastOnce())).isLinkCoordinator(ArgumentMatchers.anyString());
    }

    private String toLinkName(boolean isOther) {
        if (isOther) {
            return this.otherLinkName();
        }
        return this.linkName();
    }

    private Uuid toLinkId(boolean isOther) {
        if (isOther) {
            return this.otherLinkId();
        }
        return this.linkId();
    }

    private ClusterLinkTopicState activeState(boolean isOther) {
        return new ClusterLinkTopicState.Mirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), 111111111L, (Seq)Seq$.MODULE$.empty());
    }

    private ClusterLinkTopicState pausedState(boolean isOther, boolean linkLevel, boolean topicLevel, boolean wasFailed) {
        MirrorTopicError failureReason = wasFailed ? MirrorTopicError.SOURCE_TOPIC_ID_CHANGED : MirrorTopicError.NO_ERROR;
        return new ClusterLinkTopicState.PausedMirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), linkLevel, topicLevel, wasFailed, failureReason, 22222222L, (Seq)Seq$.MODULE$.empty());
    }

    private ClusterLinkTopicState failedState(boolean isOther) {
        return new ClusterLinkTopicState.FailedMirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), MirrorTopicError.SOURCE_TOPIC_ID_CHANGED, 33333333L);
    }

    private ClusterLinkTopicState pendingStoppedState(boolean isOther) {
        return new ClusterLinkTopicState.PendingStoppedMirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), false, 44444444L);
    }

    private ClusterLinkTopicState stoppedState(boolean isOther) {
        return new ClusterLinkTopicState.StoppedMirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), (Seq)package$.MODULE$.Seq().empty(), 555555555L);
    }

    private ClusterLinkPauseMirrorTopics newPauseMirrorTopics(Function0<Object> linkIsPaused) {
        return new ClusterLinkPauseMirrorTopics(this.linkId(), this.linkName(), linkIsPaused, this.scheduler(), this.metadataManager(), (Function0 & Serializable)() -> this.admin(), this.maxTopicsPerIteration(), 10, 10);
    }

    private void runOnce(ClusterLinkPauseMirrorTopics task) {
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)task.runOnce().get(5L, TimeUnit.SECONDS)));
    }

    private KafkaFuture<Void> newPauseSuccessFuture() {
        return KafkaFuture.completedFuture(null);
    }

    private KafkaFuture<Void> newPauseFailureFuture(Throwable ex) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally(ex);
        return future;
    }

    private void expectLinkedTopics(scala.collection.immutable.Map<String, ClusterLinkTopicState> linkedTopics) {
        TrieMap map = new TrieMap();
        map.$plus$plus$eq(linkedTopics);
        Mockito.when((Object)this.metadataManager().mirrorTopicStatesFromMetadataCache((Uuid)ArgumentMatchers.any())).thenReturn((Object)map.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private void expectPauseMirrors(scala.collection.immutable.Map<String, Option<Throwable>> values, boolean enable) {
        AlterMirrorOp pauseOp = enable ? AlterMirrorOp.PAUSE_LINK : AlterMirrorOp.RESUME_LINK;
        scala.collection.immutable.Map ops = ((IterableOnceOps)values.keys().map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)pauseOp))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map results = (scala.collection.immutable.Map)values.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String t = (String)x0$1._1();
                Option option = (Option)x0$1._2();
                if (option instanceof Some) {
                    Throwable ex = (Throwable)((Some)option).value();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), this.newPauseFailureFuture(ex));
                }
            }
            if (x0$1 != null) {
                String t = (String)x0$1._1();
                Option option = (Option)x0$1._2();
                if (None$.MODULE$.equals(option)) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), (Object)KafkaFuture.completedFuture(null));
                }
            }
            throw new MatchError(x0$1);
        });
        Mockito.when((Object)this.admin().alterMirrors((java.util.Map)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)ops).asJava()), (AlterMirrorsOptions)ArgumentMatchers.any())).thenReturn((Object)new AlterMirrorsResult(CollectionConverters$.MODULE$.MapHasAsJava((Map)results).asJava()));
    }

    public static final /* synthetic */ void $anonfun$testPauseMirrorTopicsEmpty$1(ClusterLinkPauseMirrorTopicsTest $this, boolean isPaused) {
        JFunction0.mcZ.sp & Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable)() -> isPaused;
        Object var3_2 = null;
        ClusterLinkPauseMirrorTopics pauseMirrorTopics = new ClusterLinkPauseMirrorTopics($this.linkId(), $this.linkName(), (Function0)newPauseMirrorTopics_linkIsPaused, $this.scheduler(), $this.metadataManager(), (Function0 & Serializable)() -> this.admin(), $this.maxTopicsPerIteration(), 10, 10);
        $this.runOnce(pauseMirrorTopics);
    }

    public ClusterLinkPauseMirrorTopicsTest() {
        this.linkName = "link-name";
        this.otherLinkName = "other-link-name";
        this.maxTopicsPerIteration = 5;
    }
}

