/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import kafka.controller.KafkaController;
import kafka.network.SocketServer;
import kafka.server.BrokerEpochManager;
import kafka.server.KafkaConfig;
import kafka.server.MetadataSupport;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaQuota;
import kafka.server.ZkSupport;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkManager;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.common.MetadataVersion;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class ClusterLinkTestUtils$ {
    public static final ClusterLinkTestUtils$ MODULE$ = new ClusterLinkTestUtils$();
    private static final String AllAclsFilter = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n       | \"aclFilters\": [{\n       |  \"resourceFilter\": {\n       |      \"resourceType\": \"any\",\n       |      \"patternType\": \"any\"\n       |    },\n       |  \"accessFilter\": {\n       |     \"operation\": \"any\",\n       |     \"permissionType\": \"any\"\n       |    }\n       |  }]\n       | }"));
    private static final String AllGroupsFilter = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|{\n       |\"groupFilters\": [\n       |  {\n       |     \"name\": \"*\",\n       |     \"patternType\": \"literal\",\n       |     \"filterType\": \"include\"\n       |  }\n       |]}"));
    private static final String AllTopicsFilter = MODULE$.AllGroupsFilter().replaceAll("groupFilters", "topicFilters");

    public String AllAclsFilter() {
        return AllAclsFilter;
    }

    public String AllGroupsFilter() {
        return AllGroupsFilter;
    }

    public String AllTopicsFilter() {
        return AllTopicsFilter;
    }

    /*
     * WARNING - void declaration
     */
    public ClusterLinkManager createClusterLinkManager(MetadataVersion ibp) {
        void apply_doLog;
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_12 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_15 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_18 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        boolean bl = true;
        Properties apply_props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        Object var26_27 = null;
        KafkaConfig props = new KafkaConfig((Map)apply_props, (boolean)apply_doLog);
        boolean isMultiTenant = ConfluentConfigs.buildMultitenantMetadata((Map)props.values(), (Metrics)metrics) != null;
        ClusterLinkFactory.LinkManager manager = ClusterLinkFactory$.MODULE$.createLinkManager(props, "clusterId", (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, metrics, (Time)time, isMultiTenant, (Option)None$.MODULE$);
        return this.setupClusterLinkManager(manager, ibp);
    }

    public MetadataVersion createClusterLinkManager$default$1() {
        return MetadataVersion.latest();
    }

    public ClusterLinkManager setupClusterLinkManager(ClusterLinkFactory.LinkManager manager, MetadataVersion ibp) {
        AuthorizerServerInfo serverInfo = (AuthorizerServerInfo)Mockito.mock(AuthorizerServerInfo.class);
        Endpoint brokerEndpoint = new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 1234);
        Mockito.when((Object)serverInfo.interBrokerEndpoint()).thenReturn((Object)brokerEndpoint);
        KafkaController controller = (KafkaController)Mockito.mock(KafkaController.class);
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ZkMetadataCache metadataCache = (ZkMetadataCache)Mockito.mock(ZkMetadataCache.class);
        Mockito.when((Object)metadataCache.metadataVersion()).thenReturn((Object)ibp);
        Mockito.when((Object)zkClient.getChildren("/cluster_links")).thenReturn((Object)package$.MODULE$.Seq().empty());
        Mockito.when((Object)zkClient.getClusterLinks((Set)ArgumentMatchers.any())).thenReturn((Object)Predef$.MODULE$.Map().empty());
        ((KafkaZkClient)Mockito.doNothing().when((Object)zkClient)).transformEntityConfigs((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)zkClient.clusterLinkExists((Uuid)ArgumentMatchers.isA(Uuid.class)))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ((KafkaZkClient)Mockito.doNothing().when((Object)zkClient)).setOrCreateEntityConfigs(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Properties)ArgumentMatchers.isA(Properties.class));
        ((KafkaZkClient)Mockito.doNothing().when((Object)zkClient)).createClusterLink((ClusterLinkData)ArgumentMatchers.isA(ClusterLinkData.class));
        ((KafkaZkClient)Mockito.doNothing().when((Object)zkClient)).createConfigChangeNotification(ArgumentMatchers.anyString());
        ZkSupport zkSupport = new ZkSupport(null, controller, zkClient, (Option)None$.MODULE$, metadataCache, new BrokerEpochManager(){

            public long get() {
                return 1L;
            }

            public boolean isBrokerEpochStale(long brokerEpochInRequest, boolean isKRaftControllerRequest) {
                return false;
            }
        });
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)socketServer.boundPort((ListenerName)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)9092));
        manager.initialize(serverInfo, socketServer, (Option)None$.MODULE$, (MetadataSupport)zkSupport, null, null, (Option)None$.MODULE$);
        manager.startup();
        return (ClusterLinkManager)manager;
    }

    public MetadataVersion setupClusterLinkManager$default$2() {
        return MetadataVersion.latest();
    }

    private ClusterLinkTestUtils$() {
    }
}

