/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.kafka.link.ClusterLinkUtils;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDynamicLogger;
import kafka.server.link.ClusterLinkFilter;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.GroupClusterLinkFilter;
import kafka.server.link.GroupClusterLinkFilterInfo;
import kafka.server.link.GroupFilterJson;
import kafka.server.link.MatchedGroup;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.server.link.MirrorTopicConfigsDelegate;
import kafka.server.link.TopicClusterLinkFilter;
import kafka.server.link.TopicType$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005ue\u0001B\u0010!\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013\u00051\u0007\u0003\u00048\u0001\u0001\u0006I\u0001\u000e\u0005\bq\u0001\u0011\r\u0011\"\u0001:\u0011\u0019i\u0004\u0001)A\u0005u!)a\b\u0001C\u0001\u007f!)\u0001\u000b\u0001C\u0001\u007f!)!\u000b\u0001C\u0001\u007f!)A\u000b\u0001C\u0001\u007f!)a\u000b\u0001C\u0001\u007f!)\u0001\f\u0001C\u0001\u007f!)!\f\u0001C\u0001\u007f!)A\f\u0001C\u0001\u007f!)a\f\u0001C\u0001\u007f!)\u0001\r\u0001C\u0001\u007f!)!\r\u0001C\u0001\u007f!)A\r\u0001C\u0001\u007f!)a\r\u0001C\u0001\u007f!)\u0001\u000e\u0001C\u0001\u007f!)!\u000e\u0001C\u0001\u007f!)A\u000e\u0001C\u0001\u007f!)a\u000e\u0001C\u0001\u007f!)\u0001\u000f\u0001C\u0001\u007f!)!\u000f\u0001C\u0001\u007f!)A\u000f\u0001C\u0001\u007f!)a\u000f\u0001C\u0001\u007f!)\u0001\u0010\u0001C\u0001\u007f!)!\u0010\u0001C\u0005w\"9\u0011q\t\u0001\u0005\n\u0005%\u0003bBA3\u0001\u0011%\u0011q\r\u0002\u0015\u00072,8\u000f^3s\u0019&t7.\u0016;jYN$Vm\u001d;\u000b\u0005\u0005\u0012\u0013\u0001\u00027j].T!a\t\u0013\u0002\rM,'O^3s\u0015\u0005)\u0013!B6bM.\f7\u0001A\n\u0003\u0001!\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00011!\t\t\u0004!D\u0001!\u0003)a\u0017N\\6D_:4\u0017nZ\u000b\u0002iA\u0011\u0011'N\u0005\u0003m\u0001\u0012\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u0003-a\u0017N\\6D_:4\u0017n\u001a\u0011\u0002)Q|\u0007/[2D_:4\u0017nZ*z]\u000e\u0014V\u000f\\3t+\u0005Q\u0004CA\u0019<\u0013\ta\u0004E\u0001\u000eNSJ\u0014xN\u001d+pa&\u001c7i\u001c8gS\u001e\u001c\u0016P\\2Sk2,7/A\u000bu_BL7mQ8oM&<7+\u001f8d%VdWm\u001d\u0011\u0002%Q,7\u000f\u001e,bY&$G*\u001b8l\u001d\u0006lWm\u001d\u000b\u0002\u0001B\u0011\u0011&Q\u0005\u0003\u0005*\u0012A!\u00168ji\"\u0012a\u0001\u0012\t\u0003\u000b:k\u0011A\u0012\u0006\u0003\u000f\"\u000b1!\u00199j\u0015\tI%*A\u0004kkBLG/\u001a:\u000b\u0005-c\u0015!\u00026v]&$(\"A'\u0002\u0007=\u0014x-\u0003\u0002P\r\n!A+Z:u\u0003Q!Xm\u001d;J]Z\fG.\u001b3MS:\\g*Y7fg\"\u0012q\u0001R\u0001\u0018i\u0016\u001cHOV1mS\u0012\fG/Z'jeJ|'\u000f\u0015:paND#\u0001\u0003#\u00029Q,7\u000f\u001e,bY&$\u0017\r^3NSJ\u0014xN\u001d)s_B\u001cX)\u001c9us\"\u0012\u0011\u0002R\u0001\u001fi\u0016\u001cHOV1mS\u0012\fG/Z%om\u0006d\u0017\u000eZ'jeJ|'\u000f\u0015:paND#A\u0003#\u0002KQ,7\u000f\u001e,bY&$\u0017\r^3J]Z\fG.\u001b3NSJ\u0014xN\u001d)s_B\u001c8+\u001f8p]fl\u0007FA\u0006E\u0003M!Xm\u001d;J]&$X*\u001b:s_J\u0004&o\u001c9tQ\taA)\u0001\u0010uKN$\u0018J\\5u\u001b&\u0014(o\u001c:Qe>\u00048\u000fT8dC2\fEn^1zg\"\u0012Q\u0002R\u0001(i\u0016\u001cH/\u00138ji6K'O]8s!J|\u0007o]+oW:|wO\\\"p]\u001aLw-S4o_J,G\r\u000b\u0002\u000f\t\u0006)B/Z:u+B$\u0017\r^3NSJ\u0014xN\u001d)s_B\u001c\bFA\bE\u0003%\"Xm\u001d;Va\u0012\fG/Z'jeJ|'\u000f\u0015:paN,fn\u001b8po:\u001cuN\u001c4jO&;gn\u001c:fI\"\u0012\u0001\u0003R\u0001\u001fi\u0016\u001cHOU3t_24Xm\u0011:fCR,Gk\u001c9jGN#\u0018M\u001c3be\u0012D#!\u0005#\u00029Q,7\u000f\u001e*fg>dg/Z\"sK\u0006$X-T5se>\u0014Hk\u001c9jG\"\u0012!\u0003R\u0001#i\u0016\u001cHOU3t_24Xm\u0011:fCR,W*\u001b:s_J$v\u000e]5d\u000bJ\u0014xN]:)\u0005M!\u0015\u0001\b;fgR4\u0016\r\\5eCR,7I]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0003)\u0011\u000b!\u0002^3ti\u001aKG\u000e^3sQ\t)B)A\buKN$h)\u001b7uKJ<%o\\;qQ\t1B)\u0001\nuKN$Hi\u001c$jYR,'o\u0012:pkB\u001c\bFA\fE\u0003\u0015\"Xm\u001d;GS2$XM]$s_V\u0004H+Y6fgVs\u0017n\u001c8PMR{\u0007/[2UsB,7\u000f\u000b\u0002\u0019\t\u0006\tB/Z:u\tft\u0017-\\5d\u0019><w-\u001a:)\u0005e!\u0015!\t;fgRL7OQ8piN$(/\u00199D_:4G.^3oi\u000ecw.\u001e3I_N$\bF\u0001\u000eE\u0003\t\"Xm\u001d;NCb\u001c%/Z1uK\u000ecWo\u001d;fe2Kgn[:US6,w.\u001e;Ng\"\u00121\u0004R\u0001\u000b[\u0006\\WmQ8oM&<Gc\u0001?\u0002\u0010A\u0019Q0a\u0003\u000e\u0003yT1a`A\u0001\u0003\u0015\tG-\\5o\u0015\u0011\t\u0019!!\u0002\u0002\u000f\rd\u0017.\u001a8ug*\u0019Q%a\u0002\u000b\u0007\u0005%A*\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0004\u0003\u001bq(AB\"p]\u001aLw\rC\u0004\u0002\u0012q\u0001\r!a\u0005\u0002\u000f\u0015tGO]5fgB1\u0011QCA\u0013\u0003WqA!a\u0006\u0002\"9!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001e\u0019\na\u0001\u0010:p_Rt\u0014\"A\u0016\n\u0007\u0005\r\"&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0012\u0011\u0006\u0002\u0004'\u0016\f(bAA\u0012UAI\u0011&!\f\u00022\u0005E\u0012\u0011I\u0005\u0004\u0003_Q#A\u0002+va2,7\u0007\u0005\u0003\u00024\u0005mb\u0002BA\u001b\u0003o\u00012!!\u0007+\u0013\r\tIDK\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0012q\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005e\"\u0006E\u0002*\u0003\u0007J1!!\u0012+\u0005\u001d\u0011un\u001c7fC:\fa\"\\1lKB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u0002L\u0005m\u0003\u0003BA'\u0003/j!!a\u0014\u000b\t\u0005E\u00131K\u0001\u0005kRLGN\u0003\u0002\u0002V\u0005!!.\u0019<b\u0013\u0011\tI&a\u0014\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u0002\u0012u\u0001\r!!\u0018\u0011\r\u0005U\u0011QEA0!\u001dI\u0013\u0011MA\u0019\u0003cI1!a\u0019+\u0005\u0019!V\u000f\u001d7fe\u0005\u0011R.Y6f\u0007J,\u0017\r^1cY\u0016$v\u000e]5d))\tI'!!\u0002\u0006\u0006=\u0015\u0011\u0014\t\u0005\u0003W\nYH\u0004\u0003\u0002n\u0005]TBAA8\u0015\u0011\t\t(a\u001d\u0002\u000f5,7o]1hK*!\u0011QOA\u0003\u0003\u0019\u0019w.\\7p]&!\u0011\u0011PA8\u0003]\u0019%/Z1uKR{\u0007/[2t%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0002~\u0005}$AD\"sK\u0006$\u0018M\u00197f)>\u0004\u0018n\u0019\u0006\u0005\u0003s\ny\u0007C\u0004\u0002\u0004z\u0001\r!!\r\u0002\t9\fW.\u001a\u0005\b\u0003\u000fs\u0002\u0019AAE\u00035qW/\u001c)beRLG/[8ogB\u0019\u0011&a#\n\u0007\u00055%FA\u0002J]RDq!!%\u001f\u0001\u0004\t\u0019*\u0001\u0005mS:\\g*Y7f!\u0015I\u0013QSA\u0019\u0013\r\t9J\u000b\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005me\u00041\u0001\u0002\u0014\u0006YQ.\u001b:s_J$v\u000e]5d\u0001")
public class ClusterLinkUtilsTest {
    private final ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)new Properties(null){
        {
            this.put("bootstrap.servers", "localhost:2345");
        }
    }, true);
    private final MirrorTopicConfigSyncRules topicConfigSyncRules = this.linkConfig().topicConfigSyncRules();

    public ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    public MirrorTopicConfigSyncRules topicConfigSyncRules() {
        return this.topicConfigSyncRules;
    }

    @Test
    public void testValidLinkNames() {
        String assertValid$1_linkName = "ABCXYZ.abcxyz-0123456789_";
        ClusterLinkUtils.validateLinkNameOrThrow((String)assertValid$1_linkName);
        Object var1_1 = null;
        String assertValid$1_linkName2 = "...";
        ClusterLinkUtils.validateLinkNameOrThrow((String)assertValid$1_linkName2);
        Object var2_2 = null;
        String assertValid$1_linkName3 = "_.-";
        ClusterLinkUtils.validateLinkNameOrThrow((String)assertValid$1_linkName3);
        Object var3_3 = null;
        String assertValid$1_linkName4 = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0123456789"), 20);
        ClusterLinkUtils.validateLinkNameOrThrow((String)assertValid$1_linkName4);
    }

    @Test
    public void testInvalidLinkNames() {
        ClusterLinkUtilsTest.assertInvalid$1(null);
        ClusterLinkUtilsTest.assertInvalid$1("");
        ClusterLinkUtilsTest.assertInvalid$1(".");
        ClusterLinkUtilsTest.assertInvalid$1("..");
        ClusterLinkUtilsTest.assertInvalid$1("test/link");
        ClusterLinkUtilsTest.assertInvalid$1("test:link");
        ClusterLinkUtilsTest.assertInvalid$1("test\\link");
        ClusterLinkUtilsTest.assertInvalid$1("test\nlink");
        ClusterLinkUtilsTest.assertInvalid$1("test\tlink");
        ClusterLinkUtilsTest.assertInvalid$1(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0123456789"), 30));
    }

    @Test
    public void testValidateMirrorProps() {
        Properties props = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.downconversion.enable"), (Object)"true"), (List)Nil$.MODULE$));
        this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", props);
    }

    @Test
    public void testValidateMirrorPropsEmpty() {
        this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", new Properties());
    }

    @Test
    public void testValidateInvalidMirrorProps() {
        Properties props = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)"compact"), (List)Nil$.MODULE$));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", props));
    }

    @Test
    public void testValidateInvalidMirrorPropsSynonym() {
        Properties props = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanupPolicyProp()), (Object)"compact"), (List)Nil$.MODULE$));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", props));
    }

    @Test
    public void testInitMirrorProps() {
        Config remoteConfig = this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)"cleanup.policy", (Object)"compact", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)"max.message.bytes", (Object)"10485760", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)"unclean.leader.election.enable", (Object)"true", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)"confluent.prefer.tier.fetch.ms", (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)"segment.ms", (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)"segment.bytes", (Object)"1048576", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)))))));
        Properties localProps = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.downconversion.enable"), (Object)"true"), (List)Nil$.MODULE$));
        Properties newLocalProps = new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).initMirrorProps("test");
        Assertions.assertEquals((Object)this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.downconversion.enable"), (Object)"true"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)"compact"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.message.bytes"), (Object)"10485760"), (List)Nil$.MODULE$)))), (Object)newLocalProps);
    }

    @Test
    public void testInitMirrorPropsLocalAlways() {
        Properties localProps = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)"compact"), (List)Nil$.MODULE$));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> new MirrorTopicConfigsDelegate(localProps, this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())), this.topicConfigSyncRules()).initMirrorProps("test"));
    }

    @Test
    public void testInitMirrorPropsUnknownConfigIgnored() {
        Config remoteConfig = this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)"bad.config.key", (Object)"12345", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$));
        Properties localProps = new Properties();
        Assertions.assertTrue((boolean)new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).initMirrorProps("test").isEmpty());
    }

    @Test
    public void testUpdateMirrorProps() {
        Config remoteConfig = this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)"cleanup.policy", (Object)"compact", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)"max.message.bytes", (Object)"10485760", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)"unclean.leader.election.enable", (Object)"true", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)"confluent.prefer.tier.fetch.ms", (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)"segment.ms", (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)"segment.bytes", (Object)"1048576", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)))))));
        Properties localProps = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)"delete"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.message.bytes"), (Object)"524288"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.downconversion.enable"), (Object)"true"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unclean.leader.election.enable"), (Object)"false"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"200000"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"1048576"), (List)Nil$.MODULE$)))))));
        Properties expectedLocalProps = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)"compact"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.message.bytes"), (Object)"10485760"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.downconversion.enable"), (Object)"true"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unclean.leader.election.enable"), (Object)"false"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"200000"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.bytes"), (Object)"1048576"), (List)Nil$.MODULE$)))))));
        Properties newLocalProps = new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).updateMirrorProps("test");
        Assertions.assertEquals((Object)expectedLocalProps, (Object)newLocalProps);
    }

    @Test
    public void testUpdateMirrorPropsUnknownConfigIgnored() {
        Config remoteConfig = this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)"bad.config.key", (Object)"12345", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$));
        Properties localProps = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"another.bad.config.key"), (Object)"23456"), (List)Nil$.MODULE$));
        Assertions.assertTrue((boolean)new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).updateMirrorProps("test").isEmpty());
    }

    @Test
    public void testResolveCreateTopicStandard() {
        Properties configs = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unclean.leader.election.enable"), (Object)"true"), (List)Nil$.MODULE$));
        CreateTopicsRequestData.CreatableTopic topic = this.makeCreatableTopic("test-topic", 4, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        ClusterLinkUtils.ResolveCreateTopic result = ClusterLinkUtils$.MODULE$.resolveCreateTopic(topic, (Option)None$.MODULE$, configs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, "");
        Assertions.assertEquals((Object)configs, (Object)result.configs());
        Assertions.assertTrue((boolean)result.topicState().isEmpty());
        Assertions.assertEquals((int)-1, (int)result.numPartitions());
    }

    @Test
    public void testResolveCreateMirrorTopic() {
        Uuid linkId = Uuid.randomUuid();
        Properties configs = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unclean.leader.election.enable"), (Object)"true"), (List)Nil$.MODULE$));
        Config remoteConfig = this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)"cleanup.policy", (Object)"compact", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$));
        Properties expectedConfigs = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unclean.leader.election.enable"), (Object)"true"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)"compact"), (List)Nil$.MODULE$)));
        ClusterLinkUtils.ResolveCreateTopic result1 = ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic("test-topic", -1, (Option<String>)new Some((Object)"link-name"), (Option<String>)new Some((Object)"test-topic")), (Option)new Some((Object)linkId), configs, true, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, "");
        Assertions.assertEquals((Object)configs, (Object)result1.configs());
        Assertions.assertTrue((boolean)result1.topicState().isEmpty());
        Assertions.assertEquals((int)-1, (int)result1.numPartitions());
        Node node = new Node(0, "localhost", 9092);
        java.util.List nodeList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)node, (List)Nil$.MODULE$)).asJava();
        .colon.colon partitionInfos = new .colon.colon((Object)new TopicPartitionInfo(0, node, nodeList, nodeList), (List)new .colon.colon((Object)new TopicPartitionInfo(1, node, nodeList, nodeList), (List)new .colon.colon((Object)new TopicPartitionInfo(2, node, nodeList, nodeList), (List)Nil$.MODULE$)));
        scala.collection.immutable.Set authorizedOperations = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ}));
        TopicDescription description = new TopicDescription("test-topic", false, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionInfos).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)authorizedOperations).asJava());
        CompletableFuture<ClusterLinkTopicInfo> future = new CompletableFuture<ClusterLinkTopicInfo>();
        future.complete(new ClusterLinkTopicInfo(description, remoteConfig, (Seq)package$.MODULE$.Seq().empty()));
        ClusterLinkUtils.ResolveCreateTopic result2 = ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic("test-topic", -1, (Option<String>)new Some((Object)"link-name"), (Option<String>)new Some((Object)"test-topic")), (Option)new Some((Object)linkId), configs, false, (Option)new Some((Object)this.linkConfig()), (Option)new Some(future), "");
        Assertions.assertEquals((Object)expectedConfigs, (Object)result2.configs());
        Assertions.assertTrue((boolean)(result2.topicState().get() instanceof ClusterLinkTopicState.Mirror));
        Assertions.assertEquals((Object)"link-name", (Object)((ClusterLinkTopicState)result2.topicState().get()).linkName());
        Assertions.assertEquals((int)3, (int)result2.numPartitions());
    }

    @Test
    public void testResolveCreateMirrorTopicErrors() {
        String topic = "test-topic";
        String linkName = "link-name";
        Uuid linkId = Uuid.randomUuid();
        Properties validConfigs = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unclean.leader.election.enable"), (Object)"true"), (List)Nil$.MODULE$));
        Properties invalidConfigs = this.makeProperties((scala.collection.immutable.Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanup.policy"), (Object)"compact"), (List)Nil$.MODULE$));
        Node node = new Node(0, "localhost", 9092);
        java.util.List nodeList = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)node, (List)Nil$.MODULE$)).asJava();
        .colon.colon partitionInfos = new .colon.colon((Object)new TopicPartitionInfo(0, node, nodeList, nodeList), (List)new .colon.colon((Object)new TopicPartitionInfo(1, node, nodeList, nodeList), (List)new .colon.colon((Object)new TopicPartitionInfo(2, node, nodeList, nodeList), (List)Nil$.MODULE$)));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)None$.MODULE$), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ""), ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ""), ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, 4, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ""), ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)"different-topic")), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ""), ClassTag$.MODULE$.apply(UnsupportedVersionException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), invalidConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ""), ClassTag$.MODULE$.apply(InvalidConfigurationException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$, ""), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            CompletableFuture future = new CompletableFuture();
            return ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)new Some(future), "");
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(new TimeoutException("timeout"));
            return ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)new Some(future), "");
        }, ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        Assertions$.MODULE$.intercept(() -> ClusterLinkUtilsTest.$anonfun$testResolveCreateMirrorTopicErrors$9(this, (List)partitionInfos, topic, linkName, linkId, validConfigs), ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        Assertions.assertEquals((Object)((ClusterLinkNotFoundException)Assertions$.MODULE$.intercept(() -> ClusterLinkUtilsTest.$anonfun$testResolveCreateMirrorTopicErrors$10(this, (List)partitionInfos, topic, linkName, validConfigs), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290))).getMessage(), (Object)new StringBuilder(41).append("Cluster link with name '").append(linkName).append("' does not exist.").toString());
    }

    @Test
    public void testValidateCreatePartitions() {
        ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 3, true, (Option)None$.MODULE$);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 3, false, (Option)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 2, false, (Option)new Some((Object)future)), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        future.complete(BoxesRunTime.boxToInteger((int)3));
        ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 2, false, (Option)new Some(future));
        ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 3, false, (Option)new Some(future));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 4, false, (Option)new Some((Object)future)), ClassTag$.MODULE$.apply(InvalidPartitionsException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
    }

    @Test
    public void testFilter() {
        ClusterLinkFilterInfo fooLiteral = ClusterLinkUtilsTest.filterInfo$1("fooLiteral", PatternType.LITERAL, "include");
        ClusterLinkFilterInfo bar = ClusterLinkUtilsTest.filterInfo$1("bar", PatternType.PREFIXED, "include");
        ClusterLinkFilterInfo barExclude = ClusterLinkUtilsTest.filterInfo$1("barExclude", PatternType.PREFIXED, "exclude");
        ClusterLinkFilterInfo baz = ClusterLinkUtilsTest.filterInfo$1("baz", PatternType.PREFIXED, "include");
        ClusterLinkFilterInfo bazExclude = ClusterLinkUtilsTest.filterInfo$1("bazExclude", PatternType.LITERAL, "exclude");
        .colon.colon filters = new .colon.colon((Object)fooLiteral, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)barExclude, (List)new .colon.colon((Object)baz, (List)new .colon.colon((Object)bazExclude, (List)Nil$.MODULE$)))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1(Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), (scala.collection.immutable.Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), (scala.collection.immutable.Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExcludeNot"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), (scala.collection.immutable.Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral, bar, barExclude})), (Object)((IterableOnceOps)ClusterLinkUtils$.MODULE$.doFilterTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), (scala.collection.immutable.Seq)filters)._2()).toSet());
        scala.collection.immutable.Seq filters2 = (scala.collection.immutable.Seq)filters.$plus$plus((IterableOnce)new .colon.colon((Object)ClusterLinkUtilsTest.filterInfo$1("*", PatternType.LITERAL, "include"), (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1(Predef$.MODULE$.Set().empty(), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExcludeNot"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral, bar, barExclude})), (Object)((IterableOnceOps)ClusterLinkUtils$.MODULE$.doFilterTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), filters2)._2()).toSet());
        scala.collection.immutable.Seq filters3 = (scala.collection.immutable.Seq)filters.$plus$plus((IterableOnce)new .colon.colon((Object)ClusterLinkUtilsTest.filterInfo$1("*", PatternType.LITERAL, "exclude"), (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1(Predef$.MODULE$.Set().empty(), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral, bar, barExclude})), (Object)((IterableOnceOps)ClusterLinkUtils$.MODULE$.doFilterTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), filters3)._2()).toSet());
        Assertions.assertTrue((boolean)bar.matchesIncludeOrExclude("bar"));
        Assertions.assertTrue((boolean)bar.matchesIncludeOrExclude("barInclude"));
        Assertions.assertFalse((boolean)bar.matchesIncludeOrExclude("foo"));
        Assertions.assertTrue((boolean)barExclude.matchesIncludeOrExclude("barExclude"));
        Assertions.assertTrue((boolean)barExclude.matchesIncludeOrExclude("barExcluded"));
        Assertions.assertFalse((boolean)barExclude.matchesIncludeOrExclude("foo"));
    }

    @Test
    public void testFilterGroup() {
        scala.collection.immutable.Set allTopicTypes = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TopicType$.MODULE$.LOCAL_MIRROR(), TopicType$.MODULE$.REMOTE_MIRROR()}));
        GroupClusterLinkFilterInfo fooLiteral = ClusterLinkUtilsTest.filterInfo$2("fooLiteral", PatternType.LITERAL, "include", allTopicTypes);
        GroupClusterLinkFilterInfo bar = ClusterLinkUtilsTest.filterInfo$2("bar", PatternType.PREFIXED, "include", allTopicTypes);
        GroupClusterLinkFilterInfo barExclude = ClusterLinkUtilsTest.filterInfo$2("barExclude", PatternType.PREFIXED, "exclude", allTopicTypes);
        GroupClusterLinkFilterInfo baz = ClusterLinkUtilsTest.filterInfo$2("baz", PatternType.PREFIXED, "include", allTopicTypes);
        GroupClusterLinkFilterInfo bazExclude = ClusterLinkUtilsTest.filterInfo$2("bazExclude", PatternType.LITERAL, "exclude", allTopicTypes);
        .colon.colon filters = new .colon.colon((Object)fooLiteral, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)barExclude, (List)new .colon.colon((Object)baz, (List)new .colon.colon((Object)bazExclude, (List)Nil$.MODULE$)))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$2(Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("fooLiteral", allTopicTypes)})), (Object)ClusterLinkUtilsTest.filter$2((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), (scala.collection.immutable.Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("bar", allTopicTypes), new MatchedGroup("barred", allTopicTypes)})), (Object)ClusterLinkUtilsTest.filter$2((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), (scala.collection.immutable.Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("baz", allTopicTypes), new MatchedGroup("bazExcludeNot", allTopicTypes)})), (Object)ClusterLinkUtilsTest.filter$2((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), (scala.collection.immutable.Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral.filterInfo(), bar.filterInfo(), barExclude.filterInfo()})), (Object)((IterableOnceOps)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), (scala.collection.immutable.Seq)filters)._2()).toSet());
        scala.collection.immutable.Seq filters2 = (scala.collection.immutable.Seq)filters.$plus$plus((IterableOnce)new .colon.colon((Object)ClusterLinkUtilsTest.filterInfo$2("*", PatternType.LITERAL, "include", allTopicTypes), (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$2(Predef$.MODULE$.Set().empty(), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("fooLiteral", allTopicTypes), new MatchedGroup("abc", allTopicTypes)})), (Object)ClusterLinkUtilsTest.filter$2((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("bar", allTopicTypes), new MatchedGroup("barred", allTopicTypes)})), (Object)ClusterLinkUtilsTest.filter$2((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("baz", allTopicTypes), new MatchedGroup("bazExcludeNot", allTopicTypes)})), (Object)ClusterLinkUtilsTest.filter$2((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral.filterInfo(), bar.filterInfo(), barExclude.filterInfo()})), (Object)((IterableOnceOps)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), filters2)._2()).toSet());
        scala.collection.immutable.Seq filters3 = (scala.collection.immutable.Seq)filters.$plus$plus((IterableOnce)new .colon.colon((Object)ClusterLinkUtilsTest.filterInfo$2("*", PatternType.LITERAL, "exclude", allTopicTypes), (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$2(Predef$.MODULE$.Set().empty(), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$2((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$2((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$2((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral.filterInfo(), bar.filterInfo(), barExclude.filterInfo()})), (Object)((IterableOnceOps)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), filters3)._2()).toSet());
        Assertions.assertTrue((boolean)bar.filterInfo().matchesIncludeOrExclude("bar"));
        Assertions.assertTrue((boolean)bar.filterInfo().matchesIncludeOrExclude("barInclude"));
        Assertions.assertFalse((boolean)bar.filterInfo().matchesIncludeOrExclude("foo"));
        Assertions.assertTrue((boolean)barExclude.filterInfo().matchesIncludeOrExclude("barExclude"));
        Assertions.assertTrue((boolean)barExclude.filterInfo().matchesIncludeOrExclude("barExcluded"));
        Assertions.assertFalse((boolean)barExclude.filterInfo().matchesIncludeOrExclude("foo"));
    }

    @Test
    public void testDoFilterGroups() {
        .colon.colon allTopicTypeStrs = new .colon.colon((Object)"LOCAL_MIRROR", (List)new .colon.colon((Object)"REMOTE_MIRROR", (List)Nil$.MODULE$));
        GroupFilterJson literalFilter = new GroupFilterJson((scala.collection.immutable.Seq)new .colon.colon((Object)new GroupClusterLinkFilter("foo", PatternType.LITERAL.name(), "INCLUDE", (scala.collection.immutable.Seq)allTopicTypeStrs), (List)Nil$.MODULE$));
        GroupFilterJson prefixFilter = new GroupFilterJson((scala.collection.immutable.Seq)new .colon.colon((Object)new GroupClusterLinkFilter("f", PatternType.PREFIXED.name(), "INCLUDE", (scala.collection.immutable.Seq)allTopicTypeStrs), (List)Nil$.MODULE$));
        GroupFilterJson starFilter = new GroupFilterJson((scala.collection.immutable.Seq)new .colon.colon((Object)new GroupClusterLinkFilter("*", PatternType.LITERAL.name(), "INCLUDE", (scala.collection.immutable.Seq)allTopicTypeStrs), (List)Nil$.MODULE$));
        .colon.colon allTopicTypes = new .colon.colon((Object)TopicType$.MODULE$.LOCAL_MIRROR(), (List)new .colon.colon((Object)TopicType$.MODULE$.REMOTE_MIRROR(), (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("lkc-123_east_foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"lkc-123_east_foo"})), (Option)new Some((Object)literalFilter), (Option)new Some((Object)"lkc-123_"), (Option)new Some((Object)"east_"), ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("lkc-123_east_foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"lkc-123_east_foo"})), (Option)new Some((Object)prefixFilter), (Option)new Some((Object)"lkc-123_"), (Option)new Some((Object)"east_"), ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("lkc-123_east_foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"lkc-123_east_foo"})), (Option)new Some((Object)starFilter), (Option)new Some((Object)"lkc-123_"), (Option)new Some((Object)"east_"), ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("east_foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"east_foo"})), (Option)new Some((Object)literalFilter), (Option)None$.MODULE$, (Option)new Some((Object)"east_"), ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("east_foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"east_foo"})), (Option)new Some((Object)prefixFilter), (Option)None$.MODULE$, (Option)new Some((Object)"east_"), ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("east_foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"east_foo"})), (Option)new Some((Object)starFilter), (Option)None$.MODULE$, (Option)new Some((Object)"east_"), ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("lkc-123_foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"lkc-123_foo"})), (Option)new Some((Object)literalFilter), (Option)new Some((Object)"lkc-123_"), (Option)None$.MODULE$, ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("lkc-123_foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"lkc-123_foo"})), (Option)new Some((Object)prefixFilter), (Option)new Some((Object)"lkc-123_"), (Option)None$.MODULE$, ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("lkc-123_foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"lkc-123_foo"})), (Option)new Some((Object)starFilter), (Option)new Some((Object)"lkc-123_"), (Option)None$.MODULE$, ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Option)new Some((Object)literalFilter), (Option)None$.MODULE$, (Option)None$.MODULE$, ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Option)new Some((Object)prefixFilter), (Option)None$.MODULE$, (Option)None$.MODULE$, ClusterLinkConfig.LinkMode.DESTINATION)._1());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("foo", allTopicTypes.toSet())})), (Object)ClusterLinkUtils$.MODULE$.doFilterGroups((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Option)new Some((Object)starFilter), (Option)None$.MODULE$, (Option)None$.MODULE$, ClusterLinkConfig.LinkMode.DESTINATION)._1());
    }

    @Test
    public void testFilterGroupTakesUnionOfTopicTypes() {
        scala.collection.immutable.Set allTopicTypes = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TopicType$.MODULE$.LOCAL_MIRROR(), TopicType$.MODULE$.REMOTE_MIRROR()}));
        scala.collection.immutable.Set localOnlyTopicType = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TopicType$.MODULE$.LOCAL_MIRROR()}));
        scala.collection.immutable.Set remoteOnlyTopicType = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TopicType$.MODULE$.REMOTE_MIRROR()}));
        GroupClusterLinkFilterInfo fooLiteral = ClusterLinkUtilsTest.filterInfo$3("fooLiteral", PatternType.LITERAL, "include", localOnlyTopicType);
        GroupClusterLinkFilterInfo fooPrefixed = ClusterLinkUtilsTest.filterInfo$3("foo", PatternType.PREFIXED, "include", remoteOnlyTopicType);
        GroupClusterLinkFilterInfo baz = ClusterLinkUtilsTest.filterInfo$3("baz", PatternType.PREFIXED, "include", allTopicTypes);
        GroupClusterLinkFilterInfo bar = ClusterLinkUtilsTest.filterInfo$3("bar", PatternType.PREFIXED, "include", localOnlyTopicType);
        GroupClusterLinkFilterInfo bat = ClusterLinkUtilsTest.filterInfo$3("bat", PatternType.PREFIXED, "include", remoteOnlyTopicType);
        .colon.colon filters = new .colon.colon((Object)fooLiteral, (List)new .colon.colon((Object)fooPrefixed, (List)new .colon.colon((Object)baz, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)bat, (List)Nil$.MODULE$)))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("fooLiteral", allTopicTypes), new MatchedGroup("baz", allTopicTypes), new MatchedGroup("bar", localOnlyTopicType), new MatchedGroup("foo", remoteOnlyTopicType)})), (Object)ClusterLinkUtilsTest.filter$3((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "baz", "bar", "foo"})), (scala.collection.immutable.Seq)filters));
        GroupClusterLinkFilterInfo fooLiteralAllTopicTypes = ClusterLinkUtilsTest.filterInfo$3("fooLiteral", PatternType.LITERAL, "include", allTopicTypes);
        GroupClusterLinkFilterInfo fooPrefixedExcludesRemote = ClusterLinkUtilsTest.filterInfo$3("foo", PatternType.PREFIXED, "exclude", remoteOnlyTopicType);
        .colon.colon filtersWithExcludingRemote = new .colon.colon((Object)fooLiteralAllTopicTypes, (List)new .colon.colon((Object)fooPrefixedExcludesRemote, (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("fooLiteral", localOnlyTopicType)})), (Object)ClusterLinkUtilsTest.filter$3((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral"})), (scala.collection.immutable.Seq)filtersWithExcludingRemote));
        GroupClusterLinkFilterInfo fooPrefixedExcludesLocal = ClusterLinkUtilsTest.filterInfo$3("foo", PatternType.PREFIXED, "exclude", localOnlyTopicType);
        .colon.colon filtersWithExcludingLocal = new .colon.colon((Object)fooLiteralAllTopicTypes, (List)new .colon.colon((Object)fooPrefixedExcludesLocal, (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MatchedGroup[]{new MatchedGroup("fooLiteral", remoteOnlyTopicType)})), (Object)ClusterLinkUtilsTest.filter$3((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral"})), (scala.collection.immutable.Seq)filtersWithExcludingLocal));
    }

    @Test
    public void testDynamicLogger() {
        RuntimeException e1 = new RuntimeException("runtime exception");
        IllegalStateException e2 = new IllegalStateException("illegal state");
        IllegalArgumentException e3 = new IllegalArgumentException("illegal arg");
        .colon.colon exceptions = new .colon.colon((Object)e1, (List)new .colon.colon((Object)e2, (List)new .colon.colon((Object)e3, (List)Nil$.MODULE$)));
        scala.collection.mutable.Map errorCounts = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map debugCounts = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map warnCounts = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Logging logging = new Logging(null, errorCounts, debugCounts, warnCounts){
            private Logger logger;
            private String logIdent;
            private volatile boolean bitmap$0;
            private final scala.collection.mutable.Map errorCounts$1;
            private final scala.collection.mutable.Map debugCounts$1;
            private final scala.collection.mutable.Map warnCounts$1;

            public String loggerName() {
                return Logging.loggerName$((Logging)this);
            }

            public String msgWithLogIdent(String msg) {
                return Logging.msgWithLogIdent$((Logging)this, (String)msg);
            }

            public void trace(Function0<String> msg) {
                Logging.trace$((Logging)this, msg);
            }

            public void trace(Function0<String> msg, Function0<Throwable> e) {
                Logging.trace$((Logging)this, msg, e);
            }

            public boolean isDebugEnabled() {
                return Logging.isDebugEnabled$((Logging)this);
            }

            public boolean isTraceEnabled() {
                return Logging.isTraceEnabled$((Logging)this);
            }

            public void debug(Function0<String> msg) {
                Logging.debug$((Logging)this, msg);
            }

            public void info(Function0<String> msg) {
                Logging.info$((Logging)this, msg);
            }

            public void info(Function0<String> msg, Function0<Throwable> e) {
                Logging.info$((Logging)this, msg, e);
            }

            public void warn(Function0<String> msg) {
                Logging.warn$((Logging)this, msg);
            }

            public void error(Function0<String> msg) {
                Logging.error$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg) {
                Logging.fatal$((Logging)this, msg);
            }

            public void fatal(Function0<String> msg, Function0<Throwable> e) {
                Logging.fatal$((Logging)this, msg, e);
            }

            private Logger logger$lzycompute() {
                synchronized (this) {
                    if (!this.bitmap$0) {
                        this.logger = Logging.logger$((Logging)this);
                        this.bitmap$0 = true;
                    }
                }
                return this.logger;
            }

            public Logger logger() {
                if (!this.bitmap$0) {
                    return this.logger$lzycompute();
                }
                return this.logger;
            }

            public String logIdent() {
                return this.logIdent;
            }

            public void logIdent_$eq(String x$1) {
                this.logIdent = x$1;
            }

            public void error(Function0<String> msg, Function0<Throwable> e) {
                Class<?> clazz = e.apply().getClass();
                this.errorCounts$1.update(clazz, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.errorCounts$1.apply(clazz)) + 1)));
                if (this.logger().underlying().isErrorEnabled()) {
                    String msgWithLogIdent_msg = (String)msg.apply();
                    Object var4_4 = null;
                    this.logger().underlying().error(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg), (Throwable)e.apply());
                    return;
                }
            }

            public void debug(Function0<String> msg, Function0<Throwable> e) {
                Class<?> clazz = e.apply().getClass();
                this.debugCounts$1.update(clazz, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.debugCounts$1.apply(clazz)) + 1)));
                if (this.logger().underlying().isDebugEnabled()) {
                    String msgWithLogIdent_msg = (String)msg.apply();
                    Object var4_4 = null;
                    this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg), (Throwable)e.apply());
                    return;
                }
            }

            public void warn(Function0<String> msg, Function0<Throwable> e) {
                Class<?> clazz = e.apply().getClass();
                this.warnCounts$1.update(clazz, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.warnCounts$1.apply(clazz)) + 1)));
                if (this.logger().underlying().isDebugEnabled()) {
                    String msgWithLogIdent_msg = (String)msg.apply();
                    Object var4_4 = null;
                    this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)this, (String)msgWithLogIdent_msg), (Throwable)e.apply());
                    return;
                }
            }
            {
                this.errorCounts$1 = errorCounts$1;
                this.debugCounts$1 = debugCounts$1;
                this.warnCounts$1 = warnCounts$1;
            }
        };
        ClusterLinkDynamicLogger dynamicLogger = new ClusterLinkDynamicLogger(logging, 4, 2, 50);
        ClusterLinkUtilsTest.clearCounts$1((scala.collection.immutable.Seq)exceptions, errorCounts, debugCounts, warnCounts);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> ClusterLinkUtilsTest.$anonfun$testDynamicLogger$2(dynamicLogger, e1, errorCounts, warnCounts, debugCounts, (scala.collection.immutable.Seq)exceptions, arg_0)));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> ClusterLinkUtilsTest.$anonfun$testDynamicLogger$4(dynamicLogger, e1, e2, errorCounts, warnCounts, debugCounts, (scala.collection.immutable.Seq)exceptions, arg_0)));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> dynamicLogger.error(new StringBuilder(5).append("test ").append(i).toString(), (Throwable)e1));
        ClusterLinkUtilsTest.verifyCounts$1(e1, 10, 0, 0, errorCounts, warnCounts, debugCounts, dynamicLogger);
        ClusterLinkUtilsTest.clearCounts$1((scala.collection.immutable.Seq)exceptions, errorCounts, debugCounts, warnCounts);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> dynamicLogger.error("test", (Throwable)new RuntimeException(new StringBuilder(5).append("test ").append(i).toString(), e1)));
        ClusterLinkUtilsTest.verifyCounts$1(e1, 10, 0, 0, errorCounts, warnCounts, debugCounts, dynamicLogger);
        ClusterLinkUtilsTest.clearCounts$1((scala.collection.immutable.Seq)exceptions, errorCounts, debugCounts, warnCounts);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int n = i % 3;
            switch (n) {
                case 0: {
                    dynamicLogger.error("test", (Throwable)e1);
                    return;
                }
                case 1: {
                    dynamicLogger.error("test", (Throwable)e2);
                    return;
                }
                case 2: {
                    dynamicLogger.error("test", (Throwable)e3);
                    return;
                }
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        });
        exceptions.foreach((Function1 & Serializable)e -> {
            ClusterLinkUtilsTest.verifyCounts$1(e, 10, 0, 0, errorCounts, warnCounts, debugCounts, dynamicLogger);
            return BoxedUnit.UNIT;
        });
        dynamicLogger.resetErrors();
        ClusterLinkUtilsTest.clearCounts$1((scala.collection.immutable.Seq)exceptions, errorCounts, debugCounts, warnCounts);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> dynamicLogger.error(e1.getMessage(), (Throwable)e1));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> dynamicLogger.error(e2.getMessage(), (Throwable)e2));
        ClusterLinkUtilsTest.verifyCounts$1(e1, 4, 2, 94, errorCounts, warnCounts, debugCounts, dynamicLogger);
        ClusterLinkUtilsTest.verifyCounts$1(e2, 4, 4, 192, errorCounts, warnCounts, debugCounts, dynamicLogger);
        ClusterLinkUtilsTest.clearCounts$1((scala.collection.immutable.Seq)exceptions, errorCounts, debugCounts, warnCounts);
    }

    @Test
    public void testisBootstrapConfluentCloudHost() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig brokerConfigs = KafkaConfig$.MODULE$.fromProps(props);
        Assertions.assertFalse((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(brokerConfigs, ClusterLinkUtilsTest.linkConfig$1("localhost:2345")));
        Assertions.assertFalse((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(brokerConfigs, ClusterLinkUtilsTest.linkConfig$1("PLAINTEXT://:2345")));
        Assertions.assertFalse((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(brokerConfigs, ClusterLinkUtilsTest.linkConfig$1("localhost:2345,test.stag.cpdev.cloud:9002")));
        Assertions.assertTrue((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(brokerConfigs, ClusterLinkUtilsTest.linkConfig$1("test.stag.cpdev.cloud:9002")));
        Assertions.assertTrue((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(brokerConfigs, ClusterLinkUtilsTest.linkConfig$1("test.devel.cpdev.cloud:9003")));
        Assertions.assertTrue((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(brokerConfigs, ClusterLinkUtilsTest.linkConfig$1("foo.bar.us-west2.aws.confluent.cloud:9003")));
        Assertions.assertTrue((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(brokerConfigs, ClusterLinkUtilsTest.linkConfig$1("foo.bar.us-west2.aws.confluent.cloud:9003,foo.bar.us-east2.aws.confluent.cloud:9003")));
        Assertions.assertTrue((boolean)ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(brokerConfigs, ClusterLinkUtilsTest.linkConfig$1("SASL_PLAINTEXT://foo.bar.us-west2.aws.confluent.cloud:9003")));
    }

    @Test
    public void testMaxCreateClusterLinksTimeoutMs() {
        int fiveMins = 300000;
        Assertions.assertEquals((Object)None$.MODULE$, (Object)ClusterLinkUtils$.MODULE$.checkTimeoutMs(fiveMins));
        InvalidRequestException exception = new InvalidRequestException("Timeout of 300001(ms) is above maximum allowed of 300000(ms).");
        Option actual = ClusterLinkUtils$.MODULE$.checkTimeoutMs(fiveMins + 1);
        Assertions.assertTrue((boolean)actual.isDefined());
        Assertions.assertEquals((Object)exception.getMessage(), (Object)((Throwable)actual.get()).getMessage());
    }

    private Config makeConfig(scala.collection.immutable.Seq<Tuple3<String, String, Object>> entries) {
        scala.collection.immutable.Seq configEntries = (scala.collection.immutable.Seq)entries.map((Function1 & Serializable)entry -> {
            ConfigEntry.ConfigSource source = BoxesRunTime.unboxToBoolean((Object)entry._3()) ? ConfigEntry.ConfigSource.DEFAULT_CONFIG : ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG;
            return new ConfigEntry((String)entry._1(), (String)entry._2(), source, false, false, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava(), ConfigEntry.ConfigType.UNKNOWN, null);
        });
        return new Config(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)configEntries).asJavaCollection());
    }

    private Properties makeProperties(scala.collection.immutable.Seq<Tuple2<String, String>> entries) {
        Properties props = new Properties();
        entries.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String name = (String)x0$1._1();
                String value = (String)x0$1._2();
                return props.put(name, value);
            }
            throw new MatchError(null);
        });
        return props;
    }

    private CreateTopicsRequestData.CreatableTopic makeCreatableTopic(String name, int numPartitions, Option<String> linkName, Option<String> mirrorTopic) {
        return new CreateTopicsRequestData.CreatableTopic().setName(name).setNumPartitions(numPartitions).setReplicationFactor((short)3).setLinkName((String)linkName.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setMirrorTopic((String)mirrorTopic.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private static final void assertValid$1(String linkName) {
        ClusterLinkUtils.validateLinkNameOrThrow((String)linkName);
    }

    private static final void assertInvalid$1(String linkName) {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ClusterLinkUtils$.MODULE$.validateLinkName(linkName), ClassTag$.MODULE$.apply(InvalidClusterLinkException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
    }

    public static final /* synthetic */ ClusterLinkUtils.ResolveCreateTopic $anonfun$testResolveCreateMirrorTopicErrors$9(ClusterLinkUtilsTest $this, List partitionInfos$1, String topic$1, String linkName$2, Uuid linkId$1, Properties validConfigs$1) {
        TopicDescription description = new TopicDescription("test-topic", false, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionInfos$1).asJava());
        CompletableFuture<ClusterLinkTopicInfo> future = new CompletableFuture<ClusterLinkTopicInfo>();
        future.complete(new ClusterLinkTopicInfo(description, $this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())), (Seq)package$.MODULE$.Seq().empty()));
        return ClusterLinkUtils$.MODULE$.resolveCreateTopic($this.makeCreatableTopic(topic$1, -1, (Option<String>)new Some((Object)linkName$2), (Option<String>)new Some((Object)topic$1)), (Option)new Some((Object)linkId$1), validConfigs$1, false, (Option)new Some((Object)$this.linkConfig()), (Option)new Some(future), "");
    }

    public static final /* synthetic */ ClusterLinkUtils.ResolveCreateTopic $anonfun$testResolveCreateMirrorTopicErrors$10(ClusterLinkUtilsTest $this, List partitionInfos$1, String topic$1, String linkName$2, Properties validConfigs$1) {
        scala.collection.immutable.Set authorizedOperations = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ}));
        TopicDescription description = new TopicDescription("test-topic", false, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionInfos$1).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)authorizedOperations).asJava());
        CompletableFuture<ClusterLinkTopicInfo> future = new CompletableFuture<ClusterLinkTopicInfo>();
        future.complete(new ClusterLinkTopicInfo(description, $this.makeConfig((scala.collection.immutable.Seq<Tuple3<String, String, Object>>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())), (Seq)package$.MODULE$.Seq().empty()));
        return ClusterLinkUtils$.MODULE$.resolveCreateTopic($this.makeCreatableTopic(topic$1, -1, (Option<String>)new Some((Object)linkName$2), (Option<String>)new Some((Object)topic$1)), (Option)None$.MODULE$, validConfigs$1, false, (Option)new Some((Object)$this.linkConfig()), (Option)new Some(future), "");
    }

    private static final ClusterLinkFilterInfo filterInfo$1(String name, PatternType patternType, String filterType) {
        return new ClusterLinkFilterInfo(name, patternType, filterType, (ClusterLinkFilter)new TopicClusterLinkFilter(name, patternType.name(), filterType));
    }

    private static final scala.collection.immutable.Set filter$1(scala.collection.immutable.Set items, scala.collection.immutable.Seq filters) {
        return (scala.collection.immutable.Set)ClusterLinkUtils$.MODULE$.doFilterTopics(items, filters)._1();
    }

    private static final GroupClusterLinkFilterInfo filterInfo$2(String name, PatternType patternType, String filterType, scala.collection.immutable.Set topicTypes) {
        return new GroupClusterLinkFilterInfo(new ClusterLinkFilterInfo(name, patternType, filterType, (ClusterLinkFilter)new TopicClusterLinkFilter(name, patternType.name(), filterType)), topicTypes.toSeq());
    }

    private static final scala.collection.immutable.Set filter$2(scala.collection.immutable.Set items, scala.collection.immutable.Seq filters) {
        return (scala.collection.immutable.Set)ClusterLinkUtils$.MODULE$.doFilterGroups(items, filters)._1();
    }

    private static final GroupClusterLinkFilterInfo filterInfo$3(String name, PatternType patternType, String filterType, scala.collection.immutable.Set topicTypes) {
        return new GroupClusterLinkFilterInfo(new ClusterLinkFilterInfo(name, patternType, filterType, (ClusterLinkFilter)new TopicClusterLinkFilter(name, patternType.name(), filterType)), topicTypes.toSeq());
    }

    private static final scala.collection.immutable.Set filter$3(scala.collection.immutable.Set items, scala.collection.immutable.Seq filters) {
        return (scala.collection.immutable.Set)ClusterLinkUtils$.MODULE$.doFilterGroups(items, filters)._1();
    }

    private static final void clearCounts$1(scala.collection.immutable.Seq exceptions$1, scala.collection.mutable.Map errorCounts$1, scala.collection.mutable.Map debugCounts$1, scala.collection.mutable.Map warnCounts$1) {
        exceptions$1.foreach((Function1 & Serializable)e -> {
            errorCounts$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getClass()), (Object)BoxesRunTime.boxToInteger((int)0)));
            debugCounts$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getClass()), (Object)BoxesRunTime.boxToInteger((int)0)));
            return (scala.collection.mutable.Map)warnCounts$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getClass()), (Object)BoxesRunTime.boxToInteger((int)0)));
        });
    }

    private static final void verifyCounts$1(Throwable e, int expectedErrors, int expectedWarn, int expectedDebug, scala.collection.mutable.Map errorCounts$1, scala.collection.mutable.Map warnCounts$1, scala.collection.mutable.Map debugCounts$1, ClusterLinkDynamicLogger dynamicLogger$1) {
        Assertions.assertEquals((int)expectedErrors, (int)BoxesRunTime.unboxToInt((Object)errorCounts$1.apply(e.getClass())), (String)"Incorrect error count");
        Assertions.assertEquals((int)expectedWarn, (int)BoxesRunTime.unboxToInt((Object)warnCounts$1.apply(e.getClass())), (String)"Incorrect warn count");
        Assertions.assertEquals((int)expectedDebug, (int)BoxesRunTime.unboxToInt((Object)debugCounts$1.apply(e.getClass())), (String)"Incorrect debug count");
        dynamicLogger$1.resetErrors();
    }

    public static final /* synthetic */ void $anonfun$testDynamicLogger$2(ClusterLinkDynamicLogger dynamicLogger$1, RuntimeException e1$1, scala.collection.mutable.Map errorCounts$1, scala.collection.mutable.Map warnCounts$1, scala.collection.mutable.Map debugCounts$1, scala.collection.immutable.Seq exceptions$1, int x$1) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> dynamicLogger$1.error(e1$1.getMessage(), (Throwable)e1$1));
        ClusterLinkUtilsTest.verifyCounts$1(e1$1, 4, 0, 6, errorCounts$1, warnCounts$1, debugCounts$1, dynamicLogger$1);
        ClusterLinkUtilsTest.clearCounts$1(exceptions$1, errorCounts$1, debugCounts$1, warnCounts$1);
    }

    public static final /* synthetic */ void $anonfun$testDynamicLogger$4(ClusterLinkDynamicLogger dynamicLogger$1, RuntimeException e1$1, IllegalStateException e2$1, scala.collection.mutable.Map errorCounts$1, scala.collection.mutable.Map warnCounts$1, scala.collection.mutable.Map debugCounts$1, scala.collection.immutable.Seq exceptions$1, int x$3) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int n = i % 2;
            switch (n) {
                case 0: {
                    dynamicLogger$1.error(e1$1.getMessage(), (Throwable)e1$1);
                    return;
                }
                case 1: {
                    dynamicLogger$1.error(e2$1.getMessage(), (Throwable)e2$1);
                    return;
                }
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        });
        ClusterLinkUtilsTest.verifyCounts$1(e1$1, 4, 0, 6, errorCounts$1, warnCounts$1, debugCounts$1, dynamicLogger$1);
        ClusterLinkUtilsTest.verifyCounts$1(e2$1, 4, 0, 6, errorCounts$1, warnCounts$1, debugCounts$1, dynamicLogger$1);
        ClusterLinkUtilsTest.clearCounts$1(exceptions$1, errorCounts$1, debugCounts$1, warnCounts$1);
    }

    private static final ClusterLinkConfig linkConfig$1(String bootstrapServers) {
        return ClusterLinkConfig$.MODULE$.create((Map)new Properties(null, bootstrapServers){
            {
                this.put("bootstrap.servers", bootstrapServers$1);
            }
        }, true);
    }
}

