/*
 * Decompiled with CFR 0.152.
 */
package kafka.test.annotation;

import java.util.function.Consumer;
import kafka.test.ClusterConfig;
import kafka.test.junit.RaftClusterInvocationContext;
import kafka.test.junit.ZkClusterInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;

public enum Type {
    KRAFT{

        @Override
        public void invocationContexts(ClusterConfig config, Consumer<TestTemplateInvocationContext> invocationConsumer) {
            invocationConsumer.accept(new RaftClusterInvocationContext(config.copyOf(), false));
        }
    }
    ,
    CO_KRAFT{

        @Override
        public void invocationContexts(ClusterConfig config, Consumer<TestTemplateInvocationContext> invocationConsumer) {
            invocationConsumer.accept(new RaftClusterInvocationContext(config.copyOf(), true));
        }
    }
    ,
    ZK{

        @Override
        public void invocationContexts(ClusterConfig config, Consumer<TestTemplateInvocationContext> invocationConsumer) {
            invocationConsumer.accept(new ZkClusterInvocationContext(config.copyOf()));
        }
    }
    ,
    ALL_NON_CORESIDENT{

        @Override
        public void invocationContexts(ClusterConfig config, Consumer<TestTemplateInvocationContext> invocationConsumer) {
            invocationConsumer.accept(new RaftClusterInvocationContext(config.copyOf(), false));
            invocationConsumer.accept(new ZkClusterInvocationContext(config.copyOf()));
        }
    }
    ,
    ALL{

        @Override
        public void invocationContexts(ClusterConfig config, Consumer<TestTemplateInvocationContext> invocationConsumer) {
            invocationConsumer.accept(new RaftClusterInvocationContext(config.copyOf(), false));
            invocationConsumer.accept(new RaftClusterInvocationContext(config.copyOf(), true));
            invocationConsumer.accept(new ZkClusterInvocationContext(config.copyOf()));
        }
    }
    ,
    DEFAULT{

        @Override
        public void invocationContexts(ClusterConfig config, Consumer<TestTemplateInvocationContext> invocationConsumer) {
            throw new UnsupportedOperationException("Cannot create invocation contexts for DEFAULT type");
        }
    };


    public abstract void invocationContexts(ClusterConfig var1, Consumer<TestTemplateInvocationContext> var2);
}

