/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import kafka.tier.Generators$;
import kafka.tier.OffsetRange;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.TierAbortedTxnReader;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.scalacheck.Arbitrary;
import org.scalacheck.Arbitrary$;
import org.scalacheck.Gen;
import org.scalacheck.Gen$;
import org.scalacheck.Prop;
import org.scalacheck.Prop$;
import org.scalacheck.Shrink;
import org.scalacheck.Shrink$;
import org.scalacheck.Test;
import org.scalacheck.util.Buildable$;
import org.scalacheck.util.Pretty;
import org.scalacheck.util.Pretty$;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.anyvals.PosInt;
import org.scalactic.anyvals.PosInt$;
import org.scalactic.source.Position;
import org.scalatest.FunSuite;
import org.scalatest.prop.Configuration;
import org.scalatest.prop.Configuration$MaxDiscarded$;
import org.scalatest.prop.Configuration$MaxDiscardedFactor$;
import org.scalatest.prop.Configuration$MaxSize$;
import org.scalatest.prop.Configuration$MinSize$;
import org.scalatest.prop.Configuration$MinSuccessful$;
import org.scalatest.prop.Configuration$PropertyCheckConfig$;
import org.scalatest.prop.Configuration$PropertyCheckConfiguration$;
import org.scalatest.prop.Configuration$SizeRange$;
import org.scalatest.prop.Configuration$Workers$;
import org.scalatestplus.scalacheck.CheckerAsserting;
import org.scalatestplus.scalacheck.CheckerAsserting$;
import org.scalatestplus.scalacheck.Checkers;
import org.scalatestplus.scalacheck.ScalaCheckConfiguration;
import org.scalatestplus.scalacheck.ScalaCheckConfiguration$InternalPropertyCheckConfiguration$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.Function6;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Buffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@Tag(value="propertybased")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015c\u0001\u0002\t\u0012\u0001YAQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013\rC\u0006\u0003\u00046\u0001\u0001\u0006I!\f\u0005\bm\u0001\u0011\r\u0011b\u00038\u0011\u0019q\u0005\u0001)A\u0005q!9q\n\u0001b\u0001\n\u0017\u0001\u0006B\u00021\u0001A\u0003%\u0011\u000bC\u0003b\u0001\u0011\u0005!\rC\u0003s\u0001\u0011%1\u000fC\u0003z\u0001\u0011%!\u0010C\u0003}\u0001\u0011\u0005!\rC\u0003\u007f\u0001\u0011\u0005!\rC\u0004\u0002\u0002\u0001!I!a\u0001\t\u000f\u0005e\u0001\u0001\"\u0003\u0002\u001c!1\u00111\u0007\u0001\u0005\u0002\t\u0014\u0001\u0005V5fe\u0006\u0013wN\u001d;fIRChNU3bI\u0016\u0014\bK]8qKJ$\u0018\u0010V3ti*\u0011!cE\u0001\u0005i&,'OC\u0001\u0015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\f !\tAR$D\u0001\u001a\u0015\tQ2$A\u0005tG\u0006d\u0017\r^3ti*\tA$A\u0002pe\u001eL!AH\r\u0003\u0011\u0019+hnU;ji\u0016\u0004\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\u0015M\u001c\u0017\r\\1dQ\u0016\u001c7N\u0003\u0002%7\u0005i1oY1mCR,7\u000f\u001e9mkNL!AJ\u0011\u0003\u0011\rCWmY6feN\fa\u0001P5oSRtD#A\u0015\u0011\u0005)\u0002Q\"A\t\u0002+\u001d,g.\u001a:bi>\u0014HI]5wK:\u001cuN\u001c4jOV\tQ\u0006\u0005\u0002/_5\t\u0001!\u0003\u00021c\tQ\u0002K]8qKJ$\u0018p\u00115fG.\u001cuN\u001c4jOV\u0014\u0018\r^5p]&\u0011!g\r\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u000b\u0005QJ\u0012\u0001\u00029s_B\facZ3oKJ\fGo\u001c:Ee&4XM\\\"p]\u001aLw\rI\u0001\u0010CJ\u0014wJ\u001a4tKR\u0014\u0016M\\4fgV\t\u0001\bE\u0002:wuj\u0011A\u000f\u0006\u0003EmI!\u0001\u0010\u001e\u0003\u0013\u0005\u0013(-\u001b;sCJL\bc\u0001 I\u0017:\u0011q(\u0012\b\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005V\ta\u0001\u0010:p_Rt\u0014\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019;\u0015a\u00029bG.\fw-\u001a\u0006\u0002\t&\u0011\u0011J\u0013\u0002\u0004'\u0016\f(B\u0001$H!\tQC*\u0003\u0002N#\tYqJ\u001a4tKR\u0014\u0016M\\4f\u0003A\t'OY(gMN,GOU1oO\u0016\u001c\b%\u0001\bbe\n\f%m\u001c:uK\u0012$\u0006P\\:\u0016\u0003E\u00032!O\u001eS!\rq\u0004j\u0015\t\u0003)zk\u0011!\u0016\u0006\u0003-^\u000b1\u0001\\8h\u0015\tA\u0016,A\u0005j]R,'O\\1mg*\u0011!lW\u0001\bgR|'/Y4f\u0015\t!BL\u0003\u0002^7\u00051\u0011\r]1dQ\u0016L!aX+\u0003\u0015\u0005\u0013wN\u001d;fIRCh.A\bbe\n\f%m\u001c:uK\u0012$\u0006P\\:!\u0003Q!Xm\u001d;PM\u001a\u001cX\r^:N_:|Go\u001c8jGR\t1\r\u0005\u0002eK6\tq)\u0003\u0002g\u000f\n!QK\\5uQ\tA\u0001\u000e\u0005\u0002ja6\t!N\u0003\u0002lY\u0006\u0019\u0011\r]5\u000b\u00055t\u0017a\u00026va&$XM\u001d\u0006\u0003_n\tQA[;oSRL!!\u001d6\u0003\tQ+7\u000f^\u0001\u0015G\",7m[#naRLxJ\u001d(p]\u0016k\u0007\u000f^=\u0015\u0005Q<\bCA\u001dv\u0013\t1(H\u0001\u0003Qe>\u0004\b\"\u0002=\n\u0001\u0004\u0011\u0016aC1c_J$X\r\u001a+y]N\f1c\u00195fG.\u0014V-\u00193BY2l\u0015M]6feN$\"\u0001^>\t\u000baT\u0001\u0019\u0001*\u0002EQ,7\u000f^*fe&\fG.\u001b>j]\u001e\f%m\u001c:uK\u0012$&/\u00198tC\u000e$\u0018n\u001c8tQ\tY\u0001.\u0001\u0012uKN$Hj\\2bi\u0016\u001c\u0006/Z2jM&\u001cGK]1og\u0006\u001cG/[8o%\u0006tw-\u001a\u0015\u0003\u0019!\f1dZ3o\u001d>t7+Z9vK:$\u0018.\u00197BE>\u0014H/\u001a3Uq:\u001cHCBA\u0003\u0003\u0017\t)\u0002\u0005\u0003:\u0003\u000f\u0019\u0016bAA\u0005u\t\u0019q)\u001a8\t\u000f\u00055Q\u00021\u0001\u0002\u0010\u0005)1\u000f^1siB\u0019A-!\u0005\n\u0007\u0005MqIA\u0002J]RDq!a\u0006\u000e\u0001\u0004\ty!A\u0002f]\u0012\f\u0011#\u00192peR,G\r\u0016=o\u0013:\u0014\u0016M\\4f)\u0019\ti\"!\u000b\u00022A1A-a\bT\u0003GI1!!\tH\u0005%1UO\\2uS>t\u0017\u0007E\u0002e\u0003KI1!a\nH\u0005\u001d\u0011un\u001c7fC:Dq!!\u0004\u000f\u0001\u0004\tY\u0003E\u0002e\u0003[I1!a\fH\u0005\u0011auN\\4\t\u000f\u0005]a\u00021\u0001\u0002,\u0005!C/Z:u\u001d>t7+Z9vK:$\u0018.\u00197BE>\u0014H/\u001a3Ue\u0006t7/Y2uS>t7\u000f\u000b\u0002\u0010Q\":\u0001!!\u000f\u0002@\u0005\u0005\u0003cA5\u0002<%\u0019\u0011Q\b6\u0003\u0007Q\u000bw-A\u0003wC2,X-\t\u0002\u0002D\u0005i\u0001O]8qKJ$\u0018PY1tK\u0012\u0004")
public class TierAbortedTxnReaderPropertyTest
extends FunSuite
implements Checkers {
    private final Configuration.PropertyCheckConfiguration generatorDrivenConfig;
    private final Arbitrary<scala.collection.immutable.Seq<OffsetRange>> arbOffsetRanges;
    private final Arbitrary<scala.collection.immutable.Seq<AbortedTxn>> arbAbortedTxns;
    private volatile ScalaCheckConfiguration$InternalPropertyCheckConfiguration$ InternalPropertyCheckConfiguration$module;
    private volatile Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration$module;
    private volatile Configuration$PropertyCheckConfig$ PropertyCheckConfig$module;
    private volatile Configuration$MinSuccessful$ MinSuccessful$module;
    private volatile Configuration$MaxDiscarded$ MaxDiscarded$module;
    private volatile Configuration$MaxDiscardedFactor$ MaxDiscardedFactor$module;
    private volatile Configuration$MinSize$ MinSize$module;
    private volatile Configuration$MaxSize$ MaxSize$module;
    private volatile Configuration$SizeRange$ SizeRange$module;
    private volatile Configuration$Workers$ Workers$module;

    public <A1, P, ASSERTION> Object check(Function1<A1, P> f, scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, Function1<P, Prop> p, Arbitrary<A1> a1, Shrink<A1> s1, Function1<A1, Pretty> pp1, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, f, configParams, (Configuration.PropertyCheckConfigurable)config, p, a1, s1, pp1, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A1, A2, P, ASSERTION> Object check(Function2<A1, A2, P> f, scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, Function1<P, Prop> p, Arbitrary<A1> a1, Shrink<A1> s1, Function1<A1, Pretty> pp1, Arbitrary<A2> a2, Shrink<A2> s2, Function1<A2, Pretty> pp2, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, f, configParams, (Configuration.PropertyCheckConfigurable)config, p, a1, s1, pp1, a2, s2, pp2, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A1, A2, A3, P, ASSERTION> Object check(Function3<A1, A2, A3, P> f, scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, Function1<P, Prop> p, Arbitrary<A1> a1, Shrink<A1> s1, Function1<A1, Pretty> pp1, Arbitrary<A2> a2, Shrink<A2> s2, Function1<A2, Pretty> pp2, Arbitrary<A3> a3, Shrink<A3> s3, Function1<A3, Pretty> pp3, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, f, configParams, (Configuration.PropertyCheckConfigurable)config, p, a1, s1, pp1, a2, s2, pp2, a3, s3, pp3, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A1, A2, A3, A4, P, ASSERTION> Object check(Function4<A1, A2, A3, A4, P> f, scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, Function1<P, Prop> p, Arbitrary<A1> a1, Shrink<A1> s1, Function1<A1, Pretty> pp1, Arbitrary<A2> a2, Shrink<A2> s2, Function1<A2, Pretty> pp2, Arbitrary<A3> a3, Shrink<A3> s3, Function1<A3, Pretty> pp3, Arbitrary<A4> a4, Shrink<A4> s4, Function1<A4, Pretty> pp4, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, f, configParams, (Configuration.PropertyCheckConfigurable)config, p, a1, s1, pp1, a2, s2, pp2, a3, s3, pp3, a4, s4, pp4, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A1, A2, A3, A4, A5, P, ASSERTION> Object check(Function5<A1, A2, A3, A4, A5, P> f, scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, Function1<P, Prop> p, Arbitrary<A1> a1, Shrink<A1> s1, Function1<A1, Pretty> pp1, Arbitrary<A2> a2, Shrink<A2> s2, Function1<A2, Pretty> pp2, Arbitrary<A3> a3, Shrink<A3> s3, Function1<A3, Pretty> pp3, Arbitrary<A4> a4, Shrink<A4> s4, Function1<A4, Pretty> pp4, Arbitrary<A5> a5, Shrink<A5> s5, Function1<A5, Pretty> pp5, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, f, configParams, (Configuration.PropertyCheckConfigurable)config, p, a1, s1, pp1, a2, s2, pp2, a3, s3, pp3, a4, s4, pp4, a5, s5, pp5, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A1, A2, A3, A4, A5, A6, P, ASSERTION> Object check(Function6<A1, A2, A3, A4, A5, A6, P> f, scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, Function1<P, Prop> p, Arbitrary<A1> a1, Shrink<A1> s1, Function1<A1, Pretty> pp1, Arbitrary<A2> a2, Shrink<A2> s2, Function1<A2, Pretty> pp2, Arbitrary<A3> a3, Shrink<A3> s3, Function1<A3, Pretty> pp3, Arbitrary<A4> a4, Shrink<A4> s4, Function1<A4, Pretty> pp4, Arbitrary<A5> a5, Shrink<A5> s5, Function1<A5, Pretty> pp5, Arbitrary<A6> a6, Shrink<A6> s6, Function1<A6, Pretty> pp6, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, f, configParams, (Configuration.PropertyCheckConfigurable)config, p, a1, s1, pp1, a2, s2, pp2, a3, s3, pp3, a4, s4, pp4, a5, s5, pp5, a6, s6, pp6, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <ASSERTION> Object check(Prop p, Test.Parameters prms, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, (Prop)p, (Test.Parameters)prms, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <ASSERTION> Object check(Prop p, scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable config, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return Checkers.check$((Checkers)this, (Prop)p, configParams, (Configuration.PropertyCheckConfigurable)config, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public Configuration.PropertyCheckConfiguration PropertyCheckConfig2PropertyCheckConfiguration(Configuration.PropertyCheckConfig p) {
        return ScalaCheckConfiguration.PropertyCheckConfig2PropertyCheckConfiguration$((ScalaCheckConfiguration)this, (Configuration.PropertyCheckConfig)p);
    }

    public Test.Parameters getParams(scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfigurable c) {
        return ScalaCheckConfiguration.getParams$((ScalaCheckConfiguration)this, configParams, (Configuration.PropertyCheckConfigurable)c);
    }

    public Configuration.MinSuccessful minSuccessful(int value) {
        return Configuration.minSuccessful$((Configuration)this, (int)value);
    }

    public Configuration.MaxDiscarded maxDiscarded(int value) {
        return Configuration.maxDiscarded$((Configuration)this, (int)value);
    }

    public Configuration.MaxDiscardedFactor maxDiscardedFactor(double value) {
        return Configuration.maxDiscardedFactor$((Configuration)this, (double)value);
    }

    public Configuration.MinSize minSize(int value) {
        return Configuration.minSize$((Configuration)this, (int)value);
    }

    public Configuration.MaxSize maxSize(int value) {
        return Configuration.maxSize$((Configuration)this, (int)value);
    }

    public Configuration.SizeRange sizeRange(int value) {
        return Configuration.sizeRange$((Configuration)this, (int)value);
    }

    public Configuration.Workers workers(int value) {
        return Configuration.workers$((Configuration)this, (int)value);
    }

    public ScalaCheckConfiguration$InternalPropertyCheckConfiguration$ org$scalatestplus$scalacheck$ScalaCheckConfiguration$$InternalPropertyCheckConfiguration() {
        if (this.InternalPropertyCheckConfiguration$module == null) {
            this.org$scalatestplus$scalacheck$ScalaCheckConfiguration$$InternalPropertyCheckConfiguration$lzycompute$1();
        }
        return this.InternalPropertyCheckConfiguration$module;
    }

    public Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration() {
        if (this.PropertyCheckConfiguration$module == null) {
            this.PropertyCheckConfiguration$lzycompute$1();
        }
        return this.PropertyCheckConfiguration$module;
    }

    public Configuration$PropertyCheckConfig$ PropertyCheckConfig() {
        if (this.PropertyCheckConfig$module == null) {
            this.PropertyCheckConfig$lzycompute$1();
        }
        return this.PropertyCheckConfig$module;
    }

    public Configuration$MinSuccessful$ MinSuccessful() {
        if (this.MinSuccessful$module == null) {
            this.MinSuccessful$lzycompute$1();
        }
        return this.MinSuccessful$module;
    }

    public Configuration$MaxDiscarded$ MaxDiscarded() {
        if (this.MaxDiscarded$module == null) {
            this.MaxDiscarded$lzycompute$1();
        }
        return this.MaxDiscarded$module;
    }

    public Configuration$MaxDiscardedFactor$ MaxDiscardedFactor() {
        if (this.MaxDiscardedFactor$module == null) {
            this.MaxDiscardedFactor$lzycompute$1();
        }
        return this.MaxDiscardedFactor$module;
    }

    public Configuration$MinSize$ MinSize() {
        if (this.MinSize$module == null) {
            this.MinSize$lzycompute$1();
        }
        return this.MinSize$module;
    }

    public Configuration$MaxSize$ MaxSize() {
        if (this.MaxSize$module == null) {
            this.MaxSize$lzycompute$1();
        }
        return this.MaxSize$module;
    }

    public Configuration$SizeRange$ SizeRange() {
        if (this.SizeRange$module == null) {
            this.SizeRange$lzycompute$1();
        }
        return this.SizeRange$module;
    }

    public Configuration$Workers$ Workers() {
        if (this.Workers$module == null) {
            this.Workers$lzycompute$1();
        }
        return this.Workers$module;
    }

    public void org$scalatest$prop$Configuration$_setter_$generatorDrivenConfig_$eq(Configuration.PropertyCheckConfiguration x$1) {
    }

    public Configuration.PropertyCheckConfiguration generatorDrivenConfig() {
        return this.generatorDrivenConfig;
    }

    private Arbitrary<scala.collection.immutable.Seq<OffsetRange>> arbOffsetRanges() {
        return this.arbOffsetRanges;
    }

    private Arbitrary<scala.collection.immutable.Seq<AbortedTxn>> arbAbortedTxns() {
        return this.arbAbortedTxns;
    }

    @Test
    public void testOffsetsMonotonic() {
        this.check(Prop$.MODULE$.forAll((Function1 & Serializable)offsets -> {
            ObjectRef result = ObjectRef.create((Object)Prop$.MODULE$.passed());
            ObjectRef lastEndOffset = ObjectRef.create((Object)None$.MODULE$);
            offsets.foreach((Function1 & Serializable)offsetRange -> {
                TierAbortedTxnReaderPropertyTest.$anonfun$testOffsetsMonotonic$2(lastEndOffset, result, offsetRange);
                return BoxedUnit.UNIT;
            });
            return (Prop)result.elem;
        }, Predef$.MODULE$.$conforms(), this.arbOffsetRanges(), Shrink$.MODULE$.shrinkContainer(Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkAny(), Buildable$.MODULE$.buildableFactory(Seq$.MODULE$.iterableFactory())), (Function1 & Serializable)t -> Pretty$.MODULE$.prettyAny(t)).viewSeed("testOffsetsMonotonic"), (scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam>)Nil$.MODULE$, (Configuration.PropertyCheckConfigurable)this.generatorDrivenConfig(), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("TierAbortedTxnReaderPropertyTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
    }

    private Prop checkEmptyOrNonEmpty(scala.collection.immutable.Seq<AbortedTxn> abortedTxns) {
        Optional abortedTxnsBuf = AbortedTxn.serialize((List)CollectionConverters$.MODULE$.SeqHasAsJava(abortedTxns).asJava());
        return Prop$.MODULE$.propBoolean(!abortedTxnsBuf.isPresent() && abortedTxns.isEmpty() || abortedTxnsBuf.isPresent() && abortedTxns.nonEmpty());
    }

    private Prop checkReadAllMarkers(scala.collection.immutable.Seq<AbortedTxn> abortedTxns) {
        return (Prop)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(AbortedTxn.serialize((List)CollectionConverters$.MODULE$.SeqHasAsJava(abortedTxns).asJava()))).map((Function1 & Serializable)abortedTxnBuf -> {
            ByteBufferInputStream inputStream = new ByteBufferInputStream(abortedTxnBuf);
            Buffer readMarkers = CollectionConverters$.MODULE$.ListHasAsScala(TierAbortedTxnReader.readInto((CancellationContext)CancellationContext.newContext(), (InputStream)inputStream, (long)0L, (long)Long.MAX_VALUE)).asScala();
            return Prop$.MODULE$.AnyOperators((Function0 & Serializable)() -> abortedTxns.toSet(), (Function1 & Serializable)t -> Pretty$.MODULE$.prettyAny(t)).$eq$qmark((Object)readMarkers.toSet());
        }).getOrElse((Function0 & Serializable)() -> Prop$.MODULE$.undecided());
    }

    @Test
    public void testSerializingAbortedTransactions() {
        this.check(Prop$.MODULE$.forAll((Function1 & Serializable)abortedTxns -> this.checkReadAllMarkers((scala.collection.immutable.Seq<AbortedTxn>)abortedTxns).$amp$amp((Function0 & Serializable)() -> this.checkEmptyOrNonEmpty((scala.collection.immutable.Seq<AbortedTxn>)abortedTxns)), Predef$.MODULE$.$conforms(), this.arbAbortedTxns(), Shrink$.MODULE$.shrinkContainer(Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkAny(), Buildable$.MODULE$.buildableFactory(Seq$.MODULE$.iterableFactory())), (Function1 & Serializable)t -> Pretty$.MODULE$.prettyAny(t)).viewSeed("testSerializingAbortedTransactions"), (scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam>)Nil$.MODULE$, (Configuration.PropertyCheckConfigurable)this.generatorDrivenConfig(), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("TierAbortedTxnReaderPropertyTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
    }

    @Test
    public void testLocateSpecificTransactionRange() {
        this.check(Prop$.MODULE$.forAll(Generators$.MODULE$.abortedTransactionGen().suchThat((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty())).flatMap((Function1 & Serializable)abortedTxns -> Gen$.MODULE$.pick(1, (Iterable)abortedTxns).map((Function1 & Serializable)x$2 -> (AbortedTxn)x$2.head()).flatMap((Function1 & Serializable)pick -> Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToLong((long)pick.firstOffset()), (Object)BoxesRunTime.boxToLong((long)pick.lastOffset()), (scala.collection.immutable.Seq)Nil$.MODULE$, (Numeric)Numeric.LongIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseLong()).flatMap((Function1 & Serializable)startOffset -> TierAbortedTxnReaderPropertyTest.$anonfun$testLocateSpecificTransactionRange$5(pick, abortedTxns, BoxesRunTime.unboxToLong((Object)startOffset))))), (Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                scala.collection.immutable.Seq abortedTxns = (scala.collection.immutable.Seq)x0$1._1();
                AbortedTxn guaranteedItem = (AbortedTxn)x0$1._2();
                long startOffset = BoxesRunTime.unboxToLong((Object)x0$1._3());
                long lastOffset = BoxesRunTime.unboxToLong((Object)x0$1._4());
                if (abortedTxns != null && guaranteedItem != null) {
                    ByteBuffer buffer = (ByteBuffer)AbortedTxn.serialize((List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTxns).asJava()).get();
                    ByteBufferInputStream inputStream = new ByteBufferInputStream(buffer);
                    Buffer readAbortedTransactions = CollectionConverters$.MODULE$.ListHasAsScala(TierAbortedTxnReader.readInto((CancellationContext)CancellationContext.newContext(), (InputStream)inputStream, (long)startOffset, (long)lastOffset)).asScala();
                    Object[] objectArray = new Prop[1];
                    readAbortedTransactions.contains((Object)guaranteedItem);
                    readAbortedTransactions.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TierAbortedTxnReaderPropertyTest.$anonfun$testLocateSpecificTransactionRange$8(lastOffset, x$3)));
                    objectArray[0] = Prop$.MODULE$.propBoolean(!readAbortedTransactions.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TierAbortedTxnReaderPropertyTest.$anonfun$testLocateSpecificTransactionRange$9(startOffset, x$4))));
                    return Prop$.MODULE$.all((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                }
            }
            throw new MatchError(x0$1);
        }, Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkTuple4(Shrink$.MODULE$.shrinkContainer(Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkAny(), Buildable$.MODULE$.buildableFactory(Seq$.MODULE$.iterableFactory())), Shrink$.MODULE$.shrinkAny(), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.LongIsIntegral$.MODULE$), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.LongIsIntegral$.MODULE$)), (Function1 & Serializable)t -> Pretty$.MODULE$.prettyAny(t)), (scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam>)Nil$.MODULE$, (Configuration.PropertyCheckConfigurable)this.generatorDrivenConfig(), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("TierAbortedTxnReaderPropertyTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
    }

    private Gen<AbortedTxn> genNonSequentialAbortedTxns(int start, int end) {
        return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)start), (Object)BoxesRunTime.boxToInteger((int)(end - 1)), (scala.collection.immutable.Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)firstOffset -> TierAbortedTxnReaderPropertyTest.$anonfun$genNonSequentialAbortedTxns$1(end, BoxesRunTime.unboxToInt((Object)firstOffset)));
    }

    private Function1<AbortedTxn, Object> abortedTxnInRange(long start, long end) {
        return (Function1 & Serializable)abortedTxn -> BoxesRunTime.boxToBoolean((boolean)TierAbortedTxnReaderPropertyTest.$anonfun$abortedTxnInRange$1(start, end, abortedTxn));
    }

    @Test
    public void testNonSequentialAbortedTransactions() {
        this.check(Prop$.MODULE$.forAll(Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1000), (scala.collection.immutable.Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)rangeStart -> TierAbortedTxnReaderPropertyTest.$anonfun$testNonSequentialAbortedTransactions$1(this, BoxesRunTime.unboxToInt((Object)rangeStart))), (Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int fetchStart = BoxesRunTime.unboxToInt((Object)x0$1._1());
                int fetchEnd = BoxesRunTime.unboxToInt((Object)x0$1._2());
                scala.collection.immutable.Seq abortedTxns = (scala.collection.immutable.Seq)x0$1._3();
                if (abortedTxns != null) {
                    if (abortedTxns.isEmpty()) {
                        return Prop$.MODULE$.undecided();
                    }
                    ByteBuffer buffer = (ByteBuffer)AbortedTxn.serialize((List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)abortedTxns).asJava()).get();
                    ByteBufferInputStream inputStream = new ByteBufferInputStream(buffer);
                    List readAbortedTxns = TierAbortedTxnReader.readInto((CancellationContext)CancellationContext.newContext(), (InputStream)inputStream, (long)fetchStart, (long)fetchEnd);
                    scala.collection.immutable.Seq expectedAbortedTxns = (scala.collection.immutable.Seq)abortedTxns.filter(this.abortedTxnInRange(fetchStart, fetchEnd));
                    return Prop$.MODULE$.AnyOperators((Function0 & Serializable)() -> expectedAbortedTxns.toSet(), (Function1 & Serializable)t -> Pretty$.MODULE$.prettyAny(t)).$eq$qmark((Object)CollectionConverters$.MODULE$.ListHasAsScala(readAbortedTxns).asScala().toSet());
                }
            }
            throw new MatchError(x0$1);
        }, Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkTuple3(Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.IntIsIntegral$.MODULE$), Shrink$.MODULE$.shrinkIntegral((Integral)Numeric.IntIsIntegral$.MODULE$), Shrink$.MODULE$.shrinkContainer(Predef$.MODULE$.$conforms(), Shrink$.MODULE$.shrinkAny(), Buildable$.MODULE$.buildableFactory(Seq$.MODULE$.iterableFactory()))), (Function1 & Serializable)t -> Pretty$.MODULE$.prettyAny(t)).viewSeed("testNonSequentialAbortedTransactions"), (scala.collection.immutable.Seq<Configuration.PropertyCheckConfigParam>)Nil$.MODULE$, (Configuration.PropertyCheckConfigurable)this.generatorDrivenConfig(), CheckerAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("TierAbortedTxnReaderPropertyTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
    }

    private final void org$scalatestplus$scalacheck$ScalaCheckConfiguration$$InternalPropertyCheckConfiguration$lzycompute$1() {
        synchronized (this) {
            if (this.InternalPropertyCheckConfiguration$module == null) {
                this.InternalPropertyCheckConfiguration$module = new ScalaCheckConfiguration$InternalPropertyCheckConfiguration$((ScalaCheckConfiguration)this);
            }
            return;
        }
    }

    private final void PropertyCheckConfiguration$lzycompute$1() {
        synchronized (this) {
            if (this.PropertyCheckConfiguration$module == null) {
                this.PropertyCheckConfiguration$module = new Configuration$PropertyCheckConfiguration$((Configuration)this);
            }
            return;
        }
    }

    private final void PropertyCheckConfig$lzycompute$1() {
        synchronized (this) {
            if (this.PropertyCheckConfig$module == null) {
                this.PropertyCheckConfig$module = new Configuration$PropertyCheckConfig$((Configuration)this);
            }
            return;
        }
    }

    private final void MinSuccessful$lzycompute$1() {
        synchronized (this) {
            if (this.MinSuccessful$module == null) {
                this.MinSuccessful$module = new Configuration$MinSuccessful$((Configuration)this);
            }
            return;
        }
    }

    private final void MaxDiscarded$lzycompute$1() {
        synchronized (this) {
            if (this.MaxDiscarded$module == null) {
                this.MaxDiscarded$module = new Configuration$MaxDiscarded$((Configuration)this);
            }
            return;
        }
    }

    private final void MaxDiscardedFactor$lzycompute$1() {
        synchronized (this) {
            if (this.MaxDiscardedFactor$module == null) {
                this.MaxDiscardedFactor$module = new Configuration$MaxDiscardedFactor$((Configuration)this);
            }
            return;
        }
    }

    private final void MinSize$lzycompute$1() {
        synchronized (this) {
            if (this.MinSize$module == null) {
                this.MinSize$module = new Configuration$MinSize$((Configuration)this);
            }
            return;
        }
    }

    private final void MaxSize$lzycompute$1() {
        synchronized (this) {
            if (this.MaxSize$module == null) {
                this.MaxSize$module = new Configuration$MaxSize$((Configuration)this);
            }
            return;
        }
    }

    private final void SizeRange$lzycompute$1() {
        synchronized (this) {
            if (this.SizeRange$module == null) {
                this.SizeRange$module = new Configuration$SizeRange$((Configuration)this);
            }
            return;
        }
    }

    private final void Workers$lzycompute$1() {
        synchronized (this) {
            if (this.Workers$module == null) {
                this.Workers$module = new Configuration$Workers$((Configuration)this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testOffsetsMonotonic$2(ObjectRef lastEndOffset$1, ObjectRef result$1, OffsetRange offsetRange) {
        Option option = (Option)lastEndOffset$1.elem;
        if (option instanceof Some) {
            if (BoxesRunTime.unboxToLong((Object)((Some)option).value()) > offsetRange.startOffset()) {
                result$1.elem = Prop$.MODULE$.falsified();
                return;
            }
            lastEndOffset$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)offsetRange.endOffset()));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            lastEndOffset$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)offsetRange.endOffset()));
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ Tuple4 $anonfun$testLocateSpecificTransactionRange$6(scala.collection.immutable.Seq abortedTxns$3, AbortedTxn pick$1, long startOffset$1, long endOffset) {
        return new Tuple4((Object)abortedTxns$3, (Object)pick$1, (Object)BoxesRunTime.boxToLong((long)startOffset$1), (Object)BoxesRunTime.boxToLong((long)endOffset));
    }

    public static final /* synthetic */ Gen $anonfun$testLocateSpecificTransactionRange$5(AbortedTxn pick$1, scala.collection.immutable.Seq abortedTxns$3, long startOffset) {
        return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToLong((long)(pick$1.lastOffset() + 1L)), (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE), (scala.collection.immutable.Seq)Nil$.MODULE$, (Numeric)Numeric.LongIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseLong()).map((Function1 & Serializable)endOffset -> TierAbortedTxnReaderPropertyTest.$anonfun$testLocateSpecificTransactionRange$6(abortedTxns$3, pick$1, startOffset, BoxesRunTime.unboxToLong((Object)endOffset)));
    }

    public static final /* synthetic */ boolean $anonfun$testLocateSpecificTransactionRange$8(long x5$1, AbortedTxn x$3) {
        return x$3.firstOffset() > x5$1;
    }

    public static final /* synthetic */ boolean $anonfun$testLocateSpecificTransactionRange$9(long x4$1, AbortedTxn x$4) {
        return x$4.lastOffset() < x4$1;
    }

    public static final /* synthetic */ AbortedTxn $anonfun$genNonSequentialAbortedTxns$3(int firstOffset$1, int lastOffset$1, int producerId) {
        return new AbortedTxn((long)producerId, (long)firstOffset$1, (long)lastOffset$1, 0L);
    }

    public static final /* synthetic */ Gen $anonfun$genNonSequentialAbortedTxns$2(int firstOffset$1, int lastOffset) {
        return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)5), (scala.collection.immutable.Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).map((Function1 & Serializable)producerId -> TierAbortedTxnReaderPropertyTest.$anonfun$genNonSequentialAbortedTxns$3(firstOffset$1, lastOffset, BoxesRunTime.unboxToInt((Object)producerId)));
    }

    public static final /* synthetic */ Gen $anonfun$genNonSequentialAbortedTxns$1(int end$1, int firstOffset) {
        return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)(firstOffset + 1)), (Object)BoxesRunTime.boxToInteger((int)end$1), (scala.collection.immutable.Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)lastOffset -> TierAbortedTxnReaderPropertyTest.$anonfun$genNonSequentialAbortedTxns$2(firstOffset, BoxesRunTime.unboxToInt((Object)lastOffset)));
    }

    public static final /* synthetic */ boolean $anonfun$abortedTxnInRange$1(long start$1, long end$2, AbortedTxn abortedTxn) {
        return start$1 <= abortedTxn.lastOffset() && abortedTxn.firstOffset() <= end$2;
    }

    public static final /* synthetic */ Tuple3 $anonfun$testNonSequentialAbortedTransactions$5(int fetchStart$1, scala.collection.immutable.Seq abortedTxn$1, int fetchEnd) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)fetchStart$1), (Object)BoxesRunTime.boxToInteger((int)fetchEnd), (Object)abortedTxn$1);
    }

    public static final /* synthetic */ Gen $anonfun$testNonSequentialAbortedTransactions$4(int rangeEnd$1, scala.collection.immutable.Seq abortedTxn$1, int fetchStart) {
        return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)(fetchStart + 1)), (Object)BoxesRunTime.boxToInteger((int)rangeEnd$1), (scala.collection.immutable.Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).map((Function1 & Serializable)fetchEnd -> TierAbortedTxnReaderPropertyTest.$anonfun$testNonSequentialAbortedTransactions$5(fetchStart, abortedTxn$1, BoxesRunTime.unboxToInt((Object)fetchEnd)));
    }

    public static final /* synthetic */ Gen $anonfun$testNonSequentialAbortedTransactions$2(TierAbortedTxnReaderPropertyTest $this, int rangeStart$1, int rangeEnd) {
        return Gen$.MODULE$.containerOf($this.genNonSequentialAbortedTxns(rangeStart$1, rangeEnd), Buildable$.MODULE$.buildableFactory(Seq$.MODULE$.iterableFactory()), Predef$.MODULE$.$conforms()).flatMap((Function1 & Serializable)abortedTxn -> Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)rangeStart$1), (Object)BoxesRunTime.boxToInteger((int)(rangeEnd - 1)), (scala.collection.immutable.Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)fetchStart -> TierAbortedTxnReaderPropertyTest.$anonfun$testNonSequentialAbortedTransactions$4(rangeEnd, abortedTxn, BoxesRunTime.unboxToInt((Object)fetchStart))));
    }

    public static final /* synthetic */ Gen $anonfun$testNonSequentialAbortedTransactions$1(TierAbortedTxnReaderPropertyTest $this, int rangeStart) {
        return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)1001), (Object)BoxesRunTime.boxToInteger((int)2000), (scala.collection.immutable.Seq)Nil$.MODULE$, (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)rangeEnd -> TierAbortedTxnReaderPropertyTest.$anonfun$testNonSequentialAbortedTransactions$2($this, rangeStart, BoxesRunTime.unboxToInt((Object)rangeEnd)));
    }

    public TierAbortedTxnReaderPropertyTest() {
        Configuration.$init$((Configuration)this);
        ScalaCheckConfiguration.$init$((ScalaCheckConfiguration)this);
        Checkers.$init$((Checkers)this);
        this.generatorDrivenConfig = new Configuration.PropertyCheckConfiguration((Configuration)this, ((PosInt)PosInt$.MODULE$.from(10000).get()).value(), this.PropertyCheckConfiguration().apply$default$2(), this.PropertyCheckConfiguration().apply$default$3(), this.PropertyCheckConfiguration().apply$default$4(), this.PropertyCheckConfiguration().apply$default$5());
        this.arbOffsetRanges = Arbitrary$.MODULE$.apply((Function0 & Serializable)() -> Generators$.MODULE$.offsetRangesGen(0L));
        this.arbAbortedTxns = Arbitrary$.MODULE$.apply((Function0 & Serializable)() -> Generators$.MODULE$.abortedTransactionGen());
    }
}

