/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.Defaults$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.state.FileTierPartitionState;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.network.ListenerName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005ue\u0001\u0002\f\u0018\u0001qAQa\t\u0001\u0005\u0002\u0011Bqa\n\u0001C\u0002\u0013%\u0001\u0006\u0003\u00045\u0001\u0001\u0006I!\u000b\u0005\nk\u0001\u0001\r\u0011!Q!\nYBqa\u0010\u0001C\u0002\u0013E\u0003\t\u0003\u0004H\u0001\u0001\u0006I!\u0011\u0005\u0006\u0011\u0002!\t%\u0013\u0005\u0006'\u0002!\t\u0001\u0016\u0005\u0006s\u0002!\tA\u001f\u0005\u0007\u007f\u0002!\t!!\u0001\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003_\u0001A\u0011AA\u0019\u0011\u001d\tY\u0004\u0001C\u0005\u0003{Aq!!\u0013\u0001\t\u0013\tY\u0005C\u0005\u0002b\u0001\t\n\u0011\"\u0003\u0002d!9\u0011\u0011\u0010\u0001\u0005\n\u0005m\u0004\"CAE\u0001E\u0005I\u0011BA2\u0011\u001d\tY\t\u0001C\u0005\u0003\u001bCq!!&\u0001\t\u0013\t9JA\u000bUS\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:$Vm\u001d;\u000b\u0005aI\u0012\u0001\u0002;jKJT\u0011AG\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001fC5\tqD\u0003\u0002!3\u0005\u0019\u0011\r]5\n\u0005\tz\"AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005)\u0003C\u0001\u0014\u0001\u001b\u00059\u0012A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0002SA\u0011!FM\u0007\u0002W)\u0011A&L\u0001\u0007G>lWn\u001c8\u000b\u0005iq#BA\u00181\u0003\u0019\t\u0007/Y2iK*\t\u0011'A\u0002pe\u001eL!aM\u0016\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007%A\u0005`i\u0016\u001cH/\u00138g_B\u0011q'P\u0007\u0002q)\u0011\u0001%\u000f\u0006\u0003um\nqA[;qSR,'O\u0003\u0002=a\u0005)!.\u001e8ji&\u0011a\b\u000f\u0002\t)\u0016\u001cH/\u00138g_\u0006Y!M]8lKJ\u001cu.\u001e8u+\u0005\t\u0005C\u0001\"F\u001b\u0005\u0019%\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001b%aA%oi\u0006a!M]8lKJ\u001cu.\u001e8uA\u0005)1/\u001a;VaR\u0011!*\u0014\t\u0003\u0005.K!\u0001T\"\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001d\u001e\u0001\rAN\u0001\ti\u0016\u001cH/\u00138g_\"\u0012q\u0001\u0015\t\u0003oEK!A\u0015\u001d\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A#uKN$XI\\1cY\u0016\u001cu.\u001c9bGRLwN\\!gi\u0016\u0014XI\\1cY\u0016$\u0016.\u001a:Bi\n\u0013xn[3s\u0019\u00164X\r\\,ji\"$\u0016.\u001a:DY\u0016\fg.\u001a:F]\u0006\u0014G.\u001a\u000b\u0003\u0015VCQA\u0016\u0005A\u0002]\u000ba!];peVl\u0007C\u0001-`\u001d\tIV\f\u0005\u0002[\u00076\t1L\u0003\u0002]7\u00051AH]8pizJ!AX\"\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0017M\u0001\u0004TiJLgn\u001a\u0006\u0003=\u000eCC\u0001C2lYB\u0011A-[\u0007\u0002K*\u0011amZ\u0001\taJ|g/\u001b3fe*\u0011\u0001.O\u0001\u0007a\u0006\u0014\u0018-\\:\n\u0005),'a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0002n_\u0006\na.\u0001\u0002{W\u0006\n\u0001/A\u0003le\u00064G\u000f\u000b\u0003\teZ<\bCA:u\u001b\u00059\u0017BA;h\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-I\u0001y\u0003aYH-[:qY\u0006Lh*Y7f{:\nXo\u001c:v[vZ\b'`\u0001Di\u0016\u001cH/\u00128bE2,7i\\7qC\u000e$\u0018n\u001c8BMR,'/\u00128bE2,G+[3s\u0003R\u0014%o\\6fe2+g/\u001a7O_RKWM]\"mK\u0006tWM]#oC\ndW\r\u0006\u0002Kw\")a+\u0003a\u0001/\"\"\u0011bY6~Y\tiw\u000e\u000b\u0003\neZ<\u0018\u0001\u000f;fgR$\u0015n]1mY><X\rZ\"p[B\f7\r\u001e#fY\u0016$Xm\u00115b]\u001e,7oV5uQRKWM]\"mK\u0006tWM\u001d$fCR,(/\u001a\u000b\u0004\u0015\u0006\r\u0001\"\u0002,\u000b\u0001\u00049\u0006&\u0002\u0006dW\u0006\u001dAFA7pQ\u0011Q!O^<\u0002KQ,7\u000f\u001e#jg\u0006\u0014G.\u001a+jKJLgnZ,iK:\u001cV\r^!u)>\u0004\u0018n\u0019'fm\u0016dGc\u0001&\u0002\u0010!)ak\u0003a\u0001/\"*1bY6\u0002\u00141\u0012Qn\u001c\u0015\u0005\u0017I4x/\u0001\u0014uKN$H)[:bE2,G+[3sS:<w\u000b[3o'\u0016$\u0018\t\u001e\"s_.,'\u000fT3wK2$2ASA\u000e\u0011\u00151F\u00021\u0001XQ\u0015a1m[A\u0010Y\tiw\u000e\u000b\u0003\reZ<\u0018\u0001\u0010;fgR$\u0015n]1cY\u0016$\u0016.\u001a:fIN#xN]1hK\u0006#(I]8lKJdUM^3m\u0003\u001a$XM]#oC\nd\u0017N\\4Ti\u0006$\u0018nY1mYf$2ASA\u0014\u0011\u00151V\u00021\u0001XQ\u0015i1m[A\u0016Y\tiw\u000e\u000b\u0003\u000eeZ<\u0018!\u0010;fgR$\u0015n]1cY\u0016$\u0016.\u001a:fIN#xN]1hK\u0006#(I]8lKJdUM^3m\u0003\u001a$XM]#oC\nd\u0017N\\4Es:\fW.[2bY2LHc\u0001&\u00024!)aK\u0004a\u0001/\"*abY6\u000281\u0012Qn\u001c\u0015\u0005\u001dI4x/A\u0013uKN$H)[:bE2,G+[3sK\u0012\u001cFo\u001c:bO\u0016\fEO\u0011:pW\u0016\u0014H*\u001a<fYR\u0019!*a\u0010\t\u000f\u0005\u0005s\u00021\u0001\u0002D\u0005!\u0012n\u001d#z]\u0006l\u0017nY1mYf,e.\u00192mK\u0012\u00042AQA#\u0013\r\t9e\u0011\u0002\b\u0005>|G.Z1o\u0003e9W\r\u001e+jKJ,e.\u00192mK\n\u0013xn[3s\u0007>tg-[4\u0015\t\u00055\u0013Q\f\t\u0005\u0003\u001f\nI&\u0004\u0002\u0002R)!\u00111KA+\u0003\u0015\tG-\\5o\u0015\r\t9&L\u0001\bG2LWM\u001c;t\u0013\u0011\tY&!\u0015\u0003\u0017\r{gNZ5h\u000b:$(/\u001f\u0005\t\u0003?\u0002\u0002\u0013!a\u0001/\u0006QQM\u001c;jift\u0015-\\3\u0002G\u001d,G\u000fV5fe\u0016s\u0017M\u00197f\u0005J|7.\u001a:D_:4\u0017n\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\r\u0016\u0004/\u0006\u001d4FAA5!\u0011\tY'!\u001e\u000e\u0005\u00055$\u0002BA8\u0003c\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005M4)\u0001\u0006b]:|G/\u0019;j_:LA!a\u001e\u0002n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0005dG/\u001a:US\u0016\u0014XI\\1cY\u0016\u0014%o\\6fe\u000e{gNZ5h)\u0019\ti(a!\u0002\bB!\u0011qJA@\u0013\u0011\t\t)!\u0015\u0003%\u0005cG/\u001a:D_:4\u0017nZ:SKN,H\u000e\u001e\u0005\u0007\u0003\u000b\u0013\u0002\u0019A,\u0002\u0013A\u0014x\u000e\u001d,bYV,\u0007\u0002CA0%A\u0005\t\u0019A,\u0002K\u0005dG/\u001a:US\u0016\u0014XI\\1cY\u0016\u0014%o\\6fe\u000e{gNZ5hI\u0011,g-Y;mi\u0012\u0012\u0014\u0001E1mi\u0016\u0014Hk\u001c9jG\u000e{gNZ5h)\u0019\ti(a$\u0002\u0014\"1\u0011\u0011\u0013\u000bA\u0002]\u000bq\u0001\u001d:pa.+\u0017\u0010\u0003\u0004\u0002\u0006R\u0001\raV\u0001\u000eCN\u001cXM\u001d;J]Z\fG.\u001b3\u0015\u0007)\u000bI\nC\u0004\u0002\u001cV\u0001\r!! \u0002\rI,7/\u001e7u\u0001")
public class TierConfigurationTest
extends IntegrationTestHarness {
    private final TopicPartition topicPartition;
    private TestInfo _testInfo;
    private final int brokerCount;

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo = testInfo;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testEnableCompactionAfterEnableTierAtBrokerLevelWithTierCleanerEnable(String quorum) {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierCleanerEnableProp(), "true");
        this.controllerConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.controllerConfig().setProperty(KafkaConfig$.MODULE$.TierCleanerEnableProp(), "true");
        super.setUp(this._testInfo);
        String x$1 = this.topicPartition().topic();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(x$1, x$3, 2, x$4, x$5, x$6);
        this.waitUntilLogCreatedOnBrokers(this.topicPartition(), this.brokers());
        this.alterTopicConfig("cleanup.policy", "compact").all().get(5L, TimeUnit.SECONDS);
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierConfigurationTest.$anonfun$testEnableCompactionAfterEnableTierAtBrokerLevelWithTierCleanerEnable$1(this, broker);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testEnableCompactionAfterEnableTierAtBrokerLevelNoTierCleanerEnable(String quorum) {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierCleanerFeatureEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCleanupEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCleanupDelayMsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCleanupIntervalMsProp(), "5");
        this.controllerConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.controllerConfig().setProperty(KafkaConfig$.MODULE$.TierCleanerEnableProp(), "false");
        super.setUp(this._testInfo);
        String x$1 = this.topicPartition().topic();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(x$1, x$3, 2, x$4, x$5, x$6);
        this.waitUntilLogCreatedOnBrokers(this.topicPartition(), this.brokers());
        try {
            this.alterTopicConfig("cleanup.policy", "compact").all().get();
            Assertions.fail((String)"Alter should have failed");
        }
        catch (Exception exception) {}
        this.assertInvalid(this.alterTopicConfig("cleanup.policy", "compact"));
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierConfigurationTest.$anonfun$testEnableCompactionAfterEnableTierAtBrokerLevelNoTierCleanerEnable$1(this, broker);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDisallowedCompactDeleteChangesWithTierCleanerFeature(String quorum) {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierCleanerEnableProp(), "true");
        this.controllerConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.controllerConfig().setProperty(KafkaConfig$.MODULE$.TierCleanerEnableProp(), "true");
        super.setUp(this._testInfo);
        Properties topicConfig = new Properties();
        topicConfig.setProperty("cleanup.policy", "compact");
        String x$1 = this.topicPartition().topic();
        int x$4 = this.createTopic$default$2();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(x$1, x$4, 2, topicConfig, x$5, x$6);
        this.waitUntilLogCreatedOnBrokers(this.topicPartition(), this.brokers());
        this.alterTopicConfig("cleanup.policy", "compact").all().get(5L, TimeUnit.SECONDS);
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisallowedCompactDeleteChangesWithTierCleanerFeature$1(this, broker);
            return BoxedUnit.UNIT;
        });
        this.alterTopicConfig("cleanup.policy", "delete");
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisallowedCompactDeleteChangesWithTierCleanerFeature$2(this, broker);
            return BoxedUnit.UNIT;
        });
        this.assertInvalid(this.alterTopicConfig("cleanup.policy", "delete,compact"));
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisallowedCompactDeleteChangesWithTierCleanerFeature$5(this, broker);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDisableTieringWhenSetAtTopicLevel(String quorum) {
        super.setUp(this._testInfo);
        Properties topicConfig = new Properties();
        topicConfig.setProperty("confluent.tier.enable", "true");
        String x$1 = this.topicPartition().topic();
        int x$4 = this.createTopic$default$2();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(x$1, x$4, 2, topicConfig, x$5, x$6);
        this.waitUntilLogCreatedOnBrokers(this.topicPartition(), this.brokers());
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtTopicLevel$1(this, broker);
            return BoxedUnit.UNIT;
        });
        this.alterTopicConfig("confluent.tier.enable", "false").all().get(5L, TimeUnit.SECONDS);
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtTopicLevel$2(this, broker);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDisableTieringWhenSetAtBrokerLevel(String quorum) {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        super.setUp(this._testInfo);
        String x$1 = this.topicPartition().topic();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(x$1, x$3, 2, x$4, x$5, x$6);
        this.waitUntilLogCreatedOnBrokers(this.topicPartition(), this.brokers());
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtBrokerLevel$1(this, broker);
            return BoxedUnit.UNIT;
        });
        this.alterTopicConfig("confluent.tier.enable", "false").all().get(5L, TimeUnit.SECONDS);
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtBrokerLevel$2(this, broker);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDisableTieredStorageAtBrokerLevelAfterEnablingStatically(String quorum) {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierCleanerEnableProp(), "true");
        super.setUp(this._testInfo);
        this.testDisableTieredStorageAtBrokerLevel(false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDisableTieredStorageAtBrokerLevelAfterEnablingDynamically(String quorum) {
        super.setUp(this._testInfo);
        this.alterTierEnableBrokerConfig("true", "").all().get(5L, TimeUnit.SECONDS);
        this.testDisableTieredStorageAtBrokerLevel(true);
    }

    private void testDisableTieredStorageAtBrokerLevel(boolean isDynamicallyEnabled) {
        String x$1 = this.topicPartition().topic();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(x$1, x$3, 2, x$4, x$5, x$6);
        this.waitUntilLogCreatedOnBrokers(this.topicPartition(), this.brokers());
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$1(this, broker);
            return BoxedUnit.UNIT;
        });
        int brokerToUpdate = ((KafkaBroker)this.brokers().head()).config().brokerId();
        this.alterTierEnableBrokerConfig("false", Integer.toString(brokerToUpdate)).all().get(5L, TimeUnit.SECONDS);
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$2(this, brokerToUpdate, isDynamicallyEnabled, broker);
            return BoxedUnit.UNIT;
        });
        this.alterTierEnableBrokerConfig("false", "").all().get(5L, TimeUnit.SECONDS);
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$5(this, broker);
            return BoxedUnit.UNIT;
        });
        ConfigEntry tierEnableConfig = this.getTierEnableBrokerConfig("");
        Assertions.assertFalse((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(tierEnableConfig.value())));
        Assertions.assertEquals((Object)ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, (Object)tierEnableConfig.source());
    }

    private ConfigEntry getTierEnableBrokerConfig(String entityName) {
        ConfigEntry configEntry;
        try (ConfluentAdmin adminClient = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());){
            ConfigResource brokerConfigResource = new ConfigResource(ConfigResource.Type.BROKER, entityName.toString());
            configEntry = ((Config)((Map)adminClient.describeConfigs(Collections.singleton(brokerConfigResource)).all().get()).get(brokerConfigResource)).get(KafkaConfig$.MODULE$.TierEnableProp());
        }
        return configEntry;
    }

    private String getTierEnableBrokerConfig$default$1() {
        return "";
    }

    private AlterConfigsResult alterTierEnableBrokerConfig(String propValue, String entityName) {
        AlterConfigsResult alterConfigsResult;
        AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.TierEnableProp(), propValue), AlterConfigOp.OpType.SET);
        Map<ConfigResource, Set<AlterConfigOp>> toSetOnBroker = Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, entityName), Collections.singleton(alterConfigOp));
        try (ConfluentAdmin adminClient = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());){
            alterConfigsResult = adminClient.incrementalAlterConfigs(toSetOnBroker);
        }
        return alterConfigsResult;
    }

    private String alterTierEnableBrokerConfig$default$2() {
        return "";
    }

    private AlterConfigsResult alterTopicConfig(String propKey, String propValue) {
        AlterConfigsResult alterConfigsResult;
        AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry(propKey, propValue), AlterConfigOp.OpType.SET);
        HashMap<ConfigResource, List<AlterConfigOp>> configs = new HashMap<ConfigResource, List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.topicPartition().topic()), Collections.singletonList(alterConfigOp));
        try (ConfluentAdmin adminClient = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());){
            alterConfigsResult = adminClient.incrementalAlterConfigs(configs);
        }
        return alterConfigsResult;
    }

    private void assertInvalid(AlterConfigsResult result) {
        ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> result.all().get());
        Assertions.assertEquals(InvalidConfigurationException.class, exception.getCause().getClass());
    }

    public static final /* synthetic */ boolean $anonfun$testEnableCompactionAfterEnableTierAtBrokerLevelWithTierCleanerEnable$2(TierConfigurationTest $this, KafkaBroker broker$1) {
        LogManager qual$5 = broker$1.logManager();
        TopicPartition x$15 = $this.topicPartition();
        boolean x$16 = qual$5.getLog$default$2();
        return ((AbstractLog)qual$5.getLog(x$15, x$16).get()).config().compact();
    }

    public static final /* synthetic */ String $anonfun$testEnableCompactionAfterEnableTierAtBrokerLevelWithTierCleanerEnable$3() {
        return "Timed out turning on tier compact";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testEnableCompactionAfterEnableTierAtBrokerLevelWithTierCleanerEnable$1(TierConfigurationTest $this, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$7 = $this.topicPartition();
        boolean x$8 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$1.getLog(x$7, x$8).get()).tierPartitionState().isTieringEnabled());
        LogManager qual$2 = broker.logManager();
        TopicPartition x$9 = $this.topicPartition();
        boolean x$10 = qual$2.getLog$default$2();
        Assertions.assertFalse((boolean)((FileTierPartitionState)((AbstractLog)qual$2.getLog((TopicPartition)x$9, (boolean)x$10).get()).tierPartitionState()).cleanupConfig.isEnabled());
        LogManager qual$3 = broker.logManager();
        TopicPartition x$11 = $this.topicPartition();
        boolean x$12 = qual$3.getLog$default$2();
        Assertions.assertEquals((long)Defaults$.MODULE$.TierPartitionStateCleanupDelayMs(), (long)((FileTierPartitionState)((AbstractLog)qual$3.getLog((TopicPartition)x$11, (boolean)x$12).get()).tierPartitionState()).cleanupConfig.entryRemovalDelay());
        LogManager qual$4 = broker.logManager();
        TopicPartition x$13 = $this.topicPartition();
        boolean x$14 = qual$4.getLog$default$2();
        Assertions.assertEquals((long)Defaults$.MODULE$.TierPartitionStateCleanupIntervalMs(), (long)((FileTierPartitionState)((AbstractLog)qual$4.getLog((TopicPartition)x$13, (boolean)x$14).get()).tierPartitionState()).cleanupConfig.interval());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 5000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierConfigurationTest.$anonfun$testEnableCompactionAfterEnableTierAtBrokerLevelWithTierCleanerEnable$2($this, broker)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out turning on tier compact");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$testEnableCompactionAfterEnableTierAtBrokerLevelNoTierCleanerEnable$1(TierConfigurationTest $this, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$7 = $this.topicPartition();
        boolean x$8 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$1.getLog(x$7, x$8).get()).tierPartitionState().isTieringEnabled());
        LogManager qual$2 = broker.logManager();
        TopicPartition x$9 = $this.topicPartition();
        boolean x$10 = qual$2.getLog$default$2();
        Assertions.assertTrue((boolean)((FileTierPartitionState)((AbstractLog)qual$2.getLog((TopicPartition)x$9, (boolean)x$10).get()).tierPartitionState()).cleanupConfig.isEnabled());
        LogManager qual$3 = broker.logManager();
        TopicPartition x$11 = $this.topicPartition();
        boolean x$12 = qual$3.getLog$default$2();
        Assertions.assertEquals((long)1L, (long)((FileTierPartitionState)((AbstractLog)qual$3.getLog((TopicPartition)x$11, (boolean)x$12).get()).tierPartitionState()).cleanupConfig.entryRemovalDelay());
        LogManager qual$4 = broker.logManager();
        TopicPartition x$13 = $this.topicPartition();
        boolean x$14 = qual$4.getLog$default$2();
        Assertions.assertEquals((long)5L, (long)((FileTierPartitionState)((AbstractLog)qual$4.getLog((TopicPartition)x$13, (boolean)x$14).get()).tierPartitionState()).cleanupConfig.interval());
        LogManager qual$5 = broker.logManager();
        TopicPartition x$15 = $this.topicPartition();
        boolean x$16 = qual$5.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$5.getLog(x$15, x$16).get()).config().delete());
    }

    public static final /* synthetic */ void $anonfun$testDisallowedCompactDeleteChangesWithTierCleanerFeature$1(TierConfigurationTest $this, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$7 = $this.topicPartition();
        boolean x$8 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$1.getLog(x$7, x$8).get()).tierPartitionState().isTieringEnabled());
        LogManager qual$2 = broker.logManager();
        TopicPartition x$9 = $this.topicPartition();
        boolean x$10 = qual$2.getLog$default$2();
        Assertions.assertFalse((boolean)((FileTierPartitionState)((AbstractLog)qual$2.getLog((TopicPartition)x$9, (boolean)x$10).get()).tierPartitionState()).cleanupConfig.isEnabled());
        LogManager qual$3 = broker.logManager();
        TopicPartition x$11 = $this.topicPartition();
        boolean x$12 = qual$3.getLog$default$2();
        Assertions.assertEquals((long)Defaults$.MODULE$.TierPartitionStateCleanupDelayMs(), (long)((FileTierPartitionState)((AbstractLog)qual$3.getLog((TopicPartition)x$11, (boolean)x$12).get()).tierPartitionState()).cleanupConfig.entryRemovalDelay());
        LogManager qual$4 = broker.logManager();
        TopicPartition x$13 = $this.topicPartition();
        boolean x$14 = qual$4.getLog$default$2();
        Assertions.assertEquals((long)Defaults$.MODULE$.TierPartitionStateCleanupIntervalMs(), (long)((FileTierPartitionState)((AbstractLog)qual$4.getLog((TopicPartition)x$13, (boolean)x$14).get()).tierPartitionState()).cleanupConfig.interval());
        LogManager qual$5 = broker.logManager();
        TopicPartition x$15 = $this.topicPartition();
        boolean x$16 = qual$5.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$5.getLog(x$15, x$16).get()).config().compact());
    }

    public static final /* synthetic */ boolean $anonfun$testDisallowedCompactDeleteChangesWithTierCleanerFeature$3(TierConfigurationTest $this, KafkaBroker broker$2) {
        LogManager qual$6 = broker$2.logManager();
        TopicPartition x$17 = $this.topicPartition();
        boolean x$18 = qual$6.getLog$default$2();
        return ((AbstractLog)qual$6.getLog(x$17, x$18).get()).config().delete();
    }

    public static final /* synthetic */ String $anonfun$testDisallowedCompactDeleteChangesWithTierCleanerFeature$4() {
        return "Timed out trying to switch back to delete";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDisallowedCompactDeleteChangesWithTierCleanerFeature$2(TierConfigurationTest $this, KafkaBroker broker) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 5000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierConfigurationTest.$anonfun$testDisallowedCompactDeleteChangesWithTierCleanerFeature$3($this, broker)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out trying to switch back to delete");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$testDisallowedCompactDeleteChangesWithTierCleanerFeature$5(TierConfigurationTest $this, KafkaBroker broker) {
        LogManager qual$7 = broker.logManager();
        TopicPartition x$19 = $this.topicPartition();
        boolean x$20 = qual$7.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$7.getLog(x$19, x$20).get()).config().delete());
        LogManager qual$8 = broker.logManager();
        TopicPartition x$21 = $this.topicPartition();
        boolean x$22 = qual$8.getLog$default$2();
        Assertions.assertFalse((boolean)((AbstractLog)qual$8.getLog(x$21, x$22).get()).config().compact());
    }

    public static final /* synthetic */ void $anonfun$testDisableTieringWhenSetAtTopicLevel$1(TierConfigurationTest $this, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$7 = $this.topicPartition();
        boolean x$8 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$1.getLog(x$7, x$8).get()).tierPartitionState().isTieringEnabled());
    }

    public static final /* synthetic */ boolean $anonfun$testDisableTieringWhenSetAtTopicLevel$3(TierConfigurationTest $this, KafkaBroker broker$3) {
        boolean x$10;
        TopicPartition x$9;
        LogManager qual$2 = broker$3.logManager();
        return !((AbstractLog)qual$2.getLog(x$9 = $this.topicPartition(), x$10 = qual$2.getLog$default$2()).get()).tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDisableTieringWhenSetAtTopicLevel$4() {
        return "Timed out waiting for tiered storage to be disabled";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDisableTieringWhenSetAtTopicLevel$2(TierConfigurationTest $this, KafkaBroker broker) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 5000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtTopicLevel$3($this, broker)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for tiered storage to be disabled");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$testDisableTieringWhenSetAtBrokerLevel$1(TierConfigurationTest $this, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$7 = $this.topicPartition();
        boolean x$8 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$1.getLog(x$7, x$8).get()).tierPartitionState().isTieringEnabled());
    }

    public static final /* synthetic */ boolean $anonfun$testDisableTieringWhenSetAtBrokerLevel$3(TierConfigurationTest $this, KafkaBroker broker$4) {
        boolean x$10;
        TopicPartition x$9;
        LogManager qual$2 = broker$4.logManager();
        return !((AbstractLog)qual$2.getLog(x$9 = $this.topicPartition(), x$10 = qual$2.getLog$default$2()).get()).tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDisableTieringWhenSetAtBrokerLevel$4() {
        return "Timed out waiting for tiered storage to be disabled";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDisableTieringWhenSetAtBrokerLevel$2(TierConfigurationTest $this, KafkaBroker broker) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 5000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtBrokerLevel$3($this, broker)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for tiered storage to be disabled");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$testDisableTieredStorageAtBrokerLevel$1(TierConfigurationTest $this, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$7 = $this.topicPartition();
        boolean x$8 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$1.getLog(x$7, x$8).get()).tierPartitionState().isTieringEnabled());
    }

    public static final /* synthetic */ boolean $anonfun$testDisableTieredStorageAtBrokerLevel$3(TierConfigurationTest $this, KafkaBroker broker$5) {
        boolean x$10;
        TopicPartition x$9;
        LogManager qual$2 = broker$5.logManager();
        return !((AbstractLog)qual$2.getLog(x$9 = $this.topicPartition(), x$10 = qual$2.getLog$default$2()).get()).tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDisableTieredStorageAtBrokerLevel$4() {
        return "TierPartitionState#tieringEnabled flag set to true";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDisableTieredStorageAtBrokerLevel$2(TierConfigurationTest $this, int brokerToUpdate$1, boolean isDynamicallyEnabled$1, KafkaBroker broker) {
        if (broker.config().brokerId() == brokerToUpdate$1) {
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 5000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$3($this, broker)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"TierPartitionState#tieringEnabled flag set to true");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            ConfigEntry tierEnableConfig = $this.getTierEnableBrokerConfig(Integer.toString(broker.config().brokerId()));
            Assertions.assertFalse((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(tierEnableConfig.value())));
            Assertions.assertEquals((Object)ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG, (Object)tierEnableConfig.source());
            return;
        }
        LogManager qual$3 = broker.logManager();
        TopicPartition x$11 = $this.topicPartition();
        boolean x$12 = qual$3.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$3.getLog(x$11, x$12).get()).tierPartitionState().isTieringEnabled());
        ConfigEntry tierEnableConfig = $this.getTierEnableBrokerConfig(Integer.toString(broker.config().brokerId()));
        Assertions.assertTrue((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(tierEnableConfig.value())));
        if (isDynamicallyEnabled$1) {
            Assertions.assertEquals((Object)ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, (Object)tierEnableConfig.source());
            return;
        }
        Assertions.assertEquals((Object)ConfigEntry.ConfigSource.STATIC_BROKER_CONFIG, (Object)tierEnableConfig.source());
    }

    public static final /* synthetic */ boolean $anonfun$testDisableTieredStorageAtBrokerLevel$6(TierConfigurationTest $this, KafkaBroker broker$6) {
        boolean x$14;
        TopicPartition x$13;
        LogManager qual$4 = broker$6.logManager();
        return !((AbstractLog)qual$4.getLog(x$13 = $this.topicPartition(), x$14 = qual$4.getLog$default$2()).get()).tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDisableTieredStorageAtBrokerLevel$7() {
        return "TierPartitionState#tieringEnabled flag set to true";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDisableTieredStorageAtBrokerLevel$5(TierConfigurationTest $this, KafkaBroker broker) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 5000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$6($this, broker)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"TierPartitionState#tieringEnabled flag set to true");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public TierConfigurationTest() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierCleanerFeatureEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.controllerConfig().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.controllerConfig().setProperty(KafkaConfig$.MODULE$.TierCleanerFeatureEnableProp(), "true");
        this.controllerConfig().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.topicPartition = new TopicPartition("foo", 0);
        this.brokerCount = 2;
    }
}

