/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.MergedLog;
import kafka.log.TierLogSegment;
import kafka.restore.ResetTierPartitionState;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.MemoryTracker;
import kafka.tier.fetcher.TierFetcher;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.tools.RecoveryTestUtils$;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierMetadataComparator;
import kafka.tier.tools.TierPartitionStateFencingTrigger;
import kafka.tier.tools.TierPartitionStateRestoreTrigger;
import kafka.tier.tools.TierPartitionUnfreezeLogStartOffsetTrigger;
import kafka.tier.tools.common.FenceEventInfo;
import kafka.tier.tools.common.RestoreInfo;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tEg\u0001\u0002\u0012$\u0001!BQa\f\u0001\u0005\u0002ABQa\r\u0001\u0005RQBQa\u000f\u0001\u0005\nqBq\u0001\u0011\u0001C\u0002\u0013%\u0011\t\u0003\u0004K\u0001\u0001\u0006IA\u0011\u0005\b\u0017\u0002\u0011\r\u0011\"\u00035\u0011\u0019a\u0005\u0001)A\u0005k!)Q\n\u0001C\u0005\u001d\"9a\r\u0001b\u0001\n\u00039\u0007B\u0002:\u0001A\u0003%\u0001\u000eC\u0003t\u0001\u0011\u0005C\u000f\u0003\u0004\u0002\n\u0001!\t\u0005\u0010\u0005\b\u0003'\u0001A\u0011AA\u000b\u0011\u001d\t9\u0006\u0001C\u0001\u00033Bq!a\u0019\u0001\t\u0013\t)\u0007C\u0004\u00026\u0002!I!a.\t\u000f\u0005\u0015\u0007\u0001\"\u0003\u0002H\"9\u0011Q\u0019\u0001\u0005\u0002\u0005E\u0007bBAn\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0003O\u0004A\u0011AAu\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003kDq!a?\u0001\t\u0003\ti\u0010C\u0004\u0003\b\u0001!\tA!\u0003\t\u000f\tM\u0001\u0001\"\u0003\u0003\u0016!9!q\u0004\u0001\u0005\n\t\u0005\u0002b\u0002B\u0017\u0001\u0011%!q\u0006\u0005\b\u0005o\u0001A\u0011\u0002B\u001d\u0011\u001d\u0011i\u0004\u0001C\u0005\u0005\u007fAqA!\u0010\u0001\t\u0013\u00119\u0005C\u0004\u0003R\u0001!IAa\u0015\t\u000f\t]\u0004\u0001\"\u0003\u0003z!9!Q\u0014\u0001\u0005\n\t}\u0005b\u0002BT\u0001\u0011%!\u0011\u0016\u0002\u001c)&,'/\u00138uK\u001e\u0014\u0018\r^5p]\u0016sG\rV8F]\u0012$Vm\u001d;\u000b\u0005\u0011*\u0013\u0001\u0002;jKJT\u0011AJ\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0006\u0005\u0002+[5\t1F\u0003\u0002-K\u0005\u0019\u0011\r]5\n\u00059Z#AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005\t\u0004C\u0001\u001a\u0001\u001b\u0005\u0019\u0013a\u00032s_.,'oQ8v]R,\u0012!\u000e\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0004\u0013:$\u0018!D2p]\u001aLw-\u001e:f\u001b>\u001c7\u000eF\u0001>!\t1d(\u0003\u0002@o\t!QK\\5u\u0003\u0015!x\u000e]5d+\u0005\u0011\u0005CA\"I\u001b\u0005!%BA#G\u0003\u0011a\u0017M\\4\u000b\u0003\u001d\u000bAA[1wC&\u0011\u0011\n\u0012\u0002\u0007'R\u0014\u0018N\\4\u0002\rQ|\u0007/[2!\u0003)\u0001\u0018M\u001d;ji&|gn]\u0001\fa\u0006\u0014H/\u001b;j_:\u001c\b%A\bu_BL7\rU1si&$\u0018n\u001c8t+\u0005y\u0005c\u0001)Y7:\u0011\u0011K\u0016\b\u0003%Vk\u0011a\u0015\u0006\u0003)\u001e\na\u0001\u0010:p_Rt\u0014\"\u0001\u001d\n\u0005];\u0014a\u00029bG.\fw-Z\u0005\u00033j\u00131aU3r\u0015\t9v\u0007\u0005\u0002]I6\tQL\u0003\u0002_?\u000611m\\7n_:T!A\n1\u000b\u0005\u0005\u0014\u0017AB1qC\u000eDWMC\u0001d\u0003\ry'oZ\u0005\u0003Kv\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0004fq&$X\rZ\u000b\u0002QB\u0011\u0011\u000e]\u0007\u0002U*\u00111\u000e\\\u0001\u0007CR|W.[2\u000b\u00055t\u0017AC2p]\u000e,(O]3oi*\u0011qNR\u0001\u0005kRLG.\u0003\u0002rU\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\fq!\u001a=ji\u0016$\u0007%A\u0003tKR,\u0006\u000f\u0006\u0002>k\")ao\u0003a\u0001o\u0006AA/Z:u\u0013:4w\u000e\u0005\u0002y}6\t\u0011P\u0003\u0002-u*\u00111\u0010`\u0001\bUV\u0004\u0018\u000e^3s\u0015\ti(-A\u0003kk:LG/\u0003\u0002\u0000s\nAA+Z:u\u0013:4w\u000eK\u0002\f\u0003\u0007\u00012\u0001_A\u0003\u0013\r\t9!\u001f\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u00071\ti\u0001E\u0002y\u0003\u001fI1!!\u0005z\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\fuKN$\u0018I]2iSZ,\u0017I\u001c3US\u0016\u0014h)\u001a;dQR\u0019Q(a\u0006\t\u000f\u0005eQ\u00021\u0001\u0002\u001c\u00051\u0011/^8sk6\u0004B!!\b\u0002&9!\u0011qDA\u0011!\t\u0011v'C\u0002\u0002$]\na\u0001\u0015:fI\u00164\u0017bA%\u0002()\u0019\u00111E\u001c)\u000f5\tY#a\u000f\u0002>A!\u0011QFA\u001c\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012\u0001\u00039s_ZLG-\u001a:\u000b\u0007\u0005U\"0\u0001\u0004qCJ\fWn]\u0005\u0005\u0003s\tyCA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u0003\u007f\t\u0019%\t\u0002\u0002B\u0005\u0011!p[\u0011\u0003\u0003\u000b\nQa\u001b:bMRDs!DA%\u0003#\n\u0019\u0006\u0005\u0003\u0002L\u00055SBAA\u001a\u0013\u0011\ty%a\r\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017EAA+\u0003aYH-[:qY\u0006Lh*Y7f{:\nXo\u001c:v[vZ\b'`\u0001!i\u0016\u001cH/\u0011:dQ&4X-\u00118e!J,g-\u001a:sK\u0012$\u0016.\u001a:GKR\u001c\u0007\u000eF\u0002>\u00037Bq!!\u0007\u000f\u0001\u0004\tY\u0002K\u0004\u000f\u0003W\tY$a\u0018-\t\u0005}\u00121\t\u0015\b\u001d\u0005%\u0013\u0011KA*\u0003a1\u0018\r\\5eCR,g)\u001a8dKR{w\u000e\u001c*fgVdGo\u001d\u000b\n{\u0005\u001d\u0014\u0011QAL\u0003KCq!!\u001b\u0010\u0001\u0004\tY'A\u0006gK:\u001cW-\u0012<f]R\u001c\bCBA7\u0003_\n\u0019(D\u0001o\u0013\r\t\tH\u001c\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002v\u0005uTBAA<\u0015\rq\u0016\u0011\u0010\u0006\u0004\u0003w\u001a\u0013!\u0002;p_2\u001c\u0018\u0002BA@\u0003o\u0012aBR3oG\u0016,e/\u001a8u\u0013:4w\u000eC\u0004\u0002\u0004>\u0001\r!!\"\u0002\u001fQ\u0004\u0018\nZ:U_\n+g)\u001a8dK\u0012\u0004\u0002\"!\b\u0002\b\u0006-\u0015\u0011S\u0005\u0005\u0003\u0013\u000b9CA\u0002NCB\u00042AMAG\u0013\r\tyi\t\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u00042ANAJ\u0013\r\t)j\u000e\u0002\b\u0005>|G.Z1o\u0011\u001d\tIj\u0004a\u0001\u00037\u000b1\u0001\\8h!\u0011\ti*!)\u000e\u0005\u0005}%bAAMK%!\u00111UAP\u0005%iUM]4fI2{w\rC\u0004\u0002(>\u0001\r!!+\u0002%QLWM\u001d)beRLG/[8o'R\fG/\u001a\t\u0005\u0003W\u000b\t,\u0004\u0002\u0002.*\u0019\u0011qV\u0012\u0002\u000bM$\u0018\r^3\n\t\u0005M\u0016Q\u0016\u0002\u0013)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X-A\u000ewC2LG-\u0019;f%\u0016\u001cHo\u001c:f)>|Gn\u001d*fgVdGo\u001d\u000b\f{\u0005e\u00161XA`\u0003\u0003\f\u0019\rC\u0004\u0002jA\u0001\r!a\u001b\t\u000f\u0005u\u0006\u00031\u0001\u0002\u001c\u0005\t\"/Z:u_J,w*\u001e;qkRT5o\u001c8\t\u000f\u0005\r\u0005\u00031\u0001\u0002\u0006\"9\u0011\u0011\u0014\tA\u0002\u0005m\u0005bBAT!\u0001\u0007\u0011\u0011V\u0001(i\u0016\u001cH/\u0011:dQ&4X-\u00118e)&,'OR3uG\"4UM\\2f\u0003:$'+Z2pm\u0016\u0014\u0018\u0010F\u0003>\u0003\u0013\fi\rC\u0004\u0002LF\u0001\r!!%\u0002%U\u001cXMU3ti>\u0014XMU1x\u0013:\u0004X\u000f\u001e\u0005\b\u0003\u001f\f\u0002\u0019AAI\u0003i1'/Z3{K6+'oZ3e\u0019><7\u000b^1si>3gm]3u)\ri\u00141\u001b\u0005\b\u00033\u0011\u0002\u0019AA\u000eQ\u001d\u0011\u00121FA\u001e\u0003/dC!a\u0010\u0002D!:!#!\u0013\u0002R\u0005M\u0013A\u000f;fgR\f%o\u00195jm\u0016\fe\u000e\u001a+jKJ4U\r^2i\r\u0016t7-Z!oIJ+7m\u001c<fef<\u0016\u000e\u001e5SKN$xN]3SC^Le\u000e];u)\ri\u0014q\u001c\u0005\b\u00033\u0019\u0002\u0019AA\u000eQ\u001d\u0019\u00121FA\u001e\u0003GdC!a\u0010\u0002D!:1#!\u0013\u0002R\u0005M\u0013!\u0012;fgR\f%o\u00195jm\u0016\fe\u000e\u001a+jKJ4U\r^2i\r\u0016t7-Z!oIJ+7m\u001c<fef<\u0016\u000e\u001e5NKJ<W\r\u001a'pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e$s_j,g\u000eF\u0002>\u0003WDq!!\u0007\u0015\u0001\u0004\tY\u0002K\u0004\u0015\u0003W\tY$a<-\t\u0005}\u00121\t\u0015\b)\u0005%\u0013\u0011KA*\u0003Q!Xm\u001d;DY\u0016\f'/\u00117m)&,'\u000fR1uCR\u0019Q(a>\t\u000f\u0005eX\u00031\u0001\u0002\u0012\u0006I\u0011n]\"p[B\f7\r^\u0001)i\u0016\u001cHo\u00117fCJ\fE\u000e\u001c+jKJ$\u0015\r^1G_JtuN\\\"p[B\f7\r^3e)>\u0004\u0018n\u0019\u000b\u0004{\u0005}\bbBA\r-\u0001\u0007\u00111\u0004\u0015\b-\u0005-\u00121\bB\u0002Y\u0011\ty$a\u0011)\u000fY\tI%!\u0015\u0002T\u0005)C/Z:u\u00072,\u0017M]!mYRKWM\u001d#bi\u00064uN]\"p[B\f7\r^3e)>\u0004\u0018n\u0019\u000b\u0004{\t-\u0001bBA\r/\u0001\u0007\u00111\u0004\u0015\b/\u0005-\u00121\bB\bY\u0011\ty$a\u0011)\u000f]\tI%!\u0015\u0002T\u0005q\u0001O]8ek\u000e,'+Z2pe\u0012\u001cH#B\u001f\u0003\u0018\tm\u0001B\u0002B\r1\u0001\u0007Q'\u0001\u0005o\u0005\u0006$8\r[3t\u0011\u0019\u0011i\u0002\u0007a\u0001k\u0005y!/Z2pe\u0012\u001c\b+\u001a:CCR\u001c\u0007.\u0001\u000ehKRdU-\u00193fe\u001a{'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eF\u00036\u0005G\u00119\u0003\u0003\u0004\u0003&e\u0001\raW\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\u0011I#\u0007a\u0001\u0005W\tA\u0003]1si&$\u0018n\u001c8U_2+\u0017\rZ3s\u001b\u0006\u0004\bCBA\u000f\u0003\u000f+T'A\fxC&$XK\u001c;jYN+w-\\3oiN$\u0016.\u001a:fIR)QH!\r\u00036!1!1\u0007\u000eA\u0002U\na\"\\5o\u001dVl7+Z4nK:$8\u000fC\u0004\u0003*i\u0001\rAa\u000b\u0002#MLW.\u001e7bi\u0016\u0014V\r^3oi&|g\u000eF\u0002>\u0005wAqA!\u000b\u001c\u0001\u0004\u0011Y#A\u000ed_:\u001cX/\\3B]\u00124\u0016\r\\5eCR,G+[3s\r\u0016$8\r\u001b\u000b\b{\t\u0005#1\tB#\u0011\u001d\u0011I\u0003\ba\u0001\u0005WAaA!\u0007\u001d\u0001\u0004)\u0004B\u0002B\u000f9\u0001\u0007Q\u0007F\u0005>\u0005\u0013\u0012YE!\u0014\u0003P!9!\u0011F\u000fA\u0002\t-\u0002B\u0002B\r;\u0001\u0007Q\u0007\u0003\u0004\u0003\u001eu\u0001\r!\u000e\u0005\b\u0003sl\u0002\u0019AAI\u0003I9(/\u001b;f%\u0016\u001cwN^3s\u0007>tg-[4\u0015\u0011\tU#\u0011\rB8\u0005g\u0002BAa\u0016\u0003^5\u0011!\u0011\f\u0006\u0004\u000572\u0015AA5p\u0013\u0011\u0011yF!\u0017\u0003\t\u0019KG.\u001a\u0005\b\u0005Gr\u0002\u0019\u0001B3\u0003A!\u0018.\u001a:DY&,g\u000e^\"p]\u001aLw\r\u0005\u0005\u0002n\t\u001d\u00141\u0004B5\u0013\r\tII\u001c\t\u0004\u0007\n-\u0014b\u0001B7\t\n1qJ\u00196fGRDqA!\u001d\u001f\u0001\u0004\u0011)&\u0001\u0006x_J\\\u0017N\\4ESJDqA!\u001e\u001f\u0001\u0004\u0011)&A\tce>\\WM],pe.$\u0017N\u001d'jgR\fQ%Y:tKJ$H+[7fgR\fW\u000e\u001d$pe>3gm]3u\u0019>|7.\u001e9D_J\u0014Xm\u0019;\u0015\u0013u\u0012YH! \u0003\u0010\ne\u0005B\u0002B\u0013?\u0001\u00071\fC\u0004\u0003\u0000}\u0001\rA!!\u0002\u0011\r|gn];nKJ\u0004\u0002Ba!\u0003\f\u0006m\u00111D\u0007\u0003\u0005\u000bSAAa \u0003\b*\u0019!\u0011R0\u0002\u000f\rd\u0017.\u001a8ug&!!Q\u0012BC\u00055Y\u0015MZ6b\u0007>t7/^7fe\"9!\u0011S\u0010A\u0002\tM\u0015!\u0003;j[\u0016\u001cH/Y7q!\r1$QS\u0005\u0004\u0005/;$\u0001\u0002'p]\u001eDqAa' \u0001\u0004\u0011\u0019*\u0001\bfqB,7\r^3e\u001f\u001a47/\u001a;\u0002K\u0005\u001c8/\u001a:u)&lWm\u001d;b[B4uN](gMN,G\u000fT8pWV\u0004X*[:tS:<GcB\u001f\u0003\"\n\r&Q\u0015\u0005\u0007\u0005K\u0001\u0003\u0019A.\t\u000f\t}\u0004\u00051\u0001\u0003\u0002\"9!\u0011\u0013\u0011A\u0002\tM\u0015aC2sK\u0006$X\rV8qS\u000e$BBa+\u0003:\nm&q\u0018Bb\u0005\u001b\u0004bA!,\u00038V*TB\u0001BX\u0015\u0011\u0011\tLa-\u0002\u0013%lW.\u001e;bE2,'b\u0001B[o\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%%q\u0016\u0005\u0007\u0001\u0006\u0002\r!a\u0007\t\r\tu\u0016\u00051\u00016\u00035qW/\u001c)beRLG/[8og\"1!\u0011Y\u0011A\u0002U\n\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0011\u001d\u0011)-\ta\u0001\u0005\u000f\f1\u0002^8qS\u000e\u001cuN\u001c4jOB!\u0011Q\u000eBe\u0013\r\u0011YM\u001c\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bb\u0002BhC\u0001\u0007!qY\u0001\u0012C\u0012l\u0017N\\\"mS\u0016tGoQ8oM&<\u0007")
public class TierIntegrationEndToEndTest
extends IntegrationTestHarness {
    private final String topic;
    private final int partitions;
    private final AtomicBoolean exited;

    @Override
    public int brokerCount() {
        return 1;
    }

    private void configureMock() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
    }

    private String topic() {
        return this.topic;
    }

    private int partitions() {
        return this.partitions;
    }

    private scala.collection.immutable.Seq<TopicPartition> topicPartitions() {
        return package$.MODULE$.Range().apply(0, this.partitions()).map((Function1 & Serializable)p -> TierIntegrationEndToEndTest.$anonfun$topicPartitions$1(this, BoxesRunTime.unboxToInt((Object)p)));
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveAndTierFetch(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("confluent.tier.local.hotset.bytes", "5000");
        props.put("retention.bytes", "-1");
        scala.collection.immutable.Map<Object, Object> partitionToLeaderMap = this.createTopic(this.topic(), this.partitions(), 1, props, this.adminClientConfig());
        int nBatches = 100;
        int recordsPerBatch = 100;
        this.produceRecords(nBatches, recordsPerBatch);
        this.waitUntilSegmentsTiered(5, partitionToLeaderMap);
        this.simulateRetention(partitionToLeaderMap);
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch);
        Predef$.MODULE$.assert(((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().logAppendLatencyMs().count() > 0L);
        Predef$.MODULE$.assert(((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().logAppendDataSizeInBytes().count() > 0L);
        Predef$.MODULE$.assert(((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().logAppendRate().count() > 0L);
        Predef$.MODULE$.assert(((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().tierLogFetchLatencyMs().count() > 0L);
        Predef$.MODULE$.assert(((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().localLogFetchLatencyMs().count() > 0L);
        Predef$.MODULE$.assert(((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().logFetchDataSizeInBytes().count() > 0L);
        Predef$.MODULE$.assert(((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().logFetchRate().count() > 0L);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveAndPreferredTierFetch(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("confluent.tier.local.hotset.ms", "-1");
        props.put("confluent.tier.local.hotset.bytes", "-1");
        props.put("confluent.prefer.tier.fetch.ms", "0");
        scala.collection.immutable.Map<Object, Object> partitionToLeaderMap = this.createTopic(this.topic(), this.partitions(), 1, props, this.adminClientConfig());
        int nBatches = 100;
        int recordsPerBatch = 100;
        this.produceRecords(nBatches, recordsPerBatch);
        this.waitUntilSegmentsTiered(5, partitionToLeaderMap);
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch);
    }

    /*
     * WARNING - void declaration
     */
    private void validateFenceToolResults(java.util.List<FenceEventInfo> fenceEvents, scala.collection.immutable.Map<TopicIdPartition, Object> tpIdsToBeFenced, MergedLog log, TierPartitionState tierPartitionState) {
        TopicIdPartition topicIdToBeFenced = (TopicIdPartition)((Tuple2)tpIdsToBeFenced.head())._1();
        boolean freezeMergedLogStartOffset = ((Tuple2)tpIdsToBeFenced.head())._2$mcZ$sp();
        Assertions.assertTrue((fenceEvents.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((new TopicIdPartition(fenceEvents.get(0).topic(), CoreUtils$.MODULE$.uuidFromBase64(fenceEvents.get((int)0).topicIdBase64), fenceEvents.get((int)0).partition).equals(topicIdToBeFenced) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals((Object)fenceEvents.get((int)0).freezeMergedLogStartOffset, (Object)BoxesRunTime.boxToBoolean((boolean)freezeMergedLogStartOffset)) ? 1 : 0) != 0);
        if (freezeMergedLogStartOffset) {
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierIntegrationEndToEndTest.$anonfun$validateFenceToolResults$1(tierPartitionState, log)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"timeout waiting for partition to be transitioned to the required status");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            return;
        }
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$validateFenceToolResults$3(tierPartitionState, log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"timeout waiting for partition to be transitioned to the required status");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void validateRestoreToolsResults(java.util.List<FenceEventInfo> fenceEvents, String restoreOutputJson, scala.collection.immutable.Map<TopicIdPartition, Object> tpIdsToBeFenced, MergedLog log, TierPartitionState tierPartitionState) {
        freezeMergedLogStartOffset = ((Tuple2)tpIdsToBeFenced.head())._2$mcZ$sp();
        restoreRawOutputList = RestoreInfo.RestoreRawOutput.readJsonFromFile((Path)Paths.get(restoreOutputJson, new String[0]));
        if (restoreRawOutputList.size() != 1) ** GOTO lbl-1000
        v0 = ((RestoreInfo.RestoreRawOutput)restoreRawOutputList.get((int)0)).input().fenceEventInfo().freezeMergedLogStartOffset;
        var8_8 = fenceEvents.get((int)0).freezeMergedLogStartOffset;
        if (!(v0 != null ? v0.equals(var8_8) == false : var8_8 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        Assertions.assertTrue((boolean)v1);
        if (freezeMergedLogStartOffset) {
            var11_9 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierIntegrationEndToEndTest.$anonfun$validateRestoreToolsResults$1(tierPartitionState, log)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"log and/or tier partition state is in unexpected status");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            return;
        }
        var17_12 = 100L;
        waitUntilTrue_waitTimeMs = 15000L;
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$validateRestoreToolsResults$3(tierPartitionState, log)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"log and/or tier partition state is in unexpected status");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void testArchiveAndTierFetchFenceAndRecovery(boolean useRestoreRawInput, boolean freezeMergedLogStartOffset) {
        props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("confluent.tier.local.hotset.bytes", "5000");
        props.put("retention.bytes", "-1");
        partitionToLeaderMap = this.createTopic(this.topic(), this.partitions(), 1, props, this.adminClientConfig());
        nBatches = 100;
        recordsPerBatch = 100;
        this.produceRecords(nBatches, recordsPerBatch);
        this.waitUntilSegmentsTiered(5, partitionToLeaderMap);
        this.simulateRetention(partitionToLeaderMap);
        fenceTopicPartition = (TopicPartition)this.topicPartitions().head();
        leaderId = this.getLeaderForTopicPartition(fenceTopicPartition, partitionToLeaderMap);
        qual$1 = ((KafkaBroker)this.brokerForId(leaderId).get()).logManager();
        x$2 = qual$1.getLog$default$2();
        log = (AbstractLog)qual$1.getLog(fenceTopicPartition, x$2).get();
        tierPartitionState = (FileTierPartitionState)log.tierPartitionState();
        tpIdsToBeFenced = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierPartitionState.topicIdPartition().get()), (Object)BoxesRunTime.boxToBoolean((boolean)freezeMergedLogStartOffset))}));
        topicIdPartitionsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        RecoveryTestUtils$.MODULE$.writeFencingFile(topicIdPartitionsFile, (scala.collection.immutable.Map<TopicIdPartition, Object>)tpIdsToBeFenced);
        workingDir = TestUtils.tempDirectory(null);
        brokerWorkdirList = TestUtils.tempDirectory((Path)workingDir.toPath(), null);
        recoveryConfFile = this.writeRecoverConfig((java.util.Map)((KafkaBroker)this.brokers().head()).tieredStorageInterBrokerClientConfigsSupplier().get(), workingDir, brokerWorkdirList);
        outputDir = TestUtils$.MODULE$.tempDir();
        fenceOutFile = new StringBuilder(18).append(outputDir.getAbsolutePath()).append("/fence-output.json").toString();
        TierPartitionStateFencingTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"file-fence-target-partitions"), topicIdPartitionsFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"output.json"), fenceOutFile});
        fenceEvents = FenceEventInfo.jsonToList((Path)Paths.get(fenceOutFile, new String[0]));
        this.validateFenceToolResults(fenceEvents, (scala.collection.immutable.Map<TopicIdPartition, Object>)tpIdsToBeFenced, (MergedLog)log, (TierPartitionState)tierPartitionState);
        tierPartitionState.flush();
        Assertions.assertTrue((boolean)brokerWorkdirList.mkdir());
        tpDir = Paths.get(brokerWorkdirList.getAbsolutePath(), new String[]{tierPartitionState.topicPartition().toString()}).toFile();
        tpDir.mkdir();
        flushedPath = Paths.get(tierPartitionState.flushedPath(), new String[0]);
        Files.copy(flushedPath, Paths.get(tpDir.getAbsolutePath(), new String[]{flushedPath.getFileName().toString()}), new CopyOption[0]);
        comparatorOutputJson = new StringBuilder(23).append(outputDir.getAbsolutePath()).append("/comparator-output.json").toString();
        TierMetadataComparator.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"input.json"), fenceOutFile, RecoveryUtils.makeArgument((String)"output.json"), comparatorOutputJson});
        comparatorOutput = RestoreInfo.RestoreComparatorInput.readJsonFromFile((Path)Paths.get(comparatorOutputJson, new String[0]));
        if (comparatorOutput.size() != 1) ** GOTO lbl-1000
        v0 = ((RestoreInfo.RestoreComparatorInput)comparatorOutput.get((int)0)).input().freezeMergedLogStartOffset;
        var25_25 = ((FenceEventInfo)fenceEvents.get((int)0)).freezeMergedLogStartOffset;
        if (!(v0 != null ? v0.equals(var25_25) == false : var25_25 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        Predef$.MODULE$.assert(v1);
        restoreOutputJson = new StringBuilder(20).append(outputDir.getAbsolutePath()).append("/restore-output.json").toString();
        if (useRestoreRawInput) {
            TierPartitionStateRestoreTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"fence.json"), fenceOutFile, RecoveryUtils.makeArgument((String)"restore.tier.state.root.dir"), brokerWorkdirList.getAbsolutePath(), RecoveryUtils.makeArgument((String)"output.json"), restoreOutputJson});
            this.validateRestoreToolsResults(fenceEvents, restoreOutputJson, (scala.collection.immutable.Map<TopicIdPartition, Object>)tpIdsToBeFenced, (MergedLog)log, (TierPartitionState)tierPartitionState);
        } else {
            TierPartitionStateRestoreTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"comparator.json"), comparatorOutputJson, RecoveryUtils.makeArgument((String)"output.json"), restoreOutputJson});
            if (freezeMergedLogStartOffset) {
                var32_27 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                waitUntilTrue_waitTimeMs = 15000L;
                waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$1(tierPartitionState, log)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"log and/or tier partition state is in unexpected status");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            } else {
                var38_30 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
                waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$3(tierPartitionState, log)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"log and/or tier partition state is in unexpected status");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            }
        }
        if (freezeMergedLogStartOffset && !useRestoreRawInput) {
            return;
        }
        if (freezeMergedLogStartOffset) {
            unfreezeOutputJson = new StringBuilder(29).append(outputDir.getAbsolutePath()).append("/unfreeze-trigger-output.json").toString();
            TierPartitionUnfreezeLogStartOffsetTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"restore.json"), restoreOutputJson, RecoveryUtils.makeArgument((String)"output.json"), unfreezeOutputJson});
            var44_34 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$5(tierPartitionState, log)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"timed out waiting for partition to be restored to ONLINE status");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch);
        endOffset = tierPartitionState.endOffset();
        this.produceRecords(nBatches, recordsPerBatch);
        var50_38 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$7(endOffset, tierPartitionState)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"timeout waiting for endOffset to advance after tiered partition has recovered and more records produced");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveAndTierFetchFenceAndRecovery(String quorum) {
        this.testArchiveAndTierFetchFenceAndRecovery(false, false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveAndTierFetchFenceAndRecoveryWithRestoreRawInput(String quorum) {
        this.testArchiveAndTierFetchFenceAndRecovery(true, false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveAndTierFetchFenceAndRecoveryWithMergedLogStartOffsetFrozen(String quorum) {
        this.testArchiveAndTierFetchFenceAndRecovery(true, true);
    }

    /*
     * WARNING - void declaration
     */
    public void testClearAllTierData(boolean isCompact) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("confluent.tier.local.hotset.ms", "-1");
        props.put("confluent.tier.local.hotset.bytes", "-1");
        props.put("confluent.prefer.tier.fetch.ms", "0");
        if (isCompact) {
            props.put("cleanup.policy", "compact");
            props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
            props.put("confluent.compacted.topic.prefer.tier.fetch.ms", "0");
        }
        scala.collection.immutable.Map<Object, Object> partitionToLeaderMap = this.createTopic(this.topic(), this.partitions(), 1, props, this.adminClientConfig());
        int nBatches = 100;
        int recordsPerBatch = 100;
        this.produceRecords(nBatches, recordsPerBatch);
        this.waitUntilSegmentsTiered(5, partitionToLeaderMap);
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch, isCompact);
        TopicPartition fenceTopicPartition = (TopicPartition)this.topicPartitions().head();
        int leaderId = this.getLeaderForTopicPartition(fenceTopicPartition, partitionToLeaderMap);
        LogManager qual$1 = ((KafkaBroker)this.brokerForId(leaderId).get()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(fenceTopicPartition, x$2).get();
        FileTierPartitionState tierPartitionState = (FileTierPartitionState)log.tierPartitionState();
        List segmentsBeforeClearing = CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState.segments()).asScala().toList();
        scala.collection.immutable.Map tpIdsToBeFenced = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierPartitionState.topicIdPartition().get()), (Object)BoxesRunTime.boxToBoolean((boolean)false))}));
        File topicIdPartitionsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        RecoveryTestUtils$.MODULE$.writeFencingFile(topicIdPartitionsFile, (scala.collection.immutable.Map<TopicIdPartition, Object>)tpIdsToBeFenced);
        File workingDir = TestUtils.tempDirectory(null, null);
        File brokerWorkdirList = TestUtils.tempDirectory((Path)workingDir.toPath(), null);
        File recoveryConfFile = this.writeRecoverConfig((java.util.Map)((KafkaBroker)this.brokers().head()).tieredStorageInterBrokerClientConfigsSupplier().get(), workingDir, brokerWorkdirList);
        File outputDir = TestUtils.tempDirectory(null, null);
        String fenceOutFile = new StringBuilder(18).append(outputDir.getAbsolutePath()).append("/fence-output.json").toString();
        TierPartitionStateFencingTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"file-fence-target-partitions"), topicIdPartitionsFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"output.json"), fenceOutFile});
        java.util.List fenceEvents = FenceEventInfo.jsonToList((Path)Paths.get(fenceOutFile, new String[0]));
        this.validateFenceToolResults(fenceEvents, (scala.collection.immutable.Map<TopicIdPartition, Object>)tpIdsToBeFenced, (MergedLog)log, (TierPartitionState)tierPartitionState);
        tierPartitionState.flush();
        Assertions.assertTrue((boolean)brokerWorkdirList.mkdir());
        File tpDir = Paths.get(brokerWorkdirList.getAbsolutePath(), tierPartitionState.topicPartition().toString()).toFile();
        tpDir.mkdir();
        Path flushedPath = Paths.get(tierPartitionState.flushedPath(), new String[0]);
        Path copiedTierStateFilePath = Paths.get(tpDir.getAbsolutePath(), ((Object)flushedPath.getFileName()).toString());
        Files.copy(flushedPath, copiedTierStateFilePath, new CopyOption[0]);
        ResetTierPartitionState.main((String[])new String[]{RecoveryUtils.makeArgument((String)"topic"), fenceTopicPartition.topic(), RecoveryUtils.makeArgument((String)"partition"), Integer.toString(fenceTopicPartition.partition()), RecoveryUtils.makeArgument((String)"ftps"), ((Object)copiedTierStateFilePath).toString()});
        Assertions.assertTrue((boolean)Paths.get(ResetTierPartitionState.outputFilePath((String)((Object)copiedTierStateFilePath).toString()), new String[0]).toFile().exists());
        Assertions.assertTrue((boolean)copiedTierStateFilePath.toFile().delete());
        String restoreOutputJson = new StringBuilder(20).append(outputDir.getAbsolutePath()).append("/restore-output.json").toString();
        TierPartitionStateRestoreTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"fence.json"), fenceOutFile, RecoveryUtils.makeArgument((String)"restore.tier.state.root.dir"), tpDir.getParent(), RecoveryUtils.makeArgument((String)"output.json"), restoreOutputJson});
        this.validateRestoreToolsResults(fenceEvents, restoreOutputJson, (scala.collection.immutable.Map<TopicIdPartition, Object>)tpIdsToBeFenced, (MergedLog)log, (TierPartitionState)tierPartitionState);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$testClearAllTierData$1(tierPartitionState, log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"timed out waiting for partition to be restored to ONLINE status");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilSegmentsTiered(5, partitionToLeaderMap);
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch, isCompact);
        List segmentsAfterClearing = CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState.segments()).asScala().toList();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            TierLogSegment seg1 = (TierLogSegment)segmentsBeforeClearing.apply(i);
            TierLogSegment seg2 = (TierLogSegment)segmentsAfterClearing.apply(i);
            Assertions.assertEquals((long)seg1.baseOffset(), (long)seg2.baseOffset());
            Assertions.assertEquals((long)seg1.endOffset(), (long)seg2.endOffset());
            Assertions.assertNotEquals((Object)seg1.objectId(), (Object)seg2.objectId());
        });
        long endOffset = tierPartitionState.endOffset();
        this.produceRecords(nBatches, recordsPerBatch);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$testClearAllTierData$4(endOffset, tierPartitionState)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"timeout waiting for endOffset to advance after tiered partition has recovered and more records produced");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClearAllTierDataForNonCompactedTopic(String quorum) {
        this.testClearAllTierData(false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClearAllTierDataForCompactedTopic(String quorum) {
        this.testClearAllTierData(true);
    }

    private void produceRecords(int nBatches, int recordsPerBatch) {
        try (KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());){
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nBatches).foreach((Function1 & Serializable)b -> TierIntegrationEndToEndTest.$anonfun$produceRecords$1(this, recordsPerBatch, producer, BoxesRunTime.unboxToInt((Object)b)));
        }
    }

    private int getLeaderForTopicPartition(TopicPartition topicPartition, scala.collection.immutable.Map<Object, Object> partitionToLeaderMap) {
        return BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
    }

    private void waitUntilSegmentsTiered(int minNumSegments, scala.collection.immutable.Map<Object, Object> partitionToLeaderMap) {
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierIntegrationEndToEndTest.$anonfun$waitUntilSegmentsTiered$1(this, partitionToLeaderMap, minNumSegments, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void simulateRetention(scala.collection.immutable.Map<Object, Object> partitionToLeaderMap) {
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierIntegrationEndToEndTest.$anonfun$simulateRetention$1(this, partitionToLeaderMap, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void consumeAndValidateTierFetch(scala.collection.immutable.Map<Object, Object> partitionToLeaderMap, int nBatches, int recordsPerBatch) {
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch, false);
    }

    /*
     * WARNING - void declaration
     */
    private void consumeAndValidateTierFetch(scala.collection.immutable.Map<Object, Object> partitionToLeaderMap, int nBatches, int recordsPerBatch, boolean isCompact) {
        void var33_29;
        SeqOps seqOps;
        void var19_19;
        void var21_20;
        List memoryTrackerMetrics;
        MBeanServer mBeanServer;
        block21: {
            List list;
            block20: {
                void var29_26;
                SeqOps seqOps2;
                block19: {
                    List list2;
                    block18: {
                        void var25_23;
                        SeqOps seqOps3;
                        block17: {
                            List list3;
                            block16: {
                                SeqOps seqOps4;
                                block15: {
                                    List list4;
                                    block14: {
                                        TopicPartition topicPartition = (TopicPartition)this.topicPartitions().head();
                                        KafkaConsumer consumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
                                        java.util.List<TopicPartition> partitions = Collections.singletonList(topicPartition);
                                        consumer.assign(partitions);
                                        consumer.seekToBeginning(partitions);
                                        ArrayList valuesRead = new ArrayList();
                                        ArrayList timestampsOffsets = new ArrayList();
                                        ConsumerRecords records = consumer.poll(Duration.ofMillis(1000L));
                                        do {
                                            records.forEach((Consumer)new Consumer<ConsumerRecord<String, String>>(null, valuesRead, timestampsOffsets){
                                                private final ArrayList valuesRead$1;
                                                private final ArrayList timestampsOffsets$1;

                                                public Consumer<ConsumerRecord<String, String>> andThen(Consumer<? super ConsumerRecord<String, String>> x$1) {
                                                    return Consumer.super.andThen(x$1);
                                                }

                                                public void accept(ConsumerRecord<String, String> r) {
                                                    this.valuesRead$1.add(BoxesRunTime.boxToInteger((int)Integer.parseInt((String)r.value())));
                                                    this.timestampsOffsets$1.add(new Tuple2.mcJJ.sp(r.timestamp(), r.offset()));
                                                }
                                                {
                                                    this.valuesRead$1 = valuesRead$1;
                                                    this.timestampsOffsets$1 = timestampsOffsets$1;
                                                }
                                            });
                                        } while (!(records = consumer.poll(Duration.ofMillis(1000L))).isEmpty());
                                        if (!isCompact) {
                                            Assertions.assertEquals(new ArrayList(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Range().apply(0, nBatches * recordsPerBatch)).asJava()), valuesRead);
                                            CollectionConverters$.MODULE$.ListHasAsScala(timestampsOffsets).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$4 -> {
                                                TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$2(this, timestampsOffsets, topicPartition, consumer, x$4);
                                                return BoxedUnit.UNIT;
                                            });
                                            this.assertTimestampForOffsetLookupCorrect(topicPartition, consumer, 0L, 0L);
                                            this.assertTimestampForOffsetLookupMissing(topicPartition, consumer, Long.MAX_VALUE);
                                        }
                                        mBeanServer = ManagementFactory.getPlatformMBeanServer();
                                        int partitionsInErrorDuringArchivalCount = BoxesRunTime.unboxToInt((Object)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=NumPartitionsInErrorDuringArchival"), new String[]{"Value"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToInteger((int)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$4(attr)))).head());
                                        Assertions.assertEquals((int)0, (int)partitionsInErrorDuringArchivalCount, (String)"tier archiver shows partitions in error state during archival");
                                        int partitionsInErrorDuringDeletionCount = BoxesRunTime.unboxToInt((Object)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=NumPartitionsInErrorDuringDeletion"), new String[]{"Value"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToInteger((int)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$5(attr)))).head());
                                        Assertions.assertEquals((int)0, (int)partitionsInErrorDuringDeletionCount, (String)"tier deletion process shows partitions in error state during deletion");
                                        memoryTrackerMetrics = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.server:type=TierFetcherMemoryTracker"), new String[]{"Leased", "PoolSize", "MaxLeaseLagMs"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$6(attr)))).toList();
                                        String bean = "kafka.server:type=TierFetcher";
                                        String[] attrs = new String[]{"BytesFetchedTotal", "OffsetCacheHitRatio"};
                                        list4 = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName(bean), attrs).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$7(attr)))).toList();
                                        if (list4 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps4 = package$.MODULE$.List().unapplySeq((SeqOps)list4))) break block14;
                                        new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4));
                                        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 2) == 0) break block15;
                                    }
                                    throw new MatchError((Object)list4);
                                }
                                double bytesFetchedTotal = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 0));
                                double offsetCacheHitRatio = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 1));
                                Assertions.assertEquals((double)1.0, (double)var21_20, (double)1.0E-6, (String)"offset cache should not have shown misses");
                                list3 = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.server:type=TierTopicConsumer"), new String[]{"HeartbeatMs"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$8(attr)))).toList();
                                if (list3 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = package$.MODULE$.List().unapplySeq((SeqOps)list3))) break block16;
                                new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3));
                                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1) == 0) break block17;
                            }
                            throw new MatchError((Object)list3);
                        }
                        double heartbeat = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0));
                        Assertions.assertTrue((var25_23 < (double)2000 ? 1 : 0) != 0, (String)"tier topic consumer heartbeat is alive");
                        list2 = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=HeartbeatMs"), new String[]{"Value"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToLong((long)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$9(attr)))).toList();
                        if (list2 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.List().unapplySeq((SeqOps)list2))) break block18;
                        new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2));
                        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0) break block19;
                    }
                    throw new MatchError((Object)list2);
                }
                long tierTasksHeartbeat = BoxesRunTime.unboxToLong((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0));
                Assertions.assertTrue((var29_26 < 10000L ? 1 : 0) != 0, (String)"tier tasks heartbeat is alive");
                Assertions.assertTrue((var19_19 > (double)100 ? 1 : 0) != 0, (String)"tier fetch metric shows no data fetched from tiered storage");
                list = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks.archive:type=TierArchiver,name=BytesPerSec"), new String[]{"MeanRate"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$10(attr)))).toList();
                if (list == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list))) break block20;
                new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) break block21;
            }
            throw new MatchError((Object)list);
        }
        double meanArchiveRate = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0));
        Assertions.assertTrue((var33_29 > (double)100 ? 1 : 0) != 0, (String)"tier archiver mean rate shows no data uploaded to tiered storage");
        Buffer partitionsStatusCounts = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.server:type=TierTopicConsumer"), new String[]{"ImmigratingPartitions", "CatchupConsumerPartitions", "PrimaryConsumerPartitions", "ErrorPartitions", "NumListeners", "MaxListeningMs"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$11(attr)));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 1.0, 0.0, 0.0, 0.0})), (Object)partitionsStatusCounts, (String)"tier topic manager fully immigrated the partition and metric works");
        int partitionsInErrorCount = BoxesRunTime.unboxToInt((Object)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=NumPartitionsInError"), new String[]{"Value"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToInteger((int)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$12(attr)))).head());
        Assertions.assertEquals((int)0, (int)partitionsInErrorCount, (String)"tier archiver shows no partitions in error state");
        Assertions.assertEquals((double)1.0, (double)var21_20, (double)1.0E-6, (String)"offset cache should not have shown misses");
        Assertions.assertTrue((var19_19 > (double)100 ? 1 : 0) != 0, (String)new StringBuilder(61).append("tier fetch metric shows no data fetched from tiered storage: ").append((double)var19_19).toString());
        Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)memoryTrackerMetrics.head()), (double)0.0, (double)0.0, (String)"expected all leased memory to be returned to the MemoryTracker");
        Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)memoryTrackerMetrics.apply(1)), (double)1048576.0, (double)0.0, (String)"expected all leased memory to be returned to the MemoryTracker");
        Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)memoryTrackerMetrics.last()), (double)0.0, (double)0.0, (String)"expected no value for oldestLease, since all leases should be reclaimed");
        this.brokers().foreach((Function1 & Serializable)server -> {
            TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$13(server);
            return BoxedUnit.UNIT;
        });
    }

    private File writeRecoverConfig(java.util.Map<String, Object> tierClientConfig, File workingDir, File brokerWorkdirList) {
        File recoveryConfFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        Properties props = Utils.mkProperties((java.util.Map)new HashMap<String, String>(this, workingDir, brokerWorkdirList){
            {
                this.put(KafkaConfig$.MODULE$.TierBackendProp(), "Mock");
                this.put("bootstrap.servers", $outer.bootstrapServers($outer.bootstrapServers$default$1()));
                this.put("confluent.tier.recovery.working.dir", workingDir$1.getAbsolutePath());
                this.put("confluent.tier.recovery.validate", "false");
                this.put("confluent.tier.recovery.materialize", "true");
                this.put("confluent.tier.recovery.dump.events", "false");
                this.put("confluent.tier.recovery.broker.workdir.list", brokerWorkdirList$1.getAbsolutePath());
            }
        });
        props.putAll(tierClientConfig);
        props.store(new PrintWriter(recoveryConfFile), "");
        return recoveryConfFile;
    }

    private void assertTimestampForOffsetLookupCorrect(TopicPartition topicPartition, KafkaConsumer<String, String> consumer, long timestamp, long expectedOffset) {
        HashMap<TopicPartition, Long> timestampsToSearch = new HashMap<TopicPartition, Long>();
        timestampsToSearch.put(topicPartition, Predef$.MODULE$.long2Long(timestamp));
        Assertions.assertEquals((long)expectedOffset, (long)((OffsetAndTimestamp)consumer.offsetsForTimes(timestampsToSearch).get(topicPartition)).offset(), (String)"timestamp should match offset read");
    }

    private void assertTimestampForOffsetLookupMissing(TopicPartition topicPartition, KafkaConsumer<String, String> consumer, long timestamp) {
        HashMap<TopicPartition, Long> timestampsToSearch = new HashMap<TopicPartition, Long>();
        timestampsToSearch.put(topicPartition, Predef$.MODULE$.long2Long(timestamp));
        Assertions.assertEquals(null, consumer.offsetsForTimes(timestampsToSearch).get(topicPartition), (String)"offset should not be returned");
    }

    private scala.collection.immutable.Map<Object, Object> createTopic(String topic, int numPartitions, int replicationFactor, Properties topicConfig, Properties adminClientConfig) {
        scala.collection.immutable.Map map;
        try (Admin resource_resource = this.createAdminClient(this.listenerName(), adminClientConfig);){
            map = TierIntegrationEndToEndTest.$anonfun$createTopic$1(this, topic, numPartitions, replicationFactor, topicConfig, resource_resource);
        }
        return map;
    }

    public static final /* synthetic */ TopicPartition $anonfun$topicPartitions$1(TierIntegrationEndToEndTest $this, int p) {
        return new TopicPartition($this.topic(), p);
    }

    public static final /* synthetic */ boolean $anonfun$validateFenceToolResults$1(TierPartitionState tierPartitionState$1, MergedLog log$1) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$1.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.FROZEN_LOG_START_OFFSET;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && log$1.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$validateFenceToolResults$2() {
        return "timeout waiting for partition to be transitioned to the required status";
    }

    public static final /* synthetic */ boolean $anonfun$validateFenceToolResults$3(TierPartitionState tierPartitionState$1, MergedLog log$1) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$1.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ERROR;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$1.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$validateFenceToolResults$4() {
        return "timeout waiting for partition to be transitioned to the required status";
    }

    public static final /* synthetic */ boolean $anonfun$validateRestoreToolsResults$1(TierPartitionState tierPartitionState$2, MergedLog log$2) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$2.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.FROZEN_LOG_START_OFFSET;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && log$2.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$validateRestoreToolsResults$2() {
        return "log and/or tier partition state is in unexpected status";
    }

    public static final /* synthetic */ boolean $anonfun$validateRestoreToolsResults$3(TierPartitionState tierPartitionState$2, MergedLog log$2) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$2.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$2.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$validateRestoreToolsResults$4() {
        return "log and/or tier partition state is in unexpected status";
    }

    public static final /* synthetic */ boolean $anonfun$testArchiveAndTierFetchFenceAndRecovery$1(FileTierPartitionState tierPartitionState$3, AbstractLog log$3) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$3.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.FROZEN_LOG_START_OFFSET;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && log$3.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$testArchiveAndTierFetchFenceAndRecovery$2() {
        return "log and/or tier partition state is in unexpected status";
    }

    public static final /* synthetic */ boolean $anonfun$testArchiveAndTierFetchFenceAndRecovery$3(FileTierPartitionState tierPartitionState$3, AbstractLog log$3) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$3.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$3.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$testArchiveAndTierFetchFenceAndRecovery$4() {
        return "log and/or tier partition state is in unexpected status";
    }

    public static final /* synthetic */ boolean $anonfun$testArchiveAndTierFetchFenceAndRecovery$5(FileTierPartitionState tierPartitionState$3, AbstractLog log$3) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$3.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$3.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$testArchiveAndTierFetchFenceAndRecovery$6() {
        return "timed out waiting for partition to be restored to ONLINE status";
    }

    public static final /* synthetic */ boolean $anonfun$testArchiveAndTierFetchFenceAndRecovery$7(long endOffset$1, FileTierPartitionState tierPartitionState$3) {
        return endOffset$1 < tierPartitionState$3.endOffset();
    }

    public static final /* synthetic */ String $anonfun$testArchiveAndTierFetchFenceAndRecovery$8() {
        return "timeout waiting for endOffset to advance after tiered partition has recovered and more records produced";
    }

    public static final /* synthetic */ boolean $anonfun$testClearAllTierData$1(FileTierPartitionState tierPartitionState$4, AbstractLog log$4) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$4.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$4.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$testClearAllTierData$2() {
        return "timed out waiting for partition to be restored to ONLINE status";
    }

    public static final /* synthetic */ boolean $anonfun$testClearAllTierData$4(long endOffset$2, FileTierPartitionState tierPartitionState$4) {
        return endOffset$2 < tierPartitionState$4.endOffset();
    }

    public static final /* synthetic */ String $anonfun$testClearAllTierData$5() {
        return "timeout waiting for endOffset to advance after tiered partition has recovered and more records produced";
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceRecords$2(TierIntegrationEndToEndTest $this, int recordsPerBatch$1, int b$1, long timestamp$1, int i) {
        String k = TestUtils.randomString((int)3);
        int m = recordsPerBatch$1 * b$1 + i;
        return new ProducerRecord($this.topic(), null, Predef$.MODULE$.long2Long(timestamp$1), (Object)k.getBytes(StandardCharsets.UTF_8), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)m)).getBytes(StandardCharsets.UTF_8));
    }

    public static final /* synthetic */ IndexedSeq $anonfun$produceRecords$1(TierIntegrationEndToEndTest $this, int recordsPerBatch$1, KafkaProducer producer$1, int b) {
        long timestamp = System.currentTimeMillis();
        return (IndexedSeq)((IndexedSeqOps)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), recordsPerBatch$1).map((Function1 & Serializable)i -> TierIntegrationEndToEndTest.$anonfun$produceRecords$2($this, recordsPerBatch$1, b, timestamp, BoxesRunTime.unboxToInt((Object)i))).map((Function1 & Serializable)x$1 -> producer$1.send(x$1))).map((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get(10L, TimeUnit.SECONDS));
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilSegmentsTiered$2(TierPartitionState tierPartitionState$5, int minNumSegments$1) {
        return tierPartitionState$5.numSegments() > minNumSegments$1 && tierPartitionState$5.endOffset() == tierPartitionState$5.committedEndOffset();
    }

    public static final /* synthetic */ String $anonfun$waitUntilSegmentsTiered$3(int minNumSegments$1) {
        return new StringBuilder(61).append("timeout waiting for at least ").append(minNumSegments$1).append(" to be archived and materialized").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTiered$1(TierIntegrationEndToEndTest $this, scala.collection.immutable.Map partitionToLeaderMap$1, int minNumSegments$1, TopicPartition tp) {
        int leaderId = $this.getLeaderForTopicPartition(tp, (scala.collection.immutable.Map<Object, Object>)partitionToLeaderMap$1);
        LogManager qual$1 = ((KafkaBroker)$this.brokerForId(leaderId).get()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        TierPartitionState tierPartitionState = ((AbstractLog)qual$1.getLog(tp, x$2).get()).tierPartitionState();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$waitUntilSegmentsTiered$2(tierPartitionState, minNumSegments$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$waitUntilSegmentsTiered$3(minNumSegments$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$simulateRetention$1(TierIntegrationEndToEndTest $this, scala.collection.immutable.Map partitionToLeaderMap$2, TopicPartition tp) {
        boolean x$2;
        int leaderId = $this.getLeaderForTopicPartition(tp, (scala.collection.immutable.Map<Object, Object>)partitionToLeaderMap$2);
        LogManager qual$1 = ((KafkaBroker)$this.brokerForId(leaderId).get()).replicaManager().logManager();
        Assertions.assertTrue((((AbstractLog)qual$1.getLog(tp, x$2 = qual$1.getLog$default$2()).get()).deleteOldSegments() > 0 ? 1 : 0) != 0, (String)"tiered segments should have been deleted");
    }

    public static final /* synthetic */ boolean $anonfun$consumeAndValidateTierFetch$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$consumeAndValidateTierFetch$3(long timestamp$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            return x0$1._1$mcJ$sp() >= timestamp$2;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$consumeAndValidateTierFetch$2(TierIntegrationEndToEndTest $this, ArrayList timestampsOffsets$1, TopicPartition topicPartition$1, KafkaConsumer consumer$1, Tuple2 x$4) {
        if (x$4 != null) {
            long timestamp = x$4._1$mcJ$sp();
            long expectedOffset = ((Tuple2)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)timestampsOffsets$1).asScala().find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$3(timestamp, x0$1))).get())._2$mcJ$sp();
            $this.assertTimestampForOffsetLookupCorrect(topicPartition$1, (KafkaConsumer<String, String>)consumer$1, timestamp, expectedOffset);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$consumeAndValidateTierFetch$4(Attribute attr) {
        return BoxesRunTime.unboxToInt((Object)attr.getValue());
    }

    public static final /* synthetic */ int $anonfun$consumeAndValidateTierFetch$5(Attribute attr) {
        return BoxesRunTime.unboxToInt((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$6(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$7(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$8(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ long $anonfun$consumeAndValidateTierFetch$9(Attribute attr) {
        return BoxesRunTime.unboxToLong((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$10(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$11(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ int $anonfun$consumeAndValidateTierFetch$12(Attribute attr) {
        return BoxesRunTime.unboxToInt((Object)attr.getValue());
    }

    public static final /* synthetic */ void $anonfun$consumeAndValidateTierFetch$13(KafkaBroker server) {
        MemoryTracker memoryTracker = ((TierFetcher)server.tierFetcherOpt().get()).memoryTracker();
        Assertions.assertEquals((long)0L, (long)memoryTracker.leased(), (String)new StringBuilder(54).append("expected leased TierFetcher memory for broker ").append(server.config().brokerId()).append(" to be 0").toString());
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createTopic$1(TierIntegrationEndToEndTest $this, String topic$1, int numPartitions$1, int replicationFactor$1, Properties topicConfig$1, Admin admin) {
        Buffer<KafkaBroker> x$6 = $this.brokers();
        Map x$7 = (Map)Map$.MODULE$.empty();
        return TestUtils$.MODULE$.createTopicWithAdmin(admin, topic$1, x$6, numPartitions$1, replicationFactor$1, (Map<Object, Seq<Object>>)x$7, topicConfig$1);
    }

    public TierIntegrationEndToEndTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerFeatureEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerDualCompactionValidationPercentProp(), "100");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerCompactMinEfficiencyProp(), "0.001");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "3");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), Integer.toString(Integer.MAX_VALUE));
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFetcherMemoryPoolSizeBytesProp(), Integer.toString(0x100000));
        this.serverConfig().put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCleanupEnableProp(), Boolean.toString(true));
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCleanupIntervalMsProp(), "0");
        this.configureMock();
        this.topic = "test_topic";
        this.partitions = 1;
        this.exited = new AtomicBoolean(false);
    }
}

