/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.log.AbstractLog;
import kafka.log.LogSegment;
import kafka.log.MergedLog;
import kafka.log.TierLogSegment;
import kafka.server.KafkaBroker;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.FileTierPartitionIterator;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.compaction.TierLogToClean;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class TierTestUtils$ {
    public static final TierTestUtils$ MODULE$ = new TierTestUtils$();
    private static OffsetAndEpoch _tierTopicOffsetAndEpoch = new OffsetAndEpoch(-1L, Optional.empty());

    private OffsetAndEpoch _tierTopicOffsetAndEpoch() {
        return _tierTopicOffsetAndEpoch;
    }

    private void _tierTopicOffsetAndEpoch_$eq(OffsetAndEpoch x$1) {
        _tierTopicOffsetAndEpoch = x$1;
    }

    public synchronized OffsetAndEpoch currentOffsetAndEpoch() {
        return this._tierTopicOffsetAndEpoch();
    }

    public synchronized void setTierTopicOffsetAndEpoch(OffsetAndEpoch offsetAndEpoch) {
        this._tierTopicOffsetAndEpoch_$eq(offsetAndEpoch);
    }

    public synchronized OffsetAndEpoch nextTierTopicOffsetAndEpoch() {
        OffsetAndEpoch nextOffsetAndEpoch = new OffsetAndEpoch(this._tierTopicOffsetAndEpoch().offset() + 1L, this._tierTopicOffsetAndEpoch().epoch());
        this._tierTopicOffsetAndEpoch_$eq(nextOffsetAndEpoch);
        return this._tierTopicOffsetAndEpoch();
    }

    public synchronized void initTierTopicOffset() {
        this._tierTopicOffsetAndEpoch_$eq(new OffsetAndEpoch(-1L, Optional.empty()));
    }

    public void ensureTierable(AbstractLog log, long tierEndOffset, TopicPartition topicPartition, int leaderEpoch) {
        LogSegment activeSegment = log.activeSegment();
        if (activeSegment.baseOffset() <= tierEndOffset && activeSegment.readNextOffset() > tierEndOffset) {
            log.roll((Option)None$.MODULE$, log.roll$default$2());
        }
        if (tierEndOffset == log.logEndOffset()) {
            log.appendAsFollower(this.createRecords(5, topicPartition, log.logEndOffset(), leaderEpoch));
        }
        log.flush(false);
        if (log.highWatermark() <= tierEndOffset) {
            log.updateHighWatermark(tierEndOffset + 1L);
        }
        Assertions.assertTrue((BoxesRunTime.unboxToLong((Object)log.firstUnstableOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> Long.MAX_VALUE)) > tierEndOffset ? 1 : 0) != 0);
    }

    public int ensureTierable$default$4() {
        return 0;
    }

    public MemoryRecords createRecords(int n, TopicPartition partition, long baseOffset, int leaderEpoch) {
        IndexedSeq recList = package$.MODULE$.Range().apply(0, n).map((Function1 & Serializable)x$1 -> TierTestUtils$.$anonfun$createRecords$1(BoxesRunTime.unboxToInt((Object)x$1)));
        byte x$3 = 2;
        CompressionType x$4 = CompressionType.NONE;
        long x$5 = -1L;
        short x$6 = -1;
        int x$7 = -1;
        int x$8 = -1;
        MemoryRecords records = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)recList, x$3, x$4, x$5, x$6, x$7, baseOffset, x$8);
        ByteBuffer filtered = ByteBuffer.allocate(100 * n);
        CollectionConverters$.MODULE$.IterableHasAsScala(records.batches()).asScala().foreach((Function1 & Serializable)x$2 -> {
            x$2.setPartitionLeaderEpoch(leaderEpoch);
            return BoxedUnit.UNIT;
        });
        records.filterTo(partition, new MemoryRecords.RecordFilter(){

            public MemoryRecords.RecordFilter.BatchRetentionResult checkBatchRetention(RecordBatch batch) {
                return new MemoryRecords.RecordFilter.BatchRetentionResult(MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY, false);
            }

            public boolean shouldRetainRecord(RecordBatch recordBatch, Record record) {
                return true;
            }
        }, filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
        filtered.flip();
        return new MemoryRecords(filtered);
    }

    /*
     * WARNING - void declaration
     */
    public void awaitTierTopicPartition(KafkaBroker broker, Integer partition) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTestUtils$.$anonfun$awaitTierTopicPartition$1(broker, partition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for replicas to join ISR");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public CompletableFuture<TierPartitionState.AppendResult> uploadWithMetadata(TierTopicManager tierTopicManager, TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, long startOffset, long endOffset, long maxTimestamp, long firstBatchTimestamp, int size, boolean hasAbortedTxnIndex, boolean hasEpochState, boolean hasProducerState, OffsetAndEpoch validity, TierObjectStore.OpaqueData opaqueData) {
        TierPartitionState.AppendResult result;
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, tierEpoch, objectId, startOffset, endOffset, maxTimestamp, firstBatchTimestamp, size, hasEpochState, hasAbortedTxnIndex, hasProducerState, TierUploadType.Archive, validity, opaqueData);
        TierPartitionState.AppendResult appendResult = result = (TierPartitionState.AppendResult)tierTopicManager.addMetadata((AbstractTierMetadata)uploadInitiate).get();
        TierPartitionState.AppendResult appendResult2 = TierPartitionState.AppendResult.ACCEPTED;
        if (appendResult == null ? appendResult2 != null : !appendResult.equals(appendResult2)) {
            return CompletableFuture.completedFuture(result);
        }
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(uploadInitiate);
        return tierTopicManager.addMetadata((AbstractTierMetadata)uploadComplete);
    }

    public TierPartitionState.AppendResult uploadWithMetadata(TierPartitionState tierPartitionState, TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, long startOffset, long endOffset, long maxTimestamp, long firstBatchTimestamp, int size, boolean hasAbortedTxnIndex, boolean hasEpochState, boolean hasProducerState, OffsetAndEpoch validity, TierObjectStore.OpaqueData opaqueData) {
        TierPartitionState.AppendResult result;
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, tierEpoch, objectId, startOffset, endOffset, maxTimestamp, firstBatchTimestamp, size, hasEpochState, hasAbortedTxnIndex, hasProducerState, TierUploadType.Archive, validity, opaqueData);
        TierPartitionState.AppendResult appendResult = result = tierPartitionState.append((AbstractTierMetadata)uploadInitiate, this.nextTierTopicOffsetAndEpoch());
        TierPartitionState.AppendResult appendResult2 = TierPartitionState.AppendResult.ACCEPTED;
        if (appendResult == null ? appendResult2 != null : !appendResult.equals(appendResult2)) {
            return result;
        }
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(uploadInitiate);
        return tierPartitionState.append((AbstractTierMetadata)uploadComplete, this.nextTierTopicOffsetAndEpoch());
    }

    public long uploadWithMetadata$default$7() {
        return 0L;
    }

    public long uploadWithMetadata$default$8() {
        return 0L;
    }

    public int uploadWithMetadata$default$9() {
        return 100;
    }

    public boolean uploadWithMetadata$default$10() {
        return false;
    }

    public boolean uploadWithMetadata$default$11() {
        return false;
    }

    public boolean uploadWithMetadata$default$12() {
        return false;
    }

    public OffsetAndEpoch uploadWithMetadata$default$13() {
        return OffsetAndEpoch.EMPTY;
    }

    public TierObjectStore.OpaqueData uploadWithMetadata$default$14() {
        return TierObjectStore.OpaqueData.ZEROED;
    }

    public java.util.Set<UUID> deletedSegments(FileTierPartitionState state, long maxStateChangeTimestampEligibleForCleanup) {
        Optional iteratorOpt = FileTierPartitionState.iterator((TopicPartition)((TopicIdPartition)state.topicIdPartition().get()).topicPartition(), (CheckedFileIO)state.checkedFileIO());
        if (!iteratorOpt.isPresent()) {
            throw new IllegalStateException(new StringBuilder(61).append("Attempted to get iterator for invalid FileTierPartitionState ").append(this).toString());
        }
        return CollectionConverters$.MODULE$.SetHasAsJava((Set)CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)iteratorOpt.get()).asScala().filter((Function1 & Serializable)metadata -> BoxesRunTime.boxToBoolean((boolean)TierTestUtils$.$anonfun$deletedSegments$1(maxStateChangeTimestampEligibleForCleanup, metadata))).map((Function1 & Serializable)x$3 -> x$3.objectId()).toSet()).asJava();
    }

    public long deletedSegments$default$2() {
        return -1L;
    }

    public void verifyFtpsEntries(FileTierPartitionState state, List<TierLogSegment> nonDeletedSegmentsToCompare, scala.collection.immutable.Set<UUID> deletedSegmentIDsToCompare, boolean hasStateChangeTimestamp, long expectedStateChangeTs) {
        if (nonDeletedSegmentsToCompare != null) {
            List segments = CollectionConverters$.MODULE$.IteratorHasAsScala(state.segments()).asScala().toList();
            Assertions.assertEquals((int)nonDeletedSegmentsToCompare.size(), (int)segments.size());
            segments.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                TierLogSegment segmentToCompare = (TierLogSegment)nonDeletedSegmentsToCompare.apply(i);
                TierLogSegment segment = (TierLogSegment)segments.apply(i);
                Assertions.assertEquals((long)segmentToCompare.baseOffset(), (long)segment.baseOffset());
                Assertions.assertEquals((long)segmentToCompare.objectBaseOffset(), (long)segment.objectBaseOffset());
                Assertions.assertEquals((long)segmentToCompare.endOffset(), (long)segment.endOffset());
                Assertions.assertEquals((Object)segmentToCompare.objectId(), (Object)segment.objectId());
                Assertions.assertEquals((long)segmentToCompare.firstBatchTimestamp(), (long)segment.firstBatchTimestamp());
                Assertions.assertEquals((long)segmentToCompare.maxTimestamp(), (long)segment.maxTimestamp());
            });
        }
        FileTierPartitionIterator tierObjectMetadataIterator = (FileTierPartitionIterator)FileTierPartitionState.iterator((TopicPartition)state.topicPartition(), (CheckedFileIO)state.checkedFileIO()).get();
        ArrayList<UUID> deletedSegmentUUID = new ArrayList<UUID>();
        while (tierObjectMetadataIterator.hasNext()) {
            TierObjectMetadata tierObjectMetadata = (TierObjectMetadata)tierObjectMetadataIterator.next();
            if (!hasStateChangeTimestamp) {
                Assertions.assertEquals((long)-1L, (long)tierObjectMetadata.stateChangeTimestamp());
            } else {
                TierObjectMetadata.State state2 = tierObjectMetadata.state();
                TierObjectMetadata.State state3 = TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE;
                if (!(state2 != null ? !state2.equals(state3) : state3 != null)) {
                    if (expectedStateChangeTs > 0L) {
                        Assertions.assertEquals((long)expectedStateChangeTs, (long)tierObjectMetadata.stateChangeTimestamp());
                    }
                } else {
                    Assertions.assertEquals((long)Long.MAX_VALUE, (long)tierObjectMetadata.stateChangeTimestamp());
                }
            }
            TierObjectMetadata.State state4 = tierObjectMetadata.state();
            TierObjectMetadata.State state5 = TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE;
            if (state4 != null ? !state4.equals(state5) : state5 != null) continue;
            deletedSegmentUUID.add(tierObjectMetadata.objectId());
        }
        if (deletedSegmentIDsToCompare != null) {
            Assertions.assertEquals((int)deletedSegmentIDsToCompare.size(), (int)deletedSegmentUUID.size());
            CollectionConverters$.MODULE$.ListHasAsScala(deletedSegmentUUID).asScala().foreach((Function1 & Serializable)uuid -> {
                TierTestUtils$.$anonfun$verifyFtpsEntries$2(deletedSegmentIDsToCompare, uuid);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public TopicIdPartition randomTopicIdPartition(int partition) {
        UUID topicId = UUID.randomUUID();
        String topicName = TestUtils$.MODULE$.tempTopic();
        return new TopicIdPartition(topicName, topicId, partition);
    }

    public scala.collection.immutable.Set<TopicIdPartition> randomTopicIdPartitions(int numTopicUpperBound, int numPartitionUpperBound) {
        ObjectRef topicPartitions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        int numTopics = TestUtils$.MODULE$.random().nextInt(numTopicUpperBound) + 1;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numTopics).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
            int numPartitions = TestUtils$.MODULE$.random().nextInt(numPartitionUpperBound) + 1;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> {
                topicPartitions$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)topicPartitions$1.elem).$plus((Object)MODULE$.randomTopicIdPartition(partition));
            });
        });
        return (scala.collection.immutable.Set)topicPartitions.elem;
    }

    public TierLogToClean tierLogToClean(TopicIdPartition topicIdPartition, Time time, double efficiencyRatio, double minEfficiencyRatio, double cleanableRatio, double minCleanableRatio, long earliestFirstBatchTimestamp, long compactionLag, long maxCompactionLag) {
        MergedLog log = (MergedLog)Mockito.mock(MergedLog.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("confluent.tier.enable", "true");
        map.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(minEfficiencyRatio));
        map.put("confluent.tier.cleaner.min.cleanable.ratio", Double.toString(minCleanableRatio));
        map.put("min.compaction.lag.ms", Long.toString(compactionLag));
        map.put("max.compaction.lag.ms", Long.toString(maxCompactionLag));
        LogConfig logConfig = new LogConfig(map);
        Mockito.when((Object)log.config()).thenReturn((Object)logConfig);
        Mockito.when((Object)log.firstOffsetLockedFromDeletion()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.tierableLogSegments()).thenAnswer(x$5 -> (Iterable)package$.MODULE$.Iterable().apply((Seq)Nil$.MODULE$));
        return new TierLogToClean((Option)new Some((Object)topicIdPartition), (AbstractLog)log, time, earliestFirstBatchTimestamp, 10L, 20L, 0L, 10L, 0L, 0L, cleanableRatio, efficiencyRatio, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0))));
    }

    public long tierLogToClean$default$7() {
        return Long.MIN_VALUE;
    }

    public long tierLogToClean$default$8() {
        return 0L;
    }

    public long tierLogToClean$default$9() {
        return Long.MAX_VALUE;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$createRecords$1(int x$1) {
        return new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes());
    }

    public static final /* synthetic */ boolean $anonfun$awaitTierTopicPartition$1(KafkaBroker broker$1, Integer partition$1) {
        return broker$1.replicaManager().onlinePartition(new TopicPartition("_confluent-tier-state", Predef$.MODULE$.Integer2int(partition$1))).isDefined();
    }

    public static final /* synthetic */ String $anonfun$awaitTierTopicPartition$2() {
        return "Timed out waiting for replicas to join ISR";
    }

    public static final /* synthetic */ boolean $anonfun$deletedSegments$1(long maxStateChangeTimestampEligibleForCleanup$1, TierObjectMetadata metadata) {
        TierObjectMetadata.State state = metadata.state();
        TierObjectMetadata.State state2 = TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE;
        if (!(state != null ? !state.equals(state2) : state2 != null)) {
            if (maxStateChangeTimestampEligibleForCleanup$1 == -1L || metadata.stateChangeTimestamp() > maxStateChangeTimestampEligibleForCleanup$1) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$verifyFtpsEntries$2(scala.collection.immutable.Set deletedSegmentIDsToCompare$1, UUID uuid) {
        Assertions.assertTrue((boolean)deletedSegmentIDsToCompare$1.contains((Object)uuid));
    }

    private TierTestUtils$() {
    }
}

